#!/usr/bin/python
# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import socket, time, sys

class FloodManager:
	def __init__ (self):
		self.last_messages = {}
		self.floodtime = 0
	
	def sent_msg (self, msg):
		self.last_messages[time.time()] = len(msg)
	
	def can_send (self, msg):
		min_time = time.time() - 10
		for send_time in self.last_messages.keys():
			if send_time < min_time:
				del self.last_messages[send_time]
		total_size = len(msg)
		for msg_len in self.last_messages.values(): total_size += msg_len
		if total_size > 2000 or len(self.last_messages.values()) > 15:
			return False
		else:
			return True
	
	def flood(self):
		self.floodtime = time.time()
	def flooding(self):
		return not(self.floodtime + 5 < time.time())

class IRCClient:
	def __init__ (self, host, port, nick, ident, realname):
		for var in ["host", "port", "nick", "ident", "realname"]:
			setattr(self, var, locals()[var])
		self.sock = socket.socket()
		self.versionString = "modularbot"
		self.floodmgr = FloodManager()
	
	def IRC_send (self, txt):
		self.sock.send("%s\r\n" % txt)
	
	def connect (self):
		self.sock.connect((self.host, self.port))
		self.IRC_send("NICK %s" % self.nick)
		self.IRC_send("USER %s %s bla :%s" % (self.ident, self.host, self.realname))
		self.signedOn()
	
	def join (self, channel):
		self.IRC_send("JOIN %s" % channel)
		self.joined(channel)
	
	def leave (self, channel, reason):
		self.IRC_send("PART %s :%s" % (channel, reason))
	
	def privmsg (self, user, channel, msg):
		pass
	
	def say (self, channel, msg):
		if self.floodmgr.flooding():
			return
		if self.floodmgr.can_send(msg):
			self.IRC_send("PRIVMSG %s :%s" % (channel, msg))
			self.floodmgr.sent_msg(msg)
		else:
			self.IRC_send("PRIVMSG %s :Risk of excess flood..." % channel)
			self.floodmgr.flood()
	
	def CTCP_PING (self, user, msg):
		self.notice(user[:user.find("!")], msg)
	
	def CTCP_VERSION (self, user, msg):
		print "CTCP VERSION"
		self.notice(user[:user.find("!")], msg.replace("VERSION", "VERSION %s" % self.versionString))
	
	def notice (self, channel, msg):
		if self.floodmgr.flooding():
			return
		if self.floodmgr.can_send(msg):
			self.IRC_send("NOTICE %s :%s" % (channel, msg))
			self.floodmgr.sent_msg(msg)
		else:
			self.IRC_send("NOTICE %s :Risk of excess flood..." % channel)
			self.floodmgr.flood()
	
	def PRIVMSG (self, line, line_splitted):
		channel = line_splitted[2]
		user = line_splitted[0][1:]
		msg = line[len(user) + len(channel) + len(line_splitted[1]) + 5:]
		if msg[0] == chr(1) and msg[-1] == chr(1):
			ctcp_cmd = msg[1:-1].split(" ", 1)[0]
			if hasattr(self, "CTCP_" + ctcp_cmd):
				getattr(self, "CTCP_" + ctcp_cmd)(user, msg)
			else:
				print "CTCP command %s not found" % ctcp_cmd
		else:
			self.privmsg(user, channel, msg)
	
	def KICK (self, line, line_splitted):
		channel = line_splitted[2]
		kicked = line_splitted[3]
		kicker = line_splitted[0][1:]
		msg = line[len(kicker) + len(channel) + len(line_splitted[1]) + len(kicked) + 6:]
		self.userKicked(kicked, channel, kicker, msg)
	
	def JOIN (self, line, line_splitted):
		channel = line_splitted[2][1:]
		user = line_splitted[0][1:]
		self.userJoined(user, channel)
	
	def NICK (self, line, line_splitted):
		oldname = line_splitted[0][1:]
		oldname = oldname[:oldname.find("!")]
		newname = line[line.rfind(":"):]
		self.userRenamed (oldname, newname)
	
	def PART (self, line, line_splitted):
		channel = line_splitted[2]
		user = line_splitted[0][1:]
		self.userLeft(user, channel)
	
	def MODE (self, line, line_splitted):
		# :PieD!n=Pierre@ALille-251-1-68-187.w82-127.abo.wanadoo.fr MODE #fnux +o Dictator5
		channel = line_splitted[2]
		user = line_splitted[0][1:line_splitted[0].find("!")]
		set = line_splitted[3].startswith("+")
		modes = line_splitted[3][1:]
		args = line[line.find(line_splitted[3]):]
		print line
		print line_splitted
		print (user, channel, set, modes, args)
		self.modeChanged(user, channel, set, modes, args)
	
	def run (self):
		readbuffer = ""
		while 1:
			readbuffer = readbuffer + self.sock.recv (1024)
			try:
				temp = readbuffer.split ("\n")
				readbuffer = temp.pop ()
				for line in temp:
					line = line.rstrip()
					print line
					line_splitted = line.split()
					if line_splitted[0] == "PING":
						self.IRC_send ("PONG %s" % line_splitted[1])
					else:
						if hasattr(self, line_splitted[1]):
							getattr(self, line_splitted[1])(line, line_splitted)
						else:
							try:
								cmd_number = int(line_splitted[1])
								self.numericAnswer(cmd_number, line.split(" ", 3)[-1])
							except ValueError:
								pass
							#print "Unknown IRC command !!!!"
			except:
				infos = sys.exc_info()
				sys.excepthook(infos[0], infos[1], infos[2])
	
	#EVENTS :
	def signedOn(self):
		pass
	
	def joined(self, channel):
		pass

	def userKicked(self, user, channel, kicker, reason):
		pass
	
	def userJoined(self, user, channel):
		pass
	
	def userRenamed(self, oldname, newname):
		pass

	def userLeft(self, user, channel):
		pass
	
	def numericAnswer(self, cmd_number, line):
		pass
