# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import base_logic, time, sys

class penduLogic(base_logic.Base):
	"""Implements a "pendu" game"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.end_game()
	
	def Call_startPendu (self, user, channel, message):
		"""Starts a game"""
		if self.word == "":
			self.word = message
		elif message.strip() == "":
			self.bot.say(channel, "Empty word ?")
		else:
			self.bot.say(channel, "Game already launched, please end it before")
	
	def end_game (self, channel = ""):
		if channel != "":
			self.bot.say(channel, "The word was : %s" % self.word)
		self.word = ""
		self.mistakes = 0
		self.said = []
	
	def Call_suggest (self, user, channel, message):
		"""Suggest a letter or a word"""
		if len(message) > 1:
			if len(message) == len(self.word):
				if message == self.word:
					self.bot.say(channel, "%s: congrats, you found it was %s" % (user, self.word))
				else:
					self.bot.say(channel, "%s: try again" % user)
					mistakes += 1
			else:
				self.bot.say(channel, "%s: you stupid ! Your proposition doesn't even have the right characters count !" % user)
				mistakes += 1
		elif len(message) == 0:
			self.bot.say(channel, "%s: empty suggestion ?" % user)
		else:
			if message in self.said:
				self.bot.say(channel, "%s: already submitted..." % user)
			elif message in self.word:
				self.bot.say(channel, "%s: right..." % user)
				self.said.append(message)
			else:
				self.bot.say(channel, "%s: wrong..." % user)
				self.said.append(message)
			result = ""
			for char in self.word:
				if char in self.said:
					result += char
				else:
					result += "-"
			if result == self.word:
				self.bot.say(channel, "Game won")
				self.end_game(channel)
			else:
				self.bot.say(channel, result)
		if self.mistakes > 10:
			self.bot.say(channel, "Game lost")
			self.end_game(channel)

	@admin
	def Call_endPendu (self, user, channel, message):
		"""Finish a game"""
		self.end_game(channel)