# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

def admin (func):
	func.is_admin = True
	return func

def return_string (func):
	func.returns = "string"
	return func

def return_list (func):
	func.returns = "list"
	return func

def return_dic (func):
	func.returns = "dic"
	return func

def threaded (func):
	func.threaded = True
	return func

def accept_list (func):
	func.accept_list = True
	return func

def conflict_with (conflict):
	def wrapper (func):
		func.conflict_with = conflict
		return func
	return wrapper

def core_hook (hookname):
	def wrapper (func):
		func.is_hook = True
		func.hook_name = hookname
		return func
	return wrapper
