# This file is part of ModularBot.
# Copyright (C) 2005 Pierre Ducroquet (pierre.linux59@wanadoo.fr)

# ModularBot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ModularBot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ModularBot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import base_logic

class todoLogic(base_logic.Base):
	"""Implements a TODO list"""
	def __init__(self, core):
		base_logic.Base.__init__(self, core)
		self.persistant["todos"] = [] #Contains tuples (user, message)
		
	def joinevent (self, user, channel):
		for todo in self.persistant["todos"]:
			if todo[0] == user:
				self.bot.notice(user, "TODO :" + todo[1])
		
	def Call_TODO (self, context, message):
		"""If called with an argument, TODO adds this argument as a new TODO item.
		If called without argument, TODO lists all the TODO items"""
		if message != "":
			self.persistant["todos"].append((context.user, message))
			self.save()
			context.say( "Saved")
		else:
			if len(self.persistant["todos"]) == 0:
				context.say("Nothing to do")
			else:
				texte = ""
				for todo in self.persistant["todos"]:
					item = todo[1]
					if (len(texte) + len(item)) > 400:
						context.say(texte)
						texte = ""
					texte += "%s (%s) ; " % (item, todo[0])
				if texte != "":
					context.say(texte)
			
	def Call_DONE (self, context):
		"""Remove the given TODO item from the TODO list (the user who reported the item is the only allowed to remove it"""
		for todo in self.persistant["todos"]:
			if todo[1] == context.command_args:
				context.say("Removing item from the TODO list")
				self.persistant["todos"].remove(todo)
				self.save()
				return
		context.say("Item not found in the TODO list")
