/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.1.6                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2004,2005,2006 COLLARD Christophe
 * copyright  2004,2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2004,2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    maths-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for maths.h
#endif

#if !defined (__MATHS_TEST_H)
#define _maths_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif

#if !defined(__PRECISION_H)
#include "../../MOL++/precision.h"
#endif

#if !defined(__MATHS_H)
#include "../../MOL++/maths.h"
#endif

using namespace std;

//=========================
int test_maths (int detail)
//=========================
{
  int result=1;

  long double x= 5.2375, y = -5.2375;

  if (detail) affiche ("abs", abs(y)==x);
  else result *= (abs(y)==x);

  if (detail) affiche ("power", abs(power(x,2)-x*x)<epsilon);
  else result *= (abs(power(x,2)-x*x)<epsilon);

  if (detail) affiche ("power", abs(power(x,2)-x*x)<epsilon);
  else result *= (abs(power(x,2)-x*x)<epsilon);

  if (detail) affiche ("sgn", sgn(x)==1 && sgn(-x)==-1);
  else result *= (sgn(x)==1 && sgn(-x)==-1);


  if (detail) affiche ("pi", abs(pi()-3.14159265358979323846264338327950288419716939937510) < epsilon);
  else result *= (abs(pi()-3.14159265358979323846264338327950288419716939937510)<epsilon);

  long double reel = 9*8*7*6*5*4*3*2;
  if (detail) affiche ("factorial", factorial(9)==reel);
  else result *= (factorial(9)==reel);

  if (detail) affiche ("inverse factorial", inv_factorial(reel)==9 && inv_factorial(x)==-1);
  else result *= (inv_factorial(reel)==9 && inv_factorial(x)==-1);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                    maths test passed \n";
  else cout << "                    maths test failed \n";
  cout << "============================================================== \n";

  return result;
}



#endif
