/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.0.8                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2004,2005 LAGOUCHE Sophie
 * copyright  2004,2005 CREUSE Emmanuel
 * copyright  2004,2005 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2004,2005 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    spmatrix-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for sparse matrix-test
#endif

#if !defined (__SPMATRIX_TEST_H)
#define _spmatrix_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__SPMATRIX_H)
#include "../../MOL++/spmatrix.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif


//=================================
int test_spmatrix (int detail)
//=================================

{

  int result=1;

//saisie d'une mme matrice en matrice pleine mat et en spmatrix A

  matrix<double> mat (7,8);
  spmatrix<double> A(7,8,3);

  //ligne 1
  mat(1,1)=1.0;
  mat(1,2)=2.0;
  mat(1,6)=5.0;

  A.set(1,1,1.0);
  A.set(1,2,2.0);
  A.set(1,6,5.0);


  //ligne 2
  mat(2,1)=2.0;
  mat(2,5)=3.0;
 
  A.set(2,1,2.0);
  A.set(2,5,3.0);


  //ligne 3
  mat(3,2)=-1.0;
  mat(3,5)=-1.0;
  mat(3,8)=-1.0;

  A.set(3,2,-1.0);
  A.set(3,5,-1.0);
  A.set(3,8,-1.0);


  //ligne 4
  mat(4,1)=1.0;
  mat(4,6)=2.0;

  A.set(4,2,5.0);
  
  A.set(4,1,1.0);
  A.set(4,6,2.0);
  
  A.set(4,2,0.0);


  //ligne 5
  mat(5,1)=1.0;
  mat(5,2)=1.0;
  mat(5,5)=1.0;

  A.set(5,1,1.0);
  A.set(5,2,1.0);
  A.set(5,5,1.0);


  //ligne 6
  mat(6,2)=-1.0;
  mat(6,5)=2.0;
  mat(6,8)=2.0;

  A.set(6,2,-1.0);
  A.set(6,5,2.0);
  A.set(6,8,2.0);


  //ligne 7
  mat(7,1)=1.0;
  mat(7,7)=2.0;
  mat(7,8)=2.0;

  A.set(7,1,1.0);
  A.set(7,7,2.0);
  A.set(7,8,2.0);

  //------------------------------------------------------------------------------------------
  //test fonction Row_Elements()
 
  if (detail) affiche("nb elements non nuls par ligne", (A.Row_Elements()==3));
  else result *= (A.Row_Elements()==3);

  //-------------------------------------------------------------------------------------------
  //test function set and output

  int test = 1;
  
  for (int i=1; i<=7; i++)
    for (int j=1; j<=8; j++)
      test *= (abs(mat(i,j) - A.output(i,j))<epsilon);
      
  if (detail) affiche ("function set and output", test);
  else result *= test;

  //------------------------------
  // test function add

 test = 1;
 
 spmatrix<double> add1(A);

 add1.add(7,8,2.0);
 
 add1.add(2,1,-2.0);
 
 add1.add(4,1,3.0);

 add1.add(2,2,4.0);
 
 
 spmatrix<double> add2(7,8,3);

  add2.set(1,1,1.0);
  add2.set(1,2,2.0);
  add2.set(1,6,5.0);
 
  add2.set(2,2,4.0);
  add2.set(2,5,3.0);

  add2.set(3,2,-1.0);
  add2.set(3,5,-1.0);
  add2.set(3,8,-1.0);

  add2.set(4,1,4.0);
  add2.set(4,6,2.0);

  add2.set(5,1,1.0);
  add2.set(5,2,1.0);
  add2.set(5,5,1.0);

  add2.set(6,2,-1.0);
  add2.set(6,5,2.0);
  add2.set(6,8,2.0);

  add2.set(7,1,1.0);
  add2.set(7,7,2.0);
  add2.set(7,8,4.0);
    
  for (int i=1; i<=7; i++)
    for (int j=1; j<=8; j++)
      test *= (abs(add1.output(i,j) - add2.output(i,j))<epsilon);

  if (detail) affiche ("function add", test);
  else result *= test;
 

  //-------------------------------------------------------------------------------------------
  //test operator =

  spmatrix<double> B, C(7,8,3);
  C = B = A;

  test = 1;
  for (int i=1; i<=7; i++)
    for (int j=1; j<=8; j++)
      test *= ((abs(mat(i,j)-B.output(i,j))<epsilon)  &&  (abs(mat(i,j)-C.output(i,j))<epsilon));
      
  if (detail) affiche ("operator =", test);
  else result *= test;
  
  
  //-------------------------------------------------------------------------------------------
  //test operator ==
   
  spmatrix<double> D(7,8,4), E(8,8,3), F(7,9,3), G, H, I;

  G = A;
  G.set(3,8,0.0);

  H = A;
  H.set(3,8,6.0);

  I = A;
  double elt = I.output(7,8);
  I.set(7,8,0.0);
  I.set(7,6,elt);

  for (int i=1; i<=7; i++)
    for (int j=1; j<=8; j++)
      {D.set(i,j,A.output(i,j));
       E.set(i,j,A.output(i,j));
       F.set(i,j,A.output(i,j));}
       
  if (detail) affiche ("operator ==", (B==C) && (A==B) && !(A==D) && !(A==E) && !(A==F) && !(A==G) && !(A==H) && !(A==I));
  else result *= ((B==C) && (A==B) && !(A==D) && !(A==E) && !(A==F) && !(A==G) && !(A==H) && !(A==I));
  
  //-------------------------------------------------------------------------------------------
  //test operator !=
  
  if (detail) affiche ("operator !=", !(B!=C) && !(A!=B) && (A!=D) && (A!=E) && (A!=F) && (A!=G) && (A!=H) && (A!=I));
  else result *= (!(B!=C) && !(A!=B) && (A!=D) && (A!=E) && (A!=F) && (A!=G) && (A!=H) && (A!=I));
  
  
  //-------------------------------------------------------------------------------------------
  //test constructor par recopie
 
  spmatrix<double> J(A);

  if (detail) affiche("copy constructor", (A==J));
   else result *= (A==J);
   
   //---------------------------------------------------------------------------
   //test resize
   
   test = 1;
   
   spmatrix<double> spmat1(8,7,4);
   
   spmat1.set(1,1,1.0);
   spmat1.set(1,6,5.0);
   spmat1.set(2,3,2.0);
   spmat1.set(2,6,8.0);
   spmat1.set(6,4,9.0);
   spmat1.set(5,7,1.0);
   
   for (int i=1; i<=8; i++)
     for (int j=1; j<=7; j++)
       test *= (abs(spmat1.output(i,j) - (spmat1.resize(2)).output(i,j))<epsilon);
   
   test *= ((spmat1.resize(2)).Row_Elements() == 2);
   
   if (detail) affiche("function rsize", test);
     else result *= test;
   
   //-------------------------------------------------------------------------------------------
  //test operator + (spmatrix+spmatrix)

  test = 1;
  
  spmatrix<double> K(7,8,3), L;

  K.set(1,1,2.0);
  K.set(1,2,1.0);
  K.set(1,6,4.0);

  K.set(2,7,1.0);
  K.set(2,8,1.0);
 
  K.set(3,2,1.0);
  K.set(3,5,1.0);
  K.set(3,8,1.0);

  K.set(4,6,2.0);

  K.set(5,4,1.0);
  K.set(5,5,1.0);
  K.set(5,3,1.0);

  K.set(6,3,2.0);
  K.set(6,5,-2.0);
  K.set(6,7,1.0);

  K.set(7,1,-1.0);
  K.set(7,2,2.0);
  K.set(7,3,2.0);  

  L = A+K;

  spmatrix<double> sum1(7,8,5);

  sum1.set(1,1,3.0);
  sum1.set(1,2,3.0);
  sum1.set(1,6,9.0);

  sum1.set(2,1,2.0);
  sum1.set(2,5,3.0);
  sum1.set(2,7,1.0);
  sum1.set(2,8,1.0);

  sum1.set(4,1,1.0);
  sum1.set(4,6,4.0);

  sum1.set(5,1,1.0);
  sum1.set(5,2,1.0);
  sum1.set(5,3,1.0);
  sum1.set(5,4,1.0);
  sum1.set(5,5,2.0);


  sum1.set(6,2,-1.0);
  sum1.set(6,3,2.0);
  sum1.set(6,7,1.0);
  sum1.set(6,8,2.0);

  sum1.set(7,2,2.0);
  sum1.set(7,3,2.0);
  sum1.set(7,7,2.0);
  sum1.set(7,8,2.0);
  

  for (int i=1; i<=7; i++)
    for (int j=1; j<=8; j++)
      test *= (abs(L.output(i,j) - sum1.output(i,j))<epsilon);

  test *= (L.Row_Elements() == 5);
 
 if (detail) affiche ("operator + : spmatrix+spmatrix", test);
  else result *= test;
  
   //-------------------------------------------------------------------------------------------
  //test operator + (matrix+spmatrix)
  
  //ne fonctionne pas  cause de la fonction output
  
  
  //-------------------------------------------------------------------------------------------
  //test operator - (spmatrix-spmatrix)

  test = 1;
  
  spmatrix<double> M(7,8,3), O;

  M.set(1,1,1.0);
  M.set(1,2,2.0);
  M.set(1,6,5.0);

  M.set(2,1,2.0);
  M.set(2,5,3.0);

  M.set(3,1,1.0);
  M.set(3,5,1.0);
  M.set(3,8,1.0);

  M.set(4,1,1.0);
  M.set(4,6,2.0);

  M.set(5,1,1.0);
  M.set(5,2,1.0);
  M.set(5,5,1.0);

  M.set(6,2,-1.0);
  M.set(6,5,2.0);
  M.set(6,8,2.0);

  M.set(7,1,1.0);
  M.set(7,7,2.0);
  M.set(7,8,2.0);

  spmatrix<double> N(7,8,3);

  N.set(1,1,2.0);
  N.set(1,2,1.0);
  N.set(1,6,4.0); 

  N.set(2,7,1.0);
  N.set(2,8,1.0);

  N.set(3,1,1.0);
  N.set(3,5,1.0);
  N.set(3,8,1.0);

  N.set(4,6,-2.0);

  N.set(5,4,1.0);
  N.set(5,5,2.0);
  N.set(5,3,1.0);

  N.set(6,3,2.0);
  N.set(6,5,2.0);
  N.set(6,7,1.0);

  N.set(7,1,1.0);
  N.set(7,2,2.0);
  N.set(7,3,2.0);

  O = M-N;

  spmatrix<double> sub1(7,8,5);

  sub1.set(1,1,-1.0);
  sub1.set(1,2,1.0);
  sub1.set(1,6,1.0);

  sub1.set(2,1,2.0);
  sub1.set(2,5,3.0);
  sub1.set(2,7,-1.0);
  sub1.set(2,8,-1.0);

  sub1.set(4,1,1.0);
  sub1.set(4,6,4.0);

  sub1.set(5,1,1.0);
  sub1.set(5,2,1.0);
  sub1.set(5,3,-1.0);
  sub1.set(5,4,-1.0);
  sub1.set(5,5,-1.0);

  sub1.set(6,2,-1.0);
  sub1.set(6,3,-2.0);
  sub1.set(6,7,-1.0);
  sub1.set(6,8,2.0);

  sub1.set(7,2,-2.0);
  sub1.set(7,3,-2.0);
  sub1.set(7,7,2.0);
  sub1.set(7,8,2.0);



  for (int i=1; i<=5; i++)
    for (int j=1; j<=7; j++)
      test *= (abs(O.output(i,j) - sub1.output(i,j))<epsilon);
      
  test *= (L.Row_Elements() == 5);
  
  if (detail) affiche ("operator - : spmatrix-spmatrix", test);
    else result *= test;

  //-------------------------------------------------------------------------------------------
  //test operator - (matrix-spmatrix)
  
  //ne fonctionne pas  cause de la fonction output
  
  //-------------------------------------------------------------------------------------------
  //test spmatrix*vector
  
  vector<double> V(8);

  V[1]=1.0;
  V[2]=1.0;
  V[3]=1.0;
  V[4]=1.0;
  V[5]=1.0;
  V[6]=1.0;
  V[7]=1.0;
  V[8]=1.0;

  spmatrix<double> P(7,8,3);

  P.set(1,1,1.0);
  P.set(1,2,2.0);
  P.set(1,6,5.0);
 
  P.set(2,1,2.0);
  P.set(2,5,3.0);
 
  P.set(3,1,1.0);
  P.set(3,5,1.0);
  P.set(3,8,1.0);
 
  P.set(4,1,1.0);
  P.set(4,6,2.0);
 
  P.set(5,1,1.0);
  P.set(5,2,1.0);
  P.set(5,5,1.0);

  P.set(6,2,-1.0);
  P.set(6,5,2.0);
  P.set(6,8,2.0);

  P.set(7,1,1.0);
  P.set(7,7,2.0);
  P.set(7,8,2.0);

  vector<double> sol1(7), U;

  U = P*V;

  sol1[1]=8.0;
  sol1[2]=5.0;
  sol1[3]=3.0;
  sol1[4]=3.0;
  sol1[5]=3.0;
  sol1[6]=3.0;
  sol1[7]=5.0;
  
  if (detail) affiche ("operator spmatrix*vector", (sol1 == U));
  else result *= (sol1 == U);
  
  //----------------------------------------------------------------------------------------------
  //test full
  
  spmatrix<double> Q(5,7,3);
  
  Q.set(1,1,5.0);
  Q.set(1,3,2.0);
  Q.set(1,4,9.0);
  Q.set(5,7,1.2);

  matrix<double> mat1(5,7);

  mat1(1,1)=5.0;
  mat1(1,3)=2.0;
  mat1(1,4)=9.0;
  mat1(5,7)=1.2;
 
  if (detail) affiche ("function full", (Q.full() == mat1)) ;
  else result *= (Q.full() == mat1);
  
  
  //----------------------------------------------------------------------------------------
  //test spmatrix*spmatrix
  
  spmatrix<double> R(5,5,2);
  R.set(1,1,1.0);
  R.set(1,5,1.0);
 
  R.set(2,1,1.0);
  R.set(2,5,1.0);
 
  R.set(3,1,1.0);
  R.set(3,5,1.0);
 
  R.set(4,1,1.0);
  R.set(4,5,1.0);
 
  R.set(5,1,1.0);
  R.set(5,5,1.0);

  spmatrix<double> S(5,5,3);

  S.set(1,1,1.0);
  S.set(1,3,1.0);
  S.set(1,5,1.0);

  S.set(5,2,1.0);
  S.set(5,4,1.0);

  matrix<double> T(5,5), sol2(5,5);

  T = R*S;

  for (int i=1; i<=5; i++)
    for (int j=1; j<=5; j++)
      sol2(i,j) = 1.0;
  
  if (detail) affiche ("operator spmatrix*spmatrix", (sol2 == T)) ;
  else result *= (sol2 == T);
  
  //---------------------------------------------------------------------
  //test elt*spmatrix
  
  spmatrix<double> sp2(5,5,3);
  
  sp2.set(1,1,1.0);
  sp2.set(1,3,1.0);

  sp2.set(2,5,1.0);

  sp2.set(3,4,1.0);
  sp2.set(3,5,1.0);

  sp2.set(4,1,1.0);
  sp2.set(4,3,1.0);
  sp2.set(4,5,1.0);

  sp2.set(5,1,1.0);
  
  spmatrix<double> sp22(5,5,3);
  
  sp22.set(1,1,2.0);
  sp22.set(1,3,2.0);

  sp22.set(2,5,2.0);

  sp22.set(3,4,2.0);
  sp22.set(3,5,2.0);

  sp22.set(4,1,2.0);
  sp22.set(4,3,2.0);
  sp22.set(4,5,2.0);

  sp22.set(5,1,2.0);
  
  if (detail) affiche ("operator elt*spmatrix", (sp22 == 2.0*sp2)) ;
  else result *= (sp22 == 2.0*sp2);
  
  
  //----------------------------------------------------------------------
  //test spmatrix/elt
  
  spmatrix<double> sp1(5,5,3);

  sp1.set(1,1,2.0);
  sp1.set(1,3,6.0);

  sp1.set(2,5,4.0);

  sp1.set(3,4,2.2);
  sp1.set(3,5,4.4);

  sp1.set(4,1,4.0);
  sp1.set(4,3,8.0);
  sp1.set(4,5,6.4);

  sp1.set(5,1,4.0);
  
  spmatrix<double> sp11(5,5,3);
  
  
  sp11.set(1,1,1.0);
  sp11.set(1,3,3.0);

  sp11.set(2,5,2.0);

  sp11.set(3,4,1.1);
  sp11.set(3,5,2.2);

  sp11.set(4,1,2.0);
  sp11.set(4,3,4.0);
  sp11.set(4,5,3.2);

  sp11.set(5,1,2.0);
  
  if (detail) affiche ("operator spmatrix/elt", (sp11 == sp1/2.0)) ;
  else result *= (sp11 == sp1/2.0);
  
    
  //---------------------------------------------------------------------
  //test transposee

  test = 1;

  spmatrix<double> W(7,8,3);

  W.set(1,1,1.0);
  W.set(1,2,2.0);
  W.set(1,6,5.0);
 
  W.set(2,1,2.0);
  W.set(2,5,3.0);
 
  W.set(3,1,1.0);
  W.set(3,5,1.0);
  W.set(3,8,1.0);
 
  W.set(4,1,1.0);
  W.set(4,6,2.0);
 
  W.set(5,1,1.0);
  W.set(5,2,1.0);
  W.set(5,5,1.0);

  W.set(6,2,-1.0);
  W.set(6,5,2.0);
  W.set(6,8,2.0);

  W.set(7,7,2.0);
  W.set(7,8,2.0);

  spmatrix<double> X, sol3(8,7,5);
 
  X = t(W);

  sol3.set(1,1,1.0);
  sol3.set(1,2,2.0);
  sol3.set(1,3,1.0);
  sol3.set(1,4,1.0);
  sol3.set(1,5,1.0);

  sol3.set(2,1,2.0);
  sol3.set(2,5,1.0);
  sol3.set(2,6,-1.0); 

  sol3.set(5,2,3.0);
  sol3.set(5,3,1.0);
  sol3.set(5,5,1.0);
  sol3.set(5,6,2.0);

  sol3.set(6,1,5.0);
  sol3.set(6,4,2.0);

  sol3.set(7,7,2.0);

  sol3.set(8,3,1.0);
  sol3.set(8,6,2.0);
  sol3.set(8,7,2.0);

  for (int i=1; i<=8; i++)
    for (int j=1; j<=7; j++)
      test *= (abs(X.output(i,j) - sol3.output(i,j))<epsilon);
      
  test *= (X.Row_Elements() == 5);
      
  if (detail) affiche ("function tranposee", test);
  else result *= (test);
  
  //-----------------------------------------------------------
  //function trace

  spmatrix<double> Z(5,5,3);
  
  Z.set(1,1,2.0);
  Z.set(1,5,3.0);
  
  Z.set(2,3,1.2);
  Z.set(2,5,1.0);
  
  Z.set(3,3,1.8);
  
  Z.set(4,5,0.3);
  
  Z.set(5,1,0.8);
  Z.set(5,5,0.2);

  if (detail) affiche ("function trace", (abs(trace(Z)-4)<epsilon));
   else result *= (abs(trace(Z)-4)<epsilon);
   
  //---------------------------------------------
  //function max
    
  if (detail) affiche ("function max", (abs(max(A)-5)<epsilon));
   else result *= (abs(max(A)-5)<epsilon);
  
  //----------------------------------------------------------------------
  
  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                 spmatrix test passed \n";
  else cout << "                 spmatrix test failed \n";
  cout << "============================================================== \n";

  return result;


}

#endif
