/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 1.5.6                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2003,2004,2005,2006 COLLARD Christophe
 * copyright  2003,2004 CREUSE Emmanuel
 * copyright  2003,2004,2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2003,2004,2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    symmatrix-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for symmatrix-test
#endif

#if !defined(__SYMMATRIX_TEST_H)
#define _symmatrix_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "../../MOL++/matrix.h"
#endif

#if !defined(__SYMMATRIX_H)
#include "../../MOL++/symmatrix.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif


//=============================
int test_symmatrix (int detail)
//=============================
{
  int result=1;

  vector<long double> u(9), v(9);

  vector<long double> b(9);

  v[1] = 4 ;
  v[2] = -1 ;
  v[5] = -1 ;

  matrix<long double> a(9,9), Id(9,9);
  
  a[1] = v ;
  v[1] = -1 ;
  v[2] = 4 ;
  v[3] = -1 ;
  v[4] = 0 ;
  v[5] = 0 ;
  v[6] = -1 ;

  a[2] = v ;

  v[1] = 0 ;
  v[2] = -1 ;
  v[3] = 4 ;
  v[4] = -1 ;
  v[5] = 0 ;
  v[6] = 0 ;
  v[7] = -1 ;

  a[3] = v ;
  
  v[1]=0; v[2]=0; v[3]=-1; v[4]=4; v[5]=-1; v[6]=0; v[7]=0; v[8]=-1; v[9]=0;
  a[4] = v ;
  v[1]=-1; v[2]=0; v[3]=0; v[4]=-1; v[5]=4; v[6]=-1; v[7]=0; v[8]=0; v[9]=-1;
  a[5]=v;  
  v[1]=0; v[2]=-1; v[3]=0; v[4]=0; v[5]=-1; v[6]=4; v[7]=-1; v[8]=0; v[9]=0;
  a[6]=v;
  v[1]=0; v[2]=0; v[3]=-1; v[4]=0; v[5]=0; v[6]=-1; v[7]=4; v[8]=-1; v[9]=0;
  a[7]=v;
  v[1]=0; v[2]=0; v[3]=0; v[4]=-1; v[5]=0; v[6]=0; v[7]=-1; v[8]=4; v[9]=-1;
  a[8]=v;
  v[1]=0; v[2]=0; v[3]=0; v[4]=0; v[5]=-1; v[6]=0; v[7]=0; v[8]=-1; v[9]=4;
  a[9]=v;

  v[1]=-5; v[2]=24; v[3]=18; v[4]=27; v[5]=-13; v[6]=-1; v[7]=-11; v[8]=-10; v[9]=4;

  for (int i=1; i<=9; i++) Id(i,i)=1;

  u[1]=u[9]=1.; u[2]=u[3]=u[4]=9.; u[5]=u[7]=u[8]=0.; u[6]=2.;

  matrix<long double> m(5,5);
  m(1,1)=0;
  m(1,2)=m(2,1)=0; m(2,2)=10;
  m(1,3)=m(3,1)=0; m(2,3)=m(3,2)=5; m(3,3)=1;
  m(1,4)=m(4,1)=0; m(2,4)=m(4,2)=-7; m(3,4)=m(4,3)=0; m(4,4)=0;
  m(1,5)=m(5,1)=2; m(2,5)=m(5,2)=7; m(3,5)=m(5,3)=-1; m(4,5)=m(5,4)=22; m(5,5)=-4;

  symmatrix<long double> smat(5), smat2, smat3, smat4(5), smat5(5,5);
  vector<long double> ve(5);

  bool test = true;
  int size = 0;
  if (smat) size = smat;
  else test = false;
  if (smat2) test = false;
  if (detail) affiche ("cast operator () symmatrix -> int", test && size==smat.Rows());
  else result *= (test && size==smat.Rows());

  if (detail) affiche ("operator !", !(!smat) && !smat2);
  else result *= (!(!smat) && !smat2);

  ve[1]=2; ve[2]=7; ve[3]=-1; ve[4]=22; ve[5]=-4;
  if (detail) affiche("rows/columns", ((smat.Rows()==5)&&(smat.Columns()==5)));
  else result *= (((smat.Rows()==5)&&(smat.Columns()==5)));

  smat[5]=ve;
  smat(2,2) = smat5(2,2) = 10.;
  smat(2,3) = smat5(2,3) = 5.;
  smat(3,3) = smat5(3,3) = 1.;
  smat(4,2) = -7.;

  if (detail) affiche ("operator (,)", smat(4,2)==-7.);
  else result *= (smat(4,2)==-7.);

  if (detail) affiche ("operator []", smat[5]==ve && smat[3].dim()==3);
  else result *= (smat[5]==ve && smat[3].dim()==3);

  if (detail) affiche ("operator == symmat/symmat", (smat==smat));
  else result *= (smat==smat);

  if (detail) affiche ("operator == symmat/mat", (smat==m));
  else result *= (smat==m);

  if (detail) affiche ("operator == mat/symmat", (m==smat));
  else result *= (m==smat);

 
  if (detail) affiche ("operator != symmat/symmat", (smat!=smat5));
  else result *= (smat!=smat5);

  if (detail) affiche ("operator != symmat/mat", (smat5!=m));
  else result *= (smat5!=m);

  if (detail) affiche ("operator != mat/symmat", (m!=smat5));
  else result *= (m!=smat5);

  symmatrix<long double> smtc(7,7), smtc2(7,7,true,-4.32), smtc3(7), smtc4(7,true,-4.32);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      smtc(i,j) = smtc3(i,j) = -4.32;
  if (detail) affiche ("constructor", smtc==smtc2 && smtc==smtc3 && smtc==smtc4);
  else result *= smtc==smtc2 && smtc==smtc3 && smtc==smtc4;

  smat2 = smat;
  if (detail) affiche ("operator = symmat/symmat", smat2==m && smat2[1].dim()==1);
  else result *= (smat2==m && smat2[1].dim()==1);
  
  symmatrix<double> meq1(9,9), meq2(9,9), meq3, meq4;
  for (int i=1; i<=9; i++)
    for (int j=1; j<=i; j++)
    { meq1(i,j) = 2*i/3. - 5*j/2.;
      meq2(i,j) = 1/(1.*i) + 3.21*j;
    }
  meq3 = meq1 + meq2;
  meq4 = &(meq1+meq2);
  symmatrix<double> meq5 = &(meq1+meq2);
  if (detail) affiche("operator = (destructive for temporary objects)", meq3==meq4 && meq3==meq5 && meq4[1].dim()==1);
  else result *= (meq3==meq4 && meq3==meq5 && meq4[1].dim()==1);

  symmatrix<long double> maxm;
  maxm=a;
  if (detail) affiche ("operator = symmat/mat", maxm==a && maxm[1].dim()==1);
  else result *= (maxm==a && maxm[1].dim()==1);
  
  matrix<long double> am;
  am = maxm;
  if (detail) affiche ("operator = mat/symmat", maxm==am && am[1].dim()==am.Columns());
  else result *= (maxm==am && am[1].dim()==am.Columns());

  symmatrix<double> mtrx, mtrx2(2,2), mtrx3(12,12), mtrx4, mtrx5, mtrx6, mtrx7, mtrx8;
  mtrx = mtrx8 = meq1;
  mtrx2 &= mtrx;
  mtrx3 &= mtrx4;
  mtrx7 &= mtrx8;
  if (detail) affiche ("operator &= (copy without size check)", mtrx2==meq1 && mtrx && !mtrx3 && mtrx7==meq1);
  else result *= (mtrx2==meq1 && mtrx && !mtrx3 && mtrx7==meq1);

  symmatrix<double> mtrx9;
  mtrx = mtrx8 = meq1;
  mtrx2 &=& mtrx;
  mtrx3 &=& (meq1+meq1);
  mtrx4 &=& mtrx;
  mtrx5  &=& mtrx6;
  mtrx9 &=& mtrx8;
  if (detail) affiche ("operator &= (destructive copy for temporary objects with no size check)", mtrx2==meq1 && !mtrx && mtrx3==2.*meq1 && !mtrx4 && !mtrx5 && mtrx9==meq1 && !mtrx8);
  else result *= (mtrx2==meq1 && !mtrx && mtrx3==2.*meq1 && !mtrx4 && !mtrx5 && mtrx9==meq1 && !mtrx8);

  smat4(2,2)=20; smat4(3,2)=10; smat4(3,3)=2; smat4(4,2)=-14; smat4(5,1)=4; smat4(5,2)=14; smat4(5,3)=-2; smat4(5,4)=44; smat4(5,5)=-8;
  if (detail) affiche ("operator + symmat/symmat", (smat+smat)==smat4 && (smat+smat)[1].dim()==1);
  else result *= ((smat+smat)==smat4 && (smat+smat)[1].dim()==1);

  symmatrix<long double> mata(9), smtest(9);
  matrix<long double> mat(9,9);
  for (int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      mat(i,j) = 5*i/j+2*i;
  maxm=a;
  if (detail) affiche ("operator + symmat/mat", (maxm+a==(long double) 2*a) && (maxm+mat == a+mat) && (maxm+mat)[1].dim()==mat.Columns());
  else result *= ((maxm+a==(long double) 2*a) && (maxm+mat == a+mat) && (maxm+mat)[1].dim()==mat.Columns());

  if (detail) affiche ("operator + mat/symmat", (maxm+a==(long double) 2*a) && (mat+maxm == mat+a) && (mat+maxm)[1].dim()==mat.Columns());
  else result *= ((maxm+a==(long double) 2*a) && (mat+maxm == mat+a) && (mat+maxm)[1].dim()==mat.Columns());

  smat3=smat+smat;
  if (detail) affiche ("operator - symmat/symmat", smat3-smat==smat && (smat3-smat)[1].dim()==1);
  else result *= (smat3-smat==smat && (smat3-smat)[1].dim()==1);

  maxm=(long double) 2 * a;
  if (detail) affiche ("operator - symmat/mat", (maxm-a==a) && (maxm-mat == (long double) 2 *a-mat) && (maxm-mat)[1].dim()==mat.Columns());
  else result *= ((maxm-a==a) && (maxm-mat == (long double) 2*a-mat) && (maxm-mat)[1].dim()==mat.Columns());

  if (detail) affiche ("operator - mat/symmat", (a-maxm==a*(long double) -1) && (mat-maxm == mat-(long double) 2*a) && (mat-maxm)[1].dim()==mat.Columns());
  else result *= ((a-maxm==a*(long double) -1) && (mat-maxm == mat-(long double) 2*a) && (mat-maxm)[1].dim()==mat.Columns());

  maxm=a;
  for (int i=1; i<=9; i++)
    for (int j=1; j<=i; j++)
      { mata(i,j) = 3*i-2*j+23 + i*i;
        smtest (i,j) = i*j + 2*j - i;
      }
  am = mata;
  if (detail) affiche ("operator * symmat/symmat", a*am==maxm*mata && (maxm*mata)[1].dim()==maxm.Columns());
  else result *= (a*am==maxm*mata) && (maxm*mata)[1].dim()==maxm.Columns();
  
  if (detail) affiche ("operator * symmat/mat", (maxm*mat==a*mat) && (maxm*mat)[1].dim()==mat.Columns());
  else result *= (maxm*mat==a*mat) && (maxm*mat)[1].dim()==mat.Columns();

  if (detail) affiche ("operator * mat/symmat", (mat*maxm==mat*a) && (mat*maxm)[1].dim()==mat.Columns());
  else result *= (mat*maxm==mat*a) && (mat*maxm)[1].dim()==mat.Columns();

  if (detail) affiche ("operator * symmat/sc", maxm*(long double) 3==maxm+maxm+maxm && (maxm*(long double) 3)[1].dim()==1);
  else result *= (maxm*(long double) 3==maxm+maxm+maxm) && (maxm*(long double) 3)[1].dim()==1;

  if (detail) affiche ("operator * sc/symmat", (long double) 2*maxm==maxm+maxm && ((long double) 2*maxm)[1].dim()==1);
  else result *= ((long double) 2*maxm==maxm+maxm && ((long double) 2*maxm)[1].dim()==1);
  
  vector<long double> usmat(9), vsmat;
  usmat[1] = 1; usmat[2]=2; usmat[3]=0; usmat[4]=-1; usmat[5]=-2; usmat[6]=21.52; usmat[7]=-34.567; usmat[8]= 234.22; usmat[9]=34.6;
  vsmat = maxm*usmat;
  if (detail) affiche ("operator * symmat/vect", vsmat==a*usmat);
  else result *= (vsmat==a*usmat);

  vsmat = usmat*maxm;
  if (detail) affiche ("operator * vect/symmat", vsmat==usmat*a);
  else result *= (vsmat==usmat*a);
  
  if (detail) affiche ("operator / symmat/symmat", mata/mata==Id && (mata/mata)[1].dim()==mata.Columns());
  else result *= (mata/mata==Id) && (mata/mata)[1].dim()==mata.Columns();

  mat += Id;
  if (detail) affiche ("operator / symmat/mat", (maxm/mat)==a/mat && (maxm/mat)[1].dim()==mat.Columns());
  else result *= (maxm/mat==a/mat) && (maxm/mat)[1].dim()==mat.Columns();

  if (detail) affiche ("operator / mat/symmat", (mat/maxm)==mat/a && (mat/maxm)[1].dim()==mat.Columns());
  else result *= (mat/maxm==mat/a) && (mat/maxm)[1].dim()==mat.Columns();

  maxm=a;
  maxm = maxm/ (long double) 15.;
  if (detail) affiche ("operator / symmat/sc", maxm==a/(long double) 15. && maxm[1].dim()==1);
  else result *= (maxm==a/(long double) 15. && maxm[1].dim()==1);

  maxm = a;
  long double sc15 = 15;
  if (detail) affiche ("operator / sc/symmat", sc15/maxm==sc15/a && (sc15/maxm)[1].dim()==1);
  else result *= (sc15/maxm==sc15/a && (sc15/maxm)[1].dim()==1);

  long double sum = 0;
  for (int i=1; i<=mata.Rows(); i++)
    for (int j=1; j<=mata.Columns(); j++)
      sum += mata(i,j) * maxm(i,j);
  if (detail) affiche ("operator | symmat/symmat", (mata|maxm)==sum);
  else result *= ((mata|maxm)==sum);

  sum = 0;
  for (int i=1; i<=mata.Rows(); i++)
    for (int j=1; j<=mata.Columns(); j++)
      sum += mata(i,j) * mat(i,j);
  if (detail) affiche ("operator | symmat/mat", (mata|mat)==sum);
  else result *= ((mata|mat)==sum);

  if (detail) affiche ("operator | mat/symmat", (mat|mata)==sum);
  else result *= ((mat|mata)==sum);

  symmatrix<long double> maxmt;
  matrix<long double> nm;
  nm = a+mata;
  maxmt=a;
  maxmt+= mata;
  if (detail) affiche ("operator += symmat/symmat", maxmt==nm && maxmt[1].dim()==1);
  else result *= (maxmt==nm && maxmt[1].dim()==1);

  maxmt+=mata;
  if (detail) affiche ("operator += symmat/mat(sym)", maxmt==nm+mata && maxmt[1].dim()==1);
  else result *= (maxmt==nm+mata && maxmt[1].dim()==1);

  nm = mat;
  nm+=mata;
  if (detail) affiche ("operator += mat/symmat", nm==mat+mata && nm[1].dim()==nm.Columns());
  else result *= (nm==mat+mata && nm[1].dim()==nm.Columns());
  
  nm = a-mata;
  maxmt=a;
  maxmt-= mata;
  maxm-=maxmt;
  if (detail) affiche ("operator -= symmat/symmat", maxmt==nm && maxmt[1].dim()==1);
  else result *= (maxmt==nm && maxmt[1].dim()==1);

  maxmt-=mata;
  if (detail) affiche ("operator -= symmat/mat(sym)", maxmt==nm-mata && maxmt[1].dim()==1);
  else result *= (maxmt==nm-mata && maxmt[1].dim()==1);

  nm = mat;
  nm-=mata;
  if (detail) affiche ("operator -= mat/symmat", nm==mat-mata && nm[1].dim()==nm.Columns());
  else result *= (nm==mat-mata && nm[1].dim()==nm.Columns());

  nm=mat;
  nm*=mata;
  if (detail) affiche ("operator *= mat/symmat", nm==mat*mata && nm[1].dim()==mat[1].dim());
  else result *= (nm==mat*mata && nm[1].dim()==mat[1].dim());
  
  maxm = mata;
  maxm *= 10.;
  if (detail) affiche ("operator *= symmat/sc", maxm==mata*(long double) 10 && maxm[1].dim()==1);
  else result *= (maxm==mata*(long double) 10 && maxm[1].dim()==1);

  if (detail) affiche ("operator *= sc/symmat", maxm==(long double) 10*mata && maxm[1].dim()==1);
  else result *= (maxm==(long double) 10*mata && maxm[1].dim()==1);

  matrix<long double> mta = mat;
  mta /= mata;
  if (detail) affiche ("operator /= mat/symat", mta==mat/mata && mta[1].dim()==mta.Columns());
  else result *= (mta==mat/mata && mta[1].dim()==mta.Columns());

  maxm = mata*(long double)10;
  maxm/=15.;
  if (detail) affiche ("operator /= symat/sc", maxm==mata/(long double)1.5 && maxm[1].dim()==1);
  else result *= (maxm==mata/(long double)1.5 && maxm[1].dim()==1);
  
  maxm = mata;
  maxm /= 10.;
  if (detail) affiche ("operator /= sc/symmat", maxm==mata/(long double)10 && maxm[1].dim()==1);
  else result *= (maxm==mata/(long double)10 && maxm[1].dim()==1);
  
  maxm=mata;
  nm = mata;
  if (detail) affiche ("det", det(maxm) == det(nm));
  else result *= (det(maxm) == det(nm));
  
  if (detail) affiche ("t", smat==t(smat) && t(smat)[1].dim()==1);
  else result *= (smat==t(smat) && t(smat)[1].dim()==1);

  smat.save("symmat.res");
  symmatrix<long double> fsymat(smat.Rows());
  fsymat.read("symmat.res");
  if (detail) affiche ("read/write", fsymat==smat && fsymat[1].dim()==1);
  else result *= (fsymat==smat && fsymat[1].dim()==1);
  
  if (detail) affiche ("gauss", mata*gauss(mata)==Id && gauss(mata)[1].dim()==1);
  else result *= (mata*gauss(mata)==Id && gauss(mata)[1].dim()==1);

  symmatrix<long double> defmat1, defmat2, defmat4;
  symmatrix<long double> defmat3(5,5);
  defmat1.assign(5,5);
  for (int i=1; i<=5; i++)
    for (int j=i; j<=5; j++)
      defmat1(i,j) = defmat3(i,j) = i+2*j;
  if (detail) affiche ("assign", defmat1==defmat3 && defmat1[1].dim()==1);
  else result *= (defmat1==defmat3 && defmat1[1].dim()==1);

  defmat4.create(5,5);
  for (int i=1; i<=5; i++)
    defmat4[i] = defmat3[i];
  if (detail) affiche ("create", defmat4==defmat3 && defmat4[1].dim()==1);
  else result *= (defmat4==defmat3 && defmat4[1].dim()==1);


  defmat2 = defmat1;
  defmat2(2,3) = -defmat1(2,3);
  defmat2(2,2) = -defmat1(2,2);
  defmat2(5,1) = -defmat1(5,1);
  if (detail) affiche ("abs", abs(defmat2)==defmat1 && abs(defmat2)[1].dim()==1);
  else result *= (abs(defmat2)==defmat1 && abs(defmat2)[1].dim()==1);

  symmatrix<double> matvv(2,2);
  symmatrix<double> matabsvv(2,2);
  matvv(1,1)=0.55; matvv(1,2)=-6.458; matvv(2,2)=-0.55;
  matabsvv(1,1)=0.55; matabsvv(1,2)=6.458; matabsvv(2,2)=0.55;
  if (detail) affiche ("tr", tr(matabsvv)==1.1);
  else result *= (tr(matabsvv)==1.1);

  if (detail) affiche("max", max(defmat1)==15);
  else result *= (max(defmat1)==15);


  symmatrix<double> matww(10,10);
  vector<double> diag(10);
  for (int i=1; i<=10; i++)
    { for (int j=1; j<=10; j++)
	matww(i,j) = i+2*j;
      diag[i] = 3*i;
    }
  if (detail) affiche("diagonal", diagonal(matww)==diag);
  else result *= (diagonal(matww)==diag);

  symmatrix<long double> Ids(5);
  for (int i=1; i<=5; i++)
    Ids (i,i) = 1;
  if (detail) affiche("Id2s", Ids == Id2s<long double>(5));
  else result *= (Ids == Id2s<long double>(5));

  cout << endl;  
  
  cout << "============================================================== \n";
  if (result) cout<< "                    symmatrix test passed \n";
  else cout << "                    symmatrix test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
