/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 1.3.8                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2003,2004,2005,2006 COLLARD Christophe
 * copyright  2003,2004,2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2003,2004,2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    tensors4-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for tensor4-test
#endif

#if !defined(__TENSORS4_TEST_H)
#define _tensors4_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "../../MOL++/matrix.h"
#endif

#if !defined(__SYMMATRIX_H)
#include "../../MOL++/symmatrix.h"
#endif

#if !defined(__TENSORS2_H)
#include "../../MOL++/tensors2.h"
#endif

#if !defined(__TENSORS3_H)
#include "../../MOL++/tensors3.h"
#endif

#if !defined(__TENSORS4_H)
#include "../../MOL++/tensors4.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif


//===========================
int test_tensor4 (int detail)
//===========================
{
  bool result = true;

  tensor4<long double> t1(3,5,7,2), t2(3,5,7,2), t3, t4(3,5,7,2), t5(3,5,7,2);

  bool test = true;
  int size = 0;
  if (t1) size = t1;
  else test = false;
  if (t3) test = false;
  if (detail) affiche ("cast operator () tensor4 -> int", test && size==t1.dim1());
  else result *= (test && size==t1.dim1());

  if (detail) affiche ("operator !", !(!t1) && !t3);
  else result *= (!(!t1) && !t3);

  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  {
	    t1(i,j,k,l) = i+j/(1.*k)*l;
	    t4(i,j,k,l) = 2*i-5*j+7*k/(1.*l);
	}
  if (detail) affiche ("operator (,,,)", t4(3,1,4,1)==29. && t1(3,1,4,1)==3.25);
  else result *= (t4(3,1,4,1)==29. && t1(3,1,4,1)==3.25);

  if (detail) affiche ("dim1 dim2 dim3 dim4", t1.dim1()==3 && t1.dim2()==5 && t1.dim3()==7 && t1.dim4()==2);
  else result *= t1.dim1()==3 && t1.dim2()==5 && t1.dim3()==7 && t1.dim4()==2;

  tensor4<long double> t6, t10;
  t6.assign(5,2,4,7);
  if (detail) affiche ("assign", t6.dim1()==5 && t6.dim2()==2 && t6.dim3()==4 && t6.dim4()==7);
  else result *= t6.dim1()==5 && t6.dim2()==2 && t6.dim3()==4 && t6.dim4()==7;

  t10.create(5);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=2; j++)
      for (int k=1; k<=4; k++)
	for (int l=1; l<=7; l++)
	  t6 (i,j,k,l) = i - 2*j + 3*k - l*.5;
  for (int i=1; i<=5; i++)
    t10[i] = t6[i]; 
  if (detail) affiche ("create", t10==t6);
  else result *= t10==t6;


  if (detail) affiche ("operator ==", (t1==t1) && !(t1==t2));
  else result *= ((t1==t1) && !(t1==t2));

  if (detail) affiche ("operator !=", !(t1!=t1) && t1!=t2);
  else result *= (!(t1!=t1) && t1!=t2);

  tensor3<long double> tens3 (5,7,2);
  for (int j=1; j<=5; j++)
    for (int k=1; k<=7; k++)
      for (int l=1; l<=2; l++)
	tens3(j,k,l) = 2+j/(1.*k)*l;
  tensor4<long double> tens4(3,5,7,2);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  tens4[i][j][k][l] = 2*i - 5*j + 7*k/(1.*l);
  if (detail) affiche ("operator []", t1[2]==tens3 && t4==tens4);
  else result *= (t1[2]==tens3 && t4==tens4);

  t2 = t1;
  int resultat = (t2==t1);
  t2(1,1,1,1) = -10;
  resultat *= (t1!=t2);
  t3 = t1;
  if (detail) affiche ("operator =", resultat*(t1==t3));
  else result *= ( resultat*(t1==t3));

  tensor4<long double> ntsr1(2,9,5,7), ntsr2(2,9,5,7), ntsr3, ntsr4, ntsr0(2,9,5,7);
  for (int i=1; i<=2; i++)
    for (int j=1; j<=9; j++)
      for (int k=1; k<=5; k++)
	for (int l=1; l<=7; l++)
	  { ntsr1(i,j,k,l) = 20*i/3. - 3*j/(1.*k) + 3.*l;
	    ntsr2(i,j,k,l) = 3*i - j + 1/(1.*k) + 3.*l;
	  }
  ntsr3 = ntsr1 + ntsr2;
  ntsr4 = &(ntsr1+ntsr2);
  ntsr0 = &(ntsr1+ntsr2);
  tensor4<long double> ntsr5 = &(ntsr1+ntsr2);
  if (detail) affiche("operator = (destructive copy for temporary objects)", ntsr3==ntsr0 && ntsr3==ntsr4 && ntsr3==ntsr5);
  else result *= (ntsr3==ntsr0 && ntsr3==ntsr4 && ntsr3==ntsr5);

  tensor4<long double> mtrx, mtrx2(2,3,5), mtrx3(12,24,36), mtrx4, mtrx5(2,9,5,12), mtrx6(2,9,11,12), mtrx0(2,3,11,12), mtrx7, mtrx8;
  mtrx = mtrx8 = ntsr1;
  mtrx2 &= mtrx;
  mtrx3 &= mtrx4;
  mtrx5 &= ntsr1;
  mtrx6 &= ntsr1;
  mtrx0 &= ntsr1;
  mtrx7 &= mtrx8;
  if (detail) affiche ("operator &= (copy without size check)", mtrx2==ntsr1 && mtrx && !mtrx3 && mtrx7==ntsr1 && mtrx5==ntsr1 && mtrx6==ntsr1 && mtrx0==ntsr1);
  else result *= (mtrx2==ntsr1 && mtrx && !mtrx3 && mtrx7==ntsr1 && mtrx5==ntsr1 && mtrx6==ntsr1 && mtrx0==ntsr1);

  tensor4<long double> mtrx9, mtrx10;
  mtrx = mtrx8 = ntsr1;
  mtrx2 &=& mtrx;
  mtrx3 &=& (ntsr1+ntsr1);
  mtrx4 &=& mtrx;
  mtrx5  &=& mtrx10;
  mtrx9 &=& mtrx8;
  if (detail) affiche ("operator &= (destructive copy for temporary objects with no size check)", mtrx2==ntsr1 && !mtrx && mtrx3==(long double) 2*ntsr1 && !mtrx4 && !mtrx5 && mtrx9==ntsr1 && !mtrx8);
  else result *= (mtrx2==ntsr1 && !mtrx && mtrx3==(long double) 2*ntsr1 && !mtrx4 && !mtrx5 && mtrx9==ntsr1 && !mtrx8);

  tensor4<long double> t7(3,5,7,2);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  { t3(i,j,k,l) = i*0.5 + j*2.658 - k*3.12 + 1./(1.*l);
	    t7(i,j,k,l) = 4*t3(i,j,k,l);
	  }
  if (detail) affiche ("operator +", t7==t3+t3+t3+t3);
  else result *= (t7==t3+t3+t3+t3);

  if (detail) affiche ("operator -", t3==t7-t3-t3-t3);
  else result *= (t3==t7-t3-t3-t3);

  t3 = t2;
  t3 += t1;
  if (detail) affiche ("operator +=", t3==t2+t1);
  else result *= (t3==t2+t1);
  
  t3-= t2;
  if (detail) affiche ("operator -=", t3==t1);
  else result *= (t3==t1);
 
  long double sum = 0;
  for (int i=1; i<=t1.dim1(); i++)
    for (int j=1; j<=t1.dim2(); j++)
      for (int k=1; k<=t1.dim3(); k++)
	for (int l=1; l<=t1.dim4(); l++)
	  sum += t1(i,j,k,l) * t4(i,j,k,l);
  if (detail) affiche ("operator |", abs((t1|t4)-sum)<epsilon);
  else result *= (abs((t1|t4)-sum)<epsilon);

  tensor4<long double> t8(7,2,9,1), t9(3,5,9,1);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=2; j++)
      for (int k=1; k<=9; k++)
	for (int l=1; l<=1; l++)
	  t8(i,j,k,l) = 9*i-2*j/(1.*l) - k;
  for (int i=1; i<=t1.dim1(); i++)
    for (int j=1; j<=t1.dim2(); j++)
      for (int k=1; k<=t1.dim3(); k++)
	for (int l=1; l<=t1.dim4(); l++)
	  for (int p=1; p<=t8.dim3(); p++)
	    for (int q=1; q<=t8.dim4(); q++)
	      t9(i,j,p,q) += t1(i,j,k,l) * t8(k,l,p,q);
  if (detail) affiche ("operator ||", abs((t1|t4)-sum)<epsilon);
  else result *= (abs((t1|t4)-sum)<epsilon);

  t3 = t2;
  t3 *= 5;
  if (detail) affiche ("operator *= (tensor/scalar)", t3==t2+t2+t2+t2+t2);
  else result *= (t3==t2+t2+t2+t2+t2);

  t3 = t2*(long double)3;
  if (detail) affiche ("operator * (tensor/scalar)", t3==t2+t2+t2);
  else result *= (t3==t2+t2+t2);
  
  t3 = (long double) 5*t1;
  if (detail) affiche ("operator * (scalar/tensor)", t3==t1+t1+t1+t1+t1);
  else result *= (t3==t1+t1+t1+t1+t1);
  
  long double value = 0.125;
  vector<long double> vt2(2);
  for (int k=1; k<=2; k++) vt2[k] = value*k;
  tensor3<long double> ttest2(3,5,7);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  ttest2(i,j,k) += t1(i,j,k,l) * vt2[l];
  if (detail) affiche ("operator * (tensor/vector : P_ijkl V_l)", (t1*vt2)==ttest2);
  else result *= ((t1*vt2)==ttest2);

  vector<long double> vt3(3);
  for (int k=1; k<=3; k++) vt3[k] = value*k;
  tensor3<long double> ttest3(5,7,2);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  ttest3(j,k,l) += t1(i,j,k,l)*vt3[i];
  if (detail) affiche ("operator * (vector/tensor : P_ijkl V_i)", (vt3*t1)==ttest3);
  else result *= ((vt3*t1)==ttest3);

  vector<long double> vt7(7);
  for (int k=1; k<=7; k++) vt7[k] = value*k;
  tensor3<long double> ttest7(3,5,2);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  ttest7(i,j,l) += t1(i,j,k,l)*vt7[k];
  if (detail) affiche ("operator | (tensor/vector : P_ijkl V_k)", (t1|vt7)==ttest7);
  else result *= ((t1|vt7)==ttest7);
  
  vector<long double> vt5(5);
  for (int k=1; k<=5; k++) vt5[k] = value*k;
  tensor3<long double> ttest5(3,7,2);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  ttest5(i,k,l) += t1(i,j,k,l)*vt5[j];
  if (detail) affiche ("operator | (vector/tensor : P_ijkl V_j)", (vt5|t1)==ttest5);
  else result *= ((vt5|t1)==ttest5);

  if (detail) affiche ("sum tensor * vector (i), i = 1->4 :", (tensor_sum(t1,vt3,1) == ttest3)  &&  (tensor_sum(t1,vt5,2) == ttest5)  &&  (tensor_sum(t1,vt7,3) == ttest7) &&  (tensor_sum(t1,vt2,4) == ttest2) );
  else result *= ( (tensor_sum(t1,vt3,1) == ttest3)  &&  (tensor_sum(t1,vt5,2) == ttest5)  &&  (tensor_sum(t1,vt7,3) == ttest7) &&  (tensor_sum(t1,vt2,4) == ttest2) );

  tensor2<long double> t2s(7,2), t2r(3,5);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=2; j++)
      t2s(i,j) = i*i - 2*j;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  t2r(i,j) += t1(i,j,k,l) * t2s(k,l);
  if (detail) affiche ("operator || (tensor4/tensor2 : P_ijkl M_kl)", (t1||t2s)==t2r);
  else result *= ((t1||t2s)==t2r);

  tensor2<long double> t2sr(7,2);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  t2sr(k,l) += t1(i,j,k,l) * t2r(i,j);
  if (detail) affiche ("operator || (tensor2/tensor4 : M_ij P_ijkl)", (t2r||t1)==t2sr);
  else result *= ((t2r||t1)==t2sr);

  tensor2<long double> mat1(5,7), mat2(4,2);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=7; j++)
      mat1(i,j) = (22.5+j)*i + i/j;
  for (int i=1; i<=4; i++)
    for (int j=1; j<=2; j++)
      mat2(i,j) = j*j - i;
  tensor4<long double> tmat (5,7,4,2);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=4; k++)
	for (int l=1; l<=2; l++)
	  tmat(i,j,k,l) = mat1(i,j) * mat2(k,l);
  if (detail) affiche ("operator tensor2 ^ tensor2 : Tijkl = A_ij B_kl", tmat == (mat1^mat2));
  else result *= (tmat == (mat1^mat2));

  tensor3<long double> tsr3_1(5,7,4), tsr3_2(5,9,2);
  tensor4<long double> tsr4_result(7,4,9,2);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=7; j++)
      for (int n=1; n<=4; n++)
	tsr3_1(i,j,n) = 3*n/i + 2*j/n;
  for (int i=1; i<=5; i++)
    for (int j=1; j<=9; j++)
      for (int n=1; n<=2; n++)
  	tsr3_2(i,j,n) = 3*n/i + 2*j/n;
  for (int i=1; i<=7; i++)
    for (int j=1; j<=4; j++)
      for (int k=1; k<=9; k++)
	for (int l=1; l<=2; l++)
	  for (int n=1; n<=5; n++)
	    tsr4_result(i,j,k,l) += tsr3_1(n,i,j) * tsr3_2(n,k,l);
  if (detail) affiche ("operator tensor3 ^ tensor3 :Tijkl =  P_nij Q_nkl", tsr4_result == (tsr3_1 ^ tsr3_2));
  else result *= (tsr4_result == (tsr3_1 ^ tsr3_2));
  
  tensor3<long double> t3t4(3,4,2);
  for (int n=1; n<=3; n++)
    for (int k=1; k<=5; k++)
      for (int l=1; l<=7; l++)
	for (int i=1; i<=4; i++)
	  for (int j=1; j<=2; j++)
	    t3t4(n,i,j) += tmat(k,l,i,j) * ttest2(n,k,l);
  if (detail) affiche ("operator tensor3 || tensor4 :Tn,ij =  P_nkl Q_klij", t3t4 == (ttest2||tmat));
  else result *= (t3t4 == (ttest2 || tmat));

  tensor3<long double> t4t3(3,2,9);
  for (int n=1; n<=3; n++)
    for (int k=1; k<=5; k++)
      for (int l=1; l<=7; l++)
	for (int i=1; i<=2; i++)
	  for (int j=1; j<=9; j++)
	    t4t3(n,i,j) += ntsr1(i,j,k,l) * ttest2(n,k,l);
  if (detail) affiche ("operator tensor4 || tensor3 :Tn,ij =  P_nkl Q_ijkl", t4t3 == (ntsr1 || ttest2));
  else result *= (t4t3 == (ntsr1 || ttest2));

  int nsz = 3;
  tensor4<long double> Id_4(nsz), Tsr4(nsz), Tsr4s(nsz);
  for (int i=1; i<=nsz; i++)
    for (int j=1; j<=nsz; j++)
      for (int k=1; k<=nsz; k++)
	for (int l=1; l<=nsz; l++)
	  { Id_4(i,j,k,l) += .5 * ( (i==k) * (j==l) + (i==l) * (j==k));
	    Tsr4(i,j,k,l) += .5*i + 2.134*j - 1.7654*k + 3.654298*l;
	  }
  for (int i=1; i<=nsz; i++)
    for (int j=1; j<=nsz; j++)
      for (int k=1; k<=nsz; k++)
	for (int l=1; l<=nsz; l++)
	  Tsr4s(i,j,k,l) = .25 * (Tsr4(i,j,k,l) + Tsr4(i,j,l,k) + Tsr4(j,i,k,l) + Tsr4(j,i,l,k));
  if (detail) affiche("Id4s", Id_4==Id4s<long double>(3) && (Id4s<long double>(nsz) || Tsr4s)==Tsr4s && (Tsr4s || Id4s<long double>(nsz))==Tsr4s);
  else result *= (Id_4==Id4s<long double>(3) && (Id4s<long double>(nsz) || Tsr4s)==Tsr4s && (Tsr4s || Id4s<long double>(nsz))==Tsr4s);

  t6.save("tensor4.res");
  tensor4<long double> ncd(t6.dim1(), t6.dim2(), t6.dim3(), t6.dim4());
  ncd.read("tensor4.res");
  if (detail) affiche("read/write", ncd==t6);
  else result *= (ncd==t6);

  cout << endl;  

  cout << "============================================================== \n";
  if (result) cout<< "                 4th order tensor test passed \n";
  else cout << "                 4th order tensor test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
