/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 2.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006,2007,2008,2009 COLLARD Christophe
 * copyright © 2003,2004 CREUSE Emmanuel
 * copyright © 2003,2004 MERCIER Denis
 * copyright © 2003,2004,2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2003,2004,2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 ***************************************************************/

/*
    vectors-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type vector-test.
#endif

#if !defined(__VECTORS_TEST_H)
#define _vectors_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__COLORS_H)
#include "colors.h"
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__AFFICHE_H)
#include "tests/affiche.h"
#endif

using namespace mol;


//==========================
int test_vector (int detail)
//==========================
{
  int result=1;
  vector<long double> u(9), v(9), w(9), x, y, z(9), zz, yy(9), zal(9,true), zal2(9,false);
  vector<long double> cst(7), cst1(7,false,5), cst2(7,true,2.5);

  for (int i=1; i<=7; i++)
    cst[i] = 2.5;

  // computes vectors u, v and w
  u[1]=2.; u[2]=7.25; u[3]=14.67; u[4]=234.2; u[5]=0.; u[6]=0.543378; u[7]=13.; u[8]=0.; u[9]=45.;

  v[1]=0.; v[2]=34.5; v[3]=70; v[4]=234.0; v[5]=111.; v[6]=233; v[7]=44.; v[8]=20.; v[9]=170.;

  w[1]=2.; w[2]=41.75; w[3]=84.67; w[4]=468.2; w[5]=111.; w[6]=233.543378; w[7]=57.; w[8]=20.; w[9]=215.;

  //  cout << w-(u+v); // -> provoque une erreur d'arrondi en long double mais pas en double!

  // starts tests

  if (detail) affiche ("dim()", u.dim()==9);
  else result *= (u.dim()==9);

  if (detail) affiche ("operator !", !(!u) && !x);
  else result *= (!(!u) && !x);

  if (detail) affiche ("operator !=", (u!=v));
  else result *= (u!=v);

  if (detail) affiche ("operator []", u[2]==7.25);
  else result *= (u[2]==7.25);

  if (detail) affiche ("operator ==", !(u==v) && z==zal);
  else result *= !(u==v) && z==zal;

  x = u;
  if (detail) affiche ("operator !=", (!(u!=x)));
  else result *= (!(u!=x));

  if (detail) affiche ("operator ==", (u==x));
  else result *= (u==x);

  if (detail) affiche ("constructor", cst==cst2);
  else result *= cst==cst2;

  x[1] = 23;
  z[1]=2; z[2]=7.25; z[3]=14.67; z[4]=234.2; z[5]=0; z[6]=0.543378; z[7]=13; z[8]=0; z[9]=45;

  vector<long double> ual, wal;
  ual.assign(9);
  ual[1]=2.; ual[2]=7.25; ual[3]=14.67; ual[4]=234.2; ual[5]=0.; ual[6]=0.543378; ual[7]=13.; ual[8]=0.; ual[9]=45.;

  if (detail) affiche("assign", (ual==z));
  else result *= (ual==z);

  if (detail) affiche("operator =", (u==z));
  else result *= (u==z);

  wal=9;
  wal[1]=2.; wal[2]=7.25; wal[3]=14.67; wal[4]=234.2; wal[5]=0.; wal[6]=0.543378; wal[7]=13.; wal[8]=0.; wal[9]=45.;
  if (detail) affiche("operator = (memory allocation)", (wal==z));
  else result *= (wal==z);

  vector<double> veq1(9), veq2(9), veq3, veq4;
  for (int i=1; i<=9; i++)
    { veq1[i] = 2*i/3.;
      veq2[i] = 1/(1.*i);
    }
  veq3 = veq1 + veq2;
  veq4 = &(veq1+veq2);
  vector<double> veq5 = &veq1;
  if (detail) affiche("operator =& (destructive copy for temporary objects)", veq3==veq4 && veq5==veq3-veq2 && !veq1);
  else result *= (veq3==veq4 && veq5==veq3-veq2 && !veq1);

  vector<long double> vdel(9), vnew(5), vcp, vcopy, vcpy, empty;
  for (int i=1; i<=9; i++)
    vdel[i] = i;
  vcpy = vcopy = vdel;
  vnew &= vcopy;
  vcp &= vcopy;
  vcpy &= empty;
  if (detail) affiche ("operateur &= (copy without size check)", vnew==vdel && vcp==vdel && vcopy==vdel && !vcpy && !empty);
  else result *= (vnew==vdel && vcp==vdel && vcopy==vdel && !vcpy && !empty);

  vector<double> vop1(9), vop2(9), vop3, vop4;
  for (int i=1; i<=9; i++)
    { vop1[i] = 2*i/3.;
      vop2[i] = 1/(1.*i);
    }
  vop3 = vop1 + vop2;
  vop4 &= &(vop1+vop2);
  vector<double> vop5 = vop1;
  vector<double> vop6, vop7, vop8, vop9(2);
  vop5 &=& vop7;
  vop6 &=& vop7;
  vop8 = vop3;
  vop9 &=& vop8;
  if (detail) affiche("operator &=& (detructive copy for temporary objects without size check)", vop3==vop4 && !vop5 && !vop6 && vop9==vop3 && !vop8);
  else result *= (vop3==vop4 && !vop5 && !vop6 && vop9==vop3 && !vop8);

  if (detail) affiche ("operator +", (w == u+v));
  else result *= (w == u+v);

  x[1]=2.; x[2]=-27.25; x[3]=-55.33; x[4]=0.2; x[5]=-111.; x[6]=-232.456622; x[7]=-31.; x[8]=-20.; x[9]=-125.;

  if (detail) affiche ("operator -", x-u+v == yy);
  else result *= ( x-u+v == yy);

  if (detail) affiche("scalar product", (u*v-64428.432074<1e-6)&&(sqrt(u*u) - u.norm()) < epsilon);
  else result *= ((u*v-64428.432074<1e-6)&&(sqrt(u*u) - u.norm()) < epsilon);

  vector<long double> dv(1);
  dv[1] = 2;
  if (detail) affiche ("operator /", (long double) 2*(u/dv) == u);
  else result *= ( (long double) 2*(u/dv) == u);

  x=u;
  x+=v;
  if (detail) affiche("operator +=", (x==u+v));
  else result *= (x==u+v);

  x=u;
  x-=u;
  if (detail) affiche("operator -=", (x==yy));
  else result *= (x==yy);

  long double reel = 2.;
  if (detail) affiche("operator * sc/vect", (reel*u==u+u));
  else result *= (reel*u==u+u);

  if (detail) affiche("operator * vect/sc", (u*reel==u+u));
  else result *= (u*reel==u+u);

  if (detail) affiche("operator / vect/sc", (u+u)/reel==u);
  else result *= ((u+u)/reel==u);

  x=u; x*=2.;
  if (detail) affiche("operator *=", (x==u+u));
  else result *= (x==u+u);

  x=u;
  x/=2;
  z[1]=1.; z[2]=3.625; z[3]=7.335; z[4]=117.1; z[5]=0.; z[6]=0.271689; z[7]=6.5; z[8]=0.;z[9]=22.5;
  if (detail) affiche("operator /=", x==z);
  else result *=  (x==z);

  v=yy;
  v[1] = 4 ;
  v[2] = -1 ;
  v[5] = -1 ;

  v.save("vecteur.res");
  vector<long double> fvect(v.dim());
  fvect.read("vecteur.res");
  if (detail) affiche("read/write", v==fvect);
  else result *= (v==fvect);

  string filename="vector.res";
  v.save(filename);
  vector<long double> fvect2(v.dim());
  fvect2.read(filename);
  if (detail) affiche("read/write with a string argument", v==fvect2);
  else result *= (v==fvect2);

  if (detail) affiche ("norm", (v.norm()-398.361958525158)<1e-12);
  else result *= (v.norm()-398.361958525158)<1e-12;

  vector<long double> zpermute = z;
  zpermute.permute(5,7);
  long double element = z[5];
  z[5] = z[7];
  z[7] = element;
  if (detail) affiche("permutation of 2 vector components", z==zpermute);
  else result *= (z==zpermute);

  vector<long double> upermute = u;
  permute (zpermute,upermute);
  if (detail) affiche("vector permutation (u_i <-> v_i)", u==zpermute && z==upermute);
  else result *= (u==zpermute && z==upermute);

  vector<long double> vv(3),vv1(3);
  long double ninf=4.5555;
  vv[1]=1.02;vv[2]=-1.05;vv[3]=-4.5555;
  vv1[1]=1.02;vv1[2]=1.05;vv1[3]=4.5555;
  if (detail) affiche("abs", abs(vv)==vv1);
  else result *= (abs(vv)==vv1);

  if (detail) affiche("inf norm", vv.norminf()==ninf);
  else result *= (vv.norminf()==ninf);

  vector<long double> reporder(5), uorder(5), vorder(5), worder(5);
  vector<int> upos(5), vpos(5), wpos(5);
  reporder[1]=-5; reporder[2]=-2; reporder[3]=0; reporder[4]=3; reporder[5]=8;
  upos[1]=1; upos[2]=2; upos[3]=3; upos[4]=4; upos[5]=5;
  uorder = reporder;
  vpos[1]=3; vpos[2]=2; vpos[3]=5; vpos[4]=1; vpos[5]=4;
  vorder[1]=3; vorder[2]=-2; vorder[3]=-5; vorder[4]=8; vorder[5]=0;
  wpos[1]=5; wpos[2]=4; wpos[3]=3; wpos[4]=2; wpos[5]=1;
  worder[1]=8; worder[2]=3; worder[3]=0; worder[4]=-2; worder[5]=-5;
  vector<int> uorder_pos = order(uorder);
  vector<int> vorder_pos = order(vorder);
  vector<int> worder_pos = order(worder);
  bool posorder = (uorder_pos == upos  &&  vorder_pos == vpos  &&  worder_pos == wpos);
  if (detail) affiche("order", reporder==uorder && reporder==vorder &&  reporder==worder && posorder);
  else result *= (reporder==uorder && reporder==vorder && reporder==worder && posorder);

  vector<long double> subu(5);
  for (int i=1; i<=5; i++)
    subu[i] = u[i+2];
  if (detail) affiche("subvector", subvector(u,3,7)==subu);
  else result *= (subvector(u,3,7)==subu);

  if (detail) affiche("merge", merge(subvector(u,1,5),subvector(u,6,9))==u);
  else result *= (merge(subvector(u,1,5),subvector(u,6,9))==u);


  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                      vector test passed" << reset;
  else cout << red << "                      vector test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
