/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2009,2010,2012 COLLARD Christophe
 * copyright © 2009,2010,2012 Centre National de la Recherche Scientifique
 * copyright © 2009,2010 Arts et Métiers ParisTech
 * copyright © 2009,2010 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2010,2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    symtensors4-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for symtensor4-test
#endif

#ifndef __symtensors4_test_hpp
#define __symtensors4_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __symmatrix_hpp
#include "MOL++/symmatrix.hpp"
#endif

#ifndef __tensors2_hpp
#include "MOL++/tensors2.hpp"
#endif

#ifndef __tensors3_hpp
#include "MOL++/tensors3.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __conversion_tools_hpp
#include "MOL++/conversion tools.hpp"
#endif

#ifndef __ABAQUS_conversion_tools_hpp
#include "MOL++/abaqus conversion tools.hpp"
#endif

#ifndef __symtensors4_hpp
#include "MOL++/symtensors4.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace mol;


//==============================
int test_symtensor4 (int detail)
//==============================
{
  bool result = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "            symmetric 4th order tensor test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  symtensor4<long double> st1(7,7,5,5), st2(3), st;
  tensor4<long double> t1(7,7,5,5), t2(3);

  bool test = true;

  if (detail) affiche ("operator !", !(!st1) && !st);
  else result *= (!(!st1) && !st);

  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=5; k++)
	for (int l=1; l<=5; l++)
	  st1 (i,j,k,l) = (long double) (i * j) / (long double) (k + l);

  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=5; k++)
	for (int l=1; l<=5; l++)
	  { t1 (i,j,k,l) = (long double) (i * j) / (long double) (k + l);
	    test *= abs (t1(i,j,k,l) - st1(i,j,k,l)) < epsilon;
	  }

  if (detail) affiche ("operator (,,,)", test);
  else result *= test;

  if (detail) affiche ("dim1 dim2 dim3 dim4", st1.dim1()==7 && st1.dim2()==7 && st1.dim3()==5 && st1.dim4()==5);
  else result *= st1.dim1()==7 && st1.dim2()==7 && st1.dim3()==5 && st1.dim4()==5;

  symtensor4<long double> st6, st10, st11(3);
  st6.assign(7,7,5,5);
  if (detail) affiche ("assign", st6.dim1()==7 && st6.dim2()==7 && st6.dim3()==5 && st6.dim4()==5);
  else result *= st6.dim1()==7 && st6.dim2()==7 && st6.dim3()==5 && st6.dim4()==5;

  tensor4<long double> t10(3);
  st10.create(3);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  st11 (i,j,k,l) = t10(i,j,k,l) = 2 * (i + j) / (k + l);
  for (int i=1; i<=6; i++)
    st10[i] = st11[i]; 
  if (detail) affiche ("create", st10==st11);
  else result *= st10==st11;

  if (detail) affiche ("operator == symtensor4/symtensor4", (st1==st1) && !(st1==st2));
  else result *= ((st1==st1) && !(st1==st2));

  if (detail) affiche ("operator == symtensor4/tensor4", st1==t1);
  else result *= (st1==t1);

  if (detail) affiche ("operator == tensor4/symtensor4", t1==st1);
  else result *= (t1==st1);

  if (detail) affiche ("operator != symtensor4/symtensor4", !(st1!=st1) && st1!=st2);
  else result *= (!(st1!=st1) && st1!=st2);

  if (detail) affiche ("operator != symtensor4/tensor4", st2!=t1);
  else result *= (st2!=t1);

  if (detail) affiche ("operator != tensor4/symtensor4", t1!=st2);
  else result *= (t1!=st2);

  symtensor4<long double> st0(7,7,5,5,true,1), st00(5,5,7,7,true,1);
  tensor4<long double> t0(7,7,5,5,true,1), t00(5,5,7,7,true,1);

  if (detail) affiche ("constructor with default value", st0==t0 && st00==t00);
  else result *= (st0==t0 && st00==t00);

  tensor4<long double> tsrs = st1;
  if (detail) affiche ("cast operator () symtensor4 -> tensor4", t1==tsrs);
  else result *= (t1==tsrs);

  symtensor4<long double> stsr (t1);
  matrix<long double> stsr_mat = (matrix<long double>) stsr;
  if (detail) affiche ("cast operator () symtensor4 -> matrix", symtensor2matrix(t1)==stsr_mat);
  else result *= (symtensor2matrix(t1)==stsr_mat);

  if (detail) affiche ("cast constructor with matrix", stsr == symtensor4<long double> (stsr_mat));
  else result *= (stsr == symtensor4<long double> (stsr_mat));

  symmatrix<long double> smat (6,6);
  for (int i=1; i<=6; i++)
    for (int j=i; j<=6; j++)
      smat (i,j) = 2*i + 5*j;
  if (detail) affiche ("cast constructor with symmetric matrix", matrix2symtensor (smat) == symtensor4<long double> (smat));
  else result *= (matrix2symtensor (smat) == symtensor4<long double> (smat));

  symtensor4<long double> t1_copy = t1;
  if (detail) affiche ("copy constructor", t1 == t1_copy);
  else result *= (t1 == t1_copy);

  symtensor4<long double> t1_temp = &(t1+t1-t1);
  if (detail) affiche ("constructor with temporary objects", t1 == t1_temp);
  else result *= (t1 == t1_temp);


  /*
  tensor3<long double> tens3 (5,7,2);
  for (int j=1; j<=5; j++)
    for (int k=1; k<=7; k++)
      for (int l=1; l<=2; l++)
	tens3(j,k,l) = 2+j/(1.*k)*l;
  tensor4<long double> tens4(3,5,7,2);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=2; l++)
	  tens4[i][j][k][l] = 2*i - 5*j + 7*k/(1.*l);
  if (detail) affiche ("operator []", t1[2]==tens3 && t4==tens4);
  else result *= (t1[2]==tens3 && t4==tens4);
  */

  st = st1;

  test = (st==st1);
  st(1,1,1,1) = -10;
  test *= (st1!=st);
  symtensor4<long double> st3 (7,7,5,5);
  st3 = st1;
  test *= (st1==st3);
  if (detail) affiche ("operator = symtensor4/symtensor4", test);
  else result *= (test);

  symtensor4<long double> st4;
  st4 = t1;
  if (detail) affiche ("operator = symtensor4/tensor4", st1==st4);
  else result *= (st1==st4);

  symtensor4<long double> ntsr1(3,3,3,3), ntsr2(3,3,3,3), ntsr3, ntsr4, ntsr0(3,3,3,3);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  { ntsr1(i,j,k,l) += 20*i/3. - 3*j/(1.*k) + 3.*l;
	    ntsr2(i,j,k,l) += 3*i - j + 1/(1.*k) + 3.*l;
	  }
  ntsr3 = ntsr1 + ntsr2;
  ntsr4 = &(ntsr1+ntsr2);
  ntsr0 = &(ntsr1+ntsr2);
  symtensor4<long double> ntsr5 = &(ntsr1+ntsr2);
  if (detail) affiche("operator = (destructive copy for temporary objects)", ntsr3==ntsr0 && ntsr3==ntsr4 && ntsr3==ntsr5);
  else result *= (ntsr3==ntsr0 && ntsr3==ntsr4 && ntsr3==ntsr5);

  symtensor4<long double> ntsr6;
  tensor4<long double> ts1 = ntsr1();
  tensor4<long double> ts2 = ntsr2();

  ntsr6 = &(ts1+ts2);
  symtensor4<long double> ntsr7 = &(ntsr1+ntsr2);
  if (detail) affiche("operator = (destructive copy for temporary objects) symtensor4/tensor4", ntsr3==ntsr6 && ntsr3==ntsr7);
  else result *= (ntsr3==ntsr6 && ntsr3==ntsr7);

  symtensor4<long double> mtrx, mtrx2(3,true,5), mtrx3(3,true,36), mtrx4, mtrx5(3,3,3,3), mtrx6(3,3,3,3), mtrx0(3,3,3,3), mtrx7, mtrx8;
  mtrx = mtrx8 = ntsr1;
  mtrx2 &= mtrx;
  mtrx3 &= mtrx4;
  mtrx5 &= ntsr1;
  mtrx6 &= ntsr1;
  mtrx0 &= ntsr1;
  mtrx7 &= mtrx8;
  if (detail) affiche ("operator &= (copy without size check)", mtrx2==ntsr1 && mtrx.dim1() && !mtrx3 && mtrx7==ntsr1 && mtrx5==ntsr1 && mtrx6==ntsr1 && mtrx0==ntsr1);
  else result *= (mtrx2==ntsr1 && mtrx.dim1() && !mtrx3 && mtrx7==ntsr1 && mtrx5==ntsr1 && mtrx6==ntsr1 && mtrx0==ntsr1);

  symtensor4<long double> mtrx9, mtrx10(3,true,4);
  tensor4<long double> tmtrx;
  mtrx9 &= t1;
  mtrx10 &= tmtrx;

  if (detail) affiche ("operator &= (copy without size check) symtensor4/tensor4", mtrx9==st1 && !mtrx10);
  else result *= (mtrx9==st1 && !mtrx10);

  symtensor4<long double> mtrx11, mtrx12;
  mtrx = mtrx8 = ntsr1;
  mtrx2 &=& mtrx;
  mtrx3 &=& (ntsr1+ntsr1);
  mtrx4 &=& mtrx;
  mtrx5  &=& mtrx11;
  mtrx12 &=& mtrx8;
  if (detail) affiche ("operator &= (destructive copy for temporary objects with no size check)", mtrx2==ntsr1 && !mtrx && mtrx3==ntsr1+ntsr1 && !mtrx4 && !mtrx5 && mtrx12==ntsr1 && !mtrx8);
  else result *= (mtrx2==ntsr1 && !mtrx && mtrx3==ntsr1+ntsr1 && !mtrx4 && !mtrx5 && mtrx12==ntsr1 && !mtrx8);

  tensor4<long double> tsre, tsrei;
  mtrx &=& (t1+t1);
  tsrei = t1;
  mtrx2 &=& tsrei;
  mtrx3 &= mtrx;
  mtrx3 &=& tsre;
  if (detail) affiche ("operator &= (destructive copy for temporary objects with no size check) symtensor4/tensor4", mtrx==t1+t1 && !tsrei && mtrx2==t1 && !mtrx3);
  else result *= (mtrx==t1+t1 && !tsrei && mtrx2==t1 && !mtrx3);

  if (detail) affiche ("operator + symtensor4/symtensor4", st1+st1==t1+t1);
  else result *= (st1+st1==t1+t1);

  tensor4<long double> t3 (7,7,5,5);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=5; k++)
	for (int l=1; l<=5; l++)
	  t3 (i,j,k,l) = (long double) (i * l) / (long double) (k + j);

  if (detail) affiche ("operator + symtensor4/tensor4", st1+t3==t1+t3);
  else result *= (st1+t3==t1+t3);

  if (detail) affiche ("operator + tensor4/symtensor4", t3+st1==t3+t1);
  else result *= (t3+st1==t3+t1);

  if (detail) affiche ("operator - symtensor4/symtensor4", t1==mtrx-st1);
  else result *= (t1==mtrx-st1);

  if (detail) affiche ("operator - symtensor4/tensor4", t1-t3==st1-t3);
  else result *= (t1-t3==st1-t3);

  if (detail) affiche ("operator - tensor4/symtensor4", t3-t1==t3-st1);
  else result *= (t3-t1==t3-st1);

  st3 = st1;
  st3 += st1;
  if (detail) affiche ("operator += symtensor4/symtensor4", st3==t1+t1);
  else result *= (st3==t1+t1);

  st3 += t1;
  if (detail) affiche ("operator += symtensor4/tensor4", st3==(long double)3*t1);
  else result *= (st3==(long double)3*t1);

  st3 -= st1;
  if (detail) affiche ("operator -= symtensor4/symtensor4", st3==t1+t1);
  else result *= (st3==t1+t1);

  st3 -= t1;
  if (detail) affiche ("operator -= symtensor4/tensor4", st3==st1);
  else result *= (st3==st1);

  if (detail) affiche ("operator | symtensor4/symtensor4", abs((t1|t1)-(st1|st1))<epsilon);
  else result *= (abs((t1|t1)-(st1|st1))<epsilon);

  if (detail) affiche ("operator | symtensor4/tensor4", abs((t1|t3)-(st1|t3))<epsilon);
  else result *= (abs((t1|t3)-(st1|t3))<epsilon);

  if (detail) affiche ("operator | tensor4/symtensor4", abs((t3|t1)-(t3|st1))<epsilon);
  else result *= (abs((t3|t1)-(t3|st1))<epsilon);

  tensor4<long double> t5(5,5,9,9);
  symtensor4<long double> st12(5,5,9,9);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=9; k++)
	for (int l=1; l<=9; l++)
	  st12(i,j,k,l) = t5 (i,j,k,l) = 2 * (i + j) / (k + l);

  if (detail) affiche ("operator || symtensor4/symtensor4", (st1||st12) == (t1||t5));
  else result *= ((st1||st12) == (t1||t5));

  if (detail) affiche ("operator || symtensor4/tensor4", (st1||t5) == (t1||t5));
  else result *= ((st1||t5) == (t1||t5));

  tensor4<long double> t6(6,6,7,7);
  symtensor4<long double> st13(6,6,7,7);
  for (int i=1; i<=6; i++)
    for (int j=1; j<=6; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=7; l++)
	  st13(i,j,k,l) = t6 (i,j,k,l) = 2 * (i + j) / (k + l);

  if (detail) affiche ("operator || tensor4/symtensor4", (t6||st1) == (t6||t1));
  else result *= ((t6||st1) == (t6||t1));

  st3 = st1;
  st3 *= 5;
  if (detail) affiche ("operator *= (symtensor4/scalar)", st3==st1+st1+st1+st1+st1);
  else result *= (st3==st1+st1+st1+st1+st1);

  st3 = st1*(long double)3;
  if (detail) affiche ("operator * (symtensor4/scalar)", st3==st1+st1+st1);
  else result *= (st3==st1+st1+st1);

  st3 = (long double) 5*t1;
  if (detail) affiche ("operator * (scalar/symtensor4)", st3==st1+st1+st1+st1+st1);
  else result *= (st3==st1+st1+st1+st1+st1);

  long double value = 0.125;
  vector<long double> vt2(5);
  for (int k=1; k<=5; k++) vt2[k] = value*k;
  if (detail) affiche ("operator * (symtensor4/vector)", st1*vt2==t1*vt2);
  else result *= (st1*vt2==t1*vt2);

  vector<long double> vt3(7);
  for (int k=1; k<=7; k++) vt3[k] = value*k;
  if (detail) affiche ("operator * (vector/symtensor4)", vt3*st1==vt3*t1);
  else result *= (vt3*st1==vt3*t1);

  if (detail) affiche ("operator | (symtensor4/vector)", (st1|vt2)==(t1|vt2));
  else result *= ((st1|vt2)==(t1|vt2));

  if (detail) affiche ("operator | (vector/symtensor4)", (vt3|st1)==(vt3|t1));
  else result *= ((vt3|st1)==(vt3|t1));

  if (detail) affiche ("sum symtensor4 * vector (i), i = 1->4 :", (tensor_sum(st1,vt3,1) == vt3*t1)  &&  (tensor_sum(t1,vt3,2) == vt3*t1)  &&  (tensor_sum(t1,vt2,3) == t1*vt2) &&  (tensor_sum(t1,vt2,4) == t1 * vt2) );
  else result *= ((tensor_sum(st1,vt3,1) == vt3*t1)  &&  (tensor_sum(t1,vt3,2) == vt3*t1)  &&  (tensor_sum(t1,vt2,3) == t1*vt2) &&  (tensor_sum(t1,vt2,4) == t1 * vt2) );

  tensor2<long double> t2s(5,5);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=5; j++)
      t2s(i,j) = i*i - 2*j;

  if (detail) affiche ("operator || (symtensor4/tensor2)", (t1||t2s)==(st1||t2s));
  else result *= ((t1||t2s)==(st1||t2s));

  tensor2<long double> t2ss(7,7);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=5; j++)
      t2ss(i,j) = i*i - 2*j;

  if (detail) affiche ("operator || (tensor2/symtensor4)", (t2ss||t1)==(t2ss||st1));
  else result *= ((t2ss||t1)==(t2ss||st1));

  symtensor2<long double> st1s(5,5);
  for (int i=1; i<=5; i++)
    for (int j=i; j<=5; j++)
      st1s(i,j) = (22.5+j)*i + i/j;

  symtensor2<long double> st2s(7,7);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      st2s(i,j) = i*i - 2*j;

  if (detail) affiche ("operator || (symtensor4/symtensor2)", (t1||st1s)==(st1||st1s));
  else result *= ((t1||st1s)==(st1||st1s));

  if (detail) affiche ("operator || (symtensor2/symtensor4)", (st2s||t1)==(st2s||st1));
  else result *= ((st2s||t1)==(st2s||st1));

  tensor4<long double> tmat (5,5,7,7);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=7; l++)
	  tmat(i,j,k,l) = st1s(i,j) * st2s(k,l);

  if (detail) affiche ("operator ^ (symtensor2/symtensor2)", tmat == (st1s^st2s));
  else result *= (tmat == (st1s^st2s));

  tensor3<long double> tsr3_1(4,5,5), tsr3_2(4,7,7);
  for (int i=1; i<=5; i++)
    for (int j=i; j<=5; j++)
      for (int n=1; n<=4; n++)
	tsr3_1(n,i,j) = tsr3_1(n,j,i) = 3*n/i + 2*j/n;
  for (int i=1; i<=7; i++)
    for (int j=i; j<=7; j++)
      for (int n=1; n<=4; n++)
  	tsr3_2(n,i,j) = tsr3_2(n,j,i) = 3*n/i + 2*j/n;
  tensor4<long double> tsr4_result = (tsr3_1 ^ tsr3_2);
  symtensor4 <long double> stsr4_result = (tsr3_1 ^ tsr3_2);

  if (detail) affiche ("operator tensor3 ^ tensor3", tsr4_result == stsr4_result);
  else result *= (tsr4_result == stsr4_result);
  
  tensor3<long double> to3(3,7,7);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=3; k++)
	to3(k,i,j) = k * (i*j) / (i+j);

  if (detail) affiche ("operator || tensor3/symtensor4", (to3||t1) == (to3||st1));
  else result *= ((to3||t1) == (to3||st1));

  tensor3<long double> t3o(3,5,5);
  for (int n=1; n<=3; n++)
    for (int i=1; i<=5; i++)
      for (int j=1; j<=5; j++)
	t3o(n,i,j) = n * (i*j) / (i+j);
  if (detail) affiche ("operator || symtensor4/tensor3", (t1||t3o) == (st1||t3o));
  else result *= ((t1||t3o) == (st1||t3o));

  int nsz = 12;
  tensor4<long double> Id_4 = Id4s<long double>(nsz);
  symtensor4<long double> Id_4s = Id4sym<long double>(nsz);
  if (detail) affiche("Id4sym", Id_4==Id_4s);
  else result *= (Id_4==Id_4s);

  matrix<long double> P(3,3);
  matrix<long double> passlg(3,3); // orthogonal matrix
  tensor4<long double> C(3);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      P(i,j) = (2.52*i - 1.25*j + 25 * (i==j)) * 1E-2;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  C(i,j,k,l) = 2 * (i + j) / (k * l);
  long double phi1=173.464, phi=104.504, phi2=34.5;
  passlg(1,1) =  cos(phi1) * cos(phi2)  -  sin(phi1) * cos(phi) * sin(phi2);
  passlg(1,2) = -cos(phi1) * sin(phi2)  -  sin(phi1) * cos(phi) * cos(phi2);
  passlg(1,3) =  sin(phi1) * sin(phi);
  passlg(2,1) =  sin(phi1) * cos(phi2)  +  cos(phi1) * cos(phi) * sin(phi2);
  passlg(2,2) = -sin(phi1) * sin(phi2)  +  cos(phi1) * cos(phi) * cos(phi2);
  passlg(2,3) = -cos(phi1) * sin(phi);
  passlg(3,1) =  sin(phi)  * sin(phi2);
  passlg(3,2) =  sin(phi)  * cos(phi2);
  passlg(3,3) =  cos(phi);
  symtensor4<long double> Cs = C;
  if (detail) affiche ("change basis", change_basis (passlg, C) == change_basis (passlg, Cs)  &&  change_basis (P, C) == change_basis (P, Cs));
  else result *= (change_basis (passlg, C) == change_basis (passlg, Cs)  &&  change_basis (P, C) == change_basis (P, Cs));

  symtensor4<long double> stint (7,7,5,5);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=5; k++)
	for (int l=1; l<=5; l++)
	  stint(i,j,k,l) = i+j+k+l;
  stint.save("symtensor4.res");
  symtensor4<long double> ncd(stint.dim1(), stint.dim2(), stint.dim3(), stint.dim4());
  ncd.read("symtensor4.res");
  if (detail) affiche("read/write", ncd==stint);
  else result *= (ncd==stint);

  matrix<long double> mat (6,6);
  for (int i=1; i<=6; i++)
    for (int j=1; j<=6; j++)
      if (i==j) mat(i,j) = 20*i + 30*j;
      else mat(i,j) = 2*i + 3*j;
  symtensor4<long double> Tsquare (abaqus::matrix2symtensor (mat));
  tensor4<long double> T4square = abaqus::matrix2symtensor (mat);
  symtensor4<long double> Tsquare_inv = T4square.inv();
  if (detail) affiche("inv", Tsquare.inv()==Tsquare_inv);
  else result *= (Tsquare.inv()==Tsquare_inv);

  if (detail) affiche("gauss", gauss(Tsquare)==Tsquare_inv);
  else result *= (gauss(Tsquare)==Tsquare_inv);

  if (detail) affiche ("p-norm (with p=2)", abs (stsr.p_norm (2) - stsr_mat.p_norm(2)) < epsilon * stsr.p_norm (2));
  else result *= (abs (stsr.p_norm (2) - stsr_mat.p_norm(2)) < epsilon * stsr.p_norm (2));

  string filename = "symtenseur4.res";
  stint.save(filename);
  symtensor4<long double> ncd2(stint.dim1(), stint.dim2(), stint.dim3(), stint.dim4());
  ncd2.read(filename);
  if (detail) affiche("read/write with a string argument", ncd2==stint);
  else result *= (ncd2==stint);

  cout << endl;  

  cout << "============================================================== \n";
  if (result) cout << green << "            symmetric 4th order tensor test passed" << reset;
  else cout << red << "            symmetric 4th order tensor test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
