/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006,2009,2012 COLLARD Christophe
 * copyright © 2003,2004,2005 CREUSE Emmanuel
 * copyright © 2003,2004,2005,2006,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006,2009 Arts et Métiers ParisTech
 * copyright © 2003,2004,2005,2006 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2003,2004,2005,2006,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2003,2004,2005,2006 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tests-maths belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type tests-MOL++
#endif

#ifndef __iostream
#include <iostream>
#endif

#ifndef __fstream
#include <fstream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __maths_test_hpp
#include "maths-test.hpp"
#endif

#ifndef __vectors_test_hpp
#include "vectors-test.hpp"
#endif

#ifndef __matrix_test_hpp
#include "matrix-test.hpp"
#endif

#ifndef __symmatrix_test_hpp
#include "symmatrix-test.hpp"
#endif

#ifndef __spmatrix_test_hpp
#include "spmatrix-test.hpp"
#endif

#ifndef __linear_systems_test_hpp
#include"linear systems-test.hpp"
#endif

#ifndef __tensors2_test_hpp
#include "tensors2-test.hpp"
#endif

#ifndef __symtensors2_test_hpp
#include "symtensors2-test.hpp"
#endif

#ifndef __tensors3_test_hpp
#include "tensors3-test.hpp"
#endif

#ifndef __tensors4_test_hpp
#include "tensors4-test.hpp"
#endif

#ifndef __symtensors4_test_hpp
#include "symtensors4-test.hpp"
#endif

#ifndef __conversion_tools_test_hpp
#include "conversion tools-test.hpp"
#endif

#ifndef __ABAQUS_conversion_tools_test_hpp
#include "abaqus conversion tools-test.hpp"
#endif

#ifndef __polynoms_test_hpp
#include "polynoms-test.hpp"
#endif

#ifndef __legendre_test_hpp
#include "legendre-test.hpp"
#endif

#ifndef __integration_test_hpp
#include "integration-test.hpp"
#endif

#ifndef __combinatorial_analysis_test_hpp
#include "combinatorial analysis-test.hpp"
#endif

#ifndef __gaussian_white_noise_test_hpp
#include "gaussian white noise-test.hpp"
#endif

/*#if !defined(__ODE_TEST_H)
#include "ode-test.h"
#endif
*/
using namespace std;

main()
{
  bool detail; // parameter to write/hide test procedure
  bool result = true;
  clock_t start, end;
  clock_t start_main, end_main;

  result = 1;

  detail = 0;
  start_main = start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------maths--------------------------- \n";
    //=======================================================================
  result *= test_maths (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------vector--------------------------- \n";
    //=======================================================================
  result *= test_vector (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------matrix--------------------------- \n";
    //=======================================================================
  result *= test_matrix (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------symmetric matrix---------------------- \n";
    //=======================================================================
  result *= test_symmatrix (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-----------------------sparse matrix----------------------- \n";
    //=======================================================================
  result *= test_spmatrix (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-----------------------linear systems---------------------- \n";
    //=======================================================================
  result *= test_linear_systems (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------2nd order tensors--------------------- \n";
    //=======================================================================
  result *= test_tensor2 (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "----------------symmetric 2nd order tensors---------------- \n";
    //=======================================================================
  result *= test_symtensor2 (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------3rd order tensors--------------------- \n";
    //=======================================================================
  result *= test_tensor3 (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------4th order tensor---------------------- \n";
    //=======================================================================
  result *= test_tensor4 (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout << "----------------symmetric 4th order tensor----------------- \n";
    //=======================================================================
  result *= test_symtensor4 (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "----------------------conversion tools---------------------- \n";
    //=======================================================================
  result *= test_conversion_tools (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "------------------abaqus conversion tools------------------- \n";
    //=======================================================================
  result *= test_abaqus_conversion_tools (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "--------------------------polynom--------------------------- \n";
    //=======================================================================
  result *= test_polynom (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  /*
  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "------------------------function---------------------------- \n";
    //=======================================================================
  result *= test_function (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;
  */

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "--------------------------Legendre-------------------------- \n";
    //=======================================================================
  result *= test_legendre (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------------integration-------------------------- \n";
    //=======================================================================
  result *= test_integration (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------combinatorial analysis--------------------- \n";
    //=======================================================================
  result *= test_combinatorial_analysis (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  /*
  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-------------ordinary differential equations---------------- \n";
    //=======================================================================
  result *= test_ode (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-------------ordinary differential equations 1D------------- \n";
    //=======================================================================
  result *= test_ode_1D (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-------------ordinary differential equations 2D------------- \n";
    //=======================================================================
  result *= test_ode_2D (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "----------------non linear equations solving---------------- \n";
    //=======================================================================
  //  result *= test_NLE (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;
  */

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "------------------gaussian white noise---------------------- \n";
    //=======================================================================
  result *= test_gaussian_white_noise (detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  cout << endl;

  end_main = clock();

  cout << "============================================================== \n";
  if (result) cout << green << "-------OK-------------end of MOL++ tests-------------OK-------" << reset;
  else cout << red << "-----FAILED-----------end of MOL++ tests-----------FAILED-----" << reset;
  cout << "============================================================== \n";

  cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
}


