/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2003,2004,2005,2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2003,2004,2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2003,2004,2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2003,2004,2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tensors3-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for tensor3-test
#endif

#ifndef __tensors3_test_hpp
#define __tensors3_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __symmatrix_hpp
#include "MOL++/symmatrix.hpp"
#endif

#ifndef __tensors2_hpp
#include "MOL++/tensors2.hpp"
#endif

#ifndef __tensors3_hpp
#include "MOL++/tensors3.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace mol;

//===========================
int test_tensor3 (int detail)
//===========================
{
  int result=1;

  tensor3<long double> t1(3,5,7), t2(3,5,7), t3, t4(3,5,7), t5(3,5,7);

  bool test = true;
  int size = 0;

  if (detail) affiche ("operator !", !(!t1) && !t3);
  else result *= (!(!t1) && !t3);


  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	{
	  t1(i,j,k) = i+j/(1.*k);
	  t4(i,j,k) = 2*i-5*j+7*k;
	}
  if (detail) affiche ("operator (,,)", t1(3,3,3)==4. && t1(1,5,4)==2.25);
  else result *= (t1(3,3,3)==4. && t1(1,5,4)==2.25);

  if (detail) affiche ("dim1 dim2 dim3", t1.dim1()==3 && t1.dim2()==5 && t1.dim3()==7);
  else result *= t1.dim1()==3 && t1.dim2()==5 && t1.dim3()==7;

  tensor3<long double> t6, t9;
  t6.assign(5,2,4);
  if (detail) affiche ("assign", t6.dim1()==5 && t6.dim2()==2 && t6.dim3()==4);
  else result *= t6.dim1()==5 && t6.dim2()==2 && t6.dim3()==4;

  t9.create(5);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=2; j++)
      for (int k=1; k<=4; k++)
	t6 (i,j,k) = i - 2*j + 3*k;
  for (int i=1; i<=5; i++)
    t9[i] = t6[i]; 
  if (detail) affiche ("create", t9==t6);
  else result *= t9==t6;

  matrix<long double> matens (5,7);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=7; j++)
      matens(i,j) = 2+i/(1.*j);
  int resultat = (t1[2]==matens);
  matens (1,1) = -1234;
  tensor3<long double> t1b(2,5,7);
  t1b(2,3,5) = 874/29.+47;
  if (detail) affiche ("operator []", resultat*(t1[2]!=matens) && (t1b[2][3][5]==t1b(2,3,5)));
  else result *= (resultat*(t1[2]!=matens) && (t1b[2][3][5]==t1b(2,3,5)));

  
  if (detail) affiche ("operator ==", (t1==t1) && !(t1==t4));
  else result *= ((t1==t1) && !(t1==t4));

  if (detail) affiche ("operator !=", !(t1!=t1) && t1!=t4);
  else result *= (!(t1!=t1) && t1!=t4);

  tensor3<long double> mtc(7,7,7), mtc2(7,7,7,true,-4.32), mtc3(7), mtc4(7,true,-4.32);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=7; k++)
	mtc(i,j,k) = mtc3(i,j,k) = -4.32;
  if (detail) affiche ("constructor", mtc==mtc2 && mtc==mtc3 && mtc==mtc4);
  else result *= mtc==mtc2 && mtc==mtc3 && mtc==mtc4;

  t2 = t1;
  resultat = (t1==t2);
  t1(1,1,1) = -10;
  resultat *= (t1!=t2);
  t3=t1;
  if (detail) affiche ("operator =", resultat*(t1==t3));
  else result *= (resultat*(t1==t3));

  tensor3<long double> ntsr1(9,5,7), ntsr2(9,5,7), ntsr3, ntsr4, ntsr0(9,5,7);
  for (int i=1; i<=9; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	{ ntsr1(i,j,k) = 20*i/3. - 3*j/(1.*k);
	  ntsr2(i,j,k) = 3*i - j + 1/(1.*k);
	}
  ntsr3 = ntsr1 + ntsr2;
  ntsr4 = &(ntsr1+ntsr2);
  ntsr0 = &(ntsr1+ntsr2);
  tensor3<long double> ntsr5 = &(ntsr1+ntsr2);
  if (detail) affiche("operator = (destructive copy for temporary objects)", ntsr3==ntsr0 && ntsr3==ntsr4 && ntsr3==ntsr5);
  else result *= (ntsr3==ntsr0 && ntsr3==ntsr4 && ntsr3==ntsr5);

  tensor3<long double> mtrx, mtrx2(2,3,5), mtrx3(12,24,36), mtrx4, mtrx5(9,5,12), mtrx6(9,11,12), mtrx7, mtrx8;
  mtrx = mtrx8 = ntsr1;
  mtrx2 &= mtrx;
  mtrx3 &= mtrx4;
  mtrx5 &= ntsr1;
  mtrx6 &= ntsr1;
  mtrx7 &= mtrx8;
  if (detail) affiche ("operator &= (copy without size check)", mtrx2==ntsr1 && mtrx.dim1() && !mtrx3 && mtrx7==ntsr1 && mtrx5==ntsr1 && mtrx6==ntsr1);
  else result *= (mtrx2==ntsr1 && mtrx.dim1() && !mtrx3 && mtrx7==ntsr1 && mtrx5==ntsr1 && mtrx6==ntsr1);

  tensor3<long double> mtrx9, mtrx10;
  mtrx = mtrx8 = ntsr1;
  mtrx2 &=& mtrx;
  mtrx3 &=& (ntsr1+ntsr1);
  mtrx4 &=& mtrx;
  mtrx5  &=& mtrx10;
  mtrx9 &=& mtrx8;
  if (detail) affiche ("operator &= (destructive copy for temporary objects with no size check)", mtrx2==ntsr1 && !mtrx && mtrx3==(long double) 2*ntsr1 && !mtrx4 && !mtrx5 && mtrx9==ntsr1 && !mtrx8);
  else result *= (mtrx2==ntsr1 && !mtrx && mtrx3==(long double) 2*ntsr1 && !mtrx4 && !mtrx5 && mtrx9==ntsr1 && !mtrx8);

  tensor3<long double> t7(3,5,7);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	{ t3(i,j,k) = i*0.5 + j*2.658 - k*3.12;
	  t7(i,j,k) = 4*t3(i,j,k);
	}
  if (detail) affiche ("operator +", t7==t3+t3+t3+t3);
  else result *= (t7==t3+t3+t3+t3);

  if (detail) affiche ("operator -", t3==t7-t3-t3-t3);
  else result *= (t3==t7-t3-t3-t3);

  t3 = t2;
  t3 += t1;
  if (detail) affiche ("operator +=", t3==t2+t1);
  else result *= (t3==t2+t1);
  
  t3-= t2;
  if (detail) affiche ("operator -=", t3==t1);
  else result *= (t3==t1);
 

  long double sum = 0;
  for (int i=1; i<=t1.dim1(); i++)
    for (int j=1; j<=t1.dim2(); j++)
      for (int k=1; k<=t1.dim3(); k++)
	sum += t1(i,j,k) * t4(i,j,k);
  if (detail) affiche ("operator |", (t1|t4)==sum);
  else result *= ((t1|t4)==sum);

  t3 = t2;
  t3 *= 5;
  if (detail) affiche ("operator *= (tensor/scalar)", t3==t2+t2+t2+t2+t2);
  else result *= (t3==t2+t2+t2+t2+t2);

  t3 /= 5;
  if (detail) affiche ("operator *= (tensor/scalar)", t3==t2);
  else result *= (t3==t2);

  t3 = t2 * (long double) 3;
  if (detail) affiche ("operator * (tensor/scalar)", t3==t2+t2+t2);
  else result *= (t3==t2+t2+t2);
  
  t3 = (long double) 5*t1;
  if (detail) affiche ("operator * (scalar/tensor)", t3==t1+t1+t1+t1+t1);
  else result *= (t3==t1+t1+t1+t1+t1);
  
  t3 = t3 / (long double) 5;
  if (detail) affiche ("operator / (tensor/scalar)", t3==t1);
  else result *= (t3==t1);
  
  tensor3<long double> t8(2,3,4);
  long double value = 0.125;
  for (int i=1; i<=2; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=4; k++)
	t8(i,j,k) = (17*i+j*7-25/(1.*k))*100;
  vector<long double> vt64(4);
  for (int k=1; k<=4; k++) vt64[k] = value*k;
  tensor2<long double> mat6_23, matest_23(2,3);
  for (int i=1; i<=2; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=4; k++)
	matest_23(i,j) += t8(i,j,k)*vt64[k];
  mat6_23 = t8*vt64;
  if (detail) affiche ("operator * (tensor/vector : P_kij V_j)", mat6_23==matest_23);
  else result *= (mat6_23==matest_23);
  
  vector<long double> vt62(2);
  for (int k=1; k<=2; k++) vt62[k] = value*k;
  matrix<long double> mat6_34, matest_34(3,4);
  for (int i=1; i<=2; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=4; k++)
 	matest_34(j,k) += t8(i,j,k)*vt62[i];
  mat6_34 = vt62*t8;
  if (detail) affiche ("operator * (vector/tensor : P_kij V_k)", mat6_34==matest_34);
  else result *= (mat6_34==matest_34);
  
  vector<long double> vt63(3);
  for (int k=1; k<=3; k++) vt63[k] = value*k;
  matrix<long double> mat6_24, matest_24(2,4);
  for (int i=1; i<=2; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=4; k++)
	matest_24(i,k) += t8(i,j,k)*vt63[j];
  mat6_24 = t8|vt63;
  if (detail) affiche ("operator | (vector/tensor : P_kij V_i)", mat6_24==matest_24);
  else result *= (mat6_24==matest_24);

  if (detail) affiche ("operator | (tensor/vector : P_kij V_i)", (vt63|t8)==matest_24);
  else result *= ((vt63|t8)==matest_24);

  if (detail) affiche ("sum tensor * vector (i), i = 1->3 :", (tensor_sum(t8,vt62,1) == mat6_34)  &&  (tensor_sum(t8,vt63,2) == mat6_24)  &&  (tensor_sum(t8,vt64,3) == mat6_23) );
  else result *= ((tensor_sum(t8,vt62,1) == mat6_34)  &&  (tensor_sum(t8,vt63,2) == mat6_24)  &&  (tensor_sum(t8,vt64,3) == mat6_23) );

  tensor3<long double> ts3(5,7,9);
  tensor2<long double> ts2(7,9);
  vector<long double> resp(5);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=9; k++)
	{ ts3(i,j,k) = i + 5*j - 3*k;
	  ts2(j,k) += (5*j - 7*k/3.)*i;
	}
  for (int i=1; i<=5; i++)
    for (int j=1; j<=7; j++)
      for (int k=1; k<=9; k++)
	resp[i] += ts3(i,j,k) * ts2(j,k);
  if (detail) affiche ("operator || ( tensor || matrix : P_n,ij || M_ij)", resp == (ts3||ts2));
  else result *= (resp == (ts3||ts2));

  tensor3<long double> tsm(3,5,7), tresult(2,5,7);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=5; j++)
      for (int k=1; k<=7; k++)
	tsm(i,j,k) = i/(1.*j) + k*j - i;
  for (int p=1; p<=2; p++)
    for (int i=1; i<=3; i++)
      for (int j=1; j<=5; j++)
	for (int k=1; k<=7; k++)
	  tresult(p,j,k) += matest_23(p,i) * tsm(i,j,k);
  if (detail) affiche ("operator * ( matrix * tensor : M_ij * P_jkl)", tresult==matest_23*tsm);
  else result *= (tresult==matest_23*tsm);

  tensor3<long double> ts539 (5, 3, 9), ts539_ (5, 3, 9);
  tensor2<long double> ts53 (5, 3), ts39 (3, 9);
  vector<long double> v9 (9), v5 (5);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=9; k++)
	{ v9[k] = (2 * i + 3 * j) / 7 * k;
	  v5[i] = 3 * i - k + 3 * j;
	  ts53 (i, j) = 12 * (i + 3 * j) - 15 * k;
	  ts39 (j, k) = k / i * j - k;
	}
  for (int i=1; i<=5; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=9; k++)
	{ ts539 (i, j, k) = ts53 (i,j) * v9 [k];
	  ts539_ (i, j, k) = v5 [i] * ts39 (j,k);
	}

  if (detail) affiche ("operator ^ ( tensor2 ^ vector : M_ij ^ V_p)", (ts53 ^ v9) == ts539);
  else result *= ((ts53 ^ v9) == ts539);

  if (detail) affiche ("operator ^ ( vector ^ tensor2 : M_ij ^ V_p)", (v5 ^ ts39) == ts539_);
  else result *= ((v5 ^ts39) == ts539_);

  ts3.save("tensor3.res");
  tensor3<long double> ncd(ts3.dim1(), ts3.dim2(), ts3.dim3());
  ncd.read("tensor3.res");
  if (detail) affiche("read/write", ncd==ts3);
  else result *= (ncd==ts3);

  string filename = "tenseur3.res";
  ts3.save(filename);
  tensor3<long double> ncd2(ts3.dim1(), ts3.dim2(), ts3.dim3());
  ncd2.read(filename);
  if (detail) affiche("read/write with a string argument", ncd2==ts3);
  else result *= (ncd2==ts3);

  cout << endl;  

  cout << "============================================================== \n";
  if (result) cout << green << "               3rd order tensor test passed" << reset;
  else cout << red << "               3rd order tensor test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
