// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/dependency_node_data.hh,v 1.6 2004/07/07 01:54:57 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__DEPENDENCY_NODE_DATA_HH__
#define __MPAK__BUILTINS__DEPENDENCY_NODE_DATA_HH__

#include <mpak/defs.hh>
#include <mpak/spec/node_data.hh>
#include <mpak/util/dependency.hh>

#include <boost/weak_ptr.hpp>
#include <boost/iterator/transform_iterator.hpp>

#include <string>
#include <map>

namespace mpak
{
    namespace builtins
    {
        class dependency_node_data
            : public spec::node_data
        {
            typedef std::multimap<std::string, util::dependency> dependency_map_type_;
            dependency_map_type_ dependency_map_;
            
            struct dependency_iterator_transform
            {
                typedef const dependency_map_type_::value_type::second_type &result_type;
                result_type operator () (const dependency_map_type_::value_type &v)
                    const
                {
                    return v.second;
                }
            };
            
        public:
            typedef boost::transform_iterator<dependency_iterator_transform, dependency_map_type_::const_iterator,
                                              const dependency_map_type_::value_type::second_type> dependency_iterator;
            typedef dependency_map_type_::const_iterator all_dependency_iterator;
            
            dependency_node_data (void)
                : spec::node_data (),
                  dependency_map_ ()
            {
            }
            
        protected:
            dependency_node_data (const dependency_node_data &that)
                : spec::node_data (that),
                  dependency_map_ (that.dependency_map_)
            {
            }
            
        public:
            void add_dependency (const std::string &type, const util::dependency &dependency)
            {
                this->dependency_map_.insert (dependency_map_type_::value_type (type, dependency));
            }
            
            dependency_iterator
            begin_dependencies (const std::string &type)
                const
            {
                return dependency_iterator (this->dependency_map_.lower_bound (type), dependency_iterator_transform ());
            }
            
            dependency_iterator
            end_dependencies (const std::string &type)
                const
            {
                return dependency_iterator (this->dependency_map_.upper_bound (type), dependency_iterator_transform ());
            }
            
            all_dependency_iterator
            begin_all_dependencies (void)
                const
            {
                return this->dependency_map_.begin ();
            }
            
            all_dependency_iterator
            end_all_dependencies (void)
                const
            {
                return this->dependency_map_.end ();
            }
            
            virtual
            ~dependency_node_data (void);
            
            virtual dependency_node_data *
            clone (void)
                const;
            
            virtual void
            merge (const boost::shared_ptr<spec::node_data> &that)
                const;
        };
    }
}

#endif // ifndef __MPAK__BUILTINS__DEPENDENCY_NODE_DATA_HH__
