// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/script_node_data.hh,v 1.4 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__SCRIPT_NODE_DATA_HH__
#define __MPAK__BUILTINS__SCRIPT_NODE_DATA_HH__

#include <mpak/defs.hh>
#include <mpak/spec/fwd.hh>
#include <mpak/spec/node_data.hh>

#include <boost/optional.hpp>

#include <string>
#include <map>

namespace mpak
{
    namespace builtins
    {
        class script_node_data
            : public spec::node_data
        {
        private:
            mutable boost::optional<std::string> interpreter_;
            typedef std::map<std::string, std::string> script_map_type_;
            mutable script_map_type_ script_map_;
            
        public:
            script_node_data (void)
                : spec::node_data (),
                  interpreter_ (),
                  script_map_ ()
            {
            }
            
        protected:
            script_node_data (const script_node_data &that)
                : spec::node_data (that),
                  interpreter_ (that.interpreter_),
                  script_map_ (that.script_map_)
            {
            }
            
        public:
            typedef script_map_type_::const_iterator script_iterator;
            
            virtual
            ~script_node_data (void);
            
            const boost::optional<std::string> &
            get_interpreter (void)
                const
            {
                return this->interpreter_;
            }
            
            void
            set_interpreter (const boost::optional<std::string> &interpreter)
            {
                this->interpreter_ = interpreter;
            }
            
            bool
            has_script (const std::string &name)
                const
            {
                script_map_type_::const_iterator i (this->script_map_.find (name));
                if (i == this->script_map_.end ())
                    return false;
                return true;
            }
            
            const std::string &
            get_script (const std::string &name)
                const
            {
                script_map_type_::const_iterator i (this->script_map_.find (name));
                if (i == this->script_map_.end ())
                    throw failure ("could not find script " + name);
                return i->second;
            }
            
            void
            append_script (const std::string &name, const std::string &script)
            {
                script_map_type_::iterator i (this->script_map_.find (name));
                if (i == this->script_map_.end ()) {
                    this->script_map_.insert (script_map_type_::value_type (name, script));
                } else {
                    i->second.append (script);
                }
            }
            
            script_iterator
            begin_scripts (void)
                const
            {
                return this->script_map_.begin ();
            }
            
            script_iterator
            end_scripts (void)
                const
            {
                return this->script_map_.end ();
            }
            
            virtual script_node_data *
            clone (void)
                const;
            
            void
            merge (const boost::shared_ptr<node_data> &that_node_data)
                const;
        };
    }
}

#endif // ifndef __MPAK__BUILTINS__SCRIPT_NODE_DATA_HH__
