// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/spec/pickler.hh,v 1.3 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__SPEC__PICKLER_HH__
#define __MPAK__SPEC__PICKLER_HH__

#include <mpak/spec/command_info.hh>
#include <mpak/spec/fwd.hh>
#include <mpak/util/node_path.hh>

#include <boost/shared_ptr.hpp>

#include <string>
#include <stdexcept>

namespace mpak
{
    namespace spec
    {
        class pickler
        {
        public:
            class failure
                : public std::runtime_error
            {
            public:
                inline failure (const std::string &what)
                    : std::runtime_error (what)
                {
                }
            };
            
            pickler (void)
            {
            }
            
            virtual ~pickler (void);
            
            virtual const boost::shared_ptr<command_info_list>
            read (void)
                const;
            
            virtual const boost::shared_ptr<command_info_list>
            read (const std::string &node_type, const util::node_path &node_path)
                const;
            
            virtual void
            write (const boost::shared_ptr<const command_info_list> &command_infos)
                const;
            virtual void
            write (const std::string &node_type, const util::node_path &node_path, const boost::shared_ptr<const command_info_list> &command_infos)
                const;
            
            virtual void
            remove (const std::string &node_type, const util::node_path &node_path)
                const;
        };
    }
}

#endif // ifndef __MPAK__SPEC__PICKLER_HH__
