// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/builtins/config_node.cc,v 1.2 2004/07/06 17:20:31 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/builtins/config_node.hh>
#include <mpak/spec/context.hh>
#include <mpak/spec/node.hh>

#include <boost/optional.hpp>
#include <boost/weak_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/filesystem/path.hpp>

#include <string>

namespace mpak
{
    namespace builtins
    {
        config_node::
        config_node (const std::string &type, const std::string &name,
                     spec::context &context,
                     const bool serialized_init)
            : mpak_node (type, name, context, serialized_init),
              package_tree_dir_ (),
              statedb_dir_ (),
              mpaktmp_dir_ (),
              source_dir_ (),
              root_dir_ ()
        {
        }
        
        config_node::
        ~config_node (void)
        {
        }
    }
}
