// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/spec/file_pickler.cc,v 1.3 2004/06/03 12:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/spec/file_pickler.hh>
#include <mpak/spec/command_info.hh>
#include <mpak/spec/grammar.hh>
#include <mpak/util/node_path.hh>

#include <boost/shared_ptr.hpp>
#include <boost/spirit.hpp>

#include <string>

namespace mpak
{
    namespace spec
    {
        file_pickler::
        ~file_pickler (void)
        {
        }
        
        const boost::shared_ptr<command_info_list>
        file_pickler::
        read (void)
            const
        {
            const std::string filename (this->file_path_.native_file_string ());
            boost::spirit::file_iterator<char> begin (filename);
            if (!begin) {
                throw failure ("unable to open file: " + filename);
            }
            boost::spirit::file_iterator<char> end (begin.make_end ());
            
            mpak::spec::detail::grammar g;
            BOOST_SPIRIT_DEBUG_NODE(g);
            
            boost::shared_ptr<mpak::spec::command_info_list> command_infos;
            boost::spirit::parse_info<boost::spirit::file_iterator<char> >
                info (boost::spirit::parse (begin, end,
                                            g[phoenix::var (command_infos) = phoenix::arg1]));
            
            if (!info.full)
                throw failure ("parse failed, remaining input: " + std::string (info.stop, end));
            
            return command_infos;
        }
    }
}
