// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/spec/node.cc,v 1.4 2004/07/06 17:20:31 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/spec/node.hh>
#include <mpak/spec/context.hh>
#include <mpak/spec/pickler.hh>
#include <mpak/util/node_path.hh>

#include <iostream>

namespace mpak
{
    namespace spec
    {
        node::
        ~node (void)
        {
        }
        
        void
        node::
        init (void)
            const
        {
            if (this->initialized_)
                return;
            
            this->initialized_ = true;
            
            if (this->serialized_init_) {
                const boost::shared_ptr<const spec::command_info_list> command_infos (this->context_.get_pickler ()->read (this->get_type (),
                                                                                                                           util::node_path (this->shared_from_this ())));
                
                this->context_.execute_command_list (command_infos, const_cast<node *> (this)->shared_from_this ());
            }
        }
    }
}
