// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/util/version_spec_grammar.hh,v 1.2 2004/05/29 15:52:12 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__UTIL__VERSION_SPEC_GRAMMAR_HH__
#define __MPAK__UTIL__VERSION_SPEC_GRAMMAR_HH__

#include <mpak/util/version_spec.hh>

#include <boost/spirit.hpp>
#include <boost/spirit/phoenix.hpp>
#include <boost/optional.hpp>

#include <string>

namespace mpak
{
    namespace util
    {
        namespace detail
        {
            struct version_numbers_closure
                : public boost::spirit::closure<version_numbers_closure, version_spec::version_number_vector>
            {
                member1 version_numbers;
            };
            
            struct version_numbers_grammar
                : public boost::spirit::grammar<version_numbers_grammar, version_numbers_closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef boost::spirit::rule<scanner_type_> rule_type;
                    rule_type start_;
                    rule_type version_numbers;
                    
                    definition (const version_numbers_grammar &self)
                    {
                        using boost::spirit::digit_p;
                        using boost::spirit::ch_p;
                        
                        using phoenix::bind;
                        using phoenix::construct_;
                        using phoenix::arg1;
                        using phoenix::arg2;
                        
                        typedef version_spec::version_number_vector version_number_vector;
                        
                        start_ =
                            (+digit_p)[bind (&version_spec::version_number_vector::push_back) (self.version_numbers,
                                                                                               construct_<std::string> (arg1, arg2))] % ch_p ('.');
                        
                        BOOST_SPIRIT_DEBUG_NODE(start_);
                        BOOST_SPIRIT_DEBUG_NODE(version_numbers);
                    }
                    
                    const boost::spirit::rule<scanner_type_> &
                    start (void) const
                    {
                        return this->start_;
                    }
                };
            };
            
            struct version_spec_closure
                : public boost::spirit::closure<version_spec_closure, version_spec>
            {
                member1 version_spec_;
            };
            
            struct version_spec_grammar
                : public boost::spirit::grammar<version_spec_grammar, version_spec_closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef boost::spirit::rule<scanner_type_> rule_type;
                    rule_type start_;
                    detail::version_numbers_grammar version_numbers;
                    rule_type version_letter;
                    rule_type release_type;
                    rule_type release_number;
                    rule_type revision_number;
                    
                    definition (const version_spec_grammar &self)
                    {
                        using boost::spirit::uint_p;
                        using boost::spirit::ch_p;
                        using boost::spirit::alpha_p;
                        
                        using phoenix::bind;
                        using phoenix::arg1;
                        using phoenix::arg2;
                        using phoenix::construct_;
                        using phoenix::var;
                        
                        void (version_spec::*set_release_type_func) (const boost::optional<std::string> &) = &version_spec::set_release_type;
                        
                        start_ =
                            version_numbers[bind (&version_spec::set_version_numbers) (self.version_spec_, arg1)] >>
                            !version_letter >>
                            !(ch_p ('_') >> ((release_type >> !release_number) |
                                             release_number)) >>
                            !(ch_p ('-') >> revision_number);
                        version_letter = alpha_p[bind (&version_spec::set_version_letter) (self.version_spec_, arg1)];
                        release_type = (+alpha_p)[bind (set_release_type_func)
                                                  (self.version_spec_, construct_<std::string> (arg1, arg2))];
                        release_number = uint_p[bind (&version_spec::set_release_number) (self.version_spec_, arg1)];
                        revision_number = uint_p[bind (&version_spec::set_revision_number) (self.version_spec_, arg1)];
                        
                        BOOST_SPIRIT_DEBUG_NODE(start_);
                        BOOST_SPIRIT_DEBUG_NODE(version_numbers);
                        BOOST_SPIRIT_DEBUG_NODE(version_letter);
                        BOOST_SPIRIT_DEBUG_NODE(release_type);
                        BOOST_SPIRIT_DEBUG_NODE(release_number);
                        BOOST_SPIRIT_DEBUG_NODE(revision_number);
                    }
                    
                    const boost::spirit::rule<scanner_type_> &
                    start (void) const
                    {
                        return this->start_;
                    }
                };
            };
        }
    }
}

#endif // ifndef __MPAK__UTIL__VERSION_SPEC_GRAMMAR_HH__
