// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/build/fetcher.hh,v 1.3 2004/05/29 15:52:12 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILD__FETCHER_HH__
#define __MPAK__BUILD__FETCHER_H__

#include <mpak/build/environment.hh>
#include <mpak/util/node_path.hh>
#include <mpak/spec/fwd.hh>

#include <boost/scoped_ptr.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/function.hpp>

#include <string>

namespace mpak
{
    namespace build
    {
        namespace detail
        {
            class fetcher_impl_;
        }
        
        class fetcher
        {
        public:
            class failure
                : public std::runtime_error
            {
            public:
                inline failure (const std::string &what)
                    : runtime_error (what)
                {
                }
            };
            
        private:
            boost::scoped_ptr<detail::fetcher_impl_> impl_;
            std::string url_;
            boost::filesystem::path local_file_path_;
            
        public:
            fetcher (void);
            fetcher (const std::string &url,
                     const boost::filesystem::path &local_file_path);
            fetcher (const fetcher &that);
            ~fetcher (void);
            
            void swap (fetcher &that)
            {
                this->impl_.swap (that.impl_);
                this->url_.swap (that.url_);
                std::swap (this->local_file_path_, that.local_file_path_);
            }
            
            void clear (void)
            {
                fetcher new_fetcher;
                this->swap (new_fetcher);
            }
            
            fetcher &
            operator = (const fetcher &that)
            {
                fetcher new_fetcher (that);
                this->swap (new_fetcher);
                return *this;
            }
            
            const boost::filesystem::path &
            get_local_file_path (void)
                const
            {
                return this->local_file_path_;
            }
            
            void
            set_local_file_path (const boost::filesystem::path &local_file_path)
            {
                this->local_file_path_ = local_file_path;
            }
            
            const std::string &
            get_url (void)
                const
            {
                return this->url_;
            }
            
            void
            set_url (const std::string &url)
            {
                this->url_ = url;
            }
            
            // return true to continue transfer, first arg == total file size, second == amount already fetched
            typedef boost::function<bool (double, double)> fetch_callback;
            
            void fetch (void)
                const;
            void fetch (const fetch_callback &callback)
                const;
        };
    }
}

#endif // ifndef __MPAK__BUILD__FETCHER_H__
