// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/spec/command_info.hh,v 1.3 2004/05/29 15:52:12 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__SPEC__COMMAND_INFO_HH__
#define __MPAK__SPEC__COMMAND_INFO_HH__

#include <mpak/defs.hh>

#include <string>
#include <list>
#include <vector>
#include <algorithm>

#include <boost/shared_ptr.hpp>
#include <boost/variant.hpp>

#ifdef MPAK_NEW_COMMAND_INFO
#include <boost/iterator.hpp>

#include <new>
#endif

namespace mpak
{
    namespace spec
    {
#ifndef MPAK_NEW_COMMAND_INFO
        struct command_info;
        typedef std::list<command_info> command_info_list;
        
        typedef boost::variant<std::string, boost::shared_ptr<command_info_list> > argument_type;
        typedef std::vector<argument_type> argument_vector;
        
        // TODO: store the position of the command in input for error reporting
        struct command_info
        {
            std::string identifier;
            boost::shared_ptr<argument_vector> arguments;
            
            command_info (const std::string &identifier = std::string (),
                          const boost::shared_ptr<argument_vector> &arguments = boost::shared_ptr<argument_vector> ())
                : identifier (identifier),
                  arguments (arguments)
            {
            }
            
            command_info (const command_info &command_info_)
                : identifier (command_info_.identifier),
                  arguments (command_info_.arguments)
            {
            }
            
            const command_info &
            operator= (const command_info &command_info_)
            {
                command_info new_command_info (command_info_);
                this->swap (new_command_info);
                return *this;
            }
            
            void swap (command_info &command_info_)
            {
                this->identifier.swap (command_info_.identifier);
                this->arguments.swap (command_info_.arguments);
            }
        };
#else
        namespace detail
        {
            template<class value_type_>
            class cow_list
            {
                typedef std::vector<value_type_> list_impl_;
                boost::shared_ptr<list_impl_> list_;
                
            public:
                typedef list_impl_::value_type value_type;
                typedef list_impl_::reference reference;
                typedef list_impl_::const_reference const_reference;
                typedef list_impl_::pointer pointer;
                typedef list_impl_::const_pointer const_pointer;
                typedef list_impl_::difference_type difference_type;
                typedef list_impl_::size_type size_type;
                
                typedef list_impl_::iterator iterator;
                typedef list_impl_::const_iterator const_iterator;
                
                cow_list (void)
                    : list_ (new list_impl_ ())
                {
                }
                
                iterator
                begin (void)
                {
                    return this->list_->begin ();
                }
                
                const_iterator
                begin (void)
                    const
                {
                    return this->list_->begin ();
                }
                
                iterator
                end (void)
                {
                    return this->list_->end ();
                }
                
                const_iterator
                end (void)
                    const
                {
                    return this->list_->end ();
                }
                
                size_type
                size (void)
                    const
                {
                    return this->list_->size ();
                }
                
                void
                swap (const cow_list &that)
                {
                    this->list_.swap (that.list_);
                }
                
                cow_list &
                operator = (const cow_list &that)
                {
                    cow_list new_cow_list (that);
                    this->swap (new_cow_list);
                }
                
                void
                push_back (const value_type &value)
                {
                    this->make_unique_ ();
                    this->list_->push_back (value);
                }
                
            private:
                void
                make_unique_ (void)
                {
                    if (!this->list_.unique ()) {
                        boost::shared_ptr<list_impl_> new_list (new list_impl_ (*this->list_));
                        this->list_.swap (new_list);
                    }
                }
            };
        }
        
        class command_info;
        typedef detail::cow_list<command_info> command_info_list;
        typedef boost::variant<std::string, command_info_list> argument;
        typedef detail::cow_list<argument> argument_list;
        
        class command_info
        {
            std::string identifier_;
            argument_list argument_list_;
            
        public:
            command_info (const std::string &identifier = std::string (),
                          const argument_list &arguments = argument_list ())
                : identifier (identifier),
                  arguments (arguments)
            {
            }
            
            command_info (const command_info &command_info_)
                : identifier (command_info_.identifier),
                  arguments (command_info_.arguments)
            {
            }
            
            const command_info &
            operator= (const command_info &command_info_)
            {
                command_info new_command_info (command_info_);
                this->swap (new_command_info);
                return *this;
            }
            
            void swap (command_info &command_info_)
            {
                this->identifier.swap (command_info_.identifier);
                this->arguments.swap (command_info_.arguments);
            }
            
            const std::string &
            get_identifier (void)
            {
                return this->identifier_;
            }
            
            void
            set_identifier (const std::string &identifier)
            {
            }
            
            const argument_list &
            get_arguments (void)
            {
                return this->arguments_;
            }
            
            void
            set_arguments (const argument_list &arguments)
            {
                this->arguments_ = arguments;
            }
        };
#endif
    }
}

#endif // ifndef __MPAK__SPEC__COMMAND_INFO_HH__
