// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/spec/context.hh,v 1.3 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__SPEC__CONTEXT_HH__
#define __MPAK__SPEC__CONTEXT_HH__

#include <mpak/defs.hh>
#include <mpak/spec/command.hh>
#include <mpak/spec/command_info.hh>
#include <mpak/spec/node.hh>
#include <mpak/spec/pickler.hh>

#include <boost/shared_ptr.hpp>
#include <boost/spirit/phoenix.hpp>
#include <boost/utility.hpp>
#include <boost/format.hpp>
#include <boost/variant.hpp>

#include <map>
#include <string>

namespace mpak
{
    namespace spec
    {
        class context
            : boost::noncopyable
        {
        public:
            class failure
                : public std::runtime_error
            {
            public:
                inline failure (const std::string &what)
                    : runtime_error (what)
                {
                }
            };
            
        private:
            typedef std::map<std::string, const command> command_map_type_;
            command_map_type_ command_map_;
            typedef std::map<std::string, const node_command_gen> node_command_gen_map_type_;
            node_command_gen_map_type_ node_command_gen_map_;
            typedef std::map<std::string, const node_data_command_gen> node_data_command_gen_map_type_;
            node_data_command_gen_map_type_ node_data_command_gen_map_;
            const boost::shared_ptr<const pickler> pickler_;
            
        public:
            context (const boost::shared_ptr<const pickler> pickler);
            
            const boost::shared_ptr<const pickler>
            get_pickler (void)
            {
                return this->pickler_;
            }
            
            boost::optional<std::string>
            execute_command (const command_info &info, const boost::shared_ptr<node> &node);
            
            void
            add_command (const std::string &command_name, const command &command);
            
            const command
            get_command (const std::string &command_name)
                const;
            
            boost::optional<std::string>
            execute_command_list (const boost::shared_ptr<const command_info_list> &command_infos, boost::shared_ptr<node> node);
            
            boost::optional<std::string>
            reduce_argument (const argument_type &argument, const boost::shared_ptr<node> &node);
            
            void
            add_node_command_gen (const std::string &node_type, const node_command_gen &node_command_gen);
            void
            add_node_data_command_gen (const std::string &node_data_type,
                                       const node_data_command_gen &node_data_command_gen);
            void
            add_node_data_command_gen (const std::string &node_data_type, const std::string &node_type,
                                       const node_data_command_gen &node_data_command_gen);
            
            const node_command_gen
            get_node_command_gen (const std::string &node_type)
                const;
            const node_data_command_gen
            get_node_data_command_gen (const std::string &node_data_type)
                const;
            const node_data_command_gen
            get_node_data_command_gen (const std::string &node_data_type, const std::string &node_type)
                const;
            
            boost::shared_ptr<command_info_list>
            generate_command_infos (const boost::shared_ptr<const node> &node)
                const;
            boost::shared_ptr<command_info_list>
            generate_command_infos (const std::string &node_data_type,
                                    const boost::shared_ptr<const node_data> &node_data)
                const;
            boost::shared_ptr<command_info_list>
            generate_command_infos (const std::string &node_data_type,
                                    const std::string &node_type,
                                    const boost::shared_ptr<const node_data> &node_data)
                const;
            boost::shared_ptr<command_info_list>
            generate_command_infos_with_data (const boost::shared_ptr<const node> &node)
                const;
            
            void
            write_nodes (const boost::shared_ptr<const node> &node)
                const;
        };
    }
}

#endif // ifndef __MPAK__SPEC__CONTEXT_HH__
