// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/builtins/mpak_node.cc,v 1.1 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/builtins/mpak_node.hh>
#include <mpak/spec/node.hh>

#include <boost/optional.hpp>

#include <new>
#include <map>
#include <string>

namespace mpak
{
    namespace builtins
    {
        mpak_node::~mpak_node (void)
        {
        }
        
        boost::optional<std::string>
        mpak_node::get_env (const std::string &key)
            const
        {
            this->init ();
            env_map_type_::const_iterator i = this->env_map_.find (key);
            if (i == this->env_map_.end ()) {
                return boost::optional<std::string> ();
            } else {
                return boost::optional<std::string> (i->second);
            }
        }
    }
}
