// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/builtins/stages.hh,v 1.4 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__STAGES_HH__
#define __MPAK__BUILTINS__STAGES_HH__

#include <mpak/build/stage.hh>
#include <mpak/build/fwd.hh>
#include <mpak/spec/fwd.hh>
#include <mpak/builtins/fwd.hh>

#include <boost/function.hpp>
#include <boost/shared_ptr.hpp>

namespace mpak
{
    namespace builtins
    {
        namespace stages
        {
            class clean
                : public build::stage
            {
            public:
                clean (void)
                    : stage ()
                {
                }
                
                virtual
                ~clean (void);
                
                virtual void
                execute (const util::node_path &node_path,
                         const boost::shared_ptr<builtins::version_node> &version_node,
                         const build::environment &env)
                    const;
            };
            
            class check
                : public build::stage
            {
            public:
                check (void)
                    : stage ()
                {
                }
                
                virtual
                ~check (void);
                
                virtual void
                execute (const util::node_path &node_path,
                         const boost::shared_ptr<builtins::version_node> &version_node,
                         const build::environment &env)
                    const;
            };
            
            class setup
                : public build::stage
            {
            public:
                setup (void)
                    : stage ()
                {
                }
                
                virtual
                ~setup (void);
                
                virtual void
                execute (const util::node_path &node_path,
                         const boost::shared_ptr<builtins::version_node> &version_node,
                         const build::environment &env)
                    const;
            };
            
            class dependencies
                : public build::stage
            {
            public:
                dependencies (void)
                    : stage ()
                {
                }
                
                virtual
                ~dependencies (void);
                
                virtual void
                execute (const util::node_path &node_path,
                         const boost::shared_ptr<builtins::version_node> &version_node,
                         const build::environment &env)
                    const;
            };
            
            class fetch
                : public build::stage
            {
            public:
                fetch (void)
                    : stage ()
                {
                }
                
                virtual
                ~fetch (void);
                
                virtual void
                execute (const util::node_path &node_path,
                         const boost::shared_ptr<builtins::version_node> &version_node,
                         const build::environment &env)
                    const;
            };
            
            class script
                : public build::stage
            {
            public:
                typedef boost::function<void (const util::node_path &,
                                              const boost::shared_ptr<const builtins::version_node> &,
                                              const build::environment &)> pre_post_function_type;
                
            private:
                const std::string name_;
                pre_post_function_type pre_execute_;
                pre_post_function_type post_execute_;
                
            public:
                script (const std::string &name,
                        const pre_post_function_type pre_execute = pre_post_function_type (),
                        const pre_post_function_type post_execute = pre_post_function_type ())
                    : stage (),
                      name_ (name),
                      pre_execute_ (pre_execute),
                      post_execute_ (post_execute)
                {
                }
                
                virtual
                ~script (void);
                
                virtual bool
                is_complete (const util::node_path &node_path,
                             const boost::shared_ptr<const builtins::version_node> &version_node,
                             const build::environment &env)
                    const;
                virtual void
                execute (const util::node_path &node_path,
                         const boost::shared_ptr<builtins::version_node> &version_node,
                         const build::environment &env)
                    const;
            };
            
            void install_script_pre_execute (const util::node_path &,
                                             const boost::shared_ptr<const builtins::version_node> &,
                                             const build::environment &);
            
            class merge
                : public build::stage
            {
            public:
                merge ()
                    : stage ()
                {
                }
                
                virtual
                ~merge (void);
                
                virtual void
                execute (const util::node_path &node_path,
                         const boost::shared_ptr<builtins::version_node> &version_node,
                         const build::environment &env)
                    const;
            };
            
            class unmerge
                : public build::stage
            {
            public:
                unmerge ()
                    : stage ()
                {
                }
                
                virtual
                ~unmerge (void);
                
                virtual void
                execute (const util::node_path &node_path,
                         const boost::shared_ptr<builtins::version_node> &version_node,
                         const build::environment &env)
                    const;
            };
        }
    }
}

#endif // ifndef __MPAK__BUILTINS__STAGE_HH__
