// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/spec/command.cc,v 1.1 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/spec/command.hh>
#include <mpak/spec/command_info.hh>
#include <mpak/spec/node.hh>

namespace mpak
{
    namespace spec
    {
        boost::shared_ptr<command_info_list>
        default_node_command_gen (const boost::shared_ptr<const spec::node> &node)
        {
            boost::shared_ptr<command_info_list> command_infos (new command_info_list);
            
            for (node::child_const_iterator i (node->begin_children ()); i != node->end_children (); ++i) {
                boost::shared_ptr<argument_vector> arguments (new argument_vector);
                arguments->push_back ((*i)->get_name ());
                command_infos->push_back (command_info ((*i)->get_type (), arguments));
            }
            return command_infos;
        }
    }
}
