/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using zcd;
using Tasklets;

namespace Netsukuku
{
    namespace CounterUtilities
    {
        public ArrayList<string> hash_names(ArrayList<string> myhostnames)
        {
            ArrayList<string> hashednames = new ArrayList<string>();
            foreach (string name in myhostnames)
                hashednames.add(Andna.crypto_hash(name));
            return hashednames;
        }

        public uchar[] prepare_msg(NIP nip, Gee.List<string> hashed_domains)
        {
            uchar[] message1 = nip.hash_for_signature();
            uchar[] message2 = (new ListString.with_backer(hashed_domains)).hash_for_signature();
            uchar[] message = new uchar[message1.length + message2.length];
            int im = 0;
            for (int i = 0; i < message1.length; i++) message[im++] = message1[i];
            for (int i = 0; i < message2.length; i++) message[im++] = message2[i];
            return message;
        }
    }
}

