/* inet_utils.c generated by valac 0.20.1, the Vala compiler
 * generated from inet_utils.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <tasklet.h>
#include <math.h>
#include <float.h>


#define NETSUKUKU_TYPE_NIP_IP_CONVERTER (netsukuku_nip_ip_converter_get_type ())
#define NETSUKUKU_NIP_IP_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIP_IP_CONVERTER, NetsukukuNipIpConverter))
#define NETSUKUKU_IS_NIP_IP_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIP_IP_CONVERTER))
#define NETSUKUKU_NIP_IP_CONVERTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_NIP_IP_CONVERTER, NetsukukuNipIpConverterIface))

typedef struct _NetsukukuNipIpConverter NetsukukuNipIpConverter;
typedef struct _NetsukukuNipIpConverterIface NetsukukuNipIpConverterIface;
#define _g_free0(var) (var = (g_free (var), NULL))

#define NETSUKUKU_TYPE_CLASS10_NIP_TO_IP (netsukuku_class10_nip_to_ip_get_type ())
#define NETSUKUKU_CLASS10_NIP_TO_IP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_CLASS10_NIP_TO_IP, Netsukukuclass10_nip_to_ip))
#define NETSUKUKU_CLASS10_NIP_TO_IP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_CLASS10_NIP_TO_IP, Netsukukuclass10_nip_to_ipClass))
#define NETSUKUKU_IS_CLASS10_NIP_TO_IP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_CLASS10_NIP_TO_IP))
#define NETSUKUKU_IS_CLASS10_NIP_TO_IP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_CLASS10_NIP_TO_IP))
#define NETSUKUKU_CLASS10_NIP_TO_IP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_CLASS10_NIP_TO_IP, Netsukukuclass10_nip_to_ipClass))

typedef struct _Netsukukuclass10_nip_to_ip Netsukukuclass10_nip_to_ip;
typedef struct _Netsukukuclass10_nip_to_ipClass Netsukukuclass10_nip_to_ipClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Netsukukuclass10_nip_to_ipPrivate Netsukukuclass10_nip_to_ipPrivate;

typedef enum  {
	NETSUKUKU_INET_ERROR_NO_NIP,
	NETSUKUKU_INET_ERROR_GENERIC
} NetsukukuInetError;
#define NETSUKUKU_INET_ERROR netsukuku_inet_error_quark ()
struct _NetsukukuNipIpConverterIface {
	GTypeInterface parent_iface;
	gint (*lvl_to_bits) (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint lvl);
	gint (*bits_to_lvl) (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint bits);
	NetsukukuNIP* (*pip_to_nip) (NetsukukuNipIpConverter* self, gint levels, gint gsize, guchar* pip, int pip_length1, GError** error);
	guchar* (*nip_to_pip) (NetsukukuNipIpConverter* self, gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1);
	GeeArrayList* (*valid_ids) (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
};

struct _Netsukukuclass10_nip_to_ip {
	GObject parent_instance;
	Netsukukuclass10_nip_to_ipPrivate * priv;
};

struct _Netsukukuclass10_nip_to_ipClass {
	GObjectClass parent_class;
};


extern gchar* netsukuku_family;
gchar* netsukuku_family = NULL;
extern NetsukukuNipIpConverter* netsukuku_nip_ip_converter;
NetsukukuNipIpConverter* netsukuku_nip_ip_converter = NULL;
extern gboolean netsukuku_initialized;
gboolean netsukuku_initialized = FALSE;
static gpointer netsukuku_class10_nip_to_ip_parent_class = NULL;
static NetsukukuNipIpConverterIface* netsukuku_class10_nip_to_ip_netsukuku_nip_ip_converter_parent_iface = NULL;

GQuark netsukuku_inet_error_quark (void);
GType netsukuku_nip_ip_converter_get_type (void) G_GNUC_CONST;
void netsukuku_initialize (void);
gint netsukuku_settings_get_IP_VERSION (void);
Netsukukuclass10_nip_to_ip* netsukuku_class10_nip_to_ip_new (void);
Netsukukuclass10_nip_to_ip* netsukuku_class10_nip_to_ip_construct (GType object_type);
GType netsukuku_class10_nip_to_ip_get_type (void) G_GNUC_CONST;
gint netsukuku_lvl_to_bits (gint levels, gint gsize, gint lvl);
gint netsukuku_nip_ip_converter_lvl_to_bits (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint lvl);
gint netsukuku_bits_to_lvl (gint levels, gint gsize, gint bits);
gint netsukuku_nip_ip_converter_bits_to_lvl (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint bits);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
guchar* netsukuku_nip_ip_converter_nip_to_pip (NetsukukuNipIpConverter* self, gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1);
NetsukukuNIP* netsukuku_str_to_nip (gint levels, gint gsize, const gchar* ipstr, GError** error);
NetsukukuNIP* netsukuku_nip_ip_converter_pip_to_nip (NetsukukuNipIpConverter* self, gint levels, gint gsize, guchar* pip, int pip_length1, GError** error);
guint8* netsukuku_nip_to_octets (gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1);
GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
GeeArrayList* netsukuku_nip_ip_converter_valid_ids (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
void netsukuku_gnode_to_ip_cidr (NetsukukuPartialNIP* gnode, gint gsize, gchar** ipstr, gchar** bits);
NetsukukuPartialNIP* netsukuku_ip_cidr_to_gnode (gint levels, gint gsize, const gchar* ipstr, const gchar* bits);
guint64 netsukuku_pip_to_ip (guchar* pip, int pip_length1);
guchar* netsukuku_ip_to_pip (guint64 ip, gint numbytes, int* result_length1);
enum  {
	NETSUKUKU_CLASS10_NIP_TO_IP_DUMMY_PROPERTY
};
static gint netsukuku_class10_nip_to_ip_bitsperlevel (Netsukukuclass10_nip_to_ip* self, gint gsize);
static gint netsukuku_class10_nip_to_ip_real_lvl_to_bits (NetsukukuNipIpConverter* base, gint levels, gint gsize, gint lvl);
static gint netsukuku_class10_nip_to_ip_real_bits_to_lvl (NetsukukuNipIpConverter* base, gint levels, gint gsize, gint bits);
static guchar* netsukuku_class10_nip_to_ip_real_nip_to_pip (NetsukukuNipIpConverter* base, gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1);
static NetsukukuNIP* netsukuku_class10_nip_to_ip_real_pip_to_nip (NetsukukuNipIpConverter* base, gint levels, gint gsize, guchar* pip, int pip_length1, GError** error);
static GeeArrayList* netsukuku_class10_nip_to_ip_real_valid_ids (NetsukukuNipIpConverter* base, gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);


GQuark netsukuku_inet_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_inet_error-quark");
}


void netsukuku_initialize (void) {
	gboolean _tmp0_;
	_tmp0_ = netsukuku_initialized;
	if (!_tmp0_) {
		gchar* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp5_;
		gint _tmp6_;
		Netsukukuclass10_nip_to_ip* _tmp8_;
		_tmp1_ = g_strdup ("UNK");
		_g_free0 (netsukuku_family);
		netsukuku_family = _tmp1_;
		_tmp2_ = netsukuku_settings_get_IP_VERSION ();
		_tmp3_ = _tmp2_;
		if (_tmp3_ == 4) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("AF_INET");
			_g_free0 (netsukuku_family);
			netsukuku_family = _tmp4_;
		}
		_tmp5_ = netsukuku_settings_get_IP_VERSION ();
		_tmp6_ = _tmp5_;
		if (_tmp6_ == 6) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("AF_INET6");
			_g_free0 (netsukuku_family);
			netsukuku_family = _tmp7_;
		}
		_tmp8_ = netsukuku_class10_nip_to_ip_new ();
		_g_object_unref0 (netsukuku_nip_ip_converter);
		netsukuku_nip_ip_converter = (NetsukukuNipIpConverter*) _tmp8_;
		netsukuku_initialized = TRUE;
	}
}


gint netsukuku_lvl_to_bits (gint levels, gint gsize, gint lvl) {
	gint result = 0;
	NetsukukuNipIpConverter* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	netsukuku_initialize ();
	_tmp0_ = netsukuku_nip_ip_converter;
	_tmp1_ = levels;
	_tmp2_ = gsize;
	_tmp3_ = lvl;
	_tmp4_ = netsukuku_nip_ip_converter_lvl_to_bits (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


gint netsukuku_bits_to_lvl (gint levels, gint gsize, gint bits) {
	gint result = 0;
	NetsukukuNipIpConverter* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	netsukuku_initialize ();
	_tmp0_ = netsukuku_nip_ip_converter;
	_tmp1_ = levels;
	_tmp2_ = gsize;
	_tmp3_ = bits;
	_tmp4_ = netsukuku_nip_ip_converter_bits_to_lvl (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip) {
	gchar* result = NULL;
	NetsukukuNipIpConverter* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuNIP* _tmp3_;
	gint _tmp4_ = 0;
	guchar* _tmp5_ = NULL;
	guchar* pip;
	gint pip_length1;
	gint _pip_size_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (nip != NULL, NULL);
	netsukuku_initialize ();
	_tmp0_ = netsukuku_nip_ip_converter;
	_tmp1_ = levels;
	_tmp2_ = gsize;
	_tmp3_ = nip;
	_tmp5_ = netsukuku_nip_ip_converter_nip_to_pip (_tmp0_, _tmp1_, _tmp2_, _tmp3_, &_tmp4_);
	pip = _tmp5_;
	pip_length1 = _tmp4_;
	_pip_size_ = pip_length1;
	_tmp6_ = netsukuku_family;
	_tmp7_ = tasklets_pip_to_dotted (_tmp6_, pip, pip_length1);
	result = _tmp7_;
	pip = (g_free (pip), NULL);
	return result;
}


NetsukukuNIP* netsukuku_str_to_nip (gint levels, gint gsize, const gchar* ipstr, GError** error) {
	NetsukukuNIP* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	guchar* _tmp3_ = NULL;
	guchar* pip;
	gint pip_length1;
	gint _pip_size_;
	NetsukukuNipIpConverter* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ipstr != NULL, NULL);
	netsukuku_initialize ();
	_tmp0_ = netsukuku_family;
	_tmp1_ = ipstr;
	_tmp3_ = tasklets_dotted_to_pip (_tmp0_, _tmp1_, &_tmp2_);
	pip = _tmp3_;
	pip_length1 = _tmp2_;
	_pip_size_ = pip_length1;
	_tmp4_ = netsukuku_nip_ip_converter;
	_tmp5_ = levels;
	_tmp6_ = gsize;
	_tmp7_ = netsukuku_nip_ip_converter_pip_to_nip (_tmp4_, _tmp5_, _tmp6_, pip, pip_length1, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_INET_ERROR) {
			g_propagate_error (error, _inner_error_);
			pip = (g_free (pip), NULL);
			return NULL;
		} else {
			pip = (g_free (pip), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp8_;
	pip = (g_free (pip), NULL);
	return result;
}


guint8* netsukuku_nip_to_octets (gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1) {
	guint8* result = NULL;
	NetsukukuNipIpConverter* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuNIP* _tmp3_;
	gint _tmp4_ = 0;
	guchar* _tmp5_ = NULL;
	guchar* pip;
	gint pip_length1;
	gint _pip_size_;
	guchar* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_ = NULL;
	guint8* ret;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	g_return_val_if_fail (nip != NULL, NULL);
	netsukuku_initialize ();
	_tmp0_ = netsukuku_nip_ip_converter;
	_tmp1_ = levels;
	_tmp2_ = gsize;
	_tmp3_ = nip;
	_tmp5_ = netsukuku_nip_ip_converter_nip_to_pip (_tmp0_, _tmp1_, _tmp2_, _tmp3_, &_tmp4_);
	pip = _tmp5_;
	pip_length1 = _tmp4_;
	_pip_size_ = pip_length1;
	_tmp6_ = pip;
	_tmp6__length1 = pip_length1;
	_tmp7_ = g_new0 (guint8, _tmp6__length1);
	ret = _tmp7_;
	ret_length1 = _tmp6__length1;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				guchar* _tmp12_;
				gint _tmp12__length1;
				guint8* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				guchar* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				guchar _tmp17_;
				guint8 _tmp18_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = pip;
				_tmp12__length1 = pip_length1;
				if (!(_tmp11_ < _tmp12__length1)) {
					break;
				}
				_tmp13_ = ret;
				_tmp13__length1 = ret_length1;
				_tmp14_ = i;
				_tmp15_ = pip;
				_tmp15__length1 = pip_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = (guint8) _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
			}
		}
	}
	_tmp19_ = ret;
	_tmp19__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	pip = (g_free (pip), NULL);
	return result;
}


GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip) {
	GeeArrayList* result = NULL;
	NetsukukuNipIpConverter* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	NetsukukuPartialNIP* _tmp4_;
	GeeArrayList* _tmp5_ = NULL;
	g_return_val_if_fail (partial_nip != NULL, NULL);
	netsukuku_initialize ();
	_tmp0_ = netsukuku_nip_ip_converter;
	_tmp1_ = levels;
	_tmp2_ = gsize;
	_tmp3_ = lvl;
	_tmp4_ = partial_nip;
	_tmp5_ = netsukuku_nip_ip_converter_valid_ids (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	result = _tmp5_;
	return result;
}


/** Given this gnode, returns its CIDR. E.g. 10.11.22.0/24
      * returns 2 strings
      */
void netsukuku_gnode_to_ip_cidr (NetsukukuPartialNIP* gnode, gint gsize, gchar** ipstr, gchar** bits) {
	gchar* _vala_ipstr = NULL;
	gchar* _vala_bits = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuNIP* _tmp1_ = NULL;
	NetsukukuNIP* lowestnip;
	NetsukukuPartialNIP* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint levels;
	NetsukukuPartialNIP* _tmp5_;
	gint _tmp6_ = 0;
	gint given_up_to_level;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gint _tmp9_;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_partial_nip_lowest_nip (_tmp0_);
	lowestnip = _tmp1_;
	_tmp2_ = gnode;
	_tmp3_ = netsukuku_partial_nip_get_levels (_tmp2_);
	_tmp4_ = _tmp3_;
	levels = _tmp4_;
	_tmp5_ = gnode;
	_tmp6_ = netsukuku_partial_nip_level_of_gnode (_tmp5_);
	given_up_to_level = _tmp6_;
	_tmp7_ = gsize;
	_tmp8_ = netsukuku_nip_to_str (levels, _tmp7_, lowestnip);
	_g_free0 (_vala_ipstr);
	_vala_ipstr = _tmp8_;
	_tmp9_ = gsize;
	_tmp10_ = netsukuku_lvl_to_bits (levels, _tmp9_, given_up_to_level);
	_tmp11_ = g_strdup_printf ("%i", _tmp10_);
	_g_free0 (_vala_bits);
	_vala_bits = _tmp11_;
	_g_object_unref0 (lowestnip);
	if (ipstr) {
		*ipstr = _vala_ipstr;
	} else {
		_g_free0 (_vala_ipstr);
	}
	if (bits) {
		*bits = _vala_bits;
	} else {
		_g_free0 (_vala_bits);
	}
}


/** Inverse of gnode_to_ip_cidr.
      */
NetsukukuPartialNIP* netsukuku_ip_cidr_to_gnode (gint levels, gint gsize, const gchar* ipstr, const gchar* bits) {
	NetsukukuPartialNIP* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint lvl;
	gint _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	NetsukukuNIP* _tmp8_ = NULL;
	NetsukukuNIP* nip;
	NetsukukuPartialNIP* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ipstr != NULL, NULL);
	g_return_val_if_fail (bits != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = bits;
	_tmp3_ = atoi (_tmp2_);
	_tmp4_ = netsukuku_bits_to_lvl (_tmp0_, _tmp1_, _tmp3_);
	lvl = _tmp4_;
	_tmp5_ = levels;
	_tmp6_ = gsize;
	_tmp7_ = ipstr;
	_tmp8_ = netsukuku_str_to_nip (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
	nip = _tmp8_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) nip, lvl);
	result = _tmp9_;
	_g_object_unref0 (nip);
	return result;
}


/** Returns bits corresponding to 'lvl'
          */
gint netsukuku_nip_ip_converter_lvl_to_bits (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint lvl) {
	g_return_val_if_fail (self != NULL, 0);
	return NETSUKUKU_NIP_IP_CONVERTER_GET_INTERFACE (self)->lvl_to_bits (self, levels, gsize, lvl);
}


/** Inverse of lvl_to_bits
          */
gint netsukuku_nip_ip_converter_bits_to_lvl (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint bits) {
	g_return_val_if_fail (self != NULL, 0);
	return NETSUKUKU_NIP_IP_CONVERTER_GET_INTERFACE (self)->bits_to_lvl (self, levels, gsize, bits);
}


/** Converts the given pip to a nip
          */
NetsukukuNIP* netsukuku_nip_ip_converter_pip_to_nip (NetsukukuNipIpConverter* self, gint levels, gint gsize, guchar* pip, int pip_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_NIP_IP_CONVERTER_GET_INTERFACE (self)->pip_to_nip (self, levels, gsize, pip, pip_length1, error);
}


/** The reverse of pip_to_nip
          */
guchar* netsukuku_nip_ip_converter_nip_to_pip (NetsukukuNipIpConverter* self, gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_NIP_IP_CONVERTER_GET_INTERFACE (self)->nip_to_pip (self, levels, gsize, nip, result_length1);
}


/** Returns the list of valid IDs for level lvl, given that IDs for upper
          * levels are already choosen in nip.
          */
GeeArrayList* netsukuku_nip_ip_converter_valid_ids (NetsukukuNipIpConverter* self, gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_NIP_IP_CONVERTER_GET_INTERFACE (self)->valid_ids (self, levels, gsize, lvl, partial_nip);
}


static void netsukuku_nip_ip_converter_base_init (NetsukukuNipIpConverterIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType netsukuku_nip_ip_converter_get_type (void) {
	static volatile gsize netsukuku_nip_ip_converter_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_nip_ip_converter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNipIpConverterIface), (GBaseInitFunc) netsukuku_nip_ip_converter_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType netsukuku_nip_ip_converter_type_id;
		netsukuku_nip_ip_converter_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetsukukuNipIpConverter", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (netsukuku_nip_ip_converter_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&netsukuku_nip_ip_converter_type_id__volatile, netsukuku_nip_ip_converter_type_id);
	}
	return netsukuku_nip_ip_converter_type_id__volatile;
}


guint64 netsukuku_pip_to_ip (guchar* pip, int pip_length1) {
	guint64 result = 0ULL;
	guint64 ret;
	ret = (guint64) 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				guchar* _tmp4_;
				gint _tmp4__length1;
				guchar* _tmp5_;
				gint _tmp5__length1;
				guchar* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				guchar _tmp8_;
				gint c;
				guint64 _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gdouble _tmp12_ = 0.0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = pip;
				_tmp4__length1 = pip_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = pip;
				_tmp5__length1 = pip_length1;
				_tmp6_ = pip;
				_tmp6__length1 = pip_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp5_[(_tmp6__length1 - _tmp7_) - 1];
				c = (gint) _tmp8_;
				_tmp9_ = ret;
				_tmp10_ = c;
				_tmp11_ = i;
				_tmp12_ = pow ((gdouble) 256, (gdouble) _tmp11_);
				ret = _tmp9_ + (_tmp10_ * ((guint64) _tmp12_));
			}
		}
	}
	result = ret;
	return result;
}


guchar* netsukuku_ip_to_pip (guint64 ip, gint numbytes, int* result_length1) {
	guchar* result = NULL;
	gint _tmp0_;
	guchar* _tmp1_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	gint j;
	guchar* _tmp20_;
	gint _tmp20__length1;
	_tmp0_ = numbytes;
	_tmp1_ = g_new0 (guchar, _tmp0_);
	ret = _tmp1_;
	ret_length1 = _tmp0_;
	_ret_size_ = ret_length1;
	j = 0;
	{
		gint _tmp2_;
		gint i;
		_tmp2_ = numbytes;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gint _tmp7_;
				gdouble _tmp8_ = 0.0;
				guint64 modulo;
				gint _tmp9_;
				gdouble _tmp10_ = 0.0;
				guint64 divisore;
				guint64 _tmp11_;
				guint64 _tmp12_;
				guint64 resto;
				guint64 _tmp13_;
				guint64 _tmp14_;
				guint64 quoziente;
				guint64 _tmp15_;
				gint c;
				guchar* _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				gint _tmp18_;
				guchar _tmp19_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = pow ((gdouble) 256, (gdouble) (_tmp7_ + 1));
				modulo = (guint64) _tmp8_;
				_tmp9_ = i;
				_tmp10_ = pow ((gdouble) 256, (gdouble) _tmp9_);
				divisore = (guint64) _tmp10_;
				_tmp11_ = ip;
				_tmp12_ = modulo;
				resto = _tmp11_ % _tmp12_;
				_tmp13_ = resto;
				_tmp14_ = divisore;
				quoziente = _tmp13_ / _tmp14_;
				_tmp15_ = quoziente;
				c = (gint) _tmp15_;
				_tmp16_ = ret;
				_tmp16__length1 = ret_length1;
				_tmp17_ = j;
				j = _tmp17_ + 1;
				_tmp18_ = c;
				_tmp16_[_tmp17_] = (guchar) _tmp18_;
				_tmp19_ = _tmp16_[_tmp17_];
			}
		}
	}
	_tmp20_ = ret;
	_tmp20__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}


static gint netsukuku_class10_nip_to_ip_bitsperlevel (Netsukukuclass10_nip_to_ip* self, gint gsize) {
	gint result = 0;
	gint ret;
	g_return_val_if_fail (self != NULL, 0);
	ret = 0;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = ret;
		_tmp1_ = gsize;
		if (!((1 << _tmp0_) < _tmp1_)) {
			break;
		}
		_tmp2_ = ret;
		ret = _tmp2_ + 1;
	}
	result = ret;
	return result;
}


static gint netsukuku_class10_nip_to_ip_real_lvl_to_bits (NetsukukuNipIpConverter* base, gint levels, gint gsize, gint lvl) {
	Netsukukuclass10_nip_to_ip * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	self = (Netsukukuclass10_nip_to_ip*) base;
	_tmp0_ = lvl;
	_tmp1_ = gsize;
	_tmp2_ = netsukuku_class10_nip_to_ip_bitsperlevel (self, _tmp1_);
	result = 32 - (_tmp0_ * _tmp2_);
	return result;
}


static gint netsukuku_class10_nip_to_ip_real_bits_to_lvl (NetsukukuNipIpConverter* base, gint levels, gint gsize, gint bits) {
	Netsukukuclass10_nip_to_ip * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	self = (Netsukukuclass10_nip_to_ip*) base;
	_tmp0_ = bits;
	_tmp1_ = gsize;
	_tmp2_ = netsukuku_class10_nip_to_ip_bitsperlevel (self, _tmp1_);
	result = (32 - _tmp0_) / _tmp2_;
	return result;
}


static guchar* netsukuku_class10_nip_to_ip_real_nip_to_pip (NetsukukuNipIpConverter* base, gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1) {
	Netsukukuclass10_nip_to_ip * self;
	guchar* result = NULL;
	guint64 ip;
	guint64 _tmp12_;
	gdouble _tmp13_ = 0.0;
	gint _tmp14_ = 0;
	guchar* _tmp15_ = NULL;
	guchar* _tmp16_;
	gint _tmp16__length1;
	self = (Netsukukuclass10_nip_to_ip*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	ip = (guint64) 0;
	{
		gint l;
		l = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				guint64 _tmp5_;
				NetsukukuNIP* _tmp6_;
				gint _tmp7_;
				gint _tmp8_ = 0;
				gint _tmp9_;
				gint _tmp10_;
				gdouble _tmp11_ = 0.0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l;
					l = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = l;
				_tmp4_ = levels;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = ip;
				_tmp6_ = nip;
				_tmp7_ = l;
				_tmp8_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp6_, _tmp7_);
				_tmp9_ = gsize;
				_tmp10_ = l;
				_tmp11_ = pow ((gdouble) _tmp9_, (gdouble) _tmp10_);
				ip = _tmp5_ + (_tmp8_ * ((guint64) _tmp11_));
			}
		}
	}
	_tmp12_ = ip;
	_tmp13_ = pow ((gdouble) 256, (gdouble) 3);
	_tmp15_ = netsukuku_ip_to_pip (_tmp12_ + (10 * ((guint64) _tmp13_)), 4, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


static NetsukukuNIP* netsukuku_class10_nip_to_ip_real_pip_to_nip (NetsukukuNipIpConverter* base, gint levels, gint gsize, guchar* pip, int pip_length1, GError** error) {
	Netsukukuclass10_nip_to_ip * self;
	NetsukukuNIP* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guint64 _tmp1_ = 0ULL;
	guint64 ip;
	guint64 _tmp2_;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_;
	gint* _tmp5_ = NULL;
	gint* _ret;
	gint _ret_length1;
	gint __ret_size_;
	guint64 _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gdouble _tmp24_ = 0.0;
	gint* _tmp26_;
	gint _tmp26__length1;
	NetsukukuNIP* _tmp27_;
	GError * _inner_error_ = NULL;
	self = (Netsukukuclass10_nip_to_ip*) base;
	_tmp0_ = pip;
	_tmp0__length1 = pip_length1;
	_tmp1_ = netsukuku_pip_to_ip (_tmp0_, _tmp0__length1);
	ip = _tmp1_;
	_tmp2_ = ip;
	_tmp3_ = pow ((gdouble) 256, (gdouble) 3);
	ip = _tmp2_ - (10 * ((gint) _tmp3_));
	_tmp4_ = levels;
	_tmp5_ = g_new0 (gint, _tmp4_);
	_ret = _tmp5_;
	_ret_length1 = _tmp4_;
	__ret_size_ = _ret_length1;
	{
		gint l;
		l = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gint _tmp9_;
				gint _tmp10_;
				gint* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				guint64 _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gdouble _tmp16_ = 0.0;
				gint _tmp17_;
				gint _tmp18_;
				gdouble _tmp19_ = 0.0;
				gint _tmp20_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = l;
					l = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = l;
				_tmp10_ = levels;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _ret;
				_tmp11__length1 = _ret_length1;
				_tmp12_ = l;
				_tmp13_ = ip;
				_tmp14_ = gsize;
				_tmp15_ = l;
				_tmp16_ = pow ((gdouble) _tmp14_, (gdouble) (_tmp15_ + 1));
				_tmp17_ = gsize;
				_tmp18_ = l;
				_tmp19_ = pow ((gdouble) _tmp17_, (gdouble) _tmp18_);
				_tmp11_[_tmp12_] = (gint) ((_tmp13_ % ((guint64) _tmp16_)) / ((guint64) _tmp19_));
				_tmp20_ = _tmp11_[_tmp12_];
			}
		}
	}
	_tmp21_ = ip;
	_tmp22_ = gsize;
	_tmp23_ = levels;
	_tmp24_ = pow ((gdouble) _tmp22_, (gdouble) _tmp23_);
	if ((_tmp21_ / ((guint64) _tmp24_)) > ((guint64) 0)) {
		GError* _tmp25_;
		_tmp25_ = g_error_new_literal (NETSUKUKU_INET_ERROR, NETSUKUKU_INET_ERROR_NO_NIP, "Outside of Netsukuku realm.");
		_inner_error_ = _tmp25_;
		if (_inner_error_->domain == NETSUKUKU_INET_ERROR) {
			g_propagate_error (error, _inner_error_);
			_ret = (g_free (_ret), NULL);
			return NULL;
		} else {
			_ret = (g_free (_ret), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp26_ = _ret;
	_tmp26__length1 = _ret_length1;
	_tmp27_ = netsukuku_nip_new (_tmp26_, _tmp26__length1);
	result = _tmp27_;
	_ret = (g_free (_ret), NULL);
	return result;
}


static GeeArrayList* netsukuku_class10_nip_to_ip_real_valid_ids (NetsukukuNipIpConverter* base, gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip) {
	Netsukukuclass10_nip_to_ip * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	self = (Netsukukuclass10_nip_to_ip*) base;
	g_return_val_if_fail (partial_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = gsize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) _tmp7_));
			}
		}
	}
	result = ret;
	return result;
}


Netsukukuclass10_nip_to_ip* netsukuku_class10_nip_to_ip_construct (GType object_type) {
	Netsukukuclass10_nip_to_ip * self = NULL;
	self = (Netsukukuclass10_nip_to_ip*) g_object_new (object_type, NULL);
	return self;
}


Netsukukuclass10_nip_to_ip* netsukuku_class10_nip_to_ip_new (void) {
	return netsukuku_class10_nip_to_ip_construct (NETSUKUKU_TYPE_CLASS10_NIP_TO_IP);
}


static void netsukuku_class10_nip_to_ip_class_init (Netsukukuclass10_nip_to_ipClass * klass) {
	netsukuku_class10_nip_to_ip_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_class10_nip_to_ip_netsukuku_nip_ip_converter_interface_init (NetsukukuNipIpConverterIface * iface) {
	netsukuku_class10_nip_to_ip_netsukuku_nip_ip_converter_parent_iface = g_type_interface_peek_parent (iface);
	iface->lvl_to_bits = (gint (*)(NetsukukuNipIpConverter*, gint, gint, gint)) netsukuku_class10_nip_to_ip_real_lvl_to_bits;
	iface->bits_to_lvl = (gint (*)(NetsukukuNipIpConverter*, gint, gint, gint)) netsukuku_class10_nip_to_ip_real_bits_to_lvl;
	iface->nip_to_pip = (guchar* (*)(NetsukukuNipIpConverter*, gint, gint, NetsukukuNIP*, int*)) netsukuku_class10_nip_to_ip_real_nip_to_pip;
	iface->pip_to_nip = (NetsukukuNIP* (*)(NetsukukuNipIpConverter*, gint, gint, guchar*, int, GError**)) netsukuku_class10_nip_to_ip_real_pip_to_nip;
	iface->valid_ids = (GeeArrayList* (*)(NetsukukuNipIpConverter*, gint, gint, gint, NetsukukuPartialNIP*)) netsukuku_class10_nip_to_ip_real_valid_ids;
}


static void netsukuku_class10_nip_to_ip_instance_init (Netsukukuclass10_nip_to_ip * self) {
}


/** Represents class 10.* in IPv4
      */
GType netsukuku_class10_nip_to_ip_get_type (void) {
	static volatile gsize netsukuku_class10_nip_to_ip_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_class10_nip_to_ip_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Netsukukuclass10_nip_to_ipClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_class10_nip_to_ip_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Netsukukuclass10_nip_to_ip), 0, (GInstanceInitFunc) netsukuku_class10_nip_to_ip_instance_init, NULL };
		static const GInterfaceInfo netsukuku_nip_ip_converter_info = { (GInterfaceInitFunc) netsukuku_class10_nip_to_ip_netsukuku_nip_ip_converter_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_class10_nip_to_ip_type_id;
		netsukuku_class10_nip_to_ip_type_id = g_type_register_static (G_TYPE_OBJECT, "Netsukukuclass10_nip_to_ip", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_class10_nip_to_ip_type_id, NETSUKUKU_TYPE_NIP_IP_CONVERTER, &netsukuku_nip_ip_converter_info);
		g_once_init_leave (&netsukuku_class10_nip_to_ip_type_id__volatile, netsukuku_class10_nip_to_ip_type_id);
	}
	return netsukuku_class10_nip_to_ip_type_id__volatile;
}



