/* crypto.c generated by valac 0.20.1, the Vala compiler
 * generated from crypto.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gcrypt.h>
#include <netsukuku-rpc.h>
#include <zcd.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _gcry_sexp_release0(var) ((var == NULL) ? NULL : (var = (gcry_sexp_release (var), NULL)))
#define _gcry_md_close0(var) ((var == NULL) ? NULL : (var = (gcry_md_close (var), NULL)))
#define _gcry_cipher_close0(var) ((var == NULL) ? NULL : (var = (gcry_cipher_close (var), NULL)))

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;
typedef struct _NetsukukuKeyPairPrivate NetsukukuKeyPairPrivate;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetsukukuPublicKeyWrapperPrivate NetsukukuPublicKeyWrapperPrivate;

typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
typedef enum  {
	NETSUKUKU_CRYPTO_FILE_ERROR_GENERIC
} NetsukukuCryptoFileError;
#define NETSUKUKU_CRYPTO_FILE_ERROR netsukuku_crypto_file_error_quark ()
struct _NetsukukuKeyPair {
	GObject parent_instance;
	NetsukukuKeyPairPrivate * priv;
};

struct _NetsukukuKeyPairClass {
	GObjectClass parent_class;
};

struct _NetsukukuKeyPairPrivate {
	struct gcry_sexp* keypair;
	struct gcry_sexp* pkey;
	struct gcry_sexp* skey;
	NetsukukuPublicKeyWrapper* _pub_key;
};

struct _NetsukukuPublicKeyWrapper {
	GObject parent_instance;
	NetsukukuPublicKeyWrapperPrivate * priv;
};

struct _NetsukukuPublicKeyWrapperClass {
	GObjectClass parent_class;
};

struct _NetsukukuPublicKeyWrapperPrivate {
	struct gcry_sexp* pkey;
};


extern gboolean netsukuku_settings_TESTING;
static gpointer netsukuku_key_pair_parent_class = NULL;
static gpointer netsukuku_public_key_wrapper_parent_class = NULL;

GQuark netsukuku_crypto_gcrypt_error_quark (void);
guint32 netsukuku_crypto_fnv_32 (guchar* buf, int buf_length1);
GQuark netsukuku_crypto_file_error_quark (void);
void netsukuku_crypto_write_file (const gchar* pathname, guint8* buf, int buf_length1, GError** error);
guint8* netsukuku_crypto_read_file (const gchar* pathname, gint maxlen, int* result_length1);
struct gcry_sexp* netsukuku_crypto_getpubkey (struct gcry_sexp* keypair);
struct gcry_sexp* netsukuku_crypto_getprivkey (struct gcry_sexp* keypair);
struct gcry_sexp* netsukuku_crypto_recreate_sexp (guint8* buffer, int buffer_length1, GError** error);
guint8* netsukuku_crypto_serialize_sexp (struct gcry_sexp* sexp, int* result_length1);
struct gcry_sexp* netsukuku_crypto_generate_keypair (GError** error);
guint8* netsukuku_crypto_md5 (guint8* buffer, int buffer_length1, int* result_length1, GError** error);
struct gcry_sexp* netsukuku_crypto_sign (guint8* buffer, int buffer_length1, struct gcry_sexp* skey, GError** error);
gboolean netsukuku_crypto_verify (struct gcry_sexp* sig, guint8* buffer, int buffer_length1, struct gcry_sexp* pkey, GError** error);
struct gcry_sexp* netsukuku_crypto_encrypt_session_key (guchar* buffer, int buffer_length1, struct gcry_sexp* pkey, GError** error);
gchar* netsukuku_crypto_encrypt_session_key_get_rsa_mpi (guchar* buffer, int buffer_length1, struct gcry_sexp* pkey, int* result_length1, GError** error);
guchar* netsukuku_crypto_decrypt_session_key_from_rsa_mpi (gchar* rsapart, int rsapart_length1, struct gcry_sexp* skey, int* result_length1, GError** error);
guchar* netsukuku_crypto_decrypt_session_key_from_encval (struct gcry_sexp* encval, struct gcry_sexp* skey, int* result_length1, GError** error);
guchar* netsukuku_crypto_decrypt_session_key_from_ciph (struct gcry_sexp* ciph, struct gcry_sexp* skey, int* result_length1, GError** error);
void netsukuku_crypto_hex_dump (guint8* buf, int buf_length1);
guchar* netsukuku_crypto_encrypt (guchar* message, int message_length1, guchar* key, int key_length1, guchar* iv, int iv_length1, int* result_length1, GError** error);
guchar* netsukuku_crypto_decrypt (guchar* ciph, int ciph_length1, guchar* key, int key_length1, guchar* iv, int iv_length1, int* result_length1, GError** error);
guchar* netsukuku_crypto_create_random_session_key (gint l, int* result_length1);
guchar* netsukuku_crypto_asym_encrypt (guchar* message, int message_length1, struct gcry_sexp* pkey, int* result_length1, GError** error);
static guchar* _vala_array_dup3 (guchar* self, int length);
static guchar* _vala_array_dup4 (guchar* self, int length);
guchar* netsukuku_crypto_asym_decrypt (guchar* ciph, int ciph_length1, struct gcry_sexp* skey, int* result_length1, GError** error);
gchar* netsukuku_crypto_short_repr (guint8* pubkey);
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_KEY_PAIR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairPrivate))
enum  {
	NETSUKUKU_KEY_PAIR_DUMMY_PROPERTY,
	NETSUKUKU_KEY_PAIR_PUB_KEY
};
NetsukukuKeyPair* netsukuku_key_pair_new (const gchar* from_file, GError** error);
NetsukukuKeyPair* netsukuku_key_pair_construct (GType object_type, const gchar* from_file, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pem (guint8* from_pem, int from_pem_length1, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pem (GType object_type, guint8* from_pem, int from_pem_length1, GError** error);
static void netsukuku_key_pair_set_pub_key (NetsukukuKeyPair* self, NetsukukuPublicKeyWrapper* value);
void netsukuku_key_pair_save_pair (NetsukukuKeyPair* self, const gchar* keys_path, GError** error);
void netsukuku_key_pair_save_pub_key (NetsukukuKeyPair* self, const gchar* pk_path, GError** error);
guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error);
static guchar* _vala_array_dup5 (guchar* self, int length);
guchar* netsukuku_key_pair_decrypt (NetsukukuKeyPair* self, guchar* cypher, int cypher_length1, int* result_length1, GError** error);
gchar* netsukuku_key_pair_to_string (NetsukukuKeyPair* self);
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
static void netsukuku_key_pair_finalize (GObject* obj);
static void _vala_netsukuku_key_pair_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_key_pair_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperPrivate))
enum  {
	NETSUKUKU_PUBLIC_KEY_WRAPPER_DUMMY_PROPERTY
};
static NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new (guint8* from_pem, int from_pem_length1, const gchar* from_file, NetsukukuPublicKey* from_pubk, GError** error);
static NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct (GType object_type, guint8* from_pem, int from_pem_length1, const gchar* from_file, NetsukukuPublicKey* from_pubk, GError** error);
static guint8* _vala_array_dup6 (guint8* self, int length);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_file (const gchar* from_file, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_file (GType object_type, const gchar* from_file, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pubk (NetsukukuPublicKey* from_pubk, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pubk (GType object_type, NetsukukuPublicKey* from_pubk, GError** error);
void netsukuku_public_key_wrapper_save_pub_key (NetsukukuPublicKeyWrapper* self, const gchar* pk_path, GError** error);
gboolean netsukuku_public_key_wrapper_verify (NetsukukuPublicKeyWrapper* self, guchar* msg, int msg_length1, guchar* signature, int signature_length1, GError** error);
guchar* netsukuku_public_key_wrapper_encrypt (NetsukukuPublicKeyWrapper* self, guchar* message, int message_length1, int* result_length1, GError** error);
gchar* netsukuku_public_key_wrapper_to_string (NetsukukuPublicKeyWrapper* self);
static void netsukuku_public_key_wrapper_finalize (GObject* obj);


GQuark netsukuku_crypto_gcrypt_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_crypto_gcrypt_error-quark");
}


/** 32 bit Fowler/Noll/Vo hash
          */
guint32 netsukuku_crypto_fnv_32 (guchar* buf, int buf_length1) {
	guint32 result = 0U;
	guint32 hval;
	guchar* _tmp0_;
	gint _tmp0__length1;
	hval = (guint32) 2166136261LL;
	_tmp0_ = buf;
	_tmp0__length1 = buf_length1;
	{
		guchar* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < _tmp0__length1; c_it = c_it + 1) {
			guchar c = '\0';
			c = c_collection[c_it];
			{
				guint32 _tmp1_;
				guint32 _tmp2_;
				guint32 _tmp3_;
				guint32 _tmp4_;
				guint32 _tmp5_;
				guint32 _tmp6_;
				guint32 _tmp7_;
				guchar _tmp8_;
				_tmp1_ = hval;
				_tmp2_ = hval;
				_tmp3_ = hval;
				_tmp4_ = hval;
				_tmp5_ = hval;
				_tmp6_ = hval;
				hval = _tmp1_ + (((((_tmp2_ << 1) + (_tmp3_ << 4)) + (_tmp4_ << 7)) + (_tmp5_ << 8)) + (_tmp6_ << 24));
				_tmp7_ = hval;
				_tmp8_ = c;
				hval = _tmp7_ ^ ((guint8) _tmp8_);
			}
		}
	}
	result = hval;
	return result;
}


GQuark netsukuku_crypto_file_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_crypto_file_error-quark");
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void netsukuku_crypto_write_file (const gchar* pathname, guint8* buf, int buf_length1, GError** error) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* fout;
	FILE* _tmp2_;
	FILE* _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (pathname != NULL);
	_tmp0_ = pathname;
	_tmp1_ = g_fopen (_tmp0_, "w");
	fout = _tmp1_;
	_tmp2_ = fout;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp3_ = pathname;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("Unable to write ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new_literal (NETSUKUKU_CRYPTO_FILE_ERROR, NETSUKUKU_CRYPTO_FILE_ERROR_GENERIC, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_fclose0 (fout);
			return;
		} else {
			_fclose0 (fout);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = fout;
	_tmp10_ = buf;
	_tmp10__length1 = buf_length1;
	fwrite (_tmp10_, (gsize) 1, _tmp10__length1, _tmp9_);
	_fclose0 (fout);
}


guint8* netsukuku_crypto_read_file (const gchar* pathname, gint maxlen, int* result_length1) {
	guint8* result = NULL;
	gint _tmp0_;
	guint8* _tmp1_ = NULL;
	guint8* buf;
	gint buf_length1;
	gint _buf_size_;
	const gchar* _tmp2_;
	FILE* _tmp3_ = NULL;
	FILE* fin;
	FILE* _tmp4_;
	FILE* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gsize _tmp8_ = 0UL;
	gsize len;
	gsize _tmp9_;
	guint8* _tmp10_ = NULL;
	guint8* ret;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	g_return_val_if_fail (pathname != NULL, NULL);
	_tmp0_ = maxlen;
	_tmp1_ = g_new0 (guint8, _tmp0_);
	buf = _tmp1_;
	buf_length1 = _tmp0_;
	_buf_size_ = buf_length1;
	_tmp2_ = pathname;
	_tmp3_ = g_fopen (_tmp2_, "r");
	fin = _tmp3_;
	_tmp4_ = fin;
	if (_tmp4_ == NULL) {
		guint8* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = NULL;
		_tmp5__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp5__length1;
		}
		result = _tmp5_;
		_fclose0 (fin);
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp6_ = fin;
	_tmp7_ = buf;
	_tmp7__length1 = buf_length1;
	_tmp8_ = fread (_tmp7_, (gsize) 1, _tmp7__length1, _tmp6_);
	len = _tmp8_;
	_tmp9_ = len;
	_tmp10_ = g_new0 (guint8, _tmp9_);
	ret = _tmp10_;
	ret_length1 = _tmp9_;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				gint _tmp14_;
				gsize _tmp15_;
				guint8* _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				guint8* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				guint8 _tmp20_;
				guint8 _tmp21_;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = len;
				if (!(((gsize) _tmp14_) < _tmp15_)) {
					break;
				}
				_tmp16_ = ret;
				_tmp16__length1 = ret_length1;
				_tmp17_ = i;
				_tmp18_ = buf;
				_tmp18__length1 = buf_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp16_[_tmp17_] = _tmp20_;
				_tmp21_ = _tmp16_[_tmp17_];
			}
		}
	}
	_tmp22_ = ret;
	_tmp22__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	_fclose0 (fin);
	buf = (g_free (buf), NULL);
	return result;
}


struct gcry_sexp* netsukuku_crypto_getpubkey (struct gcry_sexp* keypair) {
	struct gcry_sexp* result = NULL;
	struct gcry_sexp* _tmp0_;
	struct gcry_sexp* _tmp1_ = NULL;
	struct gcry_sexp* ret;
	g_return_val_if_fail (keypair != NULL, NULL);
	_tmp0_ = keypair;
	_tmp1_ = gcry_sexp_find_token (_tmp0_, "public-key", (gsize) 0);
	ret = _tmp1_;
	result = ret;
	return result;
}


struct gcry_sexp* netsukuku_crypto_getprivkey (struct gcry_sexp* keypair) {
	struct gcry_sexp* result = NULL;
	struct gcry_sexp* _tmp0_;
	struct gcry_sexp* _tmp1_ = NULL;
	struct gcry_sexp* ret;
	g_return_val_if_fail (keypair != NULL, NULL);
	_tmp0_ = keypair;
	_tmp1_ = gcry_sexp_find_token (_tmp0_, "private-key", (gsize) 0);
	ret = _tmp1_;
	result = ret;
	return result;
}


struct gcry_sexp* netsukuku_crypto_recreate_sexp (guint8* buffer, int buffer_length1, GError** error) {
	struct gcry_sexp* result = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	void* data;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint size;
	struct gcry_sexp* sexp = NULL;
	void* _tmp2_;
	gint _tmp3_;
	struct gcry_sexp* _tmp4_ = NULL;
	gcry_error_t _tmp5_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp6_;
	GError * _inner_error_ = NULL;
	_tmp0_ = buffer;
	_tmp0__length1 = buffer_length1;
	data = (void*) _tmp0_;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	size = _tmp1__length1;
	_tmp2_ = data;
	_tmp3_ = size;
	_tmp5_ = gcry_sexp_new (&_tmp4_, _tmp2_, (gsize) _tmp3_, 1);
	_gcry_sexp_release0 (sexp);
	sexp = _tmp4_;
	err = _tmp5_;
	_tmp6_ = err;
	if (_tmp6_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp7_;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gcry_error_t _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GError* _tmp14_;
		GError* _tmp15_;
		_tmp7_ = err;
		_tmp8_ = gcry_strsource (_tmp7_);
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = err;
		_tmp11_ = gcry_strerror (_tmp10_);
		_tmp12_ = g_strconcat ("libgcrypt: source: ", _tmp9_, " code: ", _tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (sexp);
			return NULL;
		} else {
			_gcry_sexp_release0 (sexp);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = sexp;
	return result;
}


guint8* netsukuku_crypto_serialize_sexp (struct gcry_sexp* sexp, int* result_length1) {
	guint8* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer2;
	gint buffer2_length1;
	gint _buffer2_size_;
	struct gcry_sexp* _tmp1_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gsize _tmp3_ = 0UL;
	gsize len;
	gsize _tmp4_;
	guint8* _tmp5_ = NULL;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	g_return_val_if_fail (sexp != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 2000);
	buffer2 = _tmp0_;
	buffer2_length1 = 2000;
	_buffer2_size_ = buffer2_length1;
	_tmp1_ = sexp;
	_tmp2_ = buffer2;
	_tmp2__length1 = buffer2_length1;
	_tmp3_ = gcry_sexp_sprint (_tmp1_, GCRYSEXP_FMT_CANON, _tmp2_, _tmp2__length1);
	len = _tmp3_;
	_tmp4_ = len;
	_tmp5_ = g_new0 (guint8, _tmp4_);
	buffer = _tmp5_;
	buffer_length1 = _tmp4_;
	_buffer_size_ = buffer_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gint _tmp9_;
				gsize _tmp10_;
				guint8* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				gchar* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				gchar _tmp15_;
				guint8 _tmp16_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = len;
				if (!(((gsize) _tmp9_) < _tmp10_)) {
					break;
				}
				_tmp11_ = buffer;
				_tmp11__length1 = buffer_length1;
				_tmp12_ = i;
				_tmp13_ = buffer2;
				_tmp13__length1 = buffer2_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp11_[_tmp12_] = (guint8) _tmp15_;
				_tmp16_ = _tmp11_[_tmp12_];
			}
		}
	}
	_tmp17_ = buffer;
	_tmp17__length1 = buffer_length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	buffer2 = (g_free (buffer2), NULL);
	return result;
}


struct gcry_sexp* netsukuku_crypto_generate_keypair (GError** error) {
	struct gcry_sexp* result = NULL;
	struct gcry_sexp* parms = NULL;
	struct gcry_sexp* _tmp0_ = NULL;
	gcry_error_t _tmp1_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp2_;
	struct gcry_sexp* keypair = NULL;
	struct gcry_sexp* _tmp12_;
	struct gcry_sexp* _tmp13_ = NULL;
	gcry_error_t _tmp14_ = 0U;
	gcry_error_t _tmp15_;
	GError * _inner_error_ = NULL;
	_tmp1_ = gcry_sexp_build (&_tmp0_, NULL, "(genkey (rsa (nbits 4:1024)(transient-key)))", NULL);
	_gcry_sexp_release0 (parms);
	parms = _tmp0_;
	err = _tmp1_;
	_tmp2_ = err;
	if (_tmp2_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gcry_error_t _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		_tmp3_ = err;
		_tmp4_ = gcry_strsource (_tmp3_);
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = err;
		_tmp7_ = gcry_strerror (_tmp6_);
		_tmp8_ = g_strconcat ("libgcrypt: source: ", _tmp5_, " code: ", _tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (parms);
			return NULL;
		} else {
			_gcry_sexp_release0 (parms);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = parms;
	_tmp14_ = gcry_pk_genkey (&_tmp13_, _tmp12_);
	_gcry_sexp_release0 (keypair);
	keypair = _tmp13_;
	err = _tmp14_;
	_tmp15_ = err;
	if (_tmp15_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp16_;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gcry_error_t _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		GError* _tmp24_;
		_tmp16_ = err;
		_tmp17_ = gcry_strsource (_tmp16_);
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = err;
		_tmp20_ = gcry_strerror (_tmp19_);
		_tmp21_ = g_strconcat ("libgcrypt: source: ", _tmp18_, " code: ", _tmp20_, "\n", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp24_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (keypair);
			_gcry_sexp_release0 (parms);
			return NULL;
		} else {
			_gcry_sexp_release0 (keypair);
			_gcry_sexp_release0 (parms);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = keypair;
	_gcry_sexp_release0 (parms);
	return result;
}


guint8* netsukuku_crypto_md5 (guint8* buffer, int buffer_length1, int* result_length1, GError** error) {
	guint8* result = NULL;
	struct gcry_md_handle* hash = NULL;
	struct gcry_md_handle* _tmp0_ = NULL;
	gcry_error_t _tmp1_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp2_;
	struct gcry_md_handle* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	struct gcry_md_handle* _tmp14_;
	struct gcry_md_handle* _tmp15_;
	guchar* _tmp16_ = NULL;
	guchar* tmp;
	gsize _tmp17_ = 0UL;
	gsize len;
	gsize _tmp18_;
	guint8* _tmp19_ = NULL;
	guint8* ret;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp30_;
	gint _tmp30__length1;
	GError * _inner_error_ = NULL;
	_tmp1_ = gcry_md_open (&_tmp0_, GCRY_MD_MD5, (enum gcry_md_flags) 0);
	_gcry_md_close0 (hash);
	hash = _tmp0_;
	err = _tmp1_;
	_tmp2_ = err;
	if (_tmp2_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gcry_error_t _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		_tmp3_ = err;
		_tmp4_ = gcry_strsource (_tmp3_);
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = err;
		_tmp7_ = gcry_strerror (_tmp6_);
		_tmp8_ = g_strconcat ("libgcrypt: source: ", _tmp5_, " code: ", _tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_md_close0 (hash);
			return NULL;
		} else {
			_gcry_md_close0 (hash);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = hash;
	_tmp13_ = buffer;
	_tmp13__length1 = buffer_length1;
	gcry_md_write (_tmp12_, (guchar*) _tmp13_, (_tmp13__length1 * sizeof (guint8)) / sizeof (guchar));
	_tmp14_ = hash;
	gcry_md_final (_tmp14_);
	_tmp15_ = hash;
	_tmp16_ = gcry_md_read (_tmp15_, GCRY_MD_MD5);
	tmp = _tmp16_;
	_tmp17_ = gcry_md_get_algo_dlen (GCRY_MD_MD5);
	len = _tmp17_;
	_tmp18_ = len;
	_tmp19_ = g_new0 (guint8, _tmp18_);
	ret = _tmp19_;
	ret_length1 = _tmp18_;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp20_;
			_tmp20_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_;
				gint _tmp23_;
				gsize _tmp24_;
				guint8* _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				guchar* _tmp27_;
				gint _tmp28_;
				guint8 _tmp29_;
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp23_ = i;
				_tmp24_ = len;
				if (!(((gsize) _tmp23_) < _tmp24_)) {
					break;
				}
				_tmp25_ = ret;
				_tmp25__length1 = ret_length1;
				_tmp26_ = i;
				_tmp27_ = tmp;
				_tmp28_ = i;
				_tmp25_[_tmp26_] = (guint8) (*(_tmp27_ + _tmp28_));
				_tmp29_ = _tmp25_[_tmp26_];
			}
		}
	}
	_tmp30_ = ret;
	_tmp30__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp30__length1;
	}
	result = _tmp30_;
	_gcry_md_close0 (hash);
	return result;
}


struct gcry_sexp* netsukuku_crypto_sign (guint8* buffer, int buffer_length1, struct gcry_sexp* skey, GError** error) {
	struct gcry_sexp* result = NULL;
	struct gcry_sexp* ret = NULL;
	struct gcry_sexp* data = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	struct gcry_sexp* _tmp2_ = NULL;
	gcry_error_t _tmp3_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp4_;
	struct gcry_sexp* _tmp14_;
	struct gcry_sexp* _tmp15_;
	struct gcry_sexp* _tmp16_ = NULL;
	gcry_error_t _tmp17_ = 0U;
	gcry_error_t _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (skey != NULL, NULL);
	_tmp0_ = buffer;
	_tmp0__length1 = buffer_length1;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	_tmp3_ = gcry_sexp_build (&_tmp2_, NULL, "(data (flags pkcs1) (hash md5 %b ))", _tmp0__length1, (gchar*) _tmp1_, NULL);
	_gcry_sexp_release0 (data);
	data = _tmp2_;
	err = _tmp3_;
	_tmp4_ = err;
	if (_tmp4_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gcry_error_t _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp5_ = err;
		_tmp6_ = gcry_strsource (_tmp5_);
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = err;
		_tmp9_ = gcry_strerror (_tmp8_);
		_tmp10_ = g_strconcat ("libgcrypt: source: ", _tmp7_, " code: ", _tmp9_, "\n", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (data);
			_gcry_sexp_release0 (ret);
			return NULL;
		} else {
			_gcry_sexp_release0 (data);
			_gcry_sexp_release0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = data;
	_tmp15_ = skey;
	_tmp17_ = gcry_pk_sign (&_tmp16_, _tmp14_, _tmp15_);
	_gcry_sexp_release0 (ret);
	ret = _tmp16_;
	err = _tmp17_;
	_tmp18_ = err;
	if (_tmp18_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp19_;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gcry_error_t _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp19_ = err;
		_tmp20_ = gcry_strsource (_tmp19_);
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = err;
		_tmp23_ = gcry_strerror (_tmp22_);
		_tmp24_ = g_strconcat ("libgcrypt: source: ", _tmp21_, " code: ", _tmp23_, "\n", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_inner_error_ = _tmp27_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (data);
			_gcry_sexp_release0 (ret);
			return NULL;
		} else {
			_gcry_sexp_release0 (data);
			_gcry_sexp_release0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = ret;
	_gcry_sexp_release0 (data);
	return result;
}


gboolean netsukuku_crypto_verify (struct gcry_sexp* sig, guint8* buffer, int buffer_length1, struct gcry_sexp* pkey, GError** error) {
	gboolean result = FALSE;
	struct gcry_sexp* data = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	struct gcry_sexp* _tmp2_ = NULL;
	gcry_error_t _tmp3_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp4_;
	gboolean ret;
	struct gcry_sexp* _tmp14_;
	struct gcry_sexp* _tmp15_;
	gcry_error_t _tmp16_ = 0U;
	gcry_error_t _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sig != NULL, FALSE);
	g_return_val_if_fail (pkey != NULL, FALSE);
	_tmp0_ = buffer;
	_tmp0__length1 = buffer_length1;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	_tmp3_ = gcry_sexp_build (&_tmp2_, NULL, "(data (flags pkcs1) (hash md5 %b ))", _tmp0__length1, (gchar*) _tmp1_, NULL);
	_gcry_sexp_release0 (data);
	data = _tmp2_;
	err = _tmp3_;
	_tmp4_ = err;
	if (_tmp4_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gcry_error_t _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp5_ = err;
		_tmp6_ = gcry_strsource (_tmp5_);
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = err;
		_tmp9_ = gcry_strerror (_tmp8_);
		_tmp10_ = g_strconcat ("libgcrypt: source: ", _tmp7_, " code: ", _tmp9_, "\n", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (data);
			return FALSE;
		} else {
			_gcry_sexp_release0 (data);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	ret = TRUE;
	_tmp14_ = sig;
	_tmp15_ = pkey;
	_tmp16_ = gcry_pk_verify (_tmp14_, data, _tmp15_);
	err = _tmp16_;
	_tmp17_ = err;
	if (_tmp17_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp18_;
		gpg_err_code_t _tmp19_ = 0;
		_tmp18_ = err;
		_tmp19_ = gpg_err_code (_tmp18_);
		if (_tmp19_ == GPG_ERR_BAD_SIGNATURE) {
			ret = FALSE;
		} else {
			gcry_error_t _tmp20_;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gcry_error_t _tmp23_;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			GError* _tmp27_;
			GError* _tmp28_;
			_tmp20_ = err;
			_tmp21_ = gcry_strsource (_tmp20_);
			_tmp22_ = string_to_string (_tmp21_);
			_tmp23_ = err;
			_tmp24_ = gcry_strerror (_tmp23_);
			_tmp25_ = g_strconcat ("libgcrypt: source: ", _tmp22_, " code: ", _tmp24_, "\n", NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp26_);
			_tmp28_ = _tmp27_;
			_g_free0 (_tmp26_);
			_inner_error_ = _tmp28_;
			if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
				g_propagate_error (error, _inner_error_);
				_gcry_sexp_release0 (data);
				return FALSE;
			} else {
				_gcry_sexp_release0 (data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	_gcry_sexp_release0 (data);
	return result;
}


struct gcry_sexp* netsukuku_crypto_encrypt_session_key (guchar* buffer, int buffer_length1, struct gcry_sexp* pkey, GError** error) {
	struct gcry_sexp* result = NULL;
	struct gcry_sexp* ret = NULL;
	struct gcry_sexp* data = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
	struct gcry_sexp* _tmp2_ = NULL;
	gcry_error_t _tmp3_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp4_;
	struct gcry_sexp* _tmp14_;
	struct gcry_sexp* _tmp15_;
	struct gcry_sexp* _tmp16_ = NULL;
	gcry_error_t _tmp17_ = 0U;
	gcry_error_t _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (pkey != NULL, NULL);
	_tmp0_ = buffer;
	_tmp0__length1 = buffer_length1;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	_tmp3_ = gcry_sexp_build (&_tmp2_, NULL, "(data (flags pkcs1) (value %b ))", _tmp0__length1, _tmp1_, NULL);
	_gcry_sexp_release0 (data);
	data = _tmp2_;
	err = _tmp3_;
	_tmp4_ = err;
	if (_tmp4_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gcry_error_t _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp5_ = err;
		_tmp6_ = gcry_strsource (_tmp5_);
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = err;
		_tmp9_ = gcry_strerror (_tmp8_);
		_tmp10_ = g_strconcat ("libgcrypt: source: ", _tmp7_, " code: ", _tmp9_, "\n", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (data);
			_gcry_sexp_release0 (ret);
			return NULL;
		} else {
			_gcry_sexp_release0 (data);
			_gcry_sexp_release0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = data;
	_tmp15_ = pkey;
	_tmp17_ = gcry_pk_encrypt (&_tmp16_, _tmp14_, _tmp15_);
	_gcry_sexp_release0 (ret);
	ret = _tmp16_;
	err = _tmp17_;
	_tmp18_ = err;
	if (_tmp18_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp19_;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gcry_error_t _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp19_ = err;
		_tmp20_ = gcry_strsource (_tmp19_);
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = err;
		_tmp23_ = gcry_strerror (_tmp22_);
		_tmp24_ = g_strconcat ("libgcrypt: source: ", _tmp21_, " code: ", _tmp23_, "\n", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_inner_error_ = _tmp27_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (data);
			_gcry_sexp_release0 (ret);
			return NULL;
		} else {
			_gcry_sexp_release0 (data);
			_gcry_sexp_release0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = ret;
	_gcry_sexp_release0 (data);
	return result;
}


gchar* netsukuku_crypto_encrypt_session_key_get_rsa_mpi (guchar* buffer, int buffer_length1, struct gcry_sexp* pkey, int* result_length1, GError** error) {
	gchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	struct gcry_sexp* _tmp1_;
	struct gcry_sexp* _tmp2_ = NULL;
	struct gcry_sexp* ciph;
	struct gcry_sexp* _tmp3_ = NULL;
	struct gcry_sexp* _tmp4_;
	struct gcry_sexp* _tmp5_ = NULL;
	struct gcry_sexp* _tmp6_;
	struct gcry_sexp* rsapart;
	struct gcry_sexp* _tmp7_;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_ = NULL;
	gchar* ret;
	gint ret_length1;
	gint _ret_size_;
	gchar* _tmp23_;
	gint _tmp23__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (pkey != NULL, NULL);
	_tmp0_ = buffer;
	_tmp0__length1 = buffer_length1;
	_tmp1_ = pkey;
	_tmp2_ = netsukuku_crypto_encrypt_session_key (_tmp0_, _tmp0__length1, _tmp1_, &_inner_error_);
	ciph = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = gcry_sexp_find_token (ciph, "rsa", (gsize) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = gcry_sexp_find_token (_tmp4_, "a", (gsize) 0);
	_tmp6_ = _tmp5_;
	_gcry_sexp_release0 (_tmp4_);
	rsapart = _tmp6_;
	_tmp7_ = rsapart;
	_tmp9_ = gcry_sexp_nth_data (_tmp7_, 1, &_tmp8_);
	data = _tmp9_;
	data_length1 = _tmp8_;
	_data_size_ = data_length1;
	_tmp10_ = data;
	_tmp10__length1 = data_length1;
	_tmp11_ = g_new0 (gchar, _tmp10__length1);
	ret = _tmp11_;
	ret_length1 = _tmp10__length1;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_;
				gint _tmp15_;
				gchar* _tmp16_;
				gint _tmp16__length1;
				gchar* _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				gchar* _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				gchar _tmp21_;
				gchar _tmp22_;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp15_ = i;
				_tmp16_ = data;
				_tmp16__length1 = data_length1;
				if (!(_tmp15_ < _tmp16__length1)) {
					break;
				}
				_tmp17_ = ret;
				_tmp17__length1 = ret_length1;
				_tmp18_ = i;
				_tmp19_ = data;
				_tmp19__length1 = data_length1;
				_tmp20_ = i;
				_tmp21_ = _tmp19_[_tmp20_];
				_tmp17_[_tmp18_] = _tmp21_;
				_tmp22_ = _tmp17_[_tmp18_];
			}
		}
	}
	_tmp23_ = ret;
	_tmp23__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	_gcry_sexp_release0 (rsapart);
	_gcry_sexp_release0 (ciph);
	return result;
}


guchar* netsukuku_crypto_decrypt_session_key_from_rsa_mpi (gchar* rsapart, int rsapart_length1, struct gcry_sexp* skey, int* result_length1, GError** error) {
	guchar* result = NULL;
	struct gcry_sexp* encval = NULL;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gint _tmp1__length1;
	struct gcry_sexp* _tmp2_ = NULL;
	gcry_error_t _tmp3_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp4_;
	struct gcry_sexp* _tmp14_;
	struct gcry_sexp* _tmp15_;
	gint _tmp16_ = 0;
	guchar* _tmp17_ = NULL;
	guchar* _tmp18_;
	gint _tmp18__length1;
	gint __tmp18__size_;
	guchar* _tmp19_;
	gint _tmp19__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (skey != NULL, NULL);
	_tmp0_ = rsapart;
	_tmp0__length1 = rsapart_length1;
	_tmp1_ = rsapart;
	_tmp1__length1 = rsapart_length1;
	_tmp3_ = gcry_sexp_build (&_tmp2_, NULL, "(enc-val (flags pkcs1) (rsa (a %b )))", _tmp0__length1, _tmp1_, NULL);
	_gcry_sexp_release0 (encval);
	encval = _tmp2_;
	err = _tmp3_;
	_tmp4_ = err;
	if (_tmp4_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gcry_error_t _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp5_ = err;
		_tmp6_ = gcry_strsource (_tmp5_);
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = err;
		_tmp9_ = gcry_strerror (_tmp8_);
		_tmp10_ = g_strconcat ("libgcrypt: source: ", _tmp7_, " code: ", _tmp9_, "\n", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (encval);
			return NULL;
		} else {
			_gcry_sexp_release0 (encval);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = encval;
	_tmp15_ = skey;
	_tmp17_ = netsukuku_crypto_decrypt_session_key_from_encval (_tmp14_, _tmp15_, &_tmp16_, &_inner_error_);
	_tmp18_ = _tmp17_;
	_tmp18__length1 = _tmp16_;
	__tmp18__size_ = _tmp18__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (encval);
			return NULL;
		} else {
			_gcry_sexp_release0 (encval);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	_gcry_sexp_release0 (encval);
	return result;
}


guchar* netsukuku_crypto_decrypt_session_key_from_ciph (struct gcry_sexp* ciph, struct gcry_sexp* skey, int* result_length1, GError** error) {
	guchar* result = NULL;
	struct gcry_sexp* encval = NULL;
	struct gcry_sexp* _tmp0_;
	struct gcry_sexp* _tmp1_ = NULL;
	struct gcry_sexp* rsapart;
	struct gcry_sexp* _tmp2_;
	struct gcry_sexp* _tmp3_ = NULL;
	gcry_error_t _tmp4_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp5_;
	struct gcry_sexp* _tmp15_;
	struct gcry_sexp* _tmp16_;
	gint _tmp17_ = 0;
	guchar* _tmp18_ = NULL;
	guchar* _tmp19_;
	gint _tmp19__length1;
	gint __tmp19__size_;
	guchar* _tmp20_;
	gint _tmp20__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ciph != NULL, NULL);
	g_return_val_if_fail (skey != NULL, NULL);
	_tmp0_ = ciph;
	_tmp1_ = gcry_sexp_find_token (_tmp0_, "rsa", (gsize) 0);
	rsapart = _tmp1_;
	_tmp2_ = rsapart;
	_tmp4_ = gcry_sexp_build (&_tmp3_, NULL, "(enc-val (flags pkcs1) %S )", _tmp2_, NULL);
	_gcry_sexp_release0 (encval);
	encval = _tmp3_;
	err = _tmp4_;
	_tmp5_ = err;
	if (_tmp5_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gcry_error_t _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		GError* _tmp13_;
		GError* _tmp14_;
		_tmp6_ = err;
		_tmp7_ = gcry_strsource (_tmp6_);
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = err;
		_tmp10_ = gcry_strerror (_tmp9_);
		_tmp11_ = g_strconcat ("libgcrypt: source: ", _tmp8_, " code: ", _tmp10_, "\n", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_inner_error_ = _tmp14_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (rsapart);
			_gcry_sexp_release0 (encval);
			return NULL;
		} else {
			_gcry_sexp_release0 (rsapart);
			_gcry_sexp_release0 (encval);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp15_ = encval;
	_tmp16_ = skey;
	_tmp18_ = netsukuku_crypto_decrypt_session_key_from_encval (_tmp15_, _tmp16_, &_tmp17_, &_inner_error_);
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp17_;
	__tmp19__size_ = _tmp19__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (rsapart);
			_gcry_sexp_release0 (encval);
			return NULL;
		} else {
			_gcry_sexp_release0 (rsapart);
			_gcry_sexp_release0 (encval);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp20_ = _tmp19_;
	_tmp20__length1 = _tmp19__length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	_gcry_sexp_release0 (rsapart);
	_gcry_sexp_release0 (encval);
	return result;
}


guchar* netsukuku_crypto_decrypt_session_key_from_encval (struct gcry_sexp* encval, struct gcry_sexp* skey, int* result_length1, GError** error) {
	guchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	struct gcry_sexp* plain = NULL;
	struct gcry_sexp* _tmp1_;
	struct gcry_sexp* _tmp2_;
	struct gcry_sexp* _tmp3_ = NULL;
	gcry_error_t _tmp4_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp5_;
	struct gcry_sexp* _tmp15_;
	gint _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gboolean _tmp18_;
	gboolean zerofound;
	gint validpos;
	gboolean _tmp39_;
	guchar* _tmp53_;
	gint _tmp53__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (encval != NULL, NULL);
	g_return_val_if_fail (skey != NULL, NULL);
	_tmp0_ = g_new0 (guchar, 0);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = encval;
	_tmp2_ = skey;
	_tmp4_ = gcry_pk_decrypt (&_tmp3_, _tmp1_, _tmp2_);
	_gcry_sexp_release0 (plain);
	plain = _tmp3_;
	err = _tmp4_;
	_tmp5_ = err;
	if (_tmp5_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gcry_error_t _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		GError* _tmp13_;
		GError* _tmp14_;
		_tmp6_ = err;
		_tmp7_ = gcry_strsource (_tmp6_);
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = err;
		_tmp10_ = gcry_strerror (_tmp9_);
		_tmp11_ = g_strconcat ("libgcrypt: source: ", _tmp8_, " code: ", _tmp10_, "\n", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_inner_error_ = _tmp14_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (plain);
			ret = (g_free (ret), NULL);
			return NULL;
		} else {
			_gcry_sexp_release0 (plain);
			ret = (g_free (ret), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp15_ = plain;
	_tmp17_ = gcry_sexp_nth_data (_tmp15_, 1, &_tmp16_);
	data = _tmp17_;
	data_length1 = _tmp16_;
	_data_size_ = data_length1;
	_tmp18_ = netsukuku_settings_TESTING;
	if (_tmp18_) {
		FILE* _tmp19_;
		gchar* _tmp20_;
		gint _tmp20__length1;
		_tmp19_ = stdout;
		fprintf (_tmp19_, "\ndecrypt_session_key_from_encval: nth_data(1) follows:\n");
		_tmp20_ = data;
		_tmp20__length1 = data_length1;
		netsukuku_crypto_hex_dump ((guint8*) _tmp20_, (_tmp20__length1 * sizeof (gchar)) / sizeof (guint8));
	}
	zerofound = FALSE;
	validpos = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gboolean _tmp22_;
				gint _tmp24_;
				gchar* _tmp25_;
				gint _tmp25__length1;
				gboolean _tmp26_;
				_tmp22_ = _tmp21_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = data;
				_tmp25__length1 = data_length1;
				if (!(_tmp24_ < _tmp25__length1)) {
					break;
				}
				_tmp26_ = zerofound;
				if (_tmp26_) {
					guchar* _tmp27_;
					gint _tmp27__length1;
					gint _tmp28_;
					gchar* _tmp29_;
					gint _tmp29__length1;
					gint _tmp30_;
					gchar _tmp31_;
					guchar _tmp32_;
					_tmp27_ = ret;
					_tmp27__length1 = ret_length1;
					_tmp28_ = validpos;
					validpos = _tmp28_ + 1;
					_tmp29_ = data;
					_tmp29__length1 = data_length1;
					_tmp30_ = i;
					_tmp31_ = _tmp29_[_tmp30_];
					_tmp27_[_tmp28_] = (guchar) _tmp31_;
					_tmp32_ = _tmp27_[_tmp28_];
				} else {
					gchar* _tmp33_;
					gint _tmp33__length1;
					gint _tmp34_;
					gchar _tmp35_;
					_tmp33_ = data;
					_tmp33__length1 = data_length1;
					_tmp34_ = i;
					_tmp35_ = _tmp33_[_tmp34_];
					if (_tmp35_ == '\0') {
						gchar* _tmp36_;
						gint _tmp36__length1;
						gint _tmp37_;
						guchar* _tmp38_ = NULL;
						zerofound = TRUE;
						_tmp36_ = data;
						_tmp36__length1 = data_length1;
						_tmp37_ = i;
						_tmp38_ = g_new0 (guchar, (_tmp36__length1 - _tmp37_) - 1);
						ret = (g_free (ret), NULL);
						ret = _tmp38_;
						ret_length1 = (_tmp36__length1 - _tmp37_) - 1;
						_ret_size_ = ret_length1;
					}
				}
			}
		}
	}
	_tmp39_ = zerofound;
	if (!_tmp39_) {
		gchar* _tmp40_;
		gint _tmp40__length1;
		guchar* _tmp41_ = NULL;
		_tmp40_ = data;
		_tmp40__length1 = data_length1;
		_tmp41_ = g_new0 (guchar, _tmp40__length1);
		ret = (g_free (ret), NULL);
		ret = _tmp41_;
		ret_length1 = _tmp40__length1;
		_ret_size_ = ret_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp42_;
				_tmp42_ = TRUE;
				while (TRUE) {
					gboolean _tmp43_;
					gint _tmp45_;
					gchar* _tmp46_;
					gint _tmp46__length1;
					guchar* _tmp47_;
					gint _tmp47__length1;
					gint _tmp48_;
					gchar* _tmp49_;
					gint _tmp49__length1;
					gint _tmp50_;
					gchar _tmp51_;
					guchar _tmp52_;
					_tmp43_ = _tmp42_;
					if (!_tmp43_) {
						gint _tmp44_;
						_tmp44_ = i;
						i = _tmp44_ + 1;
					}
					_tmp42_ = FALSE;
					_tmp45_ = i;
					_tmp46_ = data;
					_tmp46__length1 = data_length1;
					if (!(_tmp45_ < _tmp46__length1)) {
						break;
					}
					_tmp47_ = ret;
					_tmp47__length1 = ret_length1;
					_tmp48_ = i;
					_tmp49_ = data;
					_tmp49__length1 = data_length1;
					_tmp50_ = i;
					_tmp51_ = _tmp49_[_tmp50_];
					_tmp47_[_tmp48_] = (guchar) _tmp51_;
					_tmp52_ = _tmp47_[_tmp48_];
				}
			}
		}
	}
	_tmp53_ = ret;
	_tmp53__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp53__length1;
	}
	result = _tmp53_;
	_gcry_sexp_release0 (plain);
	return result;
}


guchar* netsukuku_crypto_encrypt (guchar* message, int message_length1, guchar* key, int key_length1, guchar* iv, int iv_length1, int* result_length1, GError** error) {
	guchar* result = NULL;
	struct gcry_cipher_handle* hd = NULL;
	struct gcry_cipher_handle* _tmp0_ = NULL;
	gcry_error_t _tmp1_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp2_;
	struct gcry_cipher_handle* _tmp12_;
	guchar* _tmp13_;
	gint _tmp13__length1;
	gcry_error_t _tmp14_ = 0U;
	gcry_error_t _tmp15_;
	struct gcry_cipher_handle* _tmp25_;
	guchar* _tmp26_;
	gint _tmp26__length1;
	gcry_error_t _tmp27_ = 0U;
	gcry_error_t _tmp28_;
	guchar* _tmp38_;
	gint _tmp38__length1;
	guchar* _tmp39_ = NULL;
	guchar* ciph;
	gint ciph_length1;
	gint _ciph_size_;
	struct gcry_cipher_handle* _tmp40_;
	guchar* _tmp41_;
	gint _tmp41__length1;
	guchar* _tmp42_;
	gint _tmp42__length1;
	gcry_error_t _tmp43_ = 0U;
	gcry_error_t _tmp44_;
	guchar* _tmp54_;
	gint _tmp54__length1;
	GError * _inner_error_ = NULL;
	_tmp1_ = gcry_cipher_open (&_tmp0_, GCRY_CIPHER_ARCFOUR, GCRY_CIPHER_MODE_STREAM, (enum gcry_cipher_flags) 0);
	_gcry_cipher_close0 (hd);
	hd = _tmp0_;
	err = _tmp1_;
	_tmp2_ = err;
	if (_tmp2_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gcry_error_t _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		_tmp3_ = err;
		_tmp4_ = gcry_strsource (_tmp3_);
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = err;
		_tmp7_ = gcry_strerror (_tmp6_);
		_tmp8_ = g_strconcat ("libgcrypt: source: ", _tmp5_, " code: ", _tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_cipher_close0 (hd);
			return NULL;
		} else {
			_gcry_cipher_close0 (hd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = hd;
	_tmp13_ = key;
	_tmp13__length1 = key_length1;
	_tmp14_ = gcry_cipher_setkey (_tmp12_, _tmp13_, _tmp13__length1);
	err = _tmp14_;
	_tmp15_ = err;
	if (_tmp15_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp16_;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gcry_error_t _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		GError* _tmp24_;
		_tmp16_ = err;
		_tmp17_ = gcry_strsource (_tmp16_);
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = err;
		_tmp20_ = gcry_strerror (_tmp19_);
		_tmp21_ = g_strconcat ("libgcrypt: source: ", _tmp18_, " code: ", _tmp20_, "\n", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp24_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_cipher_close0 (hd);
			return NULL;
		} else {
			_gcry_cipher_close0 (hd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp25_ = hd;
	_tmp26_ = iv;
	_tmp26__length1 = iv_length1;
	_tmp27_ = gcry_cipher_setiv (_tmp25_, _tmp26_, _tmp26__length1);
	err = _tmp27_;
	_tmp28_ = err;
	if (_tmp28_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp29_;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gcry_error_t _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		_tmp29_ = err;
		_tmp30_ = gcry_strsource (_tmp29_);
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = err;
		_tmp33_ = gcry_strerror (_tmp32_);
		_tmp34_ = g_strconcat ("libgcrypt: source: ", _tmp31_, " code: ", _tmp33_, "\n", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_inner_error_ = _tmp37_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_cipher_close0 (hd);
			return NULL;
		} else {
			_gcry_cipher_close0 (hd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp38_ = message;
	_tmp38__length1 = message_length1;
	_tmp39_ = g_new0 (guchar, _tmp38__length1);
	ciph = _tmp39_;
	ciph_length1 = _tmp38__length1;
	_ciph_size_ = ciph_length1;
	_tmp40_ = hd;
	_tmp41_ = ciph;
	_tmp41__length1 = ciph_length1;
	_tmp42_ = message;
	_tmp42__length1 = message_length1;
	_tmp43_ = gcry_cipher_encrypt (_tmp40_, _tmp41_, _tmp41__length1, _tmp42_, _tmp42__length1);
	err = _tmp43_;
	_tmp44_ = err;
	if (_tmp44_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp45_;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gcry_error_t _tmp48_;
		const gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_;
		GError* _tmp52_;
		GError* _tmp53_;
		_tmp45_ = err;
		_tmp46_ = gcry_strsource (_tmp45_);
		_tmp47_ = string_to_string (_tmp46_);
		_tmp48_ = err;
		_tmp49_ = gcry_strerror (_tmp48_);
		_tmp50_ = g_strconcat ("libgcrypt: source: ", _tmp47_, " code: ", _tmp49_, "\n", NULL);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp51_);
		_tmp53_ = _tmp52_;
		_g_free0 (_tmp51_);
		_inner_error_ = _tmp53_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			ciph = (g_free (ciph), NULL);
			_gcry_cipher_close0 (hd);
			return NULL;
		} else {
			ciph = (g_free (ciph), NULL);
			_gcry_cipher_close0 (hd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp54_ = ciph;
	_tmp54__length1 = ciph_length1;
	if (result_length1) {
		*result_length1 = _tmp54__length1;
	}
	result = _tmp54_;
	_gcry_cipher_close0 (hd);
	return result;
}


guchar* netsukuku_crypto_decrypt (guchar* ciph, int ciph_length1, guchar* key, int key_length1, guchar* iv, int iv_length1, int* result_length1, GError** error) {
	guchar* result = NULL;
	struct gcry_cipher_handle* hd = NULL;
	struct gcry_cipher_handle* _tmp0_ = NULL;
	gcry_error_t _tmp1_ = 0U;
	gcry_error_t err;
	gcry_error_t _tmp2_;
	struct gcry_cipher_handle* _tmp12_;
	guchar* _tmp13_;
	gint _tmp13__length1;
	gcry_error_t _tmp14_ = 0U;
	gcry_error_t _tmp15_;
	struct gcry_cipher_handle* _tmp25_;
	guchar* _tmp26_;
	gint _tmp26__length1;
	gcry_error_t _tmp27_ = 0U;
	gcry_error_t _tmp28_;
	guchar* _tmp38_;
	gint _tmp38__length1;
	guchar* _tmp39_ = NULL;
	guchar* plain;
	gint plain_length1;
	gint _plain_size_;
	struct gcry_cipher_handle* _tmp40_;
	guchar* _tmp41_;
	gint _tmp41__length1;
	guchar* _tmp42_;
	gint _tmp42__length1;
	gcry_error_t _tmp43_ = 0U;
	gcry_error_t _tmp44_;
	guchar* _tmp54_;
	gint _tmp54__length1;
	GError * _inner_error_ = NULL;
	_tmp1_ = gcry_cipher_open (&_tmp0_, GCRY_CIPHER_ARCFOUR, GCRY_CIPHER_MODE_STREAM, (enum gcry_cipher_flags) 0);
	_gcry_cipher_close0 (hd);
	hd = _tmp0_;
	err = _tmp1_;
	_tmp2_ = err;
	if (_tmp2_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gcry_error_t _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		_tmp3_ = err;
		_tmp4_ = gcry_strsource (_tmp3_);
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = err;
		_tmp7_ = gcry_strerror (_tmp6_);
		_tmp8_ = g_strconcat ("libgcrypt: source: ", _tmp5_, " code: ", _tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_cipher_close0 (hd);
			return NULL;
		} else {
			_gcry_cipher_close0 (hd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = hd;
	_tmp13_ = key;
	_tmp13__length1 = key_length1;
	_tmp14_ = gcry_cipher_setkey (_tmp12_, _tmp13_, _tmp13__length1);
	err = _tmp14_;
	_tmp15_ = err;
	if (_tmp15_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp16_;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gcry_error_t _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		GError* _tmp24_;
		_tmp16_ = err;
		_tmp17_ = gcry_strsource (_tmp16_);
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = err;
		_tmp20_ = gcry_strerror (_tmp19_);
		_tmp21_ = g_strconcat ("libgcrypt: source: ", _tmp18_, " code: ", _tmp20_, "\n", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp24_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_cipher_close0 (hd);
			return NULL;
		} else {
			_gcry_cipher_close0 (hd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp25_ = hd;
	_tmp26_ = iv;
	_tmp26__length1 = iv_length1;
	_tmp27_ = gcry_cipher_setiv (_tmp25_, _tmp26_, _tmp26__length1);
	err = _tmp27_;
	_tmp28_ = err;
	if (_tmp28_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp29_;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gcry_error_t _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		_tmp29_ = err;
		_tmp30_ = gcry_strsource (_tmp29_);
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = err;
		_tmp33_ = gcry_strerror (_tmp32_);
		_tmp34_ = g_strconcat ("libgcrypt: source: ", _tmp31_, " code: ", _tmp33_, "\n", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_inner_error_ = _tmp37_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_cipher_close0 (hd);
			return NULL;
		} else {
			_gcry_cipher_close0 (hd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp38_ = ciph;
	_tmp38__length1 = ciph_length1;
	_tmp39_ = g_new0 (guchar, _tmp38__length1);
	plain = _tmp39_;
	plain_length1 = _tmp38__length1;
	_plain_size_ = plain_length1;
	_tmp40_ = hd;
	_tmp41_ = plain;
	_tmp41__length1 = plain_length1;
	_tmp42_ = ciph;
	_tmp42__length1 = ciph_length1;
	_tmp43_ = gcry_cipher_encrypt (_tmp40_, _tmp41_, _tmp41__length1, _tmp42_, _tmp42__length1);
	err = _tmp43_;
	_tmp44_ = err;
	if (_tmp44_ != ((gcry_error_t) 0)) {
		gcry_error_t _tmp45_;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gcry_error_t _tmp48_;
		const gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_;
		GError* _tmp52_;
		GError* _tmp53_;
		_tmp45_ = err;
		_tmp46_ = gcry_strsource (_tmp45_);
		_tmp47_ = string_to_string (_tmp46_);
		_tmp48_ = err;
		_tmp49_ = gcry_strerror (_tmp48_);
		_tmp50_ = g_strconcat ("libgcrypt: source: ", _tmp47_, " code: ", _tmp49_, "\n", NULL);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp51_);
		_tmp53_ = _tmp52_;
		_g_free0 (_tmp51_);
		_inner_error_ = _tmp53_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			plain = (g_free (plain), NULL);
			_gcry_cipher_close0 (hd);
			return NULL;
		} else {
			plain = (g_free (plain), NULL);
			_gcry_cipher_close0 (hd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp54_ = plain;
	_tmp54__length1 = plain_length1;
	if (result_length1) {
		*result_length1 = _tmp54__length1;
	}
	result = _tmp54_;
	_gcry_cipher_close0 (hd);
	return result;
}


guchar* netsukuku_crypto_create_random_session_key (gint l, int* result_length1) {
	guchar* result = NULL;
	gint _tmp0_;
	guchar* _tmp1_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = l;
	_tmp1_ = g_new0 (guchar, _tmp0_);
	ret = _tmp1_;
	ret_length1 = _tmp0_;
	_ret_size_ = ret_length1;
	gcry_create_nonce (ret, ret_length1);
	_tmp2_ = ret;
	_tmp2__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


void netsukuku_crypto_hex_dump (guint8* buf, int buf_length1) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guchar* p;
	gchar* _tmp1_;
	gchar* addrstr;
	gchar* _tmp2_;
	gchar* hexstr;
	gchar* _tmp3_;
	gchar* charstr;
	const gchar* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	_tmp0_ = buf;
	_tmp0__length1 = buf_length1;
	p = _tmp0_;
	_tmp1_ = g_strdup ("");
	addrstr = _tmp1_;
	_tmp2_ = g_strdup ("");
	hexstr = _tmp2_;
	_tmp3_ = g_strdup ("");
	charstr = _tmp3_;
	{
		gint n;
		n = 1;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				guint8* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				guchar* _tmp13_;
				guchar c;
				gboolean _tmp14_ = FALSE;
				guchar _tmp15_;
				gboolean _tmp18_;
				const gchar* _tmp19_;
				guchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				guchar _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gint _tmp29_;
				guchar* _tmp41_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = n;
					n = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = n;
				_tmp8_ = buf;
				_tmp8__length1 = buf_length1;
				if (!(_tmp7_ <= _tmp8__length1)) {
					break;
				}
				_tmp9_ = n;
				if ((_tmp9_ % 16) == 1) {
					guchar* _tmp10_;
					guint8* _tmp11_;
					gint _tmp11__length1;
					gchar* _tmp12_ = NULL;
					_tmp10_ = p;
					_tmp11_ = buf;
					_tmp11__length1 = buf_length1;
					_tmp12_ = g_strdup_printf ("%.4x", ((guint) _tmp10_) - ((guint) _tmp11_));
					_g_free0 (addrstr);
					addrstr = _tmp12_;
				}
				_tmp13_ = p;
				c = *_tmp13_;
				_tmp15_ = c;
				if (_tmp15_ == ((guchar) '\0')) {
					_tmp14_ = TRUE;
				} else {
					guchar _tmp16_;
					gint _tmp17_ = 0;
					_tmp16_ = c;
					_tmp17_ = string_index_of_char ("( ):-_qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890", (gunichar) _tmp16_, 0);
					_tmp14_ = _tmp17_ < 0;
				}
				_tmp18_ = _tmp14_;
				if (_tmp18_) {
					c = (guchar) '.';
				}
				_tmp19_ = hexstr;
				_tmp20_ = p;
				_tmp21_ = g_strdup_printf ("%02X ", (guint) (*_tmp20_));
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
				_g_free0 (hexstr);
				hexstr = _tmp23_;
				_g_free0 (_tmp22_);
				_tmp24_ = charstr;
				_tmp25_ = c;
				_tmp26_ = g_strdup_printf ("%c", (gint) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
				_g_free0 (charstr);
				charstr = _tmp28_;
				_g_free0 (_tmp27_);
				_tmp29_ = n;
				if ((_tmp29_ % 16) == 0) {
					FILE* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp30_ = stdout;
					_tmp31_ = addrstr;
					_tmp32_ = hexstr;
					_tmp33_ = charstr;
					fprintf (_tmp30_, "[%4.4s]   %-50.50s  %s\n", _tmp31_, _tmp32_, _tmp33_);
					_tmp34_ = g_strdup ("");
					_g_free0 (hexstr);
					hexstr = _tmp34_;
					_tmp35_ = g_strdup ("");
					_g_free0 (charstr);
					charstr = _tmp35_;
				} else {
					gint _tmp36_;
					_tmp36_ = n;
					if ((_tmp36_ % 16) == 8) {
						const gchar* _tmp37_;
						gchar* _tmp38_;
						const gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp37_ = hexstr;
						_tmp38_ = g_strconcat (_tmp37_, "  ", NULL);
						_g_free0 (hexstr);
						hexstr = _tmp38_;
						_tmp39_ = charstr;
						_tmp40_ = g_strconcat (_tmp39_, " ", NULL);
						_g_free0 (charstr);
						charstr = _tmp40_;
					}
				}
				_tmp41_ = p;
				p = _tmp41_ + 1;
			}
		}
	}
	_tmp42_ = hexstr;
	_tmp43_ = strlen (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ > 0) {
		FILE* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		_tmp45_ = stdout;
		_tmp46_ = addrstr;
		_tmp47_ = hexstr;
		_tmp48_ = charstr;
		fprintf (_tmp45_, "[%4.4s]   %-50.50s  %s\n", _tmp46_, _tmp47_, _tmp48_);
	}
	_g_free0 (charstr);
	_g_free0 (hexstr);
	_g_free0 (addrstr);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static guchar* _vala_array_dup3 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


static guchar* _vala_array_dup4 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


guchar* netsukuku_crypto_asym_encrypt (guchar* message, int message_length1, struct gcry_sexp* pkey, int* result_length1, GError** error) {
	guchar* result = NULL;
	gint _tmp0_ = 0;
	guchar* _tmp1_ = NULL;
	guchar* session_key;
	gint session_key_length1;
	gint _session_key_size_;
	gboolean _tmp2_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	struct gcry_sexp* _tmp6_;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gint _tmp9__length1;
	gint __tmp9__size_;
	guchar* asym_enc_session_key;
	gint asym_enc_session_key_length1;
	gint _asym_enc_session_key_size_;
	guchar* _tmp10_;
	gint _tmp10__length1;
	guchar* _tmp11_;
	gint _tmp11__length1;
	guchar* _tmp12_ = NULL;
	guchar* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_ = 0;
	guchar* _tmp15_ = NULL;
	guchar* _tmp16_;
	gint _tmp16__length1;
	guchar* sym_enc_message;
	gint sym_enc_message_length1;
	gint _sym_enc_message_size_;
	guchar* _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	guint8* _tmp20_;
	gint _tmp20__length1;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guchar* _tmp22_;
	gint _tmp22__length1;
	guchar* _tmp23_;
	gint _tmp23__length1;
	guchar* len_0;
	gint len_0_length1;
	gint _len_0_size_;
	guchar* _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	guint8* _tmp28_;
	gint _tmp28__length1;
	guchar* _tmp29_;
	gint _tmp29__length1;
	guchar* _tmp30_;
	gint _tmp30__length1;
	guchar* len_1;
	gint len_1_length1;
	gint _len_1_size_;
	guchar* _tmp31_;
	gint _tmp31__length1;
	guchar* _tmp32_;
	gint _tmp32__length1;
	guchar* _tmp33_;
	gint _tmp33__length1;
	guchar* _tmp34_;
	gint _tmp34__length1;
	guchar* _tmp35_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	gint j;
	guchar* _tmp80_;
	gint _tmp80__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (pkey != NULL, NULL);
	_tmp1_ = netsukuku_crypto_create_random_session_key (32, &_tmp0_);
	session_key = _tmp1_;
	session_key_length1 = _tmp0_;
	_session_key_size_ = session_key_length1;
	_tmp2_ = netsukuku_settings_TESTING;
	if (_tmp2_) {
		FILE* _tmp3_;
		guchar* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = stdout;
		fprintf (_tmp3_, "\nasym_encrypt: session_key follows:\n");
		_tmp4_ = session_key;
		_tmp4__length1 = session_key_length1;
		netsukuku_crypto_hex_dump ((guint8*) _tmp4_, (_tmp4__length1 * sizeof (guchar)) / sizeof (guint8));
	}
	_tmp5_ = session_key;
	_tmp5__length1 = session_key_length1;
	_tmp6_ = pkey;
	_tmp8_ = netsukuku_crypto_encrypt_session_key_get_rsa_mpi (_tmp5_, _tmp5__length1, _tmp6_, &_tmp7_, &_inner_error_);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp7_;
	__tmp9__size_ = _tmp9__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			session_key = (g_free (session_key), NULL);
			return NULL;
		} else {
			session_key = (g_free (session_key), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	asym_enc_session_key = (guchar*) _tmp9_;
	asym_enc_session_key_length1 = (_tmp9__length1 * sizeof (gchar)) / sizeof (guchar);
	_asym_enc_session_key_size_ = asym_enc_session_key_length1;
	_tmp10_ = message;
	_tmp10__length1 = message_length1;
	_tmp11_ = session_key;
	_tmp11__length1 = session_key_length1;
	_tmp12_ = g_new0 (guchar, 0);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 0;
	_tmp15_ = netsukuku_crypto_encrypt (_tmp10_, _tmp10__length1, _tmp11_, _tmp11__length1, _tmp13_, 0, &_tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	_tmp13_ = (g_free (_tmp13_), NULL);
	sym_enc_message = _tmp16_;
	sym_enc_message_length1 = _tmp16__length1;
	_sym_enc_message_size_ = sym_enc_message_length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
			session_key = (g_free (session_key), NULL);
			return NULL;
		} else {
			asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
			session_key = (g_free (session_key), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = asym_enc_session_key;
	_tmp17__length1 = asym_enc_session_key_length1;
	_tmp18_ = g_strdup_printf ("%d:", _tmp17__length1);
	_tmp19_ = _tmp18_;
	_tmp20_ = string_get_data (_tmp19_, &_tmp20__length1);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _tmp20__length1;
	_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup3 (_tmp21_, _tmp21__length1) : ((gpointer) _tmp21_);
	_tmp22__length1 = _tmp21__length1;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp22__length1;
	_g_free0 (_tmp19_);
	len_0 = _tmp23_;
	len_0_length1 = _tmp23__length1;
	_len_0_size_ = len_0_length1;
	_tmp24_ = sym_enc_message;
	_tmp24__length1 = sym_enc_message_length1;
	_tmp25_ = g_strdup_printf ("%d:", _tmp24__length1);
	_tmp26_ = _tmp25_;
	_tmp27_ = string_get_data (_tmp26_, &_tmp27__length1);
	_tmp28_ = _tmp27_;
	_tmp28__length1 = _tmp27__length1;
	_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup4 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
	_tmp29__length1 = _tmp28__length1;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = _tmp29__length1;
	_g_free0 (_tmp26_);
	len_1 = _tmp30_;
	len_1_length1 = _tmp30__length1;
	_len_1_size_ = len_1_length1;
	_tmp31_ = len_0;
	_tmp31__length1 = len_0_length1;
	_tmp32_ = asym_enc_session_key;
	_tmp32__length1 = asym_enc_session_key_length1;
	_tmp33_ = len_1;
	_tmp33__length1 = len_1_length1;
	_tmp34_ = sym_enc_message;
	_tmp34__length1 = sym_enc_message_length1;
	_tmp35_ = g_new0 (guchar, ((_tmp31__length1 + _tmp32__length1) + _tmp33__length1) + _tmp34__length1);
	ret = _tmp35_;
	ret_length1 = ((_tmp31__length1 + _tmp32__length1) + _tmp33__length1) + _tmp34__length1;
	_ret_size_ = ret_length1;
	j = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp36_;
			_tmp36_ = TRUE;
			while (TRUE) {
				gboolean _tmp37_;
				gint _tmp39_;
				guchar* _tmp40_;
				gint _tmp40__length1;
				guchar* _tmp41_;
				gint _tmp41__length1;
				gint _tmp42_;
				guchar* _tmp43_;
				gint _tmp43__length1;
				gint _tmp44_;
				guchar _tmp45_;
				guchar _tmp46_;
				_tmp37_ = _tmp36_;
				if (!_tmp37_) {
					gint _tmp38_;
					_tmp38_ = i;
					i = _tmp38_ + 1;
				}
				_tmp36_ = FALSE;
				_tmp39_ = i;
				_tmp40_ = len_0;
				_tmp40__length1 = len_0_length1;
				if (!(_tmp39_ < _tmp40__length1)) {
					break;
				}
				_tmp41_ = ret;
				_tmp41__length1 = ret_length1;
				_tmp42_ = j;
				j = _tmp42_ + 1;
				_tmp43_ = len_0;
				_tmp43__length1 = len_0_length1;
				_tmp44_ = i;
				_tmp45_ = _tmp43_[_tmp44_];
				_tmp41_[_tmp42_] = _tmp45_;
				_tmp46_ = _tmp41_[_tmp42_];
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp47_;
			_tmp47_ = TRUE;
			while (TRUE) {
				gboolean _tmp48_;
				gint _tmp50_;
				guchar* _tmp51_;
				gint _tmp51__length1;
				guchar* _tmp52_;
				gint _tmp52__length1;
				gint _tmp53_;
				guchar* _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				guchar _tmp56_;
				guchar _tmp57_;
				_tmp48_ = _tmp47_;
				if (!_tmp48_) {
					gint _tmp49_;
					_tmp49_ = i;
					i = _tmp49_ + 1;
				}
				_tmp47_ = FALSE;
				_tmp50_ = i;
				_tmp51_ = asym_enc_session_key;
				_tmp51__length1 = asym_enc_session_key_length1;
				if (!(_tmp50_ < _tmp51__length1)) {
					break;
				}
				_tmp52_ = ret;
				_tmp52__length1 = ret_length1;
				_tmp53_ = j;
				j = _tmp53_ + 1;
				_tmp54_ = asym_enc_session_key;
				_tmp54__length1 = asym_enc_session_key_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				_tmp52_[_tmp53_] = _tmp56_;
				_tmp57_ = _tmp52_[_tmp53_];
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp58_;
			_tmp58_ = TRUE;
			while (TRUE) {
				gboolean _tmp59_;
				gint _tmp61_;
				guchar* _tmp62_;
				gint _tmp62__length1;
				guchar* _tmp63_;
				gint _tmp63__length1;
				gint _tmp64_;
				guchar* _tmp65_;
				gint _tmp65__length1;
				gint _tmp66_;
				guchar _tmp67_;
				guchar _tmp68_;
				_tmp59_ = _tmp58_;
				if (!_tmp59_) {
					gint _tmp60_;
					_tmp60_ = i;
					i = _tmp60_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp61_ = i;
				_tmp62_ = len_1;
				_tmp62__length1 = len_1_length1;
				if (!(_tmp61_ < _tmp62__length1)) {
					break;
				}
				_tmp63_ = ret;
				_tmp63__length1 = ret_length1;
				_tmp64_ = j;
				j = _tmp64_ + 1;
				_tmp65_ = len_1;
				_tmp65__length1 = len_1_length1;
				_tmp66_ = i;
				_tmp67_ = _tmp65_[_tmp66_];
				_tmp63_[_tmp64_] = _tmp67_;
				_tmp68_ = _tmp63_[_tmp64_];
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp69_;
			_tmp69_ = TRUE;
			while (TRUE) {
				gboolean _tmp70_;
				gint _tmp72_;
				guchar* _tmp73_;
				gint _tmp73__length1;
				guchar* _tmp74_;
				gint _tmp74__length1;
				gint _tmp75_;
				guchar* _tmp76_;
				gint _tmp76__length1;
				gint _tmp77_;
				guchar _tmp78_;
				guchar _tmp79_;
				_tmp70_ = _tmp69_;
				if (!_tmp70_) {
					gint _tmp71_;
					_tmp71_ = i;
					i = _tmp71_ + 1;
				}
				_tmp69_ = FALSE;
				_tmp72_ = i;
				_tmp73_ = sym_enc_message;
				_tmp73__length1 = sym_enc_message_length1;
				if (!(_tmp72_ < _tmp73__length1)) {
					break;
				}
				_tmp74_ = ret;
				_tmp74__length1 = ret_length1;
				_tmp75_ = j;
				j = _tmp75_ + 1;
				_tmp76_ = sym_enc_message;
				_tmp76__length1 = sym_enc_message_length1;
				_tmp77_ = i;
				_tmp78_ = _tmp76_[_tmp77_];
				_tmp74_[_tmp75_] = _tmp78_;
				_tmp79_ = _tmp74_[_tmp75_];
			}
		}
	}
	_tmp80_ = ret;
	_tmp80__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp80__length1;
	}
	result = _tmp80_;
	len_1 = (g_free (len_1), NULL);
	len_0 = (g_free (len_0), NULL);
	sym_enc_message = (g_free (sym_enc_message), NULL);
	asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
	session_key = (g_free (session_key), NULL);
	return result;
}


guchar* netsukuku_crypto_asym_decrypt (guchar* ciph, int ciph_length1, struct gcry_sexp* skey, int* result_length1, GError** error) {
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	gint i;
	gint len_0;
	gint j_0;
	guchar* _tmp2_ = NULL;
	guchar* asym_enc_session_key;
	gint asym_enc_session_key_length1;
	gint _asym_enc_session_key_size_;
	gint len_1;
	gint j_1;
	guchar* _tmp3_ = NULL;
	guchar* sym_enc_message;
	gint sym_enc_message_length1;
	gint _sym_enc_message_size_;
	gint phase;
	gint _tmp46_;
	gboolean _tmp48_;
	gboolean _tmp51_;
	guchar* _tmp54_;
	gint _tmp54__length1;
	struct gcry_sexp* _tmp55_;
	gint _tmp56_ = 0;
	guchar* _tmp57_ = NULL;
	guchar* session_key;
	gint session_key_length1;
	gint _session_key_size_;
	gboolean _tmp58_;
	guchar* _tmp61_;
	gint _tmp61__length1;
	guchar* _tmp62_;
	gint _tmp62__length1;
	guchar* _tmp63_ = NULL;
	guchar* _tmp64_;
	gint _tmp64__length1;
	gint _tmp65_ = 0;
	guchar* _tmp66_ = NULL;
	guchar* _tmp67_;
	gint _tmp67__length1;
	guchar* _tmp68_;
	gint _tmp68__length1;
	gint __tmp68__size_;
	guchar* _tmp69_;
	gint _tmp69__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (skey != NULL, NULL);
	_tmp0_ = ciph;
	_tmp0__length1 = ciph_length1;
	if (_tmp0__length1 < 6) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, "Failure: malformed encrypted message.");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	i = 0;
	len_0 = 0;
	j_0 = 0;
	_tmp2_ = g_new0 (guchar, 0);
	asym_enc_session_key = _tmp2_;
	asym_enc_session_key_length1 = 0;
	_asym_enc_session_key_size_ = asym_enc_session_key_length1;
	len_1 = 0;
	j_1 = 0;
	_tmp3_ = g_new0 (guchar, 0);
	sym_enc_message = _tmp3_;
	sym_enc_message_length1 = 0;
	_sym_enc_message_size_ = sym_enc_message_length1;
	phase = 0;
	while (TRUE) {
		gint _tmp4_;
		guchar* _tmp5_;
		gint _tmp5__length1;
		guchar* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
		guchar _tmp8_;
		guchar c;
		gint _tmp9_;
		gint _tmp45_;
		_tmp4_ = i;
		_tmp5_ = ciph;
		_tmp5__length1 = ciph_length1;
		if (!(_tmp4_ < _tmp5__length1)) {
			break;
		}
		_tmp6_ = ciph;
		_tmp6__length1 = ciph_length1;
		_tmp7_ = i;
		_tmp8_ = _tmp6_[_tmp7_];
		c = _tmp8_;
		_tmp9_ = phase;
		switch (_tmp9_) {
			case 0:
			{
				guchar _tmp10_;
				guchar _tmp15_;
				gint _tmp16_ = 0;
				gint _tmp18_;
				gint _tmp19_;
				guchar _tmp20_;
				_tmp10_ = c;
				if (_tmp10_ == ((guchar) ':')) {
					gint _tmp11_;
					gint _tmp13_;
					guchar* _tmp14_ = NULL;
					_tmp11_ = len_0;
					if (_tmp11_ == 0) {
						GError* _tmp12_;
						_tmp12_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, "Failure: malformed encrypted message.");
						_inner_error_ = _tmp12_;
						if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
							g_propagate_error (error, _inner_error_);
							sym_enc_message = (g_free (sym_enc_message), NULL);
							asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
							return NULL;
						} else {
							sym_enc_message = (g_free (sym_enc_message), NULL);
							asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					phase = 1;
					_tmp13_ = len_0;
					_tmp14_ = g_new0 (guchar, _tmp13_);
					asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
					asym_enc_session_key = _tmp14_;
					asym_enc_session_key_length1 = _tmp13_;
					_asym_enc_session_key_size_ = asym_enc_session_key_length1;
					break;
				}
				_tmp15_ = c;
				_tmp16_ = string_index_of_char ("0123456789", (gunichar) _tmp15_, 0);
				if (_tmp16_ < 0) {
					GError* _tmp17_;
					_tmp17_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, "Failure: malformed encrypted message.");
					_inner_error_ = _tmp17_;
					if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
						g_propagate_error (error, _inner_error_);
						sym_enc_message = (g_free (sym_enc_message), NULL);
						asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
						return NULL;
					} else {
						sym_enc_message = (g_free (sym_enc_message), NULL);
						asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp18_ = len_0;
				len_0 = _tmp18_ * 10;
				_tmp19_ = len_0;
				_tmp20_ = c;
				len_0 = _tmp19_ + ((gint) (_tmp20_ - '0'));
				break;
			}
			case 1:
			{
				guchar* _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				guchar _tmp23_;
				guchar _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				_tmp21_ = asym_enc_session_key;
				_tmp21__length1 = asym_enc_session_key_length1;
				_tmp22_ = j_0;
				j_0 = _tmp22_ + 1;
				_tmp23_ = c;
				_tmp21_[_tmp22_] = _tmp23_;
				_tmp24_ = _tmp21_[_tmp22_];
				_tmp25_ = j_0;
				_tmp26_ = len_0;
				if (_tmp25_ == _tmp26_) {
					phase = 2;
				}
				break;
			}
			case 2:
			{
				guchar _tmp27_;
				guchar _tmp32_;
				gint _tmp33_ = 0;
				gint _tmp35_;
				gint _tmp36_;
				guchar _tmp37_;
				_tmp27_ = c;
				if (_tmp27_ == ((guchar) ':')) {
					gint _tmp28_;
					gint _tmp30_;
					guchar* _tmp31_ = NULL;
					_tmp28_ = len_1;
					if (_tmp28_ == 0) {
						GError* _tmp29_;
						_tmp29_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, "Failure: malformed encrypted message.");
						_inner_error_ = _tmp29_;
						if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
							g_propagate_error (error, _inner_error_);
							sym_enc_message = (g_free (sym_enc_message), NULL);
							asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
							return NULL;
						} else {
							sym_enc_message = (g_free (sym_enc_message), NULL);
							asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					phase = 3;
					_tmp30_ = len_1;
					_tmp31_ = g_new0 (guchar, _tmp30_);
					sym_enc_message = (g_free (sym_enc_message), NULL);
					sym_enc_message = _tmp31_;
					sym_enc_message_length1 = _tmp30_;
					_sym_enc_message_size_ = sym_enc_message_length1;
					break;
				}
				_tmp32_ = c;
				_tmp33_ = string_index_of_char ("0123456789", (gunichar) _tmp32_, 0);
				if (_tmp33_ < 0) {
					GError* _tmp34_;
					_tmp34_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, "Failure: malformed encrypted message.");
					_inner_error_ = _tmp34_;
					if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
						g_propagate_error (error, _inner_error_);
						sym_enc_message = (g_free (sym_enc_message), NULL);
						asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
						return NULL;
					} else {
						sym_enc_message = (g_free (sym_enc_message), NULL);
						asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp35_ = len_1;
				len_1 = _tmp35_ * 10;
				_tmp36_ = len_1;
				_tmp37_ = c;
				len_1 = _tmp36_ + ((gint) (_tmp37_ - '0'));
				break;
			}
			case 3:
			{
				guchar* _tmp38_;
				gint _tmp38__length1;
				gint _tmp39_;
				guchar _tmp40_;
				guchar _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				_tmp38_ = sym_enc_message;
				_tmp38__length1 = sym_enc_message_length1;
				_tmp39_ = j_1;
				j_1 = _tmp39_ + 1;
				_tmp40_ = c;
				_tmp38_[_tmp39_] = _tmp40_;
				_tmp41_ = _tmp38_[_tmp39_];
				_tmp42_ = j_1;
				_tmp43_ = len_1;
				if (_tmp42_ == _tmp43_) {
					phase = 4;
				}
				break;
			}
			case 4:
			{
				GError* _tmp44_;
				_tmp44_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, "Failure: malformed encrypted message.");
				_inner_error_ = _tmp44_;
				if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
					g_propagate_error (error, _inner_error_);
					sym_enc_message = (g_free (sym_enc_message), NULL);
					asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
					return NULL;
				} else {
					sym_enc_message = (g_free (sym_enc_message), NULL);
					asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			default:
			break;
		}
		_tmp45_ = i;
		i = _tmp45_ + 1;
	}
	_tmp46_ = phase;
	if (_tmp46_ != 4) {
		GError* _tmp47_;
		_tmp47_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, "Failure: malformed encrypted message.");
		_inner_error_ = _tmp47_;
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			sym_enc_message = (g_free (sym_enc_message), NULL);
			asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
			return NULL;
		} else {
			sym_enc_message = (g_free (sym_enc_message), NULL);
			asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp48_ = netsukuku_settings_TESTING;
	if (_tmp48_) {
		FILE* _tmp49_;
		guchar* _tmp50_;
		gint _tmp50__length1;
		_tmp49_ = stdout;
		fprintf (_tmp49_, "\nasym_decrypt: asym_enc_session_key follows:\n");
		_tmp50_ = asym_enc_session_key;
		_tmp50__length1 = asym_enc_session_key_length1;
		netsukuku_crypto_hex_dump ((guint8*) _tmp50_, (_tmp50__length1 * sizeof (guchar)) / sizeof (guint8));
	}
	_tmp51_ = netsukuku_settings_TESTING;
	if (_tmp51_) {
		FILE* _tmp52_;
		guchar* _tmp53_;
		gint _tmp53__length1;
		_tmp52_ = stdout;
		fprintf (_tmp52_, "\nasym_decrypt: sym_enc_message follows:\n");
		_tmp53_ = sym_enc_message;
		_tmp53__length1 = sym_enc_message_length1;
		netsukuku_crypto_hex_dump ((guint8*) _tmp53_, (_tmp53__length1 * sizeof (guchar)) / sizeof (guint8));
	}
	_tmp54_ = asym_enc_session_key;
	_tmp54__length1 = asym_enc_session_key_length1;
	_tmp55_ = skey;
	_tmp57_ = netsukuku_crypto_decrypt_session_key_from_rsa_mpi ((gchar*) _tmp54_, (_tmp54__length1 * sizeof (guchar)) / sizeof (gchar), _tmp55_, &_tmp56_, &_inner_error_);
	session_key = _tmp57_;
	session_key_length1 = _tmp56_;
	_session_key_size_ = session_key_length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			sym_enc_message = (g_free (sym_enc_message), NULL);
			asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
			return NULL;
		} else {
			sym_enc_message = (g_free (sym_enc_message), NULL);
			asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp58_ = netsukuku_settings_TESTING;
	if (_tmp58_) {
		FILE* _tmp59_;
		guchar* _tmp60_;
		gint _tmp60__length1;
		_tmp59_ = stdout;
		fprintf (_tmp59_, "\nasym_decrypt: session_key follows:\n");
		_tmp60_ = session_key;
		_tmp60__length1 = session_key_length1;
		netsukuku_crypto_hex_dump ((guint8*) _tmp60_, (_tmp60__length1 * sizeof (guchar)) / sizeof (guint8));
	}
	_tmp61_ = sym_enc_message;
	_tmp61__length1 = sym_enc_message_length1;
	_tmp62_ = session_key;
	_tmp62__length1 = session_key_length1;
	_tmp63_ = g_new0 (guchar, 0);
	_tmp64_ = _tmp63_;
	_tmp64__length1 = 0;
	_tmp66_ = netsukuku_crypto_decrypt (_tmp61_, _tmp61__length1, _tmp62_, _tmp62__length1, _tmp64_, 0, &_tmp65_, &_inner_error_);
	_tmp67_ = _tmp66_;
	_tmp67__length1 = _tmp65_;
	_tmp64_ = (g_free (_tmp64_), NULL);
	_tmp68_ = _tmp67_;
	_tmp68__length1 = _tmp67__length1;
	__tmp68__size_ = _tmp68__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			session_key = (g_free (session_key), NULL);
			sym_enc_message = (g_free (sym_enc_message), NULL);
			asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
			return NULL;
		} else {
			session_key = (g_free (session_key), NULL);
			sym_enc_message = (g_free (sym_enc_message), NULL);
			asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp69_ = _tmp68_;
	_tmp69__length1 = _tmp68__length1;
	if (result_length1) {
		*result_length1 = _tmp69__length1;
	}
	result = _tmp69_;
	session_key = (g_free (session_key), NULL);
	sym_enc_message = (g_free (sym_enc_message), NULL);
	asym_enc_session_key = (g_free (asym_enc_session_key), NULL);
	return result;
}


gchar* netsukuku_crypto_short_repr (guint8* pubkey) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	guint8* _tmp1_;
	guchar* p;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	_tmp0_ = g_strdup ("...");
	ret = _tmp0_;
	_tmp1_ = pubkey;
	p = (guchar*) (_tmp1_ + 80);
	{
		gint n;
		n = 1;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				const gchar* _tmp6_;
				guchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_;
				guchar* _tmp11_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = n;
					n = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = n;
				if (!(_tmp5_ <= 16)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = p;
				_tmp8_ = g_strdup_printf ("%02X", (guint) (*_tmp7_));
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
				_g_free0 (ret);
				ret = _tmp10_;
				_g_free0 (_tmp9_);
				_tmp11_ = p;
				p = _tmp11_ + 1;
			}
		}
	}
	_tmp12_ = ret;
	_tmp13_ = g_strconcat (_tmp12_, "...", NULL);
	result = _tmp13_;
	_g_free0 (ret);
	return result;
}


NetsukukuKeyPair* netsukuku_key_pair_construct (GType object_type, const gchar* from_file, GError** error) {
	NetsukukuKeyPair * self = NULL;
	const gchar* _tmp0_;
	struct gcry_sexp* _tmp9_;
	struct gcry_sexp* _tmp10_ = NULL;
	struct gcry_sexp* _tmp11_;
	struct gcry_sexp* _tmp12_ = NULL;
	struct gcry_sexp* _tmp13_;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	guint8* _tmp16_;
	gint _tmp16__length1;
	NetsukukuPublicKeyWrapper* _tmp17_;
	NetsukukuPublicKeyWrapper* _tmp18_;
	NetsukukuPublicKeyWrapper* _tmp19_;
	NetsukukuPublicKeyWrapper* _tmp20_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuKeyPair*) g_object_new (object_type, NULL);
	_tmp0_ = from_file;
	if (_tmp0_ == NULL) {
		struct gcry_sexp* _tmp1_ = NULL;
		struct gcry_sexp* _tmp2_;
		_tmp1_ = netsukuku_crypto_generate_keypair (&_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_gcry_sexp_release0 (self->priv->keypair);
		self->priv->keypair = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gint _tmp4_ = 0;
		guint8* _tmp5_ = NULL;
		guint8* buffer;
		gint buffer_length1;
		gint _buffer_size_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		struct gcry_sexp* _tmp7_ = NULL;
		struct gcry_sexp* _tmp8_;
		_tmp3_ = from_file;
		_tmp5_ = netsukuku_crypto_read_file (_tmp3_, 2000, &_tmp4_);
		buffer = _tmp5_;
		buffer_length1 = _tmp4_;
		_buffer_size_ = buffer_length1;
		_tmp6_ = buffer;
		_tmp6__length1 = buffer_length1;
		_tmp7_ = netsukuku_crypto_recreate_sexp (_tmp6_, _tmp6__length1, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
				g_propagate_error (error, _inner_error_);
				buffer = (g_free (buffer), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				buffer = (g_free (buffer), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_gcry_sexp_release0 (self->priv->keypair);
		self->priv->keypair = _tmp8_;
		buffer = (g_free (buffer), NULL);
	}
	_tmp9_ = self->priv->keypair;
	_tmp10_ = netsukuku_crypto_getpubkey (_tmp9_);
	_gcry_sexp_release0 (self->priv->pkey);
	self->priv->pkey = _tmp10_;
	_tmp11_ = self->priv->keypair;
	_tmp12_ = netsukuku_crypto_getprivkey (_tmp11_);
	_gcry_sexp_release0 (self->priv->skey);
	self->priv->skey = _tmp12_;
	_tmp13_ = self->priv->pkey;
	_tmp15_ = netsukuku_crypto_serialize_sexp (_tmp13_, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	_tmp17_ = netsukuku_public_key_wrapper_new_from_pem (_tmp16_, _tmp14_, &_inner_error_);
	_tmp18_ = _tmp17_;
	_tmp16_ = (g_free (_tmp16_), NULL);
	_tmp19_ = _tmp18_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp20_ = _tmp19_;
	netsukuku_key_pair_set_pub_key (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	return self;
}


NetsukukuKeyPair* netsukuku_key_pair_new (const gchar* from_file, GError** error) {
	return netsukuku_key_pair_construct (NETSUKUKU_TYPE_KEY_PAIR, from_file, error);
}


void netsukuku_key_pair_save_pair (NetsukukuKeyPair* self, const gchar* keys_path, GError** error) {
	struct gcry_sexp* _tmp0_;
	gint _tmp1_ = 0;
	guint8* _tmp2_ = NULL;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keys_path != NULL);
	_tmp0_ = self->priv->keypair;
	_tmp2_ = netsukuku_crypto_serialize_sexp (_tmp0_, &_tmp1_);
	buffer = _tmp2_;
	buffer_length1 = _tmp1_;
	_buffer_size_ = buffer_length1;
	{
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = keys_path;
		_tmp4_ = buffer;
		_tmp4__length1 = buffer_length1;
		netsukuku_crypto_write_file (_tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_CRYPTO_FILE_ERROR) {
				goto __catch9_netsukuku_crypto_file_error;
			}
			buffer = (g_free (buffer), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally9;
	__catch9_netsukuku_crypto_file_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Failed to save key pair: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp11_;
		_g_error_free0 (e);
		goto __finally9;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			buffer = (g_free (buffer), NULL);
			return;
		} else {
			buffer = (g_free (buffer), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	buffer = (g_free (buffer), NULL);
}


void netsukuku_key_pair_save_pub_key (NetsukukuKeyPair* self, const gchar* pk_path, GError** error) {
	struct gcry_sexp* _tmp0_;
	gint _tmp1_ = 0;
	guint8* _tmp2_ = NULL;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pk_path != NULL);
	_tmp0_ = self->priv->pkey;
	_tmp2_ = netsukuku_crypto_serialize_sexp (_tmp0_, &_tmp1_);
	buffer = _tmp2_;
	buffer_length1 = _tmp1_;
	_buffer_size_ = buffer_length1;
	{
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = pk_path;
		_tmp4_ = buffer;
		_tmp4__length1 = buffer_length1;
		netsukuku_crypto_write_file (_tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_CRYPTO_FILE_ERROR) {
				goto __catch10_netsukuku_crypto_file_error;
			}
			buffer = (g_free (buffer), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally10;
	__catch10_netsukuku_crypto_file_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Failed to save public key: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp11_;
		_g_error_free0 (e);
		goto __finally10;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			buffer = (g_free (buffer), NULL);
			return;
		} else {
			buffer = (g_free (buffer), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	buffer = (g_free (buffer), NULL);
}


static guchar* _vala_array_dup5 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error) {
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_ = NULL;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint __tmp3__size_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	struct gcry_sexp* _tmp5_;
	struct gcry_sexp* _tmp6_ = NULL;
	struct gcry_sexp* _tmp7_;
	struct gcry_sexp* signature;
	struct gcry_sexp* _tmp8_;
	gint _tmp9_ = 0;
	guint8* _tmp10_ = NULL;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	guchar* _tmp12_;
	gint _tmp12__length1;
	guchar* _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = msg;
	_tmp0__length1 = msg_length1;
	_tmp2_ = netsukuku_crypto_md5 ((guint8*) _tmp0_, (_tmp0__length1 * sizeof (guchar)) / sizeof (guint8), &_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	__tmp3__size_ = _tmp3__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = self->priv->skey;
	_tmp6_ = netsukuku_crypto_sign (_tmp4_, _tmp3__length1, _tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	signature = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = signature;
	_tmp10_ = netsukuku_crypto_serialize_sexp (_tmp8_, &_tmp9_);
	buffer = _tmp10_;
	buffer_length1 = _tmp9_;
	_buffer_size_ = buffer_length1;
	_tmp11_ = buffer;
	_tmp11__length1 = buffer_length1;
	_tmp12_ = (((guchar*) _tmp11_) != NULL) ? _vala_array_dup5 ((guchar*) _tmp11_, (_tmp11__length1 * sizeof (guint8)) / sizeof (guchar)) : ((gpointer) ((guchar*) _tmp11_));
	_tmp12__length1 = (_tmp11__length1 * sizeof (guint8)) / sizeof (guchar);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	buffer = (g_free (buffer), NULL);
	_gcry_sexp_release0 (signature);
	return result;
}


guchar* netsukuku_key_pair_decrypt (NetsukukuKeyPair* self, guchar* cypher, int cypher_length1, int* result_length1, GError** error) {
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	struct gcry_sexp* _tmp1_;
	gint _tmp2_ = 0;
	guchar* _tmp3_ = NULL;
	guchar* _tmp4_;
	gint _tmp4__length1;
	gint __tmp4__size_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cypher;
	_tmp0__length1 = cypher_length1;
	_tmp1_ = self->priv->skey;
	_tmp3_ = netsukuku_crypto_asym_decrypt (_tmp0_, _tmp0__length1, _tmp1_, &_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	__tmp4__size_ = _tmp4__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}


gchar* netsukuku_key_pair_to_string (NetsukukuKeyPair* self) {
	gchar* result = NULL;
	NetsukukuPublicKeyWrapper* _tmp0_;
	NetsukukuPublicKey* _tmp1_ = NULL;
	NetsukukuPublicKey* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pub_key;
	_tmp1_ = netsukuku_public_key_wrapper_to_pubkey (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_public_key_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("<KeyPair pubkey='", _tmp4_, "'>", NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self) {
	NetsukukuPublicKeyWrapper* result;
	NetsukukuPublicKeyWrapper* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pub_key;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void netsukuku_key_pair_set_pub_key (NetsukukuKeyPair* self, NetsukukuPublicKeyWrapper* value) {
	NetsukukuPublicKeyWrapper* _tmp0_;
	NetsukukuPublicKeyWrapper* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_pub_key);
	self->priv->_pub_key = _tmp1_;
	g_object_notify ((GObject *) self, "pub-key");
}


static void netsukuku_key_pair_class_init (NetsukukuKeyPairClass * klass) {
	netsukuku_key_pair_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuKeyPairPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_key_pair_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_key_pair_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_key_pair_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_KEY_PAIR_PUB_KEY, g_param_spec_object ("pub-key", "pub-key", "pub-key", NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_key_pair_instance_init (NetsukukuKeyPair * self) {
	self->priv = NETSUKUKU_KEY_PAIR_GET_PRIVATE (self);
}


static void netsukuku_key_pair_finalize (GObject* obj) {
	NetsukukuKeyPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair);
	_gcry_sexp_release0 (self->priv->keypair);
	_gcry_sexp_release0 (self->priv->pkey);
	_gcry_sexp_release0 (self->priv->skey);
	_g_object_unref0 (self->priv->_pub_key);
	G_OBJECT_CLASS (netsukuku_key_pair_parent_class)->finalize (obj);
}


/**
      */
GType netsukuku_key_pair_get_type (void) {
	static volatile gsize netsukuku_key_pair_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_key_pair_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuKeyPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_key_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuKeyPair), 0, (GInstanceInitFunc) netsukuku_key_pair_instance_init, NULL };
		GType netsukuku_key_pair_type_id;
		netsukuku_key_pair_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuKeyPair", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_key_pair_type_id__volatile, netsukuku_key_pair_type_id);
	}
	return netsukuku_key_pair_type_id__volatile;
}


static void _vala_netsukuku_key_pair_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuKeyPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair);
	switch (property_id) {
		case NETSUKUKU_KEY_PAIR_PUB_KEY:
		g_value_set_object (value, netsukuku_key_pair_get_pub_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_key_pair_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuKeyPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair);
	switch (property_id) {
		case NETSUKUKU_KEY_PAIR_PUB_KEY:
		netsukuku_key_pair_set_pub_key (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static guint8* _vala_array_dup6 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct (GType object_type, guint8* from_pem, int from_pem_length1, const gchar* from_file, NetsukukuPublicKey* from_pubk, GError** error) {
	NetsukukuPublicKeyWrapper * self = NULL;
	guint8* buffer = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	guint8* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	self = (NetsukukuPublicKeyWrapper*) g_object_new (object_type, NULL);
	_tmp0_ = from_pem;
	_tmp0__length1 = from_pem_length1;
	if (_tmp0_ != NULL) {
		guint8* _tmp1_;
		gint _tmp1__length1;
		guint8* _tmp2_;
		gint _tmp2__length1;
		guint8* _tmp3_;
		gint _tmp3__length1;
		struct gcry_sexp* _tmp4_ = NULL;
		struct gcry_sexp* _tmp5_;
		_tmp1_ = from_pem;
		_tmp1__length1 = from_pem_length1;
		_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup6 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
		_tmp2__length1 = _tmp1__length1;
		buffer = (g_free (buffer), NULL);
		buffer = _tmp2_;
		buffer_length1 = _tmp2__length1;
		_buffer_size_ = buffer_length1;
		_tmp3_ = buffer;
		_tmp3__length1 = buffer_length1;
		_tmp4_ = netsukuku_crypto_recreate_sexp (_tmp3_, _tmp3__length1, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
				g_propagate_error (error, _inner_error_);
				buffer = (g_free (buffer), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				buffer = (g_free (buffer), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_gcry_sexp_release0 (self->priv->pkey);
		self->priv->pkey = _tmp5_;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = from_file;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			gint _tmp8_ = 0;
			guint8* _tmp9_ = NULL;
			guint8* _tmp10_;
			gint _tmp10__length1;
			struct gcry_sexp* _tmp11_ = NULL;
			struct gcry_sexp* _tmp12_;
			_tmp7_ = from_file;
			_tmp9_ = netsukuku_crypto_read_file (_tmp7_, 2000, &_tmp8_);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp9_;
			buffer_length1 = _tmp8_;
			_buffer_size_ = buffer_length1;
			_tmp10_ = buffer;
			_tmp10__length1 = buffer_length1;
			_tmp11_ = netsukuku_crypto_recreate_sexp (_tmp10_, _tmp10__length1, &_inner_error_);
			_tmp12_ = _tmp11_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
					g_propagate_error (error, _inner_error_);
					buffer = (g_free (buffer), NULL);
					_g_object_unref0 (self);
					return NULL;
				} else {
					buffer = (g_free (buffer), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_gcry_sexp_release0 (self->priv->pkey);
			self->priv->pkey = _tmp12_;
		} else {
			NetsukukuPublicKey* _tmp13_;
			zcdSerializableBuffer* _tmp14_;
			zcdSerializableBuffer* _tmp15_;
			guint8* _tmp16_;
			gint _tmp16__length1;
			guint8* _tmp17_;
			gint _tmp17__length1;
			struct gcry_sexp* _tmp18_ = NULL;
			struct gcry_sexp* _tmp19_;
			_tmp13_ = from_pubk;
			_tmp14_ = netsukuku_public_key_get_x (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = zcd_serializable_buffer_get_buffer (_tmp15_, &_tmp16__length1);
			_tmp17_ = _tmp16_;
			_tmp17__length1 = _tmp16__length1;
			_tmp18_ = netsukuku_crypto_recreate_sexp (_tmp17_, _tmp17__length1, &_inner_error_);
			_tmp19_ = _tmp18_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
					g_propagate_error (error, _inner_error_);
					buffer = (g_free (buffer), NULL);
					_g_object_unref0 (self);
					return NULL;
				} else {
					buffer = (g_free (buffer), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_gcry_sexp_release0 (self->priv->pkey);
			self->priv->pkey = _tmp19_;
		}
	}
	buffer = (g_free (buffer), NULL);
	return self;
}


static NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new (guint8* from_pem, int from_pem_length1, const gchar* from_file, NetsukukuPublicKey* from_pubk, GError** error) {
	return netsukuku_public_key_wrapper_construct (NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, from_pem, from_pem_length1, from_file, from_pubk, error);
}


NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pem (GType object_type, guint8* from_pem, int from_pem_length1, GError** error) {
	NetsukukuPublicKeyWrapper * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = from_pem;
	_tmp0__length1 = from_pem_length1;
	self = (NetsukukuPublicKeyWrapper*) netsukuku_public_key_wrapper_construct (object_type, _tmp0_, _tmp0__length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pem (guint8* from_pem, int from_pem_length1, GError** error) {
	return netsukuku_public_key_wrapper_construct_from_pem (NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, from_pem, from_pem_length1, error);
}


NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_file (GType object_type, const gchar* from_file, GError** error) {
	NetsukukuPublicKeyWrapper * self = NULL;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (from_file != NULL, NULL);
	_tmp0_ = from_file;
	self = (NetsukukuPublicKeyWrapper*) netsukuku_public_key_wrapper_construct (object_type, NULL, 0, _tmp0_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_file (const gchar* from_file, GError** error) {
	return netsukuku_public_key_wrapper_construct_from_file (NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, from_file, error);
}


NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pubk (GType object_type, NetsukukuPublicKey* from_pubk, GError** error) {
	NetsukukuPublicKeyWrapper * self = NULL;
	NetsukukuPublicKey* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (from_pubk != NULL, NULL);
	_tmp0_ = from_pubk;
	self = (NetsukukuPublicKeyWrapper*) netsukuku_public_key_wrapper_construct (object_type, NULL, 0, NULL, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pubk (NetsukukuPublicKey* from_pubk, GError** error) {
	return netsukuku_public_key_wrapper_construct_from_pubk (NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, from_pubk, error);
}


void netsukuku_public_key_wrapper_save_pub_key (NetsukukuPublicKeyWrapper* self, const gchar* pk_path, GError** error) {
	struct gcry_sexp* _tmp0_;
	gint _tmp1_ = 0;
	guint8* _tmp2_ = NULL;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pk_path != NULL);
	_tmp0_ = self->priv->pkey;
	_tmp2_ = netsukuku_crypto_serialize_sexp (_tmp0_, &_tmp1_);
	buffer = _tmp2_;
	buffer_length1 = _tmp1_;
	_buffer_size_ = buffer_length1;
	{
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = pk_path;
		_tmp4_ = buffer;
		_tmp4__length1 = buffer_length1;
		netsukuku_crypto_write_file (_tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_CRYPTO_FILE_ERROR) {
				goto __catch11_netsukuku_crypto_file_error;
			}
			buffer = (g_free (buffer), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally11;
	__catch11_netsukuku_crypto_file_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Failed to save public key: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (NETSUKUKU_CRYPTO_GCRYPT_ERROR, NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp11_;
		_g_error_free0 (e);
		goto __finally11;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			buffer = (g_free (buffer), NULL);
			return;
		} else {
			buffer = (g_free (buffer), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	buffer = (g_free (buffer), NULL);
}


gboolean netsukuku_public_key_wrapper_verify (NetsukukuPublicKeyWrapper* self, guchar* msg, int msg_length1, guchar* signature, int signature_length1, GError** error) {
	gboolean result = FALSE;
	guchar* _tmp0_;
	gint _tmp0__length1;
	struct gcry_sexp* _tmp1_ = NULL;
	struct gcry_sexp* sig;
	guchar* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	guint8* _tmp4_ = NULL;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	struct gcry_sexp* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	struct gcry_sexp* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = signature;
	_tmp0__length1 = signature_length1;
	_tmp1_ = netsukuku_crypto_recreate_sexp ((guint8*) _tmp0_, (_tmp0__length1 * sizeof (guchar)) / sizeof (guint8), &_inner_error_);
	sig = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp2_ = msg;
	_tmp2__length1 = msg_length1;
	_tmp4_ = netsukuku_crypto_md5 ((guint8*) _tmp2_, (_tmp2__length1 * sizeof (guchar)) / sizeof (guint8), &_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	__tmp5__size_ = _tmp5__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (sig);
			return FALSE;
		} else {
			_gcry_sexp_release0 (sig);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp6_ = sig;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	_tmp8_ = self->priv->pkey;
	_tmp9_ = netsukuku_crypto_verify (_tmp6_, _tmp7_, _tmp5__length1, _tmp8_, &_inner_error_);
	_tmp10_ = _tmp9_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_gcry_sexp_release0 (sig);
			return FALSE;
		} else {
			_gcry_sexp_release0 (sig);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp11_;
	_gcry_sexp_release0 (sig);
	return result;
}


guchar* netsukuku_public_key_wrapper_encrypt (NetsukukuPublicKeyWrapper* self, guchar* message, int message_length1, int* result_length1, GError** error) {
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	struct gcry_sexp* _tmp1_;
	gint _tmp2_ = 0;
	guchar* _tmp3_ = NULL;
	guchar* _tmp4_;
	gint _tmp4__length1;
	gint __tmp4__size_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = message;
	_tmp0__length1 = message_length1;
	_tmp1_ = self->priv->pkey;
	_tmp3_ = netsukuku_crypto_asym_encrypt (_tmp0_, _tmp0__length1, _tmp1_, &_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	__tmp4__size_ = _tmp4__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_CRYPTO_GCRYPT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}


NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self) {
	NetsukukuPublicKey* result = NULL;
	struct gcry_sexp* _tmp0_;
	gint _tmp1_ = 0;
	guint8* _tmp2_ = NULL;
	guint8* _tmp3_;
	gint _tmp3__length1;
	zcdSerializableBuffer* _tmp4_;
	zcdSerializableBuffer* _tmp5_;
	NetsukukuPublicKey* _tmp6_;
	NetsukukuPublicKey* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pkey;
	_tmp2_ = netsukuku_crypto_serialize_sexp (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp4_ = zcd_serializable_buffer_new (_tmp3_, _tmp1_);
	_tmp5_ = _tmp4_;
	_tmp6_ = netsukuku_public_key_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_tmp3_ = (g_free (_tmp3_), NULL);
	result = _tmp7_;
	return result;
}


gchar* netsukuku_public_key_wrapper_to_string (NetsukukuPublicKeyWrapper* self) {
	gchar* result = NULL;
	NetsukukuPublicKey* _tmp0_ = NULL;
	NetsukukuPublicKey* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_public_key_wrapper_to_pubkey (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = netsukuku_public_key_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("<PublicKeyWrapper pubk='", _tmp3_, "'>", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


static void netsukuku_public_key_wrapper_class_init (NetsukukuPublicKeyWrapperClass * klass) {
	netsukuku_public_key_wrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuPublicKeyWrapperPrivate));
	G_OBJECT_CLASS (klass)->finalize = netsukuku_public_key_wrapper_finalize;
}


static void netsukuku_public_key_wrapper_instance_init (NetsukukuPublicKeyWrapper * self) {
	self->priv = NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_PRIVATE (self);
}


static void netsukuku_public_key_wrapper_finalize (GObject* obj) {
	NetsukukuPublicKeyWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper);
	_gcry_sexp_release0 (self->priv->pkey);
	G_OBJECT_CLASS (netsukuku_public_key_wrapper_parent_class)->finalize (obj);
}


GType netsukuku_public_key_wrapper_get_type (void) {
	static volatile gsize netsukuku_public_key_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_public_key_wrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPublicKeyWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_public_key_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPublicKeyWrapper), 0, (GInstanceInitFunc) netsukuku_public_key_wrapper_instance_init, NULL };
		GType netsukuku_public_key_wrapper_type_id;
		netsukuku_public_key_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuPublicKeyWrapper", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_public_key_wrapper_type_id__volatile, netsukuku_public_key_wrapper_type_id);
	}
	return netsukuku_public_key_wrapper_type_id__volatile;
}



