/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using Tasklets;
using zcd;

namespace Netsukuku
{
#if log_tasklet
    private string tasklet_id()
    {
        return @"[$(Tasklet.self().id)] ";
    }
#else
    private string tasklet_id()
    {
        return "";
    }
#endif
    internal void log_debug(string msg) {Posix.syslog(Posix.LOG_DEBUG, tasklet_id()+msg);}
    internal void log_info(string msg) {Posix.syslog(Posix.LOG_INFO, tasklet_id()+msg);}
    internal void log_notice(string msg) {Posix.syslog(Posix.LOG_NOTICE, tasklet_id()+msg);}
    internal void log_warn(string msg) {Posix.syslog(Posix.LOG_WARNING, tasklet_id()+msg);}
    internal void log_error(string msg) {Posix.syslog(Posix.LOG_ERR, tasklet_id()+msg);}
    internal void log_critical(string msg) {Posix.syslog(Posix.LOG_CRIT, tasklet_id()+msg);}

    namespace Crypto
    {
        public errordomain GCryptError {GENERIC}
        public uint32 fnv_32(uchar[] data) {return 0;}
    }

    public errordomain RPCError {
        FUNCTION_NOT_REMOTABLE,
        MALFORMED_PACKET,
        NETWORK_ERROR,
        NOT_VALID_MAP_YET,
        DROP,
        GENERIC
    }

    public ArrayList<int> valid_ids(int levels, int gsize, int lvl, PartialNIP partial_nip)
    {
        ArrayList<int> ret = new ArrayList<int>();
        for (int i = 0; i < gsize; i++) ret.add(i);
        return ret;
    }

    public class AggregatedNeighbour : Object
    {
        public NIP nip;
        public string to_string() {return "";}
        public fake_AggregatedNeighbour neighbour_client;
    }
    public class fake_AggregatedNeighbour : Object
    {
        public fake_AggregatedNeighbour hook;
        public Gee.List<PairLvlNumberOfFreeNodes> list_non_saturated_levels()
        {return new ArrayList<PairLvlNumberOfFreeNodes>();}
    }

    public class MapRoute : Object
    {
        public int levels;
        public int free_nodes_nb(int lvl) {return 0;}
    }

    public class Coord : Object
    {
        public HookReservation? enter_into(int level_of_gnode, NIP nip, AggregatedNeighbour neighbour_to_contact)
        {return null;}
    }

    public class AddressManager : Object
    {
        public bool is_mature;
    }
}

namespace Ntk.Test
{
    string logger;
    const bool output = false;

    public class HookTester : Object
    {
        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        public void test_hookreservation()
        {
            HookReservation hr0;
            {
                uchar[] orig;
                {
                    HookReservation hr = new HookReservation();
                    hr.gnode = new PartialNIP({-1,-1,2,3});
                    hr.pos = 1;
                    hr.elderliness = 2;
                    hr.gids = new GNodeID[1];
                    hr.gids[0] = new GNodeID(0,0,1234);
                    hr.coordinator_knowledge_set = new CoordinatorKnowledgeSet();
                    orig = hr.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                hr0 = (HookReservation)ISerializable.deserialize(dest);
            }
            assert(hr0.elderliness == 2);
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            GLib.Test.add_func ("/Hook/HookReservation", () => {
                var x = new HookTester();
                x.set_up();
                x.test_hookreservation();
                x.tear_down();
            });
            GLib.Test.run();
            return 0;
        }
    }
}
