/* andna.c generated by valac 0.20.1, the Vala compiler
 * generated from andna.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/*   peerbuilder.in
errors:
 HookingError
  INEXISTENT_GNODE
  GENERIC
 QspnError
  NOT_YOUR_GATEWAY
  ALREADY_UP_TO_DATE
  GENERIC
 PeerRefuseServiceError
  GENERIC
 TunnelError
  GENERIC
 BorderNodesError
  WRONG_GNODE
  NOT_BORDER_NODE
  WILL_NOT_TUNNEL
  TIMEOUT
  GENERIC
 AndnaError
  GENERIC
serializables:
 TimeCapsule
 ParticipantNode
 PackedParticipantNodes
 OptionalServiceParticipants
 SetOptionalServiceParticipants
 PeerToPeerTracerPacketList
 PairNipDistance
 HookReservation
 BookingRecord
 Bookings
 BnodeRecord
 BnodeList
 CoordinatorKnowledge
 CoordinatorKnowledgeSet
 PairLvlNumberOfFreeNodes
 HCoord
 PartialNIP
 NIP
 REM
 NullREM
 DeadREM
 AlmostDeadREM
 RTT
 TracerPacketList
 RouteInSet
 PositionInRoutesSetPerLevel
 RoutesSetPerLevel
 RoutesSet
 ExtendedTracerPacket
 GNodeID
 NetworkID
 InfoNeighbour
 InfoRoute
 InfoNode
 QspnStats
 InfoBorderNode
 InfoCoord
 DHTKey
 DHTRecord
 PublicKey
 AndnaServiceKey
 AndnaServerRecord
 AndnaDomainRecord
 AndnaServer
 AndnaServers
 RegisterHostnameArguments
 CounterNipRecord
 CounterSetDataResponse
 CounterCheckHostnameResponse
 AndnaConfirmPubkResponse
 AndnaRegisterMainResponse
 AndnaRegisterSpreadResponse
 AndnaGetServersResponse
 AndnaGetRegistrarResponse
 AndnaGetCacheRecordsResponse
 BroadcastID
 UnicastID
peers:
 Andna
  methods:
   AndnaRegisterMainResponse register_main_for_pubk
    arguments:
     AndnaDomainRequest request
     SerializableBuffer signature
     bool replicate
    throws:
     PeerRefuseServiceError
   AndnaGetRegistrarResponse? get_registrar
    arguments:
     string hashed_domain
    throws:
     PeerRefuseServiceError
   AndnaDomainRecord? get_domain_record
    arguments:
     string hashed_domain
    throws:
     PeerRefuseServiceError
   AndnaRegisterSpreadResponse register_spread_record
    arguments:
     string hashed_domain
     int spread_number
     bool replicate
    throws:
     PeerRefuseServiceError
   AndnaGetServersResponse get_servers
    arguments:
     string hashed_domain
     AndnaServiceKey srv_key
     int spread_number
     bool chain
    throws:
     PeerRefuseServiceError
   AndnaGetCacheRecordsResponse get_cache_records
    arguments:
    throws:
     PeerRefuseServiceError
*/

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <zcd.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <gee.h>
#include <unistd.h>


#define NETSUKUKU_TYPE_IANDNA_AS_PEER (netsukuku_iandna_as_peer_get_type ())
#define NETSUKUKU_IANDNA_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER, NetsukukuIAndnaAsPeer))
#define NETSUKUKU_IS_IANDNA_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER))
#define NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER, NetsukukuIAndnaAsPeerIface))

typedef struct _NetsukukuIAndnaAsPeer NetsukukuIAndnaAsPeer;
typedef struct _NetsukukuIAndnaAsPeerIface NetsukukuIAndnaAsPeerIface;

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_RMT_ANDNA_PEER (netsukuku_rmt_andna_peer_get_type ())
#define NETSUKUKU_RMT_ANDNA_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeer))
#define NETSUKUKU_RMT_ANDNA_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeerClass))
#define NETSUKUKU_IS_RMT_ANDNA_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER))
#define NETSUKUKU_IS_RMT_ANDNA_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_ANDNA_PEER))
#define NETSUKUKU_RMT_ANDNA_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeerClass))

typedef struct _NetsukukuRmtAndnaPeer NetsukukuRmtAndnaPeer;
typedef struct _NetsukukuRmtAndnaPeerClass NetsukukuRmtAndnaPeerClass;
typedef struct _NetsukukuRmtAndnaPeerPrivate NetsukukuRmtAndnaPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY (netsukuku_andna_service_hashnode_key_get_type ())
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey))
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyClass))
#define NETSUKUKU_IS_ANDNA_SERVICE_HASHNODE_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY))
#define NETSUKUKU_IS_ANDNA_SERVICE_HASHNODE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY))
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyClass))

typedef struct _NetsukukuAndnaServiceHashnodeKey NetsukukuAndnaServiceHashnodeKey;
typedef struct _NetsukukuAndnaServiceHashnodeKeyClass NetsukukuAndnaServiceHashnodeKeyClass;
typedef struct _NetsukukuAndnaServiceHashnodeKeyPrivate NetsukukuAndnaServiceHashnodeKeyPrivate;

#define NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD (netsukuku_arguments_for_duplication_register_spread_get_type ())
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpread))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpreadClass))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpreadClass))

typedef struct _NetsukukuArgumentsForDuplicationRegisterSpread NetsukukuArgumentsForDuplicationRegisterSpread;
typedef struct _NetsukukuArgumentsForDuplicationRegisterSpreadClass NetsukukuArgumentsForDuplicationRegisterSpreadClass;
typedef struct _NetsukukuArgumentsForDuplicationRegisterSpreadPrivate NetsukukuArgumentsForDuplicationRegisterSpreadPrivate;

#define NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN (netsukuku_arguments_for_duplication_register_main_get_type ())
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMain))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMainClass))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMainClass))

typedef struct _NetsukukuArgumentsForDuplicationRegisterMain NetsukukuArgumentsForDuplicationRegisterMain;
typedef struct _NetsukukuArgumentsForDuplicationRegisterMainClass NetsukukuArgumentsForDuplicationRegisterMainClass;
typedef struct _NetsukukuArgumentsForDuplicationRegisterMainPrivate NetsukukuArgumentsForDuplicationRegisterMainPrivate;

#define NETSUKUKU_TYPE_DOMAIN_WANTED (netsukuku_domain_wanted_get_type ())
#define NETSUKUKU_DOMAIN_WANTED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_DOMAIN_WANTED, NetsukukuDomainWanted))
#define NETSUKUKU_DOMAIN_WANTED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_DOMAIN_WANTED, NetsukukuDomainWantedClass))
#define NETSUKUKU_IS_DOMAIN_WANTED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_DOMAIN_WANTED))
#define NETSUKUKU_IS_DOMAIN_WANTED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_DOMAIN_WANTED))
#define NETSUKUKU_DOMAIN_WANTED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_DOMAIN_WANTED, NetsukukuDomainWantedClass))

typedef struct _NetsukukuDomainWanted NetsukukuDomainWanted;
typedef struct _NetsukukuDomainWantedClass NetsukukuDomainWantedClass;
typedef struct _NetsukukuDomainWantedPrivate NetsukukuDomainWantedPrivate;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

#define NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER (netsukuku_optional_peer_to_peer_get_type ())
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))

typedef struct _NetsukukuOptionalPeerToPeer NetsukukuOptionalPeerToPeer;
typedef struct _NetsukukuOptionalPeerToPeerClass NetsukukuOptionalPeerToPeerClass;
typedef struct _NetsukukuOptionalPeerToPeerPrivate NetsukukuOptionalPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_PEER_TO_PEER (netsukuku_map_peer_to_peer_get_type ())
#define NETSUKUKU_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeer))
#define NETSUKUKU_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_MAP_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))

typedef struct _NetsukukuMapPeerToPeer NetsukukuMapPeerToPeer;
typedef struct _NetsukukuMapPeerToPeerClass NetsukukuMapPeerToPeerClass;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;
typedef struct _NetsukukuAndnaPrivate NetsukukuAndnaPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuIAndnaAsPeerIface {
	GTypeInterface parent_iface;
	NetsukukuAndnaRegisterMainResponse* (*register_main_for_pubk) (NetsukukuIAndnaAsPeer* self, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
	NetsukukuAndnaGetRegistrarResponse* (*get_registrar) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
	NetsukukuAndnaDomainRecord* (*get_domain_record) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
	NetsukukuAndnaRegisterSpreadResponse* (*register_spread_record) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
	NetsukukuAndnaGetServersResponse* (*get_servers) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
	NetsukukuAndnaGetCacheRecordsResponse* (*get_cache_records) (NetsukukuIAndnaAsPeer* self, GError** error);
};

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtAndnaPeer {
	NetsukukuRmtPeer parent_instance;
	NetsukukuRmtAndnaPeerPrivate * priv;
};

struct _NetsukukuRmtAndnaPeerClass {
	NetsukukuRmtPeerClass parent_class;
};

struct _NetsukukuAndnaServiceHashnodeKey {
	GObject parent_instance;
	NetsukukuAndnaServiceHashnodeKeyPrivate * priv;
};

struct _NetsukukuAndnaServiceHashnodeKeyClass {
	GObjectClass parent_class;
};

struct _NetsukukuAndnaServiceHashnodeKeyPrivate {
	gchar* _hashed_domain;
	gint _spread_num;
};

struct _NetsukukuArgumentsForDuplicationRegisterSpread {
	GObject parent_instance;
	NetsukukuArgumentsForDuplicationRegisterSpreadPrivate * priv;
	gchar* hashed_domain;
	gint spread_number;
	NetsukukuNIP* hashnode;
};

struct _NetsukukuArgumentsForDuplicationRegisterSpreadClass {
	GObjectClass parent_class;
};

struct _NetsukukuArgumentsForDuplicationRegisterMain {
	GObject parent_instance;
	NetsukukuArgumentsForDuplicationRegisterMainPrivate * priv;
	NetsukukuAndnaDomainRequest* request;
	zcdSerializableBuffer* signature;
	NetsukukuNIP* hashnode;
};

struct _NetsukukuArgumentsForDuplicationRegisterMainClass {
	GObjectClass parent_class;
};

struct _NetsukukuDomainWanted {
	GObject parent_instance;
	NetsukukuDomainWantedPrivate * priv;
	gchar* hostname;
	NetsukukuTimeCapsule* ttl_before_request;
	TaskletsTasklet* tasklet;
	gboolean registered;
};

struct _NetsukukuDomainWantedClass {
	GObjectClass parent_class;
};

struct _NetsukukuPeerToPeer {
	zcdRPCDispatcher parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	gint pid;
	gboolean has_valid_map;
};

struct _NetsukukuPeerToPeerClass {
	zcdRPCDispatcherClass parent_class;
	void (*start_operations) (NetsukukuPeerToPeer* self);
	void (*stop_operations) (NetsukukuPeerToPeer* self);
	gboolean (*is_participant) (NetsukukuPeerToPeer* self, gint lvl, gint pos);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuOptionalPeerToPeer {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuOptionalPeerToPeerPrivate * priv;
	NetsukukuMapPeerToPeer* map_peer_to_peer;
	gboolean will_participate;
};

struct _NetsukukuOptionalPeerToPeerClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuAndna {
	NetsukukuOptionalPeerToPeer parent_instance;
	NetsukukuAndnaPrivate * priv;
};

struct _NetsukukuAndnaClass {
	NetsukukuOptionalPeerToPeerClass parent_class;
};

struct _NetsukukuAndnaPrivate {
	NetsukukuAndnaPrivateConfigurationList* _configuration;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	gboolean hooked_to_service;
	NetsukukuCounter* counter;
	NetsukukuKeyPair* my_keys;
	GeeHashMap* request_queue;
	GeeHashMap* cache;
	GeeArrayList* lst_domains;
	NetsukukuPublicKey* _mypubk;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
struct _Block1Data {
	int _ref_count_;
	NetsukukuAndna * self;
	gchar* response_msg;
	NetsukukuTimeCapsule* response_ttl;
	NetsukukuAndnaDomainRequest* request;
	zcdSerializableBuffer* signature;
};

typedef gboolean (*NetsukukuAcceptRecordCallback) (void* user_data, GError** error);
typedef void (*NetsukukuForwardRecordCallback) (GObject* obj1, GeeList* replica_nodes, void* user_data, GError** error);
typedef void (*NetsukukuRefuseRecordCallback) (void* user_data, GError** error);
struct _Block2Data {
	int _ref_count_;
	NetsukukuAndna * self;
	gboolean response_response;
	gchar* response_msg;
	NetsukukuArgumentsForDuplicationRegisterSpread* rec;
};


static gpointer netsukuku_rmt_andna_peer_parent_class = NULL;
static NetsukukuIAndnaAsPeerIface* netsukuku_rmt_andna_peer_netsukuku_iandna_as_peer_parent_iface = NULL;
static gpointer netsukuku_andna_service_hashnode_key_parent_class = NULL;
static gpointer netsukuku_arguments_for_duplication_register_spread_parent_class = NULL;
static gpointer netsukuku_arguments_for_duplication_register_main_parent_class = NULL;
static gpointer netsukuku_domain_wanted_parent_class = NULL;
static gpointer netsukuku_andna_parent_class = NULL;
static NetsukukuIAndnaAsPeerIface* netsukuku_andna_netsukuku_iandna_as_peer_parent_iface = NULL;
static NetsukukuIAndnaIface* netsukuku_andna_netsukuku_iandna_parent_iface = NULL;

GType netsukuku_iandna_as_peer_get_type (void) G_GNUC_CONST;
NetsukukuAndnaRegisterMainResponse* netsukuku_iandna_as_peer_register_main_for_pubk (NetsukukuIAndnaAsPeer* self, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
NetsukukuAndnaGetRegistrarResponse* netsukuku_iandna_as_peer_get_registrar (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
NetsukukuAndnaDomainRecord* netsukuku_iandna_as_peer_get_domain_record (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
NetsukukuAndnaRegisterSpreadResponse* netsukuku_iandna_as_peer_register_spread_record (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
NetsukukuAndnaGetServersResponse* netsukuku_iandna_as_peer_get_servers (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
NetsukukuAndnaGetCacheRecordsResponse* netsukuku_iandna_as_peer_get_cache_records (NetsukukuIAndnaAsPeer* self, GError** error);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_rmt_andna_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_ANDNA_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtAndnaPeer* netsukuku_rmt_andna_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtAndnaPeer* netsukuku_rmt_andna_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static NetsukukuAndnaRegisterMainResponse* netsukuku_rmt_andna_peer_real_register_main_for_pubk (NetsukukuIAndnaAsPeer* base, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static NetsukukuAndnaGetRegistrarResponse* netsukuku_rmt_andna_peer_real_get_registrar (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error);
static NetsukukuAndnaDomainRecord* netsukuku_rmt_andna_peer_real_get_domain_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error);
static NetsukukuAndnaRegisterSpreadResponse* netsukuku_rmt_andna_peer_real_register_spread_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
static NetsukukuAndnaGetServersResponse* netsukuku_rmt_andna_peer_real_get_servers (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
static NetsukukuAndnaGetCacheRecordsResponse* netsukuku_rmt_andna_peer_real_get_cache_records (NetsukukuIAndnaAsPeer* base, GError** error);
GType netsukuku_andna_service_hashnode_key_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyPrivate))
enum  {
	NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_DUMMY_PROPERTY,
	NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_HASHED_DOMAIN,
	NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_SPREAD_NUM
};
NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_new (const gchar* hashed_domain, gint spread_num);
NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_construct (GType object_type, const gchar* hashed_domain, gint spread_num);
static void netsukuku_andna_service_hashnode_key_set_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self, const gchar* value);
static void netsukuku_andna_service_hashnode_key_set_spread_num (NetsukukuAndnaServiceHashnodeKey* self, gint value);
gboolean netsukuku_andna_service_hashnode_key_equal_func (NetsukukuAndnaServiceHashnodeKey* a, NetsukukuAndnaServiceHashnodeKey* b);
const gchar* netsukuku_andna_service_hashnode_key_get_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self);
gint netsukuku_andna_service_hashnode_key_get_spread_num (NetsukukuAndnaServiceHashnodeKey* self);
static void netsukuku_andna_service_hashnode_key_finalize (GObject* obj);
static void _vala_netsukuku_andna_service_hashnode_key_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_andna_service_hashnode_key_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_arguments_for_duplication_register_spread_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD_DUMMY_PROPERTY
};
NetsukukuArgumentsForDuplicationRegisterSpread* netsukuku_arguments_for_duplication_register_spread_new (void);
NetsukukuArgumentsForDuplicationRegisterSpread* netsukuku_arguments_for_duplication_register_spread_construct (GType object_type);
static void netsukuku_arguments_for_duplication_register_spread_finalize (GObject* obj);
GType netsukuku_arguments_for_duplication_register_main_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN_DUMMY_PROPERTY
};
NetsukukuArgumentsForDuplicationRegisterMain* netsukuku_arguments_for_duplication_register_main_new (void);
NetsukukuArgumentsForDuplicationRegisterMain* netsukuku_arguments_for_duplication_register_main_construct (GType object_type);
static void netsukuku_arguments_for_duplication_register_main_finalize (GObject* obj);
GType netsukuku_domain_wanted_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_DOMAIN_WANTED_DUMMY_PROPERTY
};
gboolean netsukuku_domain_wanted_equal_func (NetsukukuDomainWanted* a, NetsukukuDomainWanted* b);
NetsukukuDomainWanted* netsukuku_domain_wanted_new (void);
NetsukukuDomainWanted* netsukuku_domain_wanted_construct (GType object_type);
static void netsukuku_domain_wanted_finalize (GObject* obj);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_optional_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_map_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_ANDNA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaPrivate))
enum  {
	NETSUKUKU_ANDNA_DUMMY_PROPERTY
};
#define NETSUKUKU_ANDNA_mypid 3
NetsukukuAndna* netsukuku_andna_new (NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuAndna* netsukuku_andna_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GQuark netsukuku_peer_to_peer_error_quark (void);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
void netsukuku_andna_hook_to_service (NetsukukuAndna* self);
static void _netsukuku_andna_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self);
static gboolean _netsukuku_domain_wanted_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuRmtAndnaPeer* netsukuku_andna_peer (NetsukukuAndna* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static zcdISerializable* netsukuku_andna_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error);
void netsukuku_log_debug (const gchar* msg);
gchar* netsukuku_andna_crypto_hash (const gchar* hostname);
gchar* netsukuku_andna_utilities_crypto_hash (const gchar* hostname);
static NetsukukuNIP* netsukuku_andna_nip_for_lvl_pos (NetsukukuAndna* self, gint lvl, gint pos);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
static void netsukuku_andna_impl_hook_to_service (NetsukukuAndna* self, GError** error);
gint netsukuku_map_get_levels (NetsukukuMap* self);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
#define NETSUKUKU_ANDNA_DUPLICATION 10
static gboolean _int_equal (const gint* s1, const gint* s2);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
#define NETSUKUKU_SPREAD_ANDNA 9
void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self);
void netsukuku_log_info (const gchar* msg);
static void __lambda3_ (NetsukukuAndna* self, GError** error);
static void ___lambda3__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static NetsukukuNIP* netsukuku_andna_real_h (NetsukukuPeerToPeer* base, GObject* key);
NetsukukuNIP* netsukuku_andna_utilities_key_to_hashnode_converter (NetsukukuAndnaServiceHashnodeKey* key, gint levels, gint gsize);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
NetsukukuAndnaDomainRequest* netsukuku_andna_make_domain_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfiguration* cfg);
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
NetsukukuAndnaServerRequest* netsukuku_andna_make_server_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfigurationServer* cfg);
static void netsukuku_andna_impl_register_name (NetsukukuAndna* self, const gchar* hostname);
static NetsukukuAndnaRegisterMainResponse* netsukuku_andna_ask_register_main_for_pubk (NetsukukuAndna* self, const gchar* hostname, GError** error);
static void ________lambda12_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error);
static void netsukuku_andna_ask_register_spread_record (NetsukukuAndna* self, const gchar* hostname, gint spread_number, GError** error);
static void _________lambda12__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
#define NETSUKUKU_MAX_WAIT_REFRESH_ANDNA ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
void netsukuku_log_warn (const gchar* msg);
static void netsukuku_andna_register_name (NetsukukuAndna* self, const gchar* hostname);
static void __lambda13_ (NetsukukuAndna* self, GObject* tpar1, GError** error);
static void ___lambda13__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
void netsukuku_andna_register_my_names (NetsukukuAndna* self);
static NetsukukuAndnaPrivateConfigurationList* netsukuku_andna_get_configuration (NetsukukuAndna* self);
void netsukuku_andna_stop_register_my_names (NetsukukuAndna* self);
gboolean netsukuku_andna_register_my_names_ongoing (NetsukukuAndna* self);
static zcdSerializableBuffer* _netsukuku_andna_sign (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, NetsukukuKeyPair* key_pair);
static guchar* netsukuku_andna_prepare_msg (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, int* result_length1);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error);
static gboolean _netsukuku_andna_verify (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pubk (NetsukukuPublicKey* from_pubk, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pubk (GType object_type, NetsukukuPublicKey* from_pubk, GError** error);
gboolean netsukuku_public_key_wrapper_verify (NetsukukuPublicKeyWrapper* self, guchar* msg, int msg_length1, guchar* signature, int signature_length1, GError** error);
NetsukukuAndnaGetRegistrarResponse* netsukuku_andna_ask_registrar (NetsukukuAndna* self, const gchar* hashed_domain);
NetsukukuAndnaGetServersResponse* netsukuku_andna_ask_get_servers (NetsukukuAndna* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gboolean chain);
static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gboolean _netsukuku_andna_service_hashnode_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
NetsukukuPartialNIP* netsukuku_map_route_choose_fast (NetsukukuMapRoute* self, GeeList* choose_from);
static void netsukuku_andna_str_debug_cache (NetsukukuAndna* self);
static NetsukukuAndnaServerRecord* netsukuku_andna_make_server_record (NetsukukuAndna* self, NetsukukuAndnaServerRequest* req);
void netsukuku_andna_check_expirations_cache (NetsukukuAndna* self);
static NetsukukuAndnaRegisterMainResponse* netsukuku_andna_real_register_main_for_pubk (NetsukukuIAndnaAsPeer* base, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error);
static gboolean __lambda6_ (Block1Data* _data1_, GError** error);
NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
#define NETSUKUKU_MAX_TTL_ANDNA ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
static guint _netsukuku_andna_service_key_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _netsukuku_andna_service_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gboolean _netsukuku_andna_server_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gboolean _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
#define NETSUKUKU_MAX_QUEUE_ANDNA 5
static gboolean ___lambda6__netsukuku_accept_record_callback (gpointer self, GError** error);
static void __lambda7_ (NetsukukuAndna* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error);
static void _____lambda8_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error);
static void ______lambda8__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static void ___lambda7__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error);
static NetsukukuAndnaGetRegistrarResponse* netsukuku_andna_real_get_registrar (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
static NetsukukuAndnaDomainRecord* netsukuku_andna_real_get_domain_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error);
static NetsukukuAndnaRegisterSpreadResponse* netsukuku_andna_real_register_spread_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda9_ (Block2Data* _data2_, GError** error);
static gboolean ___lambda9__netsukuku_accept_record_callback (gpointer self, GError** error);
static void __lambda10_ (NetsukukuAndna* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error);
static void _____lambda11_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error);
static void ______lambda11__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static void ___lambda10__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error);
static NetsukukuAndnaGetServersResponse* netsukuku_andna_real_get_servers (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
#define NETSUKUKU_MAX_TTL_OF_NEGATIVE (((gint64) 1000) * ((gint64) 30))
static NetsukukuAndnaGetCacheRecordsResponse* netsukuku_andna_real_get_cache_records (NetsukukuIAndnaAsPeer* base, GError** error);
static NetsukukuAndnaConfirmPubkResponse* netsukuku_andna_real_confirm_pubk (NetsukukuIAndna* base, NetsukukuNIP* yournip, NetsukukuPublicKey* yourpubkey, gint to_be_signed, GError** error);
static NetsukukuPublicKey* netsukuku_andna_get_mypubk (NetsukukuAndna* self);
static GeeList* netsukuku_andna_real_get_your_hostnames (NetsukukuIAndna* base, NetsukukuNIP* yournip, GError** error);
static NetsukukuInfoAndna* netsukuku_andna_real_report_status (NetsukukuIAndna* base, GError** error);
gboolean netsukuku_optional_peer_to_peer_get_participant (NetsukukuOptionalPeerToPeer* self);
static NetsukukuAndnaPrivateConfigurationList* netsukuku_andna_real_get_mynames (NetsukukuIAndna* base, GError** error);
static void netsukuku_andna_real_set_mynames (NetsukukuIAndna* base, NetsukukuAndnaPrivateConfigurationList* mynames, GError** error);
static NetsukukuPublicKey* netsukuku_andna_real_retrieve_registrar_pubk (NetsukukuIAndna* base, const gchar* hashed_domain, GError** error);
static void netsukuku_andna_finalize (GObject* obj);
static void _vala_netsukuku_andna_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


NetsukukuAndnaRegisterMainResponse* netsukuku_iandna_as_peer_register_main_for_pubk (NetsukukuIAndnaAsPeer* self, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->register_main_for_pubk (self, request, signature, replicate, error);
}


NetsukukuAndnaGetRegistrarResponse* netsukuku_iandna_as_peer_get_registrar (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->get_registrar (self, hashed_domain, error);
}


NetsukukuAndnaDomainRecord* netsukuku_iandna_as_peer_get_domain_record (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->get_domain_record (self, hashed_domain, error);
}


NetsukukuAndnaRegisterSpreadResponse* netsukuku_iandna_as_peer_register_spread_record (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->register_spread_record (self, hashed_domain, spread_number, replicate, error);
}


NetsukukuAndnaGetServersResponse* netsukuku_iandna_as_peer_get_servers (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->get_servers (self, hashed_domain, srv_key, spread_number, chain, error);
}


NetsukukuAndnaGetCacheRecordsResponse* netsukuku_iandna_as_peer_get_cache_records (NetsukukuIAndnaAsPeer* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->get_cache_records (self, error);
}


static void netsukuku_iandna_as_peer_base_init (NetsukukuIAndnaAsPeerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType netsukuku_iandna_as_peer_get_type (void) {
	static volatile gsize netsukuku_iandna_as_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_iandna_as_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuIAndnaAsPeerIface), (GBaseInitFunc) netsukuku_iandna_as_peer_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType netsukuku_iandna_as_peer_type_id;
		netsukuku_iandna_as_peer_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetsukukuIAndnaAsPeer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (netsukuku_iandna_as_peer_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&netsukuku_iandna_as_peer_type_id__volatile, netsukuku_iandna_as_peer_type_id);
	}
	return netsukuku_iandna_as_peer_type_id__volatile;
}


NetsukukuRmtAndnaPeer* netsukuku_rmt_andna_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtAndnaPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	GObject* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuAggregatedNeighbour* _tmp3_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = key;
	_tmp2_ = hIP;
	_tmp3_ = aggregated_neighbour;
	self = (NetsukukuRmtAndnaPeer*) netsukuku_rmt_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NetsukukuRmtAndnaPeer* netsukuku_rmt_andna_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_andna_peer_construct (NETSUKUKU_TYPE_RMT_ANDNA_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static NetsukukuAndnaRegisterMainResponse* netsukuku_rmt_andna_peer_real_register_main_for_pubk (NetsukukuIAndnaAsPeer* base, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaRegisterMainResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuAndnaDomainRequest* _tmp4_;
	zcdRemoteCall* _tmp5_;
	zcdSerializableBuffer* _tmp6_;
	zcdRemoteCall* _tmp7_;
	gboolean _tmp8_;
	zcdSerializableBool* _tmp9_;
	zcdSerializableBool* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("register_main_for_pubk");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = request;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = rc;
	_tmp6_ = signature;
	zcd_remote_call_add_parameter (_tmp5_, (zcdISerializable*) _tmp6_);
	_tmp7_ = rc;
	_tmp8_ = replicate;
	_tmp9_ = zcd_serializable_bool_new (_tmp8_);
	_tmp10_ = _tmp9_;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	{
		zcdRemoteCall* _tmp11_;
		zcdISerializable* _tmp12_ = NULL;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* _tmp17_;
		zcdISerializable* _tmp18_;
		zcdISerializable* _tmp19_ = NULL;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_;
		_tmp11_ = rc;
		_tmp12_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch8_zcd_rpc_error;
			}
			goto __catch8_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch8_zcd_rpc_error;
			}
			goto __catch8_g_error;
		}
		_tmp18_ = _tmp17_;
		_tmp19_ = zcd_filter_exception (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch8_zcd_rpc_error;
			}
			goto __catch8_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, NETSUKUKU_TYPE_ANDNA_REGISTER_MAIN_RESPONSE, NetsukukuAndnaRegisterMainResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally8;
	__catch8_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally8;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally8;
	}
	__finally8:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuAndnaGetRegistrarResponse* netsukuku_rmt_andna_peer_real_get_registrar (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaGetRegistrarResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	const gchar* _tmp4_;
	zcdSerializableString* _tmp5_;
	zcdSerializableString* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_registrar");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = hashed_domain;
	_tmp5_ = zcd_serializable_string_new (_tmp4_);
	_tmp6_ = _tmp5_;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	{
		zcdRemoteCall* _tmp7_;
		zcdISerializable* _tmp8_ = NULL;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* ret;
		zcdISerializable* _tmp17_;
		GType _tmp18_ = 0UL;
		gboolean _tmp19_ = FALSE;
		_tmp7_ = rc;
		_tmp8_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch9_zcd_rpc_error;
			}
			goto __catch9_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch9_zcd_rpc_error;
			}
			goto __catch9_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = zcd_filter_exception (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		ret = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch9_zcd_rpc_error;
			}
			goto __catch9_g_error;
		}
		_tmp17_ = ret;
		_tmp18_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp17_);
		_tmp19_ = g_type_is_a (_tmp18_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp19_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp20_;
			NetsukukuAndnaGetRegistrarResponse* _tmp21_;
			_tmp20_ = ret;
			_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, NETSUKUKU_TYPE_ANDNA_GET_REGISTRAR_RESPONSE, NetsukukuAndnaGetRegistrarResponse));
			result = _tmp21_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally9;
	__catch9_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally9;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally9;
	}
	__finally9:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuAndnaDomainRecord* netsukuku_rmt_andna_peer_real_get_domain_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaDomainRecord* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	const gchar* _tmp4_;
	zcdSerializableString* _tmp5_;
	zcdSerializableString* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_domain_record");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = hashed_domain;
	_tmp5_ = zcd_serializable_string_new (_tmp4_);
	_tmp6_ = _tmp5_;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	{
		zcdRemoteCall* _tmp7_;
		zcdISerializable* _tmp8_ = NULL;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* ret;
		zcdISerializable* _tmp17_;
		GType _tmp18_ = 0UL;
		gboolean _tmp19_ = FALSE;
		_tmp7_ = rc;
		_tmp8_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch10_zcd_rpc_error;
			}
			goto __catch10_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch10_zcd_rpc_error;
			}
			goto __catch10_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = zcd_filter_exception (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		ret = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch10_zcd_rpc_error;
			}
			goto __catch10_g_error;
		}
		_tmp17_ = ret;
		_tmp18_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp17_);
		_tmp19_ = g_type_is_a (_tmp18_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp19_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp20_;
			NetsukukuAndnaDomainRecord* _tmp21_;
			_tmp20_ = ret;
			_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, NETSUKUKU_TYPE_ANDNA_DOMAIN_RECORD, NetsukukuAndnaDomainRecord));
			result = _tmp21_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally10;
	__catch10_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally10;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally10;
	}
	__finally10:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuAndnaRegisterSpreadResponse* netsukuku_rmt_andna_peer_real_register_spread_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaRegisterSpreadResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	const gchar* _tmp4_;
	zcdSerializableString* _tmp5_;
	zcdSerializableString* _tmp6_;
	zcdRemoteCall* _tmp7_;
	gint _tmp8_;
	zcdSerializableInt* _tmp9_;
	zcdSerializableInt* _tmp10_;
	zcdRemoteCall* _tmp11_;
	gboolean _tmp12_;
	zcdSerializableBool* _tmp13_;
	zcdSerializableBool* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("register_spread_record");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = hashed_domain;
	_tmp5_ = zcd_serializable_string_new (_tmp4_);
	_tmp6_ = _tmp5_;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = rc;
	_tmp8_ = spread_number;
	_tmp9_ = zcd_serializable_int_new (_tmp8_);
	_tmp10_ = _tmp9_;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = rc;
	_tmp12_ = replicate;
	_tmp13_ = zcd_serializable_bool_new (_tmp12_);
	_tmp14_ = _tmp13_;
	zcd_remote_call_add_parameter (_tmp11_, (zcdISerializable*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	{
		zcdRemoteCall* _tmp15_;
		zcdISerializable* _tmp16_ = NULL;
		zcdISerializable* _tmp17_;
		zcdISerializable* _tmp18_;
		zcdISerializable* _tmp19_ = NULL;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_;
		zcdISerializable* _tmp22_;
		zcdISerializable* _tmp23_ = NULL;
		zcdISerializable* _tmp24_;
		zcdISerializable* _tmp25_;
		_tmp15_ = rc;
		_tmp16_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp15_, &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch11_zcd_rpc_error;
			}
			goto __catch11_g_error;
		}
		_tmp18_ = _tmp17_;
		_tmp19_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch11_zcd_rpc_error;
			}
			goto __catch11_g_error;
		}
		_tmp22_ = _tmp21_;
		_tmp23_ = zcd_filter_exception (_tmp22_, &_inner_error_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_tmp25_ = _tmp24_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch11_zcd_rpc_error;
			}
			goto __catch11_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, NETSUKUKU_TYPE_ANDNA_REGISTER_SPREAD_RESPONSE, NetsukukuAndnaRegisterSpreadResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally11;
	__catch11_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		GError* _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _g_error_copy0 (_tmp26_);
		_inner_error_ = _tmp27_;
		_g_error_free0 (e);
		goto __finally11;
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		GQuark _tmp29_;
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_;
		gint _tmp32_;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		GError* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		GError* _tmp40_;
		GError* _tmp41_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->domain;
		_tmp30_ = g_quark_to_string (_tmp29_);
		_tmp31_ = e;
		_tmp32_ = _tmp31_->code;
		_tmp33_ = g_strdup_printf ("%i", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		_tmp37_ = string_to_string (_tmp36_);
		_tmp38_ = g_strconcat ("Unexpected error ", _tmp30_, ".", _tmp34_, " '", _tmp37_, "'", NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp39_);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp39_);
		_g_free0 (_tmp34_);
		_inner_error_ = _tmp41_;
		_g_error_free0 (e);
		goto __finally11;
	}
	__finally11:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuAndnaGetServersResponse* netsukuku_rmt_andna_peer_real_get_servers (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaGetServersResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	const gchar* _tmp4_;
	zcdSerializableString* _tmp5_;
	zcdSerializableString* _tmp6_;
	zcdRemoteCall* _tmp7_;
	NetsukukuAndnaServiceKey* _tmp8_;
	zcdRemoteCall* _tmp9_;
	gint _tmp10_;
	zcdSerializableInt* _tmp11_;
	zcdSerializableInt* _tmp12_;
	zcdRemoteCall* _tmp13_;
	gboolean _tmp14_;
	zcdSerializableBool* _tmp15_;
	zcdSerializableBool* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (srv_key != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_servers");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = hashed_domain;
	_tmp5_ = zcd_serializable_string_new (_tmp4_);
	_tmp6_ = _tmp5_;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = rc;
	_tmp8_ = srv_key;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp8_);
	_tmp9_ = rc;
	_tmp10_ = spread_number;
	_tmp11_ = zcd_serializable_int_new (_tmp10_);
	_tmp12_ = _tmp11_;
	zcd_remote_call_add_parameter (_tmp9_, (zcdISerializable*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = rc;
	_tmp14_ = chain;
	_tmp15_ = zcd_serializable_bool_new (_tmp14_);
	_tmp16_ = _tmp15_;
	zcd_remote_call_add_parameter (_tmp13_, (zcdISerializable*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	{
		zcdRemoteCall* _tmp17_;
		zcdISerializable* _tmp18_ = NULL;
		zcdISerializable* _tmp19_;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_ = NULL;
		zcdISerializable* _tmp22_;
		zcdISerializable* _tmp23_;
		zcdISerializable* _tmp24_;
		zcdISerializable* _tmp25_ = NULL;
		zcdISerializable* _tmp26_;
		zcdISerializable* _tmp27_;
		_tmp17_ = rc;
		_tmp18_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch12_zcd_rpc_error;
			}
			goto __catch12_g_error;
		}
		_tmp20_ = _tmp19_;
		_tmp21_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_tmp23_ = _tmp22_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch12_zcd_rpc_error;
			}
			goto __catch12_g_error;
		}
		_tmp24_ = _tmp23_;
		_tmp25_ = zcd_filter_exception (_tmp24_, &_inner_error_);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (_tmp24_);
		_tmp27_ = _tmp26_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch12_zcd_rpc_error;
			}
			goto __catch12_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, NETSUKUKU_TYPE_ANDNA_GET_SERVERS_RESPONSE, NetsukukuAndnaGetServersResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally12;
	__catch12_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _g_error_copy0 (_tmp28_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally12;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		GQuark _tmp31_;
		const gchar* _tmp32_ = NULL;
		GError* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GError* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->domain;
		_tmp32_ = g_quark_to_string (_tmp31_);
		_tmp33_ = e;
		_tmp34_ = _tmp33_->code;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat ("Unexpected error ", _tmp32_, ".", _tmp36_, " '", _tmp39_, "'", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		_g_free0 (_tmp36_);
		_inner_error_ = _tmp43_;
		_g_error_free0 (e);
		goto __finally12;
	}
	__finally12:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuAndnaGetCacheRecordsResponse* netsukuku_rmt_andna_peer_real_get_cache_records (NetsukukuIAndnaAsPeer* base, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaGetCacheRecordsResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_cache_records");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	{
		zcdRemoteCall* _tmp3_;
		zcdISerializable* _tmp4_ = NULL;
		zcdISerializable* _tmp5_;
		zcdISerializable* _tmp6_;
		zcdISerializable* _tmp7_ = NULL;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		_tmp3_ = rc;
		_tmp4_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch13_zcd_rpc_error;
			}
			goto __catch13_g_error;
		}
		_tmp6_ = _tmp5_;
		_tmp7_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch13_zcd_rpc_error;
			}
			goto __catch13_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = zcd_filter_exception (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch13_zcd_rpc_error;
			}
			goto __catch13_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, NETSUKUKU_TYPE_ANDNA_GET_CACHE_RECORDS_RESPONSE, NetsukukuAndnaGetCacheRecordsResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally13;
	__catch13_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally13;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->code;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Unexpected error ", _tmp18_, ".", _tmp22_, " '", _tmp25_, "'", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally13;
	}
	__finally13:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_andna_peer_class_init (NetsukukuRmtAndnaPeerClass * klass) {
	netsukuku_rmt_andna_peer_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_rmt_andna_peer_netsukuku_iandna_as_peer_interface_init (NetsukukuIAndnaAsPeerIface * iface) {
	netsukuku_rmt_andna_peer_netsukuku_iandna_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->register_main_for_pubk = (NetsukukuAndnaRegisterMainResponse* (*)(NetsukukuIAndnaAsPeer*, NetsukukuAndnaDomainRequest*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_rmt_andna_peer_real_register_main_for_pubk;
	iface->get_registrar = (NetsukukuAndnaGetRegistrarResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, GError**)) netsukuku_rmt_andna_peer_real_get_registrar;
	iface->get_domain_record = (NetsukukuAndnaDomainRecord* (*)(NetsukukuIAndnaAsPeer*, const gchar*, GError**)) netsukuku_rmt_andna_peer_real_get_domain_record;
	iface->register_spread_record = (NetsukukuAndnaRegisterSpreadResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, gint, gboolean, GError**)) netsukuku_rmt_andna_peer_real_register_spread_record;
	iface->get_servers = (NetsukukuAndnaGetServersResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, NetsukukuAndnaServiceKey*, gint, gboolean, GError**)) netsukuku_rmt_andna_peer_real_get_servers;
	iface->get_cache_records = (NetsukukuAndnaGetCacheRecordsResponse* (*)(NetsukukuIAndnaAsPeer*, GError**)) netsukuku_rmt_andna_peer_real_get_cache_records;
}


static void netsukuku_rmt_andna_peer_instance_init (NetsukukuRmtAndnaPeer * self) {
}


GType netsukuku_rmt_andna_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_andna_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_andna_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtAndnaPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_andna_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtAndnaPeer), 0, (GInstanceInitFunc) netsukuku_rmt_andna_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_iandna_as_peer_info = { (GInterfaceInitFunc) netsukuku_rmt_andna_peer_netsukuku_iandna_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_rmt_andna_peer_type_id;
		netsukuku_rmt_andna_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_RMT_PEER, "NetsukukuRmtAndnaPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_rmt_andna_peer_type_id, NETSUKUKU_TYPE_IANDNA_AS_PEER, &netsukuku_iandna_as_peer_info);
		g_once_init_leave (&netsukuku_rmt_andna_peer_type_id__volatile, netsukuku_rmt_andna_peer_type_id);
	}
	return netsukuku_rmt_andna_peer_type_id__volatile;
}


NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_construct (GType object_type, const gchar* hashed_domain, gint spread_num) {
	NetsukukuAndnaServiceHashnodeKey * self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	self = (NetsukukuAndnaServiceHashnodeKey*) g_object_new (object_type, NULL);
	_tmp0_ = hashed_domain;
	netsukuku_andna_service_hashnode_key_set_hashed_domain (self, _tmp0_);
	_tmp1_ = spread_num;
	netsukuku_andna_service_hashnode_key_set_spread_num (self, _tmp1_);
	return self;
}


NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_new (const gchar* hashed_domain, gint spread_num) {
	return netsukuku_andna_service_hashnode_key_construct (NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, hashed_domain, spread_num);
}


gboolean netsukuku_andna_service_hashnode_key_equal_func (NetsukukuAndnaServiceHashnodeKey* a, NetsukukuAndnaServiceHashnodeKey* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	NetsukukuAndnaServiceHashnodeKey* _tmp1_;
	const gchar* _tmp2_;
	NetsukukuAndnaServiceHashnodeKey* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp9_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = a;
	_tmp2_ = _tmp1_->priv->_hashed_domain;
	_tmp3_ = b;
	_tmp4_ = _tmp3_->priv->_hashed_domain;
	if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
		NetsukukuAndnaServiceHashnodeKey* _tmp5_;
		gint _tmp6_;
		NetsukukuAndnaServiceHashnodeKey* _tmp7_;
		gint _tmp8_;
		_tmp5_ = a;
		_tmp6_ = _tmp5_->priv->_spread_num;
		_tmp7_ = b;
		_tmp8_ = _tmp7_->priv->_spread_num;
		_tmp0_ = _tmp6_ == _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	result = _tmp9_;
	return result;
}


const gchar* netsukuku_andna_service_hashnode_key_get_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hashed_domain;
	result = _tmp0_;
	return result;
}


static void netsukuku_andna_service_hashnode_key_set_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_hashed_domain);
	self->priv->_hashed_domain = _tmp1_;
	g_object_notify ((GObject *) self, "hashed-domain");
}


gint netsukuku_andna_service_hashnode_key_get_spread_num (NetsukukuAndnaServiceHashnodeKey* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_spread_num;
	result = _tmp0_;
	return result;
}


static void netsukuku_andna_service_hashnode_key_set_spread_num (NetsukukuAndnaServiceHashnodeKey* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_spread_num = _tmp0_;
	g_object_notify ((GObject *) self, "spread-num");
}


static void netsukuku_andna_service_hashnode_key_class_init (NetsukukuAndnaServiceHashnodeKeyClass * klass) {
	netsukuku_andna_service_hashnode_key_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuAndnaServiceHashnodeKeyPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_andna_service_hashnode_key_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_andna_service_hashnode_key_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_andna_service_hashnode_key_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_HASHED_DOMAIN, g_param_spec_string ("hashed-domain", "hashed-domain", "hashed-domain", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_SPREAD_NUM, g_param_spec_int ("spread-num", "spread-num", "spread-num", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_andna_service_hashnode_key_instance_init (NetsukukuAndnaServiceHashnodeKey * self) {
	self->priv = NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_GET_PRIVATE (self);
}


static void netsukuku_andna_service_hashnode_key_finalize (GObject* obj) {
	NetsukukuAndnaServiceHashnodeKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey);
	_g_free0 (self->priv->_hashed_domain);
	G_OBJECT_CLASS (netsukuku_andna_service_hashnode_key_parent_class)->finalize (obj);
}


GType netsukuku_andna_service_hashnode_key_get_type (void) {
	static volatile gsize netsukuku_andna_service_hashnode_key_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_andna_service_hashnode_key_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAndnaServiceHashnodeKeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_andna_service_hashnode_key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAndnaServiceHashnodeKey), 0, (GInstanceInitFunc) netsukuku_andna_service_hashnode_key_instance_init, NULL };
		GType netsukuku_andna_service_hashnode_key_type_id;
		netsukuku_andna_service_hashnode_key_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAndnaServiceHashnodeKey", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_andna_service_hashnode_key_type_id__volatile, netsukuku_andna_service_hashnode_key_type_id);
	}
	return netsukuku_andna_service_hashnode_key_type_id__volatile;
}


static void _vala_netsukuku_andna_service_hashnode_key_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuAndnaServiceHashnodeKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey);
	switch (property_id) {
		case NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_HASHED_DOMAIN:
		g_value_set_string (value, netsukuku_andna_service_hashnode_key_get_hashed_domain (self));
		break;
		case NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_SPREAD_NUM:
		g_value_set_int (value, netsukuku_andna_service_hashnode_key_get_spread_num (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_andna_service_hashnode_key_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuAndnaServiceHashnodeKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey);
	switch (property_id) {
		case NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_HASHED_DOMAIN:
		netsukuku_andna_service_hashnode_key_set_hashed_domain (self, g_value_get_string (value));
		break;
		case NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_SPREAD_NUM:
		netsukuku_andna_service_hashnode_key_set_spread_num (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


NetsukukuArgumentsForDuplicationRegisterSpread* netsukuku_arguments_for_duplication_register_spread_construct (GType object_type) {
	NetsukukuArgumentsForDuplicationRegisterSpread * self = NULL;
	self = (NetsukukuArgumentsForDuplicationRegisterSpread*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuArgumentsForDuplicationRegisterSpread* netsukuku_arguments_for_duplication_register_spread_new (void) {
	return netsukuku_arguments_for_duplication_register_spread_construct (NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD);
}


static void netsukuku_arguments_for_duplication_register_spread_class_init (NetsukukuArgumentsForDuplicationRegisterSpreadClass * klass) {
	netsukuku_arguments_for_duplication_register_spread_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_arguments_for_duplication_register_spread_finalize;
}


static void netsukuku_arguments_for_duplication_register_spread_instance_init (NetsukukuArgumentsForDuplicationRegisterSpread * self) {
}


static void netsukuku_arguments_for_duplication_register_spread_finalize (GObject* obj) {
	NetsukukuArgumentsForDuplicationRegisterSpread * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpread);
	_g_free0 (self->hashed_domain);
	_g_object_unref0 (self->hashnode);
	G_OBJECT_CLASS (netsukuku_arguments_for_duplication_register_spread_parent_class)->finalize (obj);
}


GType netsukuku_arguments_for_duplication_register_spread_get_type (void) {
	static volatile gsize netsukuku_arguments_for_duplication_register_spread_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_arguments_for_duplication_register_spread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuArgumentsForDuplicationRegisterSpreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_arguments_for_duplication_register_spread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuArgumentsForDuplicationRegisterSpread), 0, (GInstanceInitFunc) netsukuku_arguments_for_duplication_register_spread_instance_init, NULL };
		GType netsukuku_arguments_for_duplication_register_spread_type_id;
		netsukuku_arguments_for_duplication_register_spread_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuArgumentsForDuplicationRegisterSpread", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_arguments_for_duplication_register_spread_type_id__volatile, netsukuku_arguments_for_duplication_register_spread_type_id);
	}
	return netsukuku_arguments_for_duplication_register_spread_type_id__volatile;
}


NetsukukuArgumentsForDuplicationRegisterMain* netsukuku_arguments_for_duplication_register_main_construct (GType object_type) {
	NetsukukuArgumentsForDuplicationRegisterMain * self = NULL;
	self = (NetsukukuArgumentsForDuplicationRegisterMain*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuArgumentsForDuplicationRegisterMain* netsukuku_arguments_for_duplication_register_main_new (void) {
	return netsukuku_arguments_for_duplication_register_main_construct (NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN);
}


static void netsukuku_arguments_for_duplication_register_main_class_init (NetsukukuArgumentsForDuplicationRegisterMainClass * klass) {
	netsukuku_arguments_for_duplication_register_main_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_arguments_for_duplication_register_main_finalize;
}


static void netsukuku_arguments_for_duplication_register_main_instance_init (NetsukukuArgumentsForDuplicationRegisterMain * self) {
}


static void netsukuku_arguments_for_duplication_register_main_finalize (GObject* obj) {
	NetsukukuArgumentsForDuplicationRegisterMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMain);
	_g_object_unref0 (self->request);
	_g_object_unref0 (self->signature);
	_g_object_unref0 (self->hashnode);
	G_OBJECT_CLASS (netsukuku_arguments_for_duplication_register_main_parent_class)->finalize (obj);
}


GType netsukuku_arguments_for_duplication_register_main_get_type (void) {
	static volatile gsize netsukuku_arguments_for_duplication_register_main_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_arguments_for_duplication_register_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuArgumentsForDuplicationRegisterMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_arguments_for_duplication_register_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuArgumentsForDuplicationRegisterMain), 0, (GInstanceInitFunc) netsukuku_arguments_for_duplication_register_main_instance_init, NULL };
		GType netsukuku_arguments_for_duplication_register_main_type_id;
		netsukuku_arguments_for_duplication_register_main_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuArgumentsForDuplicationRegisterMain", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_arguments_for_duplication_register_main_type_id__volatile, netsukuku_arguments_for_duplication_register_main_type_id);
	}
	return netsukuku_arguments_for_duplication_register_main_type_id__volatile;
}


gboolean netsukuku_domain_wanted_equal_func (NetsukukuDomainWanted* a, NetsukukuDomainWanted* b) {
	gboolean result = FALSE;
	NetsukukuDomainWanted* _tmp0_;
	const gchar* _tmp1_;
	NetsukukuDomainWanted* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->hostname;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->hostname;
	result = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	return result;
}


NetsukukuDomainWanted* netsukuku_domain_wanted_construct (GType object_type) {
	NetsukukuDomainWanted * self = NULL;
	self = (NetsukukuDomainWanted*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuDomainWanted* netsukuku_domain_wanted_new (void) {
	return netsukuku_domain_wanted_construct (NETSUKUKU_TYPE_DOMAIN_WANTED);
}


static void netsukuku_domain_wanted_class_init (NetsukukuDomainWantedClass * klass) {
	netsukuku_domain_wanted_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_domain_wanted_finalize;
}


static void netsukuku_domain_wanted_instance_init (NetsukukuDomainWanted * self) {
}


static void netsukuku_domain_wanted_finalize (GObject* obj) {
	NetsukukuDomainWanted * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_DOMAIN_WANTED, NetsukukuDomainWanted);
	_g_free0 (self->hostname);
	_g_object_unref0 (self->ttl_before_request);
	_g_object_unref0 (self->tasklet);
	G_OBJECT_CLASS (netsukuku_domain_wanted_parent_class)->finalize (obj);
}


GType netsukuku_domain_wanted_get_type (void) {
	static volatile gsize netsukuku_domain_wanted_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_domain_wanted_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuDomainWantedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_domain_wanted_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuDomainWanted), 0, (GInstanceInitFunc) netsukuku_domain_wanted_instance_init, NULL };
		GType netsukuku_domain_wanted_type_id;
		netsukuku_domain_wanted_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuDomainWanted", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_domain_wanted_type_id__volatile, netsukuku_domain_wanted_type_id);
	}
	return netsukuku_domain_wanted_type_id__volatile;
}


static void _netsukuku_andna_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self) {
	netsukuku_andna_hook_to_service (self);
}


static gboolean _netsukuku_domain_wanted_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_domain_wanted_equal_func (a, b);
	return result;
}


NetsukukuAndna* netsukuku_andna_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	NetsukukuAndna * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuPeerToPeerAll* _tmp2_;
	NetsukukuPeerToPeerAll* _tmp3_;
	NetsukukuPeerToPeerAll* _tmp4_;
	GeeArrayList* _tmp5_;
	NetsukukuCounter* _tmp6_;
	NetsukukuCounter* _tmp7_;
	NetsukukuKeyPair* _tmp8_;
	NetsukukuKeyPair* _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (keypair != NULL, NULL);
	g_return_val_if_fail (counter != NULL, NULL);
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	self = (NetsukukuAndna*) netsukuku_optional_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, NETSUKUKU_ANDNA_mypid);
	_tmp2_ = peer_to_peer_all;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	self->priv->peer_to_peer_all = _tmp3_;
	((NetsukukuOptionalPeerToPeer*) self)->will_participate = TRUE;
	_tmp4_ = self->priv->peer_to_peer_all;
	netsukuku_peer_to_peer_all_peer_to_peer_register (_tmp4_, (NetsukukuPeerToPeer*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->hooked_to_service = FALSE;
	g_signal_connect_object ((NetsukukuPeerToPeer*) self, "map-peer-to-peer-validated", (GCallback) _netsukuku_andna_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated, self, 0);
	_tmp5_ = gee_array_list_new (NETSUKUKU_TYPE_DOMAIN_WANTED, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_domain_wanted_equal_func_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->lst_domains);
	self->priv->lst_domains = _tmp5_;
	_tmp6_ = counter;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->counter);
	self->priv->counter = _tmp7_;
	_tmp8_ = keypair;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->my_keys);
	self->priv->my_keys = _tmp9_;
	_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->request_queue);
	self->priv->request_queue = _tmp10_;
	_tmp11_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NETSUKUKU_TYPE_ANDNA_DOMAIN_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp11_;
	return self;
}


NetsukukuAndna* netsukuku_andna_new (NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	return netsukuku_andna_construct (NETSUKUKU_TYPE_ANDNA, keypair, counter, aggregated_neighbour_manager, maproute, peer_to_peer_all);
}


NetsukukuRmtAndnaPeer* netsukuku_andna_peer (NetsukukuAndna* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtAndnaPeer* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuNIP* _tmp1_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuRmtAndnaPeer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = hIP;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = _tmp2_ != NULL;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "hIP != null || key != null");
	_tmp4_ = key;
	_tmp5_ = hIP;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = netsukuku_rmt_andna_peer_new ((NetsukukuPeerToPeer*) self, _tmp4_, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


/** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
static zcdISerializable* netsukuku_andna_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error) {
	NetsukukuAndna * self;
	zcdISerializable* result = NULL;
	GType _tmp0_ = 0UL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	zcdRemoteCall* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	zcdRemoteCall* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** pieces;
	gint pieces_length1;
	gint _pieces_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	const gchar* _tmp59_;
	gchar** _tmp84_;
	gint _tmp84__length1;
	const gchar* _tmp85_;
	gchar** _tmp110_;
	gint _tmp110__length1;
	const gchar* _tmp111_;
	gchar** _tmp159_;
	gint _tmp159__length1;
	const gchar* _tmp160_;
	gchar** _tmp219_;
	gint _tmp219__length1;
	const gchar* _tmp220_;
	GObject* _tmp231_;
	zcdRemoteCall* _tmp232_;
	zcdISerializable* _tmp233_ = NULL;
	zcdISerializable* _tmp234_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp1_ = g_type_name (_tmp0_);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = data;
	_tmp4_ = zcd_remote_call_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, ": dispatching ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	netsukuku_log_debug (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = data;
	_tmp9_ = _tmp8_->method_name;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ".", 0);
	pieces = _tmp11_;
	pieces_length1 = _vala_array_length (_tmp10_);
	_pieces_size_ = pieces_length1;
	_tmp12_ = pieces;
	_tmp12__length1 = pieces_length1;
	_tmp13_ = _tmp12_[0];
	if (g_strcmp0 (_tmp13_, "register_main_for_pubk") == 0) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		zcdRemoteCall* _tmp16_;
		GeeList* _tmp17_;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		zcdRemoteCall* _tmp22_;
		GeeList* _tmp23_;
		GeeList* _tmp24_;
		gpointer _tmp25_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp26_;
		GType _tmp27_ = 0UL;
		gboolean _tmp28_ = FALSE;
		zcdISerializable* _tmp30_;
		NetsukukuAndnaDomainRequest* _tmp31_;
		NetsukukuAndnaDomainRequest* request;
		zcdRemoteCall* _tmp32_;
		GeeList* _tmp33_;
		GeeList* _tmp34_;
		gpointer _tmp35_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp36_;
		GType _tmp37_ = 0UL;
		gboolean _tmp38_ = FALSE;
		zcdISerializable* _tmp40_;
		zcdSerializableBuffer* _tmp41_;
		zcdSerializableBuffer* signature;
		zcdRemoteCall* _tmp42_;
		GeeList* _tmp43_;
		GeeList* _tmp44_;
		gpointer _tmp45_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp46_;
		GType _tmp47_ = 0UL;
		gboolean _tmp48_ = FALSE;
		zcdISerializable* _tmp50_;
		gboolean _tmp51_;
		gboolean _tmp52_;
		gboolean replicate;
		NetsukukuAndnaDomainRequest* _tmp53_;
		zcdSerializableBuffer* _tmp54_;
		gboolean _tmp55_;
		NetsukukuAndnaRegisterMainResponse* _tmp56_ = NULL;
		NetsukukuAndnaRegisterMainResponse* _tmp57_;
		_tmp14_ = pieces;
		_tmp14__length1 = pieces_length1;
		if (_tmp14__length1 != 1) {
			GError* _tmp15_;
			_tmp15_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk is a function.");
			_inner_error_ = _tmp15_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp16_ = data;
		_tmp17_ = zcd_remote_call_get_parameters (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ != 3) {
			GError* _tmp21_;
			_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk wants 3 parameters.");
			_inner_error_ = _tmp21_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp22_ = data;
		_tmp23_ = zcd_remote_call_get_parameters (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_list_get (_tmp24_, 0);
		iser0 = (zcdISerializable*) _tmp25_;
		_tmp26_ = iser0;
		_tmp27_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp26_);
		_tmp28_ = g_type_is_a (_tmp27_, NETSUKUKU_TYPE_ANDNA_DOMAIN_REQUEST);
		if (!_tmp28_) {
			GError* _tmp29_;
			_tmp29_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk parameter 1 is not a AndnaDomainRequest.");
			_inner_error_ = _tmp29_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp30_ = iser0;
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, NETSUKUKU_TYPE_ANDNA_DOMAIN_REQUEST, NetsukukuAndnaDomainRequest));
		request = _tmp31_;
		_tmp32_ = data;
		_tmp33_ = zcd_remote_call_get_parameters (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = gee_list_get (_tmp34_, 1);
		iser1 = (zcdISerializable*) _tmp35_;
		_tmp36_ = iser1;
		_tmp37_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp36_);
		_tmp38_ = g_type_is_a (_tmp37_, ZCD_TYPE_SERIALIZABLE_BUFFER);
		if (!_tmp38_) {
			GError* _tmp39_;
			_tmp39_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk parameter 2 is not a SerializableBuffer.");
			_inner_error_ = _tmp39_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (request);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp40_ = iser1;
		_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer));
		signature = _tmp41_;
		_tmp42_ = data;
		_tmp43_ = zcd_remote_call_get_parameters (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = gee_list_get (_tmp44_, 2);
		iser2 = (zcdISerializable*) _tmp45_;
		_tmp46_ = iser2;
		_tmp47_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp46_);
		_tmp48_ = g_type_is_a (_tmp47_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp48_) {
			GError* _tmp49_;
			_tmp49_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk parameter 3 is not a bool.");
			_inner_error_ = _tmp49_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser1);
			_g_object_unref0 (request);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp50_ = iser2;
		_tmp51_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp52_ = _tmp51_;
		replicate = _tmp52_;
		_tmp53_ = request;
		_tmp54_ = signature;
		_tmp55_ = replicate;
		_tmp56_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) self, _tmp53_, _tmp54_, _tmp55_, &_inner_error_);
		_tmp57_ = _tmp56_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser1);
			_g_object_unref0 (request);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp57_;
		_g_object_unref0 (iser2);
		_g_object_unref0 (signature);
		_g_object_unref0 (iser1);
		_g_object_unref0 (request);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp58_ = pieces;
	_tmp58__length1 = pieces_length1;
	_tmp59_ = _tmp58_[0];
	if (g_strcmp0 (_tmp59_, "get_registrar") == 0) {
		gchar** _tmp60_;
		gint _tmp60__length1;
		zcdRemoteCall* _tmp62_;
		GeeList* _tmp63_;
		GeeList* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		zcdRemoteCall* _tmp68_;
		GeeList* _tmp69_;
		GeeList* _tmp70_;
		gpointer _tmp71_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp72_;
		GType _tmp73_ = 0UL;
		gboolean _tmp74_ = FALSE;
		zcdISerializable* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* hashed_domain;
		const gchar* _tmp80_;
		NetsukukuAndnaGetRegistrarResponse* _tmp81_ = NULL;
		NetsukukuAndnaGetRegistrarResponse* ret;
		NetsukukuAndnaGetRegistrarResponse* _tmp82_;
		_tmp60_ = pieces;
		_tmp60__length1 = pieces_length1;
		if (_tmp60__length1 != 1) {
			GError* _tmp61_;
			_tmp61_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_registrar is a function.");
			_inner_error_ = _tmp61_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp62_ = data;
		_tmp63_ = zcd_remote_call_get_parameters (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = gee_collection_get_size ((GeeCollection*) _tmp64_);
		_tmp66_ = _tmp65_;
		if (_tmp66_ != 1) {
			GError* _tmp67_;
			_tmp67_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_registrar wants 1 parameter.");
			_inner_error_ = _tmp67_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp68_ = data;
		_tmp69_ = zcd_remote_call_get_parameters (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = gee_list_get (_tmp70_, 0);
		iser0 = (zcdISerializable*) _tmp71_;
		_tmp72_ = iser0;
		_tmp73_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp72_);
		_tmp74_ = g_type_is_a (_tmp73_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp74_) {
			GError* _tmp75_;
			_tmp75_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_registrar parameter 1 is not a string.");
			_inner_error_ = _tmp75_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp76_ = iser0;
		_tmp77_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strdup (_tmp78_);
		hashed_domain = _tmp79_;
		_tmp80_ = hashed_domain;
		_tmp81_ = netsukuku_iandna_as_peer_get_registrar ((NetsukukuIAndnaAsPeer*) self, _tmp80_, &_inner_error_);
		ret = _tmp81_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp82_ = ret;
		if (_tmp82_ == NULL) {
			zcdSerializableNone* _tmp83_;
			_tmp83_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp83_;
			_g_object_unref0 (ret);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		result = (zcdISerializable*) ret;
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp84_ = pieces;
	_tmp84__length1 = pieces_length1;
	_tmp85_ = _tmp84_[0];
	if (g_strcmp0 (_tmp85_, "get_domain_record") == 0) {
		gchar** _tmp86_;
		gint _tmp86__length1;
		zcdRemoteCall* _tmp88_;
		GeeList* _tmp89_;
		GeeList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		zcdRemoteCall* _tmp94_;
		GeeList* _tmp95_;
		GeeList* _tmp96_;
		gpointer _tmp97_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp98_;
		GType _tmp99_ = 0UL;
		gboolean _tmp100_ = FALSE;
		zcdISerializable* _tmp102_;
		const gchar* _tmp103_;
		const gchar* _tmp104_;
		gchar* _tmp105_;
		gchar* hashed_domain;
		const gchar* _tmp106_;
		NetsukukuAndnaDomainRecord* _tmp107_ = NULL;
		NetsukukuAndnaDomainRecord* ret;
		NetsukukuAndnaDomainRecord* _tmp108_;
		_tmp86_ = pieces;
		_tmp86__length1 = pieces_length1;
		if (_tmp86__length1 != 1) {
			GError* _tmp87_;
			_tmp87_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_domain_record is a function.");
			_inner_error_ = _tmp87_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp88_ = data;
		_tmp89_ = zcd_remote_call_get_parameters (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = gee_collection_get_size ((GeeCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		if (_tmp92_ != 1) {
			GError* _tmp93_;
			_tmp93_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_domain_record wants 1 parameter.");
			_inner_error_ = _tmp93_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp94_ = data;
		_tmp95_ = zcd_remote_call_get_parameters (_tmp94_);
		_tmp96_ = _tmp95_;
		_tmp97_ = gee_list_get (_tmp96_, 0);
		iser0 = (zcdISerializable*) _tmp97_;
		_tmp98_ = iser0;
		_tmp99_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp98_);
		_tmp100_ = g_type_is_a (_tmp99_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp100_) {
			GError* _tmp101_;
			_tmp101_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_domain_record parameter 1 is not a string.");
			_inner_error_ = _tmp101_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp102_ = iser0;
		_tmp103_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp104_ = _tmp103_;
		_tmp105_ = g_strdup (_tmp104_);
		hashed_domain = _tmp105_;
		_tmp106_ = hashed_domain;
		_tmp107_ = netsukuku_iandna_as_peer_get_domain_record ((NetsukukuIAndnaAsPeer*) self, _tmp106_, &_inner_error_);
		ret = _tmp107_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp108_ = ret;
		if (_tmp108_ == NULL) {
			zcdSerializableNone* _tmp109_;
			_tmp109_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp109_;
			_g_object_unref0 (ret);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		result = (zcdISerializable*) ret;
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp110_ = pieces;
	_tmp110__length1 = pieces_length1;
	_tmp111_ = _tmp110_[0];
	if (g_strcmp0 (_tmp111_, "register_spread_record") == 0) {
		gchar** _tmp112_;
		gint _tmp112__length1;
		zcdRemoteCall* _tmp114_;
		GeeList* _tmp115_;
		GeeList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		zcdRemoteCall* _tmp120_;
		GeeList* _tmp121_;
		GeeList* _tmp122_;
		gpointer _tmp123_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp124_;
		GType _tmp125_ = 0UL;
		gboolean _tmp126_ = FALSE;
		zcdISerializable* _tmp128_;
		const gchar* _tmp129_;
		const gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* hashed_domain;
		zcdRemoteCall* _tmp132_;
		GeeList* _tmp133_;
		GeeList* _tmp134_;
		gpointer _tmp135_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp136_;
		GType _tmp137_ = 0UL;
		gboolean _tmp138_ = FALSE;
		zcdISerializable* _tmp140_;
		gint _tmp141_;
		gint _tmp142_;
		gint spread_number;
		zcdRemoteCall* _tmp143_;
		GeeList* _tmp144_;
		GeeList* _tmp145_;
		gpointer _tmp146_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp147_;
		GType _tmp148_ = 0UL;
		gboolean _tmp149_ = FALSE;
		zcdISerializable* _tmp151_;
		gboolean _tmp152_;
		gboolean _tmp153_;
		gboolean replicate;
		const gchar* _tmp154_;
		gint _tmp155_;
		gboolean _tmp156_;
		NetsukukuAndnaRegisterSpreadResponse* _tmp157_ = NULL;
		NetsukukuAndnaRegisterSpreadResponse* _tmp158_;
		_tmp112_ = pieces;
		_tmp112__length1 = pieces_length1;
		if (_tmp112__length1 != 1) {
			GError* _tmp113_;
			_tmp113_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record is a function.");
			_inner_error_ = _tmp113_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp114_ = data;
		_tmp115_ = zcd_remote_call_get_parameters (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = gee_collection_get_size ((GeeCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		if (_tmp118_ != 3) {
			GError* _tmp119_;
			_tmp119_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record wants 3 parameters.");
			_inner_error_ = _tmp119_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp120_ = data;
		_tmp121_ = zcd_remote_call_get_parameters (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = gee_list_get (_tmp122_, 0);
		iser0 = (zcdISerializable*) _tmp123_;
		_tmp124_ = iser0;
		_tmp125_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp124_);
		_tmp126_ = g_type_is_a (_tmp125_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp126_) {
			GError* _tmp127_;
			_tmp127_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record parameter 1 is not a string.");
			_inner_error_ = _tmp127_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp128_ = iser0;
		_tmp129_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp128_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp130_ = _tmp129_;
		_tmp131_ = g_strdup (_tmp130_);
		hashed_domain = _tmp131_;
		_tmp132_ = data;
		_tmp133_ = zcd_remote_call_get_parameters (_tmp132_);
		_tmp134_ = _tmp133_;
		_tmp135_ = gee_list_get (_tmp134_, 1);
		iser1 = (zcdISerializable*) _tmp135_;
		_tmp136_ = iser1;
		_tmp137_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp136_);
		_tmp138_ = g_type_is_a (_tmp137_, ZCD_TYPE_SERIALIZABLE_INT);
		if (!_tmp138_) {
			GError* _tmp139_;
			_tmp139_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record parameter 2 is not a int.");
			_inner_error_ = _tmp139_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp140_ = iser1;
		_tmp141_ = zcd_serializable_int_get_i (G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
		_tmp142_ = _tmp141_;
		spread_number = _tmp142_;
		_tmp143_ = data;
		_tmp144_ = zcd_remote_call_get_parameters (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = gee_list_get (_tmp145_, 2);
		iser2 = (zcdISerializable*) _tmp146_;
		_tmp147_ = iser2;
		_tmp148_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp147_);
		_tmp149_ = g_type_is_a (_tmp148_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp149_) {
			GError* _tmp150_;
			_tmp150_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record parameter 3 is not a bool.");
			_inner_error_ = _tmp150_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp151_ = iser2;
		_tmp152_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp153_ = _tmp152_;
		replicate = _tmp153_;
		_tmp154_ = hashed_domain;
		_tmp155_ = spread_number;
		_tmp156_ = replicate;
		_tmp157_ = netsukuku_iandna_as_peer_register_spread_record ((NetsukukuIAndnaAsPeer*) self, _tmp154_, _tmp155_, _tmp156_, &_inner_error_);
		_tmp158_ = _tmp157_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp158_;
		_g_object_unref0 (iser2);
		_g_object_unref0 (iser1);
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp159_ = pieces;
	_tmp159__length1 = pieces_length1;
	_tmp160_ = _tmp159_[0];
	if (g_strcmp0 (_tmp160_, "get_servers") == 0) {
		gchar** _tmp161_;
		gint _tmp161__length1;
		zcdRemoteCall* _tmp163_;
		GeeList* _tmp164_;
		GeeList* _tmp165_;
		gint _tmp166_;
		gint _tmp167_;
		zcdRemoteCall* _tmp169_;
		GeeList* _tmp170_;
		GeeList* _tmp171_;
		gpointer _tmp172_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp173_;
		GType _tmp174_ = 0UL;
		gboolean _tmp175_ = FALSE;
		zcdISerializable* _tmp177_;
		const gchar* _tmp178_;
		const gchar* _tmp179_;
		gchar* _tmp180_;
		gchar* hashed_domain;
		zcdRemoteCall* _tmp181_;
		GeeList* _tmp182_;
		GeeList* _tmp183_;
		gpointer _tmp184_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp185_;
		GType _tmp186_ = 0UL;
		gboolean _tmp187_ = FALSE;
		zcdISerializable* _tmp189_;
		NetsukukuAndnaServiceKey* _tmp190_;
		NetsukukuAndnaServiceKey* srv_key;
		zcdRemoteCall* _tmp191_;
		GeeList* _tmp192_;
		GeeList* _tmp193_;
		gpointer _tmp194_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp195_;
		GType _tmp196_ = 0UL;
		gboolean _tmp197_ = FALSE;
		zcdISerializable* _tmp199_;
		gint _tmp200_;
		gint _tmp201_;
		gint spread_number;
		zcdRemoteCall* _tmp202_;
		GeeList* _tmp203_;
		GeeList* _tmp204_;
		gpointer _tmp205_ = NULL;
		zcdISerializable* iser3;
		zcdISerializable* _tmp206_;
		GType _tmp207_ = 0UL;
		gboolean _tmp208_ = FALSE;
		zcdISerializable* _tmp210_;
		gboolean _tmp211_;
		gboolean _tmp212_;
		gboolean chain;
		const gchar* _tmp213_;
		NetsukukuAndnaServiceKey* _tmp214_;
		gint _tmp215_;
		gboolean _tmp216_;
		NetsukukuAndnaGetServersResponse* _tmp217_ = NULL;
		NetsukukuAndnaGetServersResponse* _tmp218_;
		_tmp161_ = pieces;
		_tmp161__length1 = pieces_length1;
		if (_tmp161__length1 != 1) {
			GError* _tmp162_;
			_tmp162_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers is a function.");
			_inner_error_ = _tmp162_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp163_ = data;
		_tmp164_ = zcd_remote_call_get_parameters (_tmp163_);
		_tmp165_ = _tmp164_;
		_tmp166_ = gee_collection_get_size ((GeeCollection*) _tmp165_);
		_tmp167_ = _tmp166_;
		if (_tmp167_ != 4) {
			GError* _tmp168_;
			_tmp168_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers wants 4 parameters.");
			_inner_error_ = _tmp168_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp169_ = data;
		_tmp170_ = zcd_remote_call_get_parameters (_tmp169_);
		_tmp171_ = _tmp170_;
		_tmp172_ = gee_list_get (_tmp171_, 0);
		iser0 = (zcdISerializable*) _tmp172_;
		_tmp173_ = iser0;
		_tmp174_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp173_);
		_tmp175_ = g_type_is_a (_tmp174_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp175_) {
			GError* _tmp176_;
			_tmp176_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers parameter 1 is not a string.");
			_inner_error_ = _tmp176_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp177_ = iser0;
		_tmp178_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp177_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp179_ = _tmp178_;
		_tmp180_ = g_strdup (_tmp179_);
		hashed_domain = _tmp180_;
		_tmp181_ = data;
		_tmp182_ = zcd_remote_call_get_parameters (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = gee_list_get (_tmp183_, 1);
		iser1 = (zcdISerializable*) _tmp184_;
		_tmp185_ = iser1;
		_tmp186_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp185_);
		_tmp187_ = g_type_is_a (_tmp186_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY);
		if (!_tmp187_) {
			GError* _tmp188_;
			_tmp188_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers parameter 2 is not a AndnaServiceKey.");
			_inner_error_ = _tmp188_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp189_ = iser1;
		_tmp190_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NetsukukuAndnaServiceKey));
		srv_key = _tmp190_;
		_tmp191_ = data;
		_tmp192_ = zcd_remote_call_get_parameters (_tmp191_);
		_tmp193_ = _tmp192_;
		_tmp194_ = gee_list_get (_tmp193_, 2);
		iser2 = (zcdISerializable*) _tmp194_;
		_tmp195_ = iser2;
		_tmp196_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp195_);
		_tmp197_ = g_type_is_a (_tmp196_, ZCD_TYPE_SERIALIZABLE_INT);
		if (!_tmp197_) {
			GError* _tmp198_;
			_tmp198_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers parameter 3 is not a int.");
			_inner_error_ = _tmp198_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (srv_key);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp199_ = iser2;
		_tmp200_ = zcd_serializable_int_get_i (G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
		_tmp201_ = _tmp200_;
		spread_number = _tmp201_;
		_tmp202_ = data;
		_tmp203_ = zcd_remote_call_get_parameters (_tmp202_);
		_tmp204_ = _tmp203_;
		_tmp205_ = gee_list_get (_tmp204_, 3);
		iser3 = (zcdISerializable*) _tmp205_;
		_tmp206_ = iser3;
		_tmp207_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp206_);
		_tmp208_ = g_type_is_a (_tmp207_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp208_) {
			GError* _tmp209_;
			_tmp209_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers parameter 4 is not a bool.");
			_inner_error_ = _tmp209_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (srv_key);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp210_ = iser3;
		_tmp211_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp210_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp212_ = _tmp211_;
		chain = _tmp212_;
		_tmp213_ = hashed_domain;
		_tmp214_ = srv_key;
		_tmp215_ = spread_number;
		_tmp216_ = chain;
		_tmp217_ = netsukuku_iandna_as_peer_get_servers ((NetsukukuIAndnaAsPeer*) self, _tmp213_, _tmp214_, _tmp215_, _tmp216_, &_inner_error_);
		_tmp218_ = _tmp217_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (srv_key);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp218_;
		_g_object_unref0 (iser3);
		_g_object_unref0 (iser2);
		_g_object_unref0 (srv_key);
		_g_object_unref0 (iser1);
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp219_ = pieces;
	_tmp219__length1 = pieces_length1;
	_tmp220_ = _tmp219_[0];
	if (g_strcmp0 (_tmp220_, "get_cache_records") == 0) {
		gchar** _tmp221_;
		gint _tmp221__length1;
		zcdRemoteCall* _tmp223_;
		GeeList* _tmp224_;
		GeeList* _tmp225_;
		gint _tmp226_;
		gint _tmp227_;
		NetsukukuAndnaGetCacheRecordsResponse* _tmp229_ = NULL;
		NetsukukuAndnaGetCacheRecordsResponse* _tmp230_;
		_tmp221_ = pieces;
		_tmp221__length1 = pieces_length1;
		if (_tmp221__length1 != 1) {
			GError* _tmp222_;
			_tmp222_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records is a function.");
			_inner_error_ = _tmp222_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp223_ = data;
		_tmp224_ = zcd_remote_call_get_parameters (_tmp223_);
		_tmp225_ = _tmp224_;
		_tmp226_ = gee_collection_get_size ((GeeCollection*) _tmp225_);
		_tmp227_ = _tmp226_;
		if (_tmp227_ != 0) {
			GError* _tmp228_;
			_tmp228_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records wants no parameters.");
			_inner_error_ = _tmp228_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp229_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) self, &_inner_error_);
		_tmp230_ = _tmp229_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp230_;
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp231_ = caller;
	_tmp232_ = data;
	_tmp233_ = ZCD_RPC_DISPATCHER_CLASS (netsukuku_andna_parent_class)->_dispatch ((zcdRPCDispatcher*) G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer), _tmp231_, _tmp232_, &_inner_error_);
	_tmp234_ = _tmp233_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = _tmp234_;
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar* netsukuku_andna_crypto_hash (const gchar* hostname) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (hostname != NULL, NULL);
	_tmp0_ = hostname;
	_tmp1_ = netsukuku_andna_utilities_crypto_hash (_tmp0_);
	result = _tmp1_;
	return result;
}


static NetsukukuNIP* netsukuku_andna_nip_for_lvl_pos (NetsukukuAndna* self, gint lvl, gint pos) {
	NetsukukuNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint* ret;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NetsukukuNIP* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp2_, &_tmp3_);
	ret = _tmp4_;
	ret_length1 = _tmp3_;
	_ret_size_ = ret_length1;
	_tmp5_ = lvl;
	_tmp6_ = pos;
	ret[_tmp5_] = _tmp6_;
	_tmp7_ = ret[_tmp5_];
	_tmp8_ = netsukuku_nip_new (ret, ret_length1);
	result = _tmp8_;
	ret = (g_free (ret), NULL);
	return result;
}


static gboolean _int_equal (const gint* s1, const gint* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static void netsukuku_andna_impl_hook_to_service (NetsukukuAndna* self, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Andna.hook_to_service");
	_tmp0_ = ((NetsukukuOptionalPeerToPeer*) self)->will_participate;
	if (_tmp0_) {
		GeeHashMap* _tmp1_;
		GeeHashMap* _tmp2_;
		GType _tmp438_ = 0UL;
		const gchar* _tmp439_ = NULL;
		const gchar* _tmp440_ = NULL;
		gchar* _tmp441_ = NULL;
		gchar* _tmp442_;
		_tmp1_ = self->priv->cache;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
		_tmp2_ = self->priv->request_queue;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp2_);
		{
			gint lvl;
			lvl = 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_;
					gint _tmp6_;
					NetsukukuMapRoute* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					gint* first_forward = NULL;
					gint* first_back = NULL;
					gint* last_back = NULL;
					GType _tmp10_ = 0UL;
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					NetsukukuMapRoute* _tmp13_;
					NetsukukuNIP* _tmp14_;
					NetsukukuNIP* _tmp15_;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_;
					gint _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					gchar* _tmp21_ = NULL;
					gchar* _tmp22_;
					gint _tmp23_;
					gint* _tmp24_ = NULL;
					gint* _tmp25_ = NULL;
					gint* _tmp26_ = NULL;
					gint* _tmp27_;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = lvl;
						lvl = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = lvl;
					_tmp7_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp8_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(_tmp6_ < _tmp9_)) {
						break;
					}
					_tmp10_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
					_tmp11_ = g_type_name (_tmp10_);
					_tmp12_ = string_to_string (_tmp11_);
					_tmp13_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp14_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = lvl;
					_tmp19_ = g_strdup_printf ("%i", _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strconcat (_tmp12_, ": hook: ", _tmp17_, " finding peers at lvl ", _tmp20_, NULL);
					_tmp22_ = _tmp21_;
					netsukuku_log_debug (_tmp22_);
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
					_g_free0 (_tmp17_);
					_tmp23_ = lvl;
					netsukuku_peer_to_peer_find_hook_peers ((NetsukukuPeerToPeer*) self, &_tmp24_, &_tmp25_, &_tmp26_, _tmp23_, NETSUKUKU_ANDNA_DUPLICATION, 120000);
					_g_free0 (first_forward);
					first_forward = _tmp24_;
					_g_free0 (first_back);
					first_back = _tmp25_;
					_g_free0 (last_back);
					last_back = _tmp26_;
					_tmp27_ = first_forward;
					if (_tmp27_ == NULL) {
						GType _tmp28_ = 0UL;
						const gchar* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_;
						_tmp28_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
						_tmp29_ = g_type_name (_tmp28_);
						_tmp30_ = string_to_string (_tmp29_);
						_tmp31_ = g_strconcat (_tmp30_, ": hook: no one in network at this level (except me)", NULL);
						_tmp32_ = _tmp31_;
						netsukuku_log_debug (_tmp32_);
						_g_free0 (_tmp32_);
					} else {
						gint* _tmp33_;
						_tmp33_ = first_back;
						if (_tmp33_ == NULL) {
							GType _tmp34_ = 0UL;
							const gchar* _tmp35_ = NULL;
							const gchar* _tmp36_ = NULL;
							gint* _tmp37_;
							gchar* _tmp38_ = NULL;
							gchar* _tmp39_;
							gchar* _tmp40_ = NULL;
							gchar* _tmp41_;
							gint _tmp42_;
							gint* _tmp43_;
							NetsukukuNIP* _tmp44_ = NULL;
							NetsukukuNIP* nip_first_forward;
							NetsukukuNIP* _tmp45_;
							NetsukukuRmtAndnaPeer* _tmp46_ = NULL;
							NetsukukuRmtAndnaPeer* peer_first_forward;
							NetsukukuRmtAndnaPeer* _tmp47_;
							NetsukukuAndnaGetCacheRecordsResponse* _tmp48_ = NULL;
							NetsukukuAndnaGetCacheRecordsResponse* cache_first_forward;
							_tmp34_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
							_tmp35_ = g_type_name (_tmp34_);
							_tmp36_ = string_to_string (_tmp35_);
							_tmp37_ = first_forward;
							_tmp38_ = g_strdup_printf ("%i", *_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = g_strconcat (_tmp36_, ": hook: few nodes at this level. get all from ", _tmp39_, ".", NULL);
							_tmp41_ = _tmp40_;
							netsukuku_log_debug (_tmp41_);
							_g_free0 (_tmp41_);
							_g_free0 (_tmp39_);
							_tmp42_ = lvl;
							_tmp43_ = first_forward;
							_tmp44_ = netsukuku_andna_nip_for_lvl_pos (self, _tmp42_, *_tmp43_);
							nip_first_forward = _tmp44_;
							_tmp45_ = nip_first_forward;
							_tmp46_ = netsukuku_andna_peer (self, _tmp45_, NULL, NULL);
							peer_first_forward = _tmp46_;
							_tmp47_ = peer_first_forward;
							_tmp48_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) _tmp47_, &_inner_error_);
							cache_first_forward = _tmp48_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (peer_first_forward);
								_g_object_unref0 (nip_first_forward);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							{
								NetsukukuAndnaGetCacheRecordsResponse* _tmp49_;
								GeeHashMap* _tmp50_;
								GeeSet* _tmp51_;
								GeeSet* _tmp52_;
								GeeSet* _tmp53_;
								GeeIterator* _tmp54_ = NULL;
								GeeIterator* _tmp55_;
								GeeIterator* _hashed_domain_it;
								_tmp49_ = cache_first_forward;
								_tmp50_ = _tmp49_->cache;
								_tmp51_ = gee_abstract_map_get_keys ((GeeMap*) _tmp50_);
								_tmp52_ = _tmp51_;
								_tmp53_ = _tmp52_;
								_tmp54_ = gee_iterable_iterator ((GeeIterable*) _tmp53_);
								_tmp55_ = _tmp54_;
								_g_object_unref0 (_tmp53_);
								_hashed_domain_it = _tmp55_;
								while (TRUE) {
									GeeIterator* _tmp56_;
									gboolean _tmp57_ = FALSE;
									GeeIterator* _tmp58_;
									gpointer _tmp59_ = NULL;
									gchar* hashed_domain;
									GType _tmp60_ = 0UL;
									const gchar* _tmp61_ = NULL;
									const gchar* _tmp62_ = NULL;
									const gchar* _tmp63_;
									const gchar* _tmp64_ = NULL;
									gint* _tmp65_;
									gchar* _tmp66_ = NULL;
									gchar* _tmp67_;
									gchar* _tmp68_ = NULL;
									gchar* _tmp69_;
									GeeHashMap* _tmp70_;
									const gchar* _tmp71_;
									gboolean _tmp72_ = FALSE;
									_tmp56_ = _hashed_domain_it;
									_tmp57_ = gee_iterator_next (_tmp56_);
									if (!_tmp57_) {
										break;
									}
									_tmp58_ = _hashed_domain_it;
									_tmp59_ = gee_iterator_get (_tmp58_);
									hashed_domain = (gchar*) _tmp59_;
									_tmp60_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
									_tmp61_ = g_type_name (_tmp60_);
									_tmp62_ = string_to_string (_tmp61_);
									_tmp63_ = hashed_domain;
									_tmp64_ = string_to_string (_tmp63_);
									_tmp65_ = first_forward;
									_tmp66_ = g_strdup_printf ("%i", *_tmp65_);
									_tmp67_ = _tmp66_;
									_tmp68_ = g_strconcat (_tmp62_, ": hook: there is ", _tmp64_, " in cache of ", _tmp67_, NULL);
									_tmp69_ = _tmp68_;
									netsukuku_log_debug (_tmp69_);
									_g_free0 (_tmp69_);
									_g_free0 (_tmp67_);
									_tmp70_ = self->priv->cache;
									_tmp71_ = hashed_domain;
									_tmp72_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp70_, _tmp71_);
									if (!_tmp72_) {
										GeeHashMap* _tmp73_;
										const gchar* _tmp74_;
										NetsukukuAndnaGetCacheRecordsResponse* _tmp75_;
										GeeHashMap* _tmp76_;
										const gchar* _tmp77_;
										gpointer _tmp78_ = NULL;
										NetsukukuAndnaDomainRecord* _tmp79_;
										GType _tmp80_ = 0UL;
										const gchar* _tmp81_ = NULL;
										const gchar* _tmp82_ = NULL;
										const gchar* _tmp83_;
										const gchar* _tmp84_ = NULL;
										gchar* _tmp85_ = NULL;
										gchar* _tmp86_;
										_tmp73_ = self->priv->cache;
										_tmp74_ = hashed_domain;
										_tmp75_ = cache_first_forward;
										_tmp76_ = _tmp75_->cache;
										_tmp77_ = hashed_domain;
										_tmp78_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp76_, _tmp77_);
										_tmp79_ = (NetsukukuAndnaDomainRecord*) _tmp78_;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp73_, _tmp74_, _tmp79_);
										_g_object_unref0 (_tmp79_);
										_tmp80_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
										_tmp81_ = g_type_name (_tmp80_);
										_tmp82_ = string_to_string (_tmp81_);
										_tmp83_ = hashed_domain;
										_tmp84_ = string_to_string (_tmp83_);
										_tmp85_ = g_strconcat (_tmp82_, ": hook: got ", _tmp84_, " in my cache", NULL);
										_tmp86_ = _tmp85_;
										netsukuku_log_debug (_tmp86_);
										_g_free0 (_tmp86_);
									}
									_g_free0 (hashed_domain);
								}
								_g_object_unref0 (_hashed_domain_it);
							}
							{
								NetsukukuAndnaGetCacheRecordsResponse* _tmp87_;
								GeeHashMap* _tmp88_;
								GeeSet* _tmp89_;
								GeeSet* _tmp90_;
								GeeSet* _tmp91_;
								GeeIterator* _tmp92_ = NULL;
								GeeIterator* _tmp93_;
								GeeIterator* _hashed_domain_it;
								_tmp87_ = cache_first_forward;
								_tmp88_ = _tmp87_->request_queue;
								_tmp89_ = gee_abstract_map_get_keys ((GeeMap*) _tmp88_);
								_tmp90_ = _tmp89_;
								_tmp91_ = _tmp90_;
								_tmp92_ = gee_iterable_iterator ((GeeIterable*) _tmp91_);
								_tmp93_ = _tmp92_;
								_g_object_unref0 (_tmp91_);
								_hashed_domain_it = _tmp93_;
								while (TRUE) {
									GeeIterator* _tmp94_;
									gboolean _tmp95_ = FALSE;
									GeeIterator* _tmp96_;
									gpointer _tmp97_ = NULL;
									gchar* hashed_domain;
									GType _tmp98_ = 0UL;
									const gchar* _tmp99_ = NULL;
									const gchar* _tmp100_ = NULL;
									const gchar* _tmp101_;
									const gchar* _tmp102_ = NULL;
									gint* _tmp103_;
									gchar* _tmp104_ = NULL;
									gchar* _tmp105_;
									gchar* _tmp106_ = NULL;
									gchar* _tmp107_;
									GeeHashMap* _tmp108_;
									const gchar* _tmp109_;
									gboolean _tmp110_ = FALSE;
									_tmp94_ = _hashed_domain_it;
									_tmp95_ = gee_iterator_next (_tmp94_);
									if (!_tmp95_) {
										break;
									}
									_tmp96_ = _hashed_domain_it;
									_tmp97_ = gee_iterator_get (_tmp96_);
									hashed_domain = (gchar*) _tmp97_;
									_tmp98_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
									_tmp99_ = g_type_name (_tmp98_);
									_tmp100_ = string_to_string (_tmp99_);
									_tmp101_ = hashed_domain;
									_tmp102_ = string_to_string (_tmp101_);
									_tmp103_ = first_forward;
									_tmp104_ = g_strdup_printf ("%i", *_tmp103_);
									_tmp105_ = _tmp104_;
									_tmp106_ = g_strconcat (_tmp100_, ": hook: there is ", _tmp102_, " in request_queue of ", _tmp105_, NULL);
									_tmp107_ = _tmp106_;
									netsukuku_log_debug (_tmp107_);
									_g_free0 (_tmp107_);
									_g_free0 (_tmp105_);
									_tmp108_ = self->priv->request_queue;
									_tmp109_ = hashed_domain;
									_tmp110_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp108_, _tmp109_);
									if (!_tmp110_) {
										GeeHashMap* _tmp111_;
										const gchar* _tmp112_;
										NetsukukuAndnaGetCacheRecordsResponse* _tmp113_;
										GeeHashMap* _tmp114_;
										const gchar* _tmp115_;
										gpointer _tmp116_ = NULL;
										GeeArrayList* _tmp117_;
										GType _tmp118_ = 0UL;
										const gchar* _tmp119_ = NULL;
										const gchar* _tmp120_ = NULL;
										const gchar* _tmp121_;
										const gchar* _tmp122_ = NULL;
										gchar* _tmp123_ = NULL;
										gchar* _tmp124_;
										_tmp111_ = self->priv->request_queue;
										_tmp112_ = hashed_domain;
										_tmp113_ = cache_first_forward;
										_tmp114_ = _tmp113_->request_queue;
										_tmp115_ = hashed_domain;
										_tmp116_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp114_, _tmp115_);
										_tmp117_ = (GeeArrayList*) _tmp116_;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp111_, _tmp112_, _tmp117_);
										_g_object_unref0 (_tmp117_);
										_tmp118_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
										_tmp119_ = g_type_name (_tmp118_);
										_tmp120_ = string_to_string (_tmp119_);
										_tmp121_ = hashed_domain;
										_tmp122_ = string_to_string (_tmp121_);
										_tmp123_ = g_strconcat (_tmp120_, ": hook: got ", _tmp122_, " in my request_queue", NULL);
										_tmp124_ = _tmp123_;
										netsukuku_log_debug (_tmp124_);
										_g_free0 (_tmp124_);
									}
									_g_free0 (hashed_domain);
								}
								_g_object_unref0 (_hashed_domain_it);
							}
							_g_object_unref0 (cache_first_forward);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							break;
						} else {
							gint* _tmp125_;
							gint* _tmp126_;
							gint _tmp261_;
							gint* _tmp262_;
							NetsukukuNIP* _tmp263_ = NULL;
							NetsukukuNIP* nip_first_forward;
							NetsukukuNIP* _tmp264_;
							NetsukukuRmtAndnaPeer* _tmp265_ = NULL;
							NetsukukuRmtAndnaPeer* peer_first_forward;
							NetsukukuRmtAndnaPeer* _tmp266_;
							NetsukukuAndnaGetCacheRecordsResponse* _tmp267_ = NULL;
							NetsukukuAndnaGetCacheRecordsResponse* cache_first_forward;
							_tmp125_ = first_back;
							_tmp126_ = last_back;
							if (_int_equal (_tmp125_, _tmp126_) != TRUE) {
								gint _tmp127_;
								gint* _tmp128_;
								NetsukukuNIP* _tmp129_ = NULL;
								NetsukukuNIP* nip_first_back;
								NetsukukuNIP* _tmp130_;
								NetsukukuRmtAndnaPeer* _tmp131_ = NULL;
								NetsukukuRmtAndnaPeer* peer_first_back;
								gint _tmp132_;
								gint* _tmp133_;
								NetsukukuNIP* _tmp134_ = NULL;
								NetsukukuNIP* nip_last_back;
								NetsukukuNIP* _tmp135_;
								NetsukukuRmtAndnaPeer* _tmp136_ = NULL;
								NetsukukuRmtAndnaPeer* peer_last_back;
								NetsukukuRmtAndnaPeer* _tmp137_;
								NetsukukuAndnaGetCacheRecordsResponse* _tmp138_ = NULL;
								NetsukukuAndnaGetCacheRecordsResponse* recs_first;
								NetsukukuRmtAndnaPeer* _tmp139_;
								NetsukukuAndnaGetCacheRecordsResponse* _tmp140_ = NULL;
								NetsukukuAndnaGetCacheRecordsResponse* recs_last;
								_tmp127_ = lvl;
								_tmp128_ = first_back;
								_tmp129_ = netsukuku_andna_nip_for_lvl_pos (self, _tmp127_, *_tmp128_);
								nip_first_back = _tmp129_;
								_tmp130_ = nip_first_back;
								_tmp131_ = netsukuku_andna_peer (self, _tmp130_, NULL, NULL);
								peer_first_back = _tmp131_;
								_tmp132_ = lvl;
								_tmp133_ = last_back;
								_tmp134_ = netsukuku_andna_nip_for_lvl_pos (self, _tmp132_, *_tmp133_);
								nip_last_back = _tmp134_;
								_tmp135_ = nip_last_back;
								_tmp136_ = netsukuku_andna_peer (self, _tmp135_, NULL, NULL);
								peer_last_back = _tmp136_;
								_tmp137_ = peer_first_back;
								_tmp138_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) _tmp137_, &_inner_error_);
								recs_first = _tmp138_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (peer_last_back);
									_g_object_unref0 (nip_last_back);
									_g_object_unref0 (peer_first_back);
									_g_object_unref0 (nip_first_back);
									_g_free0 (last_back);
									_g_free0 (first_back);
									_g_free0 (first_forward);
									return;
								}
								_tmp139_ = peer_last_back;
								_tmp140_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) _tmp139_, &_inner_error_);
								recs_last = _tmp140_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (recs_first);
									_g_object_unref0 (peer_last_back);
									_g_object_unref0 (nip_last_back);
									_g_object_unref0 (peer_first_back);
									_g_object_unref0 (nip_first_back);
									_g_free0 (last_back);
									_g_free0 (first_back);
									_g_free0 (first_forward);
									return;
								}
								{
									NetsukukuAndnaGetCacheRecordsResponse* _tmp141_;
									GeeHashMap* _tmp142_;
									GeeSet* _tmp143_;
									GeeSet* _tmp144_;
									GeeSet* _tmp145_;
									GeeIterator* _tmp146_ = NULL;
									GeeIterator* _tmp147_;
									GeeIterator* _hashed_domain_it;
									_tmp141_ = recs_first;
									_tmp142_ = _tmp141_->cache;
									_tmp143_ = gee_abstract_map_get_keys ((GeeMap*) _tmp142_);
									_tmp144_ = _tmp143_;
									_tmp145_ = _tmp144_;
									_tmp146_ = gee_iterable_iterator ((GeeIterable*) _tmp145_);
									_tmp147_ = _tmp146_;
									_g_object_unref0 (_tmp145_);
									_hashed_domain_it = _tmp147_;
									while (TRUE) {
										GeeIterator* _tmp148_;
										gboolean _tmp149_ = FALSE;
										GeeIterator* _tmp150_;
										gpointer _tmp151_ = NULL;
										gchar* hashed_domain;
										GType _tmp152_ = 0UL;
										const gchar* _tmp153_ = NULL;
										const gchar* _tmp154_ = NULL;
										const gchar* _tmp155_;
										const gchar* _tmp156_ = NULL;
										gint* _tmp157_;
										gchar* _tmp158_ = NULL;
										gchar* _tmp159_;
										gchar* _tmp160_ = NULL;
										gchar* _tmp161_;
										GeeHashMap* _tmp162_;
										const gchar* _tmp163_;
										gboolean _tmp164_ = FALSE;
										_tmp148_ = _hashed_domain_it;
										_tmp149_ = gee_iterator_next (_tmp148_);
										if (!_tmp149_) {
											break;
										}
										_tmp150_ = _hashed_domain_it;
										_tmp151_ = gee_iterator_get (_tmp150_);
										hashed_domain = (gchar*) _tmp151_;
										_tmp152_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
										_tmp153_ = g_type_name (_tmp152_);
										_tmp154_ = string_to_string (_tmp153_);
										_tmp155_ = hashed_domain;
										_tmp156_ = string_to_string (_tmp155_);
										_tmp157_ = first_back;
										_tmp158_ = g_strdup_printf ("%i", *_tmp157_);
										_tmp159_ = _tmp158_;
										_tmp160_ = g_strconcat (_tmp154_, ": hook: there is ", _tmp156_, " in cache of ", _tmp159_, NULL);
										_tmp161_ = _tmp160_;
										netsukuku_log_debug (_tmp161_);
										_g_free0 (_tmp161_);
										_g_free0 (_tmp159_);
										_tmp162_ = self->priv->cache;
										_tmp163_ = hashed_domain;
										_tmp164_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp162_, _tmp163_);
										if (!_tmp164_) {
											gboolean found;
											gboolean _tmp186_;
											found = FALSE;
											{
												NetsukukuAndnaGetCacheRecordsResponse* _tmp165_;
												GeeHashMap* _tmp166_;
												GeeSet* _tmp167_;
												GeeSet* _tmp168_;
												GeeSet* _tmp169_;
												GeeIterator* _tmp170_ = NULL;
												GeeIterator* _tmp171_;
												GeeIterator* _hashed_domain2_it;
												_tmp165_ = recs_last;
												_tmp166_ = _tmp165_->cache;
												_tmp167_ = gee_abstract_map_get_keys ((GeeMap*) _tmp166_);
												_tmp168_ = _tmp167_;
												_tmp169_ = _tmp168_;
												_tmp170_ = gee_iterable_iterator ((GeeIterable*) _tmp169_);
												_tmp171_ = _tmp170_;
												_g_object_unref0 (_tmp169_);
												_hashed_domain2_it = _tmp171_;
												while (TRUE) {
													GeeIterator* _tmp172_;
													gboolean _tmp173_ = FALSE;
													GeeIterator* _tmp174_;
													gpointer _tmp175_ = NULL;
													gchar* hashed_domain2;
													const gchar* _tmp176_;
													const gchar* _tmp177_;
													_tmp172_ = _hashed_domain2_it;
													_tmp173_ = gee_iterator_next (_tmp172_);
													if (!_tmp173_) {
														break;
													}
													_tmp174_ = _hashed_domain2_it;
													_tmp175_ = gee_iterator_get (_tmp174_);
													hashed_domain2 = (gchar*) _tmp175_;
													_tmp176_ = hashed_domain2;
													_tmp177_ = hashed_domain;
													if (g_strcmp0 (_tmp176_, _tmp177_) == 0) {
														GType _tmp178_ = 0UL;
														const gchar* _tmp179_ = NULL;
														const gchar* _tmp180_ = NULL;
														gint* _tmp181_;
														gchar* _tmp182_ = NULL;
														gchar* _tmp183_;
														gchar* _tmp184_ = NULL;
														gchar* _tmp185_;
														found = TRUE;
														_tmp178_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
														_tmp179_ = g_type_name (_tmp178_);
														_tmp180_ = string_to_string (_tmp179_);
														_tmp181_ = last_back;
														_tmp182_ = g_strdup_printf ("%i", *_tmp181_);
														_tmp183_ = _tmp182_;
														_tmp184_ = g_strconcat (_tmp180_, ": hook: but also in cache of ", _tmp183_, NULL);
														_tmp185_ = _tmp184_;
														netsukuku_log_debug (_tmp185_);
														_g_free0 (_tmp185_);
														_g_free0 (_tmp183_);
														_g_free0 (hashed_domain2);
														break;
													}
													_g_free0 (hashed_domain2);
												}
												_g_object_unref0 (_hashed_domain2_it);
											}
											_tmp186_ = found;
											if (!_tmp186_) {
												GeeHashMap* _tmp187_;
												const gchar* _tmp188_;
												NetsukukuAndnaGetCacheRecordsResponse* _tmp189_;
												GeeHashMap* _tmp190_;
												const gchar* _tmp191_;
												gpointer _tmp192_ = NULL;
												NetsukukuAndnaDomainRecord* _tmp193_;
												GType _tmp194_ = 0UL;
												const gchar* _tmp195_ = NULL;
												const gchar* _tmp196_ = NULL;
												const gchar* _tmp197_;
												const gchar* _tmp198_ = NULL;
												gchar* _tmp199_ = NULL;
												gchar* _tmp200_;
												_tmp187_ = self->priv->cache;
												_tmp188_ = hashed_domain;
												_tmp189_ = recs_first;
												_tmp190_ = _tmp189_->cache;
												_tmp191_ = hashed_domain;
												_tmp192_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp190_, _tmp191_);
												_tmp193_ = (NetsukukuAndnaDomainRecord*) _tmp192_;
												gee_abstract_map_set ((GeeAbstractMap*) _tmp187_, _tmp188_, _tmp193_);
												_g_object_unref0 (_tmp193_);
												_tmp194_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
												_tmp195_ = g_type_name (_tmp194_);
												_tmp196_ = string_to_string (_tmp195_);
												_tmp197_ = hashed_domain;
												_tmp198_ = string_to_string (_tmp197_);
												_tmp199_ = g_strconcat (_tmp196_, ": hook: got ", _tmp198_, " in my cache", NULL);
												_tmp200_ = _tmp199_;
												netsukuku_log_debug (_tmp200_);
												_g_free0 (_tmp200_);
											}
										}
										_g_free0 (hashed_domain);
									}
									_g_object_unref0 (_hashed_domain_it);
								}
								{
									NetsukukuAndnaGetCacheRecordsResponse* _tmp201_;
									GeeHashMap* _tmp202_;
									GeeSet* _tmp203_;
									GeeSet* _tmp204_;
									GeeSet* _tmp205_;
									GeeIterator* _tmp206_ = NULL;
									GeeIterator* _tmp207_;
									GeeIterator* _hashed_domain_it;
									_tmp201_ = recs_first;
									_tmp202_ = _tmp201_->request_queue;
									_tmp203_ = gee_abstract_map_get_keys ((GeeMap*) _tmp202_);
									_tmp204_ = _tmp203_;
									_tmp205_ = _tmp204_;
									_tmp206_ = gee_iterable_iterator ((GeeIterable*) _tmp205_);
									_tmp207_ = _tmp206_;
									_g_object_unref0 (_tmp205_);
									_hashed_domain_it = _tmp207_;
									while (TRUE) {
										GeeIterator* _tmp208_;
										gboolean _tmp209_ = FALSE;
										GeeIterator* _tmp210_;
										gpointer _tmp211_ = NULL;
										gchar* hashed_domain;
										GType _tmp212_ = 0UL;
										const gchar* _tmp213_ = NULL;
										const gchar* _tmp214_ = NULL;
										const gchar* _tmp215_;
										const gchar* _tmp216_ = NULL;
										gint* _tmp217_;
										gchar* _tmp218_ = NULL;
										gchar* _tmp219_;
										gchar* _tmp220_ = NULL;
										gchar* _tmp221_;
										GeeHashMap* _tmp222_;
										const gchar* _tmp223_;
										gboolean _tmp224_ = FALSE;
										_tmp208_ = _hashed_domain_it;
										_tmp209_ = gee_iterator_next (_tmp208_);
										if (!_tmp209_) {
											break;
										}
										_tmp210_ = _hashed_domain_it;
										_tmp211_ = gee_iterator_get (_tmp210_);
										hashed_domain = (gchar*) _tmp211_;
										_tmp212_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
										_tmp213_ = g_type_name (_tmp212_);
										_tmp214_ = string_to_string (_tmp213_);
										_tmp215_ = hashed_domain;
										_tmp216_ = string_to_string (_tmp215_);
										_tmp217_ = first_back;
										_tmp218_ = g_strdup_printf ("%i", *_tmp217_);
										_tmp219_ = _tmp218_;
										_tmp220_ = g_strconcat (_tmp214_, ": hook: there is ", _tmp216_, " in request_queue of ", _tmp219_, NULL);
										_tmp221_ = _tmp220_;
										netsukuku_log_debug (_tmp221_);
										_g_free0 (_tmp221_);
										_g_free0 (_tmp219_);
										_tmp222_ = self->priv->request_queue;
										_tmp223_ = hashed_domain;
										_tmp224_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp222_, _tmp223_);
										if (!_tmp224_) {
											gboolean found;
											gboolean _tmp246_;
											found = FALSE;
											{
												NetsukukuAndnaGetCacheRecordsResponse* _tmp225_;
												GeeHashMap* _tmp226_;
												GeeSet* _tmp227_;
												GeeSet* _tmp228_;
												GeeSet* _tmp229_;
												GeeIterator* _tmp230_ = NULL;
												GeeIterator* _tmp231_;
												GeeIterator* _hashed_domain2_it;
												_tmp225_ = recs_last;
												_tmp226_ = _tmp225_->request_queue;
												_tmp227_ = gee_abstract_map_get_keys ((GeeMap*) _tmp226_);
												_tmp228_ = _tmp227_;
												_tmp229_ = _tmp228_;
												_tmp230_ = gee_iterable_iterator ((GeeIterable*) _tmp229_);
												_tmp231_ = _tmp230_;
												_g_object_unref0 (_tmp229_);
												_hashed_domain2_it = _tmp231_;
												while (TRUE) {
													GeeIterator* _tmp232_;
													gboolean _tmp233_ = FALSE;
													GeeIterator* _tmp234_;
													gpointer _tmp235_ = NULL;
													gchar* hashed_domain2;
													const gchar* _tmp236_;
													const gchar* _tmp237_;
													_tmp232_ = _hashed_domain2_it;
													_tmp233_ = gee_iterator_next (_tmp232_);
													if (!_tmp233_) {
														break;
													}
													_tmp234_ = _hashed_domain2_it;
													_tmp235_ = gee_iterator_get (_tmp234_);
													hashed_domain2 = (gchar*) _tmp235_;
													_tmp236_ = hashed_domain2;
													_tmp237_ = hashed_domain;
													if (g_strcmp0 (_tmp236_, _tmp237_) == 0) {
														GType _tmp238_ = 0UL;
														const gchar* _tmp239_ = NULL;
														const gchar* _tmp240_ = NULL;
														gint* _tmp241_;
														gchar* _tmp242_ = NULL;
														gchar* _tmp243_;
														gchar* _tmp244_ = NULL;
														gchar* _tmp245_;
														found = TRUE;
														_tmp238_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
														_tmp239_ = g_type_name (_tmp238_);
														_tmp240_ = string_to_string (_tmp239_);
														_tmp241_ = last_back;
														_tmp242_ = g_strdup_printf ("%i", *_tmp241_);
														_tmp243_ = _tmp242_;
														_tmp244_ = g_strconcat (_tmp240_, ": hook: but also in request_queue of ", _tmp243_, NULL);
														_tmp245_ = _tmp244_;
														netsukuku_log_debug (_tmp245_);
														_g_free0 (_tmp245_);
														_g_free0 (_tmp243_);
														_g_free0 (hashed_domain2);
														break;
													}
													_g_free0 (hashed_domain2);
												}
												_g_object_unref0 (_hashed_domain2_it);
											}
											_tmp246_ = found;
											if (!_tmp246_) {
												GeeHashMap* _tmp247_;
												const gchar* _tmp248_;
												NetsukukuAndnaGetCacheRecordsResponse* _tmp249_;
												GeeHashMap* _tmp250_;
												const gchar* _tmp251_;
												gpointer _tmp252_ = NULL;
												GeeArrayList* _tmp253_;
												GType _tmp254_ = 0UL;
												const gchar* _tmp255_ = NULL;
												const gchar* _tmp256_ = NULL;
												const gchar* _tmp257_;
												const gchar* _tmp258_ = NULL;
												gchar* _tmp259_ = NULL;
												gchar* _tmp260_;
												_tmp247_ = self->priv->request_queue;
												_tmp248_ = hashed_domain;
												_tmp249_ = recs_first;
												_tmp250_ = _tmp249_->request_queue;
												_tmp251_ = hashed_domain;
												_tmp252_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp250_, _tmp251_);
												_tmp253_ = (GeeArrayList*) _tmp252_;
												gee_abstract_map_set ((GeeAbstractMap*) _tmp247_, _tmp248_, _tmp253_);
												_g_object_unref0 (_tmp253_);
												_tmp254_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
												_tmp255_ = g_type_name (_tmp254_);
												_tmp256_ = string_to_string (_tmp255_);
												_tmp257_ = hashed_domain;
												_tmp258_ = string_to_string (_tmp257_);
												_tmp259_ = g_strconcat (_tmp256_, ": hook: got ", _tmp258_, " in my request_queue", NULL);
												_tmp260_ = _tmp259_;
												netsukuku_log_debug (_tmp260_);
												_g_free0 (_tmp260_);
											}
										}
										_g_free0 (hashed_domain);
									}
									_g_object_unref0 (_hashed_domain_it);
								}
								_g_object_unref0 (recs_last);
								_g_object_unref0 (recs_first);
								_g_object_unref0 (peer_last_back);
								_g_object_unref0 (nip_last_back);
								_g_object_unref0 (peer_first_back);
								_g_object_unref0 (nip_first_back);
							}
							_tmp261_ = lvl;
							_tmp262_ = first_forward;
							_tmp263_ = netsukuku_andna_nip_for_lvl_pos (self, _tmp261_, *_tmp262_);
							nip_first_forward = _tmp263_;
							_tmp264_ = nip_first_forward;
							_tmp265_ = netsukuku_andna_peer (self, _tmp264_, NULL, NULL);
							peer_first_forward = _tmp265_;
							_tmp266_ = peer_first_forward;
							_tmp267_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) _tmp266_, &_inner_error_);
							cache_first_forward = _tmp267_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (peer_first_forward);
								_g_object_unref0 (nip_first_forward);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							{
								NetsukukuAndnaGetCacheRecordsResponse* _tmp268_;
								GeeHashMap* _tmp269_;
								GeeSet* _tmp270_;
								GeeSet* _tmp271_;
								GeeSet* _tmp272_;
								GeeIterator* _tmp273_ = NULL;
								GeeIterator* _tmp274_;
								GeeIterator* _hashed_domain_it;
								_tmp268_ = cache_first_forward;
								_tmp269_ = _tmp268_->cache;
								_tmp270_ = gee_abstract_map_get_keys ((GeeMap*) _tmp269_);
								_tmp271_ = _tmp270_;
								_tmp272_ = _tmp271_;
								_tmp273_ = gee_iterable_iterator ((GeeIterable*) _tmp272_);
								_tmp274_ = _tmp273_;
								_g_object_unref0 (_tmp272_);
								_hashed_domain_it = _tmp274_;
								while (TRUE) {
									GeeIterator* _tmp275_;
									gboolean _tmp276_ = FALSE;
									GeeIterator* _tmp277_;
									gpointer _tmp278_ = NULL;
									gchar* hashed_domain;
									GType _tmp279_ = 0UL;
									const gchar* _tmp280_ = NULL;
									const gchar* _tmp281_ = NULL;
									const gchar* _tmp282_;
									const gchar* _tmp283_ = NULL;
									gint* _tmp284_;
									gchar* _tmp285_ = NULL;
									gchar* _tmp286_;
									gchar* _tmp287_ = NULL;
									gchar* _tmp288_;
									GeeHashMap* _tmp289_;
									const gchar* _tmp290_;
									gboolean _tmp291_ = FALSE;
									_tmp275_ = _hashed_domain_it;
									_tmp276_ = gee_iterator_next (_tmp275_);
									if (!_tmp276_) {
										break;
									}
									_tmp277_ = _hashed_domain_it;
									_tmp278_ = gee_iterator_get (_tmp277_);
									hashed_domain = (gchar*) _tmp278_;
									_tmp279_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
									_tmp280_ = g_type_name (_tmp279_);
									_tmp281_ = string_to_string (_tmp280_);
									_tmp282_ = hashed_domain;
									_tmp283_ = string_to_string (_tmp282_);
									_tmp284_ = first_forward;
									_tmp285_ = g_strdup_printf ("%i", *_tmp284_);
									_tmp286_ = _tmp285_;
									_tmp287_ = g_strconcat (_tmp281_, ": hook: there is ", _tmp283_, " in cache of ", _tmp286_, NULL);
									_tmp288_ = _tmp287_;
									netsukuku_log_debug (_tmp288_);
									_g_free0 (_tmp288_);
									_g_free0 (_tmp286_);
									_tmp289_ = self->priv->cache;
									_tmp290_ = hashed_domain;
									_tmp291_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp289_, _tmp290_);
									if (!_tmp291_) {
										gboolean check;
										const gchar* _tmp292_;
										NetsukukuAndnaServiceHashnodeKey* _tmp293_;
										NetsukukuAndnaServiceHashnodeKey* _tmp294_;
										NetsukukuNIP* _tmp295_ = NULL;
										NetsukukuNIP* _tmp296_;
										gint _tmp297_;
										gint _tmp298_ = 0;
										gint _tmp299_;
										gint hk;
										gint _tmp300_;
										GeeList* _tmp301_ = NULL;
										GeeList* ids;
										GeeList* _tmp302_;
										gint* _tmp303_;
										gint _tmp304_ = 0;
										GeeList* _tmp305_;
										NetsukukuMapRoute* _tmp306_;
										NetsukukuNIP* _tmp307_;
										NetsukukuNIP* _tmp308_;
										gint _tmp309_;
										gint _tmp310_ = 0;
										gint _tmp311_ = 0;
										gboolean _tmp312_;
										gboolean _tmp338_;
										check = FALSE;
										_tmp292_ = hashed_domain;
										_tmp293_ = netsukuku_andna_service_hashnode_key_new (_tmp292_, 0);
										_tmp294_ = _tmp293_;
										_tmp295_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp294_);
										_tmp296_ = _tmp295_;
										_tmp297_ = lvl;
										_tmp298_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp296_, _tmp297_);
										_tmp299_ = _tmp298_;
										_g_object_unref0 (_tmp296_);
										_g_object_unref0 (_tmp294_);
										hk = _tmp299_;
										_tmp300_ = hk;
										_tmp301_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp300_, 1);
										ids = _tmp301_;
										_tmp302_ = ids;
										_tmp303_ = first_forward;
										_tmp304_ = gee_list_index_of (_tmp302_, (gpointer) ((gintptr) (*_tmp303_)));
										_tmp305_ = ids;
										_tmp306_ = ((NetsukukuPeerToPeer*) self)->maproute;
										_tmp307_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp306_);
										_tmp308_ = _tmp307_;
										_tmp309_ = lvl;
										_tmp310_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp308_, _tmp309_);
										_tmp311_ = gee_list_index_of (_tmp305_, (gpointer) ((gintptr) _tmp310_));
										if (_tmp304_ > _tmp311_) {
											check = TRUE;
										}
										_tmp312_ = check;
										if (!_tmp312_) {
											{
												gint spr;
												spr = 1;
												{
													gboolean _tmp313_;
													_tmp313_ = TRUE;
													while (TRUE) {
														gboolean _tmp314_;
														gint _tmp316_;
														const gchar* _tmp317_;
														gint _tmp318_;
														NetsukukuAndnaServiceHashnodeKey* _tmp319_;
														NetsukukuAndnaServiceHashnodeKey* _tmp320_;
														NetsukukuNIP* _tmp321_ = NULL;
														NetsukukuNIP* _tmp322_;
														gint _tmp323_;
														gint _tmp324_ = 0;
														gint _tmp325_;
														gint hk2;
														gint _tmp326_;
														GeeList* _tmp327_ = NULL;
														GeeList* ids2;
														GeeList* _tmp328_;
														gint* _tmp329_;
														gint _tmp330_ = 0;
														GeeList* _tmp331_;
														NetsukukuMapRoute* _tmp332_;
														NetsukukuNIP* _tmp333_;
														NetsukukuNIP* _tmp334_;
														gint _tmp335_;
														gint _tmp336_ = 0;
														gint _tmp337_ = 0;
														_tmp314_ = _tmp313_;
														if (!_tmp314_) {
															gint _tmp315_;
															_tmp315_ = spr;
															spr = _tmp315_ + 1;
														}
														_tmp313_ = FALSE;
														_tmp316_ = spr;
														if (!(_tmp316_ <= NETSUKUKU_SPREAD_ANDNA)) {
															break;
														}
														_tmp317_ = hashed_domain;
														_tmp318_ = spr;
														_tmp319_ = netsukuku_andna_service_hashnode_key_new (_tmp317_, _tmp318_);
														_tmp320_ = _tmp319_;
														_tmp321_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp320_);
														_tmp322_ = _tmp321_;
														_tmp323_ = lvl;
														_tmp324_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp322_, _tmp323_);
														_tmp325_ = _tmp324_;
														_g_object_unref0 (_tmp322_);
														_g_object_unref0 (_tmp320_);
														hk2 = _tmp325_;
														_tmp326_ = hk2;
														_tmp327_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp326_, 1);
														ids2 = _tmp327_;
														_tmp328_ = ids2;
														_tmp329_ = first_forward;
														_tmp330_ = gee_list_index_of (_tmp328_, (gpointer) ((gintptr) (*_tmp329_)));
														_tmp331_ = ids2;
														_tmp332_ = ((NetsukukuPeerToPeer*) self)->maproute;
														_tmp333_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp332_);
														_tmp334_ = _tmp333_;
														_tmp335_ = lvl;
														_tmp336_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp334_, _tmp335_);
														_tmp337_ = gee_list_index_of (_tmp331_, (gpointer) ((gintptr) _tmp336_));
														if (_tmp330_ > _tmp337_) {
															check = TRUE;
															_g_object_unref0 (ids2);
															break;
														}
														_g_object_unref0 (ids2);
													}
												}
											}
										}
										_tmp338_ = check;
										if (_tmp338_) {
											GeeHashMap* _tmp339_;
											const gchar* _tmp340_;
											NetsukukuAndnaGetCacheRecordsResponse* _tmp341_;
											GeeHashMap* _tmp342_;
											const gchar* _tmp343_;
											gpointer _tmp344_ = NULL;
											NetsukukuAndnaDomainRecord* _tmp345_;
											GType _tmp346_ = 0UL;
											const gchar* _tmp347_ = NULL;
											const gchar* _tmp348_ = NULL;
											const gchar* _tmp349_;
											const gchar* _tmp350_ = NULL;
											gchar* _tmp351_ = NULL;
											gchar* _tmp352_;
											_tmp339_ = self->priv->cache;
											_tmp340_ = hashed_domain;
											_tmp341_ = cache_first_forward;
											_tmp342_ = _tmp341_->cache;
											_tmp343_ = hashed_domain;
											_tmp344_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp342_, _tmp343_);
											_tmp345_ = (NetsukukuAndnaDomainRecord*) _tmp344_;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp339_, _tmp340_, _tmp345_);
											_g_object_unref0 (_tmp345_);
											_tmp346_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
											_tmp347_ = g_type_name (_tmp346_);
											_tmp348_ = string_to_string (_tmp347_);
											_tmp349_ = hashed_domain;
											_tmp350_ = string_to_string (_tmp349_);
											_tmp351_ = g_strconcat (_tmp348_, ": hook: got ", _tmp350_, " in my cache", NULL);
											_tmp352_ = _tmp351_;
											netsukuku_log_debug (_tmp352_);
											_g_free0 (_tmp352_);
										}
										_g_object_unref0 (ids);
									}
									_g_free0 (hashed_domain);
								}
								_g_object_unref0 (_hashed_domain_it);
							}
							{
								NetsukukuAndnaGetCacheRecordsResponse* _tmp353_;
								GeeHashMap* _tmp354_;
								GeeSet* _tmp355_;
								GeeSet* _tmp356_;
								GeeSet* _tmp357_;
								GeeIterator* _tmp358_ = NULL;
								GeeIterator* _tmp359_;
								GeeIterator* _hashed_domain_it;
								_tmp353_ = cache_first_forward;
								_tmp354_ = _tmp353_->request_queue;
								_tmp355_ = gee_abstract_map_get_keys ((GeeMap*) _tmp354_);
								_tmp356_ = _tmp355_;
								_tmp357_ = _tmp356_;
								_tmp358_ = gee_iterable_iterator ((GeeIterable*) _tmp357_);
								_tmp359_ = _tmp358_;
								_g_object_unref0 (_tmp357_);
								_hashed_domain_it = _tmp359_;
								while (TRUE) {
									GeeIterator* _tmp360_;
									gboolean _tmp361_ = FALSE;
									GeeIterator* _tmp362_;
									gpointer _tmp363_ = NULL;
									gchar* hashed_domain;
									GType _tmp364_ = 0UL;
									const gchar* _tmp365_ = NULL;
									const gchar* _tmp366_ = NULL;
									const gchar* _tmp367_;
									const gchar* _tmp368_ = NULL;
									gint* _tmp369_;
									gchar* _tmp370_ = NULL;
									gchar* _tmp371_;
									gchar* _tmp372_ = NULL;
									gchar* _tmp373_;
									GeeHashMap* _tmp374_;
									const gchar* _tmp375_;
									gboolean _tmp376_ = FALSE;
									_tmp360_ = _hashed_domain_it;
									_tmp361_ = gee_iterator_next (_tmp360_);
									if (!_tmp361_) {
										break;
									}
									_tmp362_ = _hashed_domain_it;
									_tmp363_ = gee_iterator_get (_tmp362_);
									hashed_domain = (gchar*) _tmp363_;
									_tmp364_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
									_tmp365_ = g_type_name (_tmp364_);
									_tmp366_ = string_to_string (_tmp365_);
									_tmp367_ = hashed_domain;
									_tmp368_ = string_to_string (_tmp367_);
									_tmp369_ = first_forward;
									_tmp370_ = g_strdup_printf ("%i", *_tmp369_);
									_tmp371_ = _tmp370_;
									_tmp372_ = g_strconcat (_tmp366_, ": hook: there is ", _tmp368_, " in request_queue of ", _tmp371_, NULL);
									_tmp373_ = _tmp372_;
									netsukuku_log_debug (_tmp373_);
									_g_free0 (_tmp373_);
									_g_free0 (_tmp371_);
									_tmp374_ = self->priv->request_queue;
									_tmp375_ = hashed_domain;
									_tmp376_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp374_, _tmp375_);
									if (!_tmp376_) {
										gboolean check;
										const gchar* _tmp377_;
										NetsukukuAndnaServiceHashnodeKey* _tmp378_;
										NetsukukuAndnaServiceHashnodeKey* _tmp379_;
										NetsukukuNIP* _tmp380_ = NULL;
										NetsukukuNIP* _tmp381_;
										gint _tmp382_;
										gint _tmp383_ = 0;
										gint _tmp384_;
										gint hk;
										gint _tmp385_;
										GeeList* _tmp386_ = NULL;
										GeeList* ids;
										GeeList* _tmp387_;
										gint* _tmp388_;
										gint _tmp389_ = 0;
										GeeList* _tmp390_;
										NetsukukuMapRoute* _tmp391_;
										NetsukukuNIP* _tmp392_;
										NetsukukuNIP* _tmp393_;
										gint _tmp394_;
										gint _tmp395_ = 0;
										gint _tmp396_ = 0;
										gboolean _tmp397_;
										gboolean _tmp423_;
										check = FALSE;
										_tmp377_ = hashed_domain;
										_tmp378_ = netsukuku_andna_service_hashnode_key_new (_tmp377_, 0);
										_tmp379_ = _tmp378_;
										_tmp380_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp379_);
										_tmp381_ = _tmp380_;
										_tmp382_ = lvl;
										_tmp383_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp381_, _tmp382_);
										_tmp384_ = _tmp383_;
										_g_object_unref0 (_tmp381_);
										_g_object_unref0 (_tmp379_);
										hk = _tmp384_;
										_tmp385_ = hk;
										_tmp386_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp385_, 1);
										ids = _tmp386_;
										_tmp387_ = ids;
										_tmp388_ = first_forward;
										_tmp389_ = gee_list_index_of (_tmp387_, (gpointer) ((gintptr) (*_tmp388_)));
										_tmp390_ = ids;
										_tmp391_ = ((NetsukukuPeerToPeer*) self)->maproute;
										_tmp392_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp391_);
										_tmp393_ = _tmp392_;
										_tmp394_ = lvl;
										_tmp395_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp393_, _tmp394_);
										_tmp396_ = gee_list_index_of (_tmp390_, (gpointer) ((gintptr) _tmp395_));
										if (_tmp389_ > _tmp396_) {
											check = TRUE;
										}
										_tmp397_ = check;
										if (!_tmp397_) {
											{
												gint spr;
												spr = 1;
												{
													gboolean _tmp398_;
													_tmp398_ = TRUE;
													while (TRUE) {
														gboolean _tmp399_;
														gint _tmp401_;
														const gchar* _tmp402_;
														gint _tmp403_;
														NetsukukuAndnaServiceHashnodeKey* _tmp404_;
														NetsukukuAndnaServiceHashnodeKey* _tmp405_;
														NetsukukuNIP* _tmp406_ = NULL;
														NetsukukuNIP* _tmp407_;
														gint _tmp408_;
														gint _tmp409_ = 0;
														gint _tmp410_;
														gint hk2;
														gint _tmp411_;
														GeeList* _tmp412_ = NULL;
														GeeList* ids2;
														GeeList* _tmp413_;
														gint* _tmp414_;
														gint _tmp415_ = 0;
														GeeList* _tmp416_;
														NetsukukuMapRoute* _tmp417_;
														NetsukukuNIP* _tmp418_;
														NetsukukuNIP* _tmp419_;
														gint _tmp420_;
														gint _tmp421_ = 0;
														gint _tmp422_ = 0;
														_tmp399_ = _tmp398_;
														if (!_tmp399_) {
															gint _tmp400_;
															_tmp400_ = spr;
															spr = _tmp400_ + 1;
														}
														_tmp398_ = FALSE;
														_tmp401_ = spr;
														if (!(_tmp401_ <= NETSUKUKU_SPREAD_ANDNA)) {
															break;
														}
														_tmp402_ = hashed_domain;
														_tmp403_ = spr;
														_tmp404_ = netsukuku_andna_service_hashnode_key_new (_tmp402_, _tmp403_);
														_tmp405_ = _tmp404_;
														_tmp406_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp405_);
														_tmp407_ = _tmp406_;
														_tmp408_ = lvl;
														_tmp409_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp407_, _tmp408_);
														_tmp410_ = _tmp409_;
														_g_object_unref0 (_tmp407_);
														_g_object_unref0 (_tmp405_);
														hk2 = _tmp410_;
														_tmp411_ = hk2;
														_tmp412_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp411_, 1);
														ids2 = _tmp412_;
														_tmp413_ = ids2;
														_tmp414_ = first_forward;
														_tmp415_ = gee_list_index_of (_tmp413_, (gpointer) ((gintptr) (*_tmp414_)));
														_tmp416_ = ids2;
														_tmp417_ = ((NetsukukuPeerToPeer*) self)->maproute;
														_tmp418_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp417_);
														_tmp419_ = _tmp418_;
														_tmp420_ = lvl;
														_tmp421_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp419_, _tmp420_);
														_tmp422_ = gee_list_index_of (_tmp416_, (gpointer) ((gintptr) _tmp421_));
														if (_tmp415_ > _tmp422_) {
															check = TRUE;
															_g_object_unref0 (ids2);
															break;
														}
														_g_object_unref0 (ids2);
													}
												}
											}
										}
										_tmp423_ = check;
										if (_tmp423_) {
											GeeHashMap* _tmp424_;
											const gchar* _tmp425_;
											NetsukukuAndnaGetCacheRecordsResponse* _tmp426_;
											GeeHashMap* _tmp427_;
											const gchar* _tmp428_;
											gpointer _tmp429_ = NULL;
											GeeArrayList* _tmp430_;
											GType _tmp431_ = 0UL;
											const gchar* _tmp432_ = NULL;
											const gchar* _tmp433_ = NULL;
											const gchar* _tmp434_;
											const gchar* _tmp435_ = NULL;
											gchar* _tmp436_ = NULL;
											gchar* _tmp437_;
											_tmp424_ = self->priv->request_queue;
											_tmp425_ = hashed_domain;
											_tmp426_ = cache_first_forward;
											_tmp427_ = _tmp426_->request_queue;
											_tmp428_ = hashed_domain;
											_tmp429_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp427_, _tmp428_);
											_tmp430_ = (GeeArrayList*) _tmp429_;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp424_, _tmp425_, _tmp430_);
											_g_object_unref0 (_tmp430_);
											_tmp431_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
											_tmp432_ = g_type_name (_tmp431_);
											_tmp433_ = string_to_string (_tmp432_);
											_tmp434_ = hashed_domain;
											_tmp435_ = string_to_string (_tmp434_);
											_tmp436_ = g_strconcat (_tmp433_, ": hook: got ", _tmp435_, " in my request_queue", NULL);
											_tmp437_ = _tmp436_;
											netsukuku_log_debug (_tmp437_);
											_g_free0 (_tmp437_);
										}
										_g_object_unref0 (ids);
									}
									_g_free0 (hashed_domain);
								}
								_g_object_unref0 (_hashed_domain_it);
							}
							_g_object_unref0 (cache_first_forward);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							break;
						}
					}
					_g_free0 (last_back);
					_g_free0 (first_back);
					_g_free0 (first_forward);
				}
			}
		}
		self->priv->hooked_to_service = TRUE;
		_tmp438_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp439_ = g_type_name (_tmp438_);
		_tmp440_ = string_to_string (_tmp439_);
		_tmp441_ = g_strconcat (_tmp440_, ": hook: finished.", NULL);
		_tmp442_ = _tmp441_;
		netsukuku_log_debug (_tmp442_);
		_g_free0 (_tmp442_);
		netsukuku_optional_peer_to_peer_participate ((NetsukukuOptionalPeerToPeer*) self);
		netsukuku_log_info ("Andna service: participating.");
	}
}


static void __lambda3_ (NetsukukuAndna* self, GError** error) {
	GError * _inner_error_ = NULL;
	netsukuku_andna_impl_hook_to_service (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void ___lambda3__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	__lambda3_ (self, error);
}


void netsukuku_andna_hook_to_service (NetsukukuAndna* self) {
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tasklets_tasklet_tasklet_callback (___lambda3__tasklets_tasklet_callback, self, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


/** This is the function h:KEY-->hIP.
          */
static NetsukukuNIP* netsukuku_andna_real_h (NetsukukuPeerToPeer* base, GObject* key) {
	NetsukukuAndna * self;
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuAndnaServiceHashnodeKey* _tmp1_;
	NetsukukuAndnaServiceHashnodeKey* _key;
	NetsukukuMapRoute* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NetsukukuNIP* _tmp8_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey));
	_key = _tmp1_;
	_tmp2_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp3_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp6_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = netsukuku_andna_utilities_key_to_hashnode_converter (_key, _tmp4_, _tmp7_);
	result = _tmp8_;
	_g_object_unref0 (_key);
	return result;
}


NetsukukuAndnaDomainRequest* netsukuku_andna_make_domain_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfiguration* cfg) {
	NetsukukuAndnaDomainRequest* result = NULL;
	NetsukukuAndnaPrivateConfiguration* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* hashed_domain;
	NetsukukuKeyPair* _tmp3_;
	NetsukukuPublicKeyWrapper* _tmp4_;
	NetsukukuPublicKeyWrapper* _tmp5_;
	NetsukukuPublicKey* _tmp6_ = NULL;
	NetsukukuPublicKey* pubk;
	NetsukukuMapRoute* _tmp7_;
	NetsukukuNIP* _tmp8_;
	NetsukukuNIP* _tmp9_;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* nip;
	GeeHashMap* services = NULL;
	GeeHashMap* _tmp11_ = NULL;
	const gchar* _tmp49_;
	NetsukukuPublicKey* _tmp50_;
	NetsukukuNIP* _tmp51_;
	GeeHashMap* _tmp52_;
	NetsukukuAndnaDomainRequest* _tmp53_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cfg != NULL, NULL);
	_tmp0_ = cfg;
	_tmp1_ = _tmp0_->domain;
	_tmp2_ = netsukuku_andna_crypto_hash (_tmp1_);
	hashed_domain = _tmp2_;
	_tmp3_ = self->priv->my_keys;
	_tmp4_ = netsukuku_key_pair_get_pub_key (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = netsukuku_public_key_wrapper_to_pubkey (_tmp5_);
	pubk = _tmp6_;
	_tmp7_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp8_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	nip = _tmp10_;
	_tmp11_ = netsukuku_andna_domain_request_make_empty_services ();
	_g_object_unref0 (services);
	services = _tmp11_;
	{
		NetsukukuAndnaPrivateConfiguration* _tmp12_;
		GeeHashMap* _tmp13_;
		GeeHashMap* _tmp14_;
		GeeSet* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeIterator* _tmp18_ = NULL;
		GeeIterator* _tmp19_;
		GeeIterator* _k_it;
		_tmp12_ = cfg;
		_tmp13_ = netsukuku_andna_private_configuration_get_services (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_abstract_map_get_keys ((GeeMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_k_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			NetsukukuAndnaServiceKey* k;
			GeeHashMap* _tmp24_;
			NetsukukuAndnaServiceKey* _tmp25_;
			GeeArrayList* _tmp26_ = NULL;
			GeeArrayList* _tmp27_;
			_tmp20_ = _k_it;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _k_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			k = (NetsukukuAndnaServiceKey*) _tmp23_;
			_tmp24_ = services;
			_tmp25_ = k;
			_tmp26_ = netsukuku_andna_server_request_make_empty_list ();
			_tmp27_ = _tmp26_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, _tmp25_, _tmp27_);
			_g_object_unref0 (_tmp27_);
			{
				NetsukukuAndnaPrivateConfiguration* _tmp28_;
				GeeHashMap* _tmp29_;
				GeeHashMap* _tmp30_;
				NetsukukuAndnaServiceKey* _tmp31_;
				gpointer _tmp32_ = NULL;
				GeeArrayList* _cfg_server_list;
				GeeArrayList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _cfg_server_size;
				gint _cfg_server_index;
				_tmp28_ = cfg;
				_tmp29_ = netsukuku_andna_private_configuration_get_services (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = k;
				_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, _tmp31_);
				_cfg_server_list = (GeeArrayList*) _tmp32_;
				_tmp33_ = _cfg_server_list;
				_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_cfg_server_size = _tmp35_;
				_cfg_server_index = -1;
				while (TRUE) {
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					GeeArrayList* _tmp39_;
					gint _tmp40_;
					gpointer _tmp41_ = NULL;
					NetsukukuAndnaPrivateConfigurationServer* cfg_server;
					GeeHashMap* _tmp42_;
					NetsukukuAndnaServiceKey* _tmp43_;
					gpointer _tmp44_ = NULL;
					GeeArrayList* _tmp45_;
					NetsukukuAndnaPrivateConfigurationServer* _tmp46_;
					NetsukukuAndnaServerRequest* _tmp47_ = NULL;
					NetsukukuAndnaServerRequest* _tmp48_;
					_tmp36_ = _cfg_server_index;
					_cfg_server_index = _tmp36_ + 1;
					_tmp37_ = _cfg_server_index;
					_tmp38_ = _cfg_server_size;
					if (!(_tmp37_ < _tmp38_)) {
						break;
					}
					_tmp39_ = _cfg_server_list;
					_tmp40_ = _cfg_server_index;
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
					cfg_server = (NetsukukuAndnaPrivateConfigurationServer*) _tmp41_;
					_tmp42_ = services;
					_tmp43_ = k;
					_tmp44_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp42_, _tmp43_);
					_tmp45_ = (GeeArrayList*) _tmp44_;
					_tmp46_ = cfg_server;
					_tmp47_ = netsukuku_andna_make_server_request (self, _tmp46_);
					_tmp48_ = _tmp47_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp48_);
					_g_object_unref0 (_tmp48_);
					_g_object_unref0 (_tmp45_);
					_g_object_unref0 (cfg_server);
				}
				_g_object_unref0 (_cfg_server_list);
			}
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	_tmp49_ = hashed_domain;
	_tmp50_ = pubk;
	_tmp51_ = nip;
	_tmp52_ = services;
	_tmp53_ = netsukuku_andna_domain_request_new (_tmp49_, _tmp50_, _tmp51_, _tmp52_);
	result = _tmp53_;
	_g_object_unref0 (services);
	_g_object_unref0 (nip);
	_g_object_unref0 (pubk);
	_g_free0 (hashed_domain);
	return result;
}


NetsukukuAndnaServerRequest* netsukuku_andna_make_server_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfigurationServer* cfg) {
	NetsukukuAndnaServerRequest* result = NULL;
	gchar* hashed_alias;
	NetsukukuAndnaPrivateConfigurationServer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp7_;
	NetsukukuPublicKey* _tmp8_;
	NetsukukuPublicKey* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	NetsukukuPublicKey* pubk;
	NetsukukuAndnaPrivateConfigurationServer* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint port_number;
	NetsukukuAndnaPrivateConfigurationServer* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint priority;
	NetsukukuAndnaPrivateConfigurationServer* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint weight;
	const gchar* _tmp20_;
	NetsukukuAndnaServerRequest* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cfg != NULL, NULL);
	hashed_alias = NULL;
	_tmp0_ = cfg;
	_tmp1_ = netsukuku_andna_private_configuration_server_get_alias (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		NetsukukuAndnaPrivateConfigurationServer* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		_tmp3_ = cfg;
		_tmp4_ = netsukuku_andna_private_configuration_server_get_alias (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = netsukuku_andna_crypto_hash (_tmp5_);
		_g_free0 (hashed_alias);
		hashed_alias = _tmp6_;
	}
	_tmp7_ = cfg;
	_tmp8_ = netsukuku_andna_private_configuration_server_get_pubk (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	pubk = _tmp10_;
	_tmp11_ = cfg;
	_tmp12_ = netsukuku_andna_private_configuration_server_get_port_number (_tmp11_);
	_tmp13_ = _tmp12_;
	port_number = _tmp13_;
	_tmp14_ = cfg;
	_tmp15_ = netsukuku_andna_private_configuration_server_get_priority (_tmp14_);
	_tmp16_ = _tmp15_;
	priority = _tmp16_;
	_tmp17_ = cfg;
	_tmp18_ = netsukuku_andna_private_configuration_server_get_weight (_tmp17_);
	_tmp19_ = _tmp18_;
	weight = _tmp19_;
	_tmp20_ = hashed_alias;
	_tmp21_ = netsukuku_andna_server_request_new (_tmp20_, pubk, port_number, priority, weight);
	result = _tmp21_;
	_g_object_unref0 (pubk);
	_g_free0 (hashed_alias);
	return result;
}


static void ________lambda12_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* tasklet_hostname;
	GObject* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint tasklet_i;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	tasklet_hostname = _tmp3_;
	_tmp4_ = tpar2;
	_tmp5_ = zcd_serializable_int_get_i (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
	_tmp6_ = _tmp5_;
	tasklet_i = _tmp6_;
	tasklets_tasklet_declare_self ("Andna.spread_registration");
	netsukuku_andna_ask_register_spread_record (self, tasklet_hostname, tasklet_i, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (tasklet_hostname);
		return;
	}
	_g_free0 (tasklet_hostname);
}


static void _________lambda12__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	________lambda12_ (self, obj1, obj2, error);
}


static void netsukuku_andna_impl_register_name (NetsukukuAndna* self, const gchar* hostname) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	NetsukukuDomainWanted* _tmp4_;
	NetsukukuDomainWanted* dw;
	NetsukukuDomainWanted* _tmp5_;
	TaskletsTasklet* _tmp6_ = NULL;
	NetsukukuDomainWanted* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	NetsukukuDomainWanted* _tmp10_;
	NetsukukuDomainWanted* _tmp11_;
	NetsukukuTimeCapsule* _tmp12_;
	GeeArrayList* _tmp13_;
	NetsukukuDomainWanted* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hostname != NULL);
	_tmp0_ = hostname;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("Andna.register_name(\"", _tmp1_, "\")", NULL);
	_tmp3_ = _tmp2_;
	tasklets_tasklet_declare_self (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = netsukuku_domain_wanted_new ();
	dw = _tmp4_;
	_tmp5_ = dw;
	_tmp6_ = tasklets_tasklet_self ();
	_g_object_unref0 (_tmp5_->tasklet);
	_tmp5_->tasklet = _tmp6_;
	_tmp7_ = dw;
	_tmp8_ = hostname;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (_tmp7_->hostname);
	_tmp7_->hostname = _tmp9_;
	_tmp10_ = dw;
	_tmp10_->registered = FALSE;
	_tmp11_ = dw;
	_tmp12_ = netsukuku_time_capsule_new ((gint64) 0);
	_g_object_unref0 (_tmp11_->ttl_before_request);
	_tmp11_->ttl_before_request = _tmp12_;
	_tmp13_ = self->priv->lst_domains;
	_tmp14_ = dw;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
	while (TRUE) {
		{
			const gchar* _tmp15_;
			NetsukukuAndnaRegisterMainResponse* _tmp16_ = NULL;
			NetsukukuAndnaRegisterMainResponse* resp;
			gboolean _tmp17_ = FALSE;
			NetsukukuAndnaRegisterMainResponse* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gboolean _tmp24_;
			_tmp15_ = hostname;
			_tmp16_ = netsukuku_andna_ask_register_main_for_pubk (self, _tmp15_, &_inner_error_);
			resp = _tmp16_;
			if (_inner_error_ != NULL) {
				goto __catch14_g_error;
			}
			_tmp18_ = resp;
			_tmp19_ = netsukuku_andna_register_main_response_get_response (_tmp18_);
			_tmp20_ = _tmp19_;
			if (g_strcmp0 (_tmp20_, "REGISTERED") == 0) {
				_tmp17_ = TRUE;
			} else {
				NetsukukuAndnaRegisterMainResponse* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = resp;
				_tmp22_ = netsukuku_andna_register_main_response_get_response (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp17_ = g_strcmp0 (_tmp23_, "UPDATED") == 0;
			}
			_tmp24_ = _tmp17_;
			if (_tmp24_) {
				const gchar* _tmp25_;
				NetsukukuDomainWanted* _tmp26_;
				NetsukukuDomainWanted* _tmp39_;
				NetsukukuAndnaRegisterMainResponse* _tmp40_;
				NetsukukuTimeCapsule* _tmp41_;
				NetsukukuTimeCapsule* _tmp42_;
				NetsukukuTimeCapsule* _tmp43_;
				NetsukukuDomainWanted* _tmp44_;
				NetsukukuDomainWanted* _tmp45_;
				NetsukukuTimeCapsule* _tmp46_;
				gint64 _tmp47_ = 0LL;
				NetsukukuTimeCapsule* _tmp48_;
				NetsukukuTimeCapsule* _tmp49_;
				NetsukukuTimeCapsule* maxttl;
				NetsukukuDomainWanted* _tmp50_;
				NetsukukuTimeCapsule* _tmp51_;
				NetsukukuTimeCapsule* _tmp52_;
				gboolean _tmp53_ = FALSE;
				_tmp25_ = hostname;
				g_signal_emit_by_name (self, "andna-registered", _tmp25_);
				_tmp26_ = dw;
				_tmp26_->registered = TRUE;
				{
					gint i;
					i = 1;
					{
						gboolean _tmp27_;
						_tmp27_ = TRUE;
						while (TRUE) {
							gboolean _tmp28_;
							gint _tmp30_;
							const gchar* _tmp31_;
							zcdSerializableString* _tmp32_;
							zcdSerializableString* _tmp33_;
							gint _tmp34_;
							zcdSerializableInt* _tmp35_;
							zcdSerializableInt* _tmp36_;
							TaskletsTasklet* _tmp37_ = NULL;
							TaskletsTasklet* _tmp38_;
							_tmp28_ = _tmp27_;
							if (!_tmp28_) {
								gint _tmp29_;
								_tmp29_ = i;
								i = _tmp29_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp30_ = i;
							if (!(_tmp30_ <= NETSUKUKU_SPREAD_ANDNA)) {
								break;
							}
							_tmp31_ = hostname;
							_tmp32_ = zcd_serializable_string_new (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = i;
							_tmp35_ = zcd_serializable_int_new (_tmp34_);
							_tmp36_ = _tmp35_;
							_tmp37_ = tasklets_tasklet_tasklet_callback (_________lambda12__tasklets_tasklet_callback, self, (GObject*) _tmp33_, (GObject*) _tmp36_, NULL, NULL);
							_tmp38_ = _tmp37_;
							_g_object_unref0 (_tmp38_);
							_g_object_unref0 (_tmp36_);
							_g_object_unref0 (_tmp33_);
						}
					}
				}
				_tmp39_ = dw;
				_tmp40_ = resp;
				_tmp41_ = netsukuku_andna_register_main_response_get_expires (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _g_object_ref0 (_tmp42_);
				_g_object_unref0 (_tmp39_->ttl_before_request);
				_tmp39_->ttl_before_request = _tmp43_;
				_tmp44_ = dw;
				_tmp45_ = dw;
				_tmp46_ = _tmp45_->ttl_before_request;
				_tmp47_ = tasklets_timer_get_msec_ttl ((TaskletsTimer*) _tmp46_);
				_tmp48_ = netsukuku_time_capsule_new (_tmp47_ - ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 10)));
				_g_object_unref0 (_tmp44_->ttl_before_request);
				_tmp44_->ttl_before_request = _tmp48_;
				_tmp49_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_WAIT_REFRESH_ANDNA);
				maxttl = _tmp49_;
				_tmp50_ = dw;
				_tmp51_ = _tmp50_->ttl_before_request;
				_tmp52_ = maxttl;
				_tmp53_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp51_, (TaskletsTimer*) _tmp52_);
				if (_tmp53_) {
					NetsukukuDomainWanted* _tmp54_;
					NetsukukuTimeCapsule* _tmp55_;
					NetsukukuTimeCapsule* _tmp56_;
					_tmp54_ = dw;
					_tmp55_ = maxttl;
					_tmp56_ = _g_object_ref0 (_tmp55_);
					_g_object_unref0 (_tmp54_->ttl_before_request);
					_tmp54_->ttl_before_request = _tmp56_;
				}
				_g_object_unref0 (maxttl);
			} else {
				const gchar* _tmp57_;
				const gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_;
				NetsukukuAndnaRegisterMainResponse* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				NetsukukuDomainWanted* _tmp69_;
				NetsukukuTimeCapsule* _tmp70_;
				_tmp57_ = hostname;
				_tmp58_ = string_to_string (_tmp57_);
				_tmp59_ = g_strconcat ("Andna: register_name('", _tmp58_, "')", NULL);
				_tmp60_ = _tmp59_;
				_tmp61_ = resp;
				_tmp62_ = netsukuku_andna_register_main_response_get_response (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = string_to_string (_tmp63_);
				_tmp65_ = g_strconcat (" got '", _tmp64_, "'", NULL);
				_tmp66_ = _tmp65_;
				_tmp67_ = g_strconcat (_tmp60_, _tmp66_, NULL);
				_tmp68_ = _tmp67_;
				netsukuku_log_warn (_tmp68_);
				_g_free0 (_tmp68_);
				_g_free0 (_tmp66_);
				_g_free0 (_tmp60_);
				_tmp69_ = dw;
				_tmp70_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
				_g_object_unref0 (_tmp69_->ttl_before_request);
				_tmp69_->ttl_before_request = _tmp70_;
			}
			_g_object_unref0 (resp);
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp71_;
			const gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_;
			GError* _tmp75_;
			GQuark _tmp76_;
			const gchar* _tmp77_ = NULL;
			GError* _tmp78_;
			gint _tmp79_;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_;
			GError* _tmp82_;
			const gchar* _tmp83_;
			const gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			NetsukukuDomainWanted* _tmp89_;
			NetsukukuTimeCapsule* _tmp90_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp71_ = hostname;
			_tmp72_ = string_to_string (_tmp71_);
			_tmp73_ = g_strconcat ("Andna: register_name('", _tmp72_, "')", NULL);
			_tmp74_ = _tmp73_;
			_tmp75_ = e;
			_tmp76_ = _tmp75_->domain;
			_tmp77_ = g_quark_to_string (_tmp76_);
			_tmp78_ = e;
			_tmp79_ = _tmp78_->code;
			_tmp80_ = g_strdup_printf ("%i", _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = e;
			_tmp83_ = _tmp82_->message;
			_tmp84_ = string_to_string (_tmp83_);
			_tmp85_ = g_strconcat (" got ", _tmp77_, " code ", _tmp81_, ": ", _tmp84_, "'", NULL);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_strconcat (_tmp74_, _tmp86_, NULL);
			_tmp88_ = _tmp87_;
			netsukuku_log_warn (_tmp88_);
			_g_free0 (_tmp88_);
			_g_free0 (_tmp86_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp74_);
			_tmp89_ = dw;
			_tmp90_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
			_g_object_unref0 (_tmp89_->ttl_before_request);
			_tmp89_->ttl_before_request = _tmp90_;
			_g_error_free0 (e);
		}
		__finally14:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dw);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			NetsukukuDomainWanted* _tmp91_;
			NetsukukuTimeCapsule* _tmp92_;
			gboolean _tmp93_ = FALSE;
			_tmp91_ = dw;
			_tmp92_ = _tmp91_->ttl_before_request;
			_tmp93_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp92_);
			if (!(!_tmp93_)) {
				break;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 100000);
		}
	}
	_g_object_unref0 (dw);
}


static void __lambda13_ (NetsukukuAndna* self, GObject* tpar1, GError** error) {
	GObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* tasklet_hostname;
	_tmp0_ = tpar1;
	_tmp1_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	tasklet_hostname = _tmp3_;
	netsukuku_andna_impl_register_name (self, tasklet_hostname);
	_g_free0 (tasklet_hostname);
}


static void ___lambda13__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	__lambda13_ (self, obj1, error);
}


static void netsukuku_andna_register_name (NetsukukuAndna* self, const gchar* hostname) {
	const gchar* _tmp0_;
	zcdSerializableString* _tmp1_;
	zcdSerializableString* _tmp2_;
	TaskletsTasklet* _tmp3_ = NULL;
	TaskletsTasklet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hostname != NULL);
	_tmp0_ = hostname;
	_tmp1_ = zcd_serializable_string_new (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tasklets_tasklet_tasklet_callback (___lambda13__tasklets_tasklet_callback, self, (GObject*) _tmp2_, NULL, NULL, NULL);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}


void netsukuku_andna_register_my_names (NetsukukuAndna* self) {
	g_return_if_fail (self != NULL);
	{
		NetsukukuAndnaPrivateConfigurationList* _tmp0_;
		NetsukukuAndnaPrivateConfigurationList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _cfg_list;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _cfg_size;
		gint _cfg_index;
		_tmp0_ = netsukuku_andna_get_configuration (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = netsukuku_andna_private_configuration_list_get_lst (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_cfg_list = _tmp4_;
		_tmp5_ = _cfg_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_cfg_size = _tmp7_;
		_cfg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuAndnaPrivateConfiguration* cfg;
			NetsukukuAndnaPrivateConfiguration* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* hostname;
			const gchar* _tmp17_;
			_tmp8_ = _cfg_index;
			_cfg_index = _tmp8_ + 1;
			_tmp9_ = _cfg_index;
			_tmp10_ = _cfg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _cfg_list;
			_tmp12_ = _cfg_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			cfg = (NetsukukuAndnaPrivateConfiguration*) _tmp13_;
			_tmp14_ = cfg;
			_tmp15_ = _tmp14_->domain;
			_tmp16_ = g_strdup (_tmp15_);
			hostname = _tmp16_;
			_tmp17_ = hostname;
			netsukuku_andna_register_name (self, _tmp17_);
			_g_free0 (hostname);
			_g_object_unref0 (cfg);
		}
		_g_object_unref0 (_cfg_list);
	}
}


void netsukuku_andna_stop_register_my_names (NetsukukuAndna* self) {
	GeeArrayList* _tmp13_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _dw_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dw_size;
		gint _dw_index;
		_tmp0_ = self->priv->lst_domains;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_dw_list = _tmp1_;
		_tmp2_ = _dw_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dw_size = _tmp4_;
		_dw_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuDomainWanted* dw;
			NetsukukuDomainWanted* _tmp11_;
			TaskletsTasklet* _tmp12_;
			_tmp5_ = _dw_index;
			_dw_index = _tmp5_ + 1;
			_tmp6_ = _dw_index;
			_tmp7_ = _dw_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _dw_list;
			_tmp9_ = _dw_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			dw = (NetsukukuDomainWanted*) _tmp10_;
			_tmp11_ = dw;
			_tmp12_ = _tmp11_->tasklet;
			tasklets_tasklet_abort (_tmp12_);
			_g_object_unref0 (dw);
		}
		_g_object_unref0 (_dw_list);
	}
	_tmp13_ = self->priv->lst_domains;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp13_);
}


gboolean netsukuku_andna_register_my_names_ongoing (NetsukukuAndna* self) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lst_domains;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}


static NetsukukuAndnaRegisterMainResponse* netsukuku_andna_ask_register_main_for_pubk (NetsukukuAndna* self, const gchar* hostname, GError** error) {
	NetsukukuAndnaRegisterMainResponse* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	NetsukukuAndnaPrivateConfigurationList* _tmp6_;
	NetsukukuAndnaPrivateConfigurationList* _tmp7_;
	const gchar* _tmp8_;
	NetsukukuAndnaPrivateConfiguration* _tmp9_ = NULL;
	NetsukukuAndnaPrivateConfiguration* cfg;
	NetsukukuAndnaDomainRequest* _tmp10_ = NULL;
	NetsukukuAndnaDomainRequest* request;
	NetsukukuKeyPair* _tmp11_;
	zcdSerializableBuffer* _tmp12_ = NULL;
	zcdSerializableBuffer* signature;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	NetsukukuAndnaServiceHashnodeKey* _tmp15_;
	NetsukukuAndnaServiceHashnodeKey* _tmp16_;
	NetsukukuRmtAndnaPeer* _tmp17_ = NULL;
	NetsukukuRmtAndnaPeer* _tmp18_;
	NetsukukuAndnaRegisterMainResponse* _tmp19_ = NULL;
	NetsukukuAndnaRegisterMainResponse* _tmp20_;
	NetsukukuAndnaRegisterMainResponse* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hostname != NULL, NULL);
	_tmp0_ = hostname;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("(\"", _tmp1_, "\")", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("ANDNA: ask_register_main_for_pubk", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	netsukuku_log_debug (_tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = netsukuku_andna_get_configuration (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = hostname;
	_tmp9_ = netsukuku_andna_private_configuration_list_get_domain (_tmp7_, _tmp8_);
	cfg = _tmp9_;
	_vala_assert (cfg != NULL, "cfg != null");
	_tmp10_ = netsukuku_andna_make_domain_request (self, cfg);
	request = _tmp10_;
	_tmp11_ = self->priv->my_keys;
	_tmp12_ = _netsukuku_andna_sign (self, request, _tmp11_);
	signature = _tmp12_;
	_tmp13_ = netsukuku_andna_domain_request_get_hashed_domain (request);
	_tmp14_ = _tmp13_;
	_tmp15_ = netsukuku_andna_service_hashnode_key_new (_tmp14_, 0);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) _tmp18_, request, signature, TRUE, &_inner_error_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp18_);
	_g_object_unref0 (_tmp16_);
	_tmp21_ = _tmp20_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (signature);
			_g_object_unref0 (request);
			_g_object_unref0 (cfg);
			return NULL;
		} else {
			_g_object_unref0 (signature);
			_g_object_unref0 (request);
			_g_object_unref0 (cfg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp21_;
	_g_object_unref0 (signature);
	_g_object_unref0 (request);
	_g_object_unref0 (cfg);
	return result;
}


static guchar* netsukuku_andna_prepare_msg (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, int* result_length1) {
	guchar* result = NULL;
	NetsukukuAndnaDomainRequest* _tmp0_;
	gint _tmp1_ = 0;
	guchar* _tmp2_ = NULL;
	guchar* message;
	gint message_length1;
	gint _message_size_;
	guchar* _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (req != NULL, NULL);
	_tmp0_ = req;
	_tmp2_ = netsukuku_andna_domain_request_hash_for_signature (_tmp0_, &_tmp1_);
	message = _tmp2_;
	message_length1 = _tmp1_;
	_message_size_ = message_length1;
	_tmp3_ = message;
	_tmp3__length1 = message_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static zcdSerializableBuffer* _netsukuku_andna_sign (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, NetsukukuKeyPair* key_pair) {
	zcdSerializableBuffer* result = NULL;
	NetsukukuKeyPair* _tmp0_;
	NetsukukuAndnaDomainRequest* _tmp1_;
	gint _tmp2_ = 0;
	guchar* _tmp3_ = NULL;
	guchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	guchar* _signed_;
	gint _signed__length1;
	gint __signed__size_;
	zcdSerializableBuffer* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (req != NULL, NULL);
	g_return_val_if_fail (key_pair != NULL, NULL);
	_tmp0_ = key_pair;
	_tmp1_ = req;
	_tmp3_ = netsukuku_andna_prepare_msg (self, _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp6_ = netsukuku_key_pair_sign (_tmp0_, _tmp4_, _tmp2_, &_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	_signed_ = _tmp7_;
	_signed__length1 = _tmp7__length1;
	__signed__size_ = _signed__length1;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = zcd_serializable_buffer_new ((guint8*) _signed_, (_signed__length1 * sizeof (guchar)) / sizeof (guint8));
	result = _tmp8_;
	_signed_ = (g_free (_signed_), NULL);
	return result;
}


static gboolean _netsukuku_andna_verify (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature) {
	gboolean result = FALSE;
	NetsukukuPublicKey* _tmp0_;
	NetsukukuPublicKeyWrapper* _tmp1_;
	NetsukukuPublicKeyWrapper* pkw;
	NetsukukuPublicKeyWrapper* _tmp2_;
	NetsukukuAndnaDomainRequest* _tmp3_;
	gint _tmp4_ = 0;
	guchar* _tmp5_ = NULL;
	guchar* _tmp6_;
	gint _tmp6__length1;
	zcdSerializableBuffer* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (req != NULL, FALSE);
	g_return_val_if_fail (pubk != NULL, FALSE);
	g_return_val_if_fail (signature != NULL, FALSE);
	_tmp0_ = pubk;
	_tmp1_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp0_, &_inner_error_);
	pkw = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = pkw;
	_tmp3_ = req;
	_tmp5_ = netsukuku_andna_prepare_msg (self, _tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp7_ = signature;
	_tmp8_ = zcd_serializable_buffer_get_buffer (_tmp7_, &_tmp8__length1);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	_tmp10_ = netsukuku_public_key_wrapper_verify (_tmp2_, _tmp6_, _tmp4_, (guchar*) _tmp9_, (_tmp9__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
	_tmp11_ = _tmp10_;
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pkw);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _tmp12_;
	_g_object_unref0 (pkw);
	return result;
}


static void netsukuku_andna_ask_register_spread_record (NetsukukuAndna* self, const gchar* hostname, gint spread_number, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	NetsukukuAndnaPrivateConfigurationList* _tmp9_;
	NetsukukuAndnaPrivateConfigurationList* _tmp10_;
	const gchar* _tmp11_;
	NetsukukuAndnaPrivateConfiguration* _tmp12_ = NULL;
	NetsukukuAndnaPrivateConfiguration* cfg;
	NetsukukuAndnaDomainRequest* _tmp13_ = NULL;
	NetsukukuAndnaDomainRequest* request;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* hashed_domain;
	gint _tmp17_;
	NetsukukuAndnaServiceHashnodeKey* _tmp18_;
	NetsukukuAndnaServiceHashnodeKey* _tmp19_;
	NetsukukuRmtAndnaPeer* _tmp20_ = NULL;
	NetsukukuRmtAndnaPeer* _tmp21_;
	gint _tmp22_;
	NetsukukuAndnaRegisterSpreadResponse* _tmp23_ = NULL;
	NetsukukuAndnaRegisterSpreadResponse* _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hostname != NULL);
	_tmp0_ = hostname;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = spread_number;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("(\"", _tmp1_, "\", ", _tmp4_, ")", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("ANDNA: ask_register_spread_record", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	netsukuku_log_debug (_tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = netsukuku_andna_get_configuration (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = hostname;
	_tmp12_ = netsukuku_andna_private_configuration_list_get_domain (_tmp10_, _tmp11_);
	cfg = _tmp12_;
	_vala_assert (cfg != NULL, "cfg != null");
	_tmp13_ = netsukuku_andna_make_domain_request (self, cfg);
	request = _tmp13_;
	_tmp14_ = netsukuku_andna_domain_request_get_hashed_domain (request);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup (_tmp15_);
	hashed_domain = _tmp16_;
	_tmp17_ = spread_number;
	_tmp18_ = netsukuku_andna_service_hashnode_key_new (hashed_domain, _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = spread_number;
	_tmp23_ = netsukuku_iandna_as_peer_register_spread_record ((NetsukukuIAndnaAsPeer*) _tmp21_, hashed_domain, _tmp22_, TRUE, &_inner_error_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp24_);
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (_tmp19_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (hashed_domain);
		_g_object_unref0 (request);
		_g_object_unref0 (cfg);
		return;
	}
	_g_free0 (hashed_domain);
	_g_object_unref0 (request);
	_g_object_unref0 (cfg);
}


NetsukukuAndnaGetRegistrarResponse* netsukuku_andna_ask_registrar (NetsukukuAndna* self, const gchar* hashed_domain) {
	NetsukukuAndnaGetRegistrarResponse* result = NULL;
	const gchar* _tmp0_;
	NetsukukuAndnaServiceHashnodeKey* _tmp1_;
	NetsukukuAndnaServiceHashnodeKey* _tmp2_;
	NetsukukuRmtAndnaPeer* _tmp3_ = NULL;
	NetsukukuRmtAndnaPeer* _tmp4_;
	NetsukukuRmtAndnaPeer* andnapeer;
	const gchar* _tmp5_;
	NetsukukuAndnaGetRegistrarResponse* _tmp6_ = NULL;
	NetsukukuAndnaGetRegistrarResponse* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = hashed_domain;
	_tmp1_ = netsukuku_andna_service_hashnode_key_new (_tmp0_, 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	andnapeer = _tmp4_;
	_tmp5_ = hashed_domain;
	_tmp6_ = netsukuku_iandna_as_peer_get_registrar ((NetsukukuIAndnaAsPeer*) andnapeer, _tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (andnapeer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp7_;
	_g_object_unref0 (andnapeer);
	return result;
}


static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_partial_nip_equal_func (a, b);
	return result;
}


static gboolean _netsukuku_andna_service_hashnode_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_andna_service_hashnode_key_equal_func (a, b);
	return result;
}


NetsukukuAndnaGetServersResponse* netsukuku_andna_ask_get_servers (NetsukukuAndna* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gboolean chain) {
	NetsukukuAndnaGetServersResponse* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* choose_from;
	GeeArrayList* _tmp1_;
	GeeArrayList* keys_from;
	const gchar* _tmp2_;
	NetsukukuAndnaServiceHashnodeKey* _tmp3_;
	NetsukukuAndnaServiceHashnodeKey* k_0;
	NetsukukuAndnaServiceHashnodeKey* _tmp4_;
	NetsukukuNIP* _tmp5_ = NULL;
	NetsukukuNIP* nip_0;
	NetsukukuNIP* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	NetsukukuNIP* _tmp11_;
	NetsukukuPartialNIP* _tmp12_ = NULL;
	NetsukukuPartialNIP* approx_0;
	NetsukukuPartialNIP* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GeeArrayList* _tmp18_;
	NetsukukuPartialNIP* _tmp19_;
	GeeArrayList* _tmp20_;
	NetsukukuAndnaServiceHashnodeKey* _tmp21_;
	NetsukukuMapRoute* _tmp47_;
	GeeArrayList* _tmp48_;
	NetsukukuPartialNIP* _tmp49_ = NULL;
	NetsukukuPartialNIP* chosen;
	NetsukukuPartialNIP* _tmp50_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (srv_key != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_PARTIAL_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
	choose_from = _tmp0_;
	_tmp1_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_service_hashnode_key_equal_func_gee_equal_data_func, NULL, NULL);
	keys_from = _tmp1_;
	_tmp2_ = hashed_domain;
	_tmp3_ = netsukuku_andna_service_hashnode_key_new (_tmp2_, 0);
	k_0 = _tmp3_;
	_tmp4_ = k_0;
	_tmp5_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp4_);
	nip_0 = _tmp5_;
	_tmp6_ = nip_0;
	_tmp7_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("Andna.ask_get_servers: possible choice: ", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	netsukuku_log_debug (_tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp11_ = nip_0;
	_tmp12_ = netsukuku_peer_to_peer_search_participant_as_nip ((NetsukukuPeerToPeer*) self, _tmp11_, 1, &_inner_error_);
	approx_0 = _tmp12_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (nip_0);
		_g_object_unref0 (k_0);
		_g_object_unref0 (keys_from);
		_g_object_unref0 (choose_from);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp13_ = approx_0;
	_tmp14_ = netsukuku_partial_nip_to_string (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat ("                                approx: ", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	netsukuku_log_debug (_tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_tmp18_ = choose_from;
	_tmp19_ = approx_0;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
	_tmp20_ = keys_from;
	_tmp21_ = k_0;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
	{
		gint i;
		i = 1;
		{
			gboolean _tmp22_;
			_tmp22_ = TRUE;
			while (TRUE) {
				gboolean _tmp23_;
				gint _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_;
				NetsukukuAndnaServiceHashnodeKey* _tmp28_;
				NetsukukuAndnaServiceHashnodeKey* k_i;
				NetsukukuAndnaServiceHashnodeKey* _tmp29_;
				NetsukukuNIP* _tmp30_ = NULL;
				NetsukukuNIP* nip_i;
				NetsukukuNIP* _tmp31_;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_;
				NetsukukuNIP* _tmp36_;
				NetsukukuPartialNIP* _tmp37_ = NULL;
				NetsukukuPartialNIP* approx_i;
				NetsukukuPartialNIP* _tmp38_;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_;
				GeeArrayList* _tmp43_;
				NetsukukuPartialNIP* _tmp44_;
				GeeArrayList* _tmp45_;
				NetsukukuAndnaServiceHashnodeKey* _tmp46_;
				_tmp23_ = _tmp22_;
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp25_ = i;
				if (!(_tmp25_ < NETSUKUKU_SPREAD_ANDNA)) {
					break;
				}
				_tmp26_ = hashed_domain;
				_tmp27_ = i;
				_tmp28_ = netsukuku_andna_service_hashnode_key_new (_tmp26_, _tmp27_);
				k_i = _tmp28_;
				_tmp29_ = k_i;
				_tmp30_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp29_);
				nip_i = _tmp30_;
				_tmp31_ = nip_i;
				_tmp32_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strconcat ("Andna.ask_get_servers: possible choice: ", _tmp33_, NULL);
				_tmp35_ = _tmp34_;
				netsukuku_log_debug (_tmp35_);
				_g_free0 (_tmp35_);
				_g_free0 (_tmp33_);
				_tmp36_ = nip_i;
				_tmp37_ = netsukuku_peer_to_peer_search_participant_as_nip ((NetsukukuPeerToPeer*) self, _tmp36_, 1, &_inner_error_);
				approx_i = _tmp37_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (nip_i);
					_g_object_unref0 (k_i);
					_g_object_unref0 (approx_0);
					_g_object_unref0 (nip_0);
					_g_object_unref0 (k_0);
					_g_object_unref0 (keys_from);
					_g_object_unref0 (choose_from);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp38_ = approx_i;
				_tmp39_ = netsukuku_partial_nip_to_string (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strconcat ("                                approx: ", _tmp40_, NULL);
				_tmp42_ = _tmp41_;
				netsukuku_log_debug (_tmp42_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				_tmp43_ = choose_from;
				_tmp44_ = approx_i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, _tmp44_);
				_tmp45_ = keys_from;
				_tmp46_ = k_i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
				_g_object_unref0 (approx_i);
				_g_object_unref0 (nip_i);
				_g_object_unref0 (k_i);
			}
		}
	}
	_tmp47_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp48_ = choose_from;
	_tmp49_ = netsukuku_map_route_choose_fast (_tmp47_, (GeeList*) _tmp48_);
	chosen = _tmp49_;
	_tmp50_ = chosen;
	if (_tmp50_ != NULL) {
		NetsukukuPartialNIP* _tmp51_;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		GeeArrayList* _tmp56_;
		NetsukukuPartialNIP* _tmp57_;
		gint _tmp58_ = 0;
		gint index;
		GeeArrayList* _tmp59_;
		gint _tmp60_;
		gpointer _tmp61_ = NULL;
		NetsukukuAndnaServiceHashnodeKey* chosen_key;
		NetsukukuAndnaServiceHashnodeKey* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		gint spread_number;
		GeeArrayList* _tmp65_;
		gint _tmp66_;
		gpointer _tmp67_ = NULL;
		NetsukukuAndnaServiceHashnodeKey* _tmp68_;
		NetsukukuRmtAndnaPeer* _tmp69_ = NULL;
		NetsukukuRmtAndnaPeer* _tmp70_;
		NetsukukuRmtAndnaPeer* node;
		NetsukukuRmtAndnaPeer* _tmp71_;
		const gchar* _tmp72_;
		NetsukukuAndnaServiceKey* _tmp73_;
		gint _tmp74_;
		gboolean _tmp75_;
		NetsukukuAndnaGetServersResponse* _tmp76_ = NULL;
		NetsukukuAndnaGetServersResponse* ret;
		_tmp51_ = chosen;
		_tmp52_ = netsukuku_partial_nip_to_string (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat ("Andna.ask_get_servers: winner is: ", _tmp53_, NULL);
		_tmp55_ = _tmp54_;
		netsukuku_log_debug (_tmp55_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		_tmp56_ = choose_from;
		_tmp57_ = chosen;
		_tmp58_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp56_, _tmp57_);
		index = _tmp58_;
		_tmp59_ = keys_from;
		_tmp60_ = index;
		_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp59_, _tmp60_);
		chosen_key = (NetsukukuAndnaServiceHashnodeKey*) _tmp61_;
		_tmp62_ = chosen_key;
		_tmp63_ = netsukuku_andna_service_hashnode_key_get_spread_num (_tmp62_);
		_tmp64_ = _tmp63_;
		spread_number = _tmp64_;
		_tmp65_ = keys_from;
		_tmp66_ = index;
		_tmp67_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, _tmp66_);
		_tmp68_ = (NetsukukuAndnaServiceHashnodeKey*) _tmp67_;
		_tmp69_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp68_, NULL);
		_tmp70_ = _tmp69_;
		_g_object_unref0 (_tmp68_);
		node = _tmp70_;
		_tmp71_ = node;
		_tmp72_ = hashed_domain;
		_tmp73_ = srv_key;
		_tmp74_ = spread_number;
		_tmp75_ = chain;
		_tmp76_ = netsukuku_iandna_as_peer_get_servers ((NetsukukuIAndnaAsPeer*) _tmp71_, _tmp72_, _tmp73_, _tmp74_, _tmp75_, &_inner_error_);
		ret = _tmp76_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (node);
			_g_object_unref0 (chosen_key);
			_g_object_unref0 (chosen);
			_g_object_unref0 (approx_0);
			_g_object_unref0 (nip_0);
			_g_object_unref0 (k_0);
			_g_object_unref0 (keys_from);
			_g_object_unref0 (choose_from);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = ret;
		_g_object_unref0 (node);
		_g_object_unref0 (chosen_key);
		_g_object_unref0 (chosen);
		_g_object_unref0 (approx_0);
		_g_object_unref0 (nip_0);
		_g_object_unref0 (k_0);
		_g_object_unref0 (keys_from);
		_g_object_unref0 (choose_from);
		return result;
	}
	result = NULL;
	_g_object_unref0 (chosen);
	_g_object_unref0 (approx_0);
	_g_object_unref0 (nip_0);
	_g_object_unref0 (k_0);
	_g_object_unref0 (keys_from);
	_g_object_unref0 (choose_from);
	return result;
}


/** Helper methods used as a server
          */
static void netsukuku_andna_str_debug_cache (NetsukukuAndna* self) {
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _k_it;
		_tmp0_ = self->priv->cache;
		_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_k_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* k;
			const gchar* _tmp10_;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			gpointer _tmp16_ = NULL;
			NetsukukuAndnaDomainRecord* _tmp17_;
			NetsukukuTimeCapsule* _tmp18_;
			NetsukukuTimeCapsule* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp6_ = _k_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _k_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			k = (gchar*) _tmp9_;
			_tmp10_ = k;
			_tmp11_ = string_to_string (_tmp10_);
			_tmp12_ = g_strconcat ("ANDNA:        ", _tmp11_, " ttl ", NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->cache;
			_tmp15_ = k;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
			_tmp17_ = (NetsukukuAndnaDomainRecord*) _tmp16_;
			_tmp18_ = netsukuku_andna_domain_record_get_expires (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = tasklets_timer_get_string_msec_ttl ((TaskletsTimer*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = string_to_string (_tmp21_);
			_tmp23_ = g_strconcat (_tmp13_, _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			netsukuku_log_debug (_tmp24_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp21_);
			_g_object_unref0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_free0 (k);
		}
		_g_object_unref0 (_k_it);
	}
}


static NetsukukuAndnaServerRecord* netsukuku_andna_make_server_record (NetsukukuAndna* self, NetsukukuAndnaServerRequest* req) {
	NetsukukuAndnaServerRecord* result = NULL;
	NetsukukuAndnaServerRequest* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* hashed_alias;
	NetsukukuAndnaServerRequest* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	NetsukukuPublicKey* _tmp6_;
	NetsukukuPublicKey* _tmp7_;
	NetsukukuPublicKey* pubk;
	NetsukukuAndnaServerRequest* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint port_number;
	NetsukukuAndnaServerRequest* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint priority;
	NetsukukuAndnaServerRequest* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint weight;
	NetsukukuAndnaServerRecord* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (req != NULL, NULL);
	_tmp0_ = req;
	_tmp1_ = netsukuku_andna_server_request_get_hashed_alias (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	hashed_alias = _tmp3_;
	_tmp4_ = req;
	_tmp5_ = netsukuku_andna_server_request_get_pubk (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	pubk = _tmp7_;
	_tmp8_ = req;
	_tmp9_ = netsukuku_andna_server_request_get_port_number (_tmp8_);
	_tmp10_ = _tmp9_;
	port_number = _tmp10_;
	_tmp11_ = req;
	_tmp12_ = netsukuku_andna_server_request_get_priority (_tmp11_);
	_tmp13_ = _tmp12_;
	priority = _tmp13_;
	_tmp14_ = req;
	_tmp15_ = netsukuku_andna_server_request_get_weight (_tmp14_);
	_tmp16_ = _tmp15_;
	weight = _tmp16_;
	_tmp17_ = netsukuku_andna_server_record_new (hashed_alias, pubk, port_number, priority, weight);
	result = _tmp17_;
	_g_object_unref0 (pubk);
	_g_free0 (hashed_alias);
	return result;
}


void netsukuku_andna_check_expirations_cache (NetsukukuAndna* self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* todel;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	netsukuku_log_debug ("ANDNA: cleaning expired entries - if any - from our ANDNA cache...");
	netsukuku_log_debug ("ANDNA: cache was:");
	netsukuku_andna_str_debug_cache (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	todel = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _hashed_domain_it;
		_tmp1_ = self->priv->cache;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_hashed_domain_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* hashed_domain;
			GeeHashMap* _tmp11_;
			const gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuAndnaDomainRecord* record;
			NetsukukuAndnaDomainRecord* _tmp14_;
			NetsukukuTimeCapsule* _tmp15_;
			NetsukukuTimeCapsule* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp7_ = _hashed_domain_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _hashed_domain_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			hashed_domain = (gchar*) _tmp10_;
			_tmp11_ = self->priv->cache;
			_tmp12_ = hashed_domain;
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
			record = (NetsukukuAndnaDomainRecord*) _tmp13_;
			_tmp14_ = record;
			_tmp15_ = netsukuku_andna_domain_record_get_expires (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp16_);
			if (_tmp17_) {
				GeeArrayList* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = todel;
				_tmp19_ = hashed_domain;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			}
			_g_object_unref0 (record);
			_g_free0 (hashed_domain);
		}
		_g_object_unref0 (_hashed_domain_it);
	}
	{
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _hashed_domain_list;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _hashed_domain_size;
		gint _hashed_domain_index;
		_tmp20_ = todel;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_hashed_domain_list = _tmp21_;
		_tmp22_ = _hashed_domain_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_hashed_domain_size = _tmp24_;
		_hashed_domain_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_ = NULL;
			gchar* hashed_domain;
			NetsukukuAndnaDomainRecord* record = NULL;
			GeeHashMap* _tmp31_;
			const gchar* _tmp32_;
			gpointer _tmp33_ = NULL;
			const gchar* _tmp34_;
			const gchar* _tmp35_ = NULL;
			NetsukukuAndnaDomainRecord* _tmp36_;
			NetsukukuPublicKey* _tmp37_;
			NetsukukuPublicKey* _tmp38_;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			GeeHashMap* _tmp43_;
			const gchar* _tmp44_;
			gboolean _tmp45_ = FALSE;
			_tmp25_ = _hashed_domain_index;
			_hashed_domain_index = _tmp25_ + 1;
			_tmp26_ = _hashed_domain_index;
			_tmp27_ = _hashed_domain_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _hashed_domain_list;
			_tmp29_ = _hashed_domain_index;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
			hashed_domain = (gchar*) _tmp30_;
			_tmp31_ = self->priv->cache;
			_tmp32_ = hashed_domain;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp31_, _tmp32_, &_tmp33_);
			_g_object_unref0 (record);
			record = _tmp33_;
			_tmp34_ = hashed_domain;
			_tmp35_ = string_to_string (_tmp34_);
			_tmp36_ = record;
			_tmp37_ = netsukuku_andna_domain_record_get_pubk (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = netsukuku_public_key_to_string (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat ("ANDNA: cleaned ", _tmp35_, " from pubk ", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			netsukuku_log_debug (_tmp42_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_tmp43_ = self->priv->request_queue;
			_tmp44_ = hashed_domain;
			_tmp45_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp43_, _tmp44_);
			if (_tmp45_) {
				GeeHashMap* _tmp46_;
				const gchar* _tmp47_;
				gpointer _tmp48_ = NULL;
				GeeArrayList* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				gboolean _tmp52_;
				_tmp46_ = self->priv->request_queue;
				_tmp47_ = hashed_domain;
				_tmp48_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp46_, _tmp47_);
				_tmp49_ = (GeeArrayList*) _tmp48_;
				_tmp50_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = _tmp51_ == 0;
				_g_object_unref0 (_tmp49_);
				if (_tmp52_) {
					GeeHashMap* _tmp53_;
					const gchar* _tmp54_;
					_tmp53_ = self->priv->request_queue;
					_tmp54_ = hashed_domain;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp53_, _tmp54_, NULL);
				} else {
					GeeHashMap* _tmp55_;
					const gchar* _tmp56_;
					gpointer _tmp57_ = NULL;
					GeeArrayList* _tmp58_;
					gpointer _tmp59_ = NULL;
					NetsukukuRegisterHostnameArguments* _tmp60_;
					NetsukukuRegisterHostnameArguments* args;
					NetsukukuRegisterHostnameArguments* _tmp61_;
					NetsukukuAndnaDomainRequest* _tmp62_;
					NetsukukuPublicKey* _tmp63_;
					NetsukukuPublicKey* _tmp64_;
					gchar* _tmp65_ = NULL;
					gchar* _tmp66_;
					gchar* _tmp67_ = NULL;
					gchar* _tmp68_;
					NetsukukuRegisterHostnameArguments* _tmp69_;
					NetsukukuAndnaDomainRequest* _tmp70_;
					NetsukukuRegisterHostnameArguments* _tmp71_;
					zcdSerializableBuffer* _tmp72_;
					NetsukukuAndnaRegisterMainResponse* _tmp73_ = NULL;
					NetsukukuAndnaRegisterMainResponse* res;
					_tmp55_ = self->priv->request_queue;
					_tmp56_ = hashed_domain;
					_tmp57_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp55_, _tmp56_);
					_tmp58_ = (GeeArrayList*) _tmp57_;
					_tmp59_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp58_, 0);
					_tmp60_ = (NetsukukuRegisterHostnameArguments*) _tmp59_;
					_g_object_unref0 (_tmp58_);
					args = _tmp60_;
					_tmp61_ = args;
					_tmp62_ = _tmp61_->request;
					_tmp63_ = netsukuku_andna_domain_request_get_pubk (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = netsukuku_public_key_to_string (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = g_strconcat ("ANDNA: trying to register it to pubk ", _tmp66_, NULL);
					_tmp68_ = _tmp67_;
					netsukuku_log_debug (_tmp68_);
					_g_free0 (_tmp68_);
					_g_free0 (_tmp66_);
					_tmp69_ = args;
					_tmp70_ = _tmp69_->request;
					_tmp71_ = args;
					_tmp72_ = _tmp71_->signature;
					_tmp73_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) self, _tmp70_, _tmp72_, TRUE, &_inner_error_);
					res = _tmp73_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (args);
						_g_object_unref0 (record);
						_g_free0 (hashed_domain);
						_g_object_unref0 (_hashed_domain_list);
						_g_object_unref0 (todel);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (res);
					_g_object_unref0 (args);
				}
			}
			_g_object_unref0 (record);
			_g_free0 (hashed_domain);
		}
		_g_object_unref0 (_hashed_domain_list);
	}
	netsukuku_log_debug ("ANDNA: cache now is:");
	netsukuku_andna_str_debug_cache (self);
	_g_object_unref0 (todel);
}


/** Remotable methods as peer()
          */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		NetsukukuAndna * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->response_ttl);
		_g_free0 (_data1_->response_msg);
		_g_object_unref0 (_data1_->request);
		_g_object_unref0 (_data1_->signature);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static guint _netsukuku_andna_service_key_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_andna_service_key_hash_func (v);
	return result;
}


static gboolean _netsukuku_andna_service_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_andna_service_key_equal_func (a, b);
	return result;
}


static gboolean _netsukuku_andna_server_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_andna_server_record_equal_func (a, b);
	return result;
}


static gboolean _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_register_hostname_arguments_equal_func_for_queue (a, b);
	return result;
}


static gboolean __lambda6_ (Block1Data* _data1_, GError** error) {
	NetsukukuAndna * self;
	gboolean result = FALSE;
	NetsukukuAndnaDomainRequest* _tmp0_;
	NetsukukuAndnaDomainRequest* _tmp1_;
	NetsukukuPublicKey* _tmp2_;
	NetsukukuPublicKey* _tmp3_;
	zcdSerializableBuffer* _tmp4_;
	gboolean _tmp5_ = FALSE;
	NetsukukuCounter* _tmp7_;
	NetsukukuAndnaDomainRequest* _tmp8_;
	NetsukukuNIP* _tmp9_;
	NetsukukuNIP* _tmp10_;
	NetsukukuAndnaDomainRequest* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	NetsukukuAndnaDomainRequest* _tmp14_;
	NetsukukuPublicKey* _tmp15_;
	NetsukukuPublicKey* _tmp16_;
	NetsukukuCounterCheckHostnameResponse* _tmp17_ = NULL;
	NetsukukuCounterCheckHostnameResponse* checkhostname;
	NetsukukuCounterCheckHostnameResponse* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GeeHashMap* _tmp22_;
	NetsukukuAndnaDomainRequest* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	GeeHashMap* _tmp44_;
	GeeHashMap* services;
	GeeHashMap* _tmp113_;
	NetsukukuAndnaDomainRequest* _tmp114_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	gpointer _tmp117_ = NULL;
	NetsukukuAndnaDomainRecord* rec_in_cache;
	NetsukukuAndnaDomainRecord* _tmp118_;
	NetsukukuPublicKey* _tmp119_;
	NetsukukuPublicKey* _tmp120_;
	NetsukukuAndnaDomainRequest* _tmp121_;
	NetsukukuPublicKey* _tmp122_;
	NetsukukuPublicKey* _tmp123_;
	gboolean _tmp124_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->request;
	_tmp1_ = _data1_->request;
	_tmp2_ = netsukuku_andna_domain_request_get_pubk (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->signature;
	_tmp5_ = _netsukuku_andna_verify (self, _tmp0_, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not your signature.");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp7_ = self->priv->counter;
	_tmp8_ = _data1_->request;
	_tmp9_ = netsukuku_andna_domain_request_get_nip (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _data1_->request;
	_tmp12_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _data1_->request;
	_tmp15_ = netsukuku_andna_domain_request_get_pubk (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_counter_ask_check_hostname (_tmp7_, _tmp10_, _tmp13_, _tmp16_, &_inner_error_);
	checkhostname = _tmp17_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp18_ = checkhostname;
	_tmp19_ = netsukuku_counter_check_hostname_response_get_response (_tmp18_);
	_tmp20_ = _tmp19_;
	if (!_tmp20_) {
		GError* _tmp21_;
		_tmp21_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not registered in Counter service.");
		_inner_error_ = _tmp21_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (checkhostname);
			return FALSE;
		} else {
			_g_object_unref0 (checkhostname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp22_ = self->priv->cache;
	_tmp23_ = _data1_->request;
	_tmp24_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp22_, _tmp25_);
	if (!_tmp26_) {
		GeeHashMap* _tmp27_;
		NetsukukuAndnaDomainRequest* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		NetsukukuAndnaDomainRequest* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		NetsukukuAndnaDomainRequest* _tmp34_;
		NetsukukuPublicKey* _tmp35_;
		NetsukukuPublicKey* _tmp36_;
		NetsukukuAndnaDomainRequest* _tmp37_;
		NetsukukuNIP* _tmp38_;
		NetsukukuNIP* _tmp39_;
		NetsukukuAndnaDomainRecord* _tmp40_;
		NetsukukuAndnaDomainRecord* _tmp41_;
		gchar* _tmp42_;
		NetsukukuTimeCapsule* _tmp43_;
		_tmp27_ = self->priv->cache;
		_tmp28_ = _data1_->request;
		_tmp29_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _data1_->request;
		_tmp32_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = _data1_->request;
		_tmp35_ = netsukuku_andna_domain_request_get_pubk (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = _data1_->request;
		_tmp38_ = netsukuku_andna_domain_request_get_nip (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = netsukuku_andna_domain_record_new (NETSUKUKU_MAX_TTL_ANDNA, _tmp33_, _tmp36_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp30_, _tmp41_);
		_g_object_unref0 (_tmp41_);
		_tmp42_ = g_strdup ("REGISTERED");
		_g_free0 (_data1_->response_msg);
		_data1_->response_msg = _tmp42_;
		_tmp43_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_ANDNA);
		_g_object_unref0 (_data1_->response_ttl);
		_data1_->response_ttl = _tmp43_;
	}
	_tmp44_ = gee_hash_map_new (NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_service_key_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_andna_service_key_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	services = _tmp44_;
	{
		NetsukukuAndnaDomainRequest* _tmp45_;
		GeeHashMap* _tmp46_;
		GeeHashMap* _tmp47_;
		GeeSet* _tmp48_;
		GeeSet* _tmp49_;
		GeeSet* _tmp50_;
		GeeIterator* _tmp51_ = NULL;
		GeeIterator* _tmp52_;
		GeeIterator* _srvk_it;
		_tmp45_ = _data1_->request;
		_tmp46_ = netsukuku_andna_domain_request_get_services (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = gee_abstract_map_get_keys ((GeeMap*) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = _tmp49_;
		_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
		_tmp52_ = _tmp51_;
		_g_object_unref0 (_tmp50_);
		_srvk_it = _tmp52_;
		while (TRUE) {
			GeeIterator* _tmp53_;
			gboolean _tmp54_ = FALSE;
			GeeIterator* _tmp55_;
			gpointer _tmp56_ = NULL;
			NetsukukuAndnaServiceKey* srvk;
			GeeHashMap* _tmp57_;
			NetsukukuAndnaServiceKey* _tmp58_;
			GeeArrayList* _tmp59_;
			GeeArrayList* _tmp60_;
			GeeHashMap* _tmp104_;
			NetsukukuAndnaServiceKey* _tmp105_;
			gpointer _tmp106_ = NULL;
			GeeArrayList* _tmp107_;
			gint _tmp108_;
			gint _tmp109_;
			gboolean _tmp110_;
			_tmp53_ = _srvk_it;
			_tmp54_ = gee_iterator_next (_tmp53_);
			if (!_tmp54_) {
				break;
			}
			_tmp55_ = _srvk_it;
			_tmp56_ = gee_iterator_get (_tmp55_);
			srvk = (NetsukukuAndnaServiceKey*) _tmp56_;
			_tmp57_ = services;
			_tmp58_ = srvk;
			_tmp59_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_server_record_equal_func_gee_equal_data_func, NULL, NULL);
			_tmp60_ = _tmp59_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp57_, _tmp58_, _tmp60_);
			_g_object_unref0 (_tmp60_);
			{
				NetsukukuAndnaDomainRequest* _tmp61_;
				GeeHashMap* _tmp62_;
				GeeHashMap* _tmp63_;
				NetsukukuAndnaServiceKey* _tmp64_;
				gpointer _tmp65_ = NULL;
				GeeArrayList* _srvrec_list;
				GeeArrayList* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				gint _srvrec_size;
				gint _srvrec_index;
				_tmp61_ = _data1_->request;
				_tmp62_ = netsukuku_andna_domain_request_get_services (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = srvk;
				_tmp65_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp63_, _tmp64_);
				_srvrec_list = (GeeArrayList*) _tmp65_;
				_tmp66_ = _srvrec_list;
				_tmp67_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp66_);
				_tmp68_ = _tmp67_;
				_srvrec_size = _tmp68_;
				_srvrec_index = -1;
				while (TRUE) {
					gint _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					GeeArrayList* _tmp72_;
					gint _tmp73_;
					gpointer _tmp74_ = NULL;
					NetsukukuAndnaServerRequest* srvrec;
					NetsukukuAndnaServerRequest* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp69_ = _srvrec_index;
					_srvrec_index = _tmp69_ + 1;
					_tmp70_ = _srvrec_index;
					_tmp71_ = _srvrec_size;
					if (!(_tmp70_ < _tmp71_)) {
						break;
					}
					_tmp72_ = _srvrec_list;
					_tmp73_ = _srvrec_index;
					_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, _tmp73_);
					srvrec = (NetsukukuAndnaServerRequest*) _tmp74_;
					_tmp75_ = srvrec;
					_tmp76_ = netsukuku_andna_server_request_get_hashed_alias (_tmp75_);
					_tmp77_ = _tmp76_;
					if (_tmp77_ != NULL) {
						NetsukukuAndnaServerRequest* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						NetsukukuAndnaGetRegistrarResponse* _tmp81_ = NULL;
						NetsukukuAndnaGetRegistrarResponse* registrar_alias;
						NetsukukuAndnaGetRegistrarResponse* _tmp82_;
						_tmp78_ = srvrec;
						_tmp79_ = netsukuku_andna_server_request_get_hashed_alias (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = netsukuku_andna_ask_registrar (self, _tmp80_);
						registrar_alias = _tmp81_;
						_tmp82_ = registrar_alias;
						if (_tmp82_ != NULL) {
							NetsukukuAndnaGetRegistrarResponse* _tmp83_;
							NetsukukuPublicKey* _tmp84_;
							NetsukukuPublicKey* _tmp85_;
							NetsukukuAndnaServerRequest* _tmp86_;
							NetsukukuPublicKey* _tmp87_;
							NetsukukuPublicKey* _tmp88_;
							gboolean _tmp89_ = FALSE;
							_tmp83_ = registrar_alias;
							_tmp84_ = netsukuku_andna_get_registrar_response_get_pubk (_tmp83_);
							_tmp85_ = _tmp84_;
							_tmp86_ = srvrec;
							_tmp87_ = netsukuku_andna_server_request_get_pubk (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = netsukuku_public_key_equal_func (_tmp85_, _tmp88_);
							if (_tmp89_) {
								GeeHashMap* _tmp90_;
								NetsukukuAndnaServiceKey* _tmp91_;
								gpointer _tmp92_ = NULL;
								GeeArrayList* _tmp93_;
								NetsukukuAndnaServerRequest* _tmp94_;
								NetsukukuAndnaServerRecord* _tmp95_ = NULL;
								NetsukukuAndnaServerRecord* _tmp96_;
								_tmp90_ = services;
								_tmp91_ = srvk;
								_tmp92_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp90_, _tmp91_);
								_tmp93_ = (GeeArrayList*) _tmp92_;
								_tmp94_ = srvrec;
								_tmp95_ = netsukuku_andna_make_server_record (self, _tmp94_);
								_tmp96_ = _tmp95_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp93_, _tmp96_);
								_g_object_unref0 (_tmp96_);
								_g_object_unref0 (_tmp93_);
							}
						}
						_g_object_unref0 (registrar_alias);
					} else {
						GeeHashMap* _tmp97_;
						NetsukukuAndnaServiceKey* _tmp98_;
						gpointer _tmp99_ = NULL;
						GeeArrayList* _tmp100_;
						NetsukukuAndnaServerRequest* _tmp101_;
						NetsukukuAndnaServerRecord* _tmp102_ = NULL;
						NetsukukuAndnaServerRecord* _tmp103_;
						_tmp97_ = services;
						_tmp98_ = srvk;
						_tmp99_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp97_, _tmp98_);
						_tmp100_ = (GeeArrayList*) _tmp99_;
						_tmp101_ = srvrec;
						_tmp102_ = netsukuku_andna_make_server_record (self, _tmp101_);
						_tmp103_ = _tmp102_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, _tmp103_);
						_g_object_unref0 (_tmp103_);
						_g_object_unref0 (_tmp100_);
					}
					_g_object_unref0 (srvrec);
				}
				_g_object_unref0 (_srvrec_list);
			}
			_tmp104_ = services;
			_tmp105_ = srvk;
			_tmp106_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp104_, _tmp105_);
			_tmp107_ = (GeeArrayList*) _tmp106_;
			_tmp108_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp107_);
			_tmp109_ = _tmp108_;
			_tmp110_ = _tmp109_ == 0;
			_g_object_unref0 (_tmp107_);
			if (_tmp110_) {
				GeeHashMap* _tmp111_;
				NetsukukuAndnaServiceKey* _tmp112_;
				_tmp111_ = services;
				_tmp112_ = srvk;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp111_, _tmp112_, NULL);
			}
			_g_object_unref0 (srvk);
		}
		_g_object_unref0 (_srvk_it);
	}
	_tmp113_ = self->priv->cache;
	_tmp114_ = _data1_->request;
	_tmp115_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp113_, _tmp116_);
	rec_in_cache = (NetsukukuAndnaDomainRecord*) _tmp117_;
	_tmp118_ = rec_in_cache;
	_tmp119_ = netsukuku_andna_domain_record_get_pubk (_tmp118_);
	_tmp120_ = _tmp119_;
	_tmp121_ = _data1_->request;
	_tmp122_ = netsukuku_andna_domain_request_get_pubk (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = netsukuku_public_key_equal_func (_tmp120_, _tmp123_);
	if (_tmp124_) {
		NetsukukuAndnaDomainRecord* _tmp125_;
		NetsukukuAndnaDomainRequest* _tmp126_;
		NetsukukuNIP* _tmp127_;
		NetsukukuNIP* _tmp128_;
		GeeHashMap* _tmp129_;
		const gchar* _tmp130_;
		NetsukukuAndnaDomainRecord* _tmp132_;
		gchar* _tmp133_ = NULL;
		gchar* _tmp134_;
		gchar* _tmp135_ = NULL;
		gchar* _tmp136_;
		NetsukukuTimeCapsule* _tmp137_;
		_tmp125_ = rec_in_cache;
		_tmp126_ = _data1_->request;
		_tmp127_ = netsukuku_andna_domain_request_get_nip (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = services;
		netsukuku_andna_domain_record_update (_tmp125_, NETSUKUKU_MAX_TTL_ANDNA, _tmp128_, _tmp129_);
		_tmp130_ = _data1_->response_msg;
		if (g_strcmp0 (_tmp130_, "REGISTERED") != 0) {
			gchar* _tmp131_;
			_tmp131_ = g_strdup ("UPDATED");
			_g_free0 (_data1_->response_msg);
			_data1_->response_msg = _tmp131_;
		}
		_tmp132_ = rec_in_cache;
		_tmp133_ = netsukuku_andna_domain_record_to_string (_tmp132_);
		_tmp134_ = _tmp133_;
		_tmp135_ = g_strconcat ("Andna: Registered: ", _tmp134_, NULL);
		_tmp136_ = _tmp135_;
		netsukuku_log_debug (_tmp136_);
		_g_free0 (_tmp136_);
		_g_free0 (_tmp134_);
		_tmp137_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_ANDNA);
		_g_object_unref0 (_data1_->response_ttl);
		_data1_->response_ttl = _tmp137_;
	} else {
		GeeHashMap* _tmp138_;
		NetsukukuAndnaDomainRequest* _tmp139_;
		const gchar* _tmp140_;
		const gchar* _tmp141_;
		gboolean _tmp142_ = FALSE;
		gboolean present;
		gboolean _tmp183_;
		_tmp138_ = self->priv->request_queue;
		_tmp139_ = _data1_->request;
		_tmp140_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp139_);
		_tmp141_ = _tmp140_;
		_tmp142_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp138_, _tmp141_);
		if (!_tmp142_) {
			GeeHashMap* _tmp143_;
			NetsukukuAndnaDomainRequest* _tmp144_;
			const gchar* _tmp145_;
			const gchar* _tmp146_;
			GeeArrayList* _tmp147_;
			GeeArrayList* _tmp148_;
			_tmp143_ = self->priv->request_queue;
			_tmp144_ = _data1_->request;
			_tmp145_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = gee_array_list_new (NETSUKUKU_TYPE_REGISTER_HOSTNAME_ARGUMENTS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func, NULL, NULL);
			_tmp148_ = _tmp147_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp143_, _tmp146_, _tmp148_);
			_g_object_unref0 (_tmp148_);
		}
		present = FALSE;
		{
			GeeHashMap* _tmp149_;
			NetsukukuAndnaDomainRequest* _tmp150_;
			const gchar* _tmp151_;
			const gchar* _tmp152_;
			gpointer _tmp153_ = NULL;
			GeeArrayList* _args_list;
			GeeArrayList* _tmp154_;
			gint _tmp155_;
			gint _tmp156_;
			gint _args_size;
			gint _args_index;
			_tmp149_ = self->priv->request_queue;
			_tmp150_ = _data1_->request;
			_tmp151_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp150_);
			_tmp152_ = _tmp151_;
			_tmp153_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp149_, _tmp152_);
			_args_list = (GeeArrayList*) _tmp153_;
			_tmp154_ = _args_list;
			_tmp155_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp154_);
			_tmp156_ = _tmp155_;
			_args_size = _tmp156_;
			_args_index = -1;
			while (TRUE) {
				gint _tmp157_;
				gint _tmp158_;
				gint _tmp159_;
				GeeArrayList* _tmp160_;
				gint _tmp161_;
				gpointer _tmp162_ = NULL;
				NetsukukuRegisterHostnameArguments* args;
				NetsukukuRegisterHostnameArguments* _tmp163_;
				NetsukukuAndnaDomainRequest* _tmp164_;
				NetsukukuPublicKey* _tmp165_;
				NetsukukuPublicKey* _tmp166_;
				NetsukukuAndnaDomainRequest* _tmp167_;
				NetsukukuPublicKey* _tmp168_;
				NetsukukuPublicKey* _tmp169_;
				gboolean _tmp170_ = FALSE;
				_tmp157_ = _args_index;
				_args_index = _tmp157_ + 1;
				_tmp158_ = _args_index;
				_tmp159_ = _args_size;
				if (!(_tmp158_ < _tmp159_)) {
					break;
				}
				_tmp160_ = _args_list;
				_tmp161_ = _args_index;
				_tmp162_ = gee_abstract_list_get ((GeeAbstractList*) _tmp160_, _tmp161_);
				args = (NetsukukuRegisterHostnameArguments*) _tmp162_;
				_tmp163_ = args;
				_tmp164_ = _tmp163_->request;
				_tmp165_ = netsukuku_andna_domain_request_get_pubk (_tmp164_);
				_tmp166_ = _tmp165_;
				_tmp167_ = _data1_->request;
				_tmp168_ = netsukuku_andna_domain_request_get_pubk (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = netsukuku_public_key_equal_func (_tmp166_, _tmp169_);
				if (_tmp170_) {
					NetsukukuRegisterHostnameArguments* _tmp171_;
					NetsukukuAndnaDomainRequest* _tmp172_;
					NetsukukuAndnaDomainRequest* _tmp173_;
					NetsukukuRegisterHostnameArguments* _tmp174_;
					zcdSerializableBuffer* _tmp175_;
					zcdSerializableBuffer* _tmp176_;
					NetsukukuRegisterHostnameArguments* _tmp177_;
					NetsukukuTimeCapsule* _tmp178_;
					gchar* _tmp179_;
					NetsukukuRegisterHostnameArguments* _tmp180_;
					NetsukukuTimeCapsule* _tmp181_;
					NetsukukuTimeCapsule* _tmp182_;
					present = TRUE;
					_tmp171_ = args;
					_tmp172_ = _data1_->request;
					_tmp173_ = _g_object_ref0 (_tmp172_);
					_g_object_unref0 (_tmp171_->request);
					_tmp171_->request = _tmp173_;
					_tmp174_ = args;
					_tmp175_ = _data1_->signature;
					_tmp176_ = _g_object_ref0 (_tmp175_);
					_g_object_unref0 (_tmp174_->signature);
					_tmp174_->signature = _tmp176_;
					_tmp177_ = args;
					_tmp178_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_ANDNA);
					_g_object_unref0 (_tmp177_->expires);
					_tmp177_->expires = _tmp178_;
					_tmp179_ = g_strdup ("QUEUED");
					_g_free0 (_data1_->response_msg);
					_data1_->response_msg = _tmp179_;
					_tmp180_ = args;
					_tmp181_ = _tmp180_->expires;
					_tmp182_ = _g_object_ref0 (_tmp181_);
					_g_object_unref0 (_data1_->response_ttl);
					_data1_->response_ttl = _tmp182_;
				}
				_g_object_unref0 (args);
			}
			_g_object_unref0 (_args_list);
		}
		_tmp183_ = present;
		if (!_tmp183_) {
			GeeHashMap* _tmp184_;
			NetsukukuAndnaDomainRequest* _tmp185_;
			const gchar* _tmp186_;
			const gchar* _tmp187_;
			gpointer _tmp188_ = NULL;
			GeeArrayList* _tmp189_;
			gint _tmp190_;
			gint _tmp191_;
			gboolean _tmp192_;
			_tmp184_ = self->priv->request_queue;
			_tmp185_ = _data1_->request;
			_tmp186_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp185_);
			_tmp187_ = _tmp186_;
			_tmp188_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp184_, _tmp187_);
			_tmp189_ = (GeeArrayList*) _tmp188_;
			_tmp190_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp189_);
			_tmp191_ = _tmp190_;
			_tmp192_ = _tmp191_ < NETSUKUKU_MAX_QUEUE_ANDNA;
			_g_object_unref0 (_tmp189_);
			if (_tmp192_) {
				GeeHashMap* _tmp193_;
				NetsukukuAndnaDomainRequest* _tmp194_;
				const gchar* _tmp195_;
				const gchar* _tmp196_;
				gpointer _tmp197_ = NULL;
				GeeArrayList* _tmp198_;
				NetsukukuAndnaDomainRequest* _tmp199_;
				zcdSerializableBuffer* _tmp200_;
				NetsukukuTimeCapsule* _tmp201_;
				NetsukukuTimeCapsule* _tmp202_;
				NetsukukuRegisterHostnameArguments* _tmp203_;
				NetsukukuRegisterHostnameArguments* _tmp204_;
				_tmp193_ = self->priv->request_queue;
				_tmp194_ = _data1_->request;
				_tmp195_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp193_, _tmp196_);
				_tmp198_ = (GeeArrayList*) _tmp197_;
				_tmp199_ = _data1_->request;
				_tmp200_ = _data1_->signature;
				_tmp201_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_ANDNA);
				_tmp202_ = _tmp201_;
				_tmp203_ = netsukuku_register_hostname_arguments_new (_tmp199_, _tmp200_, _tmp202_);
				_tmp204_ = _tmp203_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp198_, _tmp204_);
				_g_object_unref0 (_tmp204_);
				_g_object_unref0 (_tmp202_);
				_g_object_unref0 (_tmp198_);
			} else {
				gchar* _tmp205_;
				NetsukukuTimeCapsule* _tmp206_;
				_tmp205_ = g_strdup ("QUEUE_FULL");
				_g_free0 (_data1_->response_msg);
				_data1_->response_msg = _tmp205_;
				_tmp206_ = netsukuku_time_capsule_new ((gint64) 0);
				_g_object_unref0 (_data1_->response_ttl);
				_data1_->response_ttl = _tmp206_;
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (rec_in_cache);
	_g_object_unref0 (services);
	_g_object_unref0 (checkhostname);
	return result;
}


static gboolean ___lambda6__netsukuku_accept_record_callback (gpointer self, GError** error) {
	gboolean result;
	result = __lambda6_ (self, error);
	return result;
}


static void _____lambda8_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tonip;
	GObject* _tmp2_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp3_;
	NetsukukuArgumentsForDuplicationRegisterMain* arec;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tonip = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMain));
	arec = _tmp3_;
	tasklets_tasklet_declare_self ("Andna.forward_record_main");
	{
		NetsukukuRmtAndnaPeer* _tmp4_ = NULL;
		NetsukukuRmtAndnaPeer* _tmp5_;
		NetsukukuAndnaDomainRequest* _tmp6_;
		zcdSerializableBuffer* _tmp7_;
		NetsukukuAndnaRegisterMainResponse* _tmp8_ = NULL;
		NetsukukuAndnaRegisterMainResponse* _tmp9_;
		_tmp4_ = netsukuku_andna_peer (self, tonip, NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = arec->request;
		_tmp7_ = arec->signature;
		_tmp8_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) _tmp5_, _tmp6_, _tmp7_, FALSE, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch15_zcd_rpc_error;
			}
			goto __finally15;
		}
	}
	goto __finally15;
	__catch15_zcd_rpc_error:
	{
		GError* e = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GError* _tmp14_;
		GQuark _tmp15_;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) tonip);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat ("Andna.forward_record_main: forwarding to ", _tmp11_, ":", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->domain;
		_tmp16_ = g_quark_to_string (_tmp15_);
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = e;
		_tmp19_ = _tmp18_->code;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = g_strconcat (" got ", _tmp17_, " ", _tmp21_, " ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp13_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		netsukuku_log_warn (_tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (arec);
		_g_object_unref0 (tonip);
		return;
	}
	_g_object_unref0 (arec);
	_g_object_unref0 (tonip);
}


static void ______lambda8__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_____lambda8_ (self, obj1, obj2, error);
}


static void __lambda7_ (NetsukukuAndna* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error) {
	GObject* _tmp0_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp1_;
	NetsukukuArgumentsForDuplicationRegisterMain* tasklet_rec;
	GeeList* _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = tasklet_obj1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMain));
	tasklet_rec = _tmp1_;
	_tmp2_ = tasklet_replica_nodes;
	if (_tmp2_ == NULL) {
		NetsukukuArgumentsForDuplicationRegisterMain* _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		_tmp3_ = tasklet_rec;
		_tmp4_ = _tmp3_->hashnode;
		_tmp5_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) self, _tmp4_, NETSUKUKU_ANDNA_DUPLICATION, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (tasklet_rec);
				_g_object_unref0 (tasklet_replica_nodes);
				return;
			} else {
				_g_object_unref0 (tasklet_rec);
				_g_object_unref0 (tasklet_replica_nodes);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (tasklet_replica_nodes);
		tasklet_replica_nodes = _tmp6_;
	}
	{
		GeeList* _tmp7_;
		GeeList* _tmp8_;
		GeeList* _replica_node_list;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _replica_node_size;
		gint _replica_node_index;
		_tmp7_ = tasklet_replica_nodes;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_replica_node_list = _tmp8_;
		_tmp9_ = _replica_node_list;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_replica_node_size = _tmp11_;
		_replica_node_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			NetsukukuNIP* replica_node;
			NetsukukuNIP* _tmp18_;
			NetsukukuMapRoute* _tmp19_;
			NetsukukuNIP* _tmp20_;
			NetsukukuNIP* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp12_ = _replica_node_index;
			_replica_node_index = _tmp12_ + 1;
			_tmp13_ = _replica_node_index;
			_tmp14_ = _replica_node_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _replica_node_list;
			_tmp16_ = _replica_node_index;
			_tmp17_ = gee_list_get (_tmp15_, _tmp16_);
			replica_node = (NetsukukuNIP*) _tmp17_;
			_tmp18_ = replica_node;
			_tmp19_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp20_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp18_, (NetsukukuPartialNIP*) _tmp21_);
			if (!_tmp22_) {
				NetsukukuNIP* _tmp23_;
				NetsukukuArgumentsForDuplicationRegisterMain* _tmp24_;
				TaskletsTasklet* _tmp25_ = NULL;
				TaskletsTasklet* _tmp26_;
				_tmp23_ = replica_node;
				_tmp24_ = tasklet_rec;
				_tmp25_ = tasklets_tasklet_tasklet_callback (______lambda8__tasklets_tasklet_callback, self, (GObject*) _tmp23_, (GObject*) _tmp24_, NULL, NULL);
				_tmp26_ = _tmp25_;
				_g_object_unref0 (_tmp26_);
			}
			_g_object_unref0 (replica_node);
		}
		_g_object_unref0 (_replica_node_list);
	}
	_g_object_unref0 (tasklet_rec);
	_g_object_unref0 (tasklet_replica_nodes);
}


static void ___lambda7__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error) {
	__lambda7_ (self, obj1, replica_nodes, error);
}


static NetsukukuAndnaRegisterMainResponse* netsukuku_andna_real_register_main_for_pubk (NetsukukuIAndnaAsPeer* base, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaRegisterMainResponse* result = NULL;
	Block1Data* _data1_;
	NetsukukuAndnaDomainRequest* _tmp0_;
	NetsukukuAndnaDomainRequest* _tmp1_;
	zcdSerializableBuffer* _tmp2_;
	zcdSerializableBuffer* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp12_;
	NetsukukuTimeCapsule* _tmp13_;
	NetsukukuAndnaDomainRequest* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	NetsukukuAndnaServiceHashnodeKey* _tmp17_;
	NetsukukuAndnaServiceHashnodeKey* _tmp18_;
	NetsukukuNIP* _tmp19_ = NULL;
	NetsukukuNIP* _tmp20_;
	NetsukukuNIP* hashnode;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp21_;
	NetsukukuArgumentsForDuplicationRegisterMain* rec;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp22_;
	NetsukukuAndnaDomainRequest* _tmp23_;
	NetsukukuAndnaDomainRequest* _tmp24_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp25_;
	zcdSerializableBuffer* _tmp26_;
	zcdSerializableBuffer* _tmp27_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp28_;
	NetsukukuNIP* _tmp29_;
	NetsukukuNIP* _tmp30_;
	NetsukukuNIP* _tmp31_;
	gboolean _tmp32_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp33_;
	const gchar* _tmp34_;
	NetsukukuTimeCapsule* _tmp35_;
	NetsukukuAndnaRegisterMainResponse* _tmp36_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = request;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->request);
	_data1_->request = _tmp1_;
	_tmp2_ = signature;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data1_->signature);
	_data1_->signature = _tmp3_;
	_tmp4_ = self->priv->hooked_to_service;
	if (!_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = replicate;
		if (_tmp5_) {
			TaskletsTimer* _tmp6_;
			TaskletsTimer* w;
			_tmp6_ = tasklets_timer_new ((gint64) 10000);
			w = _tmp6_;
			while (TRUE) {
				gboolean _tmp7_;
				TaskletsTimer* _tmp8_;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = self->priv->hooked_to_service;
				if (!(!_tmp7_)) {
					break;
				}
				_tmp8_ = w;
				_tmp9_ = tasklets_timer_is_expired (_tmp8_);
				if (_tmp9_) {
					GError* _tmp10_;
					_tmp10_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
					_inner_error_ = _tmp10_;
					if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (w);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						return NULL;
					} else {
						_g_object_unref0 (w);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
			_g_object_unref0 (w);
		} else {
			while (TRUE) {
				gboolean _tmp11_;
				_tmp11_ = self->priv->hooked_to_service;
				if (!(!_tmp11_)) {
					break;
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
		}
	}
	_tmp12_ = g_strdup ("Noooo");
	_data1_->response_msg = _tmp12_;
	_tmp13_ = netsukuku_time_capsule_new ((gint64) 0);
	_data1_->response_ttl = _tmp13_;
	netsukuku_andna_check_expirations_cache (self);
	_tmp14_ = _data1_->request;
	_tmp15_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_andna_service_hashnode_key_new (_tmp16_, 0);
	_tmp18_ = _tmp17_;
	_tmp19_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp18_);
	hashnode = _tmp20_;
	_tmp21_ = netsukuku_arguments_for_duplication_register_main_new ();
	rec = _tmp21_;
	_tmp22_ = rec;
	_tmp23_ = _data1_->request;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_g_object_unref0 (_tmp22_->request);
	_tmp22_->request = _tmp24_;
	_tmp25_ = rec;
	_tmp26_ = _data1_->signature;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (_tmp25_->signature);
	_tmp25_->signature = _tmp27_;
	_tmp28_ = rec;
	_tmp29_ = hashnode;
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_g_object_unref0 (_tmp28_->hashnode);
	_tmp28_->hashnode = _tmp30_;
	_tmp31_ = hashnode;
	_tmp32_ = replicate;
	_tmp33_ = rec;
	netsukuku_check_hash_and_start_replica ((NetsukukuPeerToPeer*) self, _tmp31_, _tmp32_, (GObject*) _tmp33_, NETSUKUKU_ANDNA_DUPLICATION, ___lambda6__netsukuku_accept_record_callback, _data1_, ___lambda7__netsukuku_forward_record_callback, self, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return NULL;
		} else {
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp34_ = _data1_->response_msg;
	_tmp35_ = _data1_->response_ttl;
	_tmp36_ = netsukuku_andna_register_main_response_new (_tmp34_, _tmp35_);
	result = _tmp36_;
	_g_object_unref0 (rec);
	_g_object_unref0 (hashnode);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static NetsukukuAndnaGetRegistrarResponse* netsukuku_andna_real_get_registrar (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaGetRegistrarResponse* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	NetsukukuAndnaServiceHashnodeKey* _tmp7_;
	NetsukukuAndnaServiceHashnodeKey* _tmp8_;
	NetsukukuNIP* _tmp9_ = NULL;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp11_;
	NetsukukuHCoord* _tmp12_ = NULL;
	NetsukukuHCoord* _tmp13_;
	NetsukukuHCoord* _tmp14_;
	gboolean _tmp15_;
	GeeHashMap* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = self->priv->hooked_to_service;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->hooked_to_service;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_andna_check_expirations_cache (self);
	_tmp6_ = hashed_domain;
	_tmp7_ = netsukuku_andna_service_hashnode_key_new (_tmp6_, 0);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	hashnode = _tmp10_;
	_tmp11_ = hashnode;
	_tmp12_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp11_, 1, &_inner_error_);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_ != NULL;
	_g_object_unref0 (_tmp14_);
	if (_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = self->priv->cache;
	_tmp18_ = hashed_domain;
	_tmp19_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp18_);
	if (_tmp19_) {
		GeeHashMap* _tmp20_;
		const gchar* _tmp21_;
		gpointer _tmp22_ = NULL;
		NetsukukuAndnaDomainRecord* ret;
		NetsukukuAndnaDomainRecord* _tmp23_;
		NetsukukuPublicKey* _tmp24_;
		NetsukukuPublicKey* _tmp25_;
		NetsukukuAndnaDomainRecord* _tmp26_;
		NetsukukuNIP* _tmp27_;
		NetsukukuNIP* _tmp28_;
		NetsukukuAndnaDomainRecord* _tmp29_;
		NetsukukuTimeCapsule* _tmp30_;
		NetsukukuTimeCapsule* _tmp31_;
		NetsukukuAndnaGetRegistrarResponse* _tmp32_;
		_tmp20_ = self->priv->cache;
		_tmp21_ = hashed_domain;
		_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, _tmp21_);
		ret = (NetsukukuAndnaDomainRecord*) _tmp22_;
		_tmp23_ = ret;
		_tmp24_ = netsukuku_andna_domain_record_get_pubk (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = ret;
		_tmp27_ = netsukuku_andna_domain_record_get_nip (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = ret;
		_tmp30_ = netsukuku_andna_domain_record_get_expires (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = netsukuku_andna_get_registrar_response_new (_tmp25_, _tmp28_, _tmp31_);
		result = _tmp32_;
		_g_object_unref0 (ret);
		_g_object_unref0 (hashnode);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (hashnode);
		return result;
	}
	_g_object_unref0 (hashnode);
}


static NetsukukuAndnaDomainRecord* netsukuku_andna_real_get_domain_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaDomainRecord* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	NetsukukuAndnaServiceHashnodeKey* _tmp7_;
	NetsukukuAndnaServiceHashnodeKey* _tmp8_;
	NetsukukuNIP* _tmp9_ = NULL;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp11_;
	NetsukukuHCoord* _tmp12_ = NULL;
	NetsukukuHCoord* _tmp13_;
	NetsukukuHCoord* _tmp14_;
	gboolean _tmp15_;
	GeeHashMap* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GeeHashMap* _tmp20_;
	const gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = self->priv->hooked_to_service;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->hooked_to_service;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_andna_check_expirations_cache (self);
	_tmp6_ = hashed_domain;
	_tmp7_ = netsukuku_andna_service_hashnode_key_new (_tmp6_, 0);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	hashnode = _tmp10_;
	_tmp11_ = hashnode;
	_tmp12_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp11_, 1, &_inner_error_);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_ != NULL;
	_g_object_unref0 (_tmp14_);
	if (_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = self->priv->cache;
	_tmp18_ = hashed_domain;
	_tmp19_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp18_);
	if (!_tmp19_) {
		result = NULL;
		_g_object_unref0 (hashnode);
		return result;
	}
	_tmp20_ = self->priv->cache;
	_tmp21_ = hashed_domain;
	_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, _tmp21_);
	result = (NetsukukuAndnaDomainRecord*) _tmp22_;
	_g_object_unref0 (hashnode);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		NetsukukuAndna * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->rec);
		_g_free0 (_data2_->response_msg);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean __lambda9_ (Block2Data* _data2_, GError** error) {
	NetsukukuAndna * self;
	gboolean result = FALSE;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp0_;
	const gchar* _tmp1_;
	NetsukukuAndnaServiceHashnodeKey* _tmp2_;
	NetsukukuAndnaServiceHashnodeKey* _tmp3_;
	NetsukukuRmtAndnaPeer* _tmp4_ = NULL;
	NetsukukuRmtAndnaPeer* _tmp5_;
	NetsukukuRmtAndnaPeer* an_main;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp6_;
	const gchar* _tmp7_;
	NetsukukuAndnaDomainRecord* _tmp8_ = NULL;
	NetsukukuAndnaDomainRecord* main_rec;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->rec;
	_tmp1_ = _tmp0_->hashed_domain;
	_tmp2_ = netsukuku_andna_service_hashnode_key_new (_tmp1_, 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	an_main = _tmp5_;
	_tmp6_ = _data2_->rec;
	_tmp7_ = _tmp6_->hashed_domain;
	_tmp8_ = netsukuku_iandna_as_peer_get_domain_record ((NetsukukuIAndnaAsPeer*) an_main, _tmp7_, &_inner_error_);
	main_rec = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (an_main);
			return FALSE;
		} else {
			_g_object_unref0 (an_main);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (main_rec != NULL) {
		GeeHashMap* _tmp9_;
		NetsukukuArgumentsForDuplicationRegisterSpread* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = self->priv->cache;
		_tmp10_ = _data2_->rec;
		_tmp11_ = _tmp10_->hashed_domain;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp11_, main_rec);
	} else {
		gchar* _tmp12_;
		_data2_->response_response = FALSE;
		_tmp12_ = g_strdup ("MAIN_NOT_FOUND");
		_g_free0 (_data2_->response_msg);
		_data2_->response_msg = _tmp12_;
		result = FALSE;
		_g_object_unref0 (main_rec);
		_g_object_unref0 (an_main);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (main_rec);
	_g_object_unref0 (an_main);
	return result;
}


static gboolean ___lambda9__netsukuku_accept_record_callback (gpointer self, GError** error) {
	gboolean result;
	result = __lambda9_ (self, error);
	return result;
}


static void _____lambda11_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tonip;
	GObject* _tmp2_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp3_;
	NetsukukuArgumentsForDuplicationRegisterSpread* arec;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tonip = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpread));
	arec = _tmp3_;
	tasklets_tasklet_declare_self ("Andna.forward_record_spread");
	{
		NetsukukuRmtAndnaPeer* _tmp4_ = NULL;
		NetsukukuRmtAndnaPeer* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		NetsukukuAndnaRegisterSpreadResponse* _tmp8_ = NULL;
		NetsukukuAndnaRegisterSpreadResponse* _tmp9_;
		_tmp4_ = netsukuku_andna_peer (self, tonip, NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = arec->hashed_domain;
		_tmp7_ = arec->spread_number;
		_tmp8_ = netsukuku_iandna_as_peer_register_spread_record ((NetsukukuIAndnaAsPeer*) _tmp5_, _tmp6_, _tmp7_, FALSE, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch16_zcd_rpc_error;
			}
			goto __finally16;
		}
	}
	goto __finally16;
	__catch16_zcd_rpc_error:
	{
		GError* e = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GError* _tmp14_;
		GQuark _tmp15_;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) tonip);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat ("Andna.forward_record_spread: forwarding to ", _tmp11_, ":", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->domain;
		_tmp16_ = g_quark_to_string (_tmp15_);
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = e;
		_tmp19_ = _tmp18_->code;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = g_strconcat (" got ", _tmp17_, " ", _tmp21_, " ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp13_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		netsukuku_log_warn (_tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (arec);
		_g_object_unref0 (tonip);
		return;
	}
	_g_object_unref0 (arec);
	_g_object_unref0 (tonip);
}


static void ______lambda11__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_____lambda11_ (self, obj1, obj2, error);
}


static void __lambda10_ (NetsukukuAndna* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error) {
	GObject* _tmp0_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp1_;
	NetsukukuArgumentsForDuplicationRegisterSpread* tasklet_rec;
	GeeList* _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = tasklet_obj1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpread));
	tasklet_rec = _tmp1_;
	_tmp2_ = tasklet_replica_nodes;
	if (_tmp2_ == NULL) {
		NetsukukuArgumentsForDuplicationRegisterSpread* _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		_tmp3_ = tasklet_rec;
		_tmp4_ = _tmp3_->hashnode;
		_tmp5_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) self, _tmp4_, NETSUKUKU_ANDNA_DUPLICATION, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (tasklet_rec);
				_g_object_unref0 (tasklet_replica_nodes);
				return;
			} else {
				_g_object_unref0 (tasklet_rec);
				_g_object_unref0 (tasklet_replica_nodes);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (tasklet_replica_nodes);
		tasklet_replica_nodes = _tmp6_;
	}
	{
		GeeList* _tmp7_;
		GeeList* _tmp8_;
		GeeList* _replica_node_list;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _replica_node_size;
		gint _replica_node_index;
		_tmp7_ = tasklet_replica_nodes;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_replica_node_list = _tmp8_;
		_tmp9_ = _replica_node_list;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_replica_node_size = _tmp11_;
		_replica_node_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			NetsukukuNIP* replica_node;
			NetsukukuNIP* _tmp18_;
			NetsukukuMapRoute* _tmp19_;
			NetsukukuNIP* _tmp20_;
			NetsukukuNIP* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp12_ = _replica_node_index;
			_replica_node_index = _tmp12_ + 1;
			_tmp13_ = _replica_node_index;
			_tmp14_ = _replica_node_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _replica_node_list;
			_tmp16_ = _replica_node_index;
			_tmp17_ = gee_list_get (_tmp15_, _tmp16_);
			replica_node = (NetsukukuNIP*) _tmp17_;
			_tmp18_ = replica_node;
			_tmp19_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp20_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp18_, (NetsukukuPartialNIP*) _tmp21_);
			if (!_tmp22_) {
				NetsukukuNIP* _tmp23_;
				NetsukukuArgumentsForDuplicationRegisterSpread* _tmp24_;
				TaskletsTasklet* _tmp25_ = NULL;
				TaskletsTasklet* _tmp26_;
				_tmp23_ = replica_node;
				_tmp24_ = tasklet_rec;
				_tmp25_ = tasklets_tasklet_tasklet_callback (______lambda11__tasklets_tasklet_callback, self, (GObject*) _tmp23_, (GObject*) _tmp24_, NULL, NULL);
				_tmp26_ = _tmp25_;
				_g_object_unref0 (_tmp26_);
			}
			_g_object_unref0 (replica_node);
		}
		_g_object_unref0 (_replica_node_list);
	}
	_g_object_unref0 (tasklet_rec);
	_g_object_unref0 (tasklet_replica_nodes);
}


static void ___lambda10__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error) {
	__lambda10_ (self, obj1, replica_nodes, error);
}


static NetsukukuAndnaRegisterSpreadResponse* netsukuku_andna_real_register_spread_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaRegisterSpreadResponse* result = NULL;
	Block2Data* _data2_;
	gboolean _tmp0_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	NetsukukuAndnaServiceHashnodeKey* _tmp9_;
	NetsukukuAndnaServiceHashnodeKey* _tmp10_;
	NetsukukuNIP* _tmp11_ = NULL;
	NetsukukuNIP* _tmp12_;
	NetsukukuNIP* hashnode;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp13_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp17_;
	gint _tmp18_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp19_;
	NetsukukuNIP* _tmp20_;
	NetsukukuNIP* _tmp21_;
	NetsukukuNIP* _tmp22_;
	gboolean _tmp23_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp26_;
	NetsukukuAndnaRegisterSpreadResponse* _tmp27_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->hooked_to_service;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->hooked_to_service;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return NULL;
				} else {
					_g_object_unref0 (w);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	_data2_->response_response = TRUE;
	_tmp6_ = g_strdup ("OK");
	_data2_->response_msg = _tmp6_;
	netsukuku_andna_check_expirations_cache (self);
	_tmp7_ = hashed_domain;
	_tmp8_ = spread_number;
	_tmp9_ = netsukuku_andna_service_hashnode_key_new (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	hashnode = _tmp12_;
	_tmp13_ = netsukuku_arguments_for_duplication_register_spread_new ();
	_data2_->rec = _tmp13_;
	_tmp14_ = _data2_->rec;
	_tmp15_ = hashed_domain;
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (_tmp14_->hashed_domain);
	_tmp14_->hashed_domain = _tmp16_;
	_tmp17_ = _data2_->rec;
	_tmp18_ = spread_number;
	_tmp17_->spread_number = _tmp18_;
	_tmp19_ = _data2_->rec;
	_tmp20_ = hashnode;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (_tmp19_->hashnode);
	_tmp19_->hashnode = _tmp21_;
	_tmp22_ = hashnode;
	_tmp23_ = replicate;
	_tmp24_ = _data2_->rec;
	netsukuku_check_hash_and_start_replica ((NetsukukuPeerToPeer*) self, _tmp22_, _tmp23_, (GObject*) _tmp24_, NETSUKUKU_ANDNA_DUPLICATION, ___lambda9__netsukuku_accept_record_callback, _data2_, ___lambda10__netsukuku_forward_record_callback, self, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp25_ = _data2_->response_response;
	_tmp26_ = _data2_->response_msg;
	_tmp27_ = netsukuku_andna_register_spread_response_new (_tmp25_, _tmp26_);
	result = _tmp27_;
	_g_object_unref0 (hashnode);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static NetsukukuAndnaGetServersResponse* netsukuku_andna_real_get_servers (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaGetServersResponse* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	gint _tmp7_;
	NetsukukuAndnaServiceHashnodeKey* _tmp8_;
	NetsukukuAndnaServiceHashnodeKey* _tmp9_;
	NetsukukuNIP* _tmp10_ = NULL;
	NetsukukuNIP* _tmp11_;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp12_;
	NetsukukuHCoord* _tmp13_ = NULL;
	NetsukukuHCoord* _tmp14_;
	NetsukukuHCoord* _tmp15_;
	gboolean _tmp16_;
	NetsukukuTimeCapsule* expires = NULL;
	NetsukukuAndnaServers* response = NULL;
	GeeHashMap* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	NetsukukuAndnaServers* _tmp94_;
	NetsukukuTimeCapsule* _tmp95_;
	NetsukukuAndnaGetServersResponse* _tmp96_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (srv_key != NULL, NULL);
	_tmp0_ = self->priv->hooked_to_service;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->hooked_to_service;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_andna_check_expirations_cache (self);
	_tmp6_ = hashed_domain;
	_tmp7_ = spread_number;
	_tmp8_ = netsukuku_andna_service_hashnode_key_new (_tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	hashnode = _tmp11_;
	_tmp12_ = hashnode;
	_tmp13_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp12_, 1, &_inner_error_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_ != NULL;
	_g_object_unref0 (_tmp15_);
	if (_tmp16_) {
		GError* _tmp17_;
		_tmp17_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp17_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp18_ = self->priv->cache;
	_tmp19_ = hashed_domain;
	_tmp20_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp18_, _tmp19_);
	if (_tmp20_) {
		GeeHashMap* _tmp21_;
		const gchar* _tmp22_;
		gpointer _tmp23_ = NULL;
		NetsukukuAndnaDomainRecord* _tmp24_;
		NetsukukuAndnaServiceKey* _tmp25_;
		NetsukukuAndnaServers* _tmp26_ = NULL;
		NetsukukuAndnaServers* _tmp27_;
		NetsukukuTimeCapsule* _tmp28_;
		NetsukukuTimeCapsule* _tmp29_;
		NetsukukuTimeCapsule* _tmp30_;
		GeeArrayList* _tmp31_;
		GeeArrayList* todel;
		_tmp21_ = self->priv->cache;
		_tmp22_ = hashed_domain;
		_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, _tmp22_);
		_tmp24_ = (NetsukukuAndnaDomainRecord*) _tmp23_;
		_tmp25_ = srv_key;
		_tmp26_ = netsukuku_andna_domain_record_get_servers (_tmp24_, _tmp25_);
		_g_object_unref0 (response);
		response = _tmp26_;
		_g_object_unref0 (_tmp24_);
		_tmp27_ = response;
		_tmp28_ = netsukuku_andna_servers_get_expires (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _g_object_ref0 (_tmp29_);
		_g_object_unref0 (expires);
		expires = _tmp30_;
		_tmp31_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		todel = _tmp31_;
		{
			NetsukukuAndnaServers* _tmp32_;
			GeeList* _tmp33_;
			GeeList* _tmp34_;
			GeeList* _tmp35_;
			GeeList* _result_list;
			GeeList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _result_size;
			gint _result_index;
			_tmp32_ = response;
			_tmp33_ = netsukuku_andna_servers_get_servers (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _g_object_ref0 (_tmp34_);
			_result_list = _tmp35_;
			_tmp36_ = _result_list;
			_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_result_size = _tmp38_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				GeeList* _tmp42_;
				gint _tmp43_;
				gpointer _tmp44_ = NULL;
				NetsukukuAndnaServer* _result_;
				NetsukukuAndnaServer* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp39_ = _result_index;
				_result_index = _tmp39_ + 1;
				_tmp40_ = _result_index;
				_tmp41_ = _result_size;
				if (!(_tmp40_ < _tmp41_)) {
					break;
				}
				_tmp42_ = _result_list;
				_tmp43_ = _result_index;
				_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
				_result_ = (NetsukukuAndnaServer*) _tmp44_;
				_tmp45_ = _result_;
				_tmp46_ = netsukuku_andna_server_get_alias_name (_tmp45_);
				_tmp47_ = _tmp46_;
				if (_tmp47_ != NULL) {
					gboolean _tmp48_;
					_tmp48_ = chain;
					if (!_tmp48_) {
						GeeArrayList* _tmp49_;
						NetsukukuAndnaServer* _tmp50_;
						_tmp49_ = todel;
						_tmp50_ = _result_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
					} else {
						NetsukukuAndnaServiceKey* _tmp51_;
						NetsukukuAndnaServiceKey* _tmp52_;
						NetsukukuAndnaServiceKey* _tmp53_;
						gboolean _tmp54_ = FALSE;
						_tmp51_ = srv_key;
						_tmp52_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
						_tmp53_ = _tmp52_;
						_tmp54_ = netsukuku_andna_service_key_equal_func (_tmp51_, _tmp53_);
						if (_tmp54_) {
							const gchar* _tmp55_;
							NetsukukuAndnaServiceKey* _tmp56_;
							NetsukukuAndnaServiceKey* _tmp57_;
							NetsukukuAndnaGetServersResponse* _tmp58_ = NULL;
							NetsukukuAndnaGetServersResponse* resolved_alias;
							NetsukukuAndnaGetServersResponse* _tmp59_;
							NetsukukuAndnaServers* _tmp60_;
							NetsukukuAndnaServers* _tmp61_;
							NetsukukuAndnaServers* _tmp62_;
							NetsukukuAndnaServers* alias_servers;
							NetsukukuAndnaServers* _tmp63_;
							gboolean _tmp64_;
							gboolean _tmp65_;
							_tmp55_ = hashed_domain;
							_tmp56_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
							_tmp57_ = _tmp56_;
							_tmp58_ = netsukuku_andna_ask_get_servers (self, _tmp55_, _tmp57_, FALSE);
							resolved_alias = _tmp58_;
							_tmp59_ = resolved_alias;
							_tmp60_ = netsukuku_andna_get_servers_response_get_response (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = _g_object_ref0 (_tmp61_);
							alias_servers = _tmp62_;
							_tmp63_ = alias_servers;
							_tmp64_ = netsukuku_andna_servers_get_is_not_found (_tmp63_);
							_tmp65_ = _tmp64_;
							if (_tmp65_) {
								GeeArrayList* _tmp66_;
								NetsukukuAndnaServer* _tmp67_;
								_tmp66_ = todel;
								_tmp67_ = _result_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, _tmp67_);
							} else {
								NetsukukuAndnaServer* _tmp68_;
								NetsukukuAndnaServers* _tmp69_;
								GeeList* _tmp70_;
								GeeList* _tmp71_;
								gpointer _tmp72_ = NULL;
								NetsukukuAndnaServer* _tmp73_;
								NetsukukuNIP* _tmp74_;
								NetsukukuNIP* _tmp75_;
								_tmp68_ = _result_;
								_tmp69_ = alias_servers;
								_tmp70_ = netsukuku_andna_servers_get_servers (_tmp69_);
								_tmp71_ = _tmp70_;
								_tmp72_ = gee_list_get (_tmp71_, 0);
								_tmp73_ = (NetsukukuAndnaServer*) _tmp72_;
								_tmp74_ = netsukuku_andna_server_get_registrar_nip (_tmp73_);
								_tmp75_ = _tmp74_;
								netsukuku_andna_server_set_nip (_tmp68_, _tmp75_);
								_g_object_unref0 (_tmp73_);
							}
							_g_object_unref0 (alias_servers);
							_g_object_unref0 (resolved_alias);
						} else {
						}
					}
				}
				_g_object_unref0 (_result_);
			}
			_g_object_unref0 (_result_list);
		}
		{
			GeeArrayList* _tmp76_;
			GeeArrayList* _tmp77_;
			GeeArrayList* _result_list;
			GeeArrayList* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			gint _result_size;
			gint _result_index;
			_tmp76_ = todel;
			_tmp77_ = _g_object_ref0 (_tmp76_);
			_result_list = _tmp77_;
			_tmp78_ = _result_list;
			_tmp79_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp78_);
			_tmp80_ = _tmp79_;
			_result_size = _tmp80_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp81_;
				gint _tmp82_;
				gint _tmp83_;
				GeeArrayList* _tmp84_;
				gint _tmp85_;
				gpointer _tmp86_ = NULL;
				NetsukukuAndnaServer* _result_;
				NetsukukuAndnaServers* _tmp87_;
				GeeList* _tmp88_;
				GeeList* _tmp89_;
				NetsukukuAndnaServer* _tmp90_;
				_tmp81_ = _result_index;
				_result_index = _tmp81_ + 1;
				_tmp82_ = _result_index;
				_tmp83_ = _result_size;
				if (!(_tmp82_ < _tmp83_)) {
					break;
				}
				_tmp84_ = _result_list;
				_tmp85_ = _result_index;
				_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) _tmp84_, _tmp85_);
				_result_ = (NetsukukuAndnaServer*) _tmp86_;
				_tmp87_ = response;
				_tmp88_ = netsukuku_andna_servers_get_servers (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = _result_;
				gee_collection_remove ((GeeCollection*) _tmp89_, _tmp90_);
				_g_object_unref0 (_result_);
			}
			_g_object_unref0 (_result_list);
		}
		_g_object_unref0 (todel);
	} else {
		NetsukukuTimeCapsule* _tmp91_;
		NetsukukuTimeCapsule* _tmp92_;
		NetsukukuAndnaServers* _tmp93_;
		_tmp91_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_OF_NEGATIVE);
		_g_object_unref0 (expires);
		expires = _tmp91_;
		_tmp92_ = expires;
		_tmp93_ = netsukuku_andna_servers_new_not_found (_tmp92_);
		_g_object_unref0 (response);
		response = _tmp93_;
	}
	_tmp94_ = response;
	_tmp95_ = expires;
	_tmp96_ = netsukuku_andna_get_servers_response_new (_tmp94_, _tmp95_);
	result = _tmp96_;
	_g_object_unref0 (response);
	_g_object_unref0 (expires);
	_g_object_unref0 (hashnode);
	return result;
}


static NetsukukuAndnaGetCacheRecordsResponse* netsukuku_andna_real_get_cache_records (NetsukukuIAndnaAsPeer* base, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaGetCacheRecordsResponse* result = NULL;
	TaskletsTimer* _tmp0_;
	TaskletsTimer* w;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	_tmp0_ = tasklets_timer_new ((gint64) 10000);
	w = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		TaskletsTimer* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->hooked_to_service;
		if (!(!_tmp1_)) {
			break;
		}
		_tmp2_ = w;
		_tmp3_ = tasklets_timer_is_expired (_tmp2_);
		if (_tmp3_) {
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
			_inner_error_ = _tmp4_;
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (w);
				return NULL;
			} else {
				_g_object_unref0 (w);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tasklets_tasklet_nap ((glong) 0, (glong) 1000);
	}
	_tmp5_ = self->priv->cache;
	_tmp6_ = self->priv->request_queue;
	_tmp7_ = netsukuku_andna_get_cache_records_response_new (_tmp5_, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (w);
	return result;
}


/** Remotable methods as AddressManager...client
          */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static NetsukukuAndnaConfirmPubkResponse* netsukuku_andna_real_confirm_pubk (NetsukukuIAndna* base, NetsukukuNIP* yournip, NetsukukuPublicKey* yourpubkey, gint to_be_signed, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaConfirmPubkResponse* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_;
	guint8* _tmp25_ = NULL;
	guint8* _tmp26_;
	gint _tmp26__length1;
	zcdSerializableBuffer* _tmp27_;
	zcdSerializableBuffer* _tmp28_;
	NetsukukuAndnaConfirmPubkResponse* _tmp29_;
	NetsukukuAndnaConfirmPubkResponse* _tmp30_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (yournip != NULL, NULL);
	g_return_val_if_fail (yourpubkey != NULL, NULL);
	_tmp1_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp2_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = yournip;
	_tmp5_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp3_, (NetsukukuPartialNIP*) _tmp4_);
	if (_tmp5_) {
		NetsukukuPublicKey* _tmp6_;
		NetsukukuPublicKey* _tmp7_;
		NetsukukuPublicKey* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = netsukuku_andna_get_mypubk (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = yourpubkey;
		_tmp9_ = netsukuku_public_key_equal_func (_tmp7_, _tmp8_);
		_tmp0_ = _tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		NetsukukuKeyPair* _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		guint8* _tmp15_;
		gint _tmp15__length1;
		guint8* _tmp16_;
		gint _tmp16__length1;
		gint _tmp17_ = 0;
		guchar* _tmp18_ = NULL;
		guchar* _tmp19_;
		gint _tmp19__length1;
		guchar* _tmp20_;
		gint _tmp20__length1;
		gint __tmp20__size_;
		guint8* buf;
		gint buf_length1;
		gint _buf_size_;
		guint8* _tmp21_;
		gint _tmp21__length1;
		zcdSerializableBuffer* _tmp22_;
		zcdSerializableBuffer* signature;
		zcdSerializableBuffer* _tmp23_;
		NetsukukuAndnaConfirmPubkResponse* _tmp24_;
		_tmp11_ = self->priv->my_keys;
		_tmp12_ = to_be_signed;
		_tmp13_ = g_strdup_printf ("%i", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_get_data (_tmp14_, &_tmp15__length1);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _tmp15__length1;
		_tmp18_ = netsukuku_key_pair_sign (_tmp11_, (guchar*) _tmp16_, (_tmp16__length1 * sizeof (guint8)) / sizeof (guchar), &_tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		_tmp19__length1 = _tmp17_;
		_g_free0 (_tmp14_);
		_tmp20_ = _tmp19_;
		_tmp20__length1 = _tmp19__length1;
		__tmp20__size_ = _tmp20__length1;
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		buf = (guint8*) _tmp20_;
		buf_length1 = (_tmp20__length1 * sizeof (guchar)) / sizeof (guint8);
		_buf_size_ = buf_length1;
		_tmp21_ = buf;
		_tmp21__length1 = buf_length1;
		_tmp22_ = zcd_serializable_buffer_new (_tmp21_, _tmp21__length1);
		signature = _tmp22_;
		_tmp23_ = signature;
		_tmp24_ = netsukuku_andna_confirm_pubk_response_new ("OK", _tmp23_);
		result = _tmp24_;
		_g_object_unref0 (signature);
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp25_ = g_new0 (guint8, 0);
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 0;
	_tmp27_ = zcd_serializable_buffer_new (_tmp26_, 0);
	_tmp28_ = _tmp27_;
	_tmp29_ = netsukuku_andna_confirm_pubk_response_new ("NO", _tmp28_);
	_tmp30_ = _tmp29_;
	_g_object_unref0 (_tmp28_);
	_tmp26_ = (g_free (_tmp26_), NULL);
	result = _tmp30_;
	return result;
}


static GeeList* netsukuku_andna_real_get_your_hostnames (NetsukukuIAndna* base, NetsukukuNIP* yournip, GError** error) {
	NetsukukuAndna * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (yournip != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		NetsukukuAndnaPrivateConfigurationList* _tmp1_;
		NetsukukuAndnaPrivateConfigurationList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _c_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _c_size;
		gint _c_index;
		_tmp1_ = netsukuku_andna_get_configuration (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = netsukuku_andna_private_configuration_list_get_lst (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_c_list = _tmp5_;
		_tmp6_ = _c_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_c_size = _tmp8_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			NetsukukuAndnaPrivateConfiguration* c;
			GeeArrayList* _tmp15_;
			NetsukukuAndnaPrivateConfiguration* _tmp16_;
			const gchar* _tmp17_;
			_tmp9_ = _c_index;
			_c_index = _tmp9_ + 1;
			_tmp10_ = _c_index;
			_tmp11_ = _c_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _c_list;
			_tmp13_ = _c_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			c = (NetsukukuAndnaPrivateConfiguration*) _tmp14_;
			_tmp15_ = ret;
			_tmp16_ = c;
			_tmp17_ = _tmp16_->domain;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
	result = (GeeList*) ret;
	return result;
}


static NetsukukuInfoAndna* netsukuku_andna_real_report_status (NetsukukuIAndna* base, GError** error) {
	NetsukukuAndna * self;
	NetsukukuInfoAndna* result = NULL;
	NetsukukuInfoAndna* _tmp0_;
	NetsukukuInfoAndna* ret;
	NetsukukuInfoAndna* _tmp1_;
	gboolean _tmp2_;
	NetsukukuInfoAndna* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	NetsukukuInfoAndna* _tmp6_;
	gboolean _tmp7_;
	NetsukukuInfoAndna* _tmp8_;
	gboolean _tmp9_ = FALSE;
	NetsukukuInfoAndna* _tmp10_;
	NetsukukuPublicKey* _tmp11_;
	NetsukukuPublicKey* _tmp12_;
	gchar* _tmp13_ = NULL;
	self = (NetsukukuAndna*) base;
	_tmp0_ = netsukuku_info_andna_new ();
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = ((NetsukukuOptionalPeerToPeer*) self)->will_participate;
	_tmp1_->will_participate = _tmp2_;
	_tmp3_ = ret;
	_tmp4_ = netsukuku_optional_peer_to_peer_get_participant ((NetsukukuOptionalPeerToPeer*) self);
	_tmp5_ = _tmp4_;
	_tmp3_->participating = _tmp5_;
	_tmp6_ = ret;
	_tmp7_ = self->priv->hooked_to_service;
	_tmp6_->hooked = _tmp7_;
	_tmp8_ = ret;
	_tmp9_ = netsukuku_andna_register_my_names_ongoing (self);
	_tmp8_->register_ongoing = _tmp9_;
	_tmp10_ = ret;
	_tmp11_ = netsukuku_andna_get_mypubk (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = netsukuku_public_key_to_string (_tmp12_);
	_g_free0 (_tmp10_->pubk);
	_tmp10_->pubk = _tmp13_;
	{
		GeeHashMap* _tmp14_;
		GeeSet* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeIterator* _tmp18_ = NULL;
		GeeIterator* _tmp19_;
		GeeIterator* _hashed_domain_it;
		_tmp14_ = self->priv->cache;
		_tmp15_ = gee_abstract_map_get_keys ((GeeMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_hashed_domain_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* hashed_domain;
			NetsukukuInfoAndnaCache* _tmp24_;
			NetsukukuInfoAndnaCache* c;
			NetsukukuInfoAndnaCache* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			NetsukukuInfoAndnaCache* _tmp28_;
			GeeHashMap* _tmp29_;
			const gchar* _tmp30_;
			gpointer _tmp31_ = NULL;
			NetsukukuInfoAndna* _tmp32_;
			GeeArrayList* _tmp33_;
			GeeArrayList* _tmp34_;
			NetsukukuInfoAndnaCache* _tmp35_;
			_tmp20_ = _hashed_domain_it;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _hashed_domain_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			hashed_domain = (gchar*) _tmp23_;
			_tmp24_ = netsukuku_info_andna_cache_new ();
			c = _tmp24_;
			_tmp25_ = c;
			_tmp26_ = hashed_domain;
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (_tmp25_->domain);
			_tmp25_->domain = _tmp27_;
			_tmp28_ = c;
			_tmp29_ = self->priv->cache;
			_tmp30_ = hashed_domain;
			_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
			_g_object_unref0 (_tmp28_->rec);
			_tmp28_->rec = (NetsukukuAndnaDomainRecord*) _tmp31_;
			_tmp32_ = ret;
			_tmp33_ = netsukuku_info_andna_get_cache (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = c;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
			_g_object_unref0 (c);
			_g_free0 (hashed_domain);
		}
		_g_object_unref0 (_hashed_domain_it);
	}
	{
		GeeArrayList* _tmp36_;
		GeeArrayList* _tmp37_;
		GeeArrayList* _dw_list;
		GeeArrayList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _dw_size;
		gint _dw_index;
		_tmp36_ = self->priv->lst_domains;
		_tmp37_ = _g_object_ref0 (_tmp36_);
		_dw_list = _tmp37_;
		_tmp38_ = _dw_list;
		_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_dw_size = _tmp40_;
		_dw_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			GeeArrayList* _tmp44_;
			gint _tmp45_;
			gpointer _tmp46_ = NULL;
			NetsukukuDomainWanted* dw;
			NetsukukuInfoAndnaRegistration* _tmp47_;
			NetsukukuInfoAndnaRegistration* r;
			NetsukukuInfoAndnaRegistration* _tmp48_;
			NetsukukuDomainWanted* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			NetsukukuInfoAndnaRegistration* _tmp52_;
			NetsukukuDomainWanted* _tmp53_;
			gboolean _tmp54_;
			NetsukukuInfoAndnaRegistration* _tmp55_;
			NetsukukuDomainWanted* _tmp56_;
			NetsukukuTimeCapsule* _tmp57_;
			NetsukukuTimeCapsule* _tmp58_;
			NetsukukuInfoAndna* _tmp59_;
			GeeArrayList* _tmp60_;
			GeeArrayList* _tmp61_;
			NetsukukuInfoAndnaRegistration* _tmp62_;
			_tmp41_ = _dw_index;
			_dw_index = _tmp41_ + 1;
			_tmp42_ = _dw_index;
			_tmp43_ = _dw_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _dw_list;
			_tmp45_ = _dw_index;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp45_);
			dw = (NetsukukuDomainWanted*) _tmp46_;
			_tmp47_ = netsukuku_info_andna_registration_new ();
			r = _tmp47_;
			_tmp48_ = r;
			_tmp49_ = dw;
			_tmp50_ = _tmp49_->hostname;
			_tmp51_ = g_strdup (_tmp50_);
			_g_free0 (_tmp48_->domain);
			_tmp48_->domain = _tmp51_;
			_tmp52_ = r;
			_tmp53_ = dw;
			_tmp54_ = _tmp53_->registered;
			_tmp52_->registered = _tmp54_;
			_tmp55_ = r;
			_tmp56_ = dw;
			_tmp57_ = _tmp56_->ttl_before_request;
			_tmp58_ = _g_object_ref0 (_tmp57_);
			_g_object_unref0 (_tmp55_->ttl_before_request);
			_tmp55_->ttl_before_request = _tmp58_;
			_tmp59_ = ret;
			_tmp60_ = netsukuku_info_andna_get_registrations (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = r;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
			_g_object_unref0 (r);
			_g_object_unref0 (dw);
		}
		_g_object_unref0 (_dw_list);
	}
	result = ret;
	return result;
}


static NetsukukuAndnaPrivateConfigurationList* netsukuku_andna_real_get_mynames (NetsukukuIAndna* base, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaPrivateConfigurationList* result = NULL;
	NetsukukuAndnaPrivateConfigurationList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationList* _tmp1_;
	NetsukukuAndnaPrivateConfigurationList* _tmp2_;
	self = (NetsukukuAndna*) base;
	_tmp0_ = netsukuku_andna_get_configuration (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void netsukuku_andna_real_set_mynames (NetsukukuIAndna* base, NetsukukuAndnaPrivateConfigurationList* mynames, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaPrivateConfigurationList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationList* _tmp1_;
	self = (NetsukukuAndna*) base;
	g_return_if_fail (mynames != NULL);
	netsukuku_andna_stop_register_my_names (self);
	_tmp0_ = mynames;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_configuration);
	self->priv->_configuration = _tmp1_;
	netsukuku_andna_register_my_names (self);
}


static NetsukukuPublicKey* netsukuku_andna_real_retrieve_registrar_pubk (NetsukukuIAndna* base, const gchar* hashed_domain, GError** error) {
	NetsukukuAndna * self;
	NetsukukuPublicKey* result = NULL;
	const gchar* _tmp0_;
	NetsukukuAndnaGetRegistrarResponse* _tmp1_ = NULL;
	NetsukukuAndnaGetRegistrarResponse* ret;
	NetsukukuAndnaGetRegistrarResponse* _tmp2_;
	NetsukukuAndnaGetRegistrarResponse* _tmp3_;
	NetsukukuPublicKey* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	NetsukukuPublicKey* _tmp6_;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = hashed_domain;
	_tmp1_ = netsukuku_andna_ask_registrar (self, _tmp0_);
	ret = _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (ret);
		return result;
	}
	_tmp3_ = ret;
	_tmp4_ = netsukuku_andna_get_registrar_response_get_pubk (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (ret);
	return result;
}


static NetsukukuAndnaPrivateConfigurationList* netsukuku_andna_get_configuration (NetsukukuAndna* self) {
	NetsukukuAndnaPrivateConfigurationList* result;
	NetsukukuAndnaPrivateConfigurationList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationList* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_configuration;
	if (_tmp0_ == NULL) {
		NetsukukuAndnaPrivateConfigurationList* _tmp1_;
		gchar buffer[256] = {0};
		gchar* myhostname;
		gint _tmp2_ = 0;
		const gchar* _tmp13_;
		_tmp1_ = netsukuku_andna_private_configuration_list_new ();
		_g_object_unref0 (self->priv->_configuration);
		self->priv->_configuration = _tmp1_;
		myhostname = NULL;
		_tmp2_ = gethostname (buffer, 256);
		if (_tmp2_ == 0) {
			GString* _tmp3_;
			GString* sb;
			gint pos;
			GString* _tmp9_;
			GString* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp3_ = g_string_new ("");
			sb = _tmp3_;
			pos = 0;
			while (TRUE) {
				gint _tmp4_;
				gchar _tmp5_;
				GString* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_;
				_tmp4_ = pos;
				_tmp5_ = buffer[_tmp4_];
				if (!(_tmp5_ != '\0')) {
					break;
				}
				_tmp6_ = sb;
				_tmp7_ = pos;
				pos = _tmp7_ + 1;
				_tmp8_ = buffer[_tmp7_];
				g_string_append_c (_tmp6_, _tmp8_);
			}
			_tmp9_ = sb;
			g_string_append_c (_tmp9_, '\0');
			_tmp10_ = sb;
			_tmp11_ = _tmp10_->str;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (myhostname);
			myhostname = _tmp12_;
			_g_string_free0 (sb);
		}
		_tmp13_ = myhostname;
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_;
			NetsukukuAndnaPrivateConfiguration* _tmp15_;
			NetsukukuAndnaPrivateConfiguration* cfg;
			NetsukukuAndnaPrivateConfigurationList* _tmp16_;
			GeeArrayList* _tmp17_;
			GeeArrayList* _tmp18_;
			NetsukukuAndnaPrivateConfiguration* _tmp19_;
			_tmp14_ = myhostname;
			_tmp15_ = netsukuku_andna_private_configuration_new (_tmp14_, NULL);
			cfg = _tmp15_;
			_tmp16_ = self->priv->_configuration;
			_tmp17_ = netsukuku_andna_private_configuration_list_get_lst (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = cfg;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			_g_object_unref0 (cfg);
		}
		_g_free0 (myhostname);
	}
	_tmp20_ = self->priv->_configuration;
	result = _tmp20_;
	return result;
}


static NetsukukuPublicKey* netsukuku_andna_get_mypubk (NetsukukuAndna* self) {
	NetsukukuPublicKey* result;
	NetsukukuPublicKey* _tmp0_;
	NetsukukuPublicKey* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mypubk;
	if (_tmp0_ == NULL) {
		NetsukukuKeyPair* _tmp1_;
		NetsukukuPublicKeyWrapper* _tmp2_;
		NetsukukuPublicKeyWrapper* _tmp3_;
		NetsukukuPublicKey* _tmp4_ = NULL;
		_tmp1_ = self->priv->my_keys;
		_tmp2_ = netsukuku_key_pair_get_pub_key (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = netsukuku_public_key_wrapper_to_pubkey (_tmp3_);
		_g_object_unref0 (self->priv->_mypubk);
		self->priv->_mypubk = _tmp4_;
	}
	_tmp5_ = self->priv->_mypubk;
	result = _tmp5_;
	return result;
}


static void netsukuku_andna_class_init (NetsukukuAndnaClass * klass) {
	netsukuku_andna_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuAndnaPrivate));
	ZCD_RPC_DISPATCHER_CLASS (klass)->_dispatch = netsukuku_andna_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_andna_real_h;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_andna_get_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_andna_finalize;
	g_signal_new ("andna_hooked", NETSUKUKU_TYPE_ANDNA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("andna_registered", NETSUKUKU_TYPE_ANDNA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void netsukuku_andna_netsukuku_iandna_as_peer_interface_init (NetsukukuIAndnaAsPeerIface * iface) {
	netsukuku_andna_netsukuku_iandna_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->register_main_for_pubk = (NetsukukuAndnaRegisterMainResponse* (*)(NetsukukuIAndnaAsPeer*, NetsukukuAndnaDomainRequest*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_andna_real_register_main_for_pubk;
	iface->get_registrar = (NetsukukuAndnaGetRegistrarResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, GError**)) netsukuku_andna_real_get_registrar;
	iface->get_domain_record = (NetsukukuAndnaDomainRecord* (*)(NetsukukuIAndnaAsPeer*, const gchar*, GError**)) netsukuku_andna_real_get_domain_record;
	iface->register_spread_record = (NetsukukuAndnaRegisterSpreadResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, gint, gboolean, GError**)) netsukuku_andna_real_register_spread_record;
	iface->get_servers = (NetsukukuAndnaGetServersResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, NetsukukuAndnaServiceKey*, gint, gboolean, GError**)) netsukuku_andna_real_get_servers;
	iface->get_cache_records = (NetsukukuAndnaGetCacheRecordsResponse* (*)(NetsukukuIAndnaAsPeer*, GError**)) netsukuku_andna_real_get_cache_records;
}


static void netsukuku_andna_netsukuku_iandna_interface_init (NetsukukuIAndnaIface * iface) {
	netsukuku_andna_netsukuku_iandna_parent_iface = g_type_interface_peek_parent (iface);
	iface->confirm_pubk = (NetsukukuAndnaConfirmPubkResponse* (*)(NetsukukuIAndna*, NetsukukuNIP*, NetsukukuPublicKey*, gint, GError**)) netsukuku_andna_real_confirm_pubk;
	iface->get_your_hostnames = (GeeList* (*)(NetsukukuIAndna*, NetsukukuNIP*, GError**)) netsukuku_andna_real_get_your_hostnames;
	iface->report_status = (NetsukukuInfoAndna* (*)(NetsukukuIAndna*, GError**)) netsukuku_andna_real_report_status;
	iface->get_mynames = (NetsukukuAndnaPrivateConfigurationList* (*)(NetsukukuIAndna*, GError**)) netsukuku_andna_real_get_mynames;
	iface->set_mynames = (void (*)(NetsukukuIAndna*, NetsukukuAndnaPrivateConfigurationList*, GError**)) netsukuku_andna_real_set_mynames;
	iface->retrieve_registrar_pubk = (NetsukukuPublicKey* (*)(NetsukukuIAndna*, const gchar*, GError**)) netsukuku_andna_real_retrieve_registrar_pubk;
}


static void netsukuku_andna_instance_init (NetsukukuAndna * self) {
	self->priv = NETSUKUKU_ANDNA_GET_PRIVATE (self);
}


static void netsukuku_andna_finalize (GObject* obj) {
	NetsukukuAndna * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ANDNA, NetsukukuAndna);
	_g_object_unref0 (self->priv->_configuration);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	_g_object_unref0 (self->priv->counter);
	_g_object_unref0 (self->priv->my_keys);
	_g_object_unref0 (self->priv->request_queue);
	_g_object_unref0 (self->priv->cache);
	_g_object_unref0 (self->priv->lst_domains);
	_g_object_unref0 (self->priv->_mypubk);
	G_OBJECT_CLASS (netsukuku_andna_parent_class)->finalize (obj);
}


GType netsukuku_andna_get_type (void) {
	static volatile gsize netsukuku_andna_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_andna_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAndnaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_andna_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAndna), 0, (GInstanceInitFunc) netsukuku_andna_instance_init, NULL };
		static const GInterfaceInfo netsukuku_iandna_as_peer_info = { (GInterfaceInitFunc) netsukuku_andna_netsukuku_iandna_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo netsukuku_iandna_info = { (GInterfaceInitFunc) netsukuku_andna_netsukuku_iandna_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_andna_type_id;
		netsukuku_andna_type_id = g_type_register_static (NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, "NetsukukuAndna", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_andna_type_id, NETSUKUKU_TYPE_IANDNA_AS_PEER, &netsukuku_iandna_as_peer_info);
		g_type_add_interface_static (netsukuku_andna_type_id, NETSUKUKU_TYPE_IANDNA, &netsukuku_iandna_info);
		g_once_init_leave (&netsukuku_andna_type_id__volatile, netsukuku_andna_type_id);
	}
	return netsukuku_andna_type_id__volatile;
}


static void _vala_netsukuku_andna_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuAndna * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_ANDNA, NetsukukuAndna);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



