/* coord.c generated by valac 0.20.1, the Vala compiler
 * generated from coord.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * Coordinator Node
 *
 * TODO: a fixed timeout isn't a
 *       good thing, you have to consider the rtt from the requester node to
 *       the coordinator node. Any better idea?
 */
/** Handling events **/

#include <glib.h>
#include <glib-object.h>
#include <zcd.h>
#include <netsukuku-rpc.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <tasklet.h>


#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_RMT_COORD_PEER (netsukuku_rmt_coord_peer_get_type ())
#define NETSUKUKU_RMT_COORD_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_COORD_PEER, NetsukukuRmtCoordPeer))
#define NETSUKUKU_RMT_COORD_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_COORD_PEER, NetsukukuRmtCoordPeerClass))
#define NETSUKUKU_IS_RMT_COORD_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_COORD_PEER))
#define NETSUKUKU_IS_RMT_COORD_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_COORD_PEER))
#define NETSUKUKU_RMT_COORD_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_COORD_PEER, NetsukukuRmtCoordPeerClass))

typedef struct _NetsukukuRmtCoordPeer NetsukukuRmtCoordPeer;
typedef struct _NetsukukuRmtCoordPeerClass NetsukukuRmtCoordPeerClass;
typedef struct _NetsukukuRmtCoordPeerPrivate NetsukukuRmtCoordPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_COORD_HKEY (netsukuku_coord_hkey_get_type ())
#define NETSUKUKU_COORD_HKEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkey))
#define NETSUKUKU_COORD_HKEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkeyClass))
#define NETSUKUKU_IS_COORD_HKEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORD_HKEY))
#define NETSUKUKU_IS_COORD_HKEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORD_HKEY))
#define NETSUKUKU_COORD_HKEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkeyClass))

typedef struct _NetsukukuCoord_hkey NetsukukuCoord_hkey;
typedef struct _NetsukukuCoord_hkeyClass NetsukukuCoord_hkeyClass;
typedef struct _NetsukukuCoord_hkeyPrivate NetsukukuCoord_hkeyPrivate;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORD_COMMUNICATE_TO_NEW_COORDINATOR (netsukuku_struct_helper_coord_communicate_to_new_coordinator_get_type ())

#define NETSUKUKU_TYPE_COORD (netsukuku_coord_get_type ())
#define NETSUKUKU_COORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORD, NetsukukuCoord))
#define NETSUKUKU_COORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORD, NetsukukuCoordClass))
#define NETSUKUKU_IS_COORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORD))
#define NETSUKUKU_IS_COORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORD))
#define NETSUKUKU_COORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORD, NetsukukuCoordClass))

typedef struct _NetsukukuCoord NetsukukuCoord;
typedef struct _NetsukukuCoordClass NetsukukuCoordClass;
typedef struct _Netsukukustruct_helper_Coord_communicate_to_new_coordinator Netsukukustruct_helper_Coord_communicate_to_new_coordinator;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
typedef struct _NetsukukuCoordPrivate NetsukukuCoordPrivate;

#define NETSUKUKU_TYPE_COORDINATOR (netsukuku_coordinator_get_type ())
#define NETSUKUKU_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator))
#define NETSUKUKU_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))
#define NETSUKUKU_IS_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_IS_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_COORDINATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))

typedef struct _NetsukukuCoordinator NetsukukuCoordinator;
typedef struct _NetsukukuCoordinatorClass NetsukukuCoordinatorClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;
typedef struct _NetsukukuCoordinatorPrivate NetsukukuCoordinatorPrivate;

#define NETSUKUKU_TYPE_ROUTE_NODE (netsukuku_route_node_get_type ())
#define NETSUKUKU_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode))
#define NETSUKUKU_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))
#define NETSUKUKU_IS_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_IS_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_ROUTE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))

typedef struct _NetsukukuRouteNode NetsukukuRouteNode;
typedef struct _NetsukukuRouteNodeClass NetsukukuRouteNodeClass;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_MANAGE_BNODE_TUNNELS (netsukuku_struct_helper_coordinator_manage_bnode_tunnels_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_manage_bnode_tunnels Netsukukustruct_helper_Coordinator_manage_bnode_tunnels;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_FORWARD_KNOWLEDGE (netsukuku_struct_helper_coordinator_forward_knowledge_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_forward_knowledge Netsukukustruct_helper_Coordinator_forward_knowledge;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_FORWARD_KNOWLEDGE_TO_NIP (netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_FORWARD_FREE (netsukuku_struct_helper_coordinator_forward_free_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_forward_free Netsukukustruct_helper_Coordinator_forward_free;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_FORWARD_FREE_TO_NIP (netsukuku_struct_helper_coordinator_forward_free_to_nip_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_forward_free_to_nip Netsukukustruct_helper_Coordinator_forward_free_to_nip;

#define NETSUKUKU_COORDINATOR_TYPE_PAIR (netsukuku_coordinator_pair_get_type ())
#define NETSUKUKU_COORDINATOR_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPair))
#define NETSUKUKU_COORDINATOR_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPairClass))
#define NETSUKUKU_COORDINATOR_IS_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_COORDINATOR_TYPE_PAIR))
#define NETSUKUKU_COORDINATOR_IS_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_COORDINATOR_TYPE_PAIR))
#define NETSUKUKU_COORDINATOR_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPairClass))

typedef struct _NetsukukuCoordinatorPair NetsukukuCoordinatorPair;
typedef struct _NetsukukuCoordinatorPairClass NetsukukuCoordinatorPairClass;
typedef struct _NetsukukuCoordinatorPairPrivate NetsukukuCoordinatorPairPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtCoordPeer {
	NetsukukuRmtPeer parent_instance;
	NetsukukuRmtCoordPeerPrivate * priv;
};

struct _NetsukukuRmtCoordPeerClass {
	NetsukukuRmtPeerClass parent_class;
};

struct _NetsukukuCoord_hkey {
	GObject parent_instance;
	NetsukukuCoord_hkeyPrivate * priv;
	gint level_of_gnode;
	NetsukukuNIP* nip;
};

struct _NetsukukuCoord_hkeyClass {
	GObjectClass parent_class;
};

struct _Netsukukustruct_helper_Coord_communicate_to_new_coordinator {
	NetsukukuCoord* self;
	gint level_of_gnode;
};

struct _NetsukukuPeerToPeer {
	zcdRPCDispatcher parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	gint pid;
	gboolean has_valid_map;
};

struct _NetsukukuPeerToPeerClass {
	zcdRPCDispatcherClass parent_class;
	void (*start_operations) (NetsukukuPeerToPeer* self);
	void (*stop_operations) (NetsukukuPeerToPeer* self);
	gboolean (*is_participant) (NetsukukuPeerToPeer* self, gint lvl, gint pos);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuCoord {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuCoordPrivate * priv;
};

struct _NetsukukuCoordClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuCoordPrivate {
	GeeArrayList* _coordinators;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _NetsukukuCoordinator {
	GObject parent_instance;
	NetsukukuCoordinatorPrivate * priv;
	gint last_assigned_elderliness;
};

struct _NetsukukuCoordinatorClass {
	GObjectClass parent_class;
};

struct _Netsukukustruct_helper_Coordinator_manage_bnode_tunnels {
	NetsukukuCoordinator* self;
};

struct _Netsukukustruct_helper_Coordinator_forward_knowledge {
	NetsukukuCoordinator* self;
};

struct _Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip {
	NetsukukuCoordinator* self;
	NetsukukuNIP* nip;
};

struct _Netsukukustruct_helper_Coordinator_forward_free {
	NetsukukuCoordinator* self;
	gint pos;
};

struct _Netsukukustruct_helper_Coordinator_forward_free_to_nip {
	NetsukukuCoordinator* self;
	NetsukukuNIP* to_nip;
	gint pos;
};

struct _NetsukukuCoordinatorPrivate {
	NetsukukuBookings* bookings;
	NetsukukuBnodeList* bnode_list;
	NetsukukuPartialNIP* _gnode;
	NetsukukuCoord* parent;
	NetsukukuMapRoute* maproute;
	gint level_of_gnode;
	gint level_of_nodes;
	gboolean _is_main_previous_state;
	gboolean _is_main_latest_evaluation;
	TaskletsTasklet* manage_bnode_tunnels_handle;
};

struct _NetsukukuCoordinatorPair {
	GObject parent_instance;
	NetsukukuCoordinatorPairPrivate * priv;
};

struct _NetsukukuCoordinatorPairClass {
	GObjectClass parent_class;
};

struct _NetsukukuCoordinatorPairPrivate {
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
	gpointer _a;
	gpointer _b;
};


static gpointer netsukuku_rmt_coord_peer_parent_class = NULL;
static NetsukukuICoordIface* netsukuku_rmt_coord_peer_netsukuku_icoord_parent_iface = NULL;
static gpointer netsukuku_coord_hkey_parent_class = NULL;
static gpointer netsukuku_coord_parent_class = NULL;
static NetsukukuICoordIface* netsukuku_coord_netsukuku_icoord_parent_iface = NULL;
static gpointer netsukuku_coordinator_parent_class = NULL;
static gpointer netsukuku_coordinator_pair_parent_class = NULL;

#define NETSUKUKU_COORD_DUPLICATION 10
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_rmt_coord_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_COORD_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtCoordPeer* netsukuku_rmt_coord_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtCoordPeer* netsukuku_rmt_coord_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static void netsukuku_rmt_coord_peer_real_duplicate_all_knowledge (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuCoordinatorKnowledge* coordinator_knowledge, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static NetsukukuHookReservation* netsukuku_rmt_coord_peer_real_reserve (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, GError** error);
static void netsukuku_rmt_coord_peer_real_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error);
static void netsukuku_rmt_coord_peer_real_duplicate_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error);
static gboolean netsukuku_rmt_coord_peer_real_register_bnode (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing, GError** error);
static GeeList* netsukuku_rmt_coord_peer_real_report_status (NetsukukuICoord* base, GError** error);
GType netsukuku_coord_hkey_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_COORD_HKEY_DUMMY_PROPERTY
};
NetsukukuCoord_hkey* netsukuku_coord_hkey_new (void);
NetsukukuCoord_hkey* netsukuku_coord_hkey_construct (GType object_type);
static void netsukuku_coord_hkey_finalize (GObject* obj);
GType netsukuku_struct_helper_coord_communicate_to_new_coordinator_get_type (void) G_GNUC_CONST;
GType netsukuku_coord_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coord_communicate_to_new_coordinator* netsukuku_struct_helper_coord_communicate_to_new_coordinator_dup (const Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self);
void netsukuku_struct_helper_coord_communicate_to_new_coordinator_free (Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self);
void netsukuku_struct_helper_coord_communicate_to_new_coordinator_copy (const Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self, Netsukukustruct_helper_Coord_communicate_to_new_coordinator* dest);
void netsukuku_struct_helper_coord_communicate_to_new_coordinator_destroy (Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_coordinator_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_COORD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_COORD, NetsukukuCoordPrivate))
enum  {
	NETSUKUKU_COORD_DUMMY_PROPERTY
};
#define NETSUKUKU_COORD_mypid 1
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
NetsukukuCoord* netsukuku_coord_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all, NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set);
NetsukukuCoord* netsukuku_coord_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all, NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GQuark netsukuku_peer_to_peer_error_quark (void);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
void netsukuku_coord_initialize_coordinators (NetsukukuCoord* self);
gint netsukuku_map_get_levels (NetsukukuMap* self);
NetsukukuCoordinator* netsukuku_coord_get_coordinator_for_gnode_at_level (NetsukukuCoord* self, gint l);
NetsukukuPartialNIP* netsukuku_coordinator_get_gnode (NetsukukuCoordinator* self);
void netsukuku_log_debug (const gchar* msg);
void netsukuku_coordinator_add_bookings (NetsukukuCoordinator* self, NetsukukuBookings* bookings);
void netsukuku_coordinator_add_bnode_list (NetsukukuCoordinator* self, NetsukukuBnodeList* bnode_list);
GType netsukuku_route_node_get_type (void) G_GNUC_CONST;
void netsukuku_coord_node_joins_maproute (NetsukukuCoord* self, gint level_of_nodes, gint pos);
static void _netsukuku_coord_node_joins_maproute_netsukuku_map_node_new (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self);
void netsukuku_coord_node_exits_maproute (NetsukukuCoord* self, gint level_of_nodes, gint pos);
static void _netsukuku_coord_node_exits_maproute_netsukuku_map_node_deleted (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self);
void netsukuku_coord_coord_has_valid_map (NetsukukuCoord* self);
static void _netsukuku_coord_coord_has_valid_map_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self);
NetsukukuRmtCoordPeer* netsukuku_coord_peer (NetsukukuCoord* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static zcdISerializable* netsukuku_coord_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error);
static GeeList* netsukuku_coord_real_report_status (NetsukukuICoord* base, GError** error);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
void netsukuku_log_error (const gchar* msg);
NetsukukuCoordinatorKnowledge* netsukuku_coordinator_report_status (NetsukukuCoordinator* self);
gboolean netsukuku_coordinator_get_is_main (NetsukukuCoordinator* self);
static NetsukukuNIP* netsukuku_coord_real_h (NetsukukuPeerToPeer* base, GObject* k);
static void netsukuku_coord_set_coordinator_for_gnode_at_level (NetsukukuCoord* self, gint l);
NetsukukuCoordinator* netsukuku_coordinator_new (NetsukukuPartialNIP* gnode, NetsukukuCoord* parent);
NetsukukuCoordinator* netsukuku_coordinator_construct (GType object_type, NetsukukuPartialNIP* gnode, NetsukukuCoord* parent);
static void netsukuku_coord_real_stop_operations (NetsukukuPeerToPeer* base);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
void netsukuku_peer_to_peer_stop_operations (NetsukukuPeerToPeer* self);
void netsukuku_coordinator_stop_operations (NetsukukuCoordinator* self);
NetsukukuPartialNIP* netsukuku_coord_get_my_gnode_at_level (NetsukukuCoord* self, gint l);
gint netsukuku_coord_get_level_of_gnode (NetsukukuCoord* self, NetsukukuPartialNIP* gnode);
NetsukukuCoordinator* netsukuku_coord_get_coordinator_for_gnode (NetsukukuCoord* self, NetsukukuPartialNIP* gnode, GError** error);
NetsukukuHookReservation* netsukuku_coord_enter_into (NetsukukuCoord* self, gint level_of_gnode, NetsukukuNIP* nip, NetsukukuAggregatedNeighbour* neighbour_to_contact);
void netsukuku_log_info (const gchar* msg);
NetsukukuBookings* netsukuku_coord_get_bookings (NetsukukuCoord* self, gint level_of_gnode);
NetsukukuBookings* netsukuku_coordinator_get_bookings (NetsukukuCoordinator* self);
gint netsukuku_coord_get_last_assigned_elderliness (NetsukukuCoord* self, gint level_of_gnode);
NetsukukuBnodeList* netsukuku_coord_get_bnode_list (NetsukukuCoord* self, gint level_of_gnode);
NetsukukuBnodeList* netsukuku_coordinator_get_bnode_list (NetsukukuCoordinator* self);
static NetsukukuHookReservation* netsukuku_coord_real_reserve (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, GError** error);
NetsukukuHookReservation* netsukuku_coordinator_reserve (NetsukukuCoordinator* self);
static void netsukuku_coord_real_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error);
void netsukuku_coordinator_free (NetsukukuCoordinator* self, gint pos);
static void netsukuku_coord_real_duplicate_all_knowledge (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuCoordinatorKnowledge* coordinator_knowledge, GError** error);
static void netsukuku_coord_real_duplicate_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error);
void netsukuku_coordinator_force_remove (NetsukukuCoordinator* self, gint pos);
static gboolean netsukuku_coord_real_register_bnode (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing, GError** error);
gboolean netsukuku_coordinator_register_bnode (NetsukukuCoordinator* self, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing);
void netsukuku_coordinator_map_has_changed (NetsukukuCoordinator* self);
gboolean netsukuku_coordinator_get_was_main (NetsukukuCoordinator* self);
void netsukuku_coord_communicate_to_new_coordinator (NetsukukuCoord* self, gint level_of_gnode);
static void netsukuku_coord_impl_communicate_to_new_coordinator (NetsukukuCoord* self, gint level_of_gnode, GError** error);
static void* netsukuku_coord_helper_communicate_to_new_coordinator (void* v, GError** error);
static void netsukuku_coord_finalize (GObject* obj);
GType netsukuku_struct_helper_coordinator_manage_bnode_tunnels_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* netsukuku_struct_helper_coordinator_manage_bnode_tunnels_dup (const Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self);
void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_free (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self);
void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_copy (const Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self, Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* dest);
void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_destroy (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self);
GType netsukuku_struct_helper_coordinator_forward_knowledge_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_forward_knowledge* netsukuku_struct_helper_coordinator_forward_knowledge_dup (const Netsukukustruct_helper_Coordinator_forward_knowledge* self);
void netsukuku_struct_helper_coordinator_forward_knowledge_free (Netsukukustruct_helper_Coordinator_forward_knowledge* self);
void netsukuku_struct_helper_coordinator_forward_knowledge_copy (const Netsukukustruct_helper_Coordinator_forward_knowledge* self, Netsukukustruct_helper_Coordinator_forward_knowledge* dest);
void netsukuku_struct_helper_coordinator_forward_knowledge_destroy (Netsukukustruct_helper_Coordinator_forward_knowledge* self);
GType netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_dup (const Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self);
void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_free (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self);
void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_copy (const Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self, Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* dest);
void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_destroy (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self);
GType netsukuku_struct_helper_coordinator_forward_free_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_forward_free* netsukuku_struct_helper_coordinator_forward_free_dup (const Netsukukustruct_helper_Coordinator_forward_free* self);
void netsukuku_struct_helper_coordinator_forward_free_free (Netsukukustruct_helper_Coordinator_forward_free* self);
void netsukuku_struct_helper_coordinator_forward_free_copy (const Netsukukustruct_helper_Coordinator_forward_free* self, Netsukukustruct_helper_Coordinator_forward_free* dest);
void netsukuku_struct_helper_coordinator_forward_free_destroy (Netsukukustruct_helper_Coordinator_forward_free* self);
GType netsukuku_struct_helper_coordinator_forward_free_to_nip_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_forward_free_to_nip* netsukuku_struct_helper_coordinator_forward_free_to_nip_dup (const Netsukukustruct_helper_Coordinator_forward_free_to_nip* self);
void netsukuku_struct_helper_coordinator_forward_free_to_nip_free (Netsukukustruct_helper_Coordinator_forward_free_to_nip* self);
void netsukuku_struct_helper_coordinator_forward_free_to_nip_copy (const Netsukukustruct_helper_Coordinator_forward_free_to_nip* self, Netsukukustruct_helper_Coordinator_forward_free_to_nip* dest);
void netsukuku_struct_helper_coordinator_forward_free_to_nip_destroy (Netsukukustruct_helper_Coordinator_forward_free_to_nip* self);
#define NETSUKUKU_COORDINATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorPrivate))
enum  {
	NETSUKUKU_COORDINATOR_DUMMY_PROPERTY,
	NETSUKUKU_COORDINATOR_GNODE,
	NETSUKUKU_COORDINATOR_IS_MAIN,
	NETSUKUKU_COORDINATOR_WAS_MAIN
};
static void netsukuku_coordinator_set_gnode (NetsukukuCoordinator* self, NetsukukuPartialNIP* value);
void netsukuku_coordinator_manage_bnode_tunnels (NetsukukuCoordinator* self);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
gint* netsukuku_map_free_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1);
gpointer netsukuku_map_node_get (NetsukukuMap* self, gint lvl, gint pos);
gboolean netsukuku_route_node_is_empty (NetsukukuRouteNode* self);
NetsukukuGNodeID* netsukuku_route_node_get_eldest_gid (NetsukukuRouteNode* self);
NetsukukuGNodeID** netsukuku_map_route_get_gid_list (NetsukukuMapRoute* self, int* result_length1);
static gint* _int_dup (gint* self);
NetsukukuGNodeID** netsukuku_map_route_get_gid_uppermost_list (NetsukukuMapRoute* self, gint level_of_gnode, int* result_length1);
void netsukuku_coordinator_forward_knowledge (NetsukukuCoordinator* self);
static NetsukukuGNodeID** _vala_array_dup2 (NetsukukuGNodeID** self, int length);
void netsukuku_coordinator_forward_free (NetsukukuCoordinator* self, gint pos);
static void netsukuku_coordinator_impl_forward_free (NetsukukuCoordinator* self, gint pos, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error);
static void _vala_array_add3 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value);
void netsukuku_coordinator_forward_free_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, gint pos);
static void* netsukuku_coordinator_helper_forward_free (void* v, GError** error);
static void netsukuku_coordinator_impl_forward_free_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, gint pos, GError** error);
void netsukuku_log_warn (const gchar* msg);
static void* netsukuku_coordinator_helper_forward_free_to_nip (void* v, GError** error);
void netsukuku_coordinator_add_record (NetsukukuCoordinator* self, NetsukukuBookingRecord* booking_record);
static void netsukuku_coordinator_impl_manage_bnode_tunnels (NetsukukuCoordinator* self, GError** error);
static gboolean _netsukuku_bnode_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
void netsukuku_coordinator_arrange_tunnel (NetsukukuCoordinator* self, GeeArrayList* candidates);
static void* netsukuku_coordinator_helper_manage_bnode_tunnels (void* v, GError** error);
static GType netsukuku_coordinator_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static NetsukukuCoordinatorPair* netsukuku_coordinator_pair_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, gconstpointer a, gconstpointer b);
static NetsukukuCoordinatorPair* netsukuku_coordinator_pair_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, gconstpointer a, gconstpointer b);
static gint __lambda2_ (NetsukukuCoordinator* self, NetsukukuCoordinatorPair* a, NetsukukuCoordinatorPair* b);
static gconstpointer netsukuku_coordinator_pair_get_b (NetsukukuCoordinatorPair* self);
static gint ___lambda2__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gconstpointer netsukuku_coordinator_pair_get_a (NetsukukuCoordinatorPair* self);
static void netsukuku_coordinator_impl_forward_knowledge (NetsukukuCoordinator* self, GError** error);
static void _vala_array_add4 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value);
void netsukuku_coordinator_forward_knowledge_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* nip);
static void* netsukuku_coordinator_helper_forward_knowledge (void* v, GError** error);
static void netsukuku_coordinator_impl_forward_knowledge_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, GError** error);
static void* netsukuku_coordinator_helper_forward_knowledge_to_nip (void* v, GError** error);
#define NETSUKUKU_COORDINATOR_PAIR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPairPrivate))
enum  {
	NETSUKUKU_COORDINATOR_PAIR_DUMMY_PROPERTY,
	NETSUKUKU_COORDINATOR_PAIR_A_TYPE,
	NETSUKUKU_COORDINATOR_PAIR_A_DUP_FUNC,
	NETSUKUKU_COORDINATOR_PAIR_A_DESTROY_FUNC,
	NETSUKUKU_COORDINATOR_PAIR_B_TYPE,
	NETSUKUKU_COORDINATOR_PAIR_B_DUP_FUNC,
	NETSUKUKU_COORDINATOR_PAIR_B_DESTROY_FUNC,
	NETSUKUKU_COORDINATOR_PAIR_A,
	NETSUKUKU_COORDINATOR_PAIR_B
};
static void netsukuku_coordinator_pair_set_a (NetsukukuCoordinatorPair* self, gconstpointer value);
static void netsukuku_coordinator_pair_set_b (NetsukukuCoordinatorPair* self, gconstpointer value);
static void netsukuku_coordinator_pair_finalize (GObject* obj);
static void _vala_netsukuku_coordinator_pair_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_coordinator_pair_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void netsukuku_coordinator_finalize (GObject* obj);
static void _vala_netsukuku_coordinator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_coordinator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


NetsukukuRmtCoordPeer* netsukuku_rmt_coord_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCoordPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	GObject* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuAggregatedNeighbour* _tmp3_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = key;
	_tmp2_ = hIP;
	_tmp3_ = aggregated_neighbour;
	self = (NetsukukuRmtCoordPeer*) netsukuku_rmt_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NetsukukuRmtCoordPeer* netsukuku_rmt_coord_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_coord_peer_construct (NETSUKUKU_TYPE_RMT_COORD_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void netsukuku_rmt_coord_peer_real_duplicate_all_knowledge (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuCoordinatorKnowledge* coordinator_knowledge, GError** error) {
	NetsukukuRmtCoordPeer * self;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	gchar* _tmp1_;
	NetsukukuPartialNIP* _tmp2_;
	NetsukukuCoordinatorKnowledge* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_if_fail (gnode != NULL);
	g_return_if_fail (coordinator_knowledge != NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = g_strdup ("duplicate_all_knowledge");
	_g_free0 (rc->method_name);
	rc->method_name = _tmp1_;
	_tmp2_ = gnode;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp2_);
	_tmp3_ = coordinator_knowledge;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp3_);
	{
		zcdISerializable* _tmp4_ = NULL;
		zcdISerializable* _tmp5_;
		_tmp4_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, rc, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch25_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch25_netsukuku_hooking_error;
			}
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _g_error_copy0 (_tmp6_);
		_inner_error_ = _tmp7_;
		_g_error_free0 (e);
		goto __finally25;
	}
	goto __finally25;
	__catch25_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally25;
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		GQuark _tmp11_;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->domain;
		_tmp12_ = g_quark_to_string (_tmp11_);
		_tmp13_ = e;
		_tmp14_ = _tmp13_->code;
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("Unexpected error ", _tmp12_, ".", _tmp16_, " '", _tmp19_, "'", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp16_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally25;
	}
	__finally25:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rc);
			return;
		} else {
			_g_object_unref0 (rc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (rc);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuHookReservation* netsukuku_rmt_coord_peer_real_reserve (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuRmtCoordPeer * self;
	NetsukukuHookReservation* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuPartialNIP* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("reserve");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = gnode;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	{
		zcdRemoteCall* _tmp5_;
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* ret;
		zcdISerializable* _tmp7_;
		GType _tmp8_ = 0UL;
		gboolean _tmp9_ = FALSE;
		_tmp5_ = rc;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp5_, &_inner_error_);
		ret = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch26_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch26_netsukuku_hooking_error;
			}
			goto __catch26_g_error;
		}
		_tmp7_ = ret;
		_tmp8_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp7_);
		_tmp9_ = g_type_is_a (_tmp8_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp9_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp10_;
			NetsukukuHookReservation* _tmp11_;
			_tmp10_ = ret;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, NETSUKUKU_TYPE_HOOK_RESERVATION, NetsukukuHookReservation));
			result = _tmp11_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally26;
	__catch26_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GError* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _g_error_copy0 (_tmp12_);
		_inner_error_ = _tmp13_;
		_g_error_free0 (e);
		goto __finally26;
	}
	goto __finally26;
	__catch26_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally26;
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->code;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Unexpected error ", _tmp18_, ".", _tmp22_, " '", _tmp25_, "'", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally26;
	}
	__finally26:
	if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_coord_peer_real_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error) {
	NetsukukuRmtCoordPeer * self;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	gchar* _tmp1_;
	NetsukukuPartialNIP* _tmp2_;
	gint _tmp3_;
	zcdSerializableInt* _tmp4_;
	zcdSerializableInt* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = g_strdup ("free");
	_g_free0 (rc->method_name);
	rc->method_name = _tmp1_;
	_tmp2_ = gnode;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp2_);
	_tmp3_ = pos;
	_tmp4_ = zcd_serializable_int_new (_tmp3_);
	_tmp5_ = _tmp4_;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, rc, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch27_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch27_netsukuku_hooking_error;
			}
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally27;
	}
	goto __finally27;
	__catch27_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_inner_error_ = _tmp11_;
		_g_error_free0 (e);
		goto __finally27;
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GQuark _tmp13_;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->domain;
		_tmp14_ = g_quark_to_string (_tmp13_);
		_tmp15_ = e;
		_tmp16_ = _tmp15_->code;
		_tmp17_ = g_strdup_printf ("%i", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Unexpected error ", _tmp14_, ".", _tmp18_, " '", _tmp21_, "'", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp18_);
		_inner_error_ = _tmp25_;
		_g_error_free0 (e);
		goto __finally27;
	}
	__finally27:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rc);
			return;
		} else {
			_g_object_unref0 (rc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_coord_peer_real_duplicate_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error) {
	NetsukukuRmtCoordPeer * self;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	gchar* _tmp1_;
	NetsukukuPartialNIP* _tmp2_;
	gint _tmp3_;
	zcdSerializableInt* _tmp4_;
	zcdSerializableInt* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = g_strdup ("duplicate_free");
	_g_free0 (rc->method_name);
	rc->method_name = _tmp1_;
	_tmp2_ = gnode;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp2_);
	_tmp3_ = pos;
	_tmp4_ = zcd_serializable_int_new (_tmp3_);
	_tmp5_ = _tmp4_;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, rc, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch28_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch28_netsukuku_hooking_error;
			}
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally28;
	}
	goto __finally28;
	__catch28_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_inner_error_ = _tmp11_;
		_g_error_free0 (e);
		goto __finally28;
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GQuark _tmp13_;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->domain;
		_tmp14_ = g_quark_to_string (_tmp13_);
		_tmp15_ = e;
		_tmp16_ = _tmp15_->code;
		_tmp17_ = g_strdup_printf ("%i", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Unexpected error ", _tmp14_, ".", _tmp18_, " '", _tmp21_, "'", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp18_);
		_inner_error_ = _tmp25_;
		_g_error_free0 (e);
		goto __finally28;
	}
	__finally28:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rc);
			return;
		} else {
			_g_object_unref0 (rc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (rc);
}


static gboolean netsukuku_rmt_coord_peer_real_register_bnode (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing, GError** error) {
	NetsukukuRmtCoordPeer * self;
	gboolean result = FALSE;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuPartialNIP* _tmp4_;
	zcdRemoteCall* _tmp5_;
	NetsukukuNIP* _tmp6_;
	zcdRemoteCall* _tmp7_;
	gboolean _tmp8_;
	zcdSerializableBool* _tmp9_;
	zcdSerializableBool* _tmp10_;
	zcdRemoteCall* _tmp11_;
	gboolean _tmp12_;
	zcdSerializableBool* _tmp13_;
	zcdSerializableBool* _tmp14_;
	zcdRemoteCall* _tmp15_;
	gboolean _tmp16_;
	zcdSerializableBool* _tmp17_;
	zcdSerializableBool* _tmp18_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_val_if_fail (gnode != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("register_bnode");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = gnode;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = rc;
	_tmp6_ = nip;
	zcd_remote_call_add_parameter (_tmp5_, (zcdISerializable*) _tmp6_);
	_tmp7_ = rc;
	_tmp8_ = is_border;
	_tmp9_ = zcd_serializable_bool_new (_tmp8_);
	_tmp10_ = _tmp9_;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = rc;
	_tmp12_ = has_tunnel;
	_tmp13_ = zcd_serializable_bool_new (_tmp12_);
	_tmp14_ = _tmp13_;
	zcd_remote_call_add_parameter (_tmp11_, (zcdISerializable*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = rc;
	_tmp16_ = is_willing;
	_tmp17_ = zcd_serializable_bool_new (_tmp16_);
	_tmp18_ = _tmp17_;
	zcd_remote_call_add_parameter (_tmp15_, (zcdISerializable*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	{
		zcdRemoteCall* _tmp19_;
		zcdISerializable* _tmp20_ = NULL;
		zcdISerializable* _tmp21_;
		zcdSerializableBool* ret;
		zcdSerializableBool* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp19_ = rc;
		_tmp20_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp19_, &_inner_error_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch29_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch29_netsukuku_hooking_error;
			}
			goto __catch29_g_error;
		}
		ret = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool);
		_tmp22_ = ret;
		_tmp23_ = zcd_serializable_bool_get_b (_tmp22_);
		_tmp24_ = _tmp23_;
		result = _tmp24_;
		_g_object_unref0 (ret);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally29;
	__catch29_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		GError* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _g_error_copy0 (_tmp25_);
		_inner_error_ = _tmp26_;
		_g_error_free0 (e);
		goto __finally29;
	}
	goto __finally29;
	__catch29_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		GError* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _g_error_copy0 (_tmp27_);
		_inner_error_ = _tmp28_;
		_g_error_free0 (e);
		goto __finally29;
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		GQuark _tmp30_;
		const gchar* _tmp31_ = NULL;
		GError* _tmp32_;
		gint _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		GError* _tmp41_;
		GError* _tmp42_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->domain;
		_tmp31_ = g_quark_to_string (_tmp30_);
		_tmp32_ = e;
		_tmp33_ = _tmp32_->code;
		_tmp34_ = g_strdup_printf ("%i", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		_tmp38_ = string_to_string (_tmp37_);
		_tmp39_ = g_strconcat ("Unexpected error ", _tmp31_, ".", _tmp35_, " '", _tmp38_, "'", NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		_g_free0 (_tmp35_);
		_inner_error_ = _tmp42_;
		_g_error_free0 (e);
		goto __finally29;
	}
	__finally29:
	if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return FALSE;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (rc);
}


static GeeList* netsukuku_rmt_coord_peer_real_report_status (NetsukukuICoord* base, GError** error) {
	NetsukukuRmtCoordPeer * self;
	GeeList* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = g_strdup ("report_status");
	_g_free0 (rc->method_name);
	rc->method_name = _tmp1_;
	{
		zcdISerializable* _tmp2_ = NULL;
		zcdISerializable* _tmp3_;
		zcdListISerializable* ret;
		zcdListISerializable* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _tmp6_;
		_tmp2_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, rc, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch30_zcd_rpc_error;
			}
			goto __catch30_g_error;
		}
		ret = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable);
		_tmp4_ = ret;
		_tmp5_ = _tmp4_->backed;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_LIST, GeeList));
		result = _tmp6_;
		_g_object_unref0 (ret);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally30;
	__catch30_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_inner_error_ = _tmp8_;
		_g_error_free0 (e);
		goto __finally30;
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		GQuark _tmp10_;
		const gchar* _tmp11_ = NULL;
		GError* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->domain;
		_tmp11_ = g_quark_to_string (_tmp10_);
		_tmp12_ = e;
		_tmp13_ = _tmp12_->code;
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat ("Unexpected error ", _tmp11_, ".", _tmp15_, " '", _tmp18_, "'", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp15_);
		_inner_error_ = _tmp22_;
		_g_error_free0 (e);
		goto __finally30;
	}
	__finally30:
	if (_inner_error_->domain == ZCD_RPC_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_coord_peer_class_init (NetsukukuRmtCoordPeerClass * klass) {
	netsukuku_rmt_coord_peer_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_rmt_coord_peer_netsukuku_icoord_interface_init (NetsukukuICoordIface * iface) {
	netsukuku_rmt_coord_peer_netsukuku_icoord_parent_iface = g_type_interface_peek_parent (iface);
	iface->duplicate_all_knowledge = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, NetsukukuCoordinatorKnowledge*, GError**)) netsukuku_rmt_coord_peer_real_duplicate_all_knowledge;
	iface->reserve = (NetsukukuHookReservation* (*)(NetsukukuICoord*, NetsukukuPartialNIP*, GError**)) netsukuku_rmt_coord_peer_real_reserve;
	iface->free = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, gint, GError**)) netsukuku_rmt_coord_peer_real_free;
	iface->duplicate_free = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, gint, GError**)) netsukuku_rmt_coord_peer_real_duplicate_free;
	iface->register_bnode = (gboolean (*)(NetsukukuICoord*, NetsukukuPartialNIP*, NetsukukuNIP*, gboolean, gboolean, gboolean, GError**)) netsukuku_rmt_coord_peer_real_register_bnode;
	iface->report_status = (GeeList* (*)(NetsukukuICoord*, GError**)) netsukuku_rmt_coord_peer_real_report_status;
}


static void netsukuku_rmt_coord_peer_instance_init (NetsukukuRmtCoordPeer * self) {
}


GType netsukuku_rmt_coord_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_coord_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_coord_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtCoordPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_coord_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtCoordPeer), 0, (GInstanceInitFunc) netsukuku_rmt_coord_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icoord_info = { (GInterfaceInitFunc) netsukuku_rmt_coord_peer_netsukuku_icoord_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_rmt_coord_peer_type_id;
		netsukuku_rmt_coord_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_RMT_PEER, "NetsukukuRmtCoordPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_rmt_coord_peer_type_id, NETSUKUKU_TYPE_ICOORD, &netsukuku_icoord_info);
		g_once_init_leave (&netsukuku_rmt_coord_peer_type_id__volatile, netsukuku_rmt_coord_peer_type_id);
	}
	return netsukuku_rmt_coord_peer_type_id__volatile;
}


NetsukukuCoord_hkey* netsukuku_coord_hkey_construct (GType object_type) {
	NetsukukuCoord_hkey * self = NULL;
	self = (NetsukukuCoord_hkey*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuCoord_hkey* netsukuku_coord_hkey_new (void) {
	return netsukuku_coord_hkey_construct (NETSUKUKU_TYPE_COORD_HKEY);
}


static void netsukuku_coord_hkey_class_init (NetsukukuCoord_hkeyClass * klass) {
	netsukuku_coord_hkey_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coord_hkey_finalize;
}


static void netsukuku_coord_hkey_instance_init (NetsukukuCoord_hkey * self) {
}


static void netsukuku_coord_hkey_finalize (GObject* obj) {
	NetsukukuCoord_hkey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkey);
	_g_object_unref0 (self->nip);
	G_OBJECT_CLASS (netsukuku_coord_hkey_parent_class)->finalize (obj);
}


GType netsukuku_coord_hkey_get_type (void) {
	static volatile gsize netsukuku_coord_hkey_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coord_hkey_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoord_hkeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coord_hkey_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoord_hkey), 0, (GInstanceInitFunc) netsukuku_coord_hkey_instance_init, NULL };
		GType netsukuku_coord_hkey_type_id;
		netsukuku_coord_hkey_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuCoord_hkey", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_coord_hkey_type_id__volatile, netsukuku_coord_hkey_type_id);
	}
	return netsukuku_coord_hkey_type_id__volatile;
}


void netsukuku_struct_helper_coord_communicate_to_new_coordinator_copy (const Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self, Netsukukustruct_helper_Coord_communicate_to_new_coordinator* dest) {
	NetsukukuCoord* _tmp0_;
	NetsukukuCoord* _tmp1_;
	gint _tmp2_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).level_of_gnode;
	(*dest).level_of_gnode = _tmp2_;
}


void netsukuku_struct_helper_coord_communicate_to_new_coordinator_destroy (Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Coord_communicate_to_new_coordinator* netsukuku_struct_helper_coord_communicate_to_new_coordinator_dup (const Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self) {
	Netsukukustruct_helper_Coord_communicate_to_new_coordinator* dup;
	dup = g_new0 (Netsukukustruct_helper_Coord_communicate_to_new_coordinator, 1);
	netsukuku_struct_helper_coord_communicate_to_new_coordinator_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coord_communicate_to_new_coordinator_free (Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self) {
	netsukuku_struct_helper_coord_communicate_to_new_coordinator_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coord_communicate_to_new_coordinator_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id__volatile)) {
		GType netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id;
		netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coord_communicate_to_new_coordinator", (GBoxedCopyFunc) netsukuku_struct_helper_coord_communicate_to_new_coordinator_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coord_communicate_to_new_coordinator_free);
		g_once_init_leave (&netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id__volatile, netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id);
	}
	return netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id__volatile;
}


static void _netsukuku_coord_node_joins_maproute_netsukuku_map_node_new (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self) {
	netsukuku_coord_node_joins_maproute (self, lvl, pos);
}


static void _netsukuku_coord_node_exits_maproute_netsukuku_map_node_deleted (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self) {
	netsukuku_coord_node_exits_maproute (self, lvl, pos);
}


static void _netsukuku_coord_coord_has_valid_map_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self) {
	netsukuku_coord_coord_has_valid_map (self);
}


NetsukukuCoord* netsukuku_coord_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all, NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set) {
	NetsukukuCoord * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuMapRoute* _tmp47_;
	NetsukukuMapRoute* _tmp48_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	g_return_val_if_fail (coordinator_knowledge_set != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	self = (NetsukukuCoord*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, NETSUKUKU_COORD_mypid);
	{
		NetsukukuPeerToPeerAll* _tmp2_;
		_tmp2_ = peer_to_peer_all;
		netsukuku_peer_to_peer_all_peer_to_peer_register (_tmp2_, (NetsukukuPeerToPeer*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				goto __catch31_netsukuku_peer_to_peer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally31;
	__catch31_netsukuku_peer_to_peer_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("Coord service: registering failed: ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		g_error ("coord.vala:167: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	netsukuku_coord_initialize_coordinators (self);
	{
		gint level_of_gnode;
		level_of_gnode = 1;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				NetsukukuMapRoute* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				NetsukukuCoordinator* _tmp15_ = NULL;
				NetsukukuCoordinator* coordinator;
				NetsukukuCoordinatorKnowledgeSet* _tmp16_;
				GeeHashMap* _tmp17_;
				NetsukukuCoordinator* _tmp18_;
				NetsukukuPartialNIP* _tmp19_;
				NetsukukuPartialNIP* _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = level_of_gnode;
					level_of_gnode = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = level_of_gnode;
				_tmp11_ = maproute;
				_tmp12_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp10_ < (_tmp13_ + 1))) {
					break;
				}
				_tmp14_ = level_of_gnode;
				_tmp15_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp14_);
				coordinator = _tmp15_;
				_tmp16_ = coordinator_knowledge_set;
				_tmp17_ = _tmp16_->dict;
				_tmp18_ = coordinator;
				_tmp19_ = netsukuku_coordinator_get_gnode (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp20_);
				if (_tmp21_) {
					NetsukukuCoordinatorKnowledgeSet* _tmp22_;
					GeeHashMap* _tmp23_;
					NetsukukuCoordinator* _tmp24_;
					NetsukukuPartialNIP* _tmp25_;
					NetsukukuPartialNIP* _tmp26_;
					gpointer _tmp27_ = NULL;
					NetsukukuCoordinatorKnowledge* coordinator_knowledge;
					NetsukukuCoordinator* _tmp28_;
					NetsukukuPartialNIP* _tmp29_;
					NetsukukuPartialNIP* _tmp30_;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_;
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_;
					NetsukukuCoordinator* _tmp35_;
					NetsukukuCoordinatorKnowledge* _tmp36_;
					NetsukukuBookings* _tmp37_;
					NetsukukuBookings* _tmp38_;
					NetsukukuCoordinator* _tmp39_;
					NetsukukuCoordinatorKnowledge* _tmp40_;
					gint _tmp41_;
					gint _tmp42_;
					NetsukukuCoordinator* _tmp43_;
					NetsukukuCoordinatorKnowledge* _tmp44_;
					NetsukukuBnodeList* _tmp45_;
					NetsukukuBnodeList* _tmp46_;
					_tmp22_ = coordinator_knowledge_set;
					_tmp23_ = _tmp22_->dict;
					_tmp24_ = coordinator;
					_tmp25_ = netsukuku_coordinator_get_gnode (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp26_);
					coordinator_knowledge = (NetsukukuCoordinatorKnowledge*) _tmp27_;
					_tmp28_ = coordinator;
					_tmp29_ = netsukuku_coordinator_get_gnode (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = netsukuku_partial_nip_to_string (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strconcat ("Coord: memorizing knowledge records for gnode ", _tmp32_, NULL);
					_tmp34_ = _tmp33_;
					netsukuku_log_debug (_tmp34_);
					_g_free0 (_tmp34_);
					_g_free0 (_tmp32_);
					_tmp35_ = coordinator;
					_tmp36_ = coordinator_knowledge;
					_tmp37_ = netsukuku_coordinator_knowledge_get_bookings (_tmp36_);
					_tmp38_ = _tmp37_;
					netsukuku_coordinator_add_bookings (_tmp35_, _tmp38_);
					_tmp39_ = coordinator;
					_tmp40_ = coordinator_knowledge;
					_tmp41_ = netsukuku_coordinator_knowledge_get_last_assigned_elderliness (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp39_->last_assigned_elderliness = _tmp42_;
					_tmp43_ = coordinator;
					_tmp44_ = coordinator_knowledge;
					_tmp45_ = netsukuku_coordinator_knowledge_get_bnode_list (_tmp44_);
					_tmp46_ = _tmp45_;
					netsukuku_coordinator_add_bnode_list (_tmp43_, _tmp46_);
					_g_object_unref0 (coordinator_knowledge);
				}
				_g_object_unref0 (coordinator);
			}
		}
	}
	netsukuku_log_debug ("Coord: finished memorizing coordinator_knowledge_set.");
	_tmp47_ = maproute;
	g_signal_connect_object ((NetsukukuMap*) _tmp47_, "node-new", (GCallback) _netsukuku_coord_node_joins_maproute_netsukuku_map_node_new, self, 0);
	_tmp48_ = maproute;
	g_signal_connect_object ((NetsukukuMap*) _tmp48_, "node-deleted", (GCallback) _netsukuku_coord_node_exits_maproute_netsukuku_map_node_deleted, self, 0);
	g_signal_connect_object ((NetsukukuPeerToPeer*) self, "map-peer-to-peer-validated", (GCallback) _netsukuku_coord_coord_has_valid_map_netsukuku_peer_to_peer_map_peer_to_peer_validated, self, 0);
	return self;
}


NetsukukuCoord* netsukuku_coord_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all, NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set) {
	return netsukuku_coord_construct (NETSUKUKU_TYPE_COORD, aggregated_neighbour_manager, maproute, peer_to_peer_all, coordinator_knowledge_set);
}


NetsukukuRmtCoordPeer* netsukuku_coord_peer (NetsukukuCoord* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCoordPeer* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuNIP* _tmp1_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuRmtCoordPeer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = hIP;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = _tmp2_ != NULL;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "hIP != null || key != null");
	_tmp4_ = key;
	_tmp5_ = hIP;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = netsukuku_rmt_coord_peer_new ((NetsukukuPeerToPeer*) self, _tmp4_, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


/** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
static zcdISerializable* netsukuku_coord_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error) {
	NetsukukuCoord * self;
	zcdISerializable* result = NULL;
	GType _tmp0_ = 0UL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	zcdRemoteCall* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	zcdRemoteCall* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** pieces;
	gint pieces_length1;
	gint _pieces_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	const gchar* _tmp46_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	const gchar* _tmp72_;
	gchar** _tmp106_;
	gint _tmp106__length1;
	const gchar* _tmp107_;
	gchar** _tmp141_;
	gint _tmp141__length1;
	const gchar* _tmp142_;
	gchar** _tmp215_;
	gint _tmp215__length1;
	const gchar* _tmp216_;
	GObject* _tmp230_;
	zcdRemoteCall* _tmp231_;
	zcdISerializable* _tmp232_ = NULL;
	zcdISerializable* _tmp233_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp1_ = g_type_name (_tmp0_);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = data;
	_tmp4_ = zcd_remote_call_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, ": dispatching ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	netsukuku_log_debug (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = data;
	_tmp9_ = _tmp8_->method_name;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ".", 0);
	pieces = _tmp11_;
	pieces_length1 = _vala_array_length (_tmp10_);
	_pieces_size_ = pieces_length1;
	_tmp12_ = pieces;
	_tmp12__length1 = pieces_length1;
	_tmp13_ = _tmp12_[0];
	if (g_strcmp0 (_tmp13_, "duplicate_all_knowledge") == 0) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		zcdRemoteCall* _tmp16_;
		GeeList* _tmp17_;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		zcdRemoteCall* _tmp22_;
		GeeList* _tmp23_;
		GeeList* _tmp24_;
		gpointer _tmp25_ = NULL;
		zcdISerializable* iser0;
		zcdRemoteCall* _tmp26_;
		GeeList* _tmp27_;
		GeeList* _tmp28_;
		gpointer _tmp29_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp30_;
		GType _tmp31_ = 0UL;
		gboolean _tmp32_ = FALSE;
		zcdISerializable* _tmp34_;
		GType _tmp35_ = 0UL;
		gboolean _tmp36_ = FALSE;
		zcdISerializable* _tmp38_;
		NetsukukuPartialNIP* _tmp39_;
		NetsukukuPartialNIP* gnode;
		zcdISerializable* _tmp40_;
		NetsukukuCoordinatorKnowledge* _tmp41_;
		NetsukukuCoordinatorKnowledge* coordinator_knowledge;
		NetsukukuPartialNIP* _tmp42_;
		NetsukukuCoordinatorKnowledge* _tmp43_;
		zcdSerializableNone* _tmp44_;
		_tmp14_ = pieces;
		_tmp14__length1 = pieces_length1;
		if (_tmp14__length1 != 1) {
			GError* _tmp15_;
			_tmp15_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_all_knowledge is a function.");
			_inner_error_ = _tmp15_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp16_ = data;
		_tmp17_ = zcd_remote_call_get_parameters (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ != 2) {
			GError* _tmp21_;
			_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_all_knowledge wants 2 parameters.");
			_inner_error_ = _tmp21_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp22_ = data;
		_tmp23_ = zcd_remote_call_get_parameters (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_list_get (_tmp24_, 0);
		iser0 = (zcdISerializable*) _tmp25_;
		_tmp26_ = data;
		_tmp27_ = zcd_remote_call_get_parameters (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = gee_list_get (_tmp28_, 1);
		iser1 = (zcdISerializable*) _tmp29_;
		_tmp30_ = iser0;
		_tmp31_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp30_);
		_tmp32_ = g_type_is_a (_tmp31_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp32_) {
			GError* _tmp33_;
			_tmp33_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_all_knowledge parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp33_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp34_ = iser1;
		_tmp35_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp34_);
		_tmp36_ = g_type_is_a (_tmp35_, NETSUKUKU_TYPE_COORDINATOR_KNOWLEDGE);
		if (!_tmp36_) {
			GError* _tmp37_;
			_tmp37_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_all_knowledge parameter 2 is not a CoordinatorKnowledge.");
			_inner_error_ = _tmp37_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp38_ = iser0;
		_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp39_;
		_tmp40_ = iser1;
		_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, NETSUKUKU_TYPE_COORDINATOR_KNOWLEDGE, NetsukukuCoordinatorKnowledge));
		coordinator_knowledge = _tmp41_;
		_tmp42_ = gnode;
		_tmp43_ = coordinator_knowledge;
		netsukuku_icoord_duplicate_all_knowledge ((NetsukukuICoord*) self, _tmp42_, _tmp43_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (coordinator_knowledge);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp44_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp44_;
		_g_object_unref0 (coordinator_knowledge);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser1);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp45_ = pieces;
	_tmp45__length1 = pieces_length1;
	_tmp46_ = _tmp45_[0];
	if (g_strcmp0 (_tmp46_, "reserve") == 0) {
		gchar** _tmp47_;
		gint _tmp47__length1;
		zcdRemoteCall* _tmp49_;
		GeeList* _tmp50_;
		GeeList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		zcdRemoteCall* _tmp55_;
		GeeList* _tmp56_;
		GeeList* _tmp57_;
		gpointer _tmp58_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp59_;
		GType _tmp60_ = 0UL;
		gboolean _tmp61_ = FALSE;
		zcdISerializable* _tmp63_;
		NetsukukuPartialNIP* _tmp64_;
		NetsukukuPartialNIP* gnode;
		NetsukukuPartialNIP* _tmp65_;
		NetsukukuHookReservation* _tmp66_ = NULL;
		NetsukukuHookReservation* ret;
		NetsukukuHookReservation* _tmp67_;
		_tmp47_ = pieces;
		_tmp47__length1 = pieces_length1;
		if (_tmp47__length1 != 1) {
			GError* _tmp48_;
			_tmp48_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve is a function.");
			_inner_error_ = _tmp48_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp49_ = data;
		_tmp50_ = zcd_remote_call_get_parameters (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = gee_collection_get_size ((GeeCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		if (_tmp53_ != 1) {
			GError* _tmp54_;
			_tmp54_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve wants 1 parameters.");
			_inner_error_ = _tmp54_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp55_ = data;
		_tmp56_ = zcd_remote_call_get_parameters (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = gee_list_get (_tmp57_, 0);
		iser0 = (zcdISerializable*) _tmp58_;
		_tmp59_ = iser0;
		_tmp60_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp59_);
		_tmp61_ = g_type_is_a (_tmp60_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp61_) {
			GError* _tmp62_;
			_tmp62_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp62_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp63_ = iser0;
		_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp64_;
		_tmp65_ = gnode;
		_tmp66_ = netsukuku_icoord_reserve ((NetsukukuICoord*) self, _tmp65_, &_inner_error_);
		ret = _tmp66_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp67_ = ret;
		if (_tmp67_ == NULL) {
			zcdSerializableNone* _tmp68_;
			_tmp68_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp68_;
			_g_object_unref0 (ret);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			NetsukukuHookReservation* _tmp69_;
			zcdISerializable* _tmp70_;
			_tmp69_ = ret;
			_tmp70_ = _g_object_ref0 ((zcdISerializable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, NETSUKUKU_TYPE_HOOK_RESERVATION, NetsukukuHookReservation));
			result = _tmp70_;
			_g_object_unref0 (ret);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_object_unref0 (ret);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser0);
	}
	_tmp71_ = pieces;
	_tmp71__length1 = pieces_length1;
	_tmp72_ = _tmp71_[0];
	if (g_strcmp0 (_tmp72_, "free") == 0) {
		gchar** _tmp73_;
		gint _tmp73__length1;
		zcdRemoteCall* _tmp75_;
		GeeList* _tmp76_;
		GeeList* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		zcdRemoteCall* _tmp81_;
		GeeList* _tmp82_;
		GeeList* _tmp83_;
		gpointer _tmp84_ = NULL;
		zcdISerializable* iser0;
		zcdRemoteCall* _tmp85_;
		GeeList* _tmp86_;
		GeeList* _tmp87_;
		gpointer _tmp88_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp89_;
		GType _tmp90_ = 0UL;
		gboolean _tmp91_ = FALSE;
		zcdISerializable* _tmp93_;
		GType _tmp94_ = 0UL;
		gboolean _tmp95_ = FALSE;
		zcdISerializable* _tmp97_;
		NetsukukuPartialNIP* _tmp98_;
		NetsukukuPartialNIP* gnode;
		zcdISerializable* _tmp99_;
		zcdSerializableInt* _tmp100_;
		zcdSerializableInt* pos;
		NetsukukuPartialNIP* _tmp101_;
		zcdSerializableInt* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		zcdSerializableNone* _tmp105_;
		_tmp73_ = pieces;
		_tmp73__length1 = pieces_length1;
		if (_tmp73__length1 != 1) {
			GError* _tmp74_;
			_tmp74_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "free is a function.");
			_inner_error_ = _tmp74_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp75_ = data;
		_tmp76_ = zcd_remote_call_get_parameters (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = gee_collection_get_size ((GeeCollection*) _tmp77_);
		_tmp79_ = _tmp78_;
		if (_tmp79_ != 2) {
			GError* _tmp80_;
			_tmp80_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "free wants 2 parameters.");
			_inner_error_ = _tmp80_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp81_ = data;
		_tmp82_ = zcd_remote_call_get_parameters (_tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = gee_list_get (_tmp83_, 0);
		iser0 = (zcdISerializable*) _tmp84_;
		_tmp85_ = data;
		_tmp86_ = zcd_remote_call_get_parameters (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp88_ = gee_list_get (_tmp87_, 1);
		iser1 = (zcdISerializable*) _tmp88_;
		_tmp89_ = iser0;
		_tmp90_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp89_);
		_tmp91_ = g_type_is_a (_tmp90_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp91_) {
			GError* _tmp92_;
			_tmp92_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "free parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp92_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp93_ = iser1;
		_tmp94_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp93_);
		_tmp95_ = g_type_is_a (_tmp94_, ZCD_TYPE_SERIALIZABLE_INT);
		if (!_tmp95_) {
			GError* _tmp96_;
			_tmp96_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "free parameter 2 is not a int.");
			_inner_error_ = _tmp96_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp97_ = iser0;
		_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp98_;
		_tmp99_ = iser1;
		_tmp100_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
		pos = _tmp100_;
		_tmp101_ = gnode;
		_tmp102_ = pos;
		_tmp103_ = zcd_serializable_int_get_i (_tmp102_);
		_tmp104_ = _tmp103_;
		netsukuku_icoord_free ((NetsukukuICoord*) self, _tmp101_, _tmp104_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pos);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp105_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp105_;
		_g_object_unref0 (pos);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser1);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp106_ = pieces;
	_tmp106__length1 = pieces_length1;
	_tmp107_ = _tmp106_[0];
	if (g_strcmp0 (_tmp107_, "duplicate_free") == 0) {
		gchar** _tmp108_;
		gint _tmp108__length1;
		zcdRemoteCall* _tmp110_;
		GeeList* _tmp111_;
		GeeList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		zcdRemoteCall* _tmp116_;
		GeeList* _tmp117_;
		GeeList* _tmp118_;
		gpointer _tmp119_ = NULL;
		zcdISerializable* iser0;
		zcdRemoteCall* _tmp120_;
		GeeList* _tmp121_;
		GeeList* _tmp122_;
		gpointer _tmp123_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp124_;
		GType _tmp125_ = 0UL;
		gboolean _tmp126_ = FALSE;
		zcdISerializable* _tmp128_;
		GType _tmp129_ = 0UL;
		gboolean _tmp130_ = FALSE;
		zcdISerializable* _tmp132_;
		NetsukukuPartialNIP* _tmp133_;
		NetsukukuPartialNIP* gnode;
		zcdISerializable* _tmp134_;
		zcdSerializableInt* _tmp135_;
		zcdSerializableInt* pos;
		NetsukukuPartialNIP* _tmp136_;
		zcdSerializableInt* _tmp137_;
		gint _tmp138_;
		gint _tmp139_;
		zcdSerializableNone* _tmp140_;
		_tmp108_ = pieces;
		_tmp108__length1 = pieces_length1;
		if (_tmp108__length1 != 1) {
			GError* _tmp109_;
			_tmp109_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_free is a function.");
			_inner_error_ = _tmp109_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp110_ = data;
		_tmp111_ = zcd_remote_call_get_parameters (_tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = gee_collection_get_size ((GeeCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		if (_tmp114_ != 2) {
			GError* _tmp115_;
			_tmp115_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_free wants 2 parameters.");
			_inner_error_ = _tmp115_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp116_ = data;
		_tmp117_ = zcd_remote_call_get_parameters (_tmp116_);
		_tmp118_ = _tmp117_;
		_tmp119_ = gee_list_get (_tmp118_, 0);
		iser0 = (zcdISerializable*) _tmp119_;
		_tmp120_ = data;
		_tmp121_ = zcd_remote_call_get_parameters (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = gee_list_get (_tmp122_, 1);
		iser1 = (zcdISerializable*) _tmp123_;
		_tmp124_ = iser0;
		_tmp125_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp124_);
		_tmp126_ = g_type_is_a (_tmp125_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp126_) {
			GError* _tmp127_;
			_tmp127_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_free parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp127_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp128_ = iser1;
		_tmp129_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp128_);
		_tmp130_ = g_type_is_a (_tmp129_, ZCD_TYPE_SERIALIZABLE_INT);
		if (!_tmp130_) {
			GError* _tmp131_;
			_tmp131_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_free parameter 2 is not a int.");
			_inner_error_ = _tmp131_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp132_ = iser0;
		_tmp133_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp133_;
		_tmp134_ = iser1;
		_tmp135_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
		pos = _tmp135_;
		_tmp136_ = gnode;
		_tmp137_ = pos;
		_tmp138_ = zcd_serializable_int_get_i (_tmp137_);
		_tmp139_ = _tmp138_;
		netsukuku_icoord_duplicate_free ((NetsukukuICoord*) self, _tmp136_, _tmp139_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pos);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp140_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp140_;
		_g_object_unref0 (pos);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser1);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp141_ = pieces;
	_tmp141__length1 = pieces_length1;
	_tmp142_ = _tmp141_[0];
	if (g_strcmp0 (_tmp142_, "register_bnode") == 0) {
		gchar** _tmp143_;
		gint _tmp143__length1;
		zcdRemoteCall* _tmp145_;
		GeeList* _tmp146_;
		GeeList* _tmp147_;
		gint _tmp148_;
		gint _tmp149_;
		zcdRemoteCall* _tmp151_;
		GeeList* _tmp152_;
		GeeList* _tmp153_;
		gpointer _tmp154_ = NULL;
		zcdISerializable* iser0;
		zcdRemoteCall* _tmp155_;
		GeeList* _tmp156_;
		GeeList* _tmp157_;
		gpointer _tmp158_ = NULL;
		zcdISerializable* iser1;
		zcdRemoteCall* _tmp159_;
		GeeList* _tmp160_;
		GeeList* _tmp161_;
		gpointer _tmp162_ = NULL;
		zcdISerializable* iser2;
		zcdRemoteCall* _tmp163_;
		GeeList* _tmp164_;
		GeeList* _tmp165_;
		gpointer _tmp166_ = NULL;
		zcdISerializable* iser3;
		zcdRemoteCall* _tmp167_;
		GeeList* _tmp168_;
		GeeList* _tmp169_;
		gpointer _tmp170_ = NULL;
		zcdISerializable* iser4;
		zcdISerializable* _tmp171_;
		GType _tmp172_ = 0UL;
		gboolean _tmp173_ = FALSE;
		zcdISerializable* _tmp175_;
		GType _tmp176_ = 0UL;
		gboolean _tmp177_ = FALSE;
		zcdISerializable* _tmp179_;
		GType _tmp180_ = 0UL;
		gboolean _tmp181_ = FALSE;
		zcdISerializable* _tmp183_;
		GType _tmp184_ = 0UL;
		gboolean _tmp185_ = FALSE;
		zcdISerializable* _tmp187_;
		GType _tmp188_ = 0UL;
		gboolean _tmp189_ = FALSE;
		zcdISerializable* _tmp191_;
		NetsukukuPartialNIP* _tmp192_;
		NetsukukuPartialNIP* gnode;
		zcdISerializable* _tmp193_;
		NetsukukuNIP* _tmp194_;
		NetsukukuNIP* nip;
		zcdISerializable* _tmp195_;
		zcdSerializableBool* _tmp196_;
		zcdSerializableBool* is_border;
		zcdISerializable* _tmp197_;
		zcdSerializableBool* _tmp198_;
		zcdSerializableBool* has_tunnel;
		zcdISerializable* _tmp199_;
		zcdSerializableBool* _tmp200_;
		zcdSerializableBool* is_willing;
		NetsukukuPartialNIP* _tmp201_;
		NetsukukuNIP* _tmp202_;
		zcdSerializableBool* _tmp203_;
		gboolean _tmp204_;
		gboolean _tmp205_;
		zcdSerializableBool* _tmp206_;
		gboolean _tmp207_;
		gboolean _tmp208_;
		zcdSerializableBool* _tmp209_;
		gboolean _tmp210_;
		gboolean _tmp211_;
		gboolean _tmp212_ = FALSE;
		gboolean ret;
		gboolean _tmp213_;
		zcdSerializableBool* _tmp214_;
		_tmp143_ = pieces;
		_tmp143__length1 = pieces_length1;
		if (_tmp143__length1 != 1) {
			GError* _tmp144_;
			_tmp144_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode is a function.");
			_inner_error_ = _tmp144_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp145_ = data;
		_tmp146_ = zcd_remote_call_get_parameters (_tmp145_);
		_tmp147_ = _tmp146_;
		_tmp148_ = gee_collection_get_size ((GeeCollection*) _tmp147_);
		_tmp149_ = _tmp148_;
		if (_tmp149_ != 5) {
			GError* _tmp150_;
			_tmp150_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode wants 5 parameters.");
			_inner_error_ = _tmp150_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp151_ = data;
		_tmp152_ = zcd_remote_call_get_parameters (_tmp151_);
		_tmp153_ = _tmp152_;
		_tmp154_ = gee_list_get (_tmp153_, 0);
		iser0 = (zcdISerializable*) _tmp154_;
		_tmp155_ = data;
		_tmp156_ = zcd_remote_call_get_parameters (_tmp155_);
		_tmp157_ = _tmp156_;
		_tmp158_ = gee_list_get (_tmp157_, 1);
		iser1 = (zcdISerializable*) _tmp158_;
		_tmp159_ = data;
		_tmp160_ = zcd_remote_call_get_parameters (_tmp159_);
		_tmp161_ = _tmp160_;
		_tmp162_ = gee_list_get (_tmp161_, 2);
		iser2 = (zcdISerializable*) _tmp162_;
		_tmp163_ = data;
		_tmp164_ = zcd_remote_call_get_parameters (_tmp163_);
		_tmp165_ = _tmp164_;
		_tmp166_ = gee_list_get (_tmp165_, 3);
		iser3 = (zcdISerializable*) _tmp166_;
		_tmp167_ = data;
		_tmp168_ = zcd_remote_call_get_parameters (_tmp167_);
		_tmp169_ = _tmp168_;
		_tmp170_ = gee_list_get (_tmp169_, 4);
		iser4 = (zcdISerializable*) _tmp170_;
		_tmp171_ = iser0;
		_tmp172_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp171_);
		_tmp173_ = g_type_is_a (_tmp172_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp173_) {
			GError* _tmp174_;
			_tmp174_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp174_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp175_ = iser1;
		_tmp176_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp175_);
		_tmp177_ = g_type_is_a (_tmp176_, NETSUKUKU_TYPE_NIP);
		if (!_tmp177_) {
			GError* _tmp178_;
			_tmp178_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 2 is not a NIP.");
			_inner_error_ = _tmp178_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp179_ = iser2;
		_tmp180_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp179_);
		_tmp181_ = g_type_is_a (_tmp180_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp181_) {
			GError* _tmp182_;
			_tmp182_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 3 is not a SerializableBool.");
			_inner_error_ = _tmp182_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp183_ = iser3;
		_tmp184_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp183_);
		_tmp185_ = g_type_is_a (_tmp184_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp185_) {
			GError* _tmp186_;
			_tmp186_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 4 is not a SerializableBool.");
			_inner_error_ = _tmp186_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp187_ = iser4;
		_tmp188_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp187_);
		_tmp189_ = g_type_is_a (_tmp188_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp189_) {
			GError* _tmp190_;
			_tmp190_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 5 is not a SerializableBool.");
			_inner_error_ = _tmp190_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp191_ = iser0;
		_tmp192_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp191_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp192_;
		_tmp193_ = iser1;
		_tmp194_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp193_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp194_;
		_tmp195_ = iser2;
		_tmp196_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp195_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		is_border = _tmp196_;
		_tmp197_ = iser3;
		_tmp198_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		has_tunnel = _tmp198_;
		_tmp199_ = iser4;
		_tmp200_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		is_willing = _tmp200_;
		_tmp201_ = gnode;
		_tmp202_ = nip;
		_tmp203_ = is_border;
		_tmp204_ = zcd_serializable_bool_get_b (_tmp203_);
		_tmp205_ = _tmp204_;
		_tmp206_ = has_tunnel;
		_tmp207_ = zcd_serializable_bool_get_b (_tmp206_);
		_tmp208_ = _tmp207_;
		_tmp209_ = is_willing;
		_tmp210_ = zcd_serializable_bool_get_b (_tmp209_);
		_tmp211_ = _tmp210_;
		_tmp212_ = netsukuku_icoord_register_bnode ((NetsukukuICoord*) self, _tmp201_, _tmp202_, _tmp205_, _tmp208_, _tmp211_, &_inner_error_);
		ret = _tmp212_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (is_willing);
			_g_object_unref0 (has_tunnel);
			_g_object_unref0 (is_border);
			_g_object_unref0 (nip);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp213_ = ret;
		_tmp214_ = zcd_serializable_bool_new (_tmp213_);
		result = (zcdISerializable*) _tmp214_;
		_g_object_unref0 (is_willing);
		_g_object_unref0 (has_tunnel);
		_g_object_unref0 (is_border);
		_g_object_unref0 (nip);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser4);
		_g_object_unref0 (iser3);
		_g_object_unref0 (iser2);
		_g_object_unref0 (iser1);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp215_ = pieces;
	_tmp215__length1 = pieces_length1;
	_tmp216_ = _tmp215_[0];
	if (g_strcmp0 (_tmp216_, "report_status") == 0) {
		gchar** _tmp217_;
		gint _tmp217__length1;
		zcdRemoteCall* _tmp219_;
		GeeList* _tmp220_;
		GeeList* _tmp221_;
		gint _tmp222_;
		gint _tmp223_;
		GeeList* _tmp225_ = NULL;
		GeeList* _tmp226_;
		GeeList* _tmp227_;
		zcdListISerializable* _tmp228_;
		zcdISerializable* _tmp229_;
		_tmp217_ = pieces;
		_tmp217__length1 = pieces_length1;
		if (_tmp217__length1 != 1) {
			GError* _tmp218_;
			_tmp218_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "report_status is a function.");
			_inner_error_ = _tmp218_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp219_ = data;
		_tmp220_ = zcd_remote_call_get_parameters (_tmp219_);
		_tmp221_ = _tmp220_;
		_tmp222_ = gee_collection_get_size ((GeeCollection*) _tmp221_);
		_tmp223_ = _tmp222_;
		if (_tmp223_ != 0) {
			GError* _tmp224_;
			_tmp224_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "report_status wants no parameters.");
			_inner_error_ = _tmp224_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp225_ = netsukuku_icoord_report_status ((NetsukukuICoord*) self, &_inner_error_);
		_tmp226_ = _tmp225_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp227_ = _tmp226_;
		_tmp228_ = zcd_list_iserializable_new_with_backer (_tmp227_);
		_tmp229_ = (zcdISerializable*) _tmp228_;
		_g_object_unref0 (_tmp227_);
		result = _tmp229_;
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp230_ = caller;
	_tmp231_ = data;
	_tmp232_ = ZCD_RPC_DISPATCHER_CLASS (netsukuku_coord_parent_class)->_dispatch ((zcdRPCDispatcher*) G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer), _tmp230_, _tmp231_, &_inner_error_);
	_tmp233_ = _tmp232_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = _tmp233_;
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static GeeList* netsukuku_coord_real_report_status (NetsukukuICoord* base, GError** error) {
	NetsukukuCoord * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	netsukuku_log_debug ("Coord: report_status started");
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_INFO_COORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		NetsukukuMapRoute* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _level_of_nodes;
		_tmp1_ = ((NetsukukuPeerToPeer*) self)->maproute;
		_tmp2_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_level_of_nodes = _tmp3_ - 1;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gint _tmp8_;
				gint _level_of_gnode;
				gint _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gint* _tmp14_ = NULL;
				gint* _tmp15_;
				gint _tmp15__length1;
				NetsukukuPartialNIP* _tmp16_;
				NetsukukuPartialNIP* _tmp17_;
				NetsukukuPartialNIP* actual_coord;
				gint _tmp32_;
				NetsukukuCoordinator* _tmp33_ = NULL;
				NetsukukuCoordinator* coordinator;
				NetsukukuCoordinator* _tmp34_;
				NetsukukuCoordinatorKnowledge* _tmp35_ = NULL;
				NetsukukuCoordinatorKnowledge* knowledge;
				NetsukukuInfoCoord* _tmp36_;
				NetsukukuInfoCoord* info_coord;
				NetsukukuInfoCoord* _tmp37_;
				gint _tmp38_;
				NetsukukuInfoCoord* _tmp39_;
				NetsukukuCoordinatorKnowledge* _tmp40_;
				NetsukukuCoordinatorKnowledge* _tmp41_;
				NetsukukuInfoCoord* _tmp42_;
				NetsukukuCoordinator* _tmp43_;
				gboolean _tmp44_;
				gboolean _tmp45_;
				NetsukukuInfoCoord* _tmp46_;
				NetsukukuPartialNIP* _tmp47_;
				NetsukukuPartialNIP* _tmp48_;
				GeeArrayList* _tmp49_;
				NetsukukuInfoCoord* _tmp50_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = _level_of_nodes;
					_level_of_nodes = _tmp6_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = _level_of_nodes;
				if (!(_tmp7_ >= 0)) {
					break;
				}
				_tmp8_ = _level_of_nodes;
				_level_of_gnode = _tmp8_ + 1;
				_tmp9_ = _level_of_gnode;
				_tmp10_ = g_strdup_printf ("%i", _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat ("Coord: report_status level ", _tmp11_, NULL);
				_tmp13_ = _tmp12_;
				netsukuku_log_debug (_tmp13_);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				_tmp14_ = g_new0 (gint, 0);
				_tmp15_ = _tmp14_;
				_tmp15__length1 = 0;
				_tmp16_ = netsukuku_partial_nip_new (_tmp15_, 0);
				_tmp17_ = _tmp16_;
				_tmp15_ = (g_free (_tmp15_), NULL);
				actual_coord = _tmp17_;
				{
					NetsukukuCoord_hkey* _tmp18_;
					NetsukukuCoord_hkey* key;
					NetsukukuCoord_hkey* _tmp19_;
					gint _tmp20_;
					NetsukukuCoord_hkey* _tmp21_;
					NetsukukuMapRoute* _tmp22_;
					NetsukukuNIP* _tmp23_;
					NetsukukuNIP* _tmp24_;
					NetsukukuNIP* _tmp25_;
					NetsukukuCoord_hkey* _tmp26_;
					NetsukukuNIP* _tmp27_ = NULL;
					NetsukukuNIP* _tmp28_;
					NetsukukuPartialNIP* _tmp29_ = NULL;
					NetsukukuPartialNIP* _tmp30_;
					NetsukukuPartialNIP* _tmp31_;
					_tmp18_ = netsukuku_coord_hkey_new ();
					key = _tmp18_;
					_tmp19_ = key;
					_tmp20_ = _level_of_gnode;
					_tmp19_->level_of_gnode = _tmp20_;
					_tmp21_ = key;
					_tmp22_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp23_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = _g_object_ref0 (_tmp24_);
					_g_object_unref0 (_tmp21_->nip);
					_tmp21_->nip = _tmp25_;
					_tmp26_ = key;
					_tmp27_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = netsukuku_peer_to_peer_search_participant_as_nip ((NetsukukuPeerToPeer*) self, _tmp28_, 1, &_inner_error_);
					_tmp30_ = _tmp29_;
					_g_object_unref0 (_tmp28_);
					_tmp31_ = _tmp30_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (key);
						if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
							goto __catch32_netsukuku_peer_to_peer_error;
						}
						_g_object_unref0 (key);
						_g_object_unref0 (actual_coord);
						_g_object_unref0 (ret);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_object_unref0 (actual_coord);
					actual_coord = _tmp31_;
					_g_object_unref0 (key);
				}
				goto __finally32;
				__catch32_netsukuku_peer_to_peer_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					netsukuku_log_error ("Coord.report_status: no participants in Coord service.");
					_g_error_free0 (e);
				}
				__finally32:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (actual_coord);
					_g_object_unref0 (ret);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp32_ = _level_of_gnode;
				_tmp33_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp32_);
				coordinator = _tmp33_;
				_tmp34_ = coordinator;
				_tmp35_ = netsukuku_coordinator_report_status (_tmp34_);
				knowledge = _tmp35_;
				_tmp36_ = netsukuku_info_coord_new ();
				info_coord = _tmp36_;
				_tmp37_ = info_coord;
				_tmp38_ = _level_of_gnode;
				_tmp37_->level = _tmp38_;
				_tmp39_ = info_coord;
				_tmp40_ = knowledge;
				_tmp41_ = _g_object_ref0 (_tmp40_);
				_g_object_unref0 (_tmp39_->knowledge);
				_tmp39_->knowledge = _tmp41_;
				_tmp42_ = info_coord;
				_tmp43_ = coordinator;
				_tmp44_ = netsukuku_coordinator_get_is_main (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp42_->is_main = _tmp45_;
				_tmp46_ = info_coord;
				_tmp47_ = actual_coord;
				_tmp48_ = _g_object_ref0 (_tmp47_);
				_g_object_unref0 (_tmp46_->actual_coord);
				_tmp46_->actual_coord = _tmp48_;
				_tmp49_ = ret;
				_tmp50_ = info_coord;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
				_g_object_unref0 (info_coord);
				_g_object_unref0 (knowledge);
				_g_object_unref0 (coordinator);
				_g_object_unref0 (actual_coord);
			}
		}
	}
	result = (GeeList*) ret;
	return result;
}


static NetsukukuNIP* netsukuku_coord_real_h (NetsukukuPeerToPeer* base, GObject* k) {
	NetsukukuCoord * self;
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuCoord_hkey* _tmp1_;
	NetsukukuCoord_hkey* key;
	NetsukukuCoord_hkey* _tmp2_;
	NetsukukuNIP* _tmp3_;
	gint _tmp4_ = 0;
	gint* _tmp5_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	gint* _tmp15_;
	gint _tmp15__length1;
	NetsukukuNIP* _tmp16_;
	self = (NetsukukuCoord*) base;
	g_return_val_if_fail (k != NULL, NULL);
	_tmp0_ = k;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkey));
	key = _tmp1_;
	_tmp2_ = key;
	_tmp3_ = _tmp2_->nip;
	_tmp5_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp3_, &_tmp4_);
	positions = _tmp5_;
	positions_length1 = _tmp4_;
	_positions_size_ = positions_length1;
	{
		gint l;
		l = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gint _tmp9_;
				NetsukukuCoord_hkey* _tmp10_;
				gint _tmp11_;
				gint* _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				gint _tmp14_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = l;
					l = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = l;
				_tmp10_ = key;
				_tmp11_ = _tmp10_->level_of_gnode;
				if (!(_tmp9_ < _tmp11_)) {
					break;
				}
				_tmp12_ = positions;
				_tmp12__length1 = positions_length1;
				_tmp13_ = l;
				_tmp12_[_tmp13_] = 0;
				_tmp14_ = _tmp12_[_tmp13_];
			}
		}
	}
	_tmp15_ = positions;
	_tmp15__length1 = positions_length1;
	_tmp16_ = netsukuku_nip_new (_tmp15_, _tmp15__length1);
	result = _tmp16_;
	positions = (g_free (positions), NULL);
	_g_object_unref0 (key);
	return result;
}


NetsukukuCoordinator* netsukuku_coord_get_coordinator_for_gnode_at_level (NetsukukuCoord* self, gint l) {
	NetsukukuCoordinator* result = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coordinators;
	_tmp1_ = l;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, _tmp1_ - 1);
	result = (NetsukukuCoordinator*) _tmp2_;
	return result;
}


static void netsukuku_coord_set_coordinator_for_gnode_at_level (NetsukukuCoord* self, gint l) {
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_;
	gint _tmp8_;
	NetsukukuPartialNIP* _tmp9_ = NULL;
	NetsukukuPartialNIP* _tmp10_;
	NetsukukuCoordinator* _tmp11_;
	NetsukukuCoordinator* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_coordinators;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = l;
	_vala_assert (_tmp2_ == (_tmp3_ - 1), "_coordinators.size == l-1");
	_tmp4_ = self->priv->_coordinators;
	_tmp5_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp6_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = l;
	_tmp9_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = netsukuku_coordinator_new (_tmp10_, self);
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp10_);
}


void netsukuku_coord_initialize_coordinators (NetsukukuCoord* self) {
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_COORDINATOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_coordinators);
	self->priv->_coordinators = _tmp0_;
	{
		gint l;
		l = 1;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				NetsukukuMapRoute* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = l;
					l = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = l;
				_tmp5_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp6_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ <= _tmp7_)) {
					break;
				}
				_tmp8_ = l;
				netsukuku_coord_set_coordinator_for_gnode_at_level (self, _tmp8_);
			}
		}
	}
}


static void netsukuku_coord_real_stop_operations (NetsukukuPeerToPeer* base) {
	NetsukukuCoord * self;
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	self = (NetsukukuCoord*) base;
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = ipstr;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("Coord: stopping operations for ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	netsukuku_log_debug (_tmp13_);
	_g_free0 (_tmp13_);
	netsukuku_log_debug ("Coord: calling base");
	NETSUKUKU_PEER_TO_PEER_CLASS (netsukuku_coord_parent_class)->stop_operations (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer));
	netsukuku_log_debug ("Coord: base done");
	{
		gint l;
		l = 1;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_;
				gint _tmp17_;
				NetsukukuMapRoute* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				gint _tmp28_;
				NetsukukuCoordinator* _tmp29_ = NULL;
				NetsukukuCoordinator* coordinator;
				NetsukukuCoordinator* _tmp30_;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = l;
					l = _tmp16_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = l;
				_tmp18_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp19_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp18_);
				_tmp20_ = _tmp19_;
				if (!(_tmp17_ < (_tmp20_ + 1))) {
					break;
				}
				_tmp21_ = l;
				_tmp22_ = g_strdup_printf ("%i", _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = ipstr;
				_tmp25_ = string_to_string (_tmp24_);
				_tmp26_ = g_strconcat ("Coord: calling coordinator for level ", _tmp23_, " for ", _tmp25_, NULL);
				_tmp27_ = _tmp26_;
				netsukuku_log_debug (_tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp23_);
				_tmp28_ = l;
				_tmp29_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp28_);
				coordinator = _tmp29_;
				_tmp30_ = coordinator;
				netsukuku_coordinator_stop_operations (_tmp30_);
				_g_object_unref0 (coordinator);
			}
		}
	}
	_g_free0 (ipstr);
}


NetsukukuPartialNIP* netsukuku_coord_get_my_gnode_at_level (NetsukukuCoord* self, gint l) {
	NetsukukuPartialNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuPartialNIP* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = l;
	_tmp4_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


gint netsukuku_coord_get_level_of_gnode (NetsukukuCoord* self, NetsukukuPartialNIP* gnode) {
	gint result = 0;
	NetsukukuPartialNIP* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (gnode != NULL, 0);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_partial_nip_level_of_gnode (_tmp0_);
	result = _tmp1_;
	return result;
}


NetsukukuCoordinator* netsukuku_coord_get_coordinator_for_gnode (NetsukukuCoord* self, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuCoordinator* result = NULL;
	NetsukukuPartialNIP* _tmp0_;
	gint _tmp1_ = 0;
	gint level_of_gnode;
	gint _tmp2_;
	NetsukukuPartialNIP* _tmp3_ = NULL;
	NetsukukuPartialNIP* _tmp4_;
	NetsukukuPartialNIP* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gint _tmp13_;
	NetsukukuCoordinator* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_level_of_gnode (self, _tmp0_);
	level_of_gnode = _tmp1_;
	_tmp2_ = level_of_gnode;
	_tmp3_ = netsukuku_coord_get_my_gnode_at_level (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gnode;
	_tmp6_ = netsukuku_partial_nip_is_equal (_tmp4_, _tmp5_);
	_tmp7_ = !_tmp6_;
	_g_object_unref0 (_tmp4_);
	if (_tmp7_) {
		NetsukukuPartialNIP* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp8_ = gnode;
		_tmp9_ = netsukuku_partial_nip_to_string (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new_literal (NETSUKUKU_HOOKING_ERROR, NETSUKUKU_HOOKING_ERROR_INEXISTENT_GNODE, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_inner_error_ = _tmp12_;
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = level_of_gnode;
	_tmp14_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp13_);
	result = _tmp14_;
	return result;
}


/** Client-side helpers **/
NetsukukuHookReservation* netsukuku_coord_enter_into (NetsukukuCoord* self, gint level_of_gnode, NetsukukuNIP* nip, NetsukukuAggregatedNeighbour* neighbour_to_contact) {
	NetsukukuHookReservation* result = NULL;
	NetsukukuCoord_hkey* _tmp0_;
	NetsukukuCoord_hkey* key;
	NetsukukuCoord_hkey* _tmp1_;
	gint _tmp2_;
	NetsukukuCoord_hkey* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuCoord_hkey* _tmp6_;
	NetsukukuAggregatedNeighbour* _tmp7_;
	NetsukukuRmtCoordPeer* _tmp8_ = NULL;
	NetsukukuRmtCoordPeer* _peer;
	NetsukukuHookReservation* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = netsukuku_coord_hkey_new ();
	key = _tmp0_;
	_tmp1_ = key;
	_tmp2_ = level_of_gnode;
	_tmp1_->level_of_gnode = _tmp2_;
	_tmp3_ = key;
	_tmp4_ = nip;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_tmp3_->nip);
	_tmp3_->nip = _tmp5_;
	_tmp6_ = key;
	_tmp7_ = neighbour_to_contact;
	_tmp8_ = netsukuku_coord_peer (self, NULL, (GObject*) _tmp6_, _tmp7_);
	_peer = _tmp8_;
	ret = NULL;
	{
		NetsukukuRmtCoordPeer* _tmp9_;
		NetsukukuNIP* _tmp10_;
		gint _tmp11_;
		NetsukukuPartialNIP* _tmp12_ = NULL;
		NetsukukuPartialNIP* _tmp13_;
		NetsukukuHookReservation* _tmp14_ = NULL;
		NetsukukuHookReservation* _tmp15_;
		NetsukukuHookReservation* _tmp16_;
		_tmp9_ = _peer;
		_tmp10_ = nip;
		_tmp11_ = level_of_gnode;
		_tmp12_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = netsukuku_icoord_reserve ((NetsukukuICoord*) _tmp9_, _tmp13_, &_inner_error_);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp13_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch33_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch33_netsukuku_hooking_error;
			}
			_g_object_unref0 (ret);
			_g_object_unref0 (_peer);
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (ret);
		ret = _tmp16_;
	}
	goto __finally33;
	__catch33_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->code;
		_tmp19_ = g_strdup_printf ("%i", _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = g_strconcat ("Coord: got RPCError code ", _tmp20_, ": ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		netsukuku_log_info (_tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp20_);
		_g_error_free0 (e);
	}
	goto __finally33;
	__catch33_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		GError* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->code;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		_tmp32_ = string_to_string (_tmp31_);
		_tmp33_ = g_strconcat ("Coord: got HookingError code ", _tmp29_, ": ", _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		netsukuku_log_info (_tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp29_);
		_g_error_free0 (e);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ret);
		_g_object_unref0 (_peer);
		_g_object_unref0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = ret;
	_g_object_unref0 (_peer);
	_g_object_unref0 (key);
	return result;
}


NetsukukuBookings* netsukuku_coord_get_bookings (NetsukukuCoord* self, gint level_of_gnode) {
	NetsukukuBookings* result = NULL;
	gint _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuBookings* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = level_of_gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp0_);
	coordinator = _tmp1_;
	_tmp2_ = netsukuku_coordinator_get_bookings (coordinator);
	result = _tmp2_;
	_g_object_unref0 (coordinator);
	return result;
}


gint netsukuku_coord_get_last_assigned_elderliness (NetsukukuCoord* self, gint level_of_gnode) {
	gint result = 0;
	gint _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = level_of_gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp0_);
	coordinator = _tmp1_;
	_tmp2_ = coordinator->last_assigned_elderliness;
	result = _tmp2_;
	_g_object_unref0 (coordinator);
	return result;
}


NetsukukuBnodeList* netsukuku_coord_get_bnode_list (NetsukukuCoord* self, gint level_of_gnode) {
	NetsukukuBnodeList* result = NULL;
	gint _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuBnodeList* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = level_of_gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp0_);
	coordinator = _tmp1_;
	_tmp2_ = netsukuku_coordinator_get_bnode_list (coordinator);
	result = _tmp2_;
	_g_object_unref0 (coordinator);
	return result;
}


/** Remotables **/
static NetsukukuHookReservation* netsukuku_coord_real_reserve (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuCoord * self;
	NetsukukuHookReservation* result = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuHookReservation* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = netsukuku_coordinator_reserve (coordinator);
	result = _tmp2_;
	_g_object_unref0 (coordinator);
	return result;
}


static void netsukuku_coord_real_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error) {
	NetsukukuCoord * self;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = pos;
	netsukuku_coordinator_free (coordinator, _tmp2_);
	_g_object_unref0 (coordinator);
}


static void netsukuku_coord_real_duplicate_all_knowledge (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuCoordinatorKnowledge* coordinator_knowledge, GError** error) {
	NetsukukuCoord * self;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuCoordinatorKnowledge* _tmp2_;
	NetsukukuBookings* _tmp3_;
	NetsukukuBookings* _tmp4_;
	gint _tmp5_;
	NetsukukuCoordinatorKnowledge* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	NetsukukuCoordinatorKnowledge* _tmp12_;
	NetsukukuBnodeList* _tmp13_;
	NetsukukuBnodeList* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_if_fail (gnode != NULL);
	g_return_if_fail (coordinator_knowledge != NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = coordinator_knowledge;
	_tmp3_ = netsukuku_coordinator_knowledge_get_bookings (_tmp2_);
	_tmp4_ = _tmp3_;
	netsukuku_coordinator_add_bookings (coordinator, _tmp4_);
	_tmp5_ = coordinator->last_assigned_elderliness;
	_tmp6_ = coordinator_knowledge;
	_tmp7_ = netsukuku_coordinator_knowledge_get_last_assigned_elderliness (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp5_ < _tmp8_) {
		NetsukukuCoordinatorKnowledge* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = coordinator_knowledge;
		_tmp10_ = netsukuku_coordinator_knowledge_get_last_assigned_elderliness (_tmp9_);
		_tmp11_ = _tmp10_;
		coordinator->last_assigned_elderliness = _tmp11_;
	}
	_tmp12_ = coordinator_knowledge;
	_tmp13_ = netsukuku_coordinator_knowledge_get_bnode_list (_tmp12_);
	_tmp14_ = _tmp13_;
	netsukuku_coordinator_add_bnode_list (coordinator, _tmp14_);
	_g_object_unref0 (coordinator);
}


static void netsukuku_coord_real_duplicate_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error) {
	NetsukukuCoord * self;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = pos;
	netsukuku_coordinator_force_remove (coordinator, _tmp2_);
	_g_object_unref0 (coordinator);
}


static gboolean netsukuku_coord_real_register_bnode (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing, GError** error) {
	NetsukukuCoord * self;
	gboolean result = FALSE;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuNIP* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_val_if_fail (gnode != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp2_ = nip;
	_tmp3_ = is_border;
	_tmp4_ = has_tunnel;
	_tmp5_ = is_willing;
	_tmp6_ = netsukuku_coordinator_register_bnode (coordinator, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (coordinator);
	return result;
}


/** A new node in the service
          */
void netsukuku_coord_node_joins_maproute (NetsukukuCoord* self, gint level_of_nodes, gint pos) {
	gint _tmp0_;
	gint level_of_gnode;
	gint _tmp1_;
	NetsukukuCoordinator* _tmp2_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuCoordinator* _tmp3_;
	NetsukukuCoordinator* _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	NetsukukuCoordinator* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = level_of_nodes;
	level_of_gnode = _tmp0_ + 1;
	_tmp1_ = level_of_gnode;
	_tmp2_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp1_);
	coordinator = _tmp2_;
	_tmp3_ = coordinator;
	netsukuku_coordinator_map_has_changed (_tmp3_);
	_tmp4_ = coordinator;
	_tmp5_ = pos;
	netsukuku_coordinator_force_remove (_tmp4_, _tmp5_);
	_tmp7_ = coordinator;
	_tmp8_ = netsukuku_coordinator_get_was_main (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		NetsukukuCoordinator* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = coordinator;
		_tmp11_ = netsukuku_coordinator_get_is_main (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp13_ = _tmp6_;
	if (_tmp13_) {
		gint _tmp14_;
		_tmp14_ = level_of_gnode;
		netsukuku_coord_communicate_to_new_coordinator (self, _tmp14_);
	}
	_g_object_unref0 (coordinator);
}


static void netsukuku_coord_impl_communicate_to_new_coordinator (NetsukukuCoord* self, gint level_of_gnode, GError** error) {
	NetsukukuCoord_hkey* _tmp0_;
	NetsukukuCoord_hkey* key;
	gint _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuRmtCoordPeer* _tmp6_ = NULL;
	NetsukukuRmtCoordPeer* _peer;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	NetsukukuPartialNIP* _tmp13_ = NULL;
	NetsukukuPartialNIP* _tmp14_;
	gint _tmp15_;
	NetsukukuBookings* _tmp16_ = NULL;
	NetsukukuBookings* _tmp17_;
	gint _tmp18_;
	gint _tmp19_ = 0;
	gint _tmp20_;
	NetsukukuBnodeList* _tmp21_ = NULL;
	NetsukukuBnodeList* _tmp22_;
	NetsukukuCoordinatorKnowledge* _tmp23_;
	NetsukukuCoordinatorKnowledge* _tmp24_;
	NetsukukuCoordinatorKnowledge* coordinator_knowledge;
	gint _tmp25_;
	NetsukukuPartialNIP* _tmp26_ = NULL;
	NetsukukuPartialNIP* _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coord.communicate_to_new_coordinator");
	_tmp0_ = netsukuku_coord_hkey_new ();
	key = _tmp0_;
	_tmp1_ = level_of_gnode;
	key->level_of_gnode = _tmp1_;
	_tmp2_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp3_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (key->nip);
	key->nip = _tmp5_;
	_tmp6_ = netsukuku_coord_peer (self, NULL, (GObject*) key, NULL);
	_peer = _tmp6_;
	_tmp7_ = level_of_gnode;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("Coord: communicating my previous records to new Coord at level ", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	netsukuku_log_debug (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = level_of_gnode;
	_tmp13_ = netsukuku_coord_get_my_gnode_at_level (self, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = level_of_gnode;
	_tmp16_ = netsukuku_coord_get_bookings (self, _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = level_of_gnode;
	_tmp19_ = netsukuku_coord_get_last_assigned_elderliness (self, _tmp18_);
	_tmp20_ = level_of_gnode;
	_tmp21_ = netsukuku_coord_get_bnode_list (self, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = netsukuku_coordinator_knowledge_new (_tmp14_, _tmp17_, _tmp19_, _tmp22_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (_tmp14_);
	coordinator_knowledge = _tmp24_;
	_tmp25_ = level_of_gnode;
	_tmp26_ = netsukuku_coord_get_my_gnode_at_level (self, _tmp25_);
	_tmp27_ = _tmp26_;
	netsukuku_icoord_duplicate_all_knowledge ((NetsukukuICoord*) _peer, _tmp27_, coordinator_knowledge, &_inner_error_);
	_g_object_unref0 (_tmp27_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (coordinator_knowledge);
		_g_object_unref0 (_peer);
		_g_object_unref0 (key);
		return;
	}
	_g_object_unref0 (coordinator_knowledge);
	_g_object_unref0 (_peer);
	_g_object_unref0 (key);
}


static void* netsukuku_coord_helper_communicate_to_new_coordinator (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coord_communicate_to_new_coordinator* tuple_p;
	NetsukukuCoord* _tmp1_;
	NetsukukuCoord* _tmp2_;
	NetsukukuCoord* self_save;
	gint _tmp3_;
	gint level_of_gnode_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coord_communicate_to_new_coordinator*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).level_of_gnode;
	level_of_gnode_save = _tmp3_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coord_impl_communicate_to_new_coordinator (self_save, level_of_gnode_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_coord_communicate_to_new_coordinator (NetsukukuCoord* self, gint level_of_gnode) {
	Netsukukustruct_helper_Coord_communicate_to_new_coordinator arg = {0};
	NetsukukuCoord* _tmp0_;
	gint _tmp1_;
	TaskletsTasklet* _tmp2_ = NULL;
	TaskletsTasklet* _tmp3_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coord_communicate_to_new_coordinator));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = level_of_gnode;
	arg.level_of_gnode = _tmp1_;
	_tmp2_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_coord_helper_communicate_to_new_coordinator, &arg, FALSE, -1);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	netsukuku_struct_helper_coord_communicate_to_new_coordinator_destroy (&arg);
}


/** A deleted node in the service
          */
void netsukuku_coord_node_exits_maproute (NetsukukuCoord* self, gint level_of_nodes, gint pos) {
	gint _tmp0_;
	gint level_of_gnode;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	g_return_if_fail (self != NULL);
	_tmp0_ = level_of_nodes;
	level_of_gnode = _tmp0_ + 1;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, level_of_gnode);
	coordinator = _tmp1_;
	netsukuku_coordinator_map_has_changed (coordinator);
	_g_object_unref0 (coordinator);
}


/** We now have a valid map, I could have become a coordinator
          */
void netsukuku_coord_coord_has_valid_map (NetsukukuCoord* self) {
	g_return_if_fail (self != NULL);
	{
		gint level_of_gnode;
		level_of_gnode = 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				NetsukukuMapRoute* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				NetsukukuCoordinator* _tmp8_ = NULL;
				NetsukukuCoordinator* coordinator;
				NetsukukuCoordinator* _tmp9_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = level_of_gnode;
					level_of_gnode = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = level_of_gnode;
				_tmp4_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp5_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < (_tmp6_ + 1))) {
					break;
				}
				_tmp7_ = level_of_gnode;
				_tmp8_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp7_);
				coordinator = _tmp8_;
				_tmp9_ = coordinator;
				netsukuku_coordinator_map_has_changed (_tmp9_);
				_g_object_unref0 (coordinator);
			}
		}
	}
}


static void netsukuku_coord_class_init (NetsukukuCoordClass * klass) {
	netsukuku_coord_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCoordPrivate));
	ZCD_RPC_DISPATCHER_CLASS (klass)->_dispatch = netsukuku_coord_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_coord_real_h;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->stop_operations = netsukuku_coord_real_stop_operations;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coord_finalize;
}


static void netsukuku_coord_netsukuku_icoord_interface_init (NetsukukuICoordIface * iface) {
	netsukuku_coord_netsukuku_icoord_parent_iface = g_type_interface_peek_parent (iface);
	iface->report_status = (GeeList* (*)(NetsukukuICoord*, GError**)) netsukuku_coord_real_report_status;
	iface->reserve = (NetsukukuHookReservation* (*)(NetsukukuICoord*, NetsukukuPartialNIP*, GError**)) netsukuku_coord_real_reserve;
	iface->free = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, gint, GError**)) netsukuku_coord_real_free;
	iface->duplicate_all_knowledge = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, NetsukukuCoordinatorKnowledge*, GError**)) netsukuku_coord_real_duplicate_all_knowledge;
	iface->duplicate_free = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, gint, GError**)) netsukuku_coord_real_duplicate_free;
	iface->register_bnode = (gboolean (*)(NetsukukuICoord*, NetsukukuPartialNIP*, NetsukukuNIP*, gboolean, gboolean, gboolean, GError**)) netsukuku_coord_real_register_bnode;
}


static void netsukuku_coord_instance_init (NetsukukuCoord * self) {
	self->priv = NETSUKUKU_COORD_GET_PRIVATE (self);
}


static void netsukuku_coord_finalize (GObject* obj) {
	NetsukukuCoord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COORD, NetsukukuCoord);
	_g_object_unref0 (self->priv->_coordinators);
	G_OBJECT_CLASS (netsukuku_coord_parent_class)->finalize (obj);
}


GType netsukuku_coord_get_type (void) {
	static volatile gsize netsukuku_coord_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coord_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coord_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoord), 0, (GInstanceInitFunc) netsukuku_coord_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icoord_info = { (GInterfaceInitFunc) netsukuku_coord_netsukuku_icoord_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_coord_type_id;
		netsukuku_coord_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuCoord", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_coord_type_id, NETSUKUKU_TYPE_ICOORD, &netsukuku_icoord_info);
		g_once_init_leave (&netsukuku_coord_type_id__volatile, netsukuku_coord_type_id);
	}
	return netsukuku_coord_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_copy (const Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self, Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_destroy (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* netsukuku_struct_helper_coordinator_manage_bnode_tunnels_dup (const Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self) {
	Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels, 1);
	netsukuku_struct_helper_coordinator_manage_bnode_tunnels_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_free (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self) {
	netsukuku_struct_helper_coordinator_manage_bnode_tunnels_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_manage_bnode_tunnels_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id;
		netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_manage_bnode_tunnels", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_manage_bnode_tunnels_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_manage_bnode_tunnels_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id__volatile, netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id);
	}
	return netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_copy (const Netsukukustruct_helper_Coordinator_forward_knowledge* self, Netsukukustruct_helper_Coordinator_forward_knowledge* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_destroy (Netsukukustruct_helper_Coordinator_forward_knowledge* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Coordinator_forward_knowledge* netsukuku_struct_helper_coordinator_forward_knowledge_dup (const Netsukukustruct_helper_Coordinator_forward_knowledge* self) {
	Netsukukustruct_helper_Coordinator_forward_knowledge* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_forward_knowledge, 1);
	netsukuku_struct_helper_coordinator_forward_knowledge_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_free (Netsukukustruct_helper_Coordinator_forward_knowledge* self) {
	netsukuku_struct_helper_coordinator_forward_knowledge_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_forward_knowledge_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_forward_knowledge_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_forward_knowledge_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_forward_knowledge_type_id;
		netsukuku_struct_helper_coordinator_forward_knowledge_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_forward_knowledge", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_forward_knowledge_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_forward_knowledge_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_forward_knowledge_type_id__volatile, netsukuku_struct_helper_coordinator_forward_knowledge_type_id);
	}
	return netsukuku_struct_helper_coordinator_forward_knowledge_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_copy (const Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self, Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).nip;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).nip);
	(*dest).nip = _tmp3_;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_destroy (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self) {
	_g_object_unref0 ((*self).self);
	_g_object_unref0 ((*self).nip);
}


Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_dup (const Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self) {
	Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip, 1);
	netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_free (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self) {
	netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id;
		netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id__volatile, netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id);
	}
	return netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_forward_free_copy (const Netsukukustruct_helper_Coordinator_forward_free* self, Netsukukustruct_helper_Coordinator_forward_free* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	gint _tmp2_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).pos;
	(*dest).pos = _tmp2_;
}


void netsukuku_struct_helper_coordinator_forward_free_destroy (Netsukukustruct_helper_Coordinator_forward_free* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Coordinator_forward_free* netsukuku_struct_helper_coordinator_forward_free_dup (const Netsukukustruct_helper_Coordinator_forward_free* self) {
	Netsukukustruct_helper_Coordinator_forward_free* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_forward_free, 1);
	netsukuku_struct_helper_coordinator_forward_free_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_forward_free_free (Netsukukustruct_helper_Coordinator_forward_free* self) {
	netsukuku_struct_helper_coordinator_forward_free_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_forward_free_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_forward_free_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_forward_free_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_forward_free_type_id;
		netsukuku_struct_helper_coordinator_forward_free_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_forward_free", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_forward_free_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_forward_free_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_forward_free_type_id__volatile, netsukuku_struct_helper_coordinator_forward_free_type_id);
	}
	return netsukuku_struct_helper_coordinator_forward_free_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_forward_free_to_nip_copy (const Netsukukustruct_helper_Coordinator_forward_free_to_nip* self, Netsukukustruct_helper_Coordinator_forward_free_to_nip* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	gint _tmp4_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).to_nip;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).to_nip);
	(*dest).to_nip = _tmp3_;
	_tmp4_ = (*self).pos;
	(*dest).pos = _tmp4_;
}


void netsukuku_struct_helper_coordinator_forward_free_to_nip_destroy (Netsukukustruct_helper_Coordinator_forward_free_to_nip* self) {
	_g_object_unref0 ((*self).self);
	_g_object_unref0 ((*self).to_nip);
}


Netsukukustruct_helper_Coordinator_forward_free_to_nip* netsukuku_struct_helper_coordinator_forward_free_to_nip_dup (const Netsukukustruct_helper_Coordinator_forward_free_to_nip* self) {
	Netsukukustruct_helper_Coordinator_forward_free_to_nip* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_forward_free_to_nip, 1);
	netsukuku_struct_helper_coordinator_forward_free_to_nip_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_forward_free_to_nip_free (Netsukukustruct_helper_Coordinator_forward_free_to_nip* self) {
	netsukuku_struct_helper_coordinator_forward_free_to_nip_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_forward_free_to_nip_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id;
		netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_forward_free_to_nip", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_forward_free_to_nip_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_forward_free_to_nip_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id__volatile, netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id);
	}
	return netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id__volatile;
}


NetsukukuCoordinator* netsukuku_coordinator_construct (GType object_type, NetsukukuPartialNIP* gnode, NetsukukuCoord* parent) {
	NetsukukuCoordinator * self = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoord* _tmp1_;
	NetsukukuCoord* _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	NetsukukuPartialNIP* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	NetsukukuPartialNIP* _tmp7_;
	NetsukukuBookings* _tmp8_;
	NetsukukuPartialNIP* _tmp9_;
	NetsukukuBnodeList* _tmp10_;
	gint _tmp11_;
	NetsukukuMapRoute* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_val_if_fail (gnode != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (NetsukukuCoordinator*) g_object_new (object_type, NULL);
	_tmp0_ = gnode;
	netsukuku_coordinator_set_gnode (self, _tmp0_);
	_tmp1_ = parent;
	self->priv->parent = _tmp1_;
	_tmp2_ = parent;
	_tmp3_ = ((NetsukukuPeerToPeer*) _tmp2_)->maproute;
	self->priv->maproute = _tmp3_;
	_tmp4_ = gnode;
	_tmp5_ = netsukuku_partial_nip_level_of_gnode (_tmp4_);
	self->priv->level_of_gnode = _tmp5_;
	_tmp6_ = self->priv->level_of_gnode;
	self->priv->level_of_nodes = _tmp6_ - 1;
	_tmp7_ = gnode;
	_tmp8_ = netsukuku_bookings_new (_tmp7_);
	_g_object_unref0 (self->priv->bookings);
	self->priv->bookings = _tmp8_;
	_tmp9_ = gnode;
	_tmp10_ = netsukuku_bnode_list_new (_tmp9_);
	_g_object_unref0 (self->priv->bnode_list);
	self->priv->bnode_list = _tmp10_;
	self->last_assigned_elderliness = 0;
	self->priv->_is_main_previous_state = FALSE;
	self->priv->_is_main_latest_evaluation = FALSE;
	_g_object_unref0 (self->priv->manage_bnode_tunnels_handle);
	self->priv->manage_bnode_tunnels_handle = NULL;
	_tmp11_ = self->priv->level_of_gnode;
	_tmp12_ = self->priv->maproute;
	_tmp13_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp11_ != _tmp14_) {
		netsukuku_coordinator_manage_bnode_tunnels (self);
	}
	return self;
}


NetsukukuCoordinator* netsukuku_coordinator_new (NetsukukuPartialNIP* gnode, NetsukukuCoord* parent) {
	return netsukuku_coordinator_construct (NETSUKUKU_TYPE_COORDINATOR, gnode, parent);
}


void netsukuku_coordinator_stop_operations (NetsukukuCoordinator* self) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	TaskletsTasklet* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = ipstr;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("Coordinator: stopping operations for ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	netsukuku_log_debug (_tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->manage_bnode_tunnels_handle;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		TaskletsTasklet* _tmp19_;
		_tmp15_ = ipstr;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = g_strconcat ("Coordinator: aborting manage_bnode_tunnels for ", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		netsukuku_log_debug (_tmp18_);
		_g_free0 (_tmp18_);
		_tmp19_ = self->priv->manage_bnode_tunnels_handle;
		tasklets_tasklet_abort (_tmp19_);
		_g_object_unref0 (self->priv->manage_bnode_tunnels_handle);
		self->priv->manage_bnode_tunnels_handle = NULL;
	}
	_g_free0 (ipstr);
}


NetsukukuCoordinatorKnowledge* netsukuku_coordinator_report_status (NetsukukuCoordinator* self) {
	NetsukukuCoordinatorKnowledge* result = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuBookings* _tmp1_;
	gint _tmp2_;
	NetsukukuBnodeList* _tmp3_;
	NetsukukuCoordinatorKnowledge* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnode;
	_tmp1_ = self->priv->bookings;
	_tmp2_ = self->last_assigned_elderliness;
	_tmp3_ = self->priv->bnode_list;
	_tmp4_ = netsukuku_coordinator_knowledge_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


void netsukuku_coordinator_map_has_changed (NetsukukuCoordinator* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		NetsukukuCoord_hkey* _tmp1_;
		NetsukukuCoord_hkey* key;
		gint _tmp2_;
		NetsukukuMapRoute* _tmp3_;
		NetsukukuNIP* _tmp4_;
		NetsukukuNIP* _tmp5_;
		NetsukukuNIP* _tmp6_;
		gboolean _tmp7_ = FALSE;
		NetsukukuCoord* _tmp8_;
		NetsukukuCoord* _tmp9_;
		NetsukukuNIP* _tmp10_ = NULL;
		NetsukukuNIP* _tmp11_;
		NetsukukuHCoord* _tmp12_ = NULL;
		NetsukukuHCoord* _tmp13_;
		NetsukukuHCoord* _tmp14_;
		NetsukukuHCoord* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp19_;
		_tmp0_ = self->priv->_is_main_latest_evaluation;
		self->priv->_is_main_previous_state = _tmp0_;
		_tmp1_ = netsukuku_coord_hkey_new ();
		key = _tmp1_;
		_tmp2_ = self->priv->level_of_gnode;
		key->level_of_gnode = _tmp2_;
		_tmp3_ = self->priv->maproute;
		_tmp4_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (key->nip);
		key->nip = _tmp6_;
		_tmp8_ = self->priv->parent;
		_tmp9_ = self->priv->parent;
		_tmp10_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp9_, (GObject*) key);
		_tmp11_ = _tmp10_;
		_tmp12_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) _tmp8_, _tmp11_, 1, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (key);
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				goto __catch34_netsukuku_peer_to_peer_error;
			}
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_ == NULL;
		_g_object_unref0 (_tmp15_);
		if (_tmp16_) {
			NetsukukuCoord* _tmp17_;
			gboolean _tmp18_;
			_tmp17_ = self->priv->parent;
			_tmp18_ = ((NetsukukuPeerToPeer*) _tmp17_)->has_valid_map;
			_tmp7_ = _tmp18_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp19_ = _tmp7_;
		self->priv->_is_main_latest_evaluation = _tmp19_;
		_g_object_unref0 (key);
	}
	goto __finally34;
	__catch34_netsukuku_peer_to_peer_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		netsukuku_log_error ("Coordinator.map_has_changed: no participants in Coord service.");
		_g_error_free0 (e);
	}
	__finally34:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/** A node wants to become a member of our gnode.
          * If possible, we add the reservation and return the HookReservation,
          * else, we return None.
          */
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static NetsukukuGNodeID** _vala_array_dup2 (NetsukukuGNodeID** self, int length) {
	NetsukukuGNodeID** result;
	int i;
	result = g_new0 (NetsukukuGNodeID*, length + 1);
	for (i = 0; i < length; i++) {
		NetsukukuGNodeID* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


NetsukukuHookReservation* netsukuku_coordinator_reserve (NetsukukuCoordinator* self) {
	NetsukukuHookReservation* result = NULL;
	NetsukukuPartialNIP* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint* _fnl;
	gint _fnl_length1;
	gint __fnl_size_;
	GeeArrayList* _tmp9_;
	GeeArrayList* fnl;
	gint* _tmp10_;
	gint _tmp10__length1;
	GeeArrayList* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint32 _tmp23_ = 0;
	gpointer _tmp24_ = NULL;
	gint pos;
	NetsukukuBookings* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	GeeArrayList* _tmp32_;
	GeeArrayList* pool;
	GeeArrayList* _tmp52_;
	NetsukukuMapRoute* _tmp53_;
	gint _tmp54_ = 0;
	NetsukukuGNodeID** _tmp55_ = NULL;
	NetsukukuGNodeID** _tmp56_;
	gint _tmp56__length1;
	gint _tmp57_;
	NetsukukuGNodeID* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	GeeArrayList* _tmp61_;
	gint _tmp62_;
	gint* max_pool;
	gint* _tmp81_;
	gint new_elderliness;
	gint _tmp82_;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_;
	gchar* _tmp85_ = NULL;
	gchar* _tmp86_;
	gint _tmp87_;
	NetsukukuMapRoute* _tmp88_;
	gint _tmp89_;
	gint _tmp90_ = 0;
	NetsukukuGNodeID** _tmp91_ = NULL;
	NetsukukuGNodeID** gids;
	gint gids_length1;
	gint _gids_size_;
	gchar* _tmp92_;
	gchar* output_gids;
	NetsukukuGNodeID** _tmp93_;
	gint _tmp93__length1;
	const gchar* _tmp102_;
	const gchar* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	gchar* _tmp105_;
	NetsukukuCoordinatorKnowledgeSet* _tmp106_;
	NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set;
	NetsukukuHookReservation* _tmp166_;
	NetsukukuHookReservation* ret;
	NetsukukuHookReservation* _tmp167_;
	NetsukukuPartialNIP* _tmp168_;
	NetsukukuPartialNIP* _tmp169_;
	NetsukukuHookReservation* _tmp170_;
	gint _tmp171_;
	NetsukukuHookReservation* _tmp172_;
	gint _tmp173_;
	NetsukukuHookReservation* _tmp174_;
	NetsukukuGNodeID** _tmp175_;
	gint _tmp175__length1;
	NetsukukuGNodeID** _tmp176_;
	gint _tmp176__length1;
	NetsukukuHookReservation* _tmp177_;
	NetsukukuCoordinatorKnowledgeSet* _tmp178_;
	NetsukukuCoordinatorKnowledgeSet* _tmp179_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnode;
	_tmp1_ = netsukuku_partial_nip_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Coord.reserve: gnode = ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	netsukuku_log_debug (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = self->priv->maproute;
	_tmp6_ = self->priv->level_of_nodes;
	_tmp8_ = netsukuku_map_free_nodes_list ((NetsukukuMap*) _tmp5_, _tmp6_, &_tmp7_);
	_fnl = _tmp8_;
	_fnl_length1 = _tmp7_;
	__fnl_size_ = _fnl_length1;
	_tmp9_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	fnl = _tmp9_;
	_tmp10_ = _fnl;
	_tmp10__length1 = _fnl_length1;
	{
		gint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp10_;
		i_collection_length1 = _tmp10__length1;
		for (i_it = 0; i_it < _tmp10__length1; i_it = i_it + 1) {
			gint i = 0;
			i = i_collection[i_it];
			{
				NetsukukuBookings* _tmp11_;
				gint _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp11_ = self->priv->bookings;
				_tmp12_ = i;
				_tmp13_ = netsukuku_bookings_is_booked (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					_tmp14_ = fnl;
					_tmp15_ = i;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (gpointer) ((gintptr) _tmp15_));
				}
			}
		}
	}
	_tmp16_ = fnl;
	_tmp17_ = gee_collection_get_is_empty ((GeeCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		result = NULL;
		_g_object_unref0 (fnl);
		_fnl = (g_free (_fnl), NULL);
		return result;
	}
	_tmp19_ = fnl;
	_tmp20_ = fnl;
	_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_random_int_range ((gint32) 0, (gint32) _tmp22_);
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, (gint) _tmp23_);
	pos = (gint) ((gintptr) _tmp24_);
	_tmp25_ = self->priv->bookings;
	_tmp26_ = pos;
	netsukuku_bookings_new_book (_tmp25_, _tmp26_);
	_tmp27_ = pos;
	_tmp28_ = g_strdup_printf ("%i", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat ("Coord.reserve: returns pos ", _tmp29_, NULL);
	_tmp31_ = _tmp30_;
	netsukuku_log_debug (_tmp31_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_tmp32_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	pool = _tmp32_;
	{
		gint pos2;
		pos2 = 0;
		{
			gboolean _tmp33_;
			_tmp33_ = TRUE;
			while (TRUE) {
				gboolean _tmp34_;
				gint _tmp36_;
				NetsukukuMapRoute* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				NetsukukuMapRoute* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gpointer _tmp43_ = NULL;
				NetsukukuRouteNode* node;
				NetsukukuRouteNode* _tmp44_;
				gboolean _tmp45_ = FALSE;
				_tmp34_ = _tmp33_;
				if (!_tmp34_) {
					gint _tmp35_;
					_tmp35_ = pos2;
					pos2 = _tmp35_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp36_ = pos2;
				_tmp37_ = self->priv->maproute;
				_tmp38_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp37_);
				_tmp39_ = _tmp38_;
				if (!(_tmp36_ < _tmp39_)) {
					break;
				}
				_tmp40_ = self->priv->maproute;
				_tmp41_ = self->priv->level_of_nodes;
				_tmp42_ = pos2;
				_tmp43_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp40_, _tmp41_, _tmp42_);
				node = (NetsukukuRouteNode*) _tmp43_;
				_tmp44_ = node;
				_tmp45_ = netsukuku_route_node_is_empty (_tmp44_);
				if (!_tmp45_) {
					GeeArrayList* _tmp46_;
					NetsukukuRouteNode* _tmp47_;
					NetsukukuGNodeID* _tmp48_ = NULL;
					NetsukukuGNodeID* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					_tmp46_ = pool;
					_tmp47_ = node;
					_tmp48_ = netsukuku_route_node_get_eldest_gid (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = netsukuku_gnode_id_get_elderliness (_tmp49_);
					_tmp51_ = _tmp50_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, (gpointer) ((gintptr) _tmp51_));
					_g_object_unref0 (_tmp49_);
				}
				_g_object_unref0 (node);
			}
		}
	}
	_tmp52_ = pool;
	_tmp53_ = self->priv->maproute;
	_tmp55_ = netsukuku_map_route_get_gid_list (_tmp53_, &_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp56__length1 = _tmp54_;
	_tmp57_ = self->priv->level_of_nodes;
	_tmp58_ = _tmp56_[_tmp57_];
	_tmp59_ = netsukuku_gnode_id_get_elderliness (_tmp58_);
	_tmp60_ = _tmp59_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, (gpointer) ((gintptr) _tmp60_));
	_tmp56_ = (_vala_array_free (_tmp56_, _tmp56__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp61_ = pool;
	_tmp62_ = self->last_assigned_elderliness;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, (gpointer) ((gintptr) _tmp62_));
	max_pool = NULL;
	{
		GeeArrayList* _tmp63_;
		GeeArrayList* _tmp64_;
		GeeArrayList* _maybe_max_list;
		GeeArrayList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _maybe_max_size;
		gint _maybe_max_index;
		_tmp63_ = pool;
		_tmp64_ = _g_object_ref0 (_tmp63_);
		_maybe_max_list = _tmp64_;
		_tmp65_ = _maybe_max_list;
		_tmp66_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_maybe_max_size = _tmp67_;
		_maybe_max_index = -1;
		while (TRUE) {
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			GeeArrayList* _tmp71_;
			gint _tmp72_;
			gpointer _tmp73_ = NULL;
			gint maybe_max;
			gint* _tmp74_;
			_tmp68_ = _maybe_max_index;
			_maybe_max_index = _tmp68_ + 1;
			_tmp69_ = _maybe_max_index;
			_tmp70_ = _maybe_max_size;
			if (!(_tmp69_ < _tmp70_)) {
				break;
			}
			_tmp71_ = _maybe_max_list;
			_tmp72_ = _maybe_max_index;
			_tmp73_ = gee_abstract_list_get ((GeeAbstractList*) _tmp71_, _tmp72_);
			maybe_max = (gint) ((gintptr) _tmp73_);
			_tmp74_ = max_pool;
			if (_tmp74_ == NULL) {
				gint _tmp75_;
				gint* _tmp76_;
				_tmp75_ = maybe_max;
				_tmp76_ = __int_dup0 (&_tmp75_);
				_g_free0 (max_pool);
				max_pool = _tmp76_;
			} else {
				gint* _tmp77_;
				gint _tmp78_;
				_tmp77_ = max_pool;
				_tmp78_ = maybe_max;
				if ((*_tmp77_) < _tmp78_) {
					gint _tmp79_;
					gint* _tmp80_;
					_tmp79_ = maybe_max;
					_tmp80_ = __int_dup0 (&_tmp79_);
					_g_free0 (max_pool);
					max_pool = _tmp80_;
				}
			}
		}
		_g_object_unref0 (_maybe_max_list);
	}
	_tmp81_ = max_pool;
	new_elderliness = (*_tmp81_) + 1;
	_tmp82_ = new_elderliness;
	_tmp83_ = g_strdup_printf ("%i", _tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = g_strconcat ("Coord.reserve: returns new_elderliness ", _tmp84_, NULL);
	_tmp86_ = _tmp85_;
	netsukuku_log_debug (_tmp86_);
	_g_free0 (_tmp86_);
	_g_free0 (_tmp84_);
	_tmp87_ = new_elderliness;
	self->last_assigned_elderliness = _tmp87_;
	_tmp88_ = self->priv->maproute;
	_tmp89_ = self->priv->level_of_gnode;
	_tmp91_ = netsukuku_map_route_get_gid_uppermost_list (_tmp88_, _tmp89_, &_tmp90_);
	gids = _tmp91_;
	gids_length1 = _tmp90_;
	_gids_size_ = gids_length1;
	_tmp92_ = g_strdup ("");
	output_gids = _tmp92_;
	_tmp93_ = gids;
	_tmp93__length1 = gids_length1;
	{
		NetsukukuGNodeID** gid_collection = NULL;
		gint gid_collection_length1 = 0;
		gint _gid_collection_size_ = 0;
		gint gid_it = 0;
		gid_collection = _tmp93_;
		gid_collection_length1 = _tmp93__length1;
		for (gid_it = 0; gid_it < _tmp93__length1; gid_it = gid_it + 1) {
			NetsukukuGNodeID* _tmp94_;
			NetsukukuGNodeID* gid = NULL;
			_tmp94_ = _g_object_ref0 (gid_collection[gid_it]);
			gid = _tmp94_;
			{
				const gchar* _tmp95_;
				NetsukukuGNodeID* _tmp96_;
				gchar* _tmp97_ = NULL;
				gchar* _tmp98_;
				gchar* _tmp99_ = NULL;
				gchar* _tmp100_;
				gchar* _tmp101_;
				_tmp95_ = output_gids;
				_tmp96_ = gid;
				_tmp97_ = netsukuku_gnode_id_to_string (_tmp96_);
				_tmp98_ = _tmp97_;
				_tmp99_ = g_strconcat (_tmp98_, ", ", NULL);
				_tmp100_ = _tmp99_;
				_tmp101_ = g_strconcat (_tmp95_, _tmp100_, NULL);
				_g_free0 (output_gids);
				output_gids = _tmp101_;
				_g_free0 (_tmp100_);
				_g_free0 (_tmp98_);
				_g_object_unref0 (gid);
			}
		}
	}
	_tmp102_ = output_gids;
	_tmp103_ = string_to_string (_tmp102_);
	_tmp104_ = g_strconcat ("Coord.reserve: returns gids [", _tmp103_, "]", NULL);
	_tmp105_ = _tmp104_;
	netsukuku_log_debug (_tmp105_);
	_g_free0 (_tmp105_);
	netsukuku_coordinator_forward_knowledge (self);
	_tmp106_ = netsukuku_coordinator_knowledge_set_new ();
	coordinator_knowledge_set = _tmp106_;
	{
		gint _tmp107_;
		gint _level_of_nodes;
		_tmp107_ = self->priv->level_of_nodes;
		_level_of_nodes = _tmp107_;
		{
			gboolean _tmp108_;
			_tmp108_ = TRUE;
			while (TRUE) {
				gboolean _tmp109_;
				gint _tmp111_;
				NetsukukuMapRoute* _tmp112_;
				gint _tmp113_;
				gint _tmp114_;
				gint _tmp115_;
				gint _level_of_gnode;
				NetsukukuCoord* _tmp116_;
				gint _tmp117_;
				NetsukukuPartialNIP* _tmp118_ = NULL;
				NetsukukuPartialNIP* _gnode;
				NetsukukuPartialNIP* _tmp119_;
				NetsukukuBookings* _tmp120_;
				NetsukukuBookings* _bookings;
				NetsukukuCoord* _tmp146_;
				gint _tmp147_;
				NetsukukuCoordinator* _tmp148_ = NULL;
				NetsukukuCoordinator* _tmp149_;
				gint _tmp150_;
				gint _tmp151_;
				gint _last_assigned_elderliness;
				NetsukukuCoord* _tmp152_;
				gint _tmp153_;
				NetsukukuCoordinator* _tmp154_ = NULL;
				NetsukukuCoordinator* _tmp155_;
				NetsukukuBnodeList* _tmp156_ = NULL;
				NetsukukuBnodeList* _tmp157_;
				NetsukukuBnodeList* _bnode_list;
				NetsukukuCoordinatorKnowledgeSet* _tmp158_;
				NetsukukuPartialNIP* _tmp159_;
				NetsukukuPartialNIP* _tmp160_;
				NetsukukuBookings* _tmp161_;
				gint _tmp162_;
				NetsukukuBnodeList* _tmp163_;
				NetsukukuCoordinatorKnowledge* _tmp164_;
				NetsukukuCoordinatorKnowledge* _tmp165_;
				_tmp109_ = _tmp108_;
				if (!_tmp109_) {
					gint _tmp110_;
					_tmp110_ = _level_of_nodes;
					_level_of_nodes = _tmp110_ + 1;
				}
				_tmp108_ = FALSE;
				_tmp111_ = _level_of_nodes;
				_tmp112_ = self->priv->maproute;
				_tmp113_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp112_);
				_tmp114_ = _tmp113_;
				if (!(_tmp111_ < _tmp114_)) {
					break;
				}
				_tmp115_ = _level_of_nodes;
				_level_of_gnode = _tmp115_ + 1;
				_tmp116_ = self->priv->parent;
				_tmp117_ = _level_of_gnode;
				_tmp118_ = netsukuku_coord_get_my_gnode_at_level (_tmp116_, _tmp117_);
				_gnode = _tmp118_;
				_tmp119_ = _gnode;
				_tmp120_ = netsukuku_bookings_new (_tmp119_);
				_bookings = _tmp120_;
				{
					gint pos2;
					pos2 = 0;
					{
						gboolean _tmp121_;
						_tmp121_ = TRUE;
						while (TRUE) {
							gboolean _tmp122_;
							gint _tmp124_;
							NetsukukuMapRoute* _tmp125_;
							gint _tmp126_;
							gint _tmp127_;
							gboolean _tmp128_ = FALSE;
							NetsukukuMapRoute* _tmp129_;
							gint _tmp130_;
							gint _tmp131_;
							gpointer _tmp132_ = NULL;
							NetsukukuRouteNode* _tmp133_;
							gboolean _tmp134_ = FALSE;
							gboolean _tmp135_;
							gboolean _tmp143_;
							_tmp122_ = _tmp121_;
							if (!_tmp122_) {
								gint _tmp123_;
								_tmp123_ = pos2;
								pos2 = _tmp123_ + 1;
							}
							_tmp121_ = FALSE;
							_tmp124_ = pos2;
							_tmp125_ = self->priv->maproute;
							_tmp126_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp125_);
							_tmp127_ = _tmp126_;
							if (!(_tmp124_ < _tmp127_)) {
								break;
							}
							_tmp129_ = self->priv->maproute;
							_tmp130_ = _level_of_nodes;
							_tmp131_ = pos2;
							_tmp132_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp129_, _tmp130_, _tmp131_);
							_tmp133_ = (NetsukukuRouteNode*) _tmp132_;
							_tmp134_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp133_);
							_tmp135_ = !_tmp134_;
							_g_object_unref0 (_tmp133_);
							if (_tmp135_) {
								_tmp128_ = TRUE;
							} else {
								NetsukukuCoord* _tmp136_;
								gint _tmp137_;
								NetsukukuCoordinator* _tmp138_ = NULL;
								NetsukukuCoordinator* _tmp139_;
								NetsukukuBookings* _tmp140_;
								gint _tmp141_;
								gboolean _tmp142_ = FALSE;
								_tmp136_ = self->priv->parent;
								_tmp137_ = _level_of_gnode;
								_tmp138_ = netsukuku_coord_get_coordinator_for_gnode_at_level (_tmp136_, _tmp137_);
								_tmp139_ = _tmp138_;
								_tmp140_ = _tmp139_->priv->bookings;
								_tmp141_ = pos2;
								_tmp142_ = netsukuku_bookings_is_booked (_tmp140_, _tmp141_);
								_tmp128_ = _tmp142_;
								_g_object_unref0 (_tmp139_);
							}
							_tmp143_ = _tmp128_;
							if (_tmp143_) {
								NetsukukuBookings* _tmp144_;
								gint _tmp145_;
								_tmp144_ = _bookings;
								_tmp145_ = pos2;
								netsukuku_bookings_new_book (_tmp144_, _tmp145_);
							}
						}
					}
				}
				_tmp146_ = self->priv->parent;
				_tmp147_ = _level_of_gnode;
				_tmp148_ = netsukuku_coord_get_coordinator_for_gnode_at_level (_tmp146_, _tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = _tmp149_->last_assigned_elderliness;
				_tmp151_ = _tmp150_;
				_g_object_unref0 (_tmp149_);
				_last_assigned_elderliness = _tmp151_;
				_tmp152_ = self->priv->parent;
				_tmp153_ = _level_of_gnode;
				_tmp154_ = netsukuku_coord_get_coordinator_for_gnode_at_level (_tmp152_, _tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = netsukuku_coordinator_get_bnode_list (_tmp155_);
				_tmp157_ = _tmp156_;
				_g_object_unref0 (_tmp155_);
				_bnode_list = _tmp157_;
				_tmp158_ = coordinator_knowledge_set;
				_tmp159_ = _gnode;
				_tmp160_ = _gnode;
				_tmp161_ = _bookings;
				_tmp162_ = _last_assigned_elderliness;
				_tmp163_ = _bnode_list;
				_tmp164_ = netsukuku_coordinator_knowledge_new (_tmp160_, _tmp161_, _tmp162_, _tmp163_);
				_tmp165_ = _tmp164_;
				netsukuku_coordinator_knowledge_set_dict_set (_tmp158_, _tmp159_, _tmp165_);
				_g_object_unref0 (_tmp165_);
				_g_object_unref0 (_bnode_list);
				_g_object_unref0 (_bookings);
				_g_object_unref0 (_gnode);
			}
		}
	}
	netsukuku_log_debug ("Coord.reserve: returns a new coordinator_knowledge_set");
	_tmp166_ = netsukuku_hook_reservation_new ();
	ret = _tmp166_;
	_tmp167_ = ret;
	_tmp168_ = self->priv->_gnode;
	_tmp169_ = _g_object_ref0 (_tmp168_);
	_g_object_unref0 (_tmp167_->gnode);
	_tmp167_->gnode = _tmp169_;
	_tmp170_ = ret;
	_tmp171_ = pos;
	_tmp170_->pos = _tmp171_;
	_tmp172_ = ret;
	_tmp173_ = new_elderliness;
	_tmp172_->elderliness = _tmp173_;
	_tmp174_ = ret;
	_tmp175_ = gids;
	_tmp175__length1 = gids_length1;
	_tmp176_ = (_tmp175_ != NULL) ? _vala_array_dup2 (_tmp175_, _tmp175__length1) : ((gpointer) _tmp175_);
	_tmp176__length1 = _tmp175__length1;
	_tmp174_->gids = (_vala_array_free (_tmp174_->gids, _tmp174_->gids_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp174_->gids = _tmp176_;
	_tmp174_->gids_length1 = _tmp176__length1;
	_tmp177_ = ret;
	_tmp178_ = coordinator_knowledge_set;
	_tmp179_ = _g_object_ref0 (_tmp178_);
	_g_object_unref0 (_tmp177_->coordinator_knowledge_set);
	_tmp177_->coordinator_knowledge_set = _tmp179_;
	result = ret;
	_g_object_unref0 (coordinator_knowledge_set);
	_g_free0 (output_gids);
	gids = (_vala_array_free (gids, gids_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (max_pool);
	_g_object_unref0 (pool);
	_g_object_unref0 (fnl);
	_fnl = (g_free (_fnl), NULL);
	return result;
}


void netsukuku_coordinator_free (NetsukukuCoordinator* self, gint pos) {
	NetsukukuPartialNIP* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_gnode;
	_tmp1_ = netsukuku_partial_nip_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = pos;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Coord.free: gnode,pos = (", _tmp2_, ", ", _tmp5_, ")", NULL);
	_tmp7_ = _tmp6_;
	netsukuku_log_debug (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp8_ = pos;
	netsukuku_coordinator_force_remove (self, _tmp8_);
	_tmp9_ = pos;
	netsukuku_coordinator_forward_free (self, _tmp9_);
}


static void _vala_array_add3 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuNIP*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void netsukuku_coordinator_impl_forward_free (NetsukukuCoordinator* self, gint pos, GError** error) {
	NetsukukuCoord_hkey* _tmp0_;
	NetsukukuCoord_hkey* key;
	gint _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuCoord* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hash_nip;
	NetsukukuPartialNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	NetsukukuCoord* _tmp13_;
	gint _tmp14_;
	GeeList* _tmp15_ = NULL;
	GeeList* bunch;
	NetsukukuNIP** _tmp16_ = NULL;
	NetsukukuNIP** bunch_not_me;
	gint bunch_not_me_length1;
	gint _bunch_not_me_size_;
	NetsukukuNIP** _tmp35_;
	gint _tmp35__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coordinator.forward_free");
	_tmp0_ = netsukuku_coord_hkey_new ();
	key = _tmp0_;
	_tmp1_ = self->priv->level_of_gnode;
	key->level_of_gnode = _tmp1_;
	_tmp2_ = self->priv->maproute;
	_tmp3_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (key->nip);
	key->nip = _tmp5_;
	_tmp6_ = self->priv->parent;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp6_, (GObject*) key);
	hash_nip = _tmp7_;
	_tmp8_ = self->priv->_gnode;
	_tmp9_ = netsukuku_partial_nip_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("Coord: starting find_nearest COORD_DUPLICATION to gnode ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	netsukuku_log_debug (_tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = self->priv->parent;
	_tmp14_ = self->priv->level_of_gnode;
	_tmp15_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) _tmp13_, hash_nip, NETSUKUKU_COORD_DUPLICATION, &_tmp14_, &_inner_error_);
	bunch = _tmp15_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (hash_nip);
		_g_object_unref0 (key);
		return;
	}
	_tmp16_ = g_new0 (NetsukukuNIP*, 0 + 1);
	bunch_not_me = _tmp16_;
	bunch_not_me_length1 = 0;
	_bunch_not_me_size_ = bunch_not_me_length1;
	{
		GeeList* _tmp17_;
		GeeList* _n_list;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _n_size;
		gint _n_index;
		_tmp17_ = _g_object_ref0 (bunch);
		_n_list = _tmp17_;
		_tmp18_ = _n_list;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_n_size = _tmp20_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			GeeList* _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_ = NULL;
			NetsukukuNIP* n;
			NetsukukuNIP* _tmp27_;
			NetsukukuMapRoute* _tmp28_;
			NetsukukuNIP* _tmp29_;
			NetsukukuNIP* _tmp30_;
			gboolean _tmp31_ = FALSE;
			_tmp21_ = _n_index;
			_n_index = _tmp21_ + 1;
			_tmp22_ = _n_index;
			_tmp23_ = _n_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _n_list;
			_tmp25_ = _n_index;
			_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
			n = (NetsukukuNIP*) _tmp26_;
			_tmp27_ = n;
			_tmp28_ = self->priv->maproute;
			_tmp29_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp27_, (NetsukukuPartialNIP*) _tmp30_);
			if (!_tmp31_) {
				NetsukukuNIP** _tmp32_;
				gint _tmp32__length1;
				NetsukukuNIP* _tmp33_;
				NetsukukuNIP* _tmp34_;
				_tmp32_ = bunch_not_me;
				_tmp32__length1 = bunch_not_me_length1;
				_tmp33_ = n;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				_vala_array_add3 (&bunch_not_me, &bunch_not_me_length1, &_bunch_not_me_size_, _tmp34_);
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	_tmp35_ = bunch_not_me;
	_tmp35__length1 = bunch_not_me_length1;
	{
		NetsukukuNIP** to_nip_collection = NULL;
		gint to_nip_collection_length1 = 0;
		gint _to_nip_collection_size_ = 0;
		gint to_nip_it = 0;
		to_nip_collection = _tmp35_;
		to_nip_collection_length1 = _tmp35__length1;
		for (to_nip_it = 0; to_nip_it < _tmp35__length1; to_nip_it = to_nip_it + 1) {
			NetsukukuNIP* _tmp36_;
			NetsukukuNIP* to_nip = NULL;
			_tmp36_ = _g_object_ref0 (to_nip_collection[to_nip_it]);
			to_nip = _tmp36_;
			{
				NetsukukuNIP* _tmp37_;
				gint _tmp38_;
				_tmp37_ = to_nip;
				_tmp38_ = pos;
				netsukuku_coordinator_forward_free_to_nip (self, _tmp37_, _tmp38_);
				_g_object_unref0 (to_nip);
			}
		}
	}
	bunch_not_me = (_vala_array_free (bunch_not_me, bunch_not_me_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (bunch);
	_g_object_unref0 (hash_nip);
	_g_object_unref0 (key);
}


static void* netsukuku_coordinator_helper_forward_free (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_forward_free* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	gint _tmp3_;
	gint pos_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_forward_free*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).pos;
	pos_save = _tmp3_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_forward_free (self_save, pos_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


/** Communicate to secondary coordinators to free this 'pos'.
          */
void netsukuku_coordinator_forward_free (NetsukukuCoordinator* self, gint pos) {
	Netsukukustruct_helper_Coordinator_forward_free arg = {0};
	NetsukukuCoordinator* _tmp0_;
	gint _tmp1_;
	TaskletsTasklet* _tmp2_ = NULL;
	TaskletsTasklet* _tmp3_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_forward_free));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = pos;
	arg.pos = _tmp1_;
	_tmp2_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_coordinator_helper_forward_free, &arg, FALSE, -1);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	netsukuku_struct_helper_coordinator_forward_free_destroy (&arg);
}


static void netsukuku_coordinator_impl_forward_free_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, gint pos, GError** error) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuNIP* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* dest_addr;
	NetsukukuMapRoute* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	NetsukukuMapRoute* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	NetsukukuNIP* _tmp15_;
	NetsukukuNIP* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* my_addr;
	gint _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	NetsukukuAddressManagerTCPClient* _tmp24_;
	NetsukukuAddressManagerTCPClient* remote;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_nip != NULL);
	tasklets_tasklet_declare_self ("Coordinator.forward_free_to_nip");
	_tmp0_ = self->priv->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = to_nip;
	_tmp7_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp6_);
	dest_addr = _tmp7_;
	_tmp8_ = self->priv->maproute;
	_tmp9_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->maproute;
	_tmp12_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->maproute;
	_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_nip_to_str (_tmp10_, _tmp13_, _tmp16_);
	my_addr = _tmp17_;
	_tmp18_ = pos;
	_tmp19_ = g_strdup_printf ("%i", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = string_to_string (dest_addr);
	_tmp22_ = g_strconcat ("Coord: forwarding free ", _tmp20_, " to ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_log_debug (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp24_ = netsukuku_address_manager_tcp_client_new (dest_addr, NULL, my_addr, FALSE);
	remote = _tmp24_;
	{
		NetsukukuICoord* _tmp25_;
		NetsukukuICoord* _tmp26_;
		NetsukukuPartialNIP* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		_tmp25_ = netsukuku_iaddress_manager_root_dispatcher_get_coordnode ((NetsukukuIAddressManagerRootDispatcher*) remote);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_gnode;
		_tmp28_ = pos;
		netsukuku_icoord_duplicate_free (_tmp26_, _tmp27_, _tmp28_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch35_g_error;
		}
		_tmp29_ = pos;
		_tmp30_ = g_strdup_printf ("%i", _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = string_to_string (dest_addr);
		_tmp33_ = g_strconcat ("Coord: forwarded free ", _tmp31_, " to ", _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		netsukuku_log_debug (_tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp31_);
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		gint _tmp35_;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		const gchar* _tmp38_ = NULL;
		GError* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp35_ = pos;
		_tmp36_ = g_strdup_printf ("%i", _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = string_to_string (dest_addr);
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		_tmp41_ = string_to_string (_tmp40_);
		_tmp42_ = g_strconcat ("'Coord: forwarded free ", _tmp37_, " to ", _tmp38_, " got exception ", _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		netsukuku_log_warn (_tmp43_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp37_);
		_g_error_free0 (e);
	}
	__finally35:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (remote);
		_g_free0 (my_addr);
		_g_free0 (dest_addr);
		return;
	}
	_g_object_unref0 (remote);
	_g_free0 (my_addr);
	_g_free0 (dest_addr);
}


static void* netsukuku_coordinator_helper_forward_free_to_nip (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_forward_free_to_nip* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* to_nip_save;
	gint _tmp5_;
	gint pos_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_forward_free_to_nip*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).to_nip;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	to_nip_save = _tmp4_;
	_tmp5_ = (*tuple_p).pos;
	pos_save = _tmp5_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_forward_free_to_nip (self_save, to_nip_save, pos_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (to_nip_save);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (to_nip_save);
	_g_object_unref0 (self_save);
	return result;
}


/** Forwards a freed position to another hash node in the bunch.
          */
void netsukuku_coordinator_forward_free_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, gint pos) {
	Netsukukustruct_helper_Coordinator_forward_free_to_nip arg = {0};
	NetsukukuCoordinator* _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	TaskletsTasklet* _tmp4_ = NULL;
	TaskletsTasklet* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_nip != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_forward_free_to_nip));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = pos;
	arg.pos = _tmp1_;
	_tmp2_ = to_nip;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (arg.to_nip);
	arg.to_nip = _tmp3_;
	_tmp4_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_coordinator_helper_forward_free_to_nip, &arg, FALSE, -1);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	netsukuku_struct_helper_coordinator_forward_free_to_nip_destroy (&arg);
}


NetsukukuBookings* netsukuku_coordinator_get_bookings (NetsukukuCoordinator* self) {
	NetsukukuBookings* result = NULL;
	NetsukukuBookings* _tmp0_;
	NetsukukuBookings* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bookings;
	_tmp1_ = netsukuku_bookings_clone (_tmp0_);
	result = _tmp1_;
	return result;
}


void netsukuku_coordinator_add_bookings (NetsukukuCoordinator* self, NetsukukuBookings* bookings) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookings != NULL);
	{
		NetsukukuBookings* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _booking_record_it;
		_tmp0_ = bookings;
		_tmp1_ = netsukuku_bookings_iterator (_tmp0_);
		_booking_record_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			NetsukukuBookingRecord* booking_record;
			NetsukukuBookingRecord* _tmp6_;
			_tmp2_ = _booking_record_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _booking_record_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			booking_record = (NetsukukuBookingRecord*) _tmp5_;
			_tmp6_ = booking_record;
			netsukuku_coordinator_add_record (self, _tmp6_);
			_g_object_unref0 (booking_record);
		}
		_g_object_unref0 (_booking_record_it);
	}
}


/** Add a record to my bookings, do not forward.
          */
void netsukuku_coordinator_add_record (NetsukukuCoordinator* self, NetsukukuBookingRecord* booking_record) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	NetsukukuBookingRecord* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_ = NULL;
	NetsukukuRouteNode* node;
	NetsukukuRouteNode* _tmp6_;
	gboolean _tmp7_ = FALSE;
	NetsukukuBookings* _tmp8_;
	NetsukukuBookingRecord* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (booking_record != NULL);
	_tmp0_ = self->priv->maproute;
	_tmp1_ = self->priv->level_of_nodes;
	_tmp2_ = booking_record;
	_tmp3_ = netsukuku_booking_record_get_pos (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp0_, _tmp1_, _tmp4_);
	node = (NetsukukuRouteNode*) _tmp5_;
	_tmp6_ = node;
	_tmp7_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp6_);
	if (!_tmp7_) {
		_g_object_unref0 (node);
		return;
	}
	_tmp8_ = self->priv->bookings;
	_tmp9_ = booking_record;
	netsukuku_bookings_force_add (_tmp8_, _tmp9_);
	_g_object_unref0 (node);
}


/** Remove a record from my bookings, do not forward.
          */
void netsukuku_coordinator_force_remove (NetsukukuCoordinator* self, gint pos) {
	NetsukukuBookings* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookings;
	_tmp1_ = pos;
	netsukuku_bookings_force_remove (_tmp0_, _tmp1_);
}


NetsukukuBnodeList* netsukuku_coordinator_get_bnode_list (NetsukukuCoordinator* self) {
	NetsukukuBnodeList* result = NULL;
	NetsukukuBnodeList* _tmp0_;
	NetsukukuBnodeList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bnode_list;
	_tmp1_ = netsukuku_bnode_list_clone (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean netsukuku_coordinator_register_bnode (NetsukukuCoordinator* self, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	_tmp0_ = is_border;
	if (_tmp0_) {
		NetsukukuBnodeList* _tmp1_;
		NetsukukuNIP* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean ret;
		_tmp1_ = self->priv->bnode_list;
		_tmp2_ = nip;
		_tmp3_ = has_tunnel;
		_tmp4_ = is_willing;
		_tmp5_ = netsukuku_bnode_list_update_bnode (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
		ret = _tmp5_;
		netsukuku_coordinator_forward_knowledge (self);
		result = ret;
		return result;
	} else {
		NetsukukuBnodeList* _tmp6_;
		NetsukukuNIP* _tmp7_;
		_tmp6_ = self->priv->bnode_list;
		_tmp7_ = nip;
		netsukuku_bnode_list_delete_bnode (_tmp6_, _tmp7_);
		netsukuku_coordinator_forward_knowledge (self);
		result = TRUE;
		return result;
	}
}


void netsukuku_coordinator_add_bnode_list (NetsukukuCoordinator* self, NetsukukuBnodeList* bnode_list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bnode_list != NULL);
	{
		NetsukukuBnodeList* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _bnode_record_it;
		_tmp0_ = bnode_list;
		_tmp1_ = netsukuku_bnode_list_iterator (_tmp0_);
		_bnode_record_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			NetsukukuBnodeRecord* bnode_record;
			NetsukukuBnodeList* _tmp6_;
			NetsukukuBnodeRecord* _tmp7_;
			_tmp2_ = _bnode_record_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _bnode_record_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			bnode_record = (NetsukukuBnodeRecord*) _tmp5_;
			_tmp6_ = bnode_list;
			_tmp7_ = bnode_record;
			netsukuku_bnode_list_copy_bnode (_tmp6_, _tmp7_);
			_g_object_unref0 (bnode_record);
		}
		_g_object_unref0 (_bnode_record_it);
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static gboolean _netsukuku_bnode_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_bnode_record_equal_func (a, b);
	return result;
}


static void netsukuku_coordinator_impl_manage_bnode_tunnels (NetsukukuCoordinator* self, GError** error) {
	TaskletsTasklet* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coordinator.manage_bnode_tunnels");
	_tmp0_ = tasklets_tasklet_self ();
	_g_object_unref0 (self->priv->manage_bnode_tunnels_handle);
	self->priv->manage_bnode_tunnels_handle = _tmp0_;
	netsukuku_log_debug ("Coord: manage_bnode_tunnels: started");
	while (TRUE) {
		{
			gboolean _tmp1_;
			gboolean _tmp2_;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			tasklets_ms_wait ((gint64) 10000);
			_tmp1_ = netsukuku_coordinator_get_is_main (self);
			_tmp2_ = _tmp1_;
			_tmp3_ = bool_to_string (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strconcat ("Coord: manage_bnode_tunnels: is_main = ", _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			netsukuku_log_debug (_tmp6_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp4_);
			_tmp7_ = netsukuku_coordinator_get_is_main (self);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				gint number_of_nodes;
				gint number_of_tunnels;
				gint _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				GeeArrayList* _tmp23_;
				GeeArrayList* candidates;
				gchar* _tmp34_;
				gchar* str_candidates;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_ = NULL;
				gchar* _tmp57_ = NULL;
				gchar* _tmp58_;
				GeeArrayList* _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				number_of_nodes = 50;
				number_of_tunnels = 0;
				{
					NetsukukuBnodeList* _tmp9_;
					GeeIterator* _tmp10_ = NULL;
					GeeIterator* _bn_it;
					_tmp9_ = self->priv->bnode_list;
					_tmp10_ = netsukuku_bnode_list_iterator (_tmp9_);
					_bn_it = _tmp10_;
					while (TRUE) {
						GeeIterator* _tmp11_;
						gboolean _tmp12_ = FALSE;
						GeeIterator* _tmp13_;
						gpointer _tmp14_ = NULL;
						NetsukukuBnodeRecord* bn;
						NetsukukuBnodeRecord* _tmp15_;
						gboolean _tmp16_;
						_tmp11_ = _bn_it;
						_tmp12_ = gee_iterator_next (_tmp11_);
						if (!_tmp12_) {
							break;
						}
						_tmp13_ = _bn_it;
						_tmp14_ = gee_iterator_get (_tmp13_);
						bn = (NetsukukuBnodeRecord*) _tmp14_;
						_tmp15_ = bn;
						_tmp16_ = _tmp15_->has_tunnel;
						if (_tmp16_) {
							gint _tmp17_;
							_tmp17_ = number_of_tunnels;
							number_of_tunnels = _tmp17_ + 1;
						}
						_g_object_unref0 (bn);
					}
					_g_object_unref0 (_bn_it);
				}
				_tmp18_ = number_of_tunnels;
				_tmp19_ = g_strdup_printf ("%i", _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat ("Coord: manage_bnode_tunnels: number_of_tunnels = ", _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				netsukuku_log_debug (_tmp22_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_tmp23_ = gee_array_list_new (NETSUKUKU_TYPE_BNODE_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_bnode_record_equal_func_gee_equal_data_func, NULL, NULL);
				candidates = _tmp23_;
				{
					NetsukukuBnodeList* _tmp24_;
					GeeIterator* _tmp25_ = NULL;
					GeeIterator* _bn_it;
					_tmp24_ = self->priv->bnode_list;
					_tmp25_ = netsukuku_bnode_list_iterator (_tmp24_);
					_bn_it = _tmp25_;
					while (TRUE) {
						GeeIterator* _tmp26_;
						gboolean _tmp27_ = FALSE;
						GeeIterator* _tmp28_;
						gpointer _tmp29_ = NULL;
						NetsukukuBnodeRecord* bn;
						NetsukukuBnodeRecord* _tmp30_;
						gboolean _tmp31_;
						_tmp26_ = _bn_it;
						_tmp27_ = gee_iterator_next (_tmp26_);
						if (!_tmp27_) {
							break;
						}
						_tmp28_ = _bn_it;
						_tmp29_ = gee_iterator_get (_tmp28_);
						bn = (NetsukukuBnodeRecord*) _tmp29_;
						_tmp30_ = bn;
						_tmp31_ = _tmp30_->is_willing;
						if (_tmp31_) {
							GeeArrayList* _tmp32_;
							NetsukukuBnodeRecord* _tmp33_;
							_tmp32_ = candidates;
							_tmp33_ = bn;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
						}
						_g_object_unref0 (bn);
					}
					_g_object_unref0 (_bn_it);
				}
				_tmp34_ = g_strdup ("[");
				str_candidates = _tmp34_;
				{
					GeeArrayList* _tmp35_;
					GeeArrayList* _tmp36_;
					GeeArrayList* _record_list;
					GeeArrayList* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint _record_size;
					gint _record_index;
					_tmp35_ = candidates;
					_tmp36_ = _g_object_ref0 (_tmp35_);
					_record_list = _tmp36_;
					_tmp37_ = _record_list;
					_tmp38_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp37_);
					_tmp39_ = _tmp38_;
					_record_size = _tmp39_;
					_record_index = -1;
					while (TRUE) {
						gint _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						GeeArrayList* _tmp43_;
						gint _tmp44_;
						gpointer _tmp45_ = NULL;
						NetsukukuBnodeRecord* record;
						const gchar* _tmp46_;
						NetsukukuBnodeRecord* _tmp47_;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_;
						gchar* _tmp50_ = NULL;
						gchar* _tmp51_;
						gchar* _tmp52_;
						_tmp40_ = _record_index;
						_record_index = _tmp40_ + 1;
						_tmp41_ = _record_index;
						_tmp42_ = _record_size;
						if (!(_tmp41_ < _tmp42_)) {
							break;
						}
						_tmp43_ = _record_list;
						_tmp44_ = _record_index;
						_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _tmp44_);
						record = (NetsukukuBnodeRecord*) _tmp45_;
						_tmp46_ = str_candidates;
						_tmp47_ = record;
						_tmp48_ = netsukuku_bnode_record_to_string (_tmp47_);
						_tmp49_ = _tmp48_;
						_tmp50_ = g_strconcat (_tmp49_, ",", NULL);
						_tmp51_ = _tmp50_;
						_tmp52_ = g_strconcat (_tmp46_, _tmp51_, NULL);
						_g_free0 (str_candidates);
						str_candidates = _tmp52_;
						_g_free0 (_tmp51_);
						_g_free0 (_tmp49_);
						_g_object_unref0 (record);
					}
					_g_object_unref0 (_record_list);
				}
				_tmp53_ = str_candidates;
				_tmp54_ = g_strconcat (_tmp53_, "]", NULL);
				_g_free0 (str_candidates);
				str_candidates = _tmp54_;
				_tmp55_ = str_candidates;
				_tmp56_ = string_to_string (_tmp55_);
				_tmp57_ = g_strconcat ("Coord: manage_bnode_tunnels: candidates = ", _tmp56_, NULL);
				_tmp58_ = _tmp57_;
				netsukuku_log_debug (_tmp58_);
				_g_free0 (_tmp58_);
				_tmp59_ = candidates;
				_tmp60_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp59_);
				_tmp61_ = _tmp60_;
				if (_tmp61_ >= 2) {
					gboolean _tmp62_ = FALSE;
					gint _tmp63_;
					gboolean _tmp66_;
					_tmp63_ = number_of_tunnels;
					if (_tmp63_ == 0) {
						_tmp62_ = TRUE;
					} else {
						gint _tmp64_;
						gint _tmp65_;
						_tmp64_ = number_of_nodes;
						_tmp65_ = number_of_tunnels;
						_tmp62_ = (_tmp64_ / _tmp65_) > 10;
					}
					_tmp66_ = _tmp62_;
					if (_tmp66_) {
						GeeArrayList* _tmp67_;
						netsukuku_log_debug ("Coord: manage_bnode_tunnels: a new tunnel is wanted");
						_tmp67_ = candidates;
						netsukuku_coordinator_arrange_tunnel (self, _tmp67_);
					}
				}
				_g_free0 (str_candidates);
				_g_object_unref0 (candidates);
			}
		}
		goto __finally36;
		__catch36_g_error:
		{
			GError* e = NULL;
			GError* _tmp68_;
			const gchar* _tmp69_;
			const gchar* _tmp70_ = NULL;
			NetsukukuPartialNIP* _tmp71_;
			gchar* _tmp72_ = NULL;
			gchar* _tmp73_;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp68_ = e;
			_tmp69_ = _tmp68_->message;
			_tmp70_ = string_to_string (_tmp69_);
			_tmp71_ = self->priv->_gnode;
			_tmp72_ = netsukuku_partial_nip_to_string (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strconcat ("Uncaught exception ", _tmp70_, " while manage_bnode_tunnels of ", _tmp73_, NULL);
			_tmp75_ = _tmp74_;
			netsukuku_log_error (_tmp75_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp73_);
			_g_error_free0 (e);
		}
		__finally36:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void* netsukuku_coordinator_helper_manage_bnode_tunnels (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_manage_bnode_tunnels (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_coordinator_manage_bnode_tunnels (NetsukukuCoordinator* self) {
	Netsukukustruct_helper_Coordinator_manage_bnode_tunnels arg = {0};
	NetsukukuCoordinator* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_coordinator_helper_manage_bnode_tunnels, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_coordinator_manage_bnode_tunnels_destroy (&arg);
}


static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_partial_nip_equal_func (a, b);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gint __lambda2_ (NetsukukuCoordinator* self, NetsukukuCoordinatorPair* a, NetsukukuCoordinatorPair* b) {
	gint result = 0;
	NetsukukuCoordinatorPair* _tmp0_;
	gconstpointer _tmp1_;
	NetsukukuPairNipDistance* _tmp2_;
	gint _tmp3_;
	NetsukukuCoordinatorPair* _tmp4_;
	gconstpointer _tmp5_;
	NetsukukuPairNipDistance* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = netsukuku_coordinator_pair_get_b (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((NetsukukuPairNipDistance*) _tmp2_)->distance;
	_tmp4_ = b;
	_tmp5_ = netsukuku_coordinator_pair_get_b (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = ((NetsukukuPairNipDistance*) _tmp6_)->distance;
	result = _tmp3_ - _tmp7_;
	return result;
}


static gint ___lambda2__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda2_ (self, a, b);
	return result;
}


void netsukuku_coordinator_arrange_tunnel (NetsukukuCoordinator* self, GeeArrayList* candidates) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* my_addr;
	NetsukukuAddressManagerTCPClient* remote_x = NULL;
	NetsukukuAddressManagerTCPClient* remote_y = NULL;
	GeeArrayList* _tmp10_;
	GeeArrayList* pool;
	GeeArrayList* _tmp110_;
	gboolean _tmp111_;
	gboolean _tmp112_;
	GCompareDataFunc cmp;
	void* cmp_target;
	GDestroyNotify cmp_target_destroy_notify;
	GeeArrayList* _tmp113_;
	GCompareDataFunc _tmp114_;
	void* _tmp114__target;
	GeeArrayList* _tmp115_;
	gpointer _tmp116_ = NULL;
	NetsukukuCoordinatorPair* _tmp117_;
	gconstpointer _tmp118_;
	NetsukukuNIP* _tmp119_;
	NetsukukuNIP* _tmp120_;
	NetsukukuNIP* _tmp121_;
	NetsukukuNIP* nip_x;
	GeeArrayList* _tmp122_;
	gpointer _tmp123_ = NULL;
	NetsukukuCoordinatorPair* _tmp124_;
	gconstpointer _tmp125_;
	NetsukukuPairNipDistance* _tmp126_;
	NetsukukuNIP* _tmp127_;
	NetsukukuNIP* _tmp128_;
	NetsukukuNIP* _tmp129_;
	NetsukukuNIP* nip_y;
	NetsukukuNIP* _tmp130_;
	gchar* _tmp131_ = NULL;
	gchar* _tmp132_;
	NetsukukuNIP* _tmp133_;
	gchar* _tmp134_ = NULL;
	gchar* _tmp135_;
	gchar* _tmp136_ = NULL;
	gchar* _tmp137_;
	NetsukukuMapRoute* _tmp138_;
	gint _tmp139_;
	gint _tmp140_;
	NetsukukuMapRoute* _tmp141_;
	gint _tmp142_;
	gint _tmp143_;
	NetsukukuNIP* _tmp144_;
	gchar* _tmp145_ = NULL;
	gchar* _tmp146_;
	const gchar* _tmp147_;
	NetsukukuAddressManagerTCPClient* _tmp148_;
	NetsukukuAddressManagerTCPClient* _tmp149_;
	NetsukukuIBorderNodesManager* _tmp150_;
	NetsukukuIBorderNodesManager* _tmp151_;
	NetsukukuPartialNIP* _tmp152_;
	NetsukukuNIP* _tmp153_ = NULL;
	NetsukukuNIP* nip_x_secondary;
	NetsukukuNIP* _tmp154_;
	gchar* _tmp155_ = NULL;
	gchar* _tmp156_;
	gchar* _tmp157_ = NULL;
	gchar* _tmp158_;
	NetsukukuMapRoute* _tmp159_;
	gint _tmp160_;
	gint _tmp161_;
	NetsukukuMapRoute* _tmp162_;
	gint _tmp163_;
	gint _tmp164_;
	NetsukukuNIP* _tmp165_;
	gchar* _tmp166_ = NULL;
	gchar* _tmp167_;
	const gchar* _tmp168_;
	NetsukukuAddressManagerTCPClient* _tmp169_;
	NetsukukuAddressManagerTCPClient* _tmp170_;
	NetsukukuIBorderNodesManager* _tmp171_;
	NetsukukuIBorderNodesManager* _tmp172_;
	NetsukukuPartialNIP* _tmp173_;
	NetsukukuNIP* _tmp174_;
	NetsukukuNIP* _tmp175_ = NULL;
	NetsukukuNIP* nip_y_secondary;
	NetsukukuNIP* _tmp176_;
	gchar* _tmp177_ = NULL;
	gchar* _tmp178_;
	gchar* _tmp179_ = NULL;
	gchar* _tmp180_;
	NetsukukuNIP* _tmp181_;
	gchar* _tmp182_ = NULL;
	gchar* _tmp183_;
	NetsukukuNIP* _tmp184_;
	gchar* _tmp185_ = NULL;
	gchar* _tmp186_;
	gchar* _tmp187_ = NULL;
	gchar* _tmp188_;
	NetsukukuAddressManagerTCPClient* _tmp189_;
	NetsukukuIBorderNodesManager* _tmp190_;
	NetsukukuIBorderNodesManager* _tmp191_;
	NetsukukuNIP* _tmp192_;
	NetsukukuNIP* _tmp193_;
	NetsukukuNIP* _tmp194_;
	gchar* _tmp195_ = NULL;
	gchar* _tmp196_;
	NetsukukuNIP* _tmp197_;
	gchar* _tmp198_ = NULL;
	gchar* _tmp199_;
	gchar* _tmp200_ = NULL;
	gchar* _tmp201_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (candidates != NULL);
	_tmp0_ = self->priv->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	my_addr = _tmp9_;
	_tmp10_ = gee_array_list_new (NETSUKUKU_COORDINATOR_TYPE_PAIR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	pool = _tmp10_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				gint _tmp14_;
				GeeArrayList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				GeeArrayList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_ = NULL;
				NetsukukuBnodeRecord* _tmp21_;
				NetsukukuNIP* _tmp22_;
				NetsukukuNIP* _tmp23_;
				NetsukukuNIP* _tmp24_;
				NetsukukuNIP* _tmp25_;
				NetsukukuNIP* x;
				GeeArrayList* _tmp26_;
				GeeArrayList* list_of_y;
				NetsukukuMapRoute* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				NetsukukuMapRoute* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				NetsukukuNIP* _tmp48_;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				const gchar* _tmp51_;
				NetsukukuAddressManagerTCPClient* _tmp52_;
				NetsukukuAddressManagerTCPClient* _tmp53_;
				NetsukukuIBorderNodesManager* _tmp54_;
				NetsukukuIBorderNodesManager* _tmp55_;
				NetsukukuPartialNIP* _tmp56_;
				GeeArrayList* _tmp57_;
				GeeList* _tmp58_ = NULL;
				GeeList* dists;
				gchar* _tmp59_;
				gchar* str_dists;
				const gchar* _tmp78_;
				const gchar* _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				gchar* _tmp82_ = NULL;
				gchar* _tmp83_;
				gchar* _tmp84_;
				NetsukukuNIP* _tmp85_;
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_ = NULL;
				gchar* _tmp90_ = NULL;
				gchar* _tmp91_;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = candidates;
				_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp15_);
				_tmp17_ = _tmp16_;
				if (!(_tmp14_ < _tmp17_)) {
					break;
				}
				_tmp18_ = candidates;
				_tmp19_ = i;
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
				_tmp21_ = (NetsukukuBnodeRecord*) _tmp20_;
				_tmp22_ = netsukuku_bnode_record_get_nip (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				_tmp25_ = _tmp24_;
				_g_object_unref0 (_tmp21_);
				x = _tmp25_;
				_tmp26_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
				list_of_y = _tmp26_;
				{
					gint _tmp27_;
					gint j;
					_tmp27_ = i;
					j = _tmp27_ + 1;
					{
						gboolean _tmp28_;
						_tmp28_ = TRUE;
						while (TRUE) {
							gboolean _tmp29_;
							gint _tmp31_;
							GeeArrayList* _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							GeeArrayList* _tmp35_;
							GeeArrayList* _tmp36_;
							gint _tmp37_;
							gpointer _tmp38_ = NULL;
							NetsukukuBnodeRecord* _tmp39_;
							NetsukukuNIP* _tmp40_;
							NetsukukuNIP* _tmp41_;
							_tmp29_ = _tmp28_;
							if (!_tmp29_) {
								gint _tmp30_;
								_tmp30_ = j;
								j = _tmp30_ + 1;
							}
							_tmp28_ = FALSE;
							_tmp31_ = j;
							_tmp32_ = candidates;
							_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
							_tmp34_ = _tmp33_;
							if (!(_tmp31_ < _tmp34_)) {
								break;
							}
							_tmp35_ = list_of_y;
							_tmp36_ = candidates;
							_tmp37_ = j;
							_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp37_);
							_tmp39_ = (NetsukukuBnodeRecord*) _tmp38_;
							_tmp40_ = netsukuku_bnode_record_get_nip (_tmp39_);
							_tmp41_ = _tmp40_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp41_);
							_g_object_unref0 (_tmp39_);
						}
					}
				}
				_tmp42_ = self->priv->maproute;
				_tmp43_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = self->priv->maproute;
				_tmp46_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = x;
				_tmp49_ = netsukuku_nip_to_str (_tmp44_, _tmp47_, _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = my_addr;
				_tmp52_ = netsukuku_address_manager_tcp_client_new (_tmp50_, NULL, _tmp51_, TRUE);
				_g_object_unref0 (remote_x);
				remote_x = _tmp52_;
				_g_free0 (_tmp50_);
				_tmp53_ = remote_x;
				_tmp54_ = netsukuku_iaddress_manager_root_dispatcher_get_border_nodes_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = self->priv->_gnode;
				_tmp57_ = list_of_y;
				_tmp58_ = netsukuku_iborder_nodes_manager_get_distances (_tmp55_, _tmp56_, (GeeList*) _tmp57_, NULL, &_inner_error_);
				dists = _tmp58_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (list_of_y);
					_g_object_unref0 (x);
					_g_object_unref0 (pool);
					_g_object_unref0 (remote_y);
					_g_object_unref0 (remote_x);
					_g_free0 (my_addr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp59_ = g_strdup ("{");
				str_dists = _tmp59_;
				{
					GeeList* _tmp60_;
					GeeList* _tmp61_;
					GeeList* __dist_list;
					GeeList* _tmp62_;
					gint _tmp63_;
					gint _tmp64_;
					gint __dist_size;
					gint __dist_index;
					_tmp60_ = dists;
					_tmp61_ = _g_object_ref0 (_tmp60_);
					__dist_list = _tmp61_;
					_tmp62_ = __dist_list;
					_tmp63_ = gee_collection_get_size ((GeeCollection*) _tmp62_);
					_tmp64_ = _tmp63_;
					__dist_size = _tmp64_;
					__dist_index = -1;
					while (TRUE) {
						gint _tmp65_;
						gint _tmp66_;
						gint _tmp67_;
						GeeList* _tmp68_;
						gint _tmp69_;
						gpointer _tmp70_ = NULL;
						NetsukukuPairNipDistance* _dist;
						const gchar* _tmp71_;
						NetsukukuPairNipDistance* _tmp72_;
						gchar* _tmp73_ = NULL;
						gchar* _tmp74_;
						gchar* _tmp75_ = NULL;
						gchar* _tmp76_;
						gchar* _tmp77_;
						_tmp65_ = __dist_index;
						__dist_index = _tmp65_ + 1;
						_tmp66_ = __dist_index;
						_tmp67_ = __dist_size;
						if (!(_tmp66_ < _tmp67_)) {
							break;
						}
						_tmp68_ = __dist_list;
						_tmp69_ = __dist_index;
						_tmp70_ = gee_list_get (_tmp68_, _tmp69_);
						_dist = (NetsukukuPairNipDistance*) _tmp70_;
						_tmp71_ = str_dists;
						_tmp72_ = _dist;
						_tmp73_ = netsukuku_pair_nip_distance_to_string (_tmp72_);
						_tmp74_ = _tmp73_;
						_tmp75_ = g_strconcat (_tmp74_, ", ", NULL);
						_tmp76_ = _tmp75_;
						_tmp77_ = g_strconcat (_tmp71_, _tmp76_, NULL);
						_g_free0 (str_dists);
						str_dists = _tmp77_;
						_g_free0 (_tmp76_);
						_g_free0 (_tmp74_);
						_g_object_unref0 (_dist);
					}
					_g_object_unref0 (__dist_list);
				}
				_tmp78_ = str_dists;
				_tmp79_ = str_dists;
				_tmp80_ = strlen (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = string_substring (_tmp78_, (glong) 0, (glong) (_tmp81_ - 2));
				_tmp83_ = _tmp82_;
				_tmp84_ = g_strconcat (_tmp83_, "}", NULL);
				_g_free0 (str_dists);
				str_dists = _tmp84_;
				_g_free0 (_tmp83_);
				_tmp85_ = x;
				_tmp86_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = str_dists;
				_tmp89_ = string_to_string (_tmp88_);
				_tmp90_ = g_strconcat ("Coord: manage_bnode_tunnels: ", _tmp87_, " dists = ", _tmp89_, NULL);
				_tmp91_ = _tmp90_;
				netsukuku_log_debug (_tmp91_);
				_g_free0 (_tmp91_);
				_g_free0 (_tmp87_);
				{
					GeeList* _tmp92_;
					GeeList* _tmp93_;
					GeeList* _y_dist_list;
					GeeList* _tmp94_;
					gint _tmp95_;
					gint _tmp96_;
					gint _y_dist_size;
					gint _y_dist_index;
					_tmp92_ = dists;
					_tmp93_ = _g_object_ref0 (_tmp92_);
					_y_dist_list = _tmp93_;
					_tmp94_ = _y_dist_list;
					_tmp95_ = gee_collection_get_size ((GeeCollection*) _tmp94_);
					_tmp96_ = _tmp95_;
					_y_dist_size = _tmp96_;
					_y_dist_index = -1;
					while (TRUE) {
						gint _tmp97_;
						gint _tmp98_;
						gint _tmp99_;
						GeeList* _tmp100_;
						gint _tmp101_;
						gpointer _tmp102_ = NULL;
						NetsukukuPairNipDistance* y_dist;
						NetsukukuPairNipDistance* _tmp103_;
						gint _tmp104_;
						_tmp97_ = _y_dist_index;
						_y_dist_index = _tmp97_ + 1;
						_tmp98_ = _y_dist_index;
						_tmp99_ = _y_dist_size;
						if (!(_tmp98_ < _tmp99_)) {
							break;
						}
						_tmp100_ = _y_dist_list;
						_tmp101_ = _y_dist_index;
						_tmp102_ = gee_list_get (_tmp100_, _tmp101_);
						y_dist = (NetsukukuPairNipDistance*) _tmp102_;
						_tmp103_ = y_dist;
						_tmp104_ = _tmp103_->distance;
						if (_tmp104_ > 1) {
							GeeArrayList* _tmp105_;
							NetsukukuNIP* _tmp106_;
							NetsukukuPairNipDistance* _tmp107_;
							NetsukukuCoordinatorPair* _tmp108_;
							NetsukukuCoordinatorPair* _tmp109_;
							_tmp105_ = pool;
							_tmp106_ = x;
							_tmp107_ = y_dist;
							_tmp108_ = netsukuku_coordinator_pair_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_PAIR_NIP_DISTANCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp106_, _tmp107_);
							_tmp109_ = _tmp108_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp105_, _tmp109_);
							_g_object_unref0 (_tmp109_);
						}
						_g_object_unref0 (y_dist);
					}
					_g_object_unref0 (_y_dist_list);
				}
				_g_free0 (str_dists);
				_g_object_unref0 (dists);
				_g_object_unref0 (list_of_y);
				_g_object_unref0 (x);
			}
		}
	}
	_tmp110_ = pool;
	_tmp111_ = gee_collection_get_is_empty ((GeeCollection*) _tmp110_);
	_tmp112_ = _tmp111_;
	if (_tmp112_) {
		_g_object_unref0 (pool);
		_g_object_unref0 (remote_y);
		_g_object_unref0 (remote_x);
		_g_free0 (my_addr);
		return;
	}
	cmp = ___lambda2__gcompare_data_func;
	cmp_target = g_object_ref (self);
	cmp_target_destroy_notify = g_object_unref;
	_tmp113_ = pool;
	_tmp114_ = cmp;
	_tmp114__target = cmp_target;
	gee_list_sort ((GeeList*) _tmp113_, _tmp114_, _tmp114__target, NULL);
	_tmp115_ = pool;
	_tmp116_ = gee_abstract_list_get ((GeeAbstractList*) _tmp115_, 0);
	_tmp117_ = (NetsukukuCoordinatorPair*) _tmp116_;
	_tmp118_ = netsukuku_coordinator_pair_get_a (_tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = _g_object_ref0 ((NetsukukuNIP*) _tmp119_);
	_tmp121_ = _tmp120_;
	_g_object_unref0 (_tmp117_);
	nip_x = _tmp121_;
	_tmp122_ = pool;
	_tmp123_ = gee_abstract_list_get ((GeeAbstractList*) _tmp122_, 0);
	_tmp124_ = (NetsukukuCoordinatorPair*) _tmp123_;
	_tmp125_ = netsukuku_coordinator_pair_get_b (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = ((NetsukukuPairNipDistance*) _tmp126_)->nip;
	_tmp128_ = _g_object_ref0 (_tmp127_);
	_tmp129_ = _tmp128_;
	_g_object_unref0 (_tmp124_);
	nip_y = _tmp129_;
	_tmp130_ = nip_x;
	_tmp131_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp130_);
	_tmp132_ = _tmp131_;
	_tmp133_ = nip_y;
	_tmp134_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp133_);
	_tmp135_ = _tmp134_;
	_tmp136_ = g_strconcat ("Coord: arrange_tunnel: between x ", _tmp132_, " and y ", _tmp135_, NULL);
	_tmp137_ = _tmp136_;
	netsukuku_log_debug (_tmp137_);
	_g_free0 (_tmp137_);
	_g_free0 (_tmp135_);
	_g_free0 (_tmp132_);
	_tmp138_ = self->priv->maproute;
	_tmp139_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp138_);
	_tmp140_ = _tmp139_;
	_tmp141_ = self->priv->maproute;
	_tmp142_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp141_);
	_tmp143_ = _tmp142_;
	_tmp144_ = nip_x;
	_tmp145_ = netsukuku_nip_to_str (_tmp140_, _tmp143_, _tmp144_);
	_tmp146_ = _tmp145_;
	_tmp147_ = my_addr;
	_tmp148_ = netsukuku_address_manager_tcp_client_new (_tmp146_, NULL, _tmp147_, TRUE);
	_g_object_unref0 (remote_x);
	remote_x = _tmp148_;
	_g_free0 (_tmp146_);
	_tmp149_ = remote_x;
	_tmp150_ = netsukuku_iaddress_manager_root_dispatcher_get_border_nodes_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp149_);
	_tmp151_ = _tmp150_;
	_tmp152_ = self->priv->_gnode;
	_tmp153_ = netsukuku_iborder_nodes_manager_get_new_address (_tmp151_, _tmp152_, NULL, NULL, &_inner_error_);
	nip_x_secondary = _tmp153_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (nip_y);
		_g_object_unref0 (nip_x);
		(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
		cmp = NULL;
		cmp_target = NULL;
		cmp_target_destroy_notify = NULL;
		_g_object_unref0 (pool);
		_g_object_unref0 (remote_y);
		_g_object_unref0 (remote_x);
		_g_free0 (my_addr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp154_ = nip_x_secondary;
	_tmp155_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp154_);
	_tmp156_ = _tmp155_;
	_tmp157_ = g_strconcat ("Coord: arrange_tunnel: x has secondary ", _tmp156_, NULL);
	_tmp158_ = _tmp157_;
	netsukuku_log_debug (_tmp158_);
	_g_free0 (_tmp158_);
	_g_free0 (_tmp156_);
	_tmp159_ = self->priv->maproute;
	_tmp160_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp159_);
	_tmp161_ = _tmp160_;
	_tmp162_ = self->priv->maproute;
	_tmp163_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp162_);
	_tmp164_ = _tmp163_;
	_tmp165_ = nip_y;
	_tmp166_ = netsukuku_nip_to_str (_tmp161_, _tmp164_, _tmp165_);
	_tmp167_ = _tmp166_;
	_tmp168_ = my_addr;
	_tmp169_ = netsukuku_address_manager_tcp_client_new (_tmp167_, NULL, _tmp168_, TRUE);
	_g_object_unref0 (remote_y);
	remote_y = _tmp169_;
	_g_free0 (_tmp167_);
	_tmp170_ = remote_y;
	_tmp171_ = netsukuku_iaddress_manager_root_dispatcher_get_border_nodes_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp170_);
	_tmp172_ = _tmp171_;
	_tmp173_ = self->priv->_gnode;
	_tmp174_ = nip_x_secondary;
	_tmp175_ = netsukuku_iborder_nodes_manager_get_new_address (_tmp172_, _tmp173_, _tmp174_, NULL, &_inner_error_);
	nip_y_secondary = _tmp175_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (nip_x_secondary);
		_g_object_unref0 (nip_y);
		_g_object_unref0 (nip_x);
		(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
		cmp = NULL;
		cmp_target = NULL;
		cmp_target_destroy_notify = NULL;
		_g_object_unref0 (pool);
		_g_object_unref0 (remote_y);
		_g_object_unref0 (remote_x);
		_g_free0 (my_addr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp176_ = nip_y_secondary;
	_tmp177_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp176_);
	_tmp178_ = _tmp177_;
	_tmp179_ = g_strconcat ("Coord: arrange_tunnel: y has secondary ", _tmp178_, NULL);
	_tmp180_ = _tmp179_;
	netsukuku_log_debug (_tmp180_);
	_g_free0 (_tmp180_);
	_g_free0 (_tmp178_);
	_tmp181_ = nip_x_secondary;
	_tmp182_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp181_);
	_tmp183_ = _tmp182_;
	_tmp184_ = nip_y_secondary;
	_tmp185_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp184_);
	_tmp186_ = _tmp185_;
	_tmp187_ = g_strconcat ("Coord: arrange_tunnel: passed ", _tmp183_, " to ", _tmp186_, NULL);
	_tmp188_ = _tmp187_;
	netsukuku_log_debug (_tmp188_);
	_g_free0 (_tmp188_);
	_g_free0 (_tmp186_);
	_g_free0 (_tmp183_);
	_tmp189_ = remote_x;
	_tmp190_ = netsukuku_iaddress_manager_root_dispatcher_get_border_nodes_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp189_);
	_tmp191_ = _tmp190_;
	_tmp192_ = nip_x_secondary;
	_tmp193_ = nip_y_secondary;
	netsukuku_iborder_nodes_manager_assign_peer_nip (_tmp191_, _tmp192_, _tmp193_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (nip_y_secondary);
		_g_object_unref0 (nip_x_secondary);
		_g_object_unref0 (nip_y);
		_g_object_unref0 (nip_x);
		(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
		cmp = NULL;
		cmp_target = NULL;
		cmp_target_destroy_notify = NULL;
		_g_object_unref0 (pool);
		_g_object_unref0 (remote_y);
		_g_object_unref0 (remote_x);
		_g_free0 (my_addr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp194_ = nip_y_secondary;
	_tmp195_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp194_);
	_tmp196_ = _tmp195_;
	_tmp197_ = nip_x_secondary;
	_tmp198_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp197_);
	_tmp199_ = _tmp198_;
	_tmp200_ = g_strconcat ("Coord: arrange_tunnel: passed ", _tmp196_, " to ", _tmp199_, NULL);
	_tmp201_ = _tmp200_;
	netsukuku_log_debug (_tmp201_);
	_g_free0 (_tmp201_);
	_g_free0 (_tmp199_);
	_g_free0 (_tmp196_);
	_g_object_unref0 (nip_y_secondary);
	_g_object_unref0 (nip_x_secondary);
	_g_object_unref0 (nip_y);
	_g_object_unref0 (nip_x);
	(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
	cmp = NULL;
	cmp_target = NULL;
	cmp_target_destroy_notify = NULL;
	_g_object_unref0 (pool);
	_g_object_unref0 (remote_y);
	_g_object_unref0 (remote_x);
	_g_free0 (my_addr);
}


static void _vala_array_add4 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuNIP*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void netsukuku_coordinator_impl_forward_knowledge (NetsukukuCoordinator* self, GError** error) {
	NetsukukuCoord_hkey* _tmp0_;
	NetsukukuCoord_hkey* key;
	gint _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuCoord* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hash_nip;
	NetsukukuCoord* _tmp8_;
	gint _tmp9_;
	GeeList* _tmp10_ = NULL;
	GeeList* bunch;
	NetsukukuNIP** _tmp11_ = NULL;
	NetsukukuNIP** bunch_not_me;
	gint bunch_not_me_length1;
	gint _bunch_not_me_size_;
	NetsukukuNIP** _tmp30_;
	gint _tmp30__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coordinator.forward_knowledge");
	_tmp0_ = netsukuku_coord_hkey_new ();
	key = _tmp0_;
	_tmp1_ = self->priv->level_of_gnode;
	key->level_of_gnode = _tmp1_;
	_tmp2_ = self->priv->maproute;
	_tmp3_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (key->nip);
	key->nip = _tmp5_;
	_tmp6_ = self->priv->parent;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp6_, (GObject*) key);
	hash_nip = _tmp7_;
	_tmp8_ = self->priv->parent;
	_tmp9_ = self->priv->level_of_gnode;
	_tmp10_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) _tmp8_, hash_nip, NETSUKUKU_COORD_DUPLICATION, &_tmp9_, &_inner_error_);
	bunch = _tmp10_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (hash_nip);
		_g_object_unref0 (key);
		return;
	}
	_tmp11_ = g_new0 (NetsukukuNIP*, 0 + 1);
	bunch_not_me = _tmp11_;
	bunch_not_me_length1 = 0;
	_bunch_not_me_size_ = bunch_not_me_length1;
	{
		GeeList* _tmp12_;
		GeeList* _n_list;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _n_size;
		gint _n_index;
		_tmp12_ = _g_object_ref0 (bunch);
		_n_list = _tmp12_;
		_tmp13_ = _n_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_n_size = _tmp15_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_ = NULL;
			NetsukukuNIP* n;
			NetsukukuNIP* _tmp22_;
			NetsukukuMapRoute* _tmp23_;
			NetsukukuNIP* _tmp24_;
			NetsukukuNIP* _tmp25_;
			gboolean _tmp26_ = FALSE;
			_tmp16_ = _n_index;
			_n_index = _tmp16_ + 1;
			_tmp17_ = _n_index;
			_tmp18_ = _n_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _n_list;
			_tmp20_ = _n_index;
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
			n = (NetsukukuNIP*) _tmp21_;
			_tmp22_ = n;
			_tmp23_ = self->priv->maproute;
			_tmp24_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp22_, (NetsukukuPartialNIP*) _tmp25_);
			if (!_tmp26_) {
				NetsukukuNIP** _tmp27_;
				gint _tmp27__length1;
				NetsukukuNIP* _tmp28_;
				NetsukukuNIP* _tmp29_;
				_tmp27_ = bunch_not_me;
				_tmp27__length1 = bunch_not_me_length1;
				_tmp28_ = n;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_vala_array_add4 (&bunch_not_me, &bunch_not_me_length1, &_bunch_not_me_size_, _tmp29_);
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	_tmp30_ = bunch_not_me;
	_tmp30__length1 = bunch_not_me_length1;
	{
		NetsukukuNIP** to_nip_collection = NULL;
		gint to_nip_collection_length1 = 0;
		gint _to_nip_collection_size_ = 0;
		gint to_nip_it = 0;
		to_nip_collection = _tmp30_;
		to_nip_collection_length1 = _tmp30__length1;
		for (to_nip_it = 0; to_nip_it < _tmp30__length1; to_nip_it = to_nip_it + 1) {
			NetsukukuNIP* _tmp31_;
			NetsukukuNIP* to_nip = NULL;
			_tmp31_ = _g_object_ref0 (to_nip_collection[to_nip_it]);
			to_nip = _tmp31_;
			{
				NetsukukuNIP* _tmp32_;
				_tmp32_ = to_nip;
				netsukuku_coordinator_forward_knowledge_to_nip (self, _tmp32_);
				_g_object_unref0 (to_nip);
			}
		}
	}
	bunch_not_me = (_vala_array_free (bunch_not_me, bunch_not_me_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (bunch);
	_g_object_unref0 (hash_nip);
	_g_object_unref0 (key);
}


static void* netsukuku_coordinator_helper_forward_knowledge (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_forward_knowledge* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_forward_knowledge*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_forward_knowledge (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


/** Communicate to secondary coordinators all our current knowledge.
          */
void netsukuku_coordinator_forward_knowledge (NetsukukuCoordinator* self) {
	Netsukukustruct_helper_Coordinator_forward_knowledge arg = {0};
	NetsukukuCoordinator* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_forward_knowledge));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_coordinator_helper_forward_knowledge, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_coordinator_forward_knowledge_destroy (&arg);
}


static void netsukuku_coordinator_impl_forward_knowledge_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, GError** error) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuNIP* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* dest_addr;
	NetsukukuMapRoute* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	NetsukukuMapRoute* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	NetsukukuNIP* _tmp15_;
	NetsukukuNIP* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* my_addr;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	NetsukukuAddressManagerTCPClient* _tmp21_;
	NetsukukuAddressManagerTCPClient* remote;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_nip != NULL);
	tasklets_tasklet_declare_self ("Coordinator.forward_knowledge_to_nip");
	_tmp0_ = self->priv->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = to_nip;
	_tmp7_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp6_);
	dest_addr = _tmp7_;
	_tmp8_ = self->priv->maproute;
	_tmp9_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->maproute;
	_tmp12_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->maproute;
	_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_nip_to_str (_tmp10_, _tmp13_, _tmp16_);
	my_addr = _tmp17_;
	_tmp18_ = string_to_string (dest_addr);
	_tmp19_ = g_strconcat ("Coord: forwarding knowledge to ", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	netsukuku_log_debug (_tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = netsukuku_address_manager_tcp_client_new (dest_addr, NULL, my_addr, FALSE);
	remote = _tmp21_;
	{
		NetsukukuICoord* _tmp22_;
		NetsukukuICoord* _tmp23_;
		NetsukukuPartialNIP* _tmp24_;
		NetsukukuPartialNIP* _tmp25_;
		NetsukukuBookings* _tmp26_ = NULL;
		NetsukukuBookings* _tmp27_;
		gint _tmp28_;
		NetsukukuBnodeList* _tmp29_ = NULL;
		NetsukukuBnodeList* _tmp30_;
		NetsukukuCoordinatorKnowledge* _tmp31_;
		NetsukukuCoordinatorKnowledge* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		_tmp22_ = netsukuku_iaddress_manager_root_dispatcher_get_coordnode ((NetsukukuIAddressManagerRootDispatcher*) remote);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_gnode;
		_tmp25_ = self->priv->_gnode;
		_tmp26_ = netsukuku_coordinator_get_bookings (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->last_assigned_elderliness;
		_tmp29_ = netsukuku_coordinator_get_bnode_list (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = netsukuku_coordinator_knowledge_new (_tmp25_, _tmp27_, _tmp28_, _tmp30_);
		_tmp32_ = _tmp31_;
		netsukuku_icoord_duplicate_all_knowledge (_tmp23_, _tmp24_, _tmp32_, &_inner_error_);
		_g_object_unref0 (_tmp32_);
		_g_object_unref0 (_tmp30_);
		_g_object_unref0 (_tmp27_);
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
		_tmp33_ = string_to_string (dest_addr);
		_tmp34_ = g_strconcat ("Coord: forwarded knowledge to ", _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		netsukuku_log_debug (_tmp35_);
		_g_free0 (_tmp35_);
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp36_ = NULL;
		GError* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp36_ = string_to_string (dest_addr);
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat ("'Coord: forwarded knowledge to ", _tmp36_, " got exception ", _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		netsukuku_log_warn (_tmp41_);
		_g_free0 (_tmp41_);
		_g_error_free0 (e);
	}
	__finally37:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (remote);
		_g_free0 (my_addr);
		_g_free0 (dest_addr);
		return;
	}
	_g_object_unref0 (remote);
	_g_free0 (my_addr);
	_g_free0 (dest_addr);
}


static void* netsukuku_coordinator_helper_forward_knowledge_to_nip (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* nip_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).nip;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	nip_save = _tmp4_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_forward_knowledge_to_nip (self_save, nip_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (nip_save);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (nip_save);
	_g_object_unref0 (self_save);
	return result;
}


/** Forwards all current knowledge to a secondary coordinator.
          */
void netsukuku_coordinator_forward_knowledge_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* nip) {
	Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip arg = {0};
	NetsukukuCoordinator* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	TaskletsTasklet* _tmp3_ = NULL;
	TaskletsTasklet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = nip;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (arg.nip);
	arg.nip = _tmp2_;
	_tmp3_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_coordinator_helper_forward_knowledge_to_nip, &arg, FALSE, -1);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_destroy (&arg);
}


NetsukukuPartialNIP* netsukuku_coordinator_get_gnode (NetsukukuCoordinator* self) {
	NetsukukuPartialNIP* result;
	NetsukukuPartialNIP* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnode;
	result = _tmp0_;
	return result;
}


static void netsukuku_coordinator_set_gnode (NetsukukuCoordinator* self, NetsukukuPartialNIP* value) {
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuPartialNIP* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_gnode);
	self->priv->_gnode = _tmp1_;
	g_object_notify ((GObject *) self, "gnode");
}


gboolean netsukuku_coordinator_get_is_main (NetsukukuCoordinator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_main_latest_evaluation;
	result = _tmp0_;
	return result;
}


gboolean netsukuku_coordinator_get_was_main (NetsukukuCoordinator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_main_previous_state;
	result = _tmp0_;
	return result;
}


static NetsukukuCoordinatorPair* netsukuku_coordinator_pair_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, gconstpointer a, gconstpointer b) {
	NetsukukuCoordinatorPair * self = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (NetsukukuCoordinatorPair*) g_object_new (object_type, NULL);
	self->priv->a_type = a_type;
	self->priv->a_dup_func = a_dup_func;
	self->priv->a_destroy_func = a_destroy_func;
	self->priv->b_type = b_type;
	self->priv->b_dup_func = b_dup_func;
	self->priv->b_destroy_func = b_destroy_func;
	_tmp0_ = a;
	netsukuku_coordinator_pair_set_a (self, _tmp0_);
	_tmp1_ = b;
	netsukuku_coordinator_pair_set_b (self, _tmp1_);
	return self;
}


static NetsukukuCoordinatorPair* netsukuku_coordinator_pair_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, gconstpointer a, gconstpointer b) {
	return netsukuku_coordinator_pair_construct (NETSUKUKU_COORDINATOR_TYPE_PAIR, a_type, a_dup_func, a_destroy_func, b_type, b_dup_func, b_destroy_func, a, b);
}


static gconstpointer netsukuku_coordinator_pair_get_a (NetsukukuCoordinatorPair* self) {
	gconstpointer result;
	gconstpointer _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_a;
	result = _tmp0_;
	return result;
}


static void netsukuku_coordinator_pair_set_a (NetsukukuCoordinatorPair* self, gconstpointer value) {
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->a_dup_func != NULL)) ? self->priv->a_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	((self->priv->_a == NULL) || (self->priv->a_destroy_func == NULL)) ? NULL : (self->priv->_a = (self->priv->a_destroy_func (self->priv->_a), NULL));
	self->priv->_a = _tmp1_;
	g_object_notify ((GObject *) self, "a");
}


static gconstpointer netsukuku_coordinator_pair_get_b (NetsukukuCoordinatorPair* self) {
	gconstpointer result;
	gconstpointer _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_b;
	result = _tmp0_;
	return result;
}


static void netsukuku_coordinator_pair_set_b (NetsukukuCoordinatorPair* self, gconstpointer value) {
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->b_dup_func != NULL)) ? self->priv->b_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	((self->priv->_b == NULL) || (self->priv->b_destroy_func == NULL)) ? NULL : (self->priv->_b = (self->priv->b_destroy_func (self->priv->_b), NULL));
	self->priv->_b = _tmp1_;
	g_object_notify ((GObject *) self, "b");
}


static void netsukuku_coordinator_pair_class_init (NetsukukuCoordinatorPairClass * klass) {
	netsukuku_coordinator_pair_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCoordinatorPairPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_coordinator_pair_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_coordinator_pair_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coordinator_pair_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_A_TYPE, g_param_spec_gtype ("a-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_A_DUP_FUNC, g_param_spec_pointer ("a-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_A_DESTROY_FUNC, g_param_spec_pointer ("a-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_B_TYPE, g_param_spec_gtype ("b-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_B_DUP_FUNC, g_param_spec_pointer ("b-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_B_DESTROY_FUNC, g_param_spec_pointer ("b-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_A, g_param_spec_pointer ("a", "a", "a", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_B, g_param_spec_pointer ("b", "b", "b", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_coordinator_pair_instance_init (NetsukukuCoordinatorPair * self) {
	self->priv = NETSUKUKU_COORDINATOR_PAIR_GET_PRIVATE (self);
}


static void netsukuku_coordinator_pair_finalize (GObject* obj) {
	NetsukukuCoordinatorPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPair);
	((self->priv->_a == NULL) || (self->priv->a_destroy_func == NULL)) ? NULL : (self->priv->_a = (self->priv->a_destroy_func (self->priv->_a), NULL));
	((self->priv->_b == NULL) || (self->priv->b_destroy_func == NULL)) ? NULL : (self->priv->_b = (self->priv->b_destroy_func (self->priv->_b), NULL));
	G_OBJECT_CLASS (netsukuku_coordinator_pair_parent_class)->finalize (obj);
}


static GType netsukuku_coordinator_pair_get_type (void) {
	static volatile gsize netsukuku_coordinator_pair_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coordinator_pair_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoordinatorPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coordinator_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoordinatorPair), 0, (GInstanceInitFunc) netsukuku_coordinator_pair_instance_init, NULL };
		GType netsukuku_coordinator_pair_type_id;
		netsukuku_coordinator_pair_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuCoordinatorPair", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_coordinator_pair_type_id__volatile, netsukuku_coordinator_pair_type_id);
	}
	return netsukuku_coordinator_pair_type_id__volatile;
}


static void _vala_netsukuku_coordinator_pair_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuCoordinatorPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPair);
	switch (property_id) {
		case NETSUKUKU_COORDINATOR_PAIR_A:
		g_value_set_pointer (value, netsukuku_coordinator_pair_get_a (self));
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B:
		g_value_set_pointer (value, netsukuku_coordinator_pair_get_b (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_coordinator_pair_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuCoordinatorPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPair);
	switch (property_id) {
		case NETSUKUKU_COORDINATOR_PAIR_A:
		netsukuku_coordinator_pair_set_a (self, g_value_get_pointer (value));
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B:
		netsukuku_coordinator_pair_set_b (self, g_value_get_pointer (value));
		break;
		case NETSUKUKU_COORDINATOR_PAIR_A_TYPE:
		self->priv->a_type = g_value_get_gtype (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_A_DUP_FUNC:
		self->priv->a_dup_func = g_value_get_pointer (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_A_DESTROY_FUNC:
		self->priv->a_destroy_func = g_value_get_pointer (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B_TYPE:
		self->priv->b_type = g_value_get_gtype (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B_DUP_FUNC:
		self->priv->b_dup_func = g_value_get_pointer (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B_DESTROY_FUNC:
		self->priv->b_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void netsukuku_coordinator_class_init (NetsukukuCoordinatorClass * klass) {
	netsukuku_coordinator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCoordinatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_coordinator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_coordinator_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coordinator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_GNODE, g_param_spec_object ("gnode", "gnode", "gnode", NETSUKUKU_TYPE_PARTIAL_NIP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_IS_MAIN, g_param_spec_boolean ("is-main", "is-main", "is-main", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_WAS_MAIN, g_param_spec_boolean ("was-main", "was-main", "was-main", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_coordinator_instance_init (NetsukukuCoordinator * self) {
	self->priv = NETSUKUKU_COORDINATOR_GET_PRIVATE (self);
}


static void netsukuku_coordinator_finalize (GObject* obj) {
	NetsukukuCoordinator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator);
	_g_object_unref0 (self->priv->bookings);
	_g_object_unref0 (self->priv->bnode_list);
	_g_object_unref0 (self->priv->_gnode);
	_g_object_unref0 (self->priv->manage_bnode_tunnels_handle);
	G_OBJECT_CLASS (netsukuku_coordinator_parent_class)->finalize (obj);
}


GType netsukuku_coordinator_get_type (void) {
	static volatile gsize netsukuku_coordinator_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coordinator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoordinatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coordinator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoordinator), 0, (GInstanceInitFunc) netsukuku_coordinator_instance_init, NULL };
		GType netsukuku_coordinator_type_id;
		netsukuku_coordinator_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuCoordinator", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_coordinator_type_id__volatile, netsukuku_coordinator_type_id);
	}
	return netsukuku_coordinator_type_id__volatile;
}


static void _vala_netsukuku_coordinator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuCoordinator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator);
	switch (property_id) {
		case NETSUKUKU_COORDINATOR_GNODE:
		g_value_set_object (value, netsukuku_coordinator_get_gnode (self));
		break;
		case NETSUKUKU_COORDINATOR_IS_MAIN:
		g_value_set_boolean (value, netsukuku_coordinator_get_is_main (self));
		break;
		case NETSUKUKU_COORDINATOR_WAS_MAIN:
		g_value_set_boolean (value, netsukuku_coordinator_get_was_main (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_coordinator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuCoordinator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator);
	switch (property_id) {
		case NETSUKUKU_COORDINATOR_GNODE:
		netsukuku_coordinator_set_gnode (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



