/* nic_generic.c generated by valac 0.20.1, the Vala compiler
 * generated from nic_generic.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define NETSUKUKU_TYPE_NIC (netsukuku_nic_get_type ())
#define NETSUKUKU_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNIC))
#define NETSUKUKU_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))
#define NETSUKUKU_IS_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_IS_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))

typedef struct _NetsukukuNIC NetsukukuNIC;
typedef struct _NetsukukuNICClass NetsukukuNICClass;
typedef struct _NetsukukuNICPrivate NetsukukuNICPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_DUMMY_NIC (netsukuku_dummy_nic_get_type ())
#define NETSUKUKU_DUMMY_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_DUMMY_NIC, NetsukukuDummyNIC))
#define NETSUKUKU_DUMMY_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_DUMMY_NIC, NetsukukuDummyNICClass))
#define NETSUKUKU_IS_DUMMY_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_DUMMY_NIC))
#define NETSUKUKU_IS_DUMMY_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_DUMMY_NIC))
#define NETSUKUKU_DUMMY_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_DUMMY_NIC, NetsukukuDummyNICClass))

typedef struct _NetsukukuDummyNIC NetsukukuDummyNIC;
typedef struct _NetsukukuDummyNICClass NetsukukuDummyNICClass;
typedef struct _NetsukukuDummyNICPrivate NetsukukuDummyNICPrivate;

struct _NetsukukuNIC {
	GObject parent_instance;
	NetsukukuNICPrivate * priv;
	gchar* name;
	GeeArrayList* addresses;
};

struct _NetsukukuNICClass {
	GObjectClass parent_class;
	void (*_up) (NetsukukuNIC* self);
	void (*_down) (NetsukukuNIC* self);
	void (*_add_address) (NetsukukuNIC* self, const gchar* address);
	void (*_remove_address) (NetsukukuNIC* self, const gchar* address);
	void (*_disable_filtering) (NetsukukuNIC* self);
	const gchar* (*_mac_getter) (NetsukukuNIC* self);
	gboolean (*_is_active_getter) (NetsukukuNIC* self);
};

typedef NetsukukuNIC* (*NetsukukuCreateNicDelegate) (const gchar* nic_name, void* user_data);
struct _NetsukukuDummyNIC {
	NetsukukuNIC parent_instance;
	NetsukukuDummyNICPrivate * priv;
};

struct _NetsukukuDummyNICClass {
	NetsukukuNICClass parent_class;
};

struct _NetsukukuDummyNICPrivate {
	gchar* _mac;
};


static gpointer netsukuku_nic_parent_class = NULL;
static NetsukukuCreateNicDelegate netsukuku_nic_registered_class_linux;
static gpointer netsukuku_nic_registered_class_linux_target;
static GDestroyNotify netsukuku_nic_registered_class_linux_target_destroy_notify;
static NetsukukuCreateNicDelegate netsukuku_nic_registered_class_linux = NULL;
static gpointer netsukuku_nic_registered_class_linux_target = NULL;
static GDestroyNotify netsukuku_nic_registered_class_linux_target_destroy_notify = NULL;
static gpointer netsukuku_dummy_nic_parent_class = NULL;

GType netsukuku_nic_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_NIC_DUMMY_PROPERTY,
	NETSUKUKU_NIC_MAC,
	NETSUKUKU_NIC_IS_ACTIVE
};
void netsukuku_nic_register_class (const gchar* k, NetsukukuCreateNicDelegate create_new_nic, void* create_new_nic_target);
NetsukukuNIC* netsukuku_nic_create_instance (const gchar* nic_name);
const gchar* netsukuku_settings_get_NETWORK_IMPLEMENTATION (void);
NetsukukuNIC* netsukuku_nic_construct (GType object_type, const gchar* nic_name);
void netsukuku_nic_up (NetsukukuNIC* self);
void _netsukuku_nic_up (NetsukukuNIC* self);
static void netsukuku_nic_real__up (NetsukukuNIC* self);
void netsukuku_nic_down (NetsukukuNIC* self);
void _netsukuku_nic_down (NetsukukuNIC* self);
static void netsukuku_nic_real__down (NetsukukuNIC* self);
void netsukuku_nic_add_address (NetsukukuNIC* self, const gchar* address);
void _netsukuku_nic_add_address (NetsukukuNIC* self, const gchar* address);
static void netsukuku_nic_real__add_address (NetsukukuNIC* self, const gchar* address);
void netsukuku_nic_remove_address (NetsukukuNIC* self, const gchar* address);
void _netsukuku_nic_remove_address (NetsukukuNIC* self, const gchar* address);
static void netsukuku_nic_real__remove_address (NetsukukuNIC* self, const gchar* address);
void netsukuku_nic_disable_filtering (NetsukukuNIC* self);
void _netsukuku_nic_disable_filtering (NetsukukuNIC* self);
static void netsukuku_nic_real__disable_filtering (NetsukukuNIC* self);
const gchar* _netsukuku_nic_mac_getter (NetsukukuNIC* self);
static const gchar* netsukuku_nic_real__mac_getter (NetsukukuNIC* self);
gboolean _netsukuku_nic_is_active_getter (NetsukukuNIC* self);
static gboolean netsukuku_nic_real__is_active_getter (NetsukukuNIC* self);
const gchar* netsukuku_nic_get_mac (NetsukukuNIC* self);
gboolean netsukuku_nic_get_is_active (NetsukukuNIC* self);
static void netsukuku_nic_finalize (GObject* obj);
static void _vala_netsukuku_nic_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType netsukuku_dummy_nic_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_DUMMY_NIC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_DUMMY_NIC, NetsukukuDummyNICPrivate))
enum  {
	NETSUKUKU_DUMMY_NIC_DUMMY_PROPERTY
};
NetsukukuDummyNIC* netsukuku_dummy_nic_new (const gchar* nic_name);
NetsukukuDummyNIC* netsukuku_dummy_nic_construct (GType object_type, const gchar* nic_name);
static const gchar* netsukuku_dummy_nic_real__mac_getter (NetsukukuNIC* base);
static gboolean netsukuku_dummy_nic_real__is_active_getter (NetsukukuNIC* base);
static void netsukuku_dummy_nic_real__up (NetsukukuNIC* base);
static void netsukuku_dummy_nic_real__down (NetsukukuNIC* base);
static void netsukuku_dummy_nic_real__add_address (NetsukukuNIC* base, const gchar* address);
static void netsukuku_dummy_nic_real__remove_address (NetsukukuNIC* base, const gchar* address);
static void netsukuku_dummy_nic_real__disable_filtering (NetsukukuNIC* base);
static void netsukuku_dummy_nic_finalize (GObject* obj);


void netsukuku_nic_register_class (const gchar* k, NetsukukuCreateNicDelegate create_new_nic, void* create_new_nic_target) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (k != NULL);
	_tmp1_ = k;
	if (g_strcmp0 (_tmp1_, "linux") == 0) {
		NetsukukuCreateNicDelegate _tmp2_;
		void* _tmp2__target;
		_tmp2_ = netsukuku_nic_registered_class_linux;
		_tmp2__target = netsukuku_nic_registered_class_linux_target;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		NetsukukuCreateNicDelegate _tmp4_;
		void* _tmp4__target;
		_tmp4_ = create_new_nic;
		_tmp4__target = create_new_nic_target;
		(netsukuku_nic_registered_class_linux_target_destroy_notify == NULL) ? NULL : (netsukuku_nic_registered_class_linux_target_destroy_notify (netsukuku_nic_registered_class_linux_target), NULL);
		netsukuku_nic_registered_class_linux = NULL;
		netsukuku_nic_registered_class_linux_target = NULL;
		netsukuku_nic_registered_class_linux_target_destroy_notify = NULL;
		netsukuku_nic_registered_class_linux = _tmp4_;
		netsukuku_nic_registered_class_linux_target = _tmp4__target;
		netsukuku_nic_registered_class_linux_target_destroy_notify = NULL;
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


NetsukukuNIC* netsukuku_nic_create_instance (const gchar* nic_name) {
	NetsukukuNIC* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* impl;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	_tmp0_ = netsukuku_settings_get_NETWORK_IMPLEMENTATION ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	impl = _tmp2_;
	_tmp4_ = impl;
	if (g_strcmp0 (_tmp4_, "linux") == 0) {
		NetsukukuCreateNicDelegate _tmp5_;
		void* _tmp5__target;
		_tmp5_ = netsukuku_nic_registered_class_linux;
		_tmp5__target = netsukuku_nic_registered_class_linux_target;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		NetsukukuCreateNicDelegate _tmp7_;
		void* _tmp7__target;
		const gchar* _tmp8_;
		NetsukukuNIC* _tmp9_ = NULL;
		_tmp7_ = netsukuku_nic_registered_class_linux;
		_tmp7__target = netsukuku_nic_registered_class_linux_target;
		_tmp8_ = nic_name;
		_tmp9_ = _tmp7_ (_tmp8_, _tmp7__target);
		result = _tmp9_;
		_g_free0 (impl);
		return result;
	}
	_tmp10_ = impl;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("No valid real implementation of class NIC for ", _tmp11_, ". Is your system supported?", NULL);
	_tmp13_ = _tmp12_;
	g_error ("nic_generic.vala:36: %s", _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (impl);
}


NetsukukuNIC* netsukuku_nic_construct (GType object_type, const gchar* nic_name) {
	NetsukukuNIC * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	self = (NetsukukuNIC*) g_object_new (object_type, NULL);
	_tmp0_ = nic_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->addresses);
	self->addresses = _tmp2_;
	return self;
}


/** Brings the interface up.
          */
void netsukuku_nic_up (NetsukukuNIC* self) {
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_netsukuku_nic_up (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->addresses);
	self->addresses = _tmp0_;
}


static void netsukuku_nic_real__up (NetsukukuNIC* self) {
	g_critical ("Type `%s' does not implement abstract method `_netsukuku_nic_up'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void _netsukuku_nic_up (NetsukukuNIC* self) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NIC_GET_CLASS (self)->_up (self);
}


/** Brings the interface down.
          */
void netsukuku_nic_down (NetsukukuNIC* self) {
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_netsukuku_nic_down (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->addresses);
	self->addresses = _tmp0_;
}


static void netsukuku_nic_real__down (NetsukukuNIC* self) {
	g_critical ("Type `%s' does not implement abstract method `_netsukuku_nic_down'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void _netsukuku_nic_down (NetsukukuNIC* self) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NIC_GET_CLASS (self)->_down (self);
}


/** Add NIC address.
          */
void netsukuku_nic_add_address (NetsukukuNIC* self, const gchar* address) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	_tmp0_ = self->addresses;
	_tmp1_ = address;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		const gchar* _tmp3_;
		GeeArrayList* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = address;
		_netsukuku_nic_add_address (self, _tmp3_);
		_tmp4_ = self->addresses;
		_tmp5_ = address;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
	}
}


static void netsukuku_nic_real__add_address (NetsukukuNIC* self, const gchar* address) {
	g_critical ("Type `%s' does not implement abstract method `_netsukuku_nic_add_address'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void _netsukuku_nic_add_address (NetsukukuNIC* self, const gchar* address) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NIC_GET_CLASS (self)->_add_address (self, address);
}


/** Remove NIC address.
          */
void netsukuku_nic_remove_address (NetsukukuNIC* self, const gchar* address) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	_tmp0_ = self->addresses;
	_tmp1_ = address;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		const gchar* _tmp3_;
		GeeArrayList* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = address;
		_netsukuku_nic_remove_address (self, _tmp3_);
		_tmp4_ = self->addresses;
		_tmp5_ = address;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp4_, _tmp5_);
	}
}


static void netsukuku_nic_real__remove_address (NetsukukuNIC* self, const gchar* address) {
	g_critical ("Type `%s' does not implement abstract method `_netsukuku_nic_remove_address'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void _netsukuku_nic_remove_address (NetsukukuNIC* self, const gchar* address) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NIC_GET_CLASS (self)->_remove_address (self, address);
}


/** Disables filtering.
          */
void netsukuku_nic_disable_filtering (NetsukukuNIC* self) {
	g_return_if_fail (self != NULL);
	_netsukuku_nic_disable_filtering (self);
}


static void netsukuku_nic_real__disable_filtering (NetsukukuNIC* self) {
	g_critical ("Type `%s' does not implement abstract method `_netsukuku_nic_disable_filtering'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void _netsukuku_nic_disable_filtering (NetsukukuNIC* self) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NIC_GET_CLASS (self)->_disable_filtering (self);
}


static const gchar* netsukuku_nic_real__mac_getter (NetsukukuNIC* self) {
	g_critical ("Type `%s' does not implement abstract method `_netsukuku_nic_mac_getter'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


const gchar* _netsukuku_nic_mac_getter (NetsukukuNIC* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_NIC_GET_CLASS (self)->_mac_getter (self);
}


static gboolean netsukuku_nic_real__is_active_getter (NetsukukuNIC* self) {
	g_critical ("Type `%s' does not implement abstract method `_netsukuku_nic_is_active_getter'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean _netsukuku_nic_is_active_getter (NetsukukuNIC* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return NETSUKUKU_NIC_GET_CLASS (self)->_is_active_getter (self);
}


const gchar* netsukuku_nic_get_mac (NetsukukuNIC* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _netsukuku_nic_mac_getter (self);
	result = _tmp0_;
	return result;
}


gboolean netsukuku_nic_get_is_active (NetsukukuNIC* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _netsukuku_nic_is_active_getter (self);
	result = _tmp0_;
	return result;
}


static void netsukuku_nic_class_init (NetsukukuNICClass * klass) {
	netsukuku_nic_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_NIC_CLASS (klass)->_up = netsukuku_nic_real__up;
	NETSUKUKU_NIC_CLASS (klass)->_down = netsukuku_nic_real__down;
	NETSUKUKU_NIC_CLASS (klass)->_add_address = netsukuku_nic_real__add_address;
	NETSUKUKU_NIC_CLASS (klass)->_remove_address = netsukuku_nic_real__remove_address;
	NETSUKUKU_NIC_CLASS (klass)->_disable_filtering = netsukuku_nic_real__disable_filtering;
	NETSUKUKU_NIC_CLASS (klass)->_mac_getter = netsukuku_nic_real__mac_getter;
	NETSUKUKU_NIC_CLASS (klass)->_is_active_getter = netsukuku_nic_real__is_active_getter;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_nic_get_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_nic_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NIC_MAC, g_param_spec_string ("mac", "mac", "mac", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NIC_IS_ACTIVE, g_param_spec_boolean ("is-active", "is-active", "is-active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_nic_instance_init (NetsukukuNIC * self) {
}


static void netsukuku_nic_finalize (GObject* obj) {
	NetsukukuNIC * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NIC, NetsukukuNIC);
	_g_free0 (self->name);
	_g_object_unref0 (self->addresses);
	G_OBJECT_CLASS (netsukuku_nic_parent_class)->finalize (obj);
}


GType netsukuku_nic_get_type (void) {
	static volatile gsize netsukuku_nic_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_nic_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNICClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_nic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNIC), 0, (GInstanceInitFunc) netsukuku_nic_instance_init, NULL };
		GType netsukuku_nic_type_id;
		netsukuku_nic_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuNIC", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&netsukuku_nic_type_id__volatile, netsukuku_nic_type_id);
	}
	return netsukuku_nic_type_id__volatile;
}


static void _vala_netsukuku_nic_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuNIC * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NIC, NetsukukuNIC);
	switch (property_id) {
		case NETSUKUKU_NIC_MAC:
		g_value_set_string (value, netsukuku_nic_get_mac (self));
		break;
		case NETSUKUKU_NIC_IS_ACTIVE:
		g_value_set_boolean (value, netsukuku_nic_get_is_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


NetsukukuDummyNIC* netsukuku_dummy_nic_construct (GType object_type, const gchar* nic_name) {
	NetsukukuDummyNIC * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	_tmp0_ = nic_name;
	self = (NetsukukuDummyNIC*) netsukuku_nic_construct (object_type, _tmp0_);
	return self;
}


NetsukukuDummyNIC* netsukuku_dummy_nic_new (const gchar* nic_name) {
	return netsukuku_dummy_nic_construct (NETSUKUKU_TYPE_DUMMY_NIC, nic_name);
}


static const gchar* netsukuku_dummy_nic_real__mac_getter (NetsukukuNIC* base) {
	NetsukukuDummyNIC * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
	self = (NetsukukuDummyNIC*) base;
	_tmp0_ = self->priv->_mac;
	result = _tmp0_;
	return result;
}


static gboolean netsukuku_dummy_nic_real__is_active_getter (NetsukukuNIC* base) {
	NetsukukuDummyNIC * self;
	gboolean result = FALSE;
	self = (NetsukukuDummyNIC*) base;
	result = TRUE;
	return result;
}


static void netsukuku_dummy_nic_real__up (NetsukukuNIC* base) {
	NetsukukuDummyNIC * self;
	self = (NetsukukuDummyNIC*) base;
}


static void netsukuku_dummy_nic_real__down (NetsukukuNIC* base) {
	NetsukukuDummyNIC * self;
	self = (NetsukukuDummyNIC*) base;
}


static void netsukuku_dummy_nic_real__add_address (NetsukukuNIC* base, const gchar* address) {
	NetsukukuDummyNIC * self;
	self = (NetsukukuDummyNIC*) base;
	g_return_if_fail (address != NULL);
}


static void netsukuku_dummy_nic_real__remove_address (NetsukukuNIC* base, const gchar* address) {
	NetsukukuDummyNIC * self;
	self = (NetsukukuDummyNIC*) base;
	g_return_if_fail (address != NULL);
}


static void netsukuku_dummy_nic_real__disable_filtering (NetsukukuNIC* base) {
	NetsukukuDummyNIC * self;
	self = (NetsukukuDummyNIC*) base;
}


static void netsukuku_dummy_nic_class_init (NetsukukuDummyNICClass * klass) {
	netsukuku_dummy_nic_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuDummyNICPrivate));
	NETSUKUKU_NIC_CLASS (klass)->_mac_getter = netsukuku_dummy_nic_real__mac_getter;
	NETSUKUKU_NIC_CLASS (klass)->_is_active_getter = netsukuku_dummy_nic_real__is_active_getter;
	NETSUKUKU_NIC_CLASS (klass)->_up = netsukuku_dummy_nic_real__up;
	NETSUKUKU_NIC_CLASS (klass)->_down = netsukuku_dummy_nic_real__down;
	NETSUKUKU_NIC_CLASS (klass)->_add_address = netsukuku_dummy_nic_real__add_address;
	NETSUKUKU_NIC_CLASS (klass)->_remove_address = netsukuku_dummy_nic_real__remove_address;
	NETSUKUKU_NIC_CLASS (klass)->_disable_filtering = netsukuku_dummy_nic_real__disable_filtering;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_dummy_nic_finalize;
}


static void netsukuku_dummy_nic_instance_init (NetsukukuDummyNIC * self) {
	gchar* _tmp0_;
	self->priv = NETSUKUKU_DUMMY_NIC_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("nil");
	self->priv->_mac = _tmp0_;
}


static void netsukuku_dummy_nic_finalize (GObject* obj) {
	NetsukukuDummyNIC * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_DUMMY_NIC, NetsukukuDummyNIC);
	_g_free0 (self->priv->_mac);
	G_OBJECT_CLASS (netsukuku_dummy_nic_parent_class)->finalize (obj);
}


GType netsukuku_dummy_nic_get_type (void) {
	static volatile gsize netsukuku_dummy_nic_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_dummy_nic_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuDummyNICClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_dummy_nic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuDummyNIC), 0, (GInstanceInitFunc) netsukuku_dummy_nic_instance_init, NULL };
		GType netsukuku_dummy_nic_type_id;
		netsukuku_dummy_nic_type_id = g_type_register_static (NETSUKUKU_TYPE_NIC, "NetsukukuDummyNIC", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_dummy_nic_type_id__volatile, netsukuku_dummy_nic_type_id);
	}
	return netsukuku_dummy_nic_type_id__volatile;
}



