/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using Tasklets;

namespace Netsukuku
{
#if log_tasklet
    private string tasklet_id()
    {
        return @"[$(Tasklet.self().id)] ";
    }
#else
    private string tasklet_id()
    {
        return "";
    }
#endif
    internal void log_debug(string msg) {Posix.syslog(Posix.LOG_DEBUG, tasklet_id()+msg);}
    internal void log_info(string msg) {Posix.syslog(Posix.LOG_INFO, tasklet_id()+msg);}
    internal void log_notice(string msg) {Posix.syslog(Posix.LOG_NOTICE, tasklet_id()+msg);}
    internal void log_warn(string msg) {Posix.syslog(Posix.LOG_WARNING, tasklet_id()+msg);}
    internal void log_error(string msg) {Posix.syslog(Posix.LOG_ERR, tasklet_id()+msg);}
    internal void log_critical(string msg) {Posix.syslog(Posix.LOG_CRIT, tasklet_id()+msg);}

    public ArrayList<int> valid_ids(int levels, int gsize, int lvl, PartialNIP partial_nip)
    {
        ArrayList<int> ret = new ArrayList<int>();
        for (int i = 0; i < gsize; i++) ret.add(i);
        return ret;
    }

    public string nip_to_str(int levels, int gsize, NIP nip) {return "";}
}

namespace Ntk.Test
{
    public class DerivedDataClass : DataClass
    {
        private Netsukuku.Map m;
        private int lvl;
        private int pos;
        private bool its_me;
        public bool busy;

        public DerivedDataClass()
        {
        }

        public override void initialize(Object m, int lvl, int pos, bool its_me = false)
        {
            this.m = (Netsukuku.Map)m;
            this.lvl = lvl;
            this.pos = pos;
            this.its_me = its_me;
        }

        public override bool is_free()
        {
            if (its_me) return false;
            return !busy;
        }
    }

    public class DerivedMap : Netsukuku.Map<DerivedDataClass>
    {
        public DerivedMap(int levels, int gsize, NIP me)
        {
            base(levels, gsize, me);
        }

        public void deriv_node_add(int lvl, int pos)
        {
            DerivedDataClass node = node_get(lvl, pos);
            if (node.is_free())
            {
                node.busy = true;
                node_add(lvl, pos);
            }
        }

        public void deriv_node_del(int lvl, int pos)
        {
            node_del(lvl, pos);
        }

    }

    public class MapTester : Object
    {
        public void set_up ()
        {
        }

        public void tear_down ()
        {
        }

        public void test_fundamentals()
        {
            if (false /*skip test?*/) Posix.exit(77);
            // Map
            DerivedMap m = new DerivedMap(8, 8, new NIP({2, 3, 4, 5, 2, 3, 4, 5}));
            // handle signals
            string test = "";
            m.node_new.connect((_m, lvl, pos) => { test += "C%d,%d".printf(lvl, pos); });
            m.node_deleted.connect((_m, lvl, pos) => { test += "D%d,%d".printf(lvl, pos); });
            assert(m.me.position_at(2) == 4);
            assert(m.levels == 8);
            assert(m.gsize == 8);
            for (int lvl = 0; lvl < 8; lvl++)
            {
                int n = m.free_nodes_nb(lvl);
                assert(n == 7);
            }
            int[] free = m.free_nodes_list(1);
            assert(0 in free);
            assert(1 in free);
            assert(2 in free);
            assert(!(3 in free));
            assert(4 in free);
            assert(5 in free);
            assert(6 in free);
            assert(7 in free);
            assert(test == "");
            // add a node
            m.deriv_node_add(0, 7);
            // test signal
            assert(test == "C0,7");
            test = "";
            for (int lvl2 = 1; lvl2 < 8; lvl2++)
            {
                int n2 = m.busy_nodes_nb(lvl2);
                assert(n2 == 1);
            }
            int[] busy = m.busy_nodes_list(0);
            assert(!(0 in busy));
            assert(!(1 in busy));
            assert(2 in busy);
            assert(!(3 in busy));
            assert(!(4 in busy));
            assert(!(5 in busy));
            assert(!(6 in busy));
            assert(7 in busy);
            assert(test == "");
            // del a node
            m.deriv_node_del(0, 7);
            // test signal
            assert(test == "D0,7");
            test = "";
            // NIP
            NIP n = new NIP({2,2,2,1,1,1,1,5});
            NIP n2 = new NIP({2,2,2,1,1,1,1,5});
            NIP n3 = new NIP({3,2,2,1,1,1,1,5});
            assert(n != n2); // not the same instance
            assert(n.is_equal(n2)); // BUT the same values
            assert(!n.is_equal(n3));
            // HCoord
            HCoord hc_n = m.nip_to_lvlid(n);
            HCoord hc = new HCoord(6, 1);
            assert(hc.lvl == 6);
            assert(hc.pos == 1);
            assert(hc != hc_n);
            assert(hc.is_equal(hc_n));
            // back to nip
            NIP n4 = m.lvlid_to_nip(hc_n).lowest_nip();
            assert(n4.is_equal(new NIP({0,0,0,0,0,0,1,5})));
            m.stop_operations();
            TaskletDispatcher.abort_all();
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            Tasklet.init();
            GLib.Test.add_func ("/Map/Fundamentals", () => {
                var x = new MapTester();
                x.set_up();
                x.test_fundamentals();
                x.tear_down();
            });
            GLib.Test.run();
            Tasklet.kill();
            return 0;
        }
    }
}
