/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using Tasklets;
using zcd;
using Ntk.Test;

namespace Netsukuku
{
#if log_tasklet
    private string tasklet_id()
    {
        return @"[$(Tasklet.self().id)] ";
    }
#else
    private string tasklet_id()
    {
        return "";
    }
#endif
    internal void log_debug(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_info(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_notice(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_warn(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_error(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_critical(string msg) {print_out(tasklet_id()+msg+"\n");}
}

errordomain TestError {
    GENERIC
}

namespace Ntk.Test
{
    string logger;
    const bool output = false;
    public void print_out(string s)
    {
        if (output) print(s);
    }

    delegate void ClosureCallback() throws TestError;

    public class TaskletTester : Object
    {
        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        void check_then_call(
                        ClosureCallback accept_callback) throws TestError
        {
            accept_callback();
        }

        void test_error_in_tasklet()
        {
            // This function can throw a TestError it in a tasklet.
            Tasklet.tasklet_callback(
                    () => {
                        throw new TestError.GENERIC("test");
                    });
            // Give time to the tasklet to throw it.
            Tasklet.nap(0, 10000);
        }

        void test_error(bool immediately) throws TestError
        {
            // This function can throw a TestError.
            // It might be called to throw it immediately.
            if (immediately) throw new TestError.GENERIC("test");
            // Otherwise it throws it from a closure.
            check_then_call(
                    () => {
                        throw new TestError.GENERIC("test");
                    });
        }

        public void test_tasklet_callback ()
        {
            int i = 0;
            // Spawn a new tasklet in a closure.
            Tasklet.tasklet_callback(
                    () => {
                        i = 2;
                    });
            // Give time to the tasklet to complete.
            Tasklet.nap(0, 10000);
            // Verify the tasklet has completed and the closure gave no problem.
            assert(i == 2);
            // Catch an error from a call to a function
            try {
                test_error(true);
                assert(false);
            } catch (TestError e) {
                i = 3;
            }
            assert(i == 3);
            // Catch an error from a closure (called inside a function)
            try {
                test_error(false);
                assert(false);
            } catch (TestError e) {
                i = 4;
            }
            assert(i == 4);
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            Tasklet.init();
            GLib.Test.add_func ("/Tasklet/Callback", () => {
                var x = new TaskletTester();
                x.set_up();
                x.test_tasklet_callback();
                x.tear_down();
            });
            GLib.Test.run();
            Tasklet.kill();
            return 0;
        }
    }
}
