/**  Stub classes generated by rpcdesign.
  */

using Gee;
using zcd;

namespace Netsukuku
{
    public ISerializable filter_exception_HookingError(ISerializable ret) throws HookingError
    {
        if (ret.get_type().is_a(typeof(RemotableException)))
        {
            RemotableException e = (RemotableException)ret;
            if (e.domain == "HookingError")
            {
                if (e.code == "INEXISTENT_GNODE") throw new HookingError.INEXISTENT_GNODE(e.message);
                if (e.code == "GENERIC") throw new HookingError.GENERIC(e.message);
            }
        }
        return ret;
    }

    public ISerializable filter_exception_QspnError(ISerializable ret) throws QspnError
    {
        if (ret.get_type().is_a(typeof(RemotableException)))
        {
            RemotableException e = (RemotableException)ret;
            if (e.domain == "QspnError")
            {
                if (e.code == "NOT_YOUR_GATEWAY") throw new QspnError.NOT_YOUR_GATEWAY(e.message);
                if (e.code == "ALREADY_UP_TO_DATE") throw new QspnError.ALREADY_UP_TO_DATE(e.message);
                if (e.code == "GENERIC") throw new QspnError.GENERIC(e.message);
            }
        }
        return ret;
    }

    public ISerializable filter_exception_PeerRefuseServiceError(ISerializable ret) throws PeerRefuseServiceError
    {
        if (ret.get_type().is_a(typeof(RemotableException)))
        {
            RemotableException e = (RemotableException)ret;
            if (e.domain == "PeerRefuseServiceError")
            {
                if (e.code == "GENERIC") throw new PeerRefuseServiceError.GENERIC(e.message);
            }
        }
        return ret;
    }

    public ISerializable filter_exception_TunnelError(ISerializable ret) throws TunnelError
    {
        if (ret.get_type().is_a(typeof(RemotableException)))
        {
            RemotableException e = (RemotableException)ret;
            if (e.domain == "TunnelError")
            {
                if (e.code == "GENERIC") throw new TunnelError.GENERIC(e.message);
            }
        }
        return ret;
    }

    public ISerializable filter_exception_BorderNodesError(ISerializable ret) throws BorderNodesError
    {
        if (ret.get_type().is_a(typeof(RemotableException)))
        {
            RemotableException e = (RemotableException)ret;
            if (e.domain == "BorderNodesError")
            {
                if (e.code == "WRONG_GNODE") throw new BorderNodesError.WRONG_GNODE(e.message);
                if (e.code == "NOT_BORDER_NODE") throw new BorderNodesError.NOT_BORDER_NODE(e.message);
                if (e.code == "WILL_NOT_TUNNEL") throw new BorderNodesError.WILL_NOT_TUNNEL(e.message);
                if (e.code == "TIMEOUT") throw new BorderNodesError.TIMEOUT(e.message);
                if (e.code == "GENERIC") throw new BorderNodesError.GENERIC(e.message);
            }
        }
        return ret;
    }

    public ISerializable filter_exception_AndnaError(ISerializable ret) throws AndnaError
    {
        if (ret.get_type().is_a(typeof(RemotableException)))
        {
            RemotableException e = (RemotableException)ret;
            if (e.domain == "AndnaError")
            {
                if (e.code == "GENERIC") throw new AndnaError.GENERIC(e.message);
            }
        }
        return ret;
    }

    /** The following classes are used to perform
      *  RPC call using the following form:
      *
      *    var x = remote_instance.property1.property2.method0(p1, p2, p3);
      *
      *  instead of:
      *
      *    RemoteCall rc = new RemoteCall();
      *    rc.method_name = "property1.property2.method0";
      *    rc.add_parameter(p1);
      *    rc.add_parameter(p2);
      *    rc.add_parameter(p3);
      *    var x = (SerClass)remote_instance.rmt(rc);
      *
      * The actual implementation of method rmt is a duty of a derived class.
      */

    public abstract class AddressManagerFakeRmt : Object, IAddressManagerRootDispatcher, FakeRmt
    {
        private RemoteEtp _etp = null;
        public unowned IEtp _etp_getter()
        {
            if (_etp == null)
            {
                _etp = new RemoteEtp();
                _etp.root = this;
                _etp.accumulated = "etp";
            }
            return _etp;
        }

        private RemoteTunnelManager _tunnel_manager = null;
        public unowned ITunnelManager _tunnel_manager_getter()
        {
            if (_tunnel_manager == null)
            {
                _tunnel_manager = new RemoteTunnelManager();
                _tunnel_manager.root = this;
                _tunnel_manager.accumulated = "tunnel_manager";
            }
            return _tunnel_manager;
        }

        private RemoteHook _hook = null;
        public unowned IHook _hook_getter()
        {
            if (_hook == null)
            {
                _hook = new RemoteHook();
                _hook.root = this;
                _hook.accumulated = "hook";
            }
            return _hook;
        }

        private RemoteAggregatedNeighbourManager _aggregated_neighbour_manager = null;
        public unowned IAggregatedNeighbourManager _aggregated_neighbour_manager_getter()
        {
            if (_aggregated_neighbour_manager == null)
            {
                _aggregated_neighbour_manager = new RemoteAggregatedNeighbourManager();
                _aggregated_neighbour_manager.root = this;
                _aggregated_neighbour_manager.accumulated = "aggregated_neighbour_manager";
            }
            return _aggregated_neighbour_manager;
        }

        private RemoteMapRoute _maproute = null;
        public unowned IMapRoute _maproute_getter()
        {
            if (_maproute == null)
            {
                _maproute = new RemoteMapRoute();
                _maproute.root = this;
                _maproute.accumulated = "maproute";
            }
            return _maproute;
        }

        private RemoteBorderNodesManager _border_nodes_manager = null;
        public unowned IBorderNodesManager _border_nodes_manager_getter()
        {
            if (_border_nodes_manager == null)
            {
                _border_nodes_manager = new RemoteBorderNodesManager();
                _border_nodes_manager.root = this;
                _border_nodes_manager.accumulated = "border_nodes_manager";
            }
            return _border_nodes_manager;
        }

        private RemotePeerToPeerAll _peer_to_peer_all = null;
        public unowned IPeerToPeerAll _peer_to_peer_all_getter()
        {
            if (_peer_to_peer_all == null)
            {
                _peer_to_peer_all = new RemotePeerToPeerAll();
                _peer_to_peer_all.root = this;
                _peer_to_peer_all.accumulated = "peer_to_peer_all";
            }
            return _peer_to_peer_all;
        }

        private RemoteCoordinator _coordinator = null;
        public unowned ICoordinator _coordinator_getter()
        {
            if (_coordinator == null)
            {
                _coordinator = new RemoteCoordinator();
                _coordinator.root = this;
                _coordinator.accumulated = "coordinator";
            }
            return _coordinator;
        }

        private RemoteAndna _andna = null;
        public unowned IAndna _andna_getter()
        {
            if (_andna == null)
            {
                _andna = new RemoteAndna();
                _andna.root = this;
                _andna.accumulated = "andna";
            }
            return _andna;
        }

        public IPeerToPeer get_peer_to_peer_service(int pid)
        {
            RemotePeerToPeer ret = new RemotePeerToPeer();
            ret.root = this;
            ret.accumulated = @"get_peer_to_peer_service($(pid))";
            return ret;
        }

        public IOptionalPeerToPeer get_optional_peer_to_peer_service(int pid)
        {
            RemoteOptionalPeerToPeer ret = new RemoteOptionalPeerToPeer();
            ret.root = this;
            ret.accumulated = @"get_optional_peer_to_peer_service($(pid))";
            return ret;
        }

        public Gee.List<TaskletStats> report_tasklets_stats(int minutes) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "report_tasklets_stats";
            rc.add_parameter(new SerializableInt(minutes));
            ListISerializable ret = (ListISerializable)
                filter_exception(
                this.rmt(rc)
            );
            return (Gee.List<TaskletStats>)ret.backed;
        }

        public Gee.List<string> report_tasklet_logs(int id) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "report_tasklet_logs";
            rc.add_parameter(new SerializableInt(id));
            ListString ret = (ListString)
                filter_exception(
                this.rmt(rc)
            );
            return (Gee.List<string>)ret.backed;
        }

        public Gee.List<string> report_running_tasklets() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "report_running_tasklets";
            ListString ret = (ListString)
                filter_exception(
                this.rmt(rc)
            );
            return (Gee.List<string>)ret.backed;
        }

        public abstract ISerializable rmt(RemoteCall data) throws RPCError;
    }

    public class RemoteEtp : Object, IEtp
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public ExtendedTracerPacket request_etp(int prev_mod_seq_num, NIP nip_caller, int nodeid_caller, NetworkID netid_caller, Gee.List<string> macs_caller) throws RPCError, QspnError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".request_etp";
            rc.add_parameter(new SerializableInt(prev_mod_seq_num));
            rc.add_parameter(nip_caller);
            rc.add_parameter(new SerializableInt(nodeid_caller));
            rc.add_parameter(netid_caller);
            ListString _macs_caller = new ListString.with_backer(macs_caller);
            rc.add_parameter(_macs_caller);
            return (ExtendedTracerPacket)
                filter_exception(
                filter_exception_QspnError(
                root.rmt(rc))
            );
        }

        public int request_size() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".request_size";
            return ((SerializableInt)
                filter_exception(
                root.rmt(rc)
            )).i;
        }

        public void new_sequence_number(NIP nip_x, int nodeid_x, int seq_num_x) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".new_sequence_number";
            rc.add_parameter(nip_x);
            rc.add_parameter(new SerializableInt(nodeid_x));
            rc.add_parameter(new SerializableInt(seq_num_x));
            filter_exception(
                root.rmt(rc)
            );
        }

        public void act_as_gateway(NIP nip_caller, int nodeid_caller, NetworkID netid_caller, Gee.List<string> macs) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".act_as_gateway";
            rc.add_parameter(nip_caller);
            rc.add_parameter(new SerializableInt(nodeid_caller));
            rc.add_parameter(netid_caller);
            ListString _macs = new ListString.with_backer(macs);
            rc.add_parameter(_macs);
            filter_exception(
                root.rmt(rc)
            );
        }

        public QspnStats report_qspn_stats() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".report_qspn_stats";
            return (QspnStats)
                filter_exception(
                root.rmt(rc)
            );
        }

    }

    public class RemoteTunnelManager : Object, ITunnelManager
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public string? choose_tunnel_protocol(Gee.List<string> protocols) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".choose_tunnel_protocol";
            ListString _protocols = new ListString.with_backer(protocols);
            rc.add_parameter(_protocols);
            ISerializable ret =
                filter_exception(
                root.rmt(rc)
            );
            if (ret.get_type().is_a(typeof(SerializableNone))) return null;
            else return ((SerializableString)ret).s;
        }

        public void handshake(ISerializable mesg, int handler_id) throws RPCError, TunnelError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".handshake";
            rc.add_parameter(mesg);
            rc.add_parameter(new SerializableInt(handler_id));
            filter_exception(
                filter_exception_TunnelError(
                root.rmt(rc))
            );
        }

        public int request_tunnel(string protocol, int peer_handler_id, CallerInfo? _rpc_caller=null) throws RPCError, TunnelError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".request_tunnel";
            rc.add_parameter(new SerializableString(protocol));
            rc.add_parameter(new SerializableInt(peer_handler_id));
            return ((SerializableInt)
                filter_exception(
                filter_exception_TunnelError(
                root.rmt(rc))
            )).i;
        }

        public void close_tunnel(string nic_name, CallerInfo? _rpc_caller=null) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".close_tunnel";
            rc.add_parameter(new SerializableString(nic_name));
            filter_exception(
                root.rmt(rc)
            );
        }

    }

    public class RemoteAggregatedNeighbourManager : Object, IAggregatedNeighbourManager
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public void reply(int radar_id, NIP nip, int nodeid, NetworkID netid, CallerInfo? _rpc_caller=null) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".reply";
            rc.add_parameter(new SerializableInt(radar_id));
            rc.add_parameter(nip);
            rc.add_parameter(new SerializableInt(nodeid));
            rc.add_parameter(netid);
            filter_exception(
                root.rmt(rc)
            );
        }

        public void time_register(int radar_id, int levels, int gsize, NIP nip, int nodeid, NetworkID netid, string mac, bool is_primary, bool is_auxiliary) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".time_register";
            rc.add_parameter(new SerializableInt(radar_id));
            rc.add_parameter(new SerializableInt(levels));
            rc.add_parameter(new SerializableInt(gsize));
            rc.add_parameter(nip);
            rc.add_parameter(new SerializableInt(nodeid));
            rc.add_parameter(netid);
            rc.add_parameter(new SerializableString(mac));
            rc.add_parameter(new SerializableBool(is_primary));
            rc.add_parameter(new SerializableBool(is_auxiliary));
            filter_exception(
                root.rmt(rc)
            );
        }

        public void declare_dead(NIP nip, int nodeid) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".declare_dead";
            rc.add_parameter(nip);
            rc.add_parameter(new SerializableInt(nodeid));
            filter_exception(
                root.rmt(rc)
            );
        }

        public Gee.List<InfoNeighbour> report_neighbours() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".report_neighbours";
            ListISerializable ret = (ListISerializable)
                filter_exception(
                root.rmt(rc)
            );
            return (Gee.List<InfoNeighbour>)ret.backed;
        }

    }

    public class RemoteBorderNodesManager : Object, IBorderNodesManager
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public Gee.List<PairNipDistance> get_distances(PartialNIP gnode, Gee.List<NIP> list_of_nips, CallerInfo? _rpc_caller=null) throws RPCError, BorderNodesError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".get_distances";
            rc.add_parameter(gnode);
            ListISerializable _list_of_nips = new ListISerializable.with_backer(list_of_nips);
            rc.add_parameter(_list_of_nips);
            ListISerializable ret = (ListISerializable)
                filter_exception(
                filter_exception_BorderNodesError(
                root.rmt(rc))
            );
            return (Gee.List<PairNipDistance>)ret.backed;
        }

        public NIP get_new_address(PartialNIP gnode, NIP? peer_nip, CallerInfo? _rpc_caller=null) throws RPCError, BorderNodesError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".get_new_address";
            rc.add_parameter(gnode);
            if (peer_nip == null) rc.add_parameter(new SerializableNone());
            else rc.add_parameter(peer_nip);
            return (NIP)
                filter_exception(
                filter_exception_BorderNodesError(
                root.rmt(rc))
            );
        }

        public void assign_peer_nip(NIP nip_x_secondary, NIP nip_y_secondary) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".assign_peer_nip";
            rc.add_parameter(nip_x_secondary);
            rc.add_parameter(nip_y_secondary);
            filter_exception(
                root.rmt(rc)
            );
        }

        public Gee.List<InfoBorderNode> report_bordernodes_status() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".report_bordernodes_status";
            ListISerializable ret = (ListISerializable)
                filter_exception(
                root.rmt(rc)
            );
            return (Gee.List<InfoBorderNode>)ret.backed;
        }

    }

    public class RemoteCoordinator : Object, ICoordinator
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public CoordinatorReservation reserve_into(PartialNIP gnode) throws RPCError, HookingError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".reserve_into";
            rc.add_parameter(gnode);
            return (CoordinatorReservation)
                filter_exception(
                filter_exception_HookingError(
                root.rmt(rc))
            );
        }

        public CoordinatorInfo report_status(int lvl) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".report_status";
            rc.add_parameter(new SerializableInt(lvl));
            return (CoordinatorInfo)
                filter_exception(
                root.rmt(rc)
            );
        }

    }

    public class RemotePeerToPeer : Object, IPeerToPeer
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public ISerializable msg_deliver(PeerToPeerTracerPacketList peer_to_peer_tpl, NIP sender_nip, NIP hip, RemoteCall rcdata) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".msg_deliver";
            rc.add_parameter(peer_to_peer_tpl);
            rc.add_parameter(sender_nip);
            rc.add_parameter(hip);
            rc.add_parameter(rcdata);
            return
                filter_exception(
                root.rmt(rc)
            );
        }

        public ISerializable msg_send(NIP sender_nip, NIP hip, RemoteCall rcdata) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".msg_send";
            rc.add_parameter(sender_nip);
            rc.add_parameter(hip);
            rc.add_parameter(rcdata);
            return
                filter_exception(
                root.rmt(rc)
            );
        }

        public Gee.List<NIP> find_nearest(PeerToPeerTracerPacketList peer_to_peer_tpl, NIP hash_nip, int num_dupl, int lvl, int pos) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".find_nearest";
            rc.add_parameter(peer_to_peer_tpl);
            rc.add_parameter(hash_nip);
            rc.add_parameter(new SerializableInt(num_dupl));
            rc.add_parameter(new SerializableInt(lvl));
            rc.add_parameter(new SerializableInt(pos));
            ListISerializable ret = (ListISerializable)
                filter_exception(
                root.rmt(rc)
            );
            return (Gee.List<NIP>)ret.backed;
        }

        public int number_of_participants(PeerToPeerTracerPacketList peer_to_peer_tpl, int lvl, int pos) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".number_of_participants";
            rc.add_parameter(peer_to_peer_tpl);
            rc.add_parameter(new SerializableInt(lvl));
            rc.add_parameter(new SerializableInt(pos));
            return ((SerializableInt)
                filter_exception(
                root.rmt(rc)
            )).i;
        }

    }

    public class RemoteOptionalPeerToPeer : Object, IOptionalPeerToPeer
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public void participant_set(NIP nip, int lvl, int pos, ParticipantNode participant_node) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".participant_set";
            rc.add_parameter(nip);
            rc.add_parameter(new SerializableInt(lvl));
            rc.add_parameter(new SerializableInt(pos));
            rc.add_parameter(participant_node);
            filter_exception(
                root.rmt(rc)
            );
        }

        public void participant_refresh(NIP nip, PackedParticipantNodes packed_nodes) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".participant_refresh";
            rc.add_parameter(nip);
            rc.add_parameter(packed_nodes);
            filter_exception(
                root.rmt(rc)
            );
        }

    }

    public class RemotePeerToPeerAll : Object, IPeerToPeerAll
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public SetOptionalServiceParticipants get_optional_participants() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".get_optional_participants";
            return (SetOptionalServiceParticipants)
                filter_exception(
                root.rmt(rc)
            );
        }

    }

    public class RemoteMapRoute : Object, IMapRoute
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public int free_nodes_nb(int lvl) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".free_nodes_nb";
            rc.add_parameter(new SerializableInt(lvl));
            return ((SerializableInt)
                filter_exception(
                root.rmt(rc)
            )).i;
        }

        public REM worst_internal_bestrem(int level_of_gnode) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".worst_internal_bestrem";
            rc.add_parameter(new SerializableInt(level_of_gnode));
            return (REM)
                filter_exception(
                root.rmt(rc)
            );
        }

        public void request_gid(int request_id, NetworkID gnetid, PartialNIP gprefix) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".request_gid";
            rc.add_parameter(new SerializableInt(request_id));
            rc.add_parameter(gnetid);
            rc.add_parameter(gprefix);
            filter_exception(
                root.rmt(rc)
            );
        }

        public void answer_gid(NIP answering_nip, int request_id, GNodeID actual_gid) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".answer_gid";
            rc.add_parameter(answering_nip);
            rc.add_parameter(new SerializableInt(request_id));
            rc.add_parameter(actual_gid);
            filter_exception(
                root.rmt(rc)
            );
        }

        public Gee.List<InfoRoute> report_routes() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".report_routes";
            ListISerializable ret = (ListISerializable)
                filter_exception(
                root.rmt(rc)
            );
            return (Gee.List<InfoRoute>)ret.backed;
        }

        public Gee.List<GNodeID> report_gid_list() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".report_gid_list";
            ListISerializable ret = (ListISerializable)
                filter_exception(
                root.rmt(rc)
            );
            return (Gee.List<GNodeID>)ret.backed;
        }

        public InfoNode report_yourself() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".report_yourself";
            return (InfoNode)
                filter_exception(
                root.rmt(rc)
            );
        }

    }

    public class RemoteHook : Object, IHook
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public Gee.List<PairLvlNumberOfFreeNodes> list_non_saturated_levels() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".list_non_saturated_levels";
            ListISerializable ret = (ListISerializable)
                filter_exception(
                root.rmt(rc)
            );
            return (Gee.List<PairLvlNumberOfFreeNodes>)ret.backed;
        }

    }

    public class RemoteAndna : Object, IAndna
    {
        public weak FakeRmt root;
        public string accumulated = "";

        public AndnaConfirmPubkResponse confirm_pubk(NIP yournip, PublicKey yourpubkey, int to_be_signed) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".confirm_pubk";
            rc.add_parameter(yournip);
            rc.add_parameter(yourpubkey);
            rc.add_parameter(new SerializableInt(to_be_signed));
            return (AndnaConfirmPubkResponse)
                filter_exception(
                root.rmt(rc)
            );
        }

        public Gee.List<string> get_your_hostnames(NIP yournip) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".get_your_hostnames";
            rc.add_parameter(yournip);
            ListString ret = (ListString)
                filter_exception(
                root.rmt(rc)
            );
            return (Gee.List<string>)ret.backed;
        }

        public InfoAndna report_status() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".report_status";
            return (InfoAndna)
                filter_exception(
                root.rmt(rc)
            );
        }

        public AndnaPrivateConfigurationList get_mynames() throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".get_mynames";
            return (AndnaPrivateConfigurationList)
                filter_exception(
                root.rmt(rc)
            );
        }

        public void set_mynames(AndnaPrivateConfigurationList mynames) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".set_mynames";
            rc.add_parameter(mynames);
            filter_exception(
                root.rmt(rc)
            );
        }

        public PublicKey? retrieve_registrar_pubk(string hashed_domain) throws RPCError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = accumulated + ".retrieve_registrar_pubk";
            rc.add_parameter(new SerializableString(hashed_domain));
            ISerializable ret =
                filter_exception(
                root.rmt(rc)
            );
            if (ret.get_type().is_a(typeof(SerializableNone))) return null;
            else return (PublicKey)ret;
        }

    }

    /** An implementation of AddressManagerFakeRmt that sends a message via TCP.
      */
    public class AddressManagerTCPClient : AddressManagerFakeRmt
    {
        private TCPClient inner;
        public AddressManagerTCPClient(string dest_addr, uint16? dest_port=null, string? my_addr=null, bool wait_response=true)
        {
            inner = new TCPClient(dest_addr, dest_port, my_addr, wait_response);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }

        public uint16 dest_port {
            get {
                return inner.dest_port;
            }
        }

        public string dest_addr {
            get {
                return inner.dest_addr;
            }
        }

        public bool calling {
            get {
                return inner.calling;
            }
        }

        public bool retry_connect {
            get {
                return inner.retry_connect;
            }
            set {
                inner.retry_connect = value;
            }
        }

        public void close() throws RPCError
        {
            inner.close();
        }
    }

    /** An implementation of AddressManagerFakeRmt that sends a message 
      *  to its neighbours in broadcast via UDP.
      */
    public class AddressManagerBroadcastClient : AddressManagerFakeRmt
    {
        private BroadcastClient inner;
        public AddressManagerBroadcastClient(ISerializable broadcast_id,
                                             string[] devs,
                                             PrepareForAcknowledgements? prep=null,
                                             uint16 port=269)
        {
            inner = new BroadcastClient(broadcast_id, devs, prep, port);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }

        public uint16 port {
            get {
                return inner.dest_port;
            }
        }
    }

    /** An implementation of AddressManagerFakeRmt that sends requests to
      *  a set of local dispatchers. Simulates a BroadcastClient.
      */
    public class AddressManagerPseudoBroadcastClient : AddressManagerFakeRmt
    {
        private PseudoBroadcastClient inner;
        public AddressManagerPseudoBroadcastClient(Gee.List<RPCDispatcher> rpcdispatchers)
        {
            inner = new PseudoBroadcastClient(rpcdispatchers);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }
    }

    /** An implementation of AddressManagerFakeRmt that sends a message
      *  to a neighbour via UDP.
      */
    public class AddressManagerNeighbourClient : AddressManagerFakeRmt
    {
        private NeighbourClient inner;
        public AddressManagerNeighbourClient(ISerializable unicast_id, string[] devs, uint16? port=null,  bool wait_response=true)
        {
            inner = new NeighbourClient(unicast_id, devs, port, wait_response);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }

        public uint16 port {
            get {
                return inner.dest_port;
            }
        }
    }

    /** An implementation of AddressManagerFakeRmt that sends requests to a
      *  local dispatcher. Simulates a NeighbourClient.
      */
    public class AddressManagerPseudoNeighbourClient : AddressManagerFakeRmt
    {
        private PseudoNeighbourClient inner;
        public AddressManagerPseudoNeighbourClient(RPCDispatcher rpcdispatcher, bool wait_response=true)
        {
            inner = new PseudoNeighbourClient(rpcdispatcher, wait_response);
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            return inner.rmt(data);
        }
    }

    /** An implementation of AddressManagerFakeRmt that sends a message (usually without waiting for
      *  a result) to two remote objects.
      */
    public class CoupleAddressManagerFakeRmt : AddressManagerFakeRmt
    {
        private AddressManagerFakeRmt f1;
        private AddressManagerFakeRmt f2;
        public CoupleAddressManagerFakeRmt(AddressManagerFakeRmt f1, AddressManagerFakeRmt f2)
        {
            this.f1 = f1;
            this.f2 = f2;
        }

        public override ISerializable rmt(RemoteCall data) throws RPCError
        {
            try {f1.rmt(data);} catch (RPCError e) {}
            try {f2.rmt(data);} catch (RPCError e) {}
            return new SerializableNone();
        }
    }
}
