/* main-taskletlogs.c generated by valac 0.20.1, the Vala compiler
 * generated from main-taskletlogs.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <zcd-tcpclient.h>
#include <netsukuku-rpc-tcpclient.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MONITOR_TYPE_QUICK_ADDRESS_MANAGER (monitor_quick_address_manager_get_type ())
#define MONITOR_QUICK_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManager))
#define MONITOR_QUICK_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManagerClass))
#define MONITOR_IS_QUICK_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONITOR_TYPE_QUICK_ADDRESS_MANAGER))
#define MONITOR_IS_QUICK_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MONITOR_TYPE_QUICK_ADDRESS_MANAGER))
#define MONITOR_QUICK_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManagerClass))

typedef struct _MonitorQuickAddressManager MonitorQuickAddressManager;
typedef struct _MonitorQuickAddressManagerClass MonitorQuickAddressManagerClass;
typedef struct _MonitorQuickAddressManagerPrivate MonitorQuickAddressManagerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER (monitor_address_manager_fake_rmt_getter_get_type ())
#define MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetter))
#define MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetterClass))
#define MONITOR_IS_ADDRESS_MANAGER_FAKE_RMT_GETTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER))
#define MONITOR_IS_ADDRESS_MANAGER_FAKE_RMT_GETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER))
#define MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetterClass))

typedef struct _MonitorAddressManagerFakeRmtGetter MonitorAddressManagerFakeRmtGetter;
typedef struct _MonitorAddressManagerFakeRmtGetterClass MonitorAddressManagerFakeRmtGetterClass;
typedef struct _MonitorAddressManagerFakeRmtGetterPrivate MonitorAddressManagerFakeRmtGetterPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define MONITOR_TYPE_TASKLET_LOGGER (monitor_tasklet_logger_get_type ())
#define MONITOR_TASKLET_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONITOR_TYPE_TASKLET_LOGGER, MonitorTaskletLogger))
#define MONITOR_TASKLET_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MONITOR_TYPE_TASKLET_LOGGER, MonitorTaskletLoggerClass))
#define MONITOR_IS_TASKLET_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONITOR_TYPE_TASKLET_LOGGER))
#define MONITOR_IS_TASKLET_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MONITOR_TYPE_TASKLET_LOGGER))
#define MONITOR_TASKLET_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MONITOR_TYPE_TASKLET_LOGGER, MonitorTaskletLoggerClass))

typedef struct _MonitorTaskletLogger MonitorTaskletLogger;
typedef struct _MonitorTaskletLoggerClass MonitorTaskletLoggerClass;
typedef struct _MonitorTaskletLoggerPrivate MonitorTaskletLoggerPrivate;

typedef gpointer (*MonitorFuncReturning) (void* user_data);
struct _MonitorQuickAddressManager {
	NetsukukuAddressManagerTCPClient parent_instance;
	MonitorQuickAddressManagerPrivate * priv;
};

struct _MonitorQuickAddressManagerClass {
	NetsukukuAddressManagerTCPClientClass parent_class;
};

struct _MonitorQuickAddressManagerPrivate {
	gboolean thread_rmt_completed;
	zcdRemoteCall* thread_rmt_data;
	zcdISerializable* thread_rmt_ret;
	gchar* thread_rmt_error_report;
};

struct _MonitorAddressManagerFakeRmtGetter {
	GObject parent_instance;
	MonitorAddressManagerFakeRmtGetterPrivate * priv;
};

struct _MonitorAddressManagerFakeRmtGetterClass {
	GObjectClass parent_class;
};

struct _MonitorAddressManagerFakeRmtGetterPrivate {
	gchar* tcpaddress;
};

struct _MonitorTaskletLogger {
	GObject parent_instance;
	MonitorTaskletLoggerPrivate * priv;
};

struct _MonitorTaskletLoggerClass {
	GObjectClass parent_class;
};

struct _MonitorTaskletLoggerPrivate {
	MonitorAddressManagerFakeRmtGetter* client_getter;
	gint id;
	gint last_log_pos;
};


static gpointer monitor_quick_address_manager_parent_class = NULL;
static gpointer monitor_address_manager_fake_rmt_getter_parent_class = NULL;
static gpointer monitor_tasklet_logger_parent_class = NULL;

gboolean monitor_nap_until_condition (gint total_msec, MonitorFuncReturning condition_func, void* condition_func_target, gint period_usec);
GType monitor_quick_address_manager_get_type (void) G_GNUC_CONST;
#define MONITOR_QUICK_ADDRESS_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManagerPrivate))
enum  {
	MONITOR_QUICK_ADDRESS_MANAGER_DUMMY_PROPERTY
};
MonitorQuickAddressManager* monitor_quick_address_manager_new (const gchar* tcpaddress);
MonitorQuickAddressManager* monitor_quick_address_manager_construct (GType object_type, const gchar* tcpaddress);
static zcdISerializable* monitor_quick_address_manager_real_rmt (NetsukukuAddressManagerFakeRmt* base, zcdRemoteCall* data, GError** error);
static gint monitor_quick_address_manager_thread_rmt (MonitorQuickAddressManager* self);
static gpointer _monitor_quick_address_manager_thread_rmt_gthread_func (gpointer self);
static gboolean __lambda2_ (MonitorQuickAddressManager* self);
static gpointer ___lambda2__monitor_func_returning (gpointer self);
static void monitor_quick_address_manager_finalize (GObject* obj);
GType monitor_address_manager_fake_rmt_getter_get_type (void) G_GNUC_CONST;
#define MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetterPrivate))
enum  {
	MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_DUMMY_PROPERTY
};
MonitorAddressManagerFakeRmtGetter* monitor_address_manager_fake_rmt_getter_new (const gchar* tcpaddress);
MonitorAddressManagerFakeRmtGetter* monitor_address_manager_fake_rmt_getter_construct (GType object_type, const gchar* tcpaddress);
NetsukukuAddressManagerFakeRmt* monitor_address_manager_fake_rmt_getter_get_client (MonitorAddressManagerFakeRmtGetter* self);
static void monitor_address_manager_fake_rmt_getter_finalize (GObject* obj);
void monitor_main (gchar** args, int args_length1);
MonitorTaskletLogger* monitor_tasklet_logger_new (MonitorAddressManagerFakeRmtGetter* client_getter, gint id);
MonitorTaskletLogger* monitor_tasklet_logger_construct (GType object_type, MonitorAddressManagerFakeRmtGetter* client_getter, gint id);
GType monitor_tasklet_logger_get_type (void) G_GNUC_CONST;
gint monitor_tasklet_logger_run (MonitorTaskletLogger* self);
static gpointer _monitor_tasklet_logger_run_gthread_func (gpointer self);
#define MONITOR_TASKLET_LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MONITOR_TYPE_TASKLET_LOGGER, MonitorTaskletLoggerPrivate))
enum  {
	MONITOR_TASKLET_LOGGER_DUMMY_PROPERTY
};
static void monitor_tasklet_logger_finalize (GObject* obj);


gboolean monitor_nap_until_condition (gint total_msec, MonitorFuncReturning condition_func, void* condition_func_target, gint period_usec) {
	gboolean result = FALSE;
	gint _tmp0_;
	TaskletsTimer* _tmp1_;
	TaskletsTimer* t;
	gboolean ret;
	gboolean _tmp7_;
	_tmp0_ = total_msec;
	_tmp1_ = tasklets_timer_new ((gint64) _tmp0_);
	t = _tmp1_;
	ret = FALSE;
	while (TRUE) {
		TaskletsTimer* _tmp2_;
		gboolean _tmp3_ = FALSE;
		MonitorFuncReturning _tmp4_;
		void* _tmp4__target;
		gpointer _tmp5_ = NULL;
		gint _tmp6_;
		_tmp2_ = t;
		_tmp3_ = tasklets_timer_is_expired (_tmp2_);
		if (!(!_tmp3_)) {
			break;
		}
		_tmp4_ = condition_func;
		_tmp4__target = condition_func_target;
		_tmp5_ = _tmp4_ (_tmp4__target);
		if ((gboolean) ((gintptr) _tmp5_)) {
			ret = TRUE;
			break;
		}
		_tmp6_ = period_usec;
		g_usleep ((gulong) _tmp6_);
	}
	_tmp7_ = ret;
	if (!_tmp7_) {
		MonitorFuncReturning _tmp8_;
		void* _tmp8__target;
		gpointer _tmp9_ = NULL;
		_tmp8_ = condition_func;
		_tmp8__target = condition_func_target;
		_tmp9_ = _tmp8_ (_tmp8__target);
		ret = (gboolean) ((gintptr) _tmp9_);
	}
	result = ret;
	_g_object_unref0 (t);
	return result;
}


MonitorQuickAddressManager* monitor_quick_address_manager_construct (GType object_type, const gchar* tcpaddress) {
	MonitorQuickAddressManager * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	_tmp0_ = tcpaddress;
	self = (MonitorQuickAddressManager*) netsukuku_address_manager_tcp_client_construct (object_type, _tmp0_, NULL, NULL, TRUE);
	netsukuku_address_manager_tcp_client_set_retry_connect ((NetsukukuAddressManagerTCPClient*) self, FALSE);
	return self;
}


MonitorQuickAddressManager* monitor_quick_address_manager_new (const gchar* tcpaddress) {
	return monitor_quick_address_manager_construct (MONITOR_TYPE_QUICK_ADDRESS_MANAGER, tcpaddress);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _monitor_quick_address_manager_thread_rmt_gthread_func (gpointer self) {
	gpointer result;
	result = monitor_quick_address_manager_thread_rmt (self);
	g_object_unref (self);
	return result;
}


static gboolean __lambda2_ (MonitorQuickAddressManager* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	_tmp0_ = self->priv->thread_rmt_completed;
	result = _tmp0_;
	return result;
}


static gpointer ___lambda2__monitor_func_returning (gpointer self) {
	gpointer result;
	result = __lambda2_ (self);
	return result;
}


static zcdISerializable* monitor_quick_address_manager_real_rmt (NetsukukuAddressManagerFakeRmt* base, zcdRemoteCall* data, GError** error) {
	MonitorQuickAddressManager * self;
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* _tmp1_;
	GThread* _tmp2_;
	GThread* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp6_;
	zcdISerializable* _tmp9_;
	zcdISerializable* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (MonitorQuickAddressManager*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->thread_rmt_data);
	self->priv->thread_rmt_data = _tmp1_;
	self->priv->thread_rmt_completed = FALSE;
	_tmp2_ = g_thread_new (NULL, _monitor_quick_address_manager_thread_rmt_gthread_func, g_object_ref (self));
	_tmp3_ = _tmp2_;
	_g_thread_unref0 (_tmp3_);
	_tmp4_ = monitor_nap_until_condition (2000, ___lambda2__monitor_func_returning, self, 2000);
	if (!_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "Timeout");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = self->priv->thread_rmt_error_report;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		GError* _tmp8_;
		_tmp7_ = self->priv->thread_rmt_error_report;
		_tmp8_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp7_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = self->priv->thread_rmt_ret;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	return result;
}


static gint monitor_quick_address_manager_thread_rmt (MonitorQuickAddressManager* self) {
	gint result = 0;
	zcdSerializableNone* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = zcd_serializable_none_new ();
	_g_object_unref0 (self->priv->thread_rmt_ret);
	self->priv->thread_rmt_ret = (zcdISerializable*) _tmp0_;
	_g_free0 (self->priv->thread_rmt_error_report);
	self->priv->thread_rmt_error_report = NULL;
	{
		zcdRemoteCall* _tmp1_;
		zcdISerializable* _tmp2_ = NULL;
		zcdISerializable* _tmp3_;
		_tmp1_ = self->priv->thread_rmt_data;
		_tmp2_ = NETSUKUKU_ADDRESS_MANAGER_FAKE_RMT_CLASS (monitor_quick_address_manager_parent_class)->rmt ((NetsukukuAddressManagerFakeRmt*) G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_ADDRESS_MANAGER_TCP_CLIENT, NetsukukuAddressManagerTCPClient), _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch0_zcd_rpc_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_object_unref0 (self->priv->thread_rmt_ret);
		self->priv->thread_rmt_ret = _tmp3_;
	}
	goto __finally0;
	__catch0_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (self->priv->thread_rmt_error_report);
		self->priv->thread_rmt_error_report = _tmp6_;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	self->priv->thread_rmt_completed = TRUE;
	result = 0;
	return result;
}


static void monitor_quick_address_manager_class_init (MonitorQuickAddressManagerClass * klass) {
	monitor_quick_address_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MonitorQuickAddressManagerPrivate));
	NETSUKUKU_ADDRESS_MANAGER_FAKE_RMT_CLASS (klass)->rmt = monitor_quick_address_manager_real_rmt;
	G_OBJECT_CLASS (klass)->finalize = monitor_quick_address_manager_finalize;
}


static void monitor_quick_address_manager_instance_init (MonitorQuickAddressManager * self) {
	self->priv = MONITOR_QUICK_ADDRESS_MANAGER_GET_PRIVATE (self);
}


static void monitor_quick_address_manager_finalize (GObject* obj) {
	MonitorQuickAddressManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManager);
	_g_object_unref0 (self->priv->thread_rmt_data);
	_g_object_unref0 (self->priv->thread_rmt_ret);
	_g_free0 (self->priv->thread_rmt_error_report);
	G_OBJECT_CLASS (monitor_quick_address_manager_parent_class)->finalize (obj);
}


/** This class does not wait too much to report an error in communications
      * with a remotable method.
      * It is not safe to use the same object for more than one operation,
      * because if the first operation takes longer than 2 seconds the object
      * will report an error but the operation actually is carried on.
      */
GType monitor_quick_address_manager_get_type (void) {
	static volatile gsize monitor_quick_address_manager_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_quick_address_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorQuickAddressManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_quick_address_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MonitorQuickAddressManager), 0, (GInstanceInitFunc) monitor_quick_address_manager_instance_init, NULL };
		GType monitor_quick_address_manager_type_id;
		monitor_quick_address_manager_type_id = g_type_register_static (NETSUKUKU_TYPE_ADDRESS_MANAGER_TCP_CLIENT, "MonitorQuickAddressManager", &g_define_type_info, 0);
		g_once_init_leave (&monitor_quick_address_manager_type_id__volatile, monitor_quick_address_manager_type_id);
	}
	return monitor_quick_address_manager_type_id__volatile;
}


MonitorAddressManagerFakeRmtGetter* monitor_address_manager_fake_rmt_getter_construct (GType object_type, const gchar* tcpaddress) {
	MonitorAddressManagerFakeRmtGetter * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	self = (MonitorAddressManagerFakeRmtGetter*) g_object_new (object_type, NULL);
	_tmp0_ = tcpaddress;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->tcpaddress);
	self->priv->tcpaddress = _tmp1_;
	return self;
}


MonitorAddressManagerFakeRmtGetter* monitor_address_manager_fake_rmt_getter_new (const gchar* tcpaddress) {
	return monitor_address_manager_fake_rmt_getter_construct (MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, tcpaddress);
}


NetsukukuAddressManagerFakeRmt* monitor_address_manager_fake_rmt_getter_get_client (MonitorAddressManagerFakeRmtGetter* self) {
	NetsukukuAddressManagerFakeRmt* result = NULL;
	const gchar* _tmp0_;
	MonitorQuickAddressManager* _tmp1_;
	NetsukukuAddressManagerTCPClient* client;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tcpaddress;
	_tmp1_ = monitor_quick_address_manager_new (_tmp0_);
	client = (NetsukukuAddressManagerTCPClient*) _tmp1_;
	result = (NetsukukuAddressManagerFakeRmt*) client;
	return result;
}


static void monitor_address_manager_fake_rmt_getter_class_init (MonitorAddressManagerFakeRmtGetterClass * klass) {
	monitor_address_manager_fake_rmt_getter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MonitorAddressManagerFakeRmtGetterPrivate));
	G_OBJECT_CLASS (klass)->finalize = monitor_address_manager_fake_rmt_getter_finalize;
}


static void monitor_address_manager_fake_rmt_getter_instance_init (MonitorAddressManagerFakeRmtGetter * self) {
	self->priv = MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_GET_PRIVATE (self);
}


static void monitor_address_manager_fake_rmt_getter_finalize (GObject* obj) {
	MonitorAddressManagerFakeRmtGetter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetter);
	_g_free0 (self->priv->tcpaddress);
	G_OBJECT_CLASS (monitor_address_manager_fake_rmt_getter_parent_class)->finalize (obj);
}


GType monitor_address_manager_fake_rmt_getter_get_type (void) {
	static volatile gsize monitor_address_manager_fake_rmt_getter_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_address_manager_fake_rmt_getter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorAddressManagerFakeRmtGetterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_address_manager_fake_rmt_getter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MonitorAddressManagerFakeRmtGetter), 0, (GInstanceInitFunc) monitor_address_manager_fake_rmt_getter_instance_init, NULL };
		GType monitor_address_manager_fake_rmt_getter_type_id;
		monitor_address_manager_fake_rmt_getter_type_id = g_type_register_static (G_TYPE_OBJECT, "MonitorAddressManagerFakeRmtGetter", &g_define_type_info, 0);
		g_once_init_leave (&monitor_address_manager_fake_rmt_getter_type_id__volatile, monitor_address_manager_fake_rmt_getter_type_id);
	}
	return monitor_address_manager_fake_rmt_getter_type_id__volatile;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gpointer _monitor_tasklet_logger_run_gthread_func (gpointer self) {
	gpointer result;
	result = monitor_tasklet_logger_run (self);
	return result;
}


void monitor_main (gchar** args, int args_length1) {
	GOptionContext* _tmp0_;
	GOptionContext* oc;
	GOptionEntry* _tmp1_ = NULL;
	GOptionEntry* entries;
	gint entries_length1;
	gint _entries_size_;
	gint index;
	gboolean report_running;
	GOptionEntry* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	GOptionEntry _tmp4_ = {0};
	GOptionEntry _tmp5_;
	GOptionEntry* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	GOptionEntry _tmp8_ = {0};
	GOptionEntry _tmp9_;
	GOptionContext* _tmp10_;
	GOptionEntry* _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* tcpaddress;
	const gchar* _tmp21_;
	MonitorAddressManagerFakeRmtGetter* _tmp22_;
	MonitorAddressManagerFakeRmtGetter* client_getter;
	gint previous_max_id;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("ip_address");
	oc = _tmp0_;
	_tmp1_ = g_new0 (GOptionEntry, 2);
	entries = _tmp1_;
	entries_length1 = 2;
	_entries_size_ = entries_length1;
	index = 0;
	report_running = FALSE;
	_tmp2_ = entries;
	_tmp2__length1 = entries_length1;
	_tmp3_ = index;
	index = _tmp3_ + 1;
	_tmp4_.long_name = "report-running";
	_tmp4_.short_name = 'r';
	_tmp4_.flags = 0;
	_tmp4_.arg = G_OPTION_ARG_NONE;
	_tmp4_.arg_data = &report_running;
	_tmp4_.description = "Report currently running tasklets costantly";
	_tmp4_.arg_description = NULL;
	_tmp2_[_tmp3_] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3_];
	_tmp6_ = entries;
	_tmp6__length1 = entries_length1;
	_tmp7_ = index;
	index = _tmp7_ + 1;
	_tmp8_.long_name = NULL;
	_tmp6_[_tmp7_] = _tmp8_;
	_tmp9_ = _tmp6_[_tmp7_];
	_tmp10_ = oc;
	_tmp11_ = entries;
	_tmp11__length1 = entries_length1;
	g_option_context_add_main_entries (_tmp10_, _tmp11_, NULL);
	{
		GOptionContext* _tmp12_;
		_tmp12_ = oc;
		g_option_context_parse (_tmp12_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch1_g_option_error;
			}
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("Error parsing options: ", _tmp15_, "\n", NULL);
		_tmp17_ = _tmp16_;
		g_print ("%s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_error_free0 (e);
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		return;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp18_ = args;
	_tmp18__length1 = args_length1;
	_tmp19_ = _tmp18_[1];
	_tmp20_ = g_strdup (_tmp19_);
	tcpaddress = _tmp20_;
	zcd_serializer_init ();
	netsukuku_rpc_ntk_init ();
	_tmp21_ = tcpaddress;
	_tmp22_ = monitor_address_manager_fake_rmt_getter_new (_tmp21_);
	client_getter = _tmp22_;
	previous_max_id = 0;
	while (TRUE) {
		MonitorAddressManagerFakeRmtGetter* _tmp23_;
		NetsukukuAddressManagerFakeRmt* _tmp24_ = NULL;
		NetsukukuAddressManagerFakeRmt* _tmp25_;
		GeeList* _tmp26_ = NULL;
		GeeList* _tmp27_;
		GeeList* str_ids;
		gchar* _tmp28_;
		gchar* output;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gboolean _tmp57_;
		_tmp23_ = client_getter;
		_tmp24_ = monitor_address_manager_fake_rmt_getter_get_client (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = netsukuku_iaddress_manager_root_dispatcher_report_running_tasklets ((NetsukukuIAddressManagerRootDispatcher*) _tmp25_, &_inner_error_);
		_tmp27_ = _tmp26_;
		_g_object_unref0 (_tmp25_);
		str_ids = _tmp27_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client_getter);
			_g_free0 (tcpaddress);
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp28_ = g_strdup ("running: [");
		output = _tmp28_;
		{
			GeeList* _tmp29_;
			GeeList* _tmp30_;
			GeeList* _str_id_list;
			GeeList* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _str_id_size;
			gint _str_id_index;
			_tmp29_ = str_ids;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			_str_id_list = _tmp30_;
			_tmp31_ = _str_id_list;
			_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
			_tmp33_ = _tmp32_;
			_str_id_size = _tmp33_;
			_str_id_index = -1;
			while (TRUE) {
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				GeeList* _tmp37_;
				gint _tmp38_;
				gpointer _tmp39_ = NULL;
				gchar* str_id;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				const gchar* _tmp45_;
				gint _tmp46_ = 0;
				gint id;
				gint _tmp47_;
				gint _tmp48_;
				_tmp34_ = _str_id_index;
				_str_id_index = _tmp34_ + 1;
				_tmp35_ = _str_id_index;
				_tmp36_ = _str_id_size;
				if (!(_tmp35_ < _tmp36_)) {
					break;
				}
				_tmp37_ = _str_id_list;
				_tmp38_ = _str_id_index;
				_tmp39_ = gee_list_get (_tmp37_, _tmp38_);
				str_id = (gchar*) _tmp39_;
				_tmp40_ = output;
				_tmp41_ = str_id;
				_tmp42_ = g_strconcat (_tmp41_, " ", NULL);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat (_tmp40_, _tmp43_, NULL);
				_g_free0 (output);
				output = _tmp44_;
				_g_free0 (_tmp43_);
				_tmp45_ = str_id;
				_tmp46_ = atoi (_tmp45_);
				id = _tmp46_;
				_tmp47_ = id;
				_tmp48_ = previous_max_id;
				if (_tmp47_ > _tmp48_) {
					MonitorAddressManagerFakeRmtGetter* _tmp49_;
					gint _tmp50_;
					MonitorTaskletLogger* _tmp51_;
					MonitorTaskletLogger* tl;
					MonitorTaskletLogger* _tmp52_;
					GThread* _tmp53_;
					GThread* t_op;
					gint _tmp54_;
					_tmp49_ = client_getter;
					_tmp50_ = id;
					_tmp51_ = monitor_tasklet_logger_new (_tmp49_, _tmp50_);
					tl = _tmp51_;
					_tmp52_ = tl;
					_tmp53_ = g_thread_new (NULL, _monitor_tasklet_logger_run_gthread_func, g_object_ref (_tmp52_));
					t_op = _tmp53_;
					g_usleep ((gulong) 10000);
					_tmp54_ = id;
					previous_max_id = _tmp54_;
					_g_thread_unref0 (t_op);
					_g_object_unref0 (tl);
				}
				_g_free0 (str_id);
			}
			_g_object_unref0 (_str_id_list);
		}
		_tmp55_ = output;
		_tmp56_ = g_strconcat (_tmp55_, "]\n", NULL);
		_g_free0 (output);
		output = _tmp56_;
		_tmp57_ = report_running;
		if (_tmp57_) {
			const gchar* _tmp58_;
			_tmp58_ = output;
			g_print ("%s", _tmp58_);
		}
		g_usleep ((gulong) 900000);
		_g_free0 (output);
		_g_object_unref0 (str_ids);
	}
	_g_object_unref0 (client_getter);
	_g_free0 (tcpaddress);
	entries = (g_free (entries), NULL);
	_g_option_context_free0 (oc);
}


int main (int argc, char ** argv) {
	g_type_init ();
	monitor_main (argv, argc);
	return 0;
}


MonitorTaskletLogger* monitor_tasklet_logger_construct (GType object_type, MonitorAddressManagerFakeRmtGetter* client_getter, gint id) {
	MonitorTaskletLogger * self = NULL;
	MonitorAddressManagerFakeRmtGetter* _tmp0_;
	MonitorAddressManagerFakeRmtGetter* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (client_getter != NULL, NULL);
	self = (MonitorTaskletLogger*) g_object_new (object_type, NULL);
	_tmp0_ = client_getter;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->client_getter);
	self->priv->client_getter = _tmp1_;
	_tmp2_ = id;
	self->priv->id = _tmp2_;
	self->priv->last_log_pos = -1;
	return self;
}


MonitorTaskletLogger* monitor_tasklet_logger_new (MonitorAddressManagerFakeRmtGetter* client_getter, gint id) {
	return monitor_tasklet_logger_construct (MONITOR_TYPE_TASKLET_LOGGER, client_getter, id);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gint monitor_tasklet_logger_run (MonitorTaskletLogger* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	while (TRUE) {
		{
			MonitorAddressManagerFakeRmtGetter* _tmp0_;
			NetsukukuAddressManagerFakeRmt* _tmp1_ = NULL;
			NetsukukuAddressManagerFakeRmt* _tmp2_;
			gint _tmp3_;
			GeeList* _tmp4_ = NULL;
			GeeList* _tmp5_;
			GeeList* logs;
			GeeList* _tmp6_;
			gpointer _tmp7_ = NULL;
			gchar* name;
			const gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_;
			const gchar* _tmp13_;
			GeeList* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp0_ = self->priv->client_getter;
			_tmp1_ = monitor_address_manager_fake_rmt_getter_get_client (_tmp0_);
			_tmp2_ = _tmp1_;
			_tmp3_ = self->priv->id;
			_tmp4_ = netsukuku_iaddress_manager_root_dispatcher_report_tasklet_logs ((NetsukukuIAddressManagerRootDispatcher*) _tmp2_, _tmp3_, &_inner_error_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp2_);
			logs = _tmp5_;
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			_tmp6_ = logs;
			_tmp7_ = gee_list_remove_at (_tmp6_, 0);
			name = (gchar*) _tmp7_;
			_tmp8_ = name;
			_tmp9_ = g_utf8_strup (_tmp8_, (gssize) (-1));
			_tmp10_ = _tmp9_;
			_tmp11_ = string_contains (_tmp10_, "TCPSERVER");
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp10_);
			if (_tmp12_) {
				result = 0;
				_g_free0 (name);
				_g_object_unref0 (logs);
				return result;
			}
			_tmp13_ = name;
			if (g_strcmp0 (_tmp13_, "STOPPED") == 0) {
				result = 0;
				_g_free0 (name);
				_g_object_unref0 (logs);
				return result;
			}
			_tmp14_ = logs;
			_tmp15_ = gee_collection_get_is_empty ((GeeCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			if (!_tmp16_) {
				GeeList* _tmp17_;
				gpointer _tmp18_ = NULL;
				gchar* _tmp19_;
				gint _tmp20_ = 0;
				gint _tmp21_;
				gint next_pos;
				gint _tmp22_;
				GeeList* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp34_;
				gint _tmp35_;
				gint i;
				gint _tmp36_;
				gint _tmp62_;
				GeeList* _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				_tmp17_ = logs;
				_tmp18_ = gee_list_remove_at (_tmp17_, 0);
				_tmp19_ = (gchar*) _tmp18_;
				_tmp20_ = atoi (_tmp19_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				next_pos = _tmp21_;
				_tmp22_ = next_pos;
				_tmp23_ = logs;
				_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = self->priv->last_log_pos;
				if (((_tmp22_ + _tmp25_) - 1) > _tmp26_) {
					const gchar* _tmp27_;
					const gchar* _tmp28_ = NULL;
					gint _tmp29_;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_;
					_tmp27_ = name;
					_tmp28_ = string_to_string (_tmp27_);
					_tmp29_ = self->priv->id;
					_tmp30_ = g_strdup_printf ("%i", _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strconcat (_tmp28_, " [", _tmp31_, "]\n", NULL);
					_tmp33_ = _tmp32_;
					g_print ("%s", _tmp33_);
					_g_free0 (_tmp33_);
					_g_free0 (_tmp31_);
				}
				_tmp34_ = self->priv->last_log_pos;
				_tmp35_ = next_pos;
				i = (_tmp34_ - _tmp35_) + 1;
				_tmp36_ = i;
				if (_tmp36_ < 0) {
					i = 0;
				}
				{
					gboolean _tmp37_;
					_tmp37_ = TRUE;
					while (TRUE) {
						gboolean _tmp38_;
						gint _tmp40_;
						GeeList* _tmp41_;
						gint _tmp42_;
						gint _tmp43_;
						gint _tmp44_;
						GeeList* _tmp45_;
						gint _tmp46_;
						gint _tmp47_;
						_tmp38_ = _tmp37_;
						if (!_tmp38_) {
							gint _tmp39_;
							_tmp39_ = i;
							i = _tmp39_ + 1;
						}
						_tmp37_ = FALSE;
						_tmp40_ = i;
						_tmp41_ = logs;
						_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
						_tmp43_ = _tmp42_;
						if (!(_tmp40_ < _tmp43_)) {
							break;
						}
						_tmp44_ = i;
						_tmp45_ = logs;
						_tmp46_ = gee_collection_get_size ((GeeCollection*) _tmp45_);
						_tmp47_ = _tmp46_;
						if ((_tmp44_ + 1) < _tmp47_) {
							GeeList* _tmp48_;
							gint _tmp49_;
							gpointer _tmp50_ = NULL;
							gchar* _tmp51_;
							const gchar* _tmp52_ = NULL;
							gchar* _tmp53_ = NULL;
							gchar* _tmp54_;
							_tmp48_ = logs;
							_tmp49_ = i;
							_tmp50_ = gee_list_get (_tmp48_, _tmp49_);
							_tmp51_ = (gchar*) _tmp50_;
							_tmp52_ = string_to_string (_tmp51_);
							_tmp53_ = g_strconcat (" |\\__ ", _tmp52_, "\n", NULL);
							_tmp54_ = _tmp53_;
							g_print ("%s", _tmp54_);
							_g_free0 (_tmp54_);
							_g_free0 (_tmp51_);
						} else {
							GeeList* _tmp55_;
							gint _tmp56_;
							gpointer _tmp57_ = NULL;
							gchar* _tmp58_;
							const gchar* _tmp59_ = NULL;
							gchar* _tmp60_ = NULL;
							gchar* _tmp61_;
							_tmp55_ = logs;
							_tmp56_ = i;
							_tmp57_ = gee_list_get (_tmp55_, _tmp56_);
							_tmp58_ = (gchar*) _tmp57_;
							_tmp59_ = string_to_string (_tmp58_);
							_tmp60_ = g_strconcat ("  \\__ ", _tmp59_, "\n", NULL);
							_tmp61_ = _tmp60_;
							g_print ("%s", _tmp61_);
							_g_free0 (_tmp61_);
							_g_free0 (_tmp58_);
						}
					}
				}
				_tmp62_ = next_pos;
				_tmp63_ = logs;
				_tmp64_ = gee_collection_get_size ((GeeCollection*) _tmp63_);
				_tmp65_ = _tmp64_;
				self->priv->last_log_pos = (_tmp62_ + _tmp65_) - 1;
			}
			_g_free0 (name);
			_g_object_unref0 (logs);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			gint _tmp66_;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_;
			GError* _tmp69_;
			const gchar* _tmp70_;
			const gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			gchar* _tmp73_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp66_ = self->priv->id;
			_tmp67_ = g_strdup_printf ("%i", _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = e;
			_tmp70_ = _tmp69_->message;
			_tmp71_ = string_to_string (_tmp70_);
			_tmp72_ = g_strconcat ("Error on id = ", _tmp68_, " ", _tmp71_, "\n", NULL);
			_tmp73_ = _tmp72_;
			g_print ("%s", _tmp73_);
			_g_free0 (_tmp73_);
			_g_free0 (_tmp68_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		g_usleep ((gulong) 700000);
	}
}


static void monitor_tasklet_logger_class_init (MonitorTaskletLoggerClass * klass) {
	monitor_tasklet_logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MonitorTaskletLoggerPrivate));
	G_OBJECT_CLASS (klass)->finalize = monitor_tasklet_logger_finalize;
}


static void monitor_tasklet_logger_instance_init (MonitorTaskletLogger * self) {
	self->priv = MONITOR_TASKLET_LOGGER_GET_PRIVATE (self);
}


static void monitor_tasklet_logger_finalize (GObject* obj) {
	MonitorTaskletLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MONITOR_TYPE_TASKLET_LOGGER, MonitorTaskletLogger);
	_g_object_unref0 (self->priv->client_getter);
	G_OBJECT_CLASS (monitor_tasklet_logger_parent_class)->finalize (obj);
}


GType monitor_tasklet_logger_get_type (void) {
	static volatile gsize monitor_tasklet_logger_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_tasklet_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorTaskletLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_tasklet_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MonitorTaskletLogger), 0, (GInstanceInitFunc) monitor_tasklet_logger_instance_init, NULL };
		GType monitor_tasklet_logger_type_id;
		monitor_tasklet_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "MonitorTaskletLogger", &g_define_type_info, 0);
		g_once_init_leave (&monitor_tasklet_logger_type_id__volatile, monitor_tasklet_logger_type_id);
	}
	return monitor_tasklet_logger_type_id__volatile;
}



