/* main.c generated by valac 0.20.1, the Vala compiler
 * generated from main.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <zcd-tcpclient.h>
#include <netsukuku-rpc-tcpclient.h>
#include <gtk/gtk.h>
#include <ntkutils.h>
#include <math.h>
#include <float.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MONITOR_TYPE_QUICK_ADDRESS_MANAGER (monitor_quick_address_manager_get_type ())
#define MONITOR_QUICK_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManager))
#define MONITOR_QUICK_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManagerClass))
#define MONITOR_IS_QUICK_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONITOR_TYPE_QUICK_ADDRESS_MANAGER))
#define MONITOR_IS_QUICK_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MONITOR_TYPE_QUICK_ADDRESS_MANAGER))
#define MONITOR_QUICK_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManagerClass))

typedef struct _MonitorQuickAddressManager MonitorQuickAddressManager;
typedef struct _MonitorQuickAddressManagerClass MonitorQuickAddressManagerClass;
typedef struct _MonitorQuickAddressManagerPrivate MonitorQuickAddressManagerPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER (monitor_address_manager_fake_rmt_getter_get_type ())
#define MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetter))
#define MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetterClass))
#define MONITOR_IS_ADDRESS_MANAGER_FAKE_RMT_GETTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER))
#define MONITOR_IS_ADDRESS_MANAGER_FAKE_RMT_GETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER))
#define MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetterClass))

typedef struct _MonitorAddressManagerFakeRmtGetter MonitorAddressManagerFakeRmtGetter;
typedef struct _MonitorAddressManagerFakeRmtGetterClass MonitorAddressManagerFakeRmtGetterClass;
typedef struct _MonitorAddressManagerFakeRmtGetterPrivate MonitorAddressManagerFakeRmtGetterPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define MONITOR_TYPE_NODE (monitor_node_get_type ())
#define MONITOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONITOR_TYPE_NODE, MonitorNode))
#define MONITOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MONITOR_TYPE_NODE, MonitorNodeClass))
#define MONITOR_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONITOR_TYPE_NODE))
#define MONITOR_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MONITOR_TYPE_NODE))
#define MONITOR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MONITOR_TYPE_NODE, MonitorNodeClass))

typedef struct _MonitorNode MonitorNode;
typedef struct _MonitorNodeClass MonitorNodeClass;

typedef gpointer (*MonitorFuncReturning) (void* user_data);
struct _MonitorQuickAddressManager {
	NetsukukuAddressManagerTCPClient parent_instance;
	MonitorQuickAddressManagerPrivate * priv;
};

struct _MonitorQuickAddressManagerClass {
	NetsukukuAddressManagerTCPClientClass parent_class;
};

struct _MonitorQuickAddressManagerPrivate {
	gboolean thread_rmt_completed;
	zcdRemoteCall* thread_rmt_data;
	zcdISerializable* thread_rmt_ret;
	gchar* thread_rmt_error_report;
};

struct _MonitorAddressManagerFakeRmtGetter {
	GObject parent_instance;
	MonitorAddressManagerFakeRmtGetterPrivate * priv;
};

struct _MonitorAddressManagerFakeRmtGetterClass {
	GObjectClass parent_class;
};

struct _MonitorAddressManagerFakeRmtGetterPrivate {
	gchar* tcpaddress;
};


static gpointer monitor_quick_address_manager_parent_class = NULL;
static gpointer monitor_address_manager_fake_rmt_getter_parent_class = NULL;

void monitor_log_debug (const gchar* msg);
void monitor_log_info (const gchar* msg);
void monitor_log_notice (const gchar* msg);
void monitor_log_warn (const gchar* msg);
void monitor_log_error (const gchar* msg);
void monitor_log_critical (const gchar* msg);
gboolean monitor_nap_until_condition (gint total_msec, MonitorFuncReturning condition_func, void* condition_func_target, gint period_usec);
GType monitor_quick_address_manager_get_type (void) G_GNUC_CONST;
#define MONITOR_QUICK_ADDRESS_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManagerPrivate))
enum  {
	MONITOR_QUICK_ADDRESS_MANAGER_DUMMY_PROPERTY
};
MonitorQuickAddressManager* monitor_quick_address_manager_new (const gchar* tcpaddress);
MonitorQuickAddressManager* monitor_quick_address_manager_construct (GType object_type, const gchar* tcpaddress);
static zcdISerializable* monitor_quick_address_manager_real_rmt (NetsukukuAddressManagerFakeRmt* base, zcdRemoteCall* data, GError** error);
static gint monitor_quick_address_manager_thread_rmt (MonitorQuickAddressManager* self);
static gpointer _monitor_quick_address_manager_thread_rmt_gthread_func (gpointer self);
static gboolean __lambda2_ (MonitorQuickAddressManager* self);
static gpointer ___lambda2__monitor_func_returning (gpointer self);
static void monitor_quick_address_manager_finalize (GObject* obj);
GType monitor_address_manager_fake_rmt_getter_get_type (void) G_GNUC_CONST;
#define MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetterPrivate))
enum  {
	MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_DUMMY_PROPERTY
};
MonitorAddressManagerFakeRmtGetter* monitor_address_manager_fake_rmt_getter_new (const gchar* tcpaddress);
MonitorAddressManagerFakeRmtGetter* monitor_address_manager_fake_rmt_getter_construct (GType object_type, const gchar* tcpaddress);
NetsukukuAddressManagerFakeRmt* monitor_address_manager_fake_rmt_getter_get_client (MonitorAddressManagerFakeRmtGetter* self);
static void monitor_address_manager_fake_rmt_getter_finalize (GObject* obj);
gint monitor_main (gchar** args, int args_length1);
MonitorNode* monitor_node_new (const gchar* name, MonitorAddressManagerFakeRmtGetter* client_getter, GError** error);
MonitorNode* monitor_node_construct (GType object_type, const gchar* name, MonitorAddressManagerFakeRmtGetter* client_getter, GError** error);
GType monitor_node_get_type (void) G_GNUC_CONST;
gchar* monitor_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
guchar* monitor_nip_to_pip (gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1);
guchar* monitor_ip_to_pip (guint64 ip, gint numbytes, int* result_length1);


void monitor_log_debug (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("DEBUG ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_DEBUG, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void monitor_log_info (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_INFO, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void monitor_log_notice (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_NOTICE, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void monitor_log_warn (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO++ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_WARNING, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void monitor_log_error (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("ERROR ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_ERR, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void monitor_log_critical (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("ERROR+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_CRIT, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


gboolean monitor_nap_until_condition (gint total_msec, MonitorFuncReturning condition_func, void* condition_func_target, gint period_usec) {
	gboolean result = FALSE;
	gint _tmp0_;
	TaskletsTimer* _tmp1_;
	TaskletsTimer* t;
	gboolean ret;
	gboolean _tmp7_;
	_tmp0_ = total_msec;
	_tmp1_ = tasklets_timer_new ((gint64) _tmp0_);
	t = _tmp1_;
	ret = FALSE;
	while (TRUE) {
		TaskletsTimer* _tmp2_;
		gboolean _tmp3_ = FALSE;
		MonitorFuncReturning _tmp4_;
		void* _tmp4__target;
		gpointer _tmp5_ = NULL;
		gint _tmp6_;
		_tmp2_ = t;
		_tmp3_ = tasklets_timer_is_expired (_tmp2_);
		if (!(!_tmp3_)) {
			break;
		}
		_tmp4_ = condition_func;
		_tmp4__target = condition_func_target;
		_tmp5_ = _tmp4_ (_tmp4__target);
		if ((gboolean) ((gintptr) _tmp5_)) {
			ret = TRUE;
			break;
		}
		_tmp6_ = period_usec;
		g_usleep ((gulong) _tmp6_);
	}
	_tmp7_ = ret;
	if (!_tmp7_) {
		MonitorFuncReturning _tmp8_;
		void* _tmp8__target;
		gpointer _tmp9_ = NULL;
		_tmp8_ = condition_func;
		_tmp8__target = condition_func_target;
		_tmp9_ = _tmp8_ (_tmp8__target);
		ret = (gboolean) ((gintptr) _tmp9_);
	}
	result = ret;
	_g_object_unref0 (t);
	return result;
}


MonitorQuickAddressManager* monitor_quick_address_manager_construct (GType object_type, const gchar* tcpaddress) {
	MonitorQuickAddressManager * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	_tmp0_ = tcpaddress;
	self = (MonitorQuickAddressManager*) netsukuku_address_manager_tcp_client_construct (object_type, _tmp0_, NULL, NULL, TRUE);
	netsukuku_address_manager_tcp_client_set_retry_connect ((NetsukukuAddressManagerTCPClient*) self, FALSE);
	return self;
}


MonitorQuickAddressManager* monitor_quick_address_manager_new (const gchar* tcpaddress) {
	return monitor_quick_address_manager_construct (MONITOR_TYPE_QUICK_ADDRESS_MANAGER, tcpaddress);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _monitor_quick_address_manager_thread_rmt_gthread_func (gpointer self) {
	gpointer result;
	result = monitor_quick_address_manager_thread_rmt (self);
	g_object_unref (self);
	return result;
}


static gboolean __lambda2_ (MonitorQuickAddressManager* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	_tmp0_ = self->priv->thread_rmt_completed;
	result = _tmp0_;
	return result;
}


static gpointer ___lambda2__monitor_func_returning (gpointer self) {
	gpointer result;
	result = __lambda2_ (self);
	return result;
}


static zcdISerializable* monitor_quick_address_manager_real_rmt (NetsukukuAddressManagerFakeRmt* base, zcdRemoteCall* data, GError** error) {
	MonitorQuickAddressManager * self;
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* _tmp1_;
	GThread* _tmp2_;
	GThread* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp6_;
	zcdISerializable* _tmp9_;
	zcdISerializable* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (MonitorQuickAddressManager*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->thread_rmt_data);
	self->priv->thread_rmt_data = _tmp1_;
	self->priv->thread_rmt_completed = FALSE;
	_tmp2_ = g_thread_new (NULL, _monitor_quick_address_manager_thread_rmt_gthread_func, g_object_ref (self));
	_tmp3_ = _tmp2_;
	_g_thread_unref0 (_tmp3_);
	_tmp4_ = monitor_nap_until_condition (2000, ___lambda2__monitor_func_returning, self, 2000);
	if (!_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "Timeout");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = self->priv->thread_rmt_error_report;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		GError* _tmp8_;
		_tmp7_ = self->priv->thread_rmt_error_report;
		_tmp8_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp7_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = self->priv->thread_rmt_ret;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	return result;
}


static gint monitor_quick_address_manager_thread_rmt (MonitorQuickAddressManager* self) {
	gint result = 0;
	zcdSerializableNone* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = zcd_serializable_none_new ();
	_g_object_unref0 (self->priv->thread_rmt_ret);
	self->priv->thread_rmt_ret = (zcdISerializable*) _tmp0_;
	_g_free0 (self->priv->thread_rmt_error_report);
	self->priv->thread_rmt_error_report = NULL;
	{
		zcdRemoteCall* _tmp1_;
		zcdISerializable* _tmp2_ = NULL;
		zcdISerializable* _tmp3_;
		_tmp1_ = self->priv->thread_rmt_data;
		_tmp2_ = NETSUKUKU_ADDRESS_MANAGER_FAKE_RMT_CLASS (monitor_quick_address_manager_parent_class)->rmt ((NetsukukuAddressManagerFakeRmt*) G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_ADDRESS_MANAGER_TCP_CLIENT, NetsukukuAddressManagerTCPClient), _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch0_zcd_rpc_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_object_unref0 (self->priv->thread_rmt_ret);
		self->priv->thread_rmt_ret = _tmp3_;
	}
	goto __finally0;
	__catch0_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (self->priv->thread_rmt_error_report);
		self->priv->thread_rmt_error_report = _tmp6_;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	self->priv->thread_rmt_completed = TRUE;
	result = 0;
	return result;
}


static void monitor_quick_address_manager_class_init (MonitorQuickAddressManagerClass * klass) {
	monitor_quick_address_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MonitorQuickAddressManagerPrivate));
	NETSUKUKU_ADDRESS_MANAGER_FAKE_RMT_CLASS (klass)->rmt = monitor_quick_address_manager_real_rmt;
	G_OBJECT_CLASS (klass)->finalize = monitor_quick_address_manager_finalize;
}


static void monitor_quick_address_manager_instance_init (MonitorQuickAddressManager * self) {
	self->priv = MONITOR_QUICK_ADDRESS_MANAGER_GET_PRIVATE (self);
}


static void monitor_quick_address_manager_finalize (GObject* obj) {
	MonitorQuickAddressManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MONITOR_TYPE_QUICK_ADDRESS_MANAGER, MonitorQuickAddressManager);
	_g_object_unref0 (self->priv->thread_rmt_data);
	_g_object_unref0 (self->priv->thread_rmt_ret);
	_g_free0 (self->priv->thread_rmt_error_report);
	G_OBJECT_CLASS (monitor_quick_address_manager_parent_class)->finalize (obj);
}


/** This class does not wait too much to report an error in communications
      * with a remotable method.
      * It is not safe to use the same object for more than one operation,
      * because if the first operation takes longer than 2 seconds the object
      * will report an error but the operation actually is carried on.
      */
GType monitor_quick_address_manager_get_type (void) {
	static volatile gsize monitor_quick_address_manager_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_quick_address_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorQuickAddressManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_quick_address_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MonitorQuickAddressManager), 0, (GInstanceInitFunc) monitor_quick_address_manager_instance_init, NULL };
		GType monitor_quick_address_manager_type_id;
		monitor_quick_address_manager_type_id = g_type_register_static (NETSUKUKU_TYPE_ADDRESS_MANAGER_TCP_CLIENT, "MonitorQuickAddressManager", &g_define_type_info, 0);
		g_once_init_leave (&monitor_quick_address_manager_type_id__volatile, monitor_quick_address_manager_type_id);
	}
	return monitor_quick_address_manager_type_id__volatile;
}


MonitorAddressManagerFakeRmtGetter* monitor_address_manager_fake_rmt_getter_construct (GType object_type, const gchar* tcpaddress) {
	MonitorAddressManagerFakeRmtGetter * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	self = (MonitorAddressManagerFakeRmtGetter*) g_object_new (object_type, NULL);
	_tmp0_ = tcpaddress;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->tcpaddress);
	self->priv->tcpaddress = _tmp1_;
	return self;
}


MonitorAddressManagerFakeRmtGetter* monitor_address_manager_fake_rmt_getter_new (const gchar* tcpaddress) {
	return monitor_address_manager_fake_rmt_getter_construct (MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, tcpaddress);
}


NetsukukuAddressManagerFakeRmt* monitor_address_manager_fake_rmt_getter_get_client (MonitorAddressManagerFakeRmtGetter* self) {
	NetsukukuAddressManagerFakeRmt* result = NULL;
	const gchar* _tmp0_;
	MonitorQuickAddressManager* _tmp1_;
	NetsukukuAddressManagerTCPClient* client;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tcpaddress;
	_tmp1_ = monitor_quick_address_manager_new (_tmp0_);
	client = (NetsukukuAddressManagerTCPClient*) _tmp1_;
	result = (NetsukukuAddressManagerFakeRmt*) client;
	return result;
}


static void monitor_address_manager_fake_rmt_getter_class_init (MonitorAddressManagerFakeRmtGetterClass * klass) {
	monitor_address_manager_fake_rmt_getter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MonitorAddressManagerFakeRmtGetterPrivate));
	G_OBJECT_CLASS (klass)->finalize = monitor_address_manager_fake_rmt_getter_finalize;
}


static void monitor_address_manager_fake_rmt_getter_instance_init (MonitorAddressManagerFakeRmtGetter * self) {
	self->priv = MONITOR_ADDRESS_MANAGER_FAKE_RMT_GETTER_GET_PRIVATE (self);
}


static void monitor_address_manager_fake_rmt_getter_finalize (GObject* obj) {
	MonitorAddressManagerFakeRmtGetter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MONITOR_TYPE_ADDRESS_MANAGER_FAKE_RMT_GETTER, MonitorAddressManagerFakeRmtGetter);
	_g_free0 (self->priv->tcpaddress);
	G_OBJECT_CLASS (monitor_address_manager_fake_rmt_getter_parent_class)->finalize (obj);
}


GType monitor_address_manager_fake_rmt_getter_get_type (void) {
	static volatile gsize monitor_address_manager_fake_rmt_getter_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_address_manager_fake_rmt_getter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorAddressManagerFakeRmtGetterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_address_manager_fake_rmt_getter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MonitorAddressManagerFakeRmtGetter), 0, (GInstanceInitFunc) monitor_address_manager_fake_rmt_getter_instance_init, NULL };
		GType monitor_address_manager_fake_rmt_getter_type_id;
		monitor_address_manager_fake_rmt_getter_type_id = g_type_register_static (G_TYPE_OBJECT, "MonitorAddressManagerFakeRmtGetter", &g_define_type_info, 0);
		g_once_init_leave (&monitor_address_manager_fake_rmt_getter_type_id__volatile, monitor_address_manager_fake_rmt_getter_type_id);
	}
	return monitor_address_manager_fake_rmt_getter_type_id__volatile;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gint monitor_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* oc;
	GOptionEntry* _tmp1_ = NULL;
	GOptionEntry* entries;
	gint entries_length1;
	gint _entries_size_;
	gint index;
	GOptionEntry* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	GOptionEntry _tmp4_ = {0};
	GOptionEntry _tmp5_;
	GOptionContext* _tmp6_;
	GOptionEntry* _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* tcpaddress;
	const gchar* _tmp17_;
	MonitorAddressManagerFakeRmtGetter* _tmp18_;
	MonitorAddressManagerFakeRmtGetter* client_getter;
	const gchar* _tmp19_;
	MonitorAddressManagerFakeRmtGetter* _tmp20_;
	MonitorNode* _tmp21_;
	MonitorNode* x;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("ip_address");
	oc = _tmp0_;
	_tmp1_ = g_new0 (GOptionEntry, 1);
	entries = _tmp1_;
	entries_length1 = 1;
	_entries_size_ = entries_length1;
	index = 0;
	_tmp2_ = entries;
	_tmp2__length1 = entries_length1;
	_tmp3_ = index;
	index = _tmp3_ + 1;
	_tmp4_.long_name = NULL;
	_tmp2_[_tmp3_] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3_];
	_tmp6_ = oc;
	_tmp7_ = entries;
	_tmp7__length1 = entries_length1;
	g_option_context_add_main_entries (_tmp6_, _tmp7_, NULL);
	{
		GOptionContext* _tmp8_;
		_tmp8_ = oc;
		g_option_context_parse (_tmp8_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch1_g_option_error;
			}
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally1;
	__catch1_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = g_strconcat ("Error parsing options: ", _tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		g_print ("%s", _tmp13_);
		_g_free0 (_tmp13_);
		result = 1;
		_g_error_free0 (e);
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_init (&args_length1, &args);
	_tmp14_ = args;
	_tmp14__length1 = args_length1;
	_tmp15_ = _tmp14_[1];
	_tmp16_ = g_strdup (_tmp15_);
	tcpaddress = _tmp16_;
	zcd_serializer_init ();
	netsukuku_rpc_ntk_init ();
	openlog ("Ntk monitor", LOG_PID, LOG_USER);
	_tmp17_ = tcpaddress;
	_tmp18_ = monitor_address_manager_fake_rmt_getter_new (_tmp17_);
	client_getter = _tmp18_;
	_tmp19_ = tcpaddress;
	_tmp20_ = client_getter;
	_tmp21_ = monitor_node_new (_tmp19_, _tmp20_, &_inner_error_);
	x = _tmp21_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client_getter);
		_g_free0 (tcpaddress);
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_main ();
	exit (0);
	result = 0;
	_g_object_unref0 (x);
	_g_object_unref0 (client_getter);
	_g_free0 (tcpaddress);
	entries = (g_free (entries), NULL);
	_g_option_context_free0 (oc);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return monitor_main (argv, argc);
}


gchar* monitor_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_ = 0;
	guchar* _tmp4_ = NULL;
	guchar* pip;
	gint pip_length1;
	gint _pip_size_;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = nip;
	_tmp4_ = monitor_nip_to_pip (_tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	pip = _tmp4_;
	pip_length1 = _tmp3_;
	_pip_size_ = pip_length1;
	_tmp5_ = netsukuku_inet_utils_address_v4_bytes_to_str (pip, pip_length1);
	result = _tmp5_;
	pip = (g_free (pip), NULL);
	return result;
}


guchar* monitor_nip_to_pip (gint levels, gint gsize, NetsukukuNIP* nip, int* result_length1) {
	guchar* result = NULL;
	guint64 ip;
	guint64 _tmp12_;
	gdouble _tmp13_ = 0.0;
	gint _tmp14_ = 0;
	guchar* _tmp15_ = NULL;
	guchar* _tmp16_;
	gint _tmp16__length1;
	g_return_val_if_fail (nip != NULL, NULL);
	ip = (guint64) 0;
	{
		gint l;
		l = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				guint64 _tmp5_;
				NetsukukuNIP* _tmp6_;
				gint _tmp7_;
				gint _tmp8_ = 0;
				gint _tmp9_;
				gint _tmp10_;
				gdouble _tmp11_ = 0.0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l;
					l = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = l;
				_tmp4_ = levels;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = ip;
				_tmp6_ = nip;
				_tmp7_ = l;
				_tmp8_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp6_, _tmp7_);
				_tmp9_ = gsize;
				_tmp10_ = l;
				_tmp11_ = pow ((gdouble) _tmp9_, (gdouble) _tmp10_);
				ip = _tmp5_ + (_tmp8_ * ((guint64) _tmp11_));
			}
		}
	}
	_tmp12_ = ip;
	_tmp13_ = pow ((gdouble) 256, (gdouble) 3);
	_tmp15_ = monitor_ip_to_pip (_tmp12_ + (10 * ((guint64) _tmp13_)), 4, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


guchar* monitor_ip_to_pip (guint64 ip, gint numbytes, int* result_length1) {
	guchar* result = NULL;
	gint _tmp0_;
	guchar* _tmp1_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	gint j;
	guchar* _tmp16_;
	gint _tmp16__length1;
	_tmp0_ = numbytes;
	_tmp1_ = g_new0 (guchar, _tmp0_);
	ret = _tmp1_;
	ret_length1 = _tmp0_;
	_ret_size_ = ret_length1;
	j = 0;
	{
		gint _tmp2_;
		gint i;
		_tmp2_ = numbytes;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				guint64 _tmp7_;
				gint _tmp8_;
				gdouble _tmp9_ = 0.0;
				gint _tmp10_;
				gdouble _tmp11_ = 0.0;
				gint c;
				guchar* _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				gint _tmp14_;
				guchar _tmp15_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = ip;
				_tmp8_ = i;
				_tmp9_ = pow ((gdouble) 256, (gdouble) (_tmp8_ + 1));
				_tmp10_ = i;
				_tmp11_ = pow ((gdouble) 256, (gdouble) _tmp10_);
				c = (gint) ((_tmp7_ % ((guint64) _tmp9_)) / ((guint64) _tmp11_));
				_tmp12_ = ret;
				_tmp12__length1 = ret_length1;
				_tmp13_ = j;
				j = _tmp13_ + 1;
				_tmp14_ = c;
				_tmp12_[_tmp13_] = (guchar) _tmp14_;
				_tmp15_ = _tmp12_[_tmp13_];
			}
		}
	}
	_tmp16_ = ret;
	_tmp16__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}



