/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Gee;
using zcd;
using Tasklets;
using Netsukuku;

namespace Monitor
{
    public class Server : Object
    {
        public Window win_server {get; private set;}
        public Widget widget_root {get; private set;}
        private AndnaPrivateConfigurationServer server;
        private Button but_retrieve_pubk;
        private PublicKey? server_pubk;
        private RadioButton radio_alias;
        private RadioButton radio_myself;
        public Entry txt_alias {get; private set;}
        public Entry txt_name_for_pubk {get; private set;}
        public Label lbl_display_pubk {get; private set;}
        public SpinButton txt_prio {get; private set;}
        public SpinButton txt_weight {get; private set;}
        public SpinButton txt_port {get; private set;}
        public Label lbl_name {get; private set;}
        public Label lbl_servicekey {get; private set;}
        public signal void go_back(AndnaPrivateConfigurationServer rec_old,
                                   AndnaPrivateConfigurationServer rec_new);

        public
        Server
        (AndnaPrivateConfigurationServer server,
         string name,
         string servicekey)
        {
            this.server = server;

            Builder builder = new Builder ();
            builder.add_from_resource ("/org/netsukuku/monitorradar/server.ui");
            builder.connect_signals (this);

            win_server = builder.get_object ("win_server") as Window;
            widget_root = builder.get_object ("widget_root") as Widget;
            lbl_name = builder.get_object ("lbl_name") as Label;
            lbl_name.label = name;
            lbl_servicekey = builder.get_object ("lbl_servicekey") as Label;
            lbl_servicekey.label = servicekey;
            radio_alias = builder.get_object ("radio_alias") as RadioButton;
            radio_myself = builder.get_object ("radio_myself") as RadioButton;
            txt_alias = builder.get_object ("txt_alias") as Entry;
            txt_name_for_pubk = builder.get_object ("txt_name_for_pubk") as Entry;
            but_retrieve_pubk = builder.get_object ("but_retrieve_pubk") as Button;
            lbl_display_pubk = builder.get_object ("lbl_display_pubk") as Label;
            txt_prio = builder.get_object ("txt_prio") as SpinButton;
            txt_weight = builder.get_object ("txt_weight") as SpinButton;
            txt_port = builder.get_object ("txt_port") as SpinButton;
            win_server.destroy.connect(going_back);

            set_ui(server);
        }

        [CCode (instance_pos = -1)]
        public void radio_alias_toggled(RadioButton source)
        {
            set_ui_radio();
        }

        void going_back()
        {
            AndnaPrivateConfigurationServer recnew;
            string? alias = null;
            PublicKey? pubk = null;
            int port_number;
            int priority;
            int weight;
            // read UI
            if (radio_alias.active)
            {
                alias = txt_alias.text;
                pubk = server_pubk;
            }
            port_number = txt_port.get_value_as_int();
            priority = txt_prio.get_value_as_int();
            weight = txt_weight.get_value_as_int();
            // prepare ret value
            recnew = new AndnaPrivateConfigurationServer
                    (alias,
                     pubk,
                     port_number,
                     priority,
                     weight);
            go_back(server, recnew);
        }

        [CCode (instance_pos = -1)]
        public void retrieve_pubk_clicked(Button source)
        {
            string name_for_pubk = txt_name_for_pubk.text;
            set_ui_pubk(retrieve_pubk(name_for_pubk));
        }

        public void set_ui(AndnaPrivateConfigurationServer rec)
        {
            // refresh UI
            if (rec.alias == null)
            {
                radio_myself.active = true;
            }
            else
            {
                radio_alias.active = true;
                txt_alias.text = rec.alias;
            }
            txt_port.@value = rec.port_number;
            txt_prio.@value = rec.priority;
            txt_weight.@value = rec.weight;
            if (rec.pubk == null)
            {
                lbl_display_pubk.label = "NULL";
                server_pubk = rec.pubk;
            }
            else
            {
                lbl_display_pubk.label = @"$(rec.pubk)";
                server_pubk = rec.pubk;
            }
            set_ui_radio();
        }

        public void set_ui_pubk(PublicKey? pk)
        {
            // refresh UI
            if (pk == null)
            {
                lbl_display_pubk.label = "NULL";
                server_pubk = pk;
            }
            else
            {
                lbl_display_pubk.label = @"$(pk)";
                server_pubk = pk;
            }
        }

        public void set_ui_radio()
        {
            txt_alias.sensitive = radio_alias.active;
            txt_name_for_pubk.sensitive = radio_alias.active;
            but_retrieve_pubk.sensitive = radio_alias.active;
        }
    }
}

