/* servers.c generated by valac 0.20.1, the Vala compiler
 * generated from servers.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <netsukuku-rpc-tcpclient.h>
#include <stdlib.h>
#include <string.h>


#define MONITOR_TYPE_LISTSERVERS (monitor_listservers_get_type ())

#define MONITOR_TYPE_SERVERS (monitor_servers_get_type ())
#define MONITOR_SERVERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONITOR_TYPE_SERVERS, MonitorServers))
#define MONITOR_SERVERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MONITOR_TYPE_SERVERS, MonitorServersClass))
#define MONITOR_IS_SERVERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONITOR_TYPE_SERVERS))
#define MONITOR_IS_SERVERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MONITOR_TYPE_SERVERS))
#define MONITOR_SERVERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MONITOR_TYPE_SERVERS, MonitorServersClass))

typedef struct _MonitorServers MonitorServers;
typedef struct _MonitorServersClass MonitorServersClass;
typedef struct _MonitorServersPrivate MonitorServersPrivate;

#define MONITOR_TYPE_SERVER (monitor_server_get_type ())
#define MONITOR_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONITOR_TYPE_SERVER, MonitorServer))
#define MONITOR_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MONITOR_TYPE_SERVER, MonitorServerClass))
#define MONITOR_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONITOR_TYPE_SERVER))
#define MONITOR_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MONITOR_TYPE_SERVER))
#define MONITOR_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MONITOR_TYPE_SERVER, MonitorServerClass))

typedef struct _MonitorServer MonitorServer;
typedef struct _MonitorServerClass MonitorServerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	MONITOR_LISTSERVERS_STR_REPR,
	MONITOR_LISTSERVERS_STR_PUBK,
	MONITOR_LISTSERVERS_INT_PRIO,
	MONITOR_LISTSERVERS_INT_WEIGHT,
	MONITOR_LISTSERVERS_INT_PORT,
	MONITOR_LISTSERVERS_SERVER,
	MONITOR_LISTSERVERS_NUMCOLUMNS
} MonitorLISTSERVERS;

struct _MonitorServers {
	GObject parent_instance;
	MonitorServersPrivate * priv;
};

struct _MonitorServersClass {
	GObjectClass parent_class;
};

struct _MonitorServersPrivate {
	GtkWindow* _win_servers;
	GtkWidget* _widget_root;
	GeeHashMap* services;
	NetsukukuAndnaServiceKey* servicekey;
	GeeArrayList* servers;
	gchar* name;
	GtkListStore* liststore_servers;
	GtkTreeView* tv_servers;
	GtkButton* but_add;
	GtkButton* but_remove;
	GtkButton* but_details;
	GtkEntry* _txt_name;
	GtkEntry* _txt_proto;
	MonitorServer* server;
	NetsukukuAndnaPrivateConfigurationServer* selected_server;
};


static gpointer monitor_servers_parent_class = NULL;

GType monitor_listservers_get_type (void) G_GNUC_CONST;
GType monitor_servers_get_type (void) G_GNUC_CONST;
GType monitor_server_get_type (void) G_GNUC_CONST;
#define MONITOR_SERVERS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MONITOR_TYPE_SERVERS, MonitorServersPrivate))
enum  {
	MONITOR_SERVERS_DUMMY_PROPERTY,
	MONITOR_SERVERS_WIN_SERVERS,
	MONITOR_SERVERS_WIDGET_ROOT,
	MONITOR_SERVERS_TXT_NAME,
	MONITOR_SERVERS_TXT_PROTO
};
MonitorServers* monitor_servers_new (GeeHashMap* services, NetsukukuAndnaServiceKey* servicekey, const gchar* name);
MonitorServers* monitor_servers_construct (GType object_type, GeeHashMap* services, NetsukukuAndnaServiceKey* servicekey, const gchar* name);
static void monitor_servers_set_win_servers (MonitorServers* self, GtkWindow* value);
static void monitor_servers_set_widget_root (MonitorServers* self, GtkWidget* value);
static void monitor_servers_set_txt_name (MonitorServers* self, GtkEntry* value);
static void monitor_servers_set_txt_proto (MonitorServers* self, GtkEntry* value);
GtkEntry* monitor_servers_get_txt_name (MonitorServers* self);
GtkEntry* monitor_servers_get_txt_proto (MonitorServers* self);
GtkWindow* monitor_servers_get_win_servers (MonitorServers* self);
static void monitor_servers_going_back (MonitorServers* self);
static void _monitor_servers_going_back_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void __lambda19_ (MonitorServers* self);
static void monitor_servers_tv_servers_selection_changed (MonitorServers* self);
static void ___lambda19__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
void monitor_servers_refresh (MonitorServers* self);
void monitor_servers_add_server_clicked (GtkButton* source, MonitorServers* self);
static void monitor_servers_add_server (MonitorServers* self);
void monitor_servers_remove_server_clicked (GtkButton* source, MonitorServers* self);
void monitor_servers_details_server_clicked (GtkButton* source, MonitorServers* self);
MonitorServer* monitor_server_new (NetsukukuAndnaPrivateConfigurationServer* server, const gchar* name, const gchar* servicekey);
MonitorServer* monitor_server_construct (GType object_type, NetsukukuAndnaPrivateConfigurationServer* server, const gchar* name, const gchar* servicekey);
GtkWindow* monitor_server_get_win_server (MonitorServer* self);
void monitor_servers_update (MonitorServers* self, NetsukukuAndnaPrivateConfigurationServer* rec_old, NetsukukuAndnaPrivateConfigurationServer* rec_new);
static void _monitor_servers_update_monitor_server_go_back (MonitorServer* _sender, NetsukukuAndnaPrivateConfigurationServer* rec_old, NetsukukuAndnaPrivateConfigurationServer* rec_new, gpointer self);
static gint __lambda20_ (MonitorServers* self, NetsukukuAndnaPrivateConfigurationServer* a, NetsukukuAndnaPrivateConfigurationServer* b);
static gint ___lambda20__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GtkWidget* monitor_servers_get_widget_root (MonitorServers* self);
static void monitor_servers_finalize (GObject* obj);
static void _vala_monitor_servers_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_monitor_servers_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType monitor_listservers_get_type (void) {
	static volatile gsize monitor_listservers_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_listservers_type_id__volatile)) {
		static const GEnumValue values[] = {{MONITOR_LISTSERVERS_STR_REPR, "MONITOR_LISTSERVERS_STR_REPR", "str-repr"}, {MONITOR_LISTSERVERS_STR_PUBK, "MONITOR_LISTSERVERS_STR_PUBK", "str-pubk"}, {MONITOR_LISTSERVERS_INT_PRIO, "MONITOR_LISTSERVERS_INT_PRIO", "int-prio"}, {MONITOR_LISTSERVERS_INT_WEIGHT, "MONITOR_LISTSERVERS_INT_WEIGHT", "int-weight"}, {MONITOR_LISTSERVERS_INT_PORT, "MONITOR_LISTSERVERS_INT_PORT", "int-port"}, {MONITOR_LISTSERVERS_SERVER, "MONITOR_LISTSERVERS_SERVER", "server"}, {MONITOR_LISTSERVERS_NUMCOLUMNS, "MONITOR_LISTSERVERS_NUMCOLUMNS", "numcolumns"}, {0, NULL, NULL}};
		GType monitor_listservers_type_id;
		monitor_listservers_type_id = g_enum_register_static ("MonitorLISTSERVERS", values);
		g_once_init_leave (&monitor_listservers_type_id__volatile, monitor_listservers_type_id);
	}
	return monitor_listservers_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _monitor_servers_going_back_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	monitor_servers_going_back (self);
}


static void __lambda19_ (MonitorServers* self) {
	monitor_servers_tv_servers_selection_changed (self);
}


static void ___lambda19__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda19_ (self);
}


MonitorServers* monitor_servers_construct (GType object_type, GeeHashMap* services, NetsukukuAndnaServiceKey* servicekey, const gchar* name) {
	MonitorServers * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	NetsukukuAndnaServiceKey* _tmp2_;
	NetsukukuAndnaServiceKey* _tmp3_;
	GeeHashMap* _tmp4_;
	NetsukukuAndnaServiceKey* _tmp5_;
	gpointer _tmp6_ = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GtkBuilder* _tmp9_;
	GtkBuilder* builder;
	GObject* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkListStore* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkTreeView* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkButton* _tmp17_;
	GObject* _tmp18_ = NULL;
	GtkButton* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkButton* _tmp21_;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_ = NULL;
	NetsukukuAndnaServiceKey* _tmp24_;
	NetsukukuAndnaServiceKey* _tmp25_;
	NetsukukuAndnaServiceKey* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GtkWindow* _tmp38_;
	GtkTreeView* _tmp39_;
	GtkTreeSelection* _tmp40_ = NULL;
	GtkTreeSelection* _tmp41_;
	GtkTreeSelection* sel_servers;
	GtkTreeSelection* _tmp42_;
	GtkTreeSelection* _tmp43_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (services != NULL, NULL);
	g_return_val_if_fail (servicekey != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (MonitorServers*) g_object_new (object_type, NULL);
	_tmp0_ = services;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->services);
	self->priv->services = _tmp1_;
	_tmp2_ = servicekey;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->servicekey);
	self->priv->servicekey = _tmp3_;
	_tmp4_ = services;
	_tmp5_ = servicekey;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
	_g_object_unref0 (self->priv->servers);
	self->priv->servers = (GeeArrayList*) _tmp6_;
	_tmp7_ = name;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp8_;
	_tmp9_ = gtk_builder_new ();
	builder = _tmp9_;
	gtk_builder_add_from_resource (builder, "/org/netsukuku/monitorradar/servers.ui", &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gtk_builder_connect_signals (builder, self);
	_tmp10_ = gtk_builder_get_object (builder, "win_servers");
	monitor_servers_set_win_servers (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp10_) : NULL);
	_tmp11_ = gtk_builder_get_object (builder, "widget_root");
	monitor_servers_set_widget_root (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp11_) : NULL);
	_tmp12_ = gtk_builder_get_object (builder, "liststore_servers");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GTK_TYPE_LIST_STORE) ? ((GtkListStore*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->liststore_servers);
	self->priv->liststore_servers = _tmp13_;
	_tmp14_ = gtk_builder_get_object (builder, "tv_servers");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GTK_TYPE_TREE_VIEW) ? ((GtkTreeView*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->tv_servers);
	self->priv->tv_servers = _tmp15_;
	_tmp16_ = gtk_builder_get_object (builder, "but_add");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp16_) : NULL);
	_g_object_unref0 (self->priv->but_add);
	self->priv->but_add = _tmp17_;
	_tmp18_ = gtk_builder_get_object (builder, "but_remove");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->but_remove);
	self->priv->but_remove = _tmp19_;
	_tmp20_ = gtk_builder_get_object (builder, "but_details");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp20_) : NULL);
	_g_object_unref0 (self->priv->but_details);
	self->priv->but_details = _tmp21_;
	_tmp22_ = gtk_builder_get_object (builder, "txt_name");
	monitor_servers_set_txt_name (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp22_) : NULL);
	_tmp23_ = gtk_builder_get_object (builder, "txt_proto");
	monitor_servers_set_txt_proto (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp23_) : NULL);
	_tmp24_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp25_ = _tmp24_;
	_tmp26_ = servicekey;
	_tmp27_ = netsukuku_andna_service_key_equal_func (_tmp25_, _tmp26_);
	if (!_tmp27_) {
		GtkEntry* _tmp28_;
		NetsukukuAndnaServiceKey* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		GtkEntry* _tmp32_;
		NetsukukuAndnaServiceKey* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		GtkEntry* _tmp36_;
		GtkEntry* _tmp37_;
		_tmp28_ = self->priv->_txt_name;
		_tmp29_ = servicekey;
		_tmp30_ = netsukuku_andna_service_key_get_name (_tmp29_);
		_tmp31_ = _tmp30_;
		gtk_entry_set_text (_tmp28_, _tmp31_);
		_tmp32_ = self->priv->_txt_proto;
		_tmp33_ = servicekey;
		_tmp34_ = netsukuku_andna_service_key_get_proto (_tmp33_);
		_tmp35_ = _tmp34_;
		gtk_entry_set_text (_tmp32_, _tmp35_);
		_tmp36_ = self->priv->_txt_name;
		g_object_set ((GtkWidget*) _tmp36_, "can-focus", TRUE, NULL);
		_tmp37_ = self->priv->_txt_proto;
		g_object_set ((GtkWidget*) _tmp37_, "can-focus", TRUE, NULL);
	}
	_tmp38_ = self->priv->_win_servers;
	g_signal_connect_object ((GtkWidget*) _tmp38_, "destroy", (GCallback) _monitor_servers_going_back_gtk_widget_destroy, self, 0);
	_tmp39_ = self->priv->tv_servers;
	_tmp40_ = gtk_tree_view_get_selection (_tmp39_);
	_tmp41_ = _g_object_ref0 (_tmp40_);
	sel_servers = _tmp41_;
	_tmp42_ = sel_servers;
	gtk_tree_selection_set_mode (_tmp42_, GTK_SELECTION_SINGLE);
	_tmp43_ = sel_servers;
	g_signal_connect_object (_tmp43_, "changed", (GCallback) ___lambda19__gtk_tree_selection_changed, self, 0);
	monitor_servers_refresh (self);
	_g_object_unref0 (sel_servers);
	_g_object_unref0 (builder);
	return self;
}


MonitorServers* monitor_servers_new (GeeHashMap* services, NetsukukuAndnaServiceKey* servicekey, const gchar* name) {
	return monitor_servers_construct (MONITOR_TYPE_SERVERS, services, servicekey, name);
}


static void monitor_servers_going_back (MonitorServers* self) {
	NetsukukuAndnaServiceKey* _tmp0_;
	NetsukukuAndnaServiceKey* _tmp1_;
	NetsukukuAndnaServiceKey* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->servicekey;
	_tmp3_ = netsukuku_andna_service_key_equal_func (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		gboolean _tmp4_ = FALSE;
		GtkEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		NetsukukuAndnaServiceKey* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp17_;
		_tmp5_ = self->priv->_txt_name;
		_tmp6_ = gtk_entry_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->servicekey;
		_tmp9_ = netsukuku_andna_service_key_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		if (g_strcmp0 (_tmp7_, _tmp10_) != 0) {
			_tmp4_ = TRUE;
		} else {
			GtkEntry* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			NetsukukuAndnaServiceKey* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp11_ = self->priv->_txt_proto;
			_tmp12_ = gtk_entry_get_text (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->servicekey;
			_tmp15_ = netsukuku_andna_service_key_get_proto (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp4_ = g_strcmp0 (_tmp13_, _tmp16_) != 0;
		}
		_tmp17_ = _tmp4_;
		if (_tmp17_) {
			GtkEntry* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			GtkEntry* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			NetsukukuAndnaServiceKey* _tmp24_;
			NetsukukuAndnaServiceKey* new_servicekey;
			GeeHashMap* _tmp25_;
			NetsukukuAndnaServiceKey* _tmp26_;
			GeeArrayList* _tmp27_;
			GeeHashMap* _tmp28_;
			NetsukukuAndnaServiceKey* _tmp29_;
			_tmp18_ = self->priv->_txt_name;
			_tmp19_ = gtk_entry_get_text (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = self->priv->_txt_proto;
			_tmp22_ = gtk_entry_get_text (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = netsukuku_andna_service_key_new (_tmp20_, _tmp23_);
			new_servicekey = _tmp24_;
			_tmp25_ = self->priv->services;
			_tmp26_ = new_servicekey;
			_tmp27_ = self->priv->servers;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp26_, _tmp27_);
			_tmp28_ = self->priv->services;
			_tmp29_ = self->priv->servicekey;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp28_, _tmp29_, NULL);
			_g_object_unref0 (new_servicekey);
		}
	}
	g_signal_emit_by_name (self, "go-back");
}


void monitor_servers_add_server_clicked (GtkButton* source, MonitorServers* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	monitor_servers_add_server (self);
}


static void monitor_servers_add_server (MonitorServers* self) {
	GeeArrayList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp1_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->servers;
	_tmp1_ = netsukuku_andna_private_configuration_server_new (NULL, NULL, 0, 1, 1);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	monitor_servers_refresh (self);
}


void monitor_servers_remove_server_clicked (GtkButton* source, MonitorServers* self) {
	GeeArrayList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->servers;
	_tmp1_ = self->priv->selected_server;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	monitor_servers_refresh (self);
}


static void _monitor_servers_update_monitor_server_go_back (MonitorServer* _sender, NetsukukuAndnaPrivateConfigurationServer* rec_old, NetsukukuAndnaPrivateConfigurationServer* rec_new, gpointer self) {
	monitor_servers_update (self, rec_old, rec_new);
}


void monitor_servers_details_server_clicked (GtkButton* source, MonitorServers* self) {
	NetsukukuAndnaPrivateConfigurationServer* _tmp0_;
	const gchar* _tmp1_;
	NetsukukuAndnaServiceKey* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	MonitorServer* _tmp5_;
	MonitorServer* _tmp6_;
	GtkWindow* _tmp7_;
	GtkWindow* _tmp8_;
	GtkWindow* _tmp9_;
	GtkWindow* w;
	MonitorServer* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->selected_server;
	_tmp1_ = self->priv->name;
	_tmp2_ = self->priv->servicekey;
	_tmp3_ = netsukuku_andna_service_key_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = monitor_server_new (_tmp0_, _tmp1_, _tmp4_);
	_g_object_unref0 (self->priv->server);
	self->priv->server = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = self->priv->server;
	_tmp7_ = monitor_server_get_win_server (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	w = _tmp9_;
	gtk_window_set_title (w, "server");
	gtk_widget_show_all ((GtkWidget*) w);
	gtk_window_set_position (w, GTK_WIN_POS_CENTER_ON_PARENT);
	_tmp10_ = self->priv->server;
	g_signal_connect_object (_tmp10_, "go-back", (GCallback) _monitor_servers_update_monitor_server_go_back, self, 0);
	_g_object_unref0 (w);
}


void monitor_servers_update (MonitorServers* self, NetsukukuAndnaPrivateConfigurationServer* rec_old, NetsukukuAndnaPrivateConfigurationServer* rec_new) {
	GeeArrayList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp1_;
	GeeArrayList* _tmp2_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rec_old != NULL);
	g_return_if_fail (rec_new != NULL);
	_tmp0_ = self->priv->servers;
	_tmp1_ = rec_old;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = self->priv->servers;
	_tmp3_ = rec_new;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
	monitor_servers_refresh (self);
}


static gint __lambda20_ (MonitorServers* self, NetsukukuAndnaPrivateConfigurationServer* a, NetsukukuAndnaPrivateConfigurationServer* b) {
	gint result = 0;
	NetsukukuAndnaPrivateConfigurationServer* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = netsukuku_andna_private_configuration_server_get_priority (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = b;
	_tmp4_ = netsukuku_andna_private_configuration_server_get_priority (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ != _tmp5_) {
		NetsukukuAndnaPrivateConfigurationServer* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		NetsukukuAndnaPrivateConfigurationServer* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp6_ = a;
		_tmp7_ = netsukuku_andna_private_configuration_server_get_priority (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = b;
		_tmp10_ = netsukuku_andna_private_configuration_server_get_priority (_tmp9_);
		_tmp11_ = _tmp10_;
		result = _tmp8_ - _tmp11_;
		return result;
	}
	_tmp12_ = a;
	_tmp13_ = netsukuku_andna_private_configuration_server_get_weight (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = b;
	_tmp16_ = netsukuku_andna_private_configuration_server_get_weight (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp14_ != _tmp17_) {
		NetsukukuAndnaPrivateConfigurationServer* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		NetsukukuAndnaPrivateConfigurationServer* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp18_ = b;
		_tmp19_ = netsukuku_andna_private_configuration_server_get_weight (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = a;
		_tmp22_ = netsukuku_andna_private_configuration_server_get_weight (_tmp21_);
		_tmp23_ = _tmp22_;
		result = _tmp20_ - _tmp23_;
		return result;
	}
	_tmp24_ = a;
	_tmp25_ = netsukuku_andna_private_configuration_server_get_port_number (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = b;
	_tmp28_ = netsukuku_andna_private_configuration_server_get_port_number (_tmp27_);
	_tmp29_ = _tmp28_;
	result = _tmp26_ - _tmp29_;
	return result;
}


static gint ___lambda20__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda20_ (self, a, b);
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void monitor_servers_refresh (MonitorServers* self) {
	GtkListStore* _tmp0_;
	GtkTreeIter iter = {0};
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->liststore_servers;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->servers;
	gee_list_sort ((GeeList*) _tmp1_, ___lambda20__gcompare_data_func, g_object_ref (self), g_object_unref);
	{
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _server_list;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _server_size;
		gint _server_index;
		_tmp2_ = self->priv->servers;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_server_list = _tmp3_;
		_tmp4_ = _server_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_server_size = _tmp6_;
		_server_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			NetsukukuAndnaPrivateConfigurationServer* server;
			GtkListStore* _tmp13_;
			GtkTreeIter _tmp14_ = {0};
			gchar* _tmp15_;
			gchar* alias;
			gchar* _tmp16_;
			gchar* pubk;
			NetsukukuAndnaPrivateConfigurationServer* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			GtkListStore* _tmp28_;
			GtkTreeIter _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_ = NULL;
			GtkListStore* _tmp32_;
			GtkTreeIter _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_ = NULL;
			GtkListStore* _tmp36_;
			GtkTreeIter _tmp37_;
			NetsukukuAndnaPrivateConfigurationServer* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			GtkListStore* _tmp41_;
			GtkTreeIter _tmp42_;
			NetsukukuAndnaPrivateConfigurationServer* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			GtkListStore* _tmp46_;
			GtkTreeIter _tmp47_;
			NetsukukuAndnaPrivateConfigurationServer* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			GtkListStore* _tmp51_;
			GtkTreeIter _tmp52_;
			NetsukukuAndnaPrivateConfigurationServer* _tmp53_;
			_tmp7_ = _server_index;
			_server_index = _tmp7_ + 1;
			_tmp8_ = _server_index;
			_tmp9_ = _server_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _server_list;
			_tmp11_ = _server_index;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
			server = (NetsukukuAndnaPrivateConfigurationServer*) _tmp12_;
			_tmp13_ = self->priv->liststore_servers;
			gtk_list_store_append (_tmp13_, &_tmp14_);
			iter = _tmp14_;
			_tmp15_ = g_strdup ("<myself>");
			alias = _tmp15_;
			_tmp16_ = g_strdup ("null");
			pubk = _tmp16_;
			_tmp17_ = server;
			_tmp18_ = netsukuku_andna_private_configuration_server_get_alias (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_ != NULL) {
				NetsukukuAndnaPrivateConfigurationServer* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				NetsukukuAndnaPrivateConfigurationServer* _tmp24_;
				NetsukukuPublicKey* _tmp25_;
				NetsukukuPublicKey* _tmp26_;
				gchar* _tmp27_ = NULL;
				_tmp20_ = server;
				_tmp21_ = netsukuku_andna_private_configuration_server_get_alias (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup (_tmp22_);
				_g_free0 (alias);
				alias = _tmp23_;
				_tmp24_ = server;
				_tmp25_ = netsukuku_andna_private_configuration_server_get_pubk (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = netsukuku_public_key_to_string (_tmp26_);
				_g_free0 (pubk);
				pubk = _tmp27_;
			}
			_tmp28_ = self->priv->liststore_servers;
			_tmp29_ = iter;
			_tmp30_ = alias;
			_tmp31_ = string_to_string (_tmp30_);
			gtk_list_store_set (_tmp28_, &_tmp29_, MONITOR_LISTSERVERS_STR_REPR, _tmp31_, -1);
			_tmp32_ = self->priv->liststore_servers;
			_tmp33_ = iter;
			_tmp34_ = pubk;
			_tmp35_ = string_to_string (_tmp34_);
			gtk_list_store_set (_tmp32_, &_tmp33_, MONITOR_LISTSERVERS_STR_PUBK, _tmp35_, -1);
			_tmp36_ = self->priv->liststore_servers;
			_tmp37_ = iter;
			_tmp38_ = server;
			_tmp39_ = netsukuku_andna_private_configuration_server_get_port_number (_tmp38_);
			_tmp40_ = _tmp39_;
			gtk_list_store_set (_tmp36_, &_tmp37_, MONITOR_LISTSERVERS_INT_PORT, _tmp40_, -1);
			_tmp41_ = self->priv->liststore_servers;
			_tmp42_ = iter;
			_tmp43_ = server;
			_tmp44_ = netsukuku_andna_private_configuration_server_get_priority (_tmp43_);
			_tmp45_ = _tmp44_;
			gtk_list_store_set (_tmp41_, &_tmp42_, MONITOR_LISTSERVERS_INT_PRIO, _tmp45_, -1);
			_tmp46_ = self->priv->liststore_servers;
			_tmp47_ = iter;
			_tmp48_ = server;
			_tmp49_ = netsukuku_andna_private_configuration_server_get_weight (_tmp48_);
			_tmp50_ = _tmp49_;
			gtk_list_store_set (_tmp46_, &_tmp47_, MONITOR_LISTSERVERS_INT_WEIGHT, _tmp50_, -1);
			_tmp51_ = self->priv->liststore_servers;
			_tmp52_ = iter;
			_tmp53_ = server;
			gtk_list_store_set (_tmp51_, &_tmp52_, MONITOR_LISTSERVERS_SERVER, _tmp53_, -1);
			_g_free0 (pubk);
			_g_free0 (alias);
			_g_object_unref0 (server);
		}
		_g_object_unref0 (_server_list);
	}
}


static void monitor_servers_tv_servers_selection_changed (MonitorServers* self) {
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreePath* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tv_servers;
	gtk_tree_view_get_cursor (_tmp0_, &_tmp1_, &_tmp2_);
	_gtk_tree_path_free0 (path);
	path = _tmp1_;
	column = _tmp2_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		GtkListStore* _tmp4_;
		GtkTreePath* _tmp5_;
		GtkTreeIter _tmp6_ = {0};
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->liststore_servers;
		_tmp5_ = path;
		_tmp7_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp4_, &_tmp6_, _tmp5_);
		iter = _tmp6_;
		if (_tmp7_) {
			GtkListStore* _tmp8_;
			GtkTreeIter _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			GtkButton* _tmp15_;
			_tmp8_ = self->priv->liststore_servers;
			_tmp9_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, MONITOR_LISTSERVERS_SERVER, &self->priv->selected_server, -1);
			_tmp10_ = self->priv->servers;
			_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ > 1) {
				GtkButton* _tmp13_;
				_tmp13_ = self->priv->but_remove;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
			} else {
				GtkButton* _tmp14_;
				_tmp14_ = self->priv->but_remove;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
			}
			_tmp15_ = self->priv->but_details;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, TRUE);
		} else {
			GtkButton* _tmp16_;
			GtkButton* _tmp17_;
			_g_object_unref0 (self->priv->selected_server);
			self->priv->selected_server = NULL;
			_tmp16_ = self->priv->but_remove;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, FALSE);
			_tmp17_ = self->priv->but_details;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, FALSE);
		}
	} else {
		GtkButton* _tmp18_;
		GtkButton* _tmp19_;
		_g_object_unref0 (self->priv->selected_server);
		self->priv->selected_server = NULL;
		_tmp18_ = self->priv->but_remove;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, FALSE);
		_tmp19_ = self->priv->but_details;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
	}
	_gtk_tree_path_free0 (path);
}


GtkWindow* monitor_servers_get_win_servers (MonitorServers* self) {
	GtkWindow* result;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_win_servers;
	result = _tmp0_;
	return result;
}


static void monitor_servers_set_win_servers (MonitorServers* self, GtkWindow* value) {
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_win_servers);
	self->priv->_win_servers = _tmp1_;
	g_object_notify ((GObject *) self, "win-servers");
}


GtkWidget* monitor_servers_get_widget_root (MonitorServers* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget_root;
	result = _tmp0_;
	return result;
}


static void monitor_servers_set_widget_root (MonitorServers* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_widget_root);
	self->priv->_widget_root = _tmp1_;
	g_object_notify ((GObject *) self, "widget-root");
}


GtkEntry* monitor_servers_get_txt_name (MonitorServers* self) {
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_txt_name;
	result = _tmp0_;
	return result;
}


static void monitor_servers_set_txt_name (MonitorServers* self, GtkEntry* value) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_txt_name);
	self->priv->_txt_name = _tmp1_;
	g_object_notify ((GObject *) self, "txt-name");
}


GtkEntry* monitor_servers_get_txt_proto (MonitorServers* self) {
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_txt_proto;
	result = _tmp0_;
	return result;
}


static void monitor_servers_set_txt_proto (MonitorServers* self, GtkEntry* value) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_txt_proto);
	self->priv->_txt_proto = _tmp1_;
	g_object_notify ((GObject *) self, "txt-proto");
}


static void monitor_servers_class_init (MonitorServersClass * klass) {
	monitor_servers_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MonitorServersPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_monitor_servers_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_monitor_servers_set_property;
	G_OBJECT_CLASS (klass)->finalize = monitor_servers_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MONITOR_SERVERS_WIN_SERVERS, g_param_spec_object ("win-servers", "win-servers", "win-servers", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MONITOR_SERVERS_WIDGET_ROOT, g_param_spec_object ("widget-root", "widget-root", "widget-root", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MONITOR_SERVERS_TXT_NAME, g_param_spec_object ("txt-name", "txt-name", "txt-name", GTK_TYPE_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MONITOR_SERVERS_TXT_PROTO, g_param_spec_object ("txt-proto", "txt-proto", "txt-proto", GTK_TYPE_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("go_back", MONITOR_TYPE_SERVERS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void monitor_servers_instance_init (MonitorServers * self) {
	self->priv = MONITOR_SERVERS_GET_PRIVATE (self);
}


static void monitor_servers_finalize (GObject* obj) {
	MonitorServers * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MONITOR_TYPE_SERVERS, MonitorServers);
	_g_object_unref0 (self->priv->_win_servers);
	_g_object_unref0 (self->priv->_widget_root);
	_g_object_unref0 (self->priv->services);
	_g_object_unref0 (self->priv->servicekey);
	_g_object_unref0 (self->priv->servers);
	_g_free0 (self->priv->name);
	_g_object_unref0 (self->priv->liststore_servers);
	_g_object_unref0 (self->priv->tv_servers);
	_g_object_unref0 (self->priv->but_add);
	_g_object_unref0 (self->priv->but_remove);
	_g_object_unref0 (self->priv->but_details);
	_g_object_unref0 (self->priv->_txt_name);
	_g_object_unref0 (self->priv->_txt_proto);
	_g_object_unref0 (self->priv->server);
	_g_object_unref0 (self->priv->selected_server);
	G_OBJECT_CLASS (monitor_servers_parent_class)->finalize (obj);
}


GType monitor_servers_get_type (void) {
	static volatile gsize monitor_servers_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_servers_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorServersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_servers_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MonitorServers), 0, (GInstanceInitFunc) monitor_servers_instance_init, NULL };
		GType monitor_servers_type_id;
		monitor_servers_type_id = g_type_register_static (G_TYPE_OBJECT, "MonitorServers", &g_define_type_info, 0);
		g_once_init_leave (&monitor_servers_type_id__volatile, monitor_servers_type_id);
	}
	return monitor_servers_type_id__volatile;
}


static void _vala_monitor_servers_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MonitorServers * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MONITOR_TYPE_SERVERS, MonitorServers);
	switch (property_id) {
		case MONITOR_SERVERS_WIN_SERVERS:
		g_value_set_object (value, monitor_servers_get_win_servers (self));
		break;
		case MONITOR_SERVERS_WIDGET_ROOT:
		g_value_set_object (value, monitor_servers_get_widget_root (self));
		break;
		case MONITOR_SERVERS_TXT_NAME:
		g_value_set_object (value, monitor_servers_get_txt_name (self));
		break;
		case MONITOR_SERVERS_TXT_PROTO:
		g_value_set_object (value, monitor_servers_get_txt_proto (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_monitor_servers_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MonitorServers * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MONITOR_TYPE_SERVERS, MonitorServers);
	switch (property_id) {
		case MONITOR_SERVERS_WIN_SERVERS:
		monitor_servers_set_win_servers (self, g_value_get_object (value));
		break;
		case MONITOR_SERVERS_WIDGET_ROOT:
		monitor_servers_set_widget_root (self, g_value_get_object (value));
		break;
		case MONITOR_SERVERS_TXT_NAME:
		monitor_servers_set_txt_name (self, g_value_get_object (value));
		break;
		case MONITOR_SERVERS_TXT_PROTO:
		monitor_servers_set_txt_proto (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



