/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Gee;
using zcd;
using Tasklets;
using Netsukuku;

namespace Monitor
{
    // position of fields in treemodel
    enum LISTSERVICES {
        STR_REPR,
        SERVICE_KEY,
        NUMCOLUMNS
    }

    public class Services : Object
    {
        public Window win_services {get; private set;}
        public Widget widget_root {get; private set;}
        private AndnaPrivateConfiguration root;
        private string name;
        private ListStore liststore_services;
        private TreeView tv_services;
        private Button but_add;
        private Button but_remove;
        private Button but_details;
        public Entry txt_name {get; private set;}
        public signal void go_back();

        public
        Services
        (AndnaPrivateConfiguration root)
        {
            this.root = root;
            this.name = root.domain;

            Builder builder = new Builder ();
            builder.add_from_resource ("/org/netsukuku/monitorradar/services.ui");
            builder.connect_signals (this);

            win_services = builder.get_object ("win_services") as Window;
            widget_root = builder.get_object ("widget_root") as Widget;
            liststore_services = builder.get_object ("liststore_services") as ListStore;
            tv_services = builder.get_object ("tv_services") as TreeView;
            but_add = builder.get_object ("but_add") as Button;
            but_remove = builder.get_object ("but_remove") as Button;
            but_details = builder.get_object ("but_details") as Button;
            txt_name = builder.get_object ("txt_name") as Entry;
            txt_name.text = name;
            win_services.destroy.connect(going_back);

            TreeSelection sel_services = tv_services.get_selection();
            sel_services.set_mode(SelectionMode.SINGLE);
            sel_services.changed.connect(() => {tv_services_selection_changed();});

            refresh();
        }

        void going_back()
        {
            root.domain = txt_name.text;
            go_back();
        }

        [CCode (instance_pos = -1)]
        public void add_service_clicked(Button source)
        {
            add_service();
        }

        void add_service()
        {
            // adds a service
            string serv_name = "undefined";
            string serv_proto = "undefined";
            AndnaServiceKey sk = new AndnaServiceKey(serv_name, serv_proto);
            if (root.services.has_key(sk)) return;
            root.services[sk] = AndnaPrivateConfigurationServer.make_null_list();
            refresh();
        }

        [CCode (instance_pos = -1)]
        public void remove_service_clicked(Button source)
        {
            root.services.unset(selected_key);
            refresh();
        }

        private Servers servers;
        [CCode (instance_pos = -1)]
        public void details_service_clicked(Button source)
        {
            servers = new Servers(root.services, selected_key, txt_name.text);
            Window w = servers.win_servers;
            w.title = "servers";
            w.show_all();
            // TODO uncomment: modal is buggy in ubuntu right now
            // w.modal = true;
            // w.set_transient_for(win_services);
            w.set_position(WindowPosition.CENTER_ON_PARENT);
            servers.go_back.connect(update);
        }

        public void update()
        {
            // all has been done
            refresh();
        }

        public void refresh()
        {
            // refresh UI
            liststore_services.clear();
            TreeIter iter;
            foreach (AndnaServiceKey sk in root.services.keys)
            {
                liststore_services.append(out iter);
                liststore_services.@set(iter,
                        LISTSERVICES.STR_REPR, @"$(sk)");
                liststore_services.@set(iter,
                        LISTSERVICES.SERVICE_KEY, sk);
            }
        }

        private AndnaServiceKey? selected_key;
        void tv_services_selection_changed()
        {
            TreePath? path;
            unowned TreeViewColumn? column;
            TreeIter iter;
            tv_services.get_cursor(out path, out column);
            if (path != null)
            {
                if (liststore_services.get_iter(out iter, path))
                {
                    liststore_services.@get(iter,
                            LISTSERVICES.SERVICE_KEY,
                            out selected_key);
                    if (! AndnaServiceKey.equal_func(selected_key, AndnaServiceKey.NULL_SERV_KEY))
                    {
                        but_remove.sensitive = true;
                    }
                    else
                    {
                        but_remove.sensitive = false;
                    }
                    but_details.sensitive = true;
                }
                else
                {
                    selected_key = null;
                    but_remove.sensitive = false;
                    but_details.sensitive = false;
                }
            }
            else
            {
                selected_key = null;
                but_remove.sensitive = false;
                but_details.sensitive = false;
            }
        }
    }
}

