/* channel.c generated by valac 0.20.1, the Vala compiler
 * generated from channel.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TASKLETS_TYPE_CHANNEL (tasklets_channel_get_type ())
#define TASKLETS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_CHANNEL, TaskletsChannel))
#define TASKLETS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_CHANNEL, TaskletsChannelClass))
#define TASKLETS_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_CHANNEL))
#define TASKLETS_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_CHANNEL))
#define TASKLETS_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_CHANNEL, TaskletsChannelClass))

typedef struct _TaskletsChannel TaskletsChannel;
typedef struct _TaskletsChannelClass TaskletsChannelClass;
typedef struct _TaskletsChannelPrivate TaskletsChannelPrivate;

#define TASKLETS_CHANNEL_TYPE_MESSAGE (tasklets_channel_message_get_type ())
#define TASKLETS_CHANNEL_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_CHANNEL_TYPE_MESSAGE, TaskletsChannelMessage))
#define TASKLETS_CHANNEL_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_CHANNEL_TYPE_MESSAGE, TaskletsChannelMessageClass))
#define TASKLETS_CHANNEL_IS_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_CHANNEL_TYPE_MESSAGE))
#define TASKLETS_CHANNEL_IS_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_CHANNEL_TYPE_MESSAGE))
#define TASKLETS_CHANNEL_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_CHANNEL_TYPE_MESSAGE, TaskletsChannelMessageClass))

typedef struct _TaskletsChannelMessage TaskletsChannelMessage;
typedef struct _TaskletsChannelMessageClass TaskletsChannelMessageClass;

#define TASKLETS_TYPE_TASKLET (tasklets_tasklet_get_type ())
#define TASKLETS_TASKLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_TASKLET, TaskletsTasklet))
#define TASKLETS_TASKLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_TASKLET, TaskletsTaskletClass))
#define TASKLETS_IS_TASKLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_TASKLET))
#define TASKLETS_IS_TASKLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_TASKLET))
#define TASKLETS_TASKLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_TASKLET, TaskletsTaskletClass))

typedef struct _TaskletsTasklet TaskletsTasklet;
typedef struct _TaskletsTaskletClass TaskletsTaskletClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TaskletsChannelMessagePrivate TaskletsChannelMessagePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TASKLETS_TYPE_TIMER (tasklets_timer_get_type ())
#define TASKLETS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_TIMER, TaskletsTimer))
#define TASKLETS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_TIMER, TaskletsTimerClass))
#define TASKLETS_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_TIMER))
#define TASKLETS_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_TIMER))
#define TASKLETS_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_TIMER, TaskletsTimerClass))

typedef struct _TaskletsTimer TaskletsTimer;
typedef struct _TaskletsTimerClass TaskletsTimerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	TASKLETS_CHANNEL_ERROR_TIMEOUT_EXPIRED,
	TASKLETS_CHANNEL_ERROR_GENERIC
} TaskletsChannelError;
#define TASKLETS_CHANNEL_ERROR tasklets_channel_error_quark ()
struct _TaskletsChannel {
	GObject parent_instance;
	TaskletsChannelPrivate * priv;
};

struct _TaskletsChannelClass {
	GObjectClass parent_class;
};

struct _TaskletsChannelPrivate {
	GeeLinkedList* pendingMessages;
	GeeArrayList* taskletsWaitingForReceipt;
	GeeArrayList* receivingTasklets;
};

struct _TaskletsChannelMessage {
	GObject parent_instance;
	TaskletsChannelMessagePrivate * priv;
	GValue wrapped;
	TaskletsTasklet* confirmReceipt;
};

struct _TaskletsChannelMessageClass {
	GObjectClass parent_class;
};


static gpointer tasklets_channel_parent_class = NULL;
static GeeHashMap* tasklets_channel__channels;
static GeeHashMap* tasklets_channel__channels = NULL;
static gpointer tasklets_channel_message_parent_class = NULL;

GQuark tasklets_channel_error_quark (void);
GType tasklets_channel_get_type (void) G_GNUC_CONST;
static GType tasklets_channel_message_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tasklets_tasklet_get_type (void) G_GNUC_CONST;
#define TASKLETS_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TASKLETS_TYPE_CHANNEL, TaskletsChannelPrivate))
enum  {
	TASKLETS_CHANNEL_DUMMY_PROPERTY,
	TASKLETS_CHANNEL_BALANCE
};
TaskletsChannel* tasklets_channel_new (const gchar* name);
TaskletsChannel* tasklets_channel_construct (GType object_type, const gchar* name);
static GeeHashMap* tasklets_channel_get_channels (void);
gboolean tasklets_tasklet_equal_func (TaskletsTasklet* a, TaskletsTasklet* b);
TaskletsChannel* tasklets_channel_find (const gchar* name);
void tasklets_channel_send_async (TaskletsChannel* self, GValue* v);
static TaskletsChannelMessage* tasklets_channel_message_new (void);
static TaskletsChannelMessage* tasklets_channel_message_construct (GType object_type);
void tasklets_channel_send (TaskletsChannel* self, GValue* v);
TaskletsTasklet* tasklets_tasklet_self (void);
void tasklets_tasklet_nap (glong sec, glong usec);
void tasklets_channel_recv (TaskletsChannel* self, GValue* result);
static void tasklets_channel_recv_implementation (TaskletsChannel* self, gint64* timeout_msec, GValue* result, GError** error);
void tasklets_channel_recv_with_timeout (TaskletsChannel* self, gint64 timeout_msec, GValue* result, GError** error);
GType tasklets_timer_get_type (void) G_GNUC_CONST;
TaskletsTimer* tasklets_timer_new (gint64 msec_ttl);
TaskletsTimer* tasklets_timer_construct (GType object_type, gint64 msec_ttl);
gboolean tasklets_tasklet_is_dead (TaskletsTasklet* self);
gboolean tasklets_timer_is_expired (TaskletsTimer* self);
gint tasklets_channel_get_balance (TaskletsChannel* self);
enum  {
	TASKLETS_CHANNEL_MESSAGE_DUMMY_PROPERTY
};
static void tasklets_channel_message_finalize (GObject* obj);
static void tasklets_channel_finalize (GObject* obj);
static void _vala_tasklets_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


GQuark tasklets_channel_error_quark (void) {
	return g_quark_from_static_string ("tasklets_channel_error-quark");
}


TaskletsChannel* tasklets_channel_construct (GType object_type, const gchar* name) {
	TaskletsChannel * self = NULL;
	const gchar* _tmp0_;
	GeeLinkedList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
#line 63 "/home/luca/repo/wip/tasklet/channel.vala"
	self = (TaskletsChannel*) g_object_new (object_type, NULL);
#line 65 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp0_ = name;
#line 65 "/home/luca/repo/wip/tasklet/channel.vala"
	if (_tmp0_ != NULL) {
#line 166 "channel.c"
		GeeHashMap* _tmp1_;
		GeeHashMap* _tmp2_;
		const gchar* _tmp3_;
#line 65 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp1_ = tasklets_channel_get_channels ();
#line 65 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp2_ = _tmp1_;
#line 65 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp3_ = name;
#line 65 "/home/luca/repo/wip/tasklet/channel.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp3_, self);
#line 178 "channel.c"
	}
#line 66 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp4_ = gee_linked_list_new (TASKLETS_CHANNEL_TYPE_MESSAGE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 66 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (self->priv->pendingMessages);
#line 66 "/home/luca/repo/wip/tasklet/channel.vala"
	self->priv->pendingMessages = _tmp4_;
#line 67 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp5_ = gee_array_list_new (TASKLETS_TYPE_TASKLET, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) tasklets_tasklet_equal_func, NULL, NULL);
#line 67 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (self->priv->taskletsWaitingForReceipt);
#line 67 "/home/luca/repo/wip/tasklet/channel.vala"
	self->priv->taskletsWaitingForReceipt = _tmp5_;
#line 68 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp6_ = gee_array_list_new (TASKLETS_TYPE_TASKLET, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) tasklets_tasklet_equal_func, NULL, NULL);
#line 68 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (self->priv->receivingTasklets);
#line 68 "/home/luca/repo/wip/tasklet/channel.vala"
	self->priv->receivingTasklets = _tmp6_;
#line 63 "/home/luca/repo/wip/tasklet/channel.vala"
	return self;
#line 200 "channel.c"
}


TaskletsChannel* tasklets_channel_new (const gchar* name) {
#line 63 "/home/luca/repo/wip/tasklet/channel.vala"
	return tasklets_channel_construct (TASKLETS_TYPE_CHANNEL, name);
#line 207 "channel.c"
}


TaskletsChannel* tasklets_channel_find (const gchar* name) {
	TaskletsChannel* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
#line 71 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp0_ = tasklets_channel_get_channels ();
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp1_ = _tmp0_;
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp2_ = name;
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
	if (_tmp3_) {
#line 229 "channel.c"
		GeeHashMap* _tmp4_;
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_ = NULL;
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp4_ = tasklets_channel_get_channels ();
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp5_ = _tmp4_;
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp6_ = name;
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
		result = (TaskletsChannel*) _tmp7_;
#line 73 "/home/luca/repo/wip/tasklet/channel.vala"
		return result;
#line 246 "channel.c"
	}
#line 74 "/home/luca/repo/wip/tasklet/channel.vala"
	result = NULL;
#line 74 "/home/luca/repo/wip/tasklet/channel.vala"
	return result;
#line 252 "channel.c"
}


void tasklets_channel_send_async (TaskletsChannel* self, GValue* v) {
	TaskletsChannelMessage* _tmp0_;
	TaskletsChannelMessage* msg;
	GValue _tmp1_;
	GValue _tmp2_ = {0};
	GeeLinkedList* _tmp3_;
#line 86 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_if_fail (v != NULL);
#line 88 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp0_ = tasklets_channel_message_new ();
#line 88 "/home/luca/repo/wip/tasklet/channel.vala"
	msg = _tmp0_;
#line 89 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp1_ = *v;
#line 89 "/home/luca/repo/wip/tasklet/channel.vala"
	if (G_IS_VALUE (&_tmp1_)) {
#line 89 "/home/luca/repo/wip/tasklet/channel.vala"
		g_value_init (&_tmp2_, G_VALUE_TYPE (&_tmp1_));
#line 89 "/home/luca/repo/wip/tasklet/channel.vala"
		g_value_copy (&_tmp1_, &_tmp2_);
#line 278 "channel.c"
	} else {
#line 89 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp2_ = _tmp1_;
#line 282 "channel.c"
	}
#line 89 "/home/luca/repo/wip/tasklet/channel.vala"
	G_IS_VALUE (&msg->wrapped) ? (g_value_unset (&msg->wrapped), NULL) : NULL;
#line 89 "/home/luca/repo/wip/tasklet/channel.vala"
	msg->wrapped = _tmp2_;
#line 90 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp3_ = self->priv->pendingMessages;
#line 90 "/home/luca/repo/wip/tasklet/channel.vala"
	gee_queue_offer ((GeeQueue*) _tmp3_, msg);
#line 86 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (msg);
#line 294 "channel.c"
}


void tasklets_channel_send (TaskletsChannel* self, GValue* v) {
	TaskletsChannelMessage* _tmp0_;
	TaskletsChannelMessage* msg;
	TaskletsChannelMessage* _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	TaskletsChannelMessage* _tmp4_;
	TaskletsTasklet* _tmp5_ = NULL;
	GeeArrayList* _tmp6_;
	TaskletsChannelMessage* _tmp7_;
	TaskletsTasklet* _tmp8_;
	GeeLinkedList* _tmp9_;
	TaskletsChannelMessage* _tmp10_;
#line 93 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_if_fail (v != NULL);
#line 95 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp0_ = tasklets_channel_message_new ();
#line 95 "/home/luca/repo/wip/tasklet/channel.vala"
	msg = _tmp0_;
#line 96 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp1_ = msg;
#line 96 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp2_ = *v;
#line 96 "/home/luca/repo/wip/tasklet/channel.vala"
	if (G_IS_VALUE (&_tmp2_)) {
#line 96 "/home/luca/repo/wip/tasklet/channel.vala"
		g_value_init (&_tmp3_, G_VALUE_TYPE (&_tmp2_));
#line 96 "/home/luca/repo/wip/tasklet/channel.vala"
		g_value_copy (&_tmp2_, &_tmp3_);
#line 329 "channel.c"
	} else {
#line 96 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp3_ = _tmp2_;
#line 333 "channel.c"
	}
#line 96 "/home/luca/repo/wip/tasklet/channel.vala"
	G_IS_VALUE (&_tmp1_->wrapped) ? (g_value_unset (&_tmp1_->wrapped), NULL) : NULL;
#line 96 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp1_->wrapped = _tmp3_;
#line 97 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp4_ = msg;
#line 97 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp5_ = tasklets_tasklet_self ();
#line 97 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (_tmp4_->confirmReceipt);
#line 97 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp4_->confirmReceipt = _tmp5_;
#line 98 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp6_ = self->priv->taskletsWaitingForReceipt;
#line 98 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp7_ = msg;
#line 98 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp8_ = _tmp7_->confirmReceipt;
#line 98 "/home/luca/repo/wip/tasklet/channel.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp8_);
#line 99 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp9_ = self->priv->pendingMessages;
#line 99 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp10_ = msg;
#line 99 "/home/luca/repo/wip/tasklet/channel.vala"
	gee_queue_offer ((GeeQueue*) _tmp9_, _tmp10_);
#line 100 "/home/luca/repo/wip/tasklet/channel.vala"
	while (TRUE) {
#line 363 "channel.c"
		GeeArrayList* _tmp11_;
		TaskletsChannelMessage* _tmp12_;
		TaskletsTasklet* _tmp13_;
		gboolean _tmp14_ = FALSE;
#line 100 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp11_ = self->priv->taskletsWaitingForReceipt;
#line 100 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp12_ = msg;
#line 100 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp13_ = _tmp12_->confirmReceipt;
#line 100 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp14_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp11_, _tmp13_);
#line 100 "/home/luca/repo/wip/tasklet/channel.vala"
		if (!_tmp14_) {
#line 100 "/home/luca/repo/wip/tasklet/channel.vala"
			break;
#line 380 "channel.c"
		}
#line 102 "/home/luca/repo/wip/tasklet/channel.vala"
		tasklets_tasklet_nap ((glong) 0, (glong) 100);
#line 384 "channel.c"
	}
#line 93 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (msg);
#line 388 "channel.c"
}


void tasklets_channel_recv (TaskletsChannel* self, GValue* result) {
	GValue _tmp2_ = {0};
	GError * _inner_error_ = NULL;
#line 106 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_if_fail (self != NULL);
#line 397 "channel.c"
	{
		GValue _tmp0_ = {0};
		GValue _tmp1_;
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
		tasklets_channel_recv_implementation (self, NULL, &_tmp0_, &_inner_error_);
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp1_ = _tmp0_;
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
		if (_inner_error_ != NULL) {
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
			if (_inner_error_->domain == TASKLETS_CHANNEL_ERROR) {
#line 409 "channel.c"
				goto __catch1_tasklets_channel_error;
			}
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
			g_clear_error (&_inner_error_);
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
			return;
#line 418 "channel.c"
		}
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
		*result = _tmp1_;
#line 110 "/home/luca/repo/wip/tasklet/channel.vala"
		return;
#line 424 "channel.c"
	}
	goto __finally1;
	__catch1_tasklets_channel_error:
	{
		GError* e = NULL;
#line 108 "/home/luca/repo/wip/tasklet/channel.vala"
		e = _inner_error_;
#line 108 "/home/luca/repo/wip/tasklet/channel.vala"
		_inner_error_ = NULL;
#line 114 "/home/luca/repo/wip/tasklet/channel.vala"
		_vala_assert (FALSE, "false");
#line 108 "/home/luca/repo/wip/tasklet/channel.vala"
		_g_error_free0 (e);
#line 438 "channel.c"
	}
	__finally1:
#line 108 "/home/luca/repo/wip/tasklet/channel.vala"
	if (_inner_error_ != NULL) {
#line 108 "/home/luca/repo/wip/tasklet/channel.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 108 "/home/luca/repo/wip/tasklet/channel.vala"
		g_clear_error (&_inner_error_);
#line 108 "/home/luca/repo/wip/tasklet/channel.vala"
		return;
#line 449 "channel.c"
	}
#line 117 "/home/luca/repo/wip/tasklet/channel.vala"
	g_value_init (&_tmp2_, G_TYPE_OBJECT);
#line 117 "/home/luca/repo/wip/tasklet/channel.vala"
	*result = _tmp2_;
#line 117 "/home/luca/repo/wip/tasklet/channel.vala"
	return;
#line 457 "channel.c"
}


void tasklets_channel_recv_with_timeout (TaskletsChannel* self, gint64 timeout_msec, GValue* result, GError** error) {
	gint64 _tmp0_;
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GError * _inner_error_ = NULL;
#line 120 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_if_fail (self != NULL);
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp0_ = timeout_msec;
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
	tasklets_channel_recv_implementation (self, &_tmp0_, &_tmp1_, &_inner_error_);
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp2_ = _tmp1_;
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
	if (_inner_error_ != NULL) {
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
		if (_inner_error_->domain == TASKLETS_CHANNEL_ERROR) {
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
			g_propagate_error (error, _inner_error_);
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
			return;
#line 482 "channel.c"
		} else {
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
			g_clear_error (&_inner_error_);
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
			return;
#line 490 "channel.c"
		}
	}
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
	*result = _tmp2_;
#line 122 "/home/luca/repo/wip/tasklet/channel.vala"
	return;
#line 497 "channel.c"
}


static void tasklets_channel_recv_implementation (TaskletsChannel* self, gint64* timeout_msec, GValue* result, GError** error) {
	TaskletsChannelMessage* retval = NULL;
	TaskletsTimer* tc;
	gint64* _tmp0_;
	GeeArrayList* _tmp3_;
	TaskletsTasklet* _tmp4_ = NULL;
	TaskletsTasklet* _tmp5_;
	TaskletsChannelMessage* _tmp43_;
	GValue _tmp44_;
	GValue _tmp45_ = {0};
	GError * _inner_error_ = NULL;
#line 125 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/luca/repo/wip/tasklet/channel.vala"
	tc = NULL;
#line 129 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp0_ = timeout_msec;
#line 129 "/home/luca/repo/wip/tasklet/channel.vala"
	if (_tmp0_ != NULL) {
#line 520 "channel.c"
		gint64* _tmp1_;
		TaskletsTimer* _tmp2_;
#line 131 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp1_ = timeout_msec;
#line 131 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp2_ = tasklets_timer_new (*_tmp1_);
#line 131 "/home/luca/repo/wip/tasklet/channel.vala"
		_g_object_unref0 (tc);
#line 131 "/home/luca/repo/wip/tasklet/channel.vala"
		tc = _tmp2_;
#line 531 "channel.c"
	}
#line 133 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp3_ = self->priv->receivingTasklets;
#line 133 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp4_ = tasklets_tasklet_self ();
#line 133 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp5_ = _tmp4_;
#line 133 "/home/luca/repo/wip/tasklet/channel.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp5_);
#line 133 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (_tmp5_);
#line 134 "/home/luca/repo/wip/tasklet/channel.vala"
	while (TRUE) {
#line 545 "channel.c"
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gboolean _tmp34_ = FALSE;
		TaskletsTimer* _tmp35_;
		gboolean _tmp38_;
#line 136 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp6_ = self->priv->pendingMessages;
#line 136 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 136 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp8_ = _tmp7_;
#line 136 "/home/luca/repo/wip/tasklet/channel.vala"
		if (_tmp8_ > 0) {
#line 560 "channel.c"
			GeeArrayList* _tmp9_;
			gpointer _tmp10_ = NULL;
			TaskletsTasklet* _tmp11_;
			TaskletsTasklet* _tmp12_ = NULL;
			TaskletsTasklet* _tmp13_;
			gboolean _tmp14_;
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp9_ = self->priv->receivingTasklets;
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, 0);
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp11_ = (TaskletsTasklet*) _tmp10_;
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp12_ = tasklets_tasklet_self ();
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp13_ = _tmp12_;
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp14_ = _tmp11_ != _tmp13_;
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			_g_object_unref0 (_tmp13_);
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			_g_object_unref0 (_tmp11_);
#line 138 "/home/luca/repo/wip/tasklet/channel.vala"
			if (_tmp14_) {
#line 585 "channel.c"
				GeeArrayList* _tmp15_;
				gpointer _tmp16_ = NULL;
				TaskletsTasklet* _tmp17_;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_;
				gboolean aborted;
				gboolean _tmp20_;
#line 140 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp15_ = self->priv->receivingTasklets;
#line 140 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
#line 140 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp17_ = (TaskletsTasklet*) _tmp16_;
#line 140 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp18_ = tasklets_tasklet_is_dead (_tmp17_);
#line 140 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp19_ = _tmp18_;
#line 140 "/home/luca/repo/wip/tasklet/channel.vala"
				_g_object_unref0 (_tmp17_);
#line 140 "/home/luca/repo/wip/tasklet/channel.vala"
				aborted = _tmp19_;
#line 141 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp20_ = aborted;
#line 141 "/home/luca/repo/wip/tasklet/channel.vala"
				if (_tmp20_) {
#line 611 "channel.c"
					GeeArrayList* _tmp21_;
					gpointer _tmp22_ = NULL;
					TaskletsTasklet* _tmp23_;
#line 143 "/home/luca/repo/wip/tasklet/channel.vala"
					_tmp21_ = self->priv->receivingTasklets;
#line 143 "/home/luca/repo/wip/tasklet/channel.vala"
					_tmp22_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp21_, 0);
#line 143 "/home/luca/repo/wip/tasklet/channel.vala"
					_tmp23_ = (TaskletsTasklet*) _tmp22_;
#line 143 "/home/luca/repo/wip/tasklet/channel.vala"
					_g_object_unref0 (_tmp23_);
#line 144 "/home/luca/repo/wip/tasklet/channel.vala"
					continue;
#line 625 "channel.c"
				}
			} else {
				GeeArrayList* _tmp24_;
				gpointer _tmp25_ = NULL;
				TaskletsTasklet* _tmp26_;
				GeeLinkedList* _tmp27_;
				gpointer _tmp28_ = NULL;
				TaskletsChannelMessage* _tmp29_;
				TaskletsTasklet* _tmp30_;
#line 149 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp24_ = self->priv->receivingTasklets;
#line 149 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp25_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp24_, 0);
#line 149 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp26_ = (TaskletsTasklet*) _tmp25_;
#line 149 "/home/luca/repo/wip/tasklet/channel.vala"
				_g_object_unref0 (_tmp26_);
#line 150 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp27_ = self->priv->pendingMessages;
#line 150 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp28_ = gee_queue_poll ((GeeQueue*) _tmp27_);
#line 150 "/home/luca/repo/wip/tasklet/channel.vala"
				_g_object_unref0 (retval);
#line 150 "/home/luca/repo/wip/tasklet/channel.vala"
				retval = (TaskletsChannelMessage*) _tmp28_;
#line 151 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp29_ = retval;
#line 151 "/home/luca/repo/wip/tasklet/channel.vala"
				_tmp30_ = _tmp29_->confirmReceipt;
#line 151 "/home/luca/repo/wip/tasklet/channel.vala"
				if (_tmp30_ != NULL) {
#line 657 "channel.c"
					GeeArrayList* _tmp31_;
					TaskletsChannelMessage* _tmp32_;
					TaskletsTasklet* _tmp33_;
#line 153 "/home/luca/repo/wip/tasklet/channel.vala"
					_tmp31_ = self->priv->taskletsWaitingForReceipt;
#line 153 "/home/luca/repo/wip/tasklet/channel.vala"
					_tmp32_ = retval;
#line 153 "/home/luca/repo/wip/tasklet/channel.vala"
					_tmp33_ = _tmp32_->confirmReceipt;
#line 153 "/home/luca/repo/wip/tasklet/channel.vala"
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp31_, _tmp33_);
#line 669 "channel.c"
				}
#line 155 "/home/luca/repo/wip/tasklet/channel.vala"
				break;
#line 673 "channel.c"
			}
		}
#line 158 "/home/luca/repo/wip/tasklet/channel.vala"
		tasklets_tasklet_nap ((glong) 0, (glong) 10000);
#line 159 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp35_ = tc;
#line 159 "/home/luca/repo/wip/tasklet/channel.vala"
		if (_tmp35_ != NULL) {
#line 682 "channel.c"
			TaskletsTimer* _tmp36_;
			gboolean _tmp37_ = FALSE;
#line 159 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp36_ = tc;
#line 159 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp37_ = tasklets_timer_is_expired (_tmp36_);
#line 159 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp34_ = _tmp37_;
#line 691 "channel.c"
		} else {
#line 159 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp34_ = FALSE;
#line 695 "channel.c"
		}
#line 159 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp38_ = _tmp34_;
#line 159 "/home/luca/repo/wip/tasklet/channel.vala"
		if (_tmp38_) {
#line 701 "channel.c"
			GeeArrayList* _tmp39_;
			TaskletsTasklet* _tmp40_ = NULL;
			TaskletsTasklet* _tmp41_;
			GError* _tmp42_;
#line 161 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp39_ = self->priv->receivingTasklets;
#line 161 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp40_ = tasklets_tasklet_self ();
#line 161 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp41_ = _tmp40_;
#line 161 "/home/luca/repo/wip/tasklet/channel.vala"
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp39_, _tmp41_);
#line 161 "/home/luca/repo/wip/tasklet/channel.vala"
			_g_object_unref0 (_tmp41_);
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
			_tmp42_ = g_error_new_literal (TASKLETS_CHANNEL_ERROR, TASKLETS_CHANNEL_ERROR_TIMEOUT_EXPIRED, "Channel: recv timeout");
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
			_inner_error_ = _tmp42_;
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
			if (_inner_error_->domain == TASKLETS_CHANNEL_ERROR) {
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				g_propagate_error (error, _inner_error_);
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				_g_object_unref0 (tc);
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				_g_object_unref0 (retval);
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				return;
#line 730 "channel.c"
			} else {
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				_g_object_unref0 (tc);
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				_g_object_unref0 (retval);
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				g_clear_error (&_inner_error_);
#line 162 "/home/luca/repo/wip/tasklet/channel.vala"
				return;
#line 742 "channel.c"
			}
		}
	}
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp43_ = retval;
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp44_ = _tmp43_->wrapped;
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
	if (G_IS_VALUE (&_tmp44_)) {
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
		g_value_init (&_tmp45_, G_VALUE_TYPE (&_tmp44_));
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
		g_value_copy (&_tmp44_, &_tmp45_);
#line 756 "channel.c"
	} else {
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp45_ = _tmp44_;
#line 760 "channel.c"
	}
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
	*result = _tmp45_;
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (tc);
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (retval);
#line 165 "/home/luca/repo/wip/tasklet/channel.vala"
	return;
#line 770 "channel.c"
}


static GeeHashMap* tasklets_channel_get_channels (void) {
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
#line 53 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp0_ = tasklets_channel__channels;
#line 53 "/home/luca/repo/wip/tasklet/channel.vala"
	if (_tmp0_ == NULL) {
#line 782 "channel.c"
		GeeHashMap* _tmp1_;
#line 53 "/home/luca/repo/wip/tasklet/channel.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TASKLETS_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 53 "/home/luca/repo/wip/tasklet/channel.vala"
		_g_object_unref0 (tasklets_channel__channels);
#line 53 "/home/luca/repo/wip/tasklet/channel.vala"
		tasklets_channel__channels = _tmp1_;
#line 790 "channel.c"
	}
#line 54 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp2_ = tasklets_channel__channels;
#line 54 "/home/luca/repo/wip/tasklet/channel.vala"
	result = _tmp2_;
#line 54 "/home/luca/repo/wip/tasklet/channel.vala"
	return result;
#line 798 "channel.c"
}


gint tasklets_channel_get_balance (TaskletsChannel* self) {
	gint result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 81 "/home/luca/repo/wip/tasklet/channel.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 82 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp0_ = self->priv->pendingMessages;
#line 82 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 82 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp2_ = _tmp1_;
#line 82 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp3_ = self->priv->receivingTasklets;
#line 82 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 82 "/home/luca/repo/wip/tasklet/channel.vala"
	_tmp5_ = _tmp4_;
#line 82 "/home/luca/repo/wip/tasklet/channel.vala"
	result = _tmp2_ - _tmp5_;
#line 82 "/home/luca/repo/wip/tasklet/channel.vala"
	return result;
#line 828 "channel.c"
}


static TaskletsChannelMessage* tasklets_channel_message_construct (GType object_type) {
	TaskletsChannelMessage * self = NULL;
#line 43 "/home/luca/repo/wip/tasklet/channel.vala"
	self = (TaskletsChannelMessage*) g_object_new (object_type, NULL);
#line 43 "/home/luca/repo/wip/tasklet/channel.vala"
	return self;
#line 838 "channel.c"
}


static TaskletsChannelMessage* tasklets_channel_message_new (void) {
#line 43 "/home/luca/repo/wip/tasklet/channel.vala"
	return tasklets_channel_message_construct (TASKLETS_CHANNEL_TYPE_MESSAGE);
#line 845 "channel.c"
}


static void tasklets_channel_message_class_init (TaskletsChannelMessageClass * klass) {
#line 43 "/home/luca/repo/wip/tasklet/channel.vala"
	tasklets_channel_message_parent_class = g_type_class_peek_parent (klass);
#line 43 "/home/luca/repo/wip/tasklet/channel.vala"
	G_OBJECT_CLASS (klass)->finalize = tasklets_channel_message_finalize;
#line 854 "channel.c"
}


static void tasklets_channel_message_instance_init (TaskletsChannelMessage * self) {
}


static void tasklets_channel_message_finalize (GObject* obj) {
	TaskletsChannelMessage * self;
#line 43 "/home/luca/repo/wip/tasklet/channel.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_CHANNEL_TYPE_MESSAGE, TaskletsChannelMessage);
#line 45 "/home/luca/repo/wip/tasklet/channel.vala"
	G_IS_VALUE (&self->wrapped) ? (g_value_unset (&self->wrapped), NULL) : NULL;
#line 46 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (self->confirmReceipt);
#line 43 "/home/luca/repo/wip/tasklet/channel.vala"
	G_OBJECT_CLASS (tasklets_channel_message_parent_class)->finalize (obj);
#line 872 "channel.c"
}


static GType tasklets_channel_message_get_type (void) {
	static volatile gsize tasklets_channel_message_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_channel_message_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsChannelMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_channel_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsChannelMessage), 0, (GInstanceInitFunc) tasklets_channel_message_instance_init, NULL };
		GType tasklets_channel_message_type_id;
		tasklets_channel_message_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsChannelMessage", &g_define_type_info, 0);
		g_once_init_leave (&tasklets_channel_message_type_id__volatile, tasklets_channel_message_type_id);
	}
	return tasklets_channel_message_type_id__volatile;
}


static void tasklets_channel_class_init (TaskletsChannelClass * klass) {
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	tasklets_channel_parent_class = g_type_class_peek_parent (klass);
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	g_type_class_add_private (klass, sizeof (TaskletsChannelPrivate));
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tasklets_channel_get_property;
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	G_OBJECT_CLASS (klass)->finalize = tasklets_channel_finalize;
#line 897 "channel.c"
	/** A positive value indicates messages waiting to be received.
	          * A negative value indicates tasklets waiting to receive a message.
	          */
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKLETS_CHANNEL_BALANCE, g_param_spec_int ("balance", "balance", "balance", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 903 "channel.c"
}


static void tasklets_channel_instance_init (TaskletsChannel * self) {
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	self->priv = TASKLETS_CHANNEL_GET_PRIVATE (self);
#line 910 "channel.c"
}


static void tasklets_channel_finalize (GObject* obj) {
	TaskletsChannel * self;
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_TYPE_CHANNEL, TaskletsChannel);
#line 59 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (self->priv->pendingMessages);
#line 60 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (self->priv->taskletsWaitingForReceipt);
#line 61 "/home/luca/repo/wip/tasklet/channel.vala"
	_g_object_unref0 (self->priv->receivingTasklets);
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	G_OBJECT_CLASS (tasklets_channel_parent_class)->finalize (obj);
#line 926 "channel.c"
}


/** A Channel object is used for bidirectional communication between tasklets.
      *
      * Features:
      *  * an object sent through an instance of Channel can be received only through the same instance of Channel;
      *  * an instance of Channel can have a name, and can be obtained by that name (static method find);
      *  * it is possible to send a message without blocking the current tasklet; not even scheduling;
      *  * it is possible for a tasklet to wait for a message to be received from a Channel;
      *    it is guaranteed that the order with which several tasklets wait a message is respected in the
      *    dispatching of messages; it is also possible for the tasklet to specify a timeout when waiting for a message;
      *  * it is possible to send a message and block the sending tasklet until the message is received;
      *  * it is possible to know how many messages are in a Channel to be received or
      *    how many tasklets are waiting to receive in a Channel (property balance)
      */
GType tasklets_channel_get_type (void) {
	static volatile gsize tasklets_channel_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_channel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsChannel), 0, (GInstanceInitFunc) tasklets_channel_instance_init, NULL };
		GType tasklets_channel_type_id;
		tasklets_channel_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsChannel", &g_define_type_info, 0);
		g_once_init_leave (&tasklets_channel_type_id__volatile, tasklets_channel_type_id);
	}
	return tasklets_channel_type_id__volatile;
}


static void _vala_tasklets_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TaskletsChannel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKLETS_TYPE_CHANNEL, TaskletsChannel);
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
	switch (property_id) {
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
		case TASKLETS_CHANNEL_BALANCE:
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
		g_value_set_int (value, tasklets_channel_get_balance (self));
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
		break;
#line 966 "channel.c"
		default:
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 41 "/home/luca/repo/wip/tasklet/channel.vala"
		break;
#line 972 "channel.c"
	}
}



