/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;

namespace zcd
{
    /** This interface has to be derived by a class that wants to send
      *  a RPC by any suitable means.
      */
    public interface FakeRmt : Object
    {
        public abstract ISerializable rmt(RemoteCall data) throws RPCError;
    }

    /** This class is used to send a message (usually without waiting for
      *  a result) to two remote objects.
      */
    public class CoupleFakeRmt : Object, FakeRmt
    {
        private FakeRmt f1;
        private FakeRmt f2;
        public CoupleFakeRmt(FakeRmt f1, FakeRmt f2)
        {
            this.f1 = f1;
            this.f2 = f2;
        }

        public ISerializable rmt(RemoteCall data) throws RPCError
        {
            f1.rmt(data);
            return f2.rmt(data);
        }
    }
}

