/* udpmessage.c generated by valac 0.20.1, the Vala compiler
 * generated from udpmessage.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define ZCD_TYPE_ISERIALIZABLE (zcd_iserializable_get_type ())
#define ZCD_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializable))
#define ZCD_IS_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_ISERIALIZABLE))
#define ZCD_ISERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializableIface))

typedef struct _zcdISerializable zcdISerializable;
typedef struct _zcdISerializableIface zcdISerializableIface;

#define ZCD_TYPE_UDP_MESSAGE (zcd_udp_message_get_type ())
#define ZCD_UDP_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessage))
#define ZCD_UDP_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessageClass))
#define ZCD_IS_UDP_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_UDP_MESSAGE))
#define ZCD_IS_UDP_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_UDP_MESSAGE))
#define ZCD_UDP_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessageClass))

typedef struct _zcdUDPMessage zcdUDPMessage;
typedef struct _zcdUDPMessageClass zcdUDPMessageClass;
typedef struct _zcdUDPMessagePrivate zcdUDPMessagePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define ZCD_TYPE_UDP_PAYLOAD (zcd_udp_payload_get_type ())
#define ZCD_UDP_PAYLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayload))
#define ZCD_UDP_PAYLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayloadClass))
#define ZCD_IS_UDP_PAYLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_UDP_PAYLOAD))
#define ZCD_IS_UDP_PAYLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_UDP_PAYLOAD))
#define ZCD_UDP_PAYLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayloadClass))

typedef struct _zcdUDPPayload zcdUDPPayload;
typedef struct _zcdUDPPayloadClass zcdUDPPayloadClass;
typedef struct _zcdUDPPayloadPrivate zcdUDPPayloadPrivate;

#define ZCD_TYPE_REMOTE_CALL (zcd_remote_call_get_type ())
#define ZCD_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCall))
#define ZCD_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))
#define ZCD_IS_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_REMOTE_CALL))
#define ZCD_IS_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_REMOTE_CALL))
#define ZCD_REMOTE_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))

typedef struct _zcdRemoteCall zcdRemoteCall;
typedef struct _zcdRemoteCallClass zcdRemoteCallClass;

typedef enum  {
	ZCD_SERIALIZER_ERROR_GENERIC
} zcdSerializerError;
#define ZCD_SERIALIZER_ERROR zcd_serializer_error_quark ()
struct _zcdISerializableIface {
	GTypeInterface parent_iface;
	GVariant* (*serialize_to_variant) (zcdISerializable* self);
	void (*deserialize_from_variant) (zcdISerializable* self, GVariant* v, GError** error);
};

struct _zcdUDPMessage {
	GObject parent_instance;
	zcdUDPMessagePrivate * priv;
};

struct _zcdUDPMessageClass {
	GObjectClass parent_class;
};

struct _zcdUDPMessagePrivate {
	gint _request_id;
	gchar* message_type;
	gboolean _wait_response;
	gboolean _send_ack;
	zcdISerializable* _data;
};

struct _zcdUDPPayload {
	GObject parent_instance;
	zcdUDPPayloadPrivate * priv;
	guchar* ser;
	gint ser_length1;
	zcdRemoteCall* data;
};

struct _zcdUDPPayloadClass {
	GObjectClass parent_class;
};


static gpointer zcd_udp_message_parent_class = NULL;
static zcdISerializableIface* zcd_udp_message_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_udp_payload_parent_class = NULL;
static zcdISerializableIface* zcd_udp_payload_zcd_iserializable_parent_iface = NULL;

GQuark zcd_serializer_error_quark (void);
GType zcd_iserializable_get_type (void) G_GNUC_CONST;
GType zcd_udp_message_get_type (void) G_GNUC_CONST;
#define ZCD_UDP_MESSAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessagePrivate))
enum  {
	ZCD_UDP_MESSAGE_DUMMY_PROPERTY,
	ZCD_UDP_MESSAGE_REQUEST_ID,
	ZCD_UDP_MESSAGE_WAIT_RESPONSE,
	ZCD_UDP_MESSAGE_SEND_ACK,
	ZCD_UDP_MESSAGE_DATA
};
static zcdUDPMessage* zcd_udp_message_new (gint reqid);
static zcdUDPMessage* zcd_udp_message_construct (GType object_type, gint reqid);
static void zcd_udp_message_set_request_id (zcdUDPMessage* self, gint value);
zcdUDPMessage* zcd_udp_message_make_request_unicast (zcdISerializable* data, gboolean wait_response);
static void zcd_udp_message_set_wait_response (zcdUDPMessage* self, gboolean value);
static void zcd_udp_message_set_data (zcdUDPMessage* self, zcdISerializable* value);
zcdUDPMessage* zcd_udp_message_make_request_broadcast (zcdISerializable* data, gboolean send_ack);
static void zcd_udp_message_set_send_ack (zcdUDPMessage* self, gboolean value);
zcdUDPMessage* zcd_udp_message_make_keep_alive (gint reqid);
zcdUDPMessage* zcd_udp_message_make_response (gint reqid, zcdISerializable* data);
gboolean zcd_udp_message_is_response (zcdUDPMessage* self);
gboolean zcd_udp_message_is_keepalive (zcdUDPMessage* self);
gboolean zcd_udp_message_is_request_unicast (zcdUDPMessage* self);
gboolean zcd_udp_message_is_request_broadcast (zcdUDPMessage* self);
static GVariant* zcd_udp_message_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_int_to_variant (gint i);
gint zcd_udp_message_get_request_id (zcdUDPMessage* self);
GVariant* zcd_serializer_string_to_variant (const gchar* s);
gboolean zcd_udp_message_get_wait_response (zcdUDPMessage* self);
GVariant* zcd_serializer_uchar_array_to_variant (guchar* auc, int auc_length1);
zcdISerializable* zcd_udp_message_get_data (zcdUDPMessage* self);
guchar* zcd_iserializable_serialize (zcdISerializable* self, int* result_length1);
gboolean zcd_udp_message_get_send_ack (zcdUDPMessage* self);
GVariant* zcd_serializer_tuple_to_variant_5 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3, GVariant* v4);
static void zcd_udp_message_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
void zcd_serializer_variant_to_tuple_5 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3, GVariant** v4);
gint zcd_serializer_variant_to_int (GVariant* v);
gchar* zcd_serializer_variant_to_string (GVariant* v);
zcdISerializable* zcd_iserializable_deserialize (guchar* ser, int ser_length1, GError** error);
guchar* zcd_serializer_variant_to_uchar_array (GVariant* v, int* result_length1);
gchar* zcd_udp_message_to_string (zcdUDPMessage* self);
GType zcd_udp_payload_get_type (void) G_GNUC_CONST;
gchar* zcd_udp_payload_to_string (zcdUDPPayload* self);
static void zcd_udp_message_finalize (GObject* obj);
static void _vala_zcd_udp_message_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zcd_udp_message_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType zcd_remote_call_get_type (void) G_GNUC_CONST;
enum  {
	ZCD_UDP_PAYLOAD_DUMMY_PROPERTY
};
zcdUDPPayload* zcd_udp_payload_new (zcdISerializable* ser, zcdRemoteCall* data);
zcdUDPPayload* zcd_udp_payload_construct (GType object_type, zcdISerializable* ser, zcdRemoteCall* data);
static GVariant* zcd_udp_payload_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_iserializable_serialize_to_variant (zcdISerializable* self);
GVariant* zcd_serializer_tuple_to_variant (GVariant* v0, GVariant* v1);
static void zcd_udp_payload_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
void zcd_serializer_variant_to_tuple (GVariant* v, GVariant** v0, GVariant** v1);
void zcd_iserializable_deserialize_from_variant (zcdISerializable* self, GVariant* v, GError** error);
gchar* zcd_remote_call_to_string (zcdRemoteCall* self);
static void zcd_udp_payload_finalize (GObject* obj);


static zcdUDPMessage* zcd_udp_message_construct (GType object_type, gint reqid) {
	zcdUDPMessage * self = NULL;
	gint _tmp0_;
	self = (zcdUDPMessage*) g_object_new (object_type, NULL);
	_tmp0_ = reqid;
	if (_tmp0_ == (-1)) {
		gint _tmp1_;
		gint32 _tmp2_ = 0;
		_tmp1_ = G_MAXINT;
		_tmp2_ = g_random_int_range ((gint32) 1, (gint32) _tmp1_);
		zcd_udp_message_set_request_id (self, (gint) _tmp2_);
	} else {
		gint _tmp3_;
		_tmp3_ = reqid;
		zcd_udp_message_set_request_id (self, _tmp3_);
	}
	return self;
}


static zcdUDPMessage* zcd_udp_message_new (gint reqid) {
	return zcd_udp_message_construct (ZCD_TYPE_UDP_MESSAGE, reqid);
}


zcdUDPMessage* zcd_udp_message_make_request_unicast (zcdISerializable* data, gboolean wait_response) {
	zcdUDPMessage* result = NULL;
	zcdUDPMessage* _tmp0_;
	zcdUDPMessage* ret;
	gchar* _tmp1_;
	gboolean _tmp2_;
	zcdISerializable* _tmp3_;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = zcd_udp_message_new (-1);
	ret = _tmp0_;
	_tmp1_ = g_strdup ("R");
	_g_free0 (ret->priv->message_type);
	ret->priv->message_type = _tmp1_;
	_tmp2_ = wait_response;
	zcd_udp_message_set_wait_response (ret, _tmp2_);
	_tmp3_ = data;
	zcd_udp_message_set_data (ret, _tmp3_);
	result = ret;
	return result;
}


zcdUDPMessage* zcd_udp_message_make_request_broadcast (zcdISerializable* data, gboolean send_ack) {
	zcdUDPMessage* result = NULL;
	zcdUDPMessage* _tmp0_;
	zcdUDPMessage* ret;
	gchar* _tmp1_;
	zcdISerializable* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = zcd_udp_message_new (-1);
	ret = _tmp0_;
	_tmp1_ = g_strdup ("B");
	_g_free0 (ret->priv->message_type);
	ret->priv->message_type = _tmp1_;
	zcd_udp_message_set_wait_response (ret, FALSE);
	_tmp2_ = data;
	zcd_udp_message_set_data (ret, _tmp2_);
	_tmp3_ = send_ack;
	zcd_udp_message_set_send_ack (ret, _tmp3_);
	result = ret;
	return result;
}


zcdUDPMessage* zcd_udp_message_make_keep_alive (gint reqid) {
	zcdUDPMessage* result = NULL;
	gint _tmp0_;
	zcdUDPMessage* _tmp1_;
	zcdUDPMessage* ret;
	gchar* _tmp2_;
	_tmp0_ = reqid;
	_tmp1_ = zcd_udp_message_new (_tmp0_);
	ret = _tmp1_;
	_tmp2_ = g_strdup ("K");
	_g_free0 (ret->priv->message_type);
	ret->priv->message_type = _tmp2_;
	zcd_udp_message_set_wait_response (ret, FALSE);
	result = ret;
	return result;
}


zcdUDPMessage* zcd_udp_message_make_response (gint reqid, zcdISerializable* data) {
	zcdUDPMessage* result = NULL;
	gint _tmp0_;
	zcdUDPMessage* _tmp1_;
	zcdUDPMessage* ret;
	gchar* _tmp2_;
	zcdISerializable* _tmp3_;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = reqid;
	_tmp1_ = zcd_udp_message_new (_tmp0_);
	ret = _tmp1_;
	_tmp2_ = g_strdup ("A");
	_g_free0 (ret->priv->message_type);
	ret->priv->message_type = _tmp2_;
	zcd_udp_message_set_wait_response (ret, FALSE);
	_tmp3_ = data;
	zcd_udp_message_set_data (ret, _tmp3_);
	result = ret;
	return result;
}


gboolean zcd_udp_message_is_response (zcdUDPMessage* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->message_type;
	result = g_strcmp0 (_tmp0_, "A") == 0;
	return result;
}


gboolean zcd_udp_message_is_keepalive (zcdUDPMessage* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->message_type;
	result = g_strcmp0 (_tmp0_, "K") == 0;
	return result;
}


gboolean zcd_udp_message_is_request_unicast (zcdUDPMessage* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->message_type;
	result = g_strcmp0 (_tmp0_, "R") == 0;
	return result;
}


gboolean zcd_udp_message_is_request_broadcast (zcdUDPMessage* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->message_type;
	result = g_strcmp0 (_tmp0_, "B") == 0;
	return result;
}


static GVariant* zcd_udp_message_real_serialize_to_variant (zcdISerializable* base) {
	zcdUDPMessage * self;
	GVariant* result = NULL;
	gint _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* v0;
	const gchar* _tmp2_;
	GVariant* _tmp3_ = NULL;
	GVariant* v1;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gint _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* v2;
	zcdISerializable* _tmp8_;
	gint _tmp9_ = 0;
	guchar* _tmp10_ = NULL;
	guchar* _tmp11_;
	gint _tmp11__length1;
	GVariant* _tmp12_ = NULL;
	GVariant* _tmp13_;
	GVariant* v3;
	gint _tmp14_ = 0;
	gboolean _tmp15_;
	gint _tmp16_;
	GVariant* _tmp17_ = NULL;
	GVariant* v4;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_ = NULL;
	GVariant* vret;
	self = (zcdUDPMessage*) base;
	_tmp0_ = self->priv->_request_id;
	_tmp1_ = zcd_serializer_int_to_variant (_tmp0_);
	v0 = _tmp1_;
	_tmp2_ = self->priv->message_type;
	_tmp3_ = zcd_serializer_string_to_variant (_tmp2_);
	v1 = _tmp3_;
	_tmp5_ = self->priv->_wait_response;
	if (_tmp5_) {
		_tmp4_ = 1;
	} else {
		_tmp4_ = 0;
	}
	_tmp6_ = _tmp4_;
	_tmp7_ = zcd_serializer_int_to_variant (_tmp6_);
	v2 = _tmp7_;
	_tmp8_ = self->priv->_data;
	_tmp10_ = zcd_iserializable_serialize (_tmp8_, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp12_ = zcd_serializer_uchar_array_to_variant (_tmp11_, _tmp9_);
	_tmp13_ = _tmp12_;
	_tmp11_ = (g_free (_tmp11_), NULL);
	v3 = _tmp13_;
	_tmp15_ = self->priv->_send_ack;
	if (_tmp15_) {
		_tmp14_ = 1;
	} else {
		_tmp14_ = 0;
	}
	_tmp16_ = _tmp14_;
	_tmp17_ = zcd_serializer_int_to_variant (_tmp16_);
	v4 = _tmp17_;
	_tmp18_ = v0;
	_tmp19_ = v1;
	_tmp20_ = v2;
	_tmp21_ = v3;
	_tmp22_ = zcd_serializer_tuple_to_variant_5 (_tmp18_, _tmp19_, _tmp20_, _tmp21_, v4);
	vret = _tmp22_;
	result = vret;
	_g_variant_unref0 (v4);
	_g_variant_unref0 (v3);
	_g_variant_unref0 (v2);
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
	return result;
}


static void zcd_udp_message_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdUDPMessage * self;
	GVariant* v0 = NULL;
	GVariant* v1 = NULL;
	GVariant* v2 = NULL;
	GVariant* v3 = NULL;
	GVariant* v4 = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	guchar* _tmp10_ = NULL;
	guchar* _tmp11_;
	gint _tmp11__length1;
	zcdISerializable* _tmp12_ = NULL;
	zcdISerializable* _tmp13_;
	zcdISerializable* _tmp14_;
	zcdISerializable* _tmp15_;
	gint _tmp16_ = 0;
	GError * _inner_error_ = NULL;
	self = (zcdUDPMessage*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	zcd_serializer_variant_to_tuple_5 (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	_g_variant_unref0 (v0);
	v0 = _tmp1_;
	_g_variant_unref0 (v1);
	v1 = _tmp2_;
	_g_variant_unref0 (v2);
	v2 = _tmp3_;
	_g_variant_unref0 (v3);
	v3 = _tmp4_;
	_g_variant_unref0 (v4);
	v4 = _tmp5_;
	_tmp6_ = zcd_serializer_variant_to_int (v0);
	zcd_udp_message_set_request_id (self, _tmp6_);
	_tmp7_ = zcd_serializer_variant_to_string (v1);
	_g_free0 (self->priv->message_type);
	self->priv->message_type = _tmp7_;
	_tmp8_ = zcd_serializer_variant_to_int (v2);
	zcd_udp_message_set_wait_response (self, _tmp8_ == 1);
	_tmp10_ = zcd_serializer_variant_to_uchar_array (v3, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp12_ = zcd_iserializable_deserialize (_tmp11_, _tmp9_, &_inner_error_);
	_tmp13_ = _tmp12_;
	_tmp11_ = (g_free (_tmp11_), NULL);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (v4);
			_g_variant_unref0 (v3);
			_g_variant_unref0 (v2);
			_g_variant_unref0 (v1);
			_g_variant_unref0 (v0);
			return;
		} else {
			_g_variant_unref0 (v4);
			_g_variant_unref0 (v3);
			_g_variant_unref0 (v2);
			_g_variant_unref0 (v1);
			_g_variant_unref0 (v0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = _tmp14_;
	zcd_udp_message_set_data (self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = zcd_serializer_variant_to_int (v4);
	zcd_udp_message_set_send_ack (self, _tmp16_ == 1);
	_g_variant_unref0 (v4);
	_g_variant_unref0 (v3);
	_g_variant_unref0 (v2);
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* zcd_udp_message_to_string (zcdUDPMessage* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gchar* _tmp56_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = zcd_udp_message_is_response (self);
	if (_tmp0_) {
		gint _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		zcdISerializable* _tmp4_;
		GType _tmp5_ = 0UL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp1_ = self->priv->_request_id;
		_tmp2_ = g_strdup_printf ("%i", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_data;
		_tmp5_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp4_);
		_tmp6_ = g_type_name (_tmp5_);
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("<UDPMessage ANSWER request=", _tmp3_, " [", _tmp7_, "]>", NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp3_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = zcd_udp_message_is_keepalive (self);
	if (_tmp10_) {
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp11_ = self->priv->_request_id;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("<UDPMessage KEEPALIVE request=", _tmp13_, ">", NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = zcd_udp_message_is_request_unicast (self);
	if (_tmp16_) {
		const gchar* _tmp17_ = NULL;
		gboolean _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* wait_str;
		gchar* _tmp21_;
		gchar* data_str;
		zcdISerializable* _tmp22_;
		zcdUDPPayload* _tmp23_;
		zcdUDPPayload* _data;
		zcdUDPPayload* _tmp24_;
		gint _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		_tmp18_ = self->priv->_wait_response;
		if (_tmp18_) {
			_tmp17_ = "wait_response";
		} else {
			_tmp17_ = "no_wait_response";
		}
		_tmp19_ = _tmp17_;
		_tmp20_ = g_strdup (_tmp19_);
		wait_str = _tmp20_;
		_tmp21_ = g_strdup ("null_data");
		data_str = _tmp21_;
		_tmp22_ = self->priv->_data;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, ZCD_TYPE_UDP_PAYLOAD) ? ((zcdUDPPayload*) _tmp22_) : NULL);
		_data = _tmp23_;
		_tmp24_ = _data;
		if (_tmp24_ != NULL) {
			zcdUDPPayload* _tmp25_;
			gchar* _tmp26_ = NULL;
			_tmp25_ = _data;
			_tmp26_ = zcd_udp_payload_to_string (_tmp25_);
			_g_free0 (data_str);
			data_str = _tmp26_;
		}
		_tmp27_ = self->priv->_request_id;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = data_str;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = wait_str;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("<UDPMessage REQUEST id=", _tmp29_, " ", _tmp31_, " ", _tmp33_, ">", NULL);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp29_);
		result = _tmp35_;
		_g_object_unref0 (_data);
		_g_free0 (data_str);
		_g_free0 (wait_str);
		return result;
	}
	_tmp36_ = zcd_udp_message_is_request_broadcast (self);
	if (_tmp36_) {
		const gchar* _tmp37_ = NULL;
		gboolean _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* wait_str;
		gchar* _tmp41_;
		gchar* data_str;
		zcdISerializable* _tmp42_;
		zcdUDPPayload* _tmp43_;
		zcdUDPPayload* _data;
		zcdUDPPayload* _tmp44_;
		gint _tmp47_;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_ = NULL;
		const gchar* _tmp52_;
		const gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		_tmp38_ = self->priv->_wait_response;
		if (_tmp38_) {
			_tmp37_ = "wait_response";
		} else {
			_tmp37_ = "no_wait_response";
		}
		_tmp39_ = _tmp37_;
		_tmp40_ = g_strdup (_tmp39_);
		wait_str = _tmp40_;
		_tmp41_ = g_strdup ("null_data");
		data_str = _tmp41_;
		_tmp42_ = self->priv->_data;
		_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, ZCD_TYPE_UDP_PAYLOAD) ? ((zcdUDPPayload*) _tmp42_) : NULL);
		_data = _tmp43_;
		_tmp44_ = _data;
		if (_tmp44_ != NULL) {
			zcdUDPPayload* _tmp45_;
			gchar* _tmp46_ = NULL;
			_tmp45_ = _data;
			_tmp46_ = zcd_udp_payload_to_string (_tmp45_);
			_g_free0 (data_str);
			data_str = _tmp46_;
		}
		_tmp47_ = self->priv->_request_id;
		_tmp48_ = g_strdup_printf ("%i", _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = data_str;
		_tmp51_ = string_to_string (_tmp50_);
		_tmp52_ = wait_str;
		_tmp53_ = string_to_string (_tmp52_);
		_tmp54_ = g_strconcat ("<UDPMessage BROADCAST id=", _tmp49_, " ", _tmp51_, " ", _tmp53_, ">", NULL);
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp49_);
		result = _tmp55_;
		_g_object_unref0 (_data);
		_g_free0 (data_str);
		_g_free0 (wait_str);
		return result;
	}
	_tmp56_ = g_strdup ("<UDPMessage ???>");
	result = _tmp56_;
	return result;
}


gint zcd_udp_message_get_request_id (zcdUDPMessage* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_request_id;
	result = _tmp0_;
	return result;
}


static void zcd_udp_message_set_request_id (zcdUDPMessage* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_request_id = _tmp0_;
	g_object_notify ((GObject *) self, "request-id");
}


gboolean zcd_udp_message_get_wait_response (zcdUDPMessage* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_wait_response;
	result = _tmp0_;
	return result;
}


static void zcd_udp_message_set_wait_response (zcdUDPMessage* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_wait_response = _tmp0_;
	g_object_notify ((GObject *) self, "wait-response");
}


gboolean zcd_udp_message_get_send_ack (zcdUDPMessage* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_send_ack;
	result = _tmp0_;
	return result;
}


static void zcd_udp_message_set_send_ack (zcdUDPMessage* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_send_ack = _tmp0_;
	g_object_notify ((GObject *) self, "send-ack");
}


zcdISerializable* zcd_udp_message_get_data (zcdUDPMessage* self) {
	zcdISerializable* result;
	zcdISerializable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data;
	result = _tmp0_;
	return result;
}


static void zcd_udp_message_set_data (zcdUDPMessage* self, zcdISerializable* value) {
	zcdISerializable* _tmp0_;
	zcdISerializable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_data);
	self->priv->_data = _tmp1_;
	g_object_notify ((GObject *) self, "data");
}


static void zcd_udp_message_class_init (zcdUDPMessageClass * klass) {
	zcd_udp_message_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdUDPMessagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_udp_message_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zcd_udp_message_set_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_udp_message_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_UDP_MESSAGE_REQUEST_ID, g_param_spec_int ("request-id", "request-id", "request-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_UDP_MESSAGE_WAIT_RESPONSE, g_param_spec_boolean ("wait-response", "wait-response", "wait-response", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_UDP_MESSAGE_SEND_ACK, g_param_spec_boolean ("send-ack", "send-ack", "send-ack", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/** data will be a instance of a serializable class, that will contain
	          * the marshalled_data. Furthermore it will contain information to identify
	          * a single node (if request_unicast) or a group of nodes.
	          * See the abstract class UDPPayload below.
	          */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_UDP_MESSAGE_DATA, g_param_spec_object ("data", "data", "data", ZCD_TYPE_ISERIALIZABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zcd_udp_message_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_udp_message_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_udp_message_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_udp_message_real_deserialize_from_variant;
}


static void zcd_udp_message_instance_init (zcdUDPMessage * self) {
	self->priv = ZCD_UDP_MESSAGE_GET_PRIVATE (self);
}


static void zcd_udp_message_finalize (GObject* obj) {
	zcdUDPMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_UDP_MESSAGE, zcdUDPMessage);
	_g_free0 (self->priv->message_type);
	_g_object_unref0 (self->priv->_data);
	G_OBJECT_CLASS (zcd_udp_message_parent_class)->finalize (obj);
}


/** A message that uses UDP as transport.
      */
GType zcd_udp_message_get_type (void) {
	static volatile gsize zcd_udp_message_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_udp_message_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdUDPMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_udp_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdUDPMessage), 0, (GInstanceInitFunc) zcd_udp_message_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_udp_message_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_udp_message_type_id;
		zcd_udp_message_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdUDPMessage", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_udp_message_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_udp_message_type_id__volatile, zcd_udp_message_type_id);
	}
	return zcd_udp_message_type_id__volatile;
}


static void _vala_zcd_udp_message_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdUDPMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_UDP_MESSAGE, zcdUDPMessage);
	switch (property_id) {
		case ZCD_UDP_MESSAGE_REQUEST_ID:
		g_value_set_int (value, zcd_udp_message_get_request_id (self));
		break;
		case ZCD_UDP_MESSAGE_WAIT_RESPONSE:
		g_value_set_boolean (value, zcd_udp_message_get_wait_response (self));
		break;
		case ZCD_UDP_MESSAGE_SEND_ACK:
		g_value_set_boolean (value, zcd_udp_message_get_send_ack (self));
		break;
		case ZCD_UDP_MESSAGE_DATA:
		g_value_set_object (value, zcd_udp_message_get_data (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zcd_udp_message_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	zcdUDPMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_UDP_MESSAGE, zcdUDPMessage);
	switch (property_id) {
		case ZCD_UDP_MESSAGE_REQUEST_ID:
		zcd_udp_message_set_request_id (self, g_value_get_int (value));
		break;
		case ZCD_UDP_MESSAGE_WAIT_RESPONSE:
		zcd_udp_message_set_wait_response (self, g_value_get_boolean (value));
		break;
		case ZCD_UDP_MESSAGE_SEND_ACK:
		zcd_udp_message_set_send_ack (self, g_value_get_boolean (value));
		break;
		case ZCD_UDP_MESSAGE_DATA:
		zcd_udp_message_set_data (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


zcdUDPPayload* zcd_udp_payload_construct (GType object_type, zcdISerializable* ser, zcdRemoteCall* data) {
	zcdUDPPayload * self = NULL;
	zcdISerializable* _tmp0_;
	gint _tmp1_ = 0;
	guchar* _tmp2_ = NULL;
	zcdRemoteCall* _tmp3_;
	zcdRemoteCall* _tmp4_;
	g_return_val_if_fail (ser != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	self = (zcdUDPPayload*) g_object_new (object_type, NULL);
	_tmp0_ = ser;
	_tmp2_ = zcd_iserializable_serialize (_tmp0_, &_tmp1_);
	self->ser = (g_free (self->ser), NULL);
	self->ser = _tmp2_;
	self->ser_length1 = _tmp1_;
	_tmp3_ = data;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->data);
	self->data = _tmp4_;
	return self;
}


zcdUDPPayload* zcd_udp_payload_new (zcdISerializable* ser, zcdRemoteCall* data) {
	return zcd_udp_payload_construct (ZCD_TYPE_UDP_PAYLOAD, ser, data);
}


static GVariant* zcd_udp_payload_real_serialize_to_variant (zcdISerializable* base) {
	zcdUDPPayload * self;
	GVariant* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp1_ = NULL;
	GVariant* v0;
	zcdRemoteCall* _tmp2_;
	GVariant* _tmp3_ = NULL;
	GVariant* v1;
	GVariant* _tmp4_ = NULL;
	GVariant* vret;
	self = (zcdUDPPayload*) base;
	_tmp0_ = self->ser;
	_tmp0__length1 = self->ser_length1;
	_tmp1_ = zcd_serializer_uchar_array_to_variant (_tmp0_, _tmp0__length1);
	v0 = _tmp1_;
	_tmp2_ = self->data;
	_tmp3_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) _tmp2_);
	v1 = _tmp3_;
	_tmp4_ = zcd_serializer_tuple_to_variant (v0, v1);
	vret = _tmp4_;
	result = vret;
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
	return result;
}


static void zcd_udp_payload_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdUDPPayload * self;
	GVariant* v0 = NULL;
	GVariant* v1 = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	guchar* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_;
	zcdRemoteCall* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (zcdUDPPayload*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	zcd_serializer_variant_to_tuple (_tmp0_, &_tmp1_, &_tmp2_);
	_g_variant_unref0 (v0);
	v0 = _tmp1_;
	_g_variant_unref0 (v1);
	v1 = _tmp2_;
	_tmp4_ = zcd_serializer_variant_to_uchar_array (v0, &_tmp3_);
	self->ser = (g_free (self->ser), NULL);
	self->ser = _tmp4_;
	self->ser_length1 = _tmp3_;
	_tmp5_ = g_object_new (ZCD_TYPE_REMOTE_CALL, NULL);
	_tmp6_ = G_IS_INITIALLY_UNOWNED (_tmp5_) ? g_object_ref_sink (_tmp5_) : _tmp5_;
	_g_object_unref0 (self->data);
	self->data = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, ZCD_TYPE_REMOTE_CALL, zcdRemoteCall);
	_tmp7_ = self->data;
	zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp7_, v1, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (v1);
			_g_variant_unref0 (v0);
			return;
		} else {
			_g_variant_unref0 (v1);
			_g_variant_unref0 (v0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
}


gchar* zcd_udp_payload_to_string (zcdUDPPayload* self) {
	gchar* result = NULL;
	zcdRemoteCall* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->data;
	_tmp1_ = zcd_remote_call_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("<UDPPayload ", _tmp2_, ">", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static void zcd_udp_payload_class_init (zcdUDPPayloadClass * klass) {
	zcd_udp_payload_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = zcd_udp_payload_finalize;
}


static void zcd_udp_payload_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_udp_payload_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_udp_payload_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_udp_payload_real_deserialize_from_variant;
}


static void zcd_udp_payload_instance_init (zcdUDPPayload * self) {
}


static void zcd_udp_payload_finalize (GObject* obj) {
	zcdUDPPayload * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayload);
	self->ser = (g_free (self->ser), NULL);
	_g_object_unref0 (self->data);
	G_OBJECT_CLASS (zcd_udp_payload_parent_class)->finalize (obj);
}


/** A UDP message containing a RemoteCall to be dispatched and data that the callbacks can inspect
      * to see whether the message has to be delivered to one of our dispatchers
      */
GType zcd_udp_payload_get_type (void) {
	static volatile gsize zcd_udp_payload_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_udp_payload_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdUDPPayloadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_udp_payload_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdUDPPayload), 0, (GInstanceInitFunc) zcd_udp_payload_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_udp_payload_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_udp_payload_type_id;
		zcd_udp_payload_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdUDPPayload", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_udp_payload_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_udp_payload_type_id__volatile, zcd_udp_payload_type_id);
	}
	return zcd_udp_payload_type_id__volatile;
}



