/*
 * Decompiled with CFR 0.152.
 */
package irc.tree;

import irc.tree.Comparator;
import irc.tree.GroupItem;
import irc.tree.TreeTraversalListener;
import java.util.Enumeration;

class TreeNode {
    public TreeNode left;
    public TreeNode right;
    public GroupItem item;
    private Comparator _comparator;

    public TreeNode(GroupItem groupItem, Comparator comparator) {
        this._comparator = comparator;
        this.item = groupItem;
        this.left = new TreeNode(comparator);
        this.right = new TreeNode(comparator);
    }

    public TreeNode(Comparator comparator) {
        this._comparator = comparator;
        this.item = null;
        this.left = null;
        this.right = null;
    }

    public boolean external() {
        return this.left == null || this.right == null;
    }

    public TreeNode remove(Object object) throws Exception {
        if (this.external()) {
            throw new Exception();
        }
        int n = this._comparator.compare(object, this.item.getFirstItem());
        if (n == 0) {
            this.item.remove(object);
            if (this.item.size() == 0) {
                if (this.left.external()) {
                    return this.right;
                }
                if (this.right.external()) {
                    return this.left;
                }
                return this.right.addTree(this.left);
            }
            return this;
        }
        if (n < 0) {
            this.left = this.left.remove(object);
            return this;
        }
        this.right = this.right.remove(object);
        return this;
    }

    private TreeNode addTree(TreeNode treeNode) throws Exception {
        if (this.external()) {
            return treeNode;
        }
        int n = this._comparator.compare(treeNode.item.getFirstItem(), this.item.getFirstItem());
        if (n == 0) {
            throw new Exception();
        }
        if (n < 0) {
            this.left = this.left.addTree(treeNode);
            return this;
        }
        this.right = this.right.addTree(treeNode);
        return this;
    }

    public TreeNode add(Object object) throws Exception {
        if (this.external()) {
            return new TreeNode(new GroupItem(object), this._comparator);
        }
        int n = this._comparator.compare(object, this.item.getFirstItem());
        if (n == 0) {
            this.item.add(object);
            return this;
        }
        if (n < 0) {
            this.left = this.left.add(object);
            return this;
        }
        this.right = this.right.add(object);
        return this;
    }

    public void inorder(TreeTraversalListener treeTraversalListener, Object object) {
        if (this.external()) {
            return;
        }
        this.left.inorder(treeTraversalListener, object);
        Enumeration enumeration = this.item.elements();
        while (enumeration.hasMoreElements()) {
            treeTraversalListener.nextItem(enumeration.nextElement(), object);
        }
        this.right.inorder(treeTraversalListener, object);
    }
}

