/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.Interpretor;
import irc.NotEnoughParametersException;
import irc.Server;
import irc.Source;
import irc.StringParser;
import java.util.Locale;

public abstract class RootInterpretor
extends IRCObject
implements Interpretor {
    protected StringParser _parser;
    protected Interpretor _next;

    public RootInterpretor(IRCConfiguration iRCConfiguration) {
        this(iRCConfiguration, null);
    }

    public RootInterpretor(IRCConfiguration iRCConfiguration, Interpretor interpretor) {
        super(iRCConfiguration);
        this.setNextInterpretor(interpretor);
        this._parser = new StringParser();
    }

    public void setNextInterpretor(Interpretor interpretor) {
        this._next = interpretor;
    }

    public Interpretor getNextInterpretor() {
        return this._next;
    }

    public boolean isInside(Interpretor interpretor) {
        while (interpretor != null) {
            if (interpretor == this) {
                return true;
            }
            interpretor = interpretor.getNextInterpretor();
        }
        return false;
    }

    public void addLast(Interpretor interpretor) {
        if (this.isInside(interpretor)) {
            return;
        }
        Interpretor interpretor2 = this;
        while (interpretor2.getNextInterpretor() != null) {
            interpretor2 = interpretor2.getNextInterpretor();
        }
        interpretor2.setNextInterpretor(interpretor);
    }

    protected void test(String string, String[] stringArray, int n) throws NotEnoughParametersException {
        if (stringArray.length <= n) {
            throw new NotEnoughParametersException(string);
        }
    }

    protected void handleCommand(Source source, String string, String[] stringArray, String[] stringArray2) {
        if (this._next == null) {
            Server server = source.getServer();
            if (server.isConnected()) {
                server.execute(stringArray2[0]);
            } else {
                source.report(this.getText(1285));
            }
        } else {
            this._next.sendString(source, "/" + stringArray2[0]);
        }
    }

    public void sendString(Source source, String string) {
        if (string.length() == 0) {
            return;
        }
        if (string.startsWith("/")) {
            int n;
            string = string.substring(1);
            String[] stringArray = this._parser.parseString(string);
            String[] stringArray2 = new String[stringArray.length];
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray2[n] = "";
                for (int i = n; i < stringArray.length; ++i) {
                    int n2 = n;
                    stringArray2[n2] = stringArray2[n2] + stringArray[i] + " ";
                }
                stringArray2[n] = StringParser.trim(stringArray2[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].startsWith("\"") && stringArray[n].endsWith("\"")) {
                    stringArray[n] = stringArray[n].substring(1, stringArray[n].length() - 1);
                    continue;
                }
                if (!stringArray[n].startsWith("'") || !stringArray[n].endsWith("'")) continue;
                stringArray[n] = stringArray[n].substring(1, stringArray[n].length() - 1);
            }
            String string2 = stringArray[0];
            this.handleCommand(source, string2.toLowerCase(Locale.ENGLISH), stringArray, stringArray2);
        } else {
            this.say(source, string);
        }
    }

    protected void say(Source source, String string) {
        Server server = source.getServer();
        if (source.talkable()) {
            source.messageReceived(server.getNick(), string);
            server.say(source.getName(), string);
        } else {
            source.report(this.getText(1));
        }
    }
}

