/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.AWTImageLoader;
import irc.CTCPInterpretor;
import irc.ConfigurationLoader;
import irc.DefaultInterpretor;
import irc.DefaultSource;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.IRCServer;
import irc.Interpretor;
import irc.LocalFileHandler;
import irc.NullSoundHandler;
import irc.NullURLHandler;
import irc.ParameterProvider;
import irc.PluginManager;
import irc.Server;
import irc.ServerListener;
import irc.ServerManager;
import irc.Source;
import irc.StartupConfiguration;
import irc.StreamParameterProvider;
import irc.gui.GUISource;
import irc.gui.IRCInterface;
import irc.gui.IRCInterfaceListener;
import irc.ident.IdentListener;
import irc.ident.IdentWrapper;
import irc.plugin.Plugin;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IRCApplication
extends IRCObject
implements ServerListener,
ServerManager,
IdentListener,
IRCInterfaceListener,
WindowListener,
ActionListener,
PluginManager {
    private DefaultSource _defaultSource;
    private Interpretor _inter;
    private IdentWrapper _ident;
    private StartupConfiguration _start;
    private IRCInterface _interface;
    private Vector _plugins;
    private Hashtable _pluginsTable;
    private Frame _frame;
    private Container _container;
    private Hashtable _servers;
    private Object _nickLock = new Object();

    public IRCApplication(IRCConfiguration iRCConfiguration, StartupConfiguration startupConfiguration, Container container) {
        super(iRCConfiguration);
        Object object;
        this._container = container;
        this._start = startupConfiguration;
        this._plugins = new Vector();
        this._pluginsTable = new Hashtable();
        String string = iRCConfiguration.getS("gui");
        try {
            object = Class.forName("irc.gui." + string + ".Interface");
            Constructor<?> constructor = ((Class)object).getDeclaredConstructor(iRCConfiguration.getClass());
            this._interface = (IRCInterface)constructor.newInstance(iRCConfiguration);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            throw new Error("Unable to load interface " + string + " : " + invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new Error("Unable to load interface " + string + " : " + throwable);
        }
        this._servers = new Hashtable();
        this._defaultSource = new DefaultSource(this._ircConfiguration);
        object = new DefaultInterpretor(this._ircConfiguration, this._start, this, this);
        this._defaultSource.setInterpretor((Interpretor)object);
    }

    public synchronized void init() {
        this.loadPlugin(this._interface);
        String[] stringArray = this._start.getPlugins();
        for (int i = 0; i < stringArray.length; ++i) {
            this.loadPlugin(stringArray[i]);
        }
        this._interface.addIRCInterfaceListener(this);
        if (this._container == null) {
            this._frame = new Frame();
            this._frame.addWindowListener(this);
            if (this._interface.getComponent() != null) {
                this._frame.add(this._interface.getComponent());
            }
            this._frame.setFont(new Font("", 0, 12));
            ((Component)this._frame).setSize(640, 400);
            this._frame.show();
        } else {
            this._frame = null;
            this._container.removeAll();
            this._container.setLayout(new GridLayout(1, 1));
            if (this._interface.getComponent() != null) {
                this._container.add(this._interface.getComponent());
            }
        }
        this._inter = new CTCPInterpretor(this._ircConfiguration, this._defaultSource.getInterpretor(), this);
        this._inter.addLast(this._interface.getInterpretor());
        if (this._ircConfiguration.getB("useidentserver")) {
            try {
                this._ident = new IdentWrapper(this._ircConfiguration);
                Exception exception = this._ident.start(this._start.getName(), this);
                if (exception != null) {
                    this._defaultSource.report("\u00036*** " + this.getText(513, exception.getMessage()));
                }
            }
            catch (Throwable throwable) {}
        } else {
            this._ident = null;
        }
        IRCServer iRCServer = new IRCServer(this._ircConfiguration, this, this._start.getNick(), this._start.getAltNick(), this._start.getName(), this._start.getAlias());
        iRCServer.setServers(this._start.getHost(), this._start.getPort(), this._start.getPass());
        this.newServer(iRCServer, this._ircConfiguration.getB("autoconnection"));
        this.requestSourceFocus();
    }

    public IRCInterface getIRCInterface() {
        return this._interface;
    }

    public void newServer(Server server, boolean bl) {
        server.addServerListener(this);
        this._servers.put(server, server);
        Enumeration enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            plugin.serverCreated(server);
        }
        server.enumerateSourcesAsCreated(this);
        if (bl) {
            server.connect();
        }
    }

    public synchronized void uninit() {
        Enumeration enumeration = this._servers.keys();
        while (enumeration.hasMoreElements()) {
            Server server = (Server)enumeration.nextElement();
            server.leave();
        }
        if (this._ident != null) {
            this._ident.stop();
        }
        this._interface.removeIRCInterfaceListener(this);
        if (this._frame != null) {
            this._frame.removeWindowListener(this);
        }
        this._frame = null;
        while (this._plugins.size() > 0) {
            this.unloadPlugin((Plugin)this._plugins.elementAt(this._plugins.size() - 1));
        }
        this._pluginsTable = new Hashtable();
        EventDispatcher.clearCache();
    }

    public boolean loadPlugin(String string) {
        Plugin plugin;
        if (this._pluginsTable.get(string) != null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("irc.plugin." + string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(this._ircConfiguration.getClass());
            plugin = (Plugin)constructor.newInstance(this._ircConfiguration);
            this.loadPlugin(plugin);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        this._pluginsTable.put(string, plugin);
        return true;
    }

    public boolean unloadPlugin(String string) {
        Plugin plugin = (Plugin)this._pluginsTable.get(string);
        if (plugin == null) {
            return false;
        }
        this._pluginsTable.remove(string);
        this.unloadPlugin(plugin);
        return true;
    }

    private void loadPlugin(Plugin plugin) {
        plugin.setIRCApplication(this);
        plugin.load();
        this._plugins.insertElementAt(plugin, this._plugins.size());
        plugin.sourceCreated(this._defaultSource, Boolean.TRUE);
        Enumeration enumeration = this._servers.keys();
        while (enumeration.hasMoreElements()) {
            Server server = (Server)enumeration.nextElement();
            plugin.serverCreated(server);
            class AddHandler
            implements ServerListener {
                private Plugin _plugin;

                public AddHandler(Plugin plugin) {
                    this._plugin = plugin;
                }

                public void serverConnected(Server server) {
                }

                public void serverDisconnected(Server server) {
                }

                public void serverLeft(Server server) {
                }

                public String[] cannotUseRequestedNicknames(Server server) {
                    return null;
                }

                public void sourceCreated(Source source, Server server, Boolean bl) {
                    this._plugin.sourceCreated(source, bl);
                }

                public void sourceRemoved(Source source, Server server) {
                }

                public Object specialServerRequest(String string, Server server, Object[] objectArray) {
                    return null;
                }
            }
            server.enumerateSourcesAsCreated(new AddHandler(plugin));
        }
    }

    private void unloadPlugin(Plugin plugin) {
        for (int i = 0; i < this._plugins.size(); ++i) {
            if (this._plugins.elementAt(i) != plugin) continue;
            this._plugins.removeElementAt(i);
            Enumeration enumeration = this._servers.keys();
            while (enumeration.hasMoreElements()) {
                Server server = (Server)enumeration.nextElement();
                class RemoveHandler
                implements ServerListener {
                    private Plugin _plugin;

                    public RemoveHandler(Plugin plugin) {
                        this._plugin = plugin;
                    }

                    public void serverConnected(Server server) {
                    }

                    public void serverDisconnected(Server server) {
                    }

                    public void serverLeft(Server server) {
                    }

                    public String[] cannotUseRequestedNicknames(Server server) {
                        return null;
                    }

                    public void sourceCreated(Source source, Server server, Boolean bl) {
                    }

                    public void sourceRemoved(Source source, Server server) {
                        this._plugin.sourceRemoved(source);
                    }

                    public Object specialServerRequest(String string, Server server, Object[] objectArray) {
                        return null;
                    }
                }
                server.enumerateSourcesAsRemoved(new RemoveHandler(plugin));
                plugin.serverRemoved(server);
            }
            plugin.sourceRemoved(this._defaultSource);
            plugin.unload();
            return;
        }
    }

    public void sourceCreated(Source source, Server server, Boolean bl) {
        source.getInterpretor().addLast(this._inter);
        Enumeration enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            plugin.sourceCreated(source, bl);
        }
    }

    public void sourceRemoved(Source source, Server server) {
        Enumeration enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            plugin.sourceRemoved(source);
        }
    }

    public void serverLeft(Server server) {
        Enumeration enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            plugin.serverRemoved(server);
        }
        this._servers.remove(server);
        server.removeServerListener(this);
    }

    public Object specialServerRequest(String string, Server server, Object[] objectArray) {
        if (string.equals("DCCFileRequest")) {
            File file = this._ircConfiguration.getSecurityProvider().getSaveFile(objectArray[1].toString(), this.getText(769) + " [" + objectArray[1] + "]");
            return file;
        }
        if (string.equals("DCCChatRequest")) {
            return new Boolean(true);
        }
        System.err.println("Unknown request : " + string);
        System.err.println("Please submit bug report at plouf@pjirc.com with following information :");
        Thread.dumpStack();
        return null;
    }

    public void serverConnected(Server server) {
        Object object;
        for (int i = 0; i < this._start.getCommands().length; ++i) {
            object = this._start.getCommands()[i];
            if (((String)object).startsWith("/") && server instanceof IRCServer) {
                ((IRCServer)server).getStatus().sendString(this._start.getCommands()[i]);
                continue;
            }
            server.execute(this._start.getCommands()[i]);
        }
        Enumeration enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            object = (Plugin)enumeration.nextElement();
            ((Plugin)object).serverConnected(server);
        }
    }

    public void serverDisconnected(Server server) {
        Enumeration enumeration = this._plugins.elements();
        while (enumeration.hasMoreElements()) {
            Plugin plugin = (Plugin)enumeration.nextElement();
            plugin.serverDisconnected(server);
        }
    }

    public void identRequested(String string, Integer n, String string2) {
        this._defaultSource.report("\u00036*** " + this.getText(514, string));
        String string3 = "";
        switch (n) {
            case -1: {
                string3 = this.getText(515);
                break;
            }
            case 0: {
                string3 = this.getText(516, string2);
                break;
            }
            case 1: {
                string3 = this.getText(516, this.getText(517) + " : " + string2);
                break;
            }
            case 2: {
                string3 = this.getText(518);
                break;
            }
            default: {
                string3 = this.getText(523);
            }
        }
        this._defaultSource.report("\u00036*** " + string3);
    }

    public void identRunning(Integer n) {
        this._defaultSource.report("\u00036*** " + this.getText(519, n + ""));
    }

    public void identLeaving(String string) {
        this._defaultSource.report("\u00036*** " + this.getText(520, string));
    }

    public void activeChanged(GUISource gUISource, IRCInterface iRCInterface) {
        if (gUISource != null) {
            if (gUISource.getSource().mayDefault()) {
                gUISource.getSource().getServer().setDefaultSource(gUISource.getSource());
            }
            if (this._frame != null) {
                this._frame.setTitle(gUISource.getTitle());
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this._frame) {
            EventDispatcher.dispatchEventAsync(this, "uninit", new Object[0]);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Frame)windowEvent.getSource()).hide();
        ((Frame)windowEvent.getSource()).dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private GUISource getActiveSource() {
        return this._interface.getActive();
    }

    public void requestSourceFocus() {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.requestFocus();
    }

    public void sendString(String string) {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.getSource().sendString(string);
    }

    public void setFieldText(String string) {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.setFieldText(string);
    }

    public String getFieldText() {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return "";
        }
        return gUISource.getFieldText();
    }

    public void validateText() {
        GUISource gUISource = this.getActiveSource();
        if (gUISource == null) {
            return;
        }
        gUISource.validateText();
    }

    public void sendPluginEvent(String string, Object object) {
        Plugin plugin = (Plugin)this._pluginsTable.get(string);
        if (plugin == null) {
            return;
        }
        plugin.externalEvent(object);
    }

    public Object getPluginValue(String string, Object object) {
        Plugin plugin = (Plugin)this._pluginsTable.get(string);
        if (plugin == null) {
            return null;
        }
        return plugin.getValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] cannotUseRequestedNicknames(Server server) {
        Object object = this._nickLock;
        synchronized (object) {
            if (this._interface.getComponent() != null) {
                this._interface.getComponent().setEnabled(false);
            }
            if (this._frame != null) {
                this._frame.setEnabled(false);
            }
            Frame frame = new Frame();
            frame.setLayout(new FlowLayout());
            ((Component)frame).setSize(200, 65);
            frame.setTitle(this.getText(1818));
            TextField textField = new TextField(this._start.getNick());
            Button button = new Button("Ok");
            button.addActionListener(this);
            frame.add(textField);
            frame.add(button);
            frame.show();
            try {
                this._nickLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            frame.hide();
            frame.remove(button);
            frame.remove(textField);
            frame.dispose();
            String[] stringArray = new String[]{textField.getText()};
            if (this._frame != null) {
                this._frame.setEnabled(true);
            }
            if (this._interface.getComponent() != null) {
                this._interface.getComponent().setEnabled(true);
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this._nickLock;
        synchronized (object) {
            this._nickLock.notifyAll();
        }
    }

    private static void usage() {
        System.out.println("Usage :");
        System.out.println("   java irc.IRCApplication -f configfile");
        System.out.println("or java irc.IRCApplication -p nick fullname host gui");
        System.out.println("");
        System.out.println("Without any parameter, '-f pjirc.cfg' parameters are assumed.");
    }

    public static void go(String[] stringArray) {
        LocalFileHandler localFileHandler = new LocalFileHandler();
        try {
            StartupConfiguration startupConfiguration;
            IRCConfiguration iRCConfiguration;
            Object object;
            if (stringArray.length == 0 || stringArray.length >= 2 && stringArray[0].equals("-f")) {
                object = "pjirc.cfg";
                if (stringArray.length >= 2) {
                    object = stringArray[1];
                }
                StreamParameterProvider streamParameterProvider = new StreamParameterProvider(localFileHandler.getInputStream((String)object));
                ConfigurationLoader configurationLoader = new ConfigurationLoader(streamParameterProvider, new NullURLHandler(), new AWTImageLoader(), new NullSoundHandler(), localFileHandler);
                iRCConfiguration = configurationLoader.loadIRCConfiguration();
                startupConfiguration = configurationLoader.loadStartupConfiguration();
            } else if (stringArray.length >= 5 && stringArray[0].equals("-p")) {
                object = new StreamParameterProvider(null);
                ConfigurationLoader configurationLoader = new ConfigurationLoader((ParameterProvider)object, new NullURLHandler(), new AWTImageLoader(), new NullSoundHandler(), localFileHandler);
                iRCConfiguration = configurationLoader.loadIRCConfiguration();
                iRCConfiguration.set("gui", stringArray[4]);
                startupConfiguration = new StartupConfiguration(stringArray[1], "", stringArray[2], new String[]{""}, new String[]{stringArray[3]}, new int[]{6667}, "", new String[0], new String[0]);
            } else {
                IRCApplication.usage();
                return;
            }
            object = new IRCApplication(iRCConfiguration, startupConfiguration, null);
            EventDispatcher.dispatchEventAsyncAndWaitEx(object, "init", new Object[0]);
        }
        catch (Throwable throwable) {
            System.out.println("Error : " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        IRCApplication.go(stringArray);
    }
}

