/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

class LimitedArray {
    private int _size = 0;
    private int _maximum;
    private int _missing = 0;
    private Object[] _array;

    public LimitedArray(int n) {
        this._maximum = n;
        this._array = new Object[4];
    }

    public void expand() {
        if (this._array.length >= this._maximum) {
            return;
        }
        int n = this._array.length << 1;
        Object[] objectArray = new Object[n];
        System.arraycopy(this._array, 0, objectArray, 0, this._array.length);
        this._array = objectArray;
    }

    public void add(Object object) {
        if (this.size() >= this._array.length) {
            this.expand();
        }
        if (this.size() >= this._array.length) {
            ++this._missing;
        }
        this._array[this.size() % this._array.length] = object;
        ++this._size;
    }

    public Object get(int n) {
        if (n < this._missing) {
            return null;
        }
        return this._array[n % this._array.length];
    }

    public int size() {
        return this._size;
    }
}

