CREATE TABLE ne_admin_menu (
  menu_id int(12) NOT NULL default '0',
  text char(64) NOT NULL default '',
  module char(64) NOT NULL default '',
  op char(64) NOT NULL default '',
  weight int(3) NOT NULL default '0',
  PRIMARY KEY  (menu_id)
) TYPE=MyISAM;

INSERT INTO ne_admin_menu (menu_id, text, module, op, weight) VALUES (1, 'show modules', 'module-admin', 'admin_modules', 0);
INSERT INTO ne_admin_menu (menu_id, text, module, op, weight) VALUES (3, 'install new module', 'module-admin', 'install', 2);
INSERT INTO ne_admin_menu (menu_id, text, module, op, weight) VALUES (15, 'Admin Blocks', 'blocks', 'admin_blocks', 0);
INSERT INTO ne_admin_menu (menu_id, text, module, op, weight) VALUES (16, 'Add Block', 'blocks', 'add_blocks', 0);


CREATE TABLE ne_admin_permissons (
  user_id int(12) NOT NULL default '0',
  module_name char(80) NOT NULL default '',
  PRIMARY KEY  (user_id,module_name)
) TYPE=MyISAM;

CREATE TABLE ne_blocks (
  block_id int(12) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  weight int(3) NOT NULL default '0',
  language char(2) default NULL,
  visible int(1) NOT NULL default '0',
  active int(1) NOT NULL default '0',
  position int(1) NOT NULL default '0',
  module varchar(255) NOT NULL default 'ALL',
  block_type int(1) NOT NULL default '0',
  url varchar(255) default NULL,
  blockfile varchar(32) default NULL,
  content text,
  PRIMARY KEY  (block_id)
) TYPE=MyISAM;


CREATE TABLE ne_modules (
  module_id int(4) NOT NULL default '0',
  name char(25) NOT NULL default '',
  visible tinyint(2) NOT NULL default '0',
  active tinyint(1) NOT NULL default '0',
  title char(64) NOT NULL default '',
  PRIMARY KEY  (module_id),
  UNIQUE KEY name (name)
) TYPE=MyISAM;

INSERT INTO ne_modules (module_id, name, visible, active, title) VALUES (1, 'module-admin', 0, 1, 'Modules Admin');
INSERT INTO ne_modules (module_id, name, visible, active, title) VALUES (6, 'blocks', 2, 1, 'Blocks');

CREATE TABLE ne_users (
  uid int(10) NOT NULL default '0',
  username char(64) default NULL,
  admin int(1) NOT NULL default '0',
  superuser int(1) NOT NULL default '0',
  email char(255) NOT NULL default '',
  theme char(64) NOT NULL default '',
  lang char(2) NOT NULL default '',
  points int(16) NOT NULL default '0',
  password char(80) NOT NULL default '',
  last_login timestamp(14) NOT NULL,
  cookie char(255) NOT NULL default '',
  session char(255) NOT NULL default '',
  ip char(15) NOT NULL default '',
  PRIMARY KEY  (uid),
  UNIQUE KEY name (username)
) TYPE=MyISAM;

#
# Dumping data for table `ne_users`
#

INSERT INTO ne_users (uid, username, admin, superuser, email, theme, lang, points, password, last_login, cookie, session, ip) VALUES (1, 'admin', 1, 1, 'admin@example.com', '', 'de', 0, '21232f297a57a5a743894a0e4a801fc3', 20031111112811, '', 'ad29f8e43ee7aea7b633a72c21f64dfa', '127.0.0.1');