<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Online Help for NukeEvent 
*
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/

/**
* The Index Site that starts the Module you want.
*
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/

/**
* include the main functions file
*/
require_once('includes/mainfile.inc.php');
$neModuleLoader = "help.php";
$neTheme->setTemplate('help.tpl');// or die(_('the template help.tpl could not be found'));
//get the module
if( isset($_POST['mod'])) {
    $strModule = $_POST['mod'];
} else {
    $strModule = $_GET['mod'];
}

if( isset($_POST['file']) and !empty($_POST['file'])) {
    $strFile = $_POST['file'];
} else {
    $strFile = $_GET['file'];
}

if ( preg_match("/(\.|\/)/",$strModule) ){
    $neTheme->drawErrorpage(
    neTranslate('title-access_denied'),
    neTranslate('message-access_denied')
    );
    neDrawSite();
    die();
} elseif ( preg_match("/(\.|\/)/",$strFile) ){
    $neTheme->drawErrorpage(
    neTranslate('title-access_denied'),
    neTranslate('message-access_denied')
    );
    neDrawSite();
    die();
}

//Display an Error if the File does not exist
$strHelpFile= 'modules/'.$strModule.'/help/'.$neSession->getLang().'/'.$strFile.'.html';
if ( file_exists('modules/'.$strModule.'/help/'.$neSession->getLang().'/'.$strFile.'.html') ) {
    readfile('modules/'.$strModule.'/help/'.$neSession->getLang().'/'.$strFile.'.html');
    $neTheme->drawSite();
} elseif (file_exists('modules/'.$strModule.'/help/'.$neConfig['default']['lang'].'/'.$strFile.'.html')) {
    echo 'default file_exists';
} else {
    $neTheme->drawErrorpage(
    neTranslate('title-no_help_avaible'),
    neTranslate('message-no_help_avaible')
    );
}
//Display the Standard Layout if there is no module specified;
?>
