<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* A Module that allows comments in other Modules.
*
* @package nukeevent.modules.comments
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/
/**
* load the Config File for the comments Module
*/
include_once('modules/comments/config.inc.php');

/* Load the Language File for the Comments Module */
neGetLang('comments');

/**
*/
function showReplys($commentId,$tableName,$tpl)
{
	global $neDb;
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$tableName.' ';
    $strQuery .= 'WHERE reply_to='.$neDb->quote($commentId);
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    if ($result->numRows() > 0) {
        while($result->fetchInto($comment,DB_FETCHMODE_ASSOC)) {
            $tpl->setVariable( array(
            'REPLY_TITLE'  => $comment['comment_title'],
            'REPLY_AUTHOR' => $comment['comment_author'],
            'REPLY_DATE' => neFormatTimestamp($comment['comment_date'],'date'),
            'REPLY_TEXT' => $comment['comment_text']
            ));
        }
        //showReplys($comment['comment_id'],$tableName,$tpl);
    }            
}        

/**
*/
function showComments($tableName,$threadId,$redirectUrl)
{
    global $neModuleName, $neTheme ,$neConfig, $neDb, $neSession;
    $tpl = $neTheme->getTemplate('comments','comments.tpl');
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$tableName.' ';
    $strQuery .= 'WHERE  thread_id='.$neDb->quote($threadId).' ';
    $strQuery .= 'AND comment_reply=0';
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    if ($result->numRows() > 0) {   
        while($comment = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
            $tpl->setCurrentBlock('comment');
            $date = neFormatTimestamp($comment['comment_date'],'date');
            $tpl->setVariable( array(
            'COMMENT_ID'  => $comment['comment_id'],
            'COMMENT_TITLE'  => $comment['comment_title'],
            'COMMENT_AUTHOR' => $neTheme->getUserinfo($comment['comment_poster']),
            'COMMENT_DATE' => $date,
            'COMMENT_TEXT' => neEncodeUbb($comment['comment_text'])
            ));
            //showReplys($comment['comment_id'],$tableName,$tpl);
            $tpl->parse('comment');
        }
    }
    if ($neConfig['comments']['quickcomment']) {
        $tpl->setCurrentBlock('write_comment');
        $tpl->setVariable( array(
            'REDIRECT_URL'  => $redirectUrl,
            'THREAD_ID'  => $threadId,
            'TABLE_NAME'  => $tableName,
            'AUTHOR' => $neSession->getId(),
            'COMMENT_TEXTBOX' => $neTheme->getUbbBox('comment[text]','',3,50),
            'LABEL_TITLE' => neTranslate('title'),
            'LABEL_WRITE_COMMENT' => neTranslate('write_comment'),
            'LABEL_TEXT' => neTranslate('comment'),
            'LABEL_ADD_COMMENT' => neTranslate('add_comment')
        ));
        $tpl->touchBlock('write_comment');
    }
            
    return $tpl->get();
}

/**
* Adds the Comment to the Database
*/
function submitComment($arrFormdata,$strRedirectUrl){
	global $neDbWrite;
	list($usec, $sec) = explode(" ",microtime()); 
    $microtime = ((float)$usec + (float)$sec);
	$commentId = $neDbWrite->quote($microtime);
	$threadId  = $neDbWrite->quote(intval($arrFormdata['thread_id']));
	$author    = $neDbWrite->quote(intval($arrFormdata['author']));
	$date = $neDbWrite->quote(time());
	$title = $neDbWrite->quote(neChecktext($arrFormdata['title'],'plain'));
	$text = $neDbWrite->quote(neChecktext($arrFormdata['text'],'ubb'));
    $reply  = $neDbWrite->quote(intval($arrFormdata['reply']));

    $strQuery  = 'INSERT INTO  `'.$arrFormdata['table_name'].'`';
    $strQuery .= '(comment_id, thread_id, comment_poster, comment_date, ';
    $strQuery .= 'comment_title, comment_text, comment_reply) ';
    $strQuery .= "VALUES ($commentId, $threadId, $author, NOW(), $title, $text, ";
	$strQuery .= "$reply)";
	$result = $neDbWrite->query($strQuery);
	neGetDbError($result,__LINE__,__FILE__,$strQuery);
	neRedirect($strRedirectUrl);
}
?>